/*
 * Decompiled with CFR 0.152.
 */
package com.kuaike.scrm.groupsend.service.impl;

import cn.kinyun.link.common_dto.dto.BaseResponse;
import cn.kinyun.link.common_dto.dto.ResponseCodeType;
import cn.kinyun.link.common_dto.enums.LinkOpType;
import cn.kinyun.link.common_dto.enums.OpPlatform;
import cn.kinyun.link.service.ConversationService;
import cn.kinyun.link.service.MessageService;
import cn.kinyun.link.service.push.request.BaseSendReq;
import cn.kinyun.link.service.push.request.BatchPushMessageReq;
import com.alibaba.fastjson.JSON;
import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.kuaike.common.errorcode.CommonErrorCode;
import com.kuaike.common.errorcode.UniverseErrorCode;
import com.kuaike.common.exception.BusinessException;
import com.kuaike.common.utils.DateUtil;
import com.kuaike.scrm.common.dto.CurrentUserInfo;
import com.kuaike.scrm.common.dto.jsMsg.UniformMsgDto;
import com.kuaike.scrm.common.enums.JsMsgType;
import com.kuaike.scrm.common.enums.ReceiveType;
import com.kuaike.scrm.common.enums.SendStatus;
import com.kuaike.scrm.common.enums.TaskStatus;
import com.kuaike.scrm.common.service.SettingService;
import com.kuaike.scrm.common.utils.LoginUtils;
import com.kuaike.scrm.dal.groupsend.entity.MessageGroupSendDetail;
import com.kuaike.scrm.dal.groupsend.entity.MessageGroupSendTask;
import com.kuaike.scrm.dal.groupsend.entity.MessageGroupSendTaskCriteria;
import com.kuaike.scrm.dal.groupsend.mapper.MessageGroupSendDetailMapper;
import com.kuaike.scrm.dal.groupsend.mapper.MessageGroupSendTaskMapper;
import com.kuaike.scrm.dal.wework.dto.SendDetailDto;
import com.kuaike.scrm.dal.wework.entity.WeworkUser;
import com.kuaike.scrm.dal.wework.mapper.WeworkChatRoomRelationMapper;
import com.kuaike.scrm.dal.wework.mapper.WeworkUserMapper;
import com.kuaike.scrm.groupsend.dto.SendMessageDto;
import com.kuaike.scrm.groupsend.dto.SendRetryReqDto;
import com.kuaike.scrm.groupsend.dto.response.GroupSendRequestDto;
import com.kuaike.scrm.groupsend.service.GroupSendStatusService;
import com.kuaike.scrm.groupsend.service.GroupSendVipExecuteService;
import com.kuaike.scrm.utils.exec.AbstractTaskJob;
import com.kuaike.scrm.utils.exec.ITaskRunnable;
import com.kuaike.scrm.utils.exec.TaskJob;
import com.kuaike.scrm.utils.exec.TaskJobExecutor;
import com.kuaike.scrm.utils.exec.TaskJobRun;
import com.kuaike.scrm.utils.exec.TaskJobType;
import com.kuaike.scrm.vip.dto.enums.MessageSendRetryType;
import com.kuaike.scrm.vip.dto.enums.SystemParamName;
import com.kuaike.scrm.vip.service.WeworkOperateService;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.stereotype.Service;

@Service
public class GroupSendVipExecuteServiceImpl
implements GroupSendVipExecuteService {
    private static final Logger log = LoggerFactory.getLogger(GroupSendVipExecuteServiceImpl.class);
    @Qualifier(value="stringRedisTemplate")
    @Autowired
    private RedisTemplate redisTemplate;
    @Autowired
    private String getGroupSendTaskKey;
    @Autowired
    private GroupSendStatusService groupSendStatusService;
    @Autowired
    private MessageGroupSendTaskMapper groupSendTaskMapper;
    @Autowired
    private MessageGroupSendDetailMapper groupSendDetailMapper;
    @Autowired
    private WeworkOperateService weworkOperateService;
    @Autowired
    private MessageService messageService;
    @Autowired
    private ConversationService conversationService;
    @Autowired
    private WeworkChatRoomRelationMapper weworkChatRoomRelationMapper;
    @Autowired
    private WeworkUserMapper weworkUserMapper;
    @Autowired
    private SettingService settingService;
    private static final String NOT_MANAGER_FAIL_REMARK = "\u65e0\u7ba1\u7406\u4f01\u5fae\u53f7\u5728\u8be5\u7fa4\u4e2d";
    private static final String NOT_IN_CHATROOM_REMARK = "\u4e0d\u5728\u7fa4\u5185";
    private static final String BLACK_LIST_FAIL_REMARK = "\u8054\u7cfb\u4eba\u5728\u7cfb\u7edf\u9ed1\u540d\u5355\u4e2d\uff0c\u53d6\u6d88\u53d1\u9001";
    private static final String ZOMBIE_FANS_FAIL_REMARK = "\u8054\u7cfb\u4eba\u662f\u50f5\u5c38\u7c89\uff0c\u53d6\u6d88\u53d1\u9001";
    private static final String NOT_FRIEND_REMARK = "\u8054\u7cfb\u4eba\u975e\u597d\u53cb\uff0c\u53d6\u6d88\u53d1\u9001";
    private static final String EXCEED_LIMIT_FAIL_REMARK = "\u8d85\u51fa\u6bcf\u5929\u7fa4\u53d1\u6d88\u606f\u9650\u989d";
    private static final String NOT_ONLINE_FAIL_REMARK = "\u4f01\u5fae\u4e0d\u5728\u7ebf";
    private static final String NO_MANAGE_WEWORK_IN_CHATROOM = "\u65e0\u7ed1\u5b9a\u6216\u7ba1\u7406\u7684\u4f01\u5fae\u53f7\u5728\u7fa4\u4e2d";
    private static final String EXCEED_DEADLINE = "\u8d85\u8fc7\u7ec8\u6b62\u53d1\u9001\u65f6\u95f4,\u505c\u6b62\u53d1\u9001";
    private static final Set<Integer> tobeSendStatusSet = Sets.newHashSet((Object[])new Integer[]{SendStatus.TO_BE_SEND.getValue(), SendStatus.TO_BE_QUERY.getValue()});

    @Override
    public void executeSendTaskWithTime() {
        log.info("executeSendTaskWithTime start");
        List weworkIds = this.groupSendDetailMapper.queryNeedSendWeworkIds();
        if (CollectionUtils.isEmpty((Collection)weworkIds)) {
            log.info("\u6ca1\u6709\u8981\u7fa4\u53d1\u7684\u4f01\u5fae\u53f7");
            return;
        }
        List<Object> groupSendDetailList = Lists.newArrayList();
        List partitionList = Lists.partition((List)weworkIds, (int)3);
        for (List subList : partitionList) {
            List temResult = this.groupSendDetailMapper.queryWeworkNeedSendDetail(subList);
            groupSendDetailList.addAll(temResult);
        }
        if (CollectionUtils.isEmpty((Collection)groupSendDetailList)) {
            log.info("\u6ca1\u6709\u8981\u7fa4\u53d1\u7684\u6d88\u606f");
            return;
        }
        groupSendDetailList = this.exceedDeadline((List<SendDetailDto>)groupSendDetailList);
        this.updateOfflineWechatMessageSendStatus((List<? extends SendDetailDto>)groupSendDetailList);
        groupSendDetailList = this.filterOverLimit(groupSendDetailList);
        this.groupSendStatusService.updateTaskStatus(groupSendDetailList);
        if (CollectionUtils.isEmpty(groupSendDetailList)) {
            log.info("\u6ca1\u6709\u8981\u53d1\u9001\u7684\u6d88\u606f\uff0cexit");
            return;
        }
        Map<Long, String> idContentMap = this.queryContentMap(groupSendDetailList);
        this.sendMessage(groupSendDetailList, idContentMap);
        log.info("executeSendTaskWithTime end");
    }

    private Set<Long> updateOfflineWechatMessageSendStatus(List<? extends SendDetailDto> messageGroupSendDetailList) {
        if (CollectionUtils.isEmpty(messageGroupSendDetailList)) {
            return new HashSet<Long>();
        }
        Map bizId2WeworkIds = messageGroupSendDetailList.stream().collect(Collectors.groupingBy(SendDetailDto::getBizId, Collectors.mapping(MessageGroupSendDetail::getUserDigitId, Collectors.toSet())));
        HashSet offlineWechatIdSet = Sets.newHashSet();
        bizId2WeworkIds.forEach((bizId, sendWechatIdSet) -> {
            Map wechatOnlineMap = this.weworkOperateService.queryWeworkIsOnline(bizId, (List)Lists.newArrayList((Iterable)sendWechatIdSet));
            Set set = wechatOnlineMap.entrySet().stream().filter(a -> (Boolean)a.getValue() == false).map(a -> (String)a.getKey()).collect(Collectors.toSet());
            offlineWechatIdSet.addAll(set);
        });
        log.info("sendMessageTimingTask offlineWechatIds = {}", (Object)JSON.toJSONString((Object)offlineWechatIdSet));
        if (CollectionUtils.isEmpty((Collection)offlineWechatIdSet)) {
            return new HashSet<Long>();
        }
        Set<Long> offlineDetailIds = messageGroupSendDetailList.stream().filter(a -> offlineWechatIdSet.contains(a.getUserDigitId())).map(a -> a.getId()).collect(Collectors.toSet());
        this.groupSendDetailMapper.updateStatusByIds(offlineDetailIds, Integer.valueOf(SendStatus.SEND_FAIL.getValue()), NOT_ONLINE_FAIL_REMARK, null);
        log.info("sendMessageTimingTask update offline detailIds = {}", offlineDetailIds);
        if (CollectionUtils.isNotEmpty(offlineDetailIds)) {
            messageGroupSendDetailList.removeIf(e -> offlineDetailIds.contains(e.getId()));
        }
        return offlineDetailIds;
    }

    private List<SendDetailDto> filterOverLimit(List<SendDetailDto> groupSendDetailList) {
        if (CollectionUtils.isEmpty(groupSendDetailList)) {
            return Lists.newArrayList();
        }
        Date now = new Date();
        Map<Long, List<SendDetailDto>> bizId2Details = groupSendDetailList.stream().collect(Collectors.groupingBy(a -> a.getBizId()));
        HashSet overLimitDetailIds = Sets.newHashSet();
        SystemParamName paramName = SystemParamName.EVERYDAY_GROUP_SEND_WEWORK_NUM_UPPER_LIMIT;
        ReceiveType receiveType = ReceiveType.CONTACT;
        this.collectOverLimit(groupSendDetailList, now, bizId2Details, overLimitDetailIds, paramName, receiveType);
        SystemParamName paramName2 = SystemParamName.EVERYDAY_GROUP_SEND_ROOM_NUM_UPPER_LIMIT;
        ReceiveType receiveType2 = ReceiveType.CHATROOM;
        this.collectOverLimit(groupSendDetailList, now, bizId2Details, overLimitDetailIds, paramName2, receiveType2);
        if (CollectionUtils.isNotEmpty((Collection)overLimitDetailIds)) {
            ArrayList detailIds = Lists.newArrayList((Iterable)overLimitDetailIds);
            List partitions = Lists.partition((List)detailIds, (int)50);
            partitions.stream().forEach(subList -> this.groupSendDetailMapper.updateStatusByIds((Collection)subList, Integer.valueOf(SendStatus.SEND_FAIL.getValue()), EXCEED_LIMIT_FAIL_REMARK, null));
        }
        return groupSendDetailList.stream().filter(a -> !overLimitDetailIds.contains(a.getId())).collect(Collectors.toList());
    }

    private void collectOverLimit(List<SendDetailDto> groupSendDetailList, Date now, Map<Long, List<SendDetailDto>> bizId2Details, Set<Long> overLimitDetailIds, SystemParamName paramName, ReceiveType receiveType) {
        bizId2Details.forEach((bizId, details) -> {
            Integer total = this.settingService.getIntegerOrDefault(bizId, paramName.getKey(), Integer.valueOf(1000));
            Set robotIds = details.stream().map(a -> a.getUserDigitId()).collect(Collectors.toSet());
            Map robotIds2SendCount = this.groupSendDetailMapper.querySendCountToday(Integer.valueOf(receiveType.getType()), robotIds, DateUtil.getStartOfDay((Date)now), DateUtil.getEndOfDay((Date)now));
            List overLimitIds = groupSendDetailList.stream().filter(a -> {
                if (a.getReceiveType().intValue() == receiveType.getType()) {
                    Integer sendCount = robotIds2SendCount.getOrDefault(a.getUserDigitId(), 0);
                    sendCount = sendCount + 1;
                    robotIds2SendCount.put(a.getUserDigitId(), sendCount);
                    return total - sendCount < 0;
                }
                return false;
            }).map(a -> a.getId()).collect(Collectors.toList());
            if (CollectionUtils.isNotEmpty(overLimitIds)) {
                overLimitDetailIds.addAll(overLimitIds);
            }
        });
    }

    private List<SendDetailDto> exceedDeadline(List<SendDetailDto> groupSendDetailList) {
        if (CollectionUtils.isEmpty(groupSendDetailList)) {
            return groupSendDetailList;
        }
        ArrayList exceedDeadlineList = Lists.newArrayList();
        groupSendDetailList = groupSendDetailList.stream().filter(a -> {
            if (a.getDeadline() != null && a.getDeadline().getTime() <= System.currentTimeMillis()) {
                exceedDeadlineList.add(a);
                return false;
            }
            return true;
        }).collect(Collectors.toList());
        if (CollectionUtils.isNotEmpty((Collection)exceedDeadlineList)) {
            List detailIds = exceedDeadlineList.stream().map(a -> a.getId()).collect(Collectors.toList());
            List partitions = Lists.partition(detailIds, (int)50);
            partitions.stream().forEach(subList -> this.groupSendDetailMapper.updateStatusByIds((Collection)subList, Integer.valueOf(SendStatus.SEND_FAIL.getValue()), EXCEED_DEADLINE, null));
        }
        return groupSendDetailList;
    }

    private Map<Long, String> queryContentMap(List<SendDetailDto> groupSendDetailList) {
        List taskIds = groupSendDetailList.stream().map(a -> a.getTaskId()).distinct().collect(Collectors.toList());
        MessageGroupSendTaskCriteria criteria = new MessageGroupSendTaskCriteria();
        criteria.createCriteria().andIdIn(taskIds);
        List messageGroupSendTasks = this.groupSendTaskMapper.selectByExample((Object)criteria);
        return messageGroupSendTasks.stream().collect(Collectors.toMap(MessageGroupSendTask::getId, MessageGroupSendTask::getContent));
    }

    private void sendMessage(List<? extends SendDetailDto> messageGroupSendDetailList, Map<Long, String> subTaskIdContentMap) {
        log.info("sendMessage begin");
        if (CollectionUtils.isEmpty(messageGroupSendDetailList) || subTaskIdContentMap == null) {
            return;
        }
        Set detailIds = messageGroupSendDetailList.stream().map(a -> a.getId()).collect(Collectors.toSet());
        log.info("sendMessageTimingTask send message, detailIds = {}", detailIds);
        Map<String, List<SendDetailDto>> weworkId2Details = messageGroupSendDetailList.stream().collect(Collectors.groupingBy(MessageGroupSendDetail::getUserDigitId));
        List weworkUsers = this.weworkUserMapper.queryByDigitIds(weworkId2Details.keySet());
        Map<String, WeworkUser> digitId2WeworkUser = weworkUsers.stream().collect(Collectors.toMap(a -> a.getWeworkDigitId(), a -> a));
        HashMap buId2Urls = Maps.newHashMap();
        ArrayList taskJobList = Lists.newArrayList();
        for (Map.Entry<String, List<SendDetailDto>> entry : weworkId2Details.entrySet()) {
            String sendWeworkId = entry.getKey();
            List<Object> messageGroupSendDetails = entry.getValue();
            if (CollectionUtils.isEmpty(messageGroupSendDetails)) {
                log.warn("not found detail sendWeworkId:{}", (Object)sendWeworkId);
                continue;
            }
            WeworkUser weworkUser = digitId2WeworkUser.get(sendWeworkId);
            if (Objects.nonNull(weworkUser)) {
                for (SendDetailDto sendDetailDto : messageGroupSendDetails) {
                    sendDetailDto.setWeworkUserId(weworkUser.getWeworkUserId());
                }
            }
            if (CollectionUtils.isEmpty(messageGroupSendDetails = messageGroupSendDetails.stream().filter(t -> tobeSendStatusSet.contains(t.getStatus())).collect(Collectors.toList()))) {
                log.warn("not found TO_BE_SEND detail sendWeworkId:{}", (Object)sendWeworkId);
                continue;
            }
            Map<Long, List<SendDetailDto>> taskId2Details = messageGroupSendDetails.stream().collect(Collectors.groupingBy(a -> a.getTaskId()));
            for (Map.Entry<Long, List<SendDetailDto>> longListEntry : taskId2Details.entrySet()) {
                Long taskId = longListEntry.getKey();
                List<SendDetailDto> SendDetailDtos = longListEntry.getValue();
                Long bizId = SendDetailDtos.get(0).getBizId();
                ArrayList runnables = Lists.newArrayList();
                SendDetailDtos.forEach(dto -> {
                    String content = (String)subTaskIdContentMap.get(dto.getTaskId());
                    Set urls = (Set)buId2Urls.get(bizId);
                    runnables.add(new GroupSendRunnable((SendDetailDto)dto, content, urls));
                });
                ArrayList list = Lists.newArrayList();
                runnables.forEach(runnable -> list.add(new TaskJobRun((ITaskRunnable)runnable)));
                TaskJob taskJob = new TaskJob(taskId, TaskJobType.GROUPSEND, sendWeworkId, (List)list);
                taskJobList.add(taskJob);
                log.info("taskJobList add groupsend,taskId={} sendWeworkId={}, jobSize:{}", new Object[]{taskId, sendWeworkId, list.size()});
            }
        }
        if (CollectionUtils.isNotEmpty((Collection)taskJobList)) {
            for (TaskJob taskJob : taskJobList) {
                TaskJobExecutor.addTaskJob((AbstractTaskJob)taskJob);
            }
        }
    }

    private boolean checkTaskDisable(SendDetailDto SendDetailDto2) {
        String str;
        boolean ifTaskDisable = false;
        Object value = this.redisTemplate.opsForHash().get((Object)this.getGroupSendTaskKey, (Object)String.valueOf(SendDetailDto2.getTaskId()));
        if (value != null && StringUtils.isNotBlank((CharSequence)(str = (String)value))) {
            String[] arr = str.split(":");
            Date startTime = new Date(Long.valueOf(arr[0]));
            Date endTime = new Date(Long.valueOf(arr[1]));
            if (SendDetailDto2.getCreateTime().getTime() >= startTime.getTime() && SendDetailDto2.getCreateTime().getTime() <= endTime.getTime()) {
                ifTaskDisable = true;
            }
        }
        return ifTaskDisable;
    }

    private boolean checkDetailTobesend(SendDetailDto SendDetailDto2) {
        MessageGroupSendDetail detail = (MessageGroupSendDetail)this.groupSendDetailMapper.selectByPrimaryKey((Object)SendDetailDto2.getId());
        return detail != null && tobeSendStatusSet.contains(detail.getStatus()) && detail.getIsDeleted() == 0;
    }

    private void sendChatRoomMessage(SendDetailDto sendDetailDto, String content, Set<String> urls) {
        String sendWeworkId = sendDetailDto.getUserDigitId();
        String weworkUserId = sendDetailDto.getWeworkUserId();
        String receiveId = sendDetailDto.getReceiveId();
        String receiveDigitId = sendDetailDto.getReceiveDigitId();
        if (StringUtils.isBlank((CharSequence)weworkUserId)) {
            this.updateSendDetailToFinal((MessageGroupSendDetail)sendDetailDto, NOT_MANAGER_FAIL_REMARK);
            return;
        }
        Integer isDelete = this.weworkChatRoomRelationMapper.queryChatRoomStatus(sendDetailDto.getCorpId(), receiveId, weworkUserId);
        if (isDelete == null || isDelete == 1) {
            this.updateSendDetailToFinal((MessageGroupSendDetail)sendDetailDto, NOT_IN_CHATROOM_REMARK);
            return;
        }
        sendDetailDto.setStatus(Integer.valueOf(SendStatus.SENDING.getValue()));
        this.updateDetail((MessageGroupSendDetail)sendDetailDto);
        try {
            GroupSendRequestDto sendRequestDto = this.sendMultMessageReturnStatusAndMsg(sendDetailDto, sendWeworkId, receiveDigitId, content, urls);
            switch (SendStatus.getType((Integer)sendRequestDto.getStatus())) {
                case SENDING: {
                    sendDetailDto.setStatus(Integer.valueOf(SendStatus.SENDING.getValue()));
                    sendDetailDto.setRequestId(sendRequestDto.getRequestId());
                    this.updateDetail((MessageGroupSendDetail)sendDetailDto);
                    break;
                }
                case SEND_FAIL: {
                    this.updateSendDetailToFinal((MessageGroupSendDetail)sendDetailDto, sendRequestDto.getMsg());
                    break;
                }
                case TO_BE_SEND: {
                    sendDetailDto.setStatus(Integer.valueOf(SendStatus.TO_BE_SEND.getValue()));
                    sendDetailDto.setRemark(sendRequestDto.getMsg());
                    this.updateDetail((MessageGroupSendDetail)sendDetailDto);
                }
            }
        }
        catch (Exception e) {
            log.error("group send chatRoom error \u53d1\u9001\u6d88\u606f\u5931\u8d25\uff1a", (Throwable)e);
            this.updateSendDetailToFinal((MessageGroupSendDetail)sendDetailDto, this.buildErrorMsg(e));
        }
    }

    private void sendContactMessage(SendDetailDto sendDetailDto, String content, Set<String> urls) {
        sendDetailDto.setStatus(Integer.valueOf(SendStatus.SENDING.getValue()));
        this.updateDetail((MessageGroupSendDetail)sendDetailDto);
        try {
            GroupSendRequestDto sendRequestDto = this.sendMultMessageReturnStatusAndMsg(sendDetailDto, sendDetailDto.getUserDigitId(), sendDetailDto.getReceiveDigitId(), content, urls);
            switch (SendStatus.getType((Integer)sendRequestDto.getStatus())) {
                case SENDING: {
                    sendDetailDto.setStatus(Integer.valueOf(SendStatus.SENDING.getValue()));
                    sendDetailDto.setRequestId(sendRequestDto.getRequestId());
                    this.updateDetail((MessageGroupSendDetail)sendDetailDto);
                    break;
                }
                case SEND_FAIL: {
                    this.updateSendDetailToFinal((MessageGroupSendDetail)sendDetailDto, sendRequestDto.getMsg());
                    break;
                }
                case TO_BE_SEND: {
                    sendDetailDto.setStatus(Integer.valueOf(SendStatus.TO_BE_SEND.getValue()));
                    sendDetailDto.setRemark(sendRequestDto.getMsg());
                    this.updateDetail((MessageGroupSendDetail)sendDetailDto);
                }
            }
        }
        catch (Exception e) {
            log.error("sendContactMessageNow single \u53d1\u9001\u6d88\u606f\u5931\u8d25\uff1adetailId: {}", (Object)sendDetailDto.getId(), (Object)e);
            this.updateSendDetailToFinal((MessageGroupSendDetail)sendDetailDto, this.buildErrorMsg(e));
        }
    }

    private void updateDetail(MessageGroupSendDetail detail) {
        detail.setUpdateTime(new Date());
        try {
            this.groupSendDetailMapper.updateByPrimaryKeySelective((Object)detail);
        }
        catch (Exception e) {
            log.error("group send messages id:", (Object)detail.getId());
            log.error("group send message ", (Throwable)e);
        }
    }

    private void updateSendDetailToFinal(MessageGroupSendDetail detail, String reason) {
        detail.setStatus(Integer.valueOf(SendStatus.SEND_FAIL.getValue()));
        detail.setRemark(reason);
        this.updateDetail(detail);
    }

    private String buildErrorMsg(Exception e) {
        String errorMsg = "\u53d1\u9001\u6d88\u606f\u5931\u8d25";
        if (Objects.nonNull(e) && StringUtils.isNotBlank((CharSequence)e.getMessage())) {
            errorMsg = e.getMessage();
        }
        return StringUtils.abbreviate((String)errorMsg, (int)50);
    }

    private GroupSendRequestDto sendMultMessageReturnStatusAndMsg(SendDetailDto SendDetailDto2, String weworkId, String targetId, String content, Set<String> urls) {
        try {
            String remark;
            Integer status;
            BaseResponse baseResponse;
            List groupMessageConentDtos = JSON.parseArray((String)content, UniformMsgDto.class);
            GroupSendRequestDto result = GroupSendRequestDto.build(SendStatus.SEND_FAIL.getValue(), "\u7fa4\u53d1\u6d88\u606f\u5185\u5bb9\u683c\u5f0f\u9519\u8bef");
            if (CollectionUtils.isEmpty((Collection)groupMessageConentDtos)) {
                log.error("sendMultMessage error groupMessageConentDtos empty,taskId:{}", (Object)SendDetailDto2.getTaskId());
                return result;
            }
            List<SendMessageDto> sendMessageDtoList = this.buildMessage(groupMessageConentDtos, weworkId, targetId, SendDetailDto2);
            if (CollectionUtils.isEmpty(sendMessageDtoList)) {
                log.warn("sendMultMessage sendMessageDtoList empty,taskId:{}", (Object)SendDetailDto2.getTaskId());
                return result;
            }
            BaseResponse response = this.batchSendMessageReturnRequestIdOrErrorMsg(sendMessageDtoList);
            log.info("groupsend response:{}", (Object)JSON.toJSONString(response));
            if (response.getCode() == (long)ResponseCodeType.SUCCESS.getCode()) {
                if (CollectionUtils.isEmpty((Collection)((Collection)response.getData()))) {
                    log.error("response.data is null,response={}", response);
                    return null;
                }
                for (int i = 0; i < ((List)response.getData()).size() && i < sendMessageDtoList.size(); ++i) {
                    BaseResponse item = (BaseResponse)((List)response.getData()).get(i);
                    if (!StringUtils.isBlank((CharSequence)item.getRequestId())) continue;
                    log.warn("requestId is empty,response={}", (Object)item);
                }
                baseResponse = (BaseResponse)((List)response.getData()).get(((List)response.getData()).size() - 1);
            } else {
                baseResponse = response;
            }
            Integer code = (int)baseResponse.getCode();
            switch (ResponseCodeType.getInstance((int)code)) {
                case SUCCESS: {
                    status = SendStatus.SENDING.getValue();
                    remark = baseResponse.getMsg();
                    break;
                }
                case WEWORK_OFFLINE: 
                case REQUEST_PARAM_NOT_INVALID: 
                case INTERNAL_SERVER_ERROR: 
                case SEND_TIME_OVER_24: 
                case CANCEL: {
                    status = SendStatus.SEND_FAIL.getValue();
                    remark = baseResponse.getMsg();
                    break;
                }
                case THRESHOLD_EXCEEDED: {
                    status = SendStatus.SEND_FAIL.getValue();
                    remark = ResponseCodeType.THRESHOLD_EXCEEDED.getDesc();
                    break;
                }
                case WEWORK_REQUEST_FREQUENTLY: {
                    status = SendStatus.SEND_FAIL.getValue();
                    remark = "\u5fae\u4fe1\u8fd4\u56de\uff1a\u6d88\u606f\u53d1\u9001\u9891\u7e41\u3002\u4e3a\u4e86\u60a8\u7684\u8d26\u53f7\u5b89\u5168\uff0c\u7cfb\u7edf\u5df2\u7ecf\u81ea\u52a8\u505c\u6b62\u53d1\u9001\uff0c\u5982\u987b\u518d\u6b21\u53d1\u9001\uff0c\u8bf7\u624b\u52a8\u70b9\u51fb\u4e00\u952e\u91cd\u53d1";
                    break;
                }
                case CONCURRENT_MODIFY: 
                case BATCH_PUSH_CONCURRENT_MODIFY: {
                    status = SendStatus.TO_BE_SEND.getValue();
                    remark = baseResponse.getMsg();
                    break;
                }
                default: {
                    if (code == 2001) {
                        status = SendStatus.SEND_FAIL.getValue();
                        remark = "\u5fae\u4fe1\u8fd4\u56de\uff1a\u6d88\u606f\u53d1\u9001\u9891\u7e41\u3002\u4e3a\u4e86\u60a8\u7684\u8d26\u53f7\u5b89\u5168\uff0c\u7cfb\u7edf\u5df2\u7ecf\u81ea\u52a8\u505c\u6b62\u53d1\u9001\uff0c\u5982\u987b\u518d\u6b21\u53d1\u9001\uff0c\u8bf7\u624b\u52a8\u70b9\u51fb\u4e00\u952e\u91cd\u53d1";
                        break;
                    }
                    status = SendStatus.SEND_FAIL.getValue();
                    remark = baseResponse.getMsg();
                }
            }
            return GroupSendRequestDto.build(status, remark, baseResponse, baseResponse.getRequestId());
        }
        catch (Exception e) {
            log.error("\u7fa4\u53d1\u6d88\u606f\u670d\u52a1\u8c03\u7528\u5f02\u5e38\uff0ccontent={}", (Object)content, (Object)e);
            return GroupSendRequestDto.build(SendStatus.SEND_FAIL.getValue(), StringUtils.abbreviate((String)("\u7fa4\u53d1\u6d88\u606f\u670d\u52a1\u8c03\u7528\u5f02\u5e38," + e.getMessage()), (int)50));
        }
    }

    private BaseResponse<List<BaseResponse>> batchSendMessageReturnRequestIdOrErrorMsg(List<SendMessageDto> sendMessageDtos) {
        log.info("\u6279\u91cf\u53d1\u9001\u6d88\u606f\uff0cmessageDtos:{}", (Object)JSON.toJSONString(sendMessageDtos));
        if (CollectionUtils.isEmpty(sendMessageDtos)) {
            log.warn("empty messages");
            return null;
        }
        ArrayList batchPushMsgs = Lists.newArrayList();
        ArrayList noticeList = Lists.newArrayList();
        for (SendMessageDto sendMessageDto : sendMessageDtos) {
            if (StringUtils.equals((CharSequence)sendMessageDto.getMsgType(), (CharSequence)JsMsgType.notice.name())) {
                noticeList.add(sendMessageDto);
                continue;
            }
            batchPushMsgs.add(sendMessageDto);
        }
        if (CollectionUtils.isNotEmpty((Collection)noticeList)) {
            if (CollectionUtils.isNotEmpty((Collection)batchPushMsgs)) {
                noticeList.addAll(batchPushMsgs);
            }
            return this.batchPushMsg(noticeList);
        }
        return this.batchPushMsg(batchPushMsgs);
    }

    private BaseResponse<List<BaseResponse>> batchPushMsg(List<SendMessageDto> sendMessageDtos) {
        ArrayList baseSendDtos = Lists.newArrayList();
        String notice = null;
        for (SendMessageDto sendMessageDto : sendMessageDtos) {
            if (StringUtils.isEmpty(notice) && StringUtils.equalsIgnoreCase((CharSequence)JsMsgType.notice.name(), (CharSequence)sendMessageDto.getMsgType())) {
                notice = sendMessageDto.getContent();
                continue;
            }
            BaseSendReq baseSendReq = sendMessageDto.convert2BaseSendReq();
            if (!Objects.nonNull(baseSendReq)) continue;
            baseSendDtos.add(baseSendReq);
        }
        SendMessageDto sendMessageDto = sendMessageDtos.get(0);
        BatchPushMessageReq req = new BatchPushMessageReq();
        req.setTargetId(sendMessageDto.getTargetId());
        if (ReceiveType.CONTACT.getType() == sendMessageDto.getTargetType().intValue()) {
            req.setType(0);
        } else {
            req.setType(1);
        }
        req.setList((List)baseSendDtos);
        req.setNotice(notice);
        req.setWeworkId(sendMessageDto.getWeworkId());
        req.setOpPlatform(Integer.valueOf(OpPlatform.MANAGER.getType()));
        req.setCorpId(sendMessageDto.getCorpId());
        req.setControl(true);
        req.setBizId(sendMessageDto.getBizId());
        req.setSendDate(new Date());
        req.setTaskType(LinkOpType.BATCHPUSH);
        req.setTaskId(sendMessageDto.getTaskId());
        req.setDetailId(sendMessageDto.getDetailId());
        req.setDeadline(sendMessageDto.getDeadline());
        log.info("req={}", (Object)req);
        return this.messageService.batchPush(req);
    }

    private List<SendMessageDto> buildMessage(List<UniformMsgDto> groupMessageConentDtos, String weworkId, String targetId, SendDetailDto SendDetailDto2) {
        ArrayList list = Lists.newArrayList();
        for (UniformMsgDto uniformMsgDto : groupMessageConentDtos) {
            SendMessageDto item = new SendMessageDto(uniformMsgDto, SendDetailDto2.getTaskId(), SendDetailDto2.getId(), weworkId, SendDetailDto2.getBizId(), SendDetailDto2.getCorpId(), targetId, SendDetailDto2.getReceiveType(), SendDetailDto2.getDeadline());
            list.add(item);
        }
        return list;
    }

    @Override
    public void sendRetryMessage(SendRetryReqDto params) {
        CurrentUserInfo currentUser = LoginUtils.getCurrentUser();
        log.info("sendRetryMessage with params={},userId={}", (Object)params, (Object)currentUser.getId());
        params.validate();
        Long id = params.getId();
        Integer type = params.getType();
        switch (MessageSendRetryType.getType((Integer)type)) {
            case TASK: {
                this.sendRetryTaskMessage(id);
                break;
            }
            case DETAIL: {
                this.sendRetryDetailMessage(id);
            }
        }
    }

    private void sendRetryDetailMessage(Long detailId) {
        MessageGroupSendDetail messageGroupSendDetail = (MessageGroupSendDetail)this.groupSendDetailMapper.selectByPrimaryKey((Object)detailId);
        if (messageGroupSendDetail == null) {
            throw new BusinessException((UniverseErrorCode)CommonErrorCode.BUSINESS_ERROR, "\u91cd\u53d1\u6d88\u606f\u4e0d\u5b58\u5728");
        }
        if (messageGroupSendDetail.getStatus().equals(SendStatus.SENDING.getValue())) {
            log.info("send retry detail message is sending, id = {}", (Object)detailId);
            throw new BusinessException((UniverseErrorCode)CommonErrorCode.BUSINESS_ERROR, "\u6d88\u606f\u6b63\u5728\u53d1\u9001\u4e2d");
        }
        log.info("send retry detail message before, {}", (Object)JSON.toJSONString((Object)messageGroupSendDetail));
        MessageGroupSendTask messageGroupSendTask = (MessageGroupSendTask)this.groupSendTaskMapper.selectByPrimaryKey((Object)messageGroupSendDetail.getTaskId());
        Preconditions.checkArgument((messageGroupSendTask != null ? 1 : 0) != 0, (Object)"\u91cd\u53d1\u6d88\u606f\u4efb\u52a1\u4e0d\u5b58\u5728");
        Preconditions.checkArgument((boolean)messageGroupSendTask.getTaskStatus().equals(TaskStatus.NORMAL.getValue()), (Object)"\u4efb\u52a1\u5df2\u7981\u7528,\u4e0d\u53ef\u91cd\u8bd5");
        messageGroupSendDetail.setStatus(Integer.valueOf(SendStatus.TO_BE_SEND.getValue()));
        messageGroupSendDetail.setRequestId(null);
        messageGroupSendDetail.setSendCompleteTime(null);
        messageGroupSendDetail.setRemark(null);
        this.groupSendDetailMapper.updateByPrimaryKey((Object)messageGroupSendDetail);
        if (!messageGroupSendTask.getSendStatus().equals(SendStatus.SENDING.getValue())) {
            this.groupSendTaskMapper.refreshTaskSendStatusBySendStatus((Collection)Lists.newArrayList((Object[])new Long[]{messageGroupSendTask.getId()}), Integer.valueOf(SendStatus.SENDING.getValue()), true);
        }
        this.groupSendStatusService.refreshStatus(Sets.newHashSet((Object[])new Long[]{messageGroupSendDetail.getId()}));
    }

    private void sendRetryTaskMessage(Long taskId) {
        MessageGroupSendTask messageGroupSendTask = (MessageGroupSendTask)this.groupSendTaskMapper.selectByPrimaryKey((Object)taskId);
        Preconditions.checkArgument((messageGroupSendTask != null ? 1 : 0) != 0, (Object)"\u91cd\u53d1\u6d88\u606f\u4efb\u52a1\u4e0d\u5b58\u5728");
        Preconditions.checkArgument((boolean)messageGroupSendTask.getTaskStatus().equals(TaskStatus.NORMAL.getValue()), (Object)"\u4efb\u52a1\u5df2\u7981\u7528,\u4e0d\u53ef\u91cd\u8bd5");
        List messageGroupSendDetailList = this.groupSendDetailMapper.queryDetailListByTaskIdAndStatus(taskId, (Collection)Sets.newHashSet((Object[])new Integer[]{SendStatus.ALREADY_EXPIRE.getValue(), SendStatus.SEND_FAIL.getValue()}));
        if (CollectionUtils.isEmpty((Collection)messageGroupSendDetailList)) {
            throw new BusinessException((UniverseErrorCode)CommonErrorCode.BUSINESS_ERROR, "\u6ca1\u6709\u9700\u8981\u91cd\u53d1\u7684\u6d88\u606f");
        }
        List taskIds = messageGroupSendDetailList.stream().map(a -> a.getTaskId()).distinct().collect(Collectors.toList());
        Set retryDetailIds = messageGroupSendDetailList.stream().map(a -> a.getId()).collect(Collectors.toSet());
        log.info("send retry subTask message, retryDetailIds = {}", retryDetailIds);
        if (CollectionUtils.isEmpty(retryDetailIds)) {
            log.info("\u6ca1\u6709\u5931\u8d25\u7684\u6d88\u606f\u9700\u8981\u91cd\u53d1, taskId={}", (Object)taskId);
            return;
        }
        List partition = Lists.partition((List)Lists.newArrayList(retryDetailIds), (int)300);
        for (int i = 0; i < partition.size(); ++i) {
            this.groupSendDetailMapper.resetDetailStatus((Collection)partition.get(i), Integer.valueOf(SendStatus.TO_BE_SEND.getValue()), null);
        }
        this.groupSendTaskMapper.updateSendStatus(taskIds, SendStatus.SENDING.getValue());
        this.groupSendTaskMapper.reSetArriveNum((Collection)Lists.newArrayList((Object[])new Long[]{taskId}));
    }

    @Override
    public void executeSendTaskWithChatRoomCondition() {
    }

    class GroupSendRunnable
    implements ITaskRunnable {
        SendDetailDto sendDetailDto;
        String content;
        Set<String> urls;

        public SendDetailDto getSendDetailDto() {
            return this.sendDetailDto;
        }

        public String getContent() {
            return this.content;
        }

        public Set<String> getUrls() {
            return this.urls;
        }

        public GroupSendRunnable(SendDetailDto sendDetailDto, String content, Set<String> urls) {
            this.sendDetailDto = sendDetailDto;
            this.content = content;
            this.urls = urls;
        }

        public void run() {
            try {
                long startTime = System.currentTimeMillis();
                boolean ifTaskDisable = GroupSendVipExecuteServiceImpl.this.checkTaskDisable(this.sendDetailDto);
                if (ifTaskDisable) {
                    log.info("\u4efb\u52a1\u5df2\u7ecf\u7981\u7528,\u9000\u51fa,taskId={}", (Object)this.sendDetailDto.getTaskId());
                    return;
                }
                if (this.sendDetailDto != null && this.sendDetailDto.getDeadline() != null && this.sendDetailDto.getDeadline().getTime() <= System.currentTimeMillis()) {
                    log.info(GroupSendVipExecuteServiceImpl.EXCEED_DEADLINE);
                    GroupSendVipExecuteServiceImpl.this.updateSendDetailToFinal((MessageGroupSendDetail)this.sendDetailDto, GroupSendVipExecuteServiceImpl.EXCEED_DEADLINE);
                    return;
                }
                boolean isTobeSend = GroupSendVipExecuteServiceImpl.this.checkDetailTobesend(this.sendDetailDto);
                if (!isTobeSend) {
                    log.info("groupsend detail\u72b6\u6001\u5df2\u53d8\u5316,\u65e0\u9700\u53d1\u9001,detailId={}", (Object)this.sendDetailDto.getId());
                    return;
                }
                if (this.sendDetailDto.getReceiveType().intValue() == ReceiveType.CHATROOM.getType()) {
                    log.info("chatroom groupsend SendDetailDto={}", (Object)this.sendDetailDto);
                    GroupSendVipExecuteServiceImpl.this.sendChatRoomMessage(this.sendDetailDto, this.content, this.urls);
                } else {
                    log.info("contact groupsend SendDetailDto={}", (Object)this.sendDetailDto);
                    GroupSendVipExecuteServiceImpl.this.sendContactMessage(this.sendDetailDto, this.content, this.urls);
                }
                log.info("send message with SendDetailDto={},wasteTime={}", (Object)this.sendDetailDto, (Object)(System.currentTimeMillis() - startTime));
            }
            catch (Exception e) {
                log.error("send with error", (Throwable)e);
            }
        }
    }
}

