/*
 * Decompiled with CFR 0.152.
 */
package com.kuaike.scrm.groupsend.service.impl;

import cn.kinyun.link.common_dto.dto.BaseResponse;
import cn.kinyun.link.common_dto.dto.ResponseCodeType;
import cn.kinyun.link.common_dto.enums.LinkOpType;
import cn.kinyun.link.service.OperateService;
import com.alibaba.fastjson.JSON;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.kuaike.common.errorcode.CommonErrorCode;
import com.kuaike.common.errorcode.UniverseErrorCode;
import com.kuaike.common.exception.BusinessException;
import com.kuaike.scrm.common.dto.StopWatchDto;
import com.kuaike.scrm.common.enums.GroupSendFkType;
import com.kuaike.scrm.common.enums.GroupSendSource;
import com.kuaike.scrm.common.enums.GroupSendTaskType;
import com.kuaike.scrm.common.enums.QueryType;
import com.kuaike.scrm.common.enums.ReceiveType;
import com.kuaike.scrm.common.enums.SendStatus;
import com.kuaike.scrm.common.enums.TaskStatus;
import com.kuaike.scrm.common.service.ParamEncryService;
import com.kuaike.scrm.common.service.dto.GroupSendEntity;
import com.kuaike.scrm.common.service.dto.MeetingParams;
import com.kuaike.scrm.common.service.dto.SelectedChatroom2WeworkUserDto;
import com.kuaike.scrm.common.service.dto.SelectedContact2WeworkUserDto;
import com.kuaike.scrm.common.utils.DateUtil;
import com.kuaike.scrm.common.utils.JacksonUtils;
import com.kuaike.scrm.common.utils.KafkaClientUtils;
import com.kuaike.scrm.dal.groupsend.dto.FkTaskId2TaskStatusCountDto;
import com.kuaike.scrm.dal.groupsend.dto.MinMaxDateDto;
import com.kuaike.scrm.dal.groupsend.entity.MessageGroupSendDetail;
import com.kuaike.scrm.dal.groupsend.entity.MessageGroupSendTask;
import com.kuaike.scrm.dal.groupsend.mapper.MessageGroupSendDetailMapper;
import com.kuaike.scrm.dal.groupsend.mapper.MessageGroupSendTaskMapper;
import com.kuaike.scrm.dal.groupsend.mapper.MessageGroupSopMapper;
import com.kuaike.scrm.dal.wework.mapper.WeworkUserMapper;
import com.kuaike.scrm.groupsend.dto.WeworkUserSendTargetPair;
import com.kuaike.scrm.groupsend.dto.request.AddOrModInnerGroupSendReq;
import com.kuaike.scrm.groupsend.dto.request.AddOrModReq;
import com.kuaike.scrm.groupsend.dto.request.UpdateGroupSendReq;
import com.kuaike.scrm.groupsend.dto.response.GroupSendWrapResp;
import com.kuaike.scrm.groupsend.dto.response.MultiSearchChatroomRespDto;
import com.kuaike.scrm.groupsend.dto.response.MultiSearchContactResp;
import com.kuaike.scrm.groupsend.service.GroupSendService;
import com.kuaike.scrm.groupsend.service.GroupSendTaskService;
import com.kuaike.scrm.groupsend.service.GroupSendWrapService;
import com.kuaike.scrm.groupsend.service.MultiSelectService;
import com.kuaike.scrm.groupsend.service.impl.GroupSendServiceImpl;
import com.kuaike.scrm.service.MeetingCusParamEncryRelService;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.collections4.MapUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.time.DateUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class GroupSendTaskServiceImpl
implements GroupSendTaskService {
    private static final Logger log = LoggerFactory.getLogger(GroupSendTaskServiceImpl.class);
    @Autowired
    private MessageGroupSendTaskMapper groupSendTaskMapper;
    @Autowired
    private MessageGroupSopMapper sopMapper;
    @Autowired
    private MessageGroupSendDetailMapper groupSendDetailMapper;
    @Autowired
    private MultiSelectService multiSelectService;
    @Autowired
    private KafkaClientUtils kafkaClientUtils;
    @Value(value="${kafka.topic.meeting_group_send}")
    private String meetingGroupSendTopic;
    @Autowired
    private GroupSendWrapService groupSendWrapService;
    @Autowired
    private ParamEncryService paramEncryService;
    @Autowired
    private GroupSendService groupSendService;
    @Resource
    private MeetingCusParamEncryRelService meetingCusParamEncryRelService;
    @Autowired
    private WeworkUserMapper weworkUserMapper;
    @Autowired
    private OperateService operateService;
    @Autowired
    private RedisTemplate<String, String> redisTemplate;
    @Autowired
    private String getGroupSendTaskKey;

    @Override
    public void updateWithOutParam(UpdateGroupSendReq req) {
        GroupSendWrapResp resp = this.groupSendWrapService.updateWithOutParam(req);
        if (resp != null && resp.getOpType() != null) {
            this.sendMessageToKafka(resp.getTask(), resp.getOpType(), resp.isCreateByMeeting());
        }
    }

    private void sendMessageToKafka(MessageGroupSendTask task, int opType, boolean isCreateByMeeting) {
        if (task.getFkTaskId() != null && task.getFkType() != null && task.getFkType() != 0) {
            try {
                GroupSendEntity entity = new GroupSendEntity();
                entity.setFkId(String.valueOf(task.getFkTaskId()));
                entity.setFkType(task.getFkType());
                entity.setTaskNum(task.getNum());
                entity.setTaskId(task.getId());
                entity.setOpType(opType);
                entity.setCreateByMeeting(isCreateByMeeting);
                log.info("push to kafka with groupsend entity={}", (Object)JSON.toJSONString((Object)entity));
                this.kafkaClientUtils.sendMessage(this.meetingGroupSendTopic, task.getNum(), JacksonUtils.getInstance().writeValueAsString((Object)entity));
            }
            catch (Exception e) {
                log.error("sendMessage to {} with error", (Object)this.meetingGroupSendTopic, (Object)e);
            }
        }
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void updateGroupSend(AddOrModReq req, MessageGroupSendTask groupSendTask, Long operatorId) {
        log.info("updateGroupSend with req={},groupSendTask={},operatorId={}", new Object[]{req, groupSendTask, operatorId});
        groupSendTask.setSendTime(req.getSendTime());
        groupSendTask.setDeadline(req.getDeadlineTime());
        groupSendTask.setUpdateBy(operatorId);
        groupSendTask.setName(req.getTaskName());
        groupSendTask.setTimeoutGap(req.getChangeTimeoutGap());
        groupSendTask.setAutoChangeTaskType(req.getAutoChangeTaskType());
        try {
            groupSendTask.setContent(JacksonUtils.getInstance().writeValueAsString(req.getContentList()));
            groupSendTask.setParamsJson(JacksonUtils.getInstance().writeValueAsString((Object)req));
        }
        catch (JsonProcessingException e) {
            e.printStackTrace();
        }
        this.updateGroupSendTask(groupSendTask, null, null);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void disableTask(String taskNum, Long operatorId) {
        List details;
        log.info("disableTask with taskNum={},operatorId={}", (Object)taskNum, (Object)operatorId);
        this.groupSendTaskMapper.updateTaskStatus(taskNum, TaskStatus.BANED.getValue(), operatorId);
        MessageGroupSendTask task = this.groupSendTaskMapper.queryByTaskNum(taskNum);
        if (task.getFkType().equals(GroupSendFkType.SOP.getType())) {
            this.updateTaskStatusSop(task.getFkTaskId());
        }
        if (CollectionUtils.isNotEmpty((Collection)(details = this.groupSendDetailMapper.queryDetailListByTaskIdAndStatus(task.getId(), (Collection)Sets.newHashSet((Object[])new Integer[]{SendStatus.TO_BE_QUERY.getValue(), SendStatus.TO_BE_SEND.getValue(), SendStatus.SENDING.getValue()}))))) {
            List detailIds = details.stream().map(a -> a.getId()).collect(Collectors.toList());
            this.groupSendDetailMapper.updateStatusAndSendTimeWhenFailByIds(detailIds, Integer.valueOf(SendStatus.SEND_FAIL.getValue()), "\u7981\u7528\u4efb\u52a1");
        }
        try {
            this.cancelWaitingMessageSend(task.getId());
        }
        catch (Exception e) {
            log.error("notice cancel waiting messageSend error, {}", (Throwable)e);
            this.groupSendTaskMapper.updateTaskStatus(task.getNum(), TaskStatus.NORMAL.getValue(), operatorId);
            throw e;
        }
    }

    public void cancelWaitingMessageSend(Long taskId) {
        StopWatchDto timer;
        block10: {
            if (taskId == null) {
                return;
            }
            timer = new StopWatchDto("cancelWaitingMessageSend", true, log);
            timer.start("queryMinMaxCreateTime");
            MinMaxDateDto minMaxDateDto = this.groupSendDetailMapper.queryMinMaxCreateTime(taskId);
            timer.stop();
            if (minMaxDateDto == null || minMaxDateDto.getMax() == null) {
                log.info("queryMinMaxCreateTime with empty");
                timer.print();
                return;
            }
            timer.start("setRedisVariable");
            String value = minMaxDateDto.getMin().getTime() + ":" + minMaxDateDto.getMax().getTime();
            this.redisTemplate.opsForHash().put((Object)this.getGroupSendTaskKey, (Object)String.valueOf(taskId), (Object)value);
            log.info("up task and time in redis.taskId={},value={}", (Object)taskId, (Object)value);
            timer.stop();
            try {
                timer.start("cancelOperation");
                BaseResponse baseResponse = this.operateService.cancelTask(taskId, LinkOpType.BATCHPUSH);
                log.info("cancelTask with taskId={},baseResponse={}", (Object)taskId, (Object)baseResponse);
                if (baseResponse.getCode() == (long)ResponseCodeType.SUCCESS.getCode()) {
                    log.info("success");
                    break block10;
                }
                if (baseResponse.getCode() == (long)ResponseCodeType.BATCH_PUSH_CONCURRENT_MODIFY.getCode()) {
                    throw new BusinessException((UniverseErrorCode)CommonErrorCode.BUSINESS_ERROR, "\u673a\u5668\u4eba\u4e1a\u52a1\u6b63\u5fd9,\u8bf7\u7a0d\u540e\u518d\u8bd5");
                }
                if (baseResponse.getCode() == (long)ResponseCodeType.REQUEST_PARAM_NOT_INVALID.getCode()) {
                    log.info("taskId \u5728link\u4e0d\u5b58\u5728,\u4e0d\u7528\u53d6\u6d88");
                    break block10;
                }
                log.error("\u8c03\u7528\u53d6\u6d88\u63a5\u53e3\u5f02\u5e38, \u8fd4\u56de\u503c\u4e3a:", (Object)baseResponse);
                throw new BusinessException((UniverseErrorCode)CommonErrorCode.BUSINESS_ERROR, "\u4efb\u52a1\u53d6\u6d88\u5f02\u5e38");
            }
            catch (Exception e) {
                log.error("cancelTask with error", (Throwable)e);
                throw e;
            }
            finally {
                timer.stop();
            }
        }
        timer.print();
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void enableTask(String taskNum, Long operatorId) {
        log.info("enableTask with taskNum={},operatorId={}", (Object)taskNum, (Object)operatorId);
        MessageGroupSendTask task = this.groupSendTaskMapper.queryByTaskNum(taskNum);
        if (Objects.isNull(task)) {
            return;
        }
        if (GroupSendServiceImpl.vipGroupSend.contains(task.getTaskType())) {
            Long count = this.redisTemplate.opsForHash().delete((Object)this.getGroupSendTaskKey, new Object[]{String.valueOf(task.getId())});
            log.info("remove groupSendTaskKey flag, count={}", (Object)count);
        }
        this.groupSendTaskMapper.updateTaskStatus(taskNum, TaskStatus.NORMAL.getValue(), operatorId);
        if (task.getFkType().equals(GroupSendFkType.SOP.getType())) {
            this.updateTaskStatusSop(task.getFkTaskId());
        }
    }

    @Override
    public void taskStart() {
        log.info("groupSend taskSend start");
        Date now = new Date();
        now = DateUtils.addSeconds((Date)now, (int)60);
        List needStartGroupSendTasks = this.groupSendTaskMapper.queryStartTask(now);
        if (CollectionUtils.isEmpty((Collection)needStartGroupSendTasks)) {
            return;
        }
        List taskIds = needStartGroupSendTasks.stream().map(a -> a.getId()).collect(Collectors.toList());
        log.info("ready to generate detail with taskIds={}", taskIds);
        for (MessageGroupSendTask task : needStartGroupSendTasks) {
            if (GroupSendFkType.UN_ARRIVE_MEETING.getType() == task.getFkType().intValue() && now.before(task.getSendTime())) {
                log.info("\u8d85\u65f6\u672a\u9001\u8fbe\u4efb\u52a1\uff1anum:{} \u73b0\u5728\u8fd8\u672a\u5230\u89e6\u53d1\u65f6\u95f4\uff0c\u7b49\u5f85\u89e6\u53d1\u65f6\u95f4\u518d\u751f\u6210detail: sendTime:{} ", (Object)task.getNum(), (Object)DateUtil.dateToDateString((Date)task.getSendTime()));
                continue;
            }
            GroupSendWrapResp resp = this.groupSendWrapService.warpGenerateDetail(task, now);
            if (resp == null || resp.getOpType() == null || !Objects.nonNull(resp.getTask()) || GroupSendFkType.UN_ARRIVE_MEETING.getType() == task.getFkType().intValue()) continue;
            this.sendMessageToKafka(resp.getTask(), resp.getOpType(), resp.isCreateByMeeting());
            log.info("sendMessageToKafka with param={}", (Object)JSON.toJSONString((Object)resp));
        }
        log.info("groupSend taskSend end");
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public GroupSendWrapResp generateGroupSendDetailAndUpdate(MessageGroupSendTask task, AddOrModReq req) {
        log.info("generateGroupSendDetailAndUpdate with taskId={},req={}", (Object)task.getId(), (Object)req);
        ArrayList details = Lists.newArrayList();
        switch (GroupSendTaskType.getType((int)task.getTaskType())) {
            case SIDEBAR: 
            case QYAPI: 
            case VIP_GROUP_SEND_CHATROOM: 
            case VIP_GROUP_SEND_CUSTOMER: 
            case VIP_GROUP_SEND_NOTICE: {
                this.calShouldSendDetails(task, req, details);
                break;
            }
            case CLIENT: {
                this.calClientSendDetails(task, req, details);
            }
        }
        log.info("generate taskDetail,taskId={},detailCount={}", (Object)task.getId(), (Object)details.size());
        if (CollectionUtils.isEmpty((Collection)details)) {
            if (GroupSendFkType.UN_ARRIVE_MEETING.getType() != task.getFkType().intValue() || !req.getNotUpdateTaskStatus().booleanValue()) {
                this.updateGroupSendTask(task, 0, SendStatus.ALREADY_SEND.getValue());
            }
            return new GroupSendWrapResp(task, 2, false, req.getSource() != null && req.getSource().equals(GroupSendSource.MEETING_SERVICE.getType()));
        }
        List partition = Lists.partition((List)details, (int)50);
        for (List messageGroupSendDetails : partition) {
            this.fillExtField(task, messageGroupSendDetails);
            this.groupSendDetailMapper.batchInsert(messageGroupSendDetails);
        }
        this.updateGroupSendTask(task, details.size(), SendStatus.SENDING.getValue());
        return new GroupSendWrapResp(task, 2, true, req.getSource() != null && req.getSource().equals(GroupSendSource.MEETING_SERVICE.getType()));
    }

    private void calClientSendDetails(MessageGroupSendTask task, AddOrModReq req, List<MessageGroupSendDetail> details) {
        Date nowTime = new Date();
        for (String weworkUserNum : req.getWeworkUserNums()) {
            MessageGroupSendDetail detail = new MessageGroupSendDetail();
            detail.setCorpId(task.getCorpId());
            detail.setSendTime(task.getSendTime());
            detail.setBizId(task.getBizId());
            detail.setCreateBy(Long.valueOf(-1L));
            detail.setCreateTime(nowTime);
            if (task.getFkType().intValue() == GroupSendFkType.MEETING.getType()) {
                String param = "";
                detail.setExtField1(param);
            }
            detail.setReceiveId("emptyReceiverId");
            if (req.getQueryType().equals(QueryType.CONTACT.getType())) {
                detail.setReceiveType(Integer.valueOf(ReceiveType.CONTACT.getType()));
            } else {
                detail.setReceiveType(Integer.valueOf(ReceiveType.CHATROOM.getType()));
            }
            detail.setSendWeworkNum(weworkUserNum);
            detail.setStatus(Integer.valueOf(SendStatus.TO_BE_SEND.getValue()));
            detail.setTaskId(task.getId());
            detail.setUpdateBy(Long.valueOf(-1L));
            detail.setUpdateTime(nowTime);
            detail.setTaskType(task.getTaskType());
            detail.setDeadline(task.getDeadline());
            details.add(detail);
        }
    }

    private void calShouldSendDetails(MessageGroupSendTask task, AddOrModReq req, List<MessageGroupSendDetail> details) {
        switch (QueryType.getByType((int)task.getQueryType())) {
            case CONTACT: {
                if (GroupSendFkType.UN_ARRIVE_MEETING.getType() == task.getFkType().intValue()) {
                    MultiSearchContactResp contactResp = new MultiSearchContactResp();
                    contactResp.setList(req.getWeworkUserDtos());
                    this.buildContactDetails(task, details, contactResp, req);
                    task.setQueryRequestId(contactResp.getRequestId());
                    break;
                }
                req.getGroupsendContact().setRequestId(null);
                MultiSearchContactResp contactResp = this.multiSelectService.multiSearchContact(req.getGroupsendContact(), true);
                if (!CollectionUtils.isNotEmpty(contactResp.getList())) break;
                this.buildContactDetails(task, details, contactResp, req);
                task.setQueryRequestId(contactResp.getRequestId());
                break;
            }
            case CHAT_ROOM: {
                if (req.getTaskType().equals(GroupSendTaskType.QYAPI.getValue())) {
                    this.calClientSendDetails(task, req, details);
                    task.setQueryRequestId(null);
                    break;
                }
                MultiSearchChatroomRespDto chatroomResp = this.multiSelectService.multiSearchChatroom(req.getGroupsendChatRoom(), true);
                if (!CollectionUtils.isNotEmpty(chatroomResp.getList())) break;
                this.buildChatroomDetails(task, details, chatroomResp);
                task.setQueryRequestId(chatroomResp.getRequestId());
                break;
            }
            case QRCODE: {
                req.getGroupsendQrCodeContact().setRequestId(null);
                MultiSearchContactResp qrContactResp = this.multiSelectService.multiSearchQrcode(req.getGroupsendQrCodeContact(), true);
                if (!CollectionUtils.isNotEmpty(qrContactResp.getList())) break;
                this.buildContactDetails(task, details, qrContactResp, req);
                task.setQueryRequestId(qrContactResp.getRequestId());
            }
        }
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void updateGroupSendTask(MessageGroupSendTask task, Integer sendCount, Integer sendStatus) {
        task.setUpdateTime(new Date());
        if (sendStatus != null) {
            task.setSendStatus(sendStatus);
        }
        if (sendCount != null) {
            task.setSendCount(sendCount);
        }
        this.groupSendTaskMapper.updateByPrimaryKeySelective((Object)task);
        if (task.getFkType().equals(GroupSendFkType.SOP.getType())) {
            this.updateSendStatusSop(Lists.newArrayList((Object[])new Long[]{task.getId()}));
            if (sendCount != null) {
                this.sopMapper.updateSendCount(task.getFkTaskId(), Long.valueOf(sendCount.intValue()));
            }
        }
    }

    private void fillExtField(MessageGroupSendTask task, List<MessageGroupSendDetail> details) {
        if (task.getFkType().equals(GroupSendFkType.MEETING.getType())) {
            List paramsList = details.stream().map(a -> {
                if (task.getFkType().equals(GroupSendFkType.MEETING.getType())) {
                    String receiveId = null;
                    if (!a.getReceiveId().equals("${customstr}")) {
                        receiveId = a.getReceiveId();
                    }
                    return new MeetingParams(task.getFkTaskId(), task.getNum(), a.getSendWeworkNum(), receiveId, a.getReceiveType(), Long.valueOf(0L));
                }
                return null;
            }).filter(a -> Objects.nonNull(a)).collect(Collectors.toList());
            List meetingEncryRespDtoList = this.paramEncryService.batchGenerateEncryMeetingParam(paramsList);
            try {
                this.meetingCusParamEncryRelService.batchInsertWhenGroupTaskFillExtField(task.getBizId(), meetingEncryRespDtoList);
            }
            catch (Exception e) {
                log.error("fillExtField \u63d2\u5165meetingCusParamEncryRel\u5f02\u5e38", (Throwable)e);
            }
            Map<String, String> encryKey2Params = meetingEncryRespDtoList.stream().collect(Collectors.toMap(a -> StringUtils.join((Object[])new Object[]{a.getGroupSendNum(), a.getMeetingId(), a.getWeworkUserNum(), a.getTargetId() == null ? "${customstr}" : a.getTargetId()}, (String)"$$"), a -> a.getEncryParam()));
            for (MessageGroupSendDetail item : details) {
                String key = StringUtils.join((Object[])new Object[]{task.getNum(), task.getFkTaskId(), item.getSendWeworkNum(), item.getReceiveId() == null ? "${customstr}" : item.getReceiveId()}, (String)"$$");
                item.setExtField1(encryKey2Params.get(key));
            }
        }
    }

    private void buildChatroomDetails(MessageGroupSendTask task, List<MessageGroupSendDetail> details, MultiSearchChatroomRespDto chatroomResp) {
        for (SelectedChatroom2WeworkUserDto selectedChatroom2WeworkUserDto : chatroomResp.getList()) {
            Date nowTime = new Date();
            MessageGroupSendDetail item = new MessageGroupSendDetail();
            item.setCorpId(task.getCorpId());
            item.setSendTime(task.getSendTime());
            item.setBizId(task.getBizId());
            item.setCreateBy(Long.valueOf(-1L));
            item.setCreateTime(nowTime);
            if (task.getFkType() == 1) {
                String param = "";
                item.setExtField1(param);
            }
            item.setReceiveId(selectedChatroom2WeworkUserDto.getChatroomId());
            item.setReceiveDigitId(selectedChatroom2WeworkUserDto.getChatroomDigitId());
            item.setReceiveType(Integer.valueOf(ReceiveType.CHATROOM.getType()));
            item.setSendWeworkNum(selectedChatroom2WeworkUserDto.getWeworkNum());
            item.setUserDigitId(selectedChatroom2WeworkUserDto.getWeworkUserDigitId());
            item.setStatus(Integer.valueOf(SendStatus.TO_BE_SEND.getValue()));
            item.setTaskId(task.getId());
            item.setUpdateBy(Long.valueOf(-1L));
            item.setUpdateTime(nowTime);
            item.setTaskType(task.getTaskType());
            item.setDeadline(task.getDeadline());
            details.add(item);
        }
    }

    private void buildContactDetails(MessageGroupSendTask task, List<MessageGroupSendDetail> details, MultiSearchContactResp contactResp, AddOrModReq req) {
        if (Objects.isNull(contactResp)) {
            return;
        }
        if (CollectionUtils.isEmpty(contactResp.getList())) {
            return;
        }
        for (SelectedContact2WeworkUserDto selectedContact2WeworkUserDto : contactResp.getList()) {
            Date nowTime = new Date();
            MessageGroupSendDetail item = new MessageGroupSendDetail();
            item.setCorpId(task.getCorpId());
            item.setSendTime(task.getSendTime());
            item.setBizId(task.getBizId());
            item.setCreateBy(Long.valueOf(-1L));
            item.setCreateTime(nowTime);
            if (task.getFkType().intValue() == GroupSendFkType.MEETING.getType()) {
                String param = "";
                item.setExtField1(param);
            }
            item.setReceiveId(selectedContact2WeworkUserDto.getContactId());
            item.setReceiveDigitId(selectedContact2WeworkUserDto.getContactDigitId());
            item.setReceiveType(Integer.valueOf(ReceiveType.CONTACT.getType()));
            item.setSendWeworkNum(selectedContact2WeworkUserDto.getWeworkNum());
            item.setUserDigitId(selectedContact2WeworkUserDto.getWeworkUserDigitId());
            item.setStatus(Integer.valueOf(SendStatus.TO_BE_SEND.getValue()));
            item.setTaskId(task.getId());
            item.setUpdateBy(Long.valueOf(-1L));
            item.setUpdateTime(nowTime);
            item.setDeadline(task.getDeadline());
            item.setTaskType(task.getTaskType());
            details.add(item);
        }
    }

    @Override
    public void taskExpire() {
        log.info("groupSend taskExpire start");
        Date now = new Date();
        this.expireSidebarAndClientGroupSend(now);
        this.expireSystemGroupSend(now);
        log.info("groupSend taskExpire end");
    }

    private void expireSystemGroupSend(Date now) {
        Map expireId2TaskId = this.groupSendDetailMapper.querySystemSendExpireIds(now);
        if (MapUtils.isNotEmpty((Map)expireId2TaskId)) {
            log.info("expire systemSend count={}", (Object)expireId2TaskId.size());
            List partition2 = Lists.partition((List)Lists.newArrayList(expireId2TaskId.keySet()), (int)100);
            for (List ids : partition2) {
                this.groupSendDetailMapper.updateStatusByIds((Collection)ids, Integer.valueOf(SendStatus.ALREADY_EXPIRE.getValue()), SendStatus.ALREADY_EXPIRE.getDesc(), null);
            }
            Set<Long> needUpdateTaskIds = expireId2TaskId.values().stream().collect(Collectors.toSet());
            this.groupSendService.updateTaskStatus(needUpdateTaskIds);
        }
    }

    private boolean expireSidebarAndClientGroupSend(Date now) {
        List expireTaskIds = this.groupSendTaskMapper.queryExpireTask(now, (Collection)Lists.newArrayList((Object[])new Integer[]{GroupSendTaskType.SIDEBAR.getValue(), GroupSendTaskType.CLIENT.getValue()}));
        log.info("expire task count={}", (Object)expireTaskIds.size());
        if (CollectionUtils.isEmpty((Collection)expireTaskIds)) {
            return true;
        }
        this.groupSendTaskMapper.updateSendStatus((Collection)expireTaskIds, SendStatus.ALREADY_SEND.getValue());
        this.updateSendStatusSop(expireTaskIds);
        List detailIds = this.groupSendDetailMapper.queryExpireIdsByTaskIds(expireTaskIds);
        log.info("expire taskDetail count={}", (Object)detailIds.size());
        List partition = Lists.partition((List)detailIds, (int)100);
        for (List ids : partition) {
            this.groupSendDetailMapper.updateStatusByIds((Collection)ids, Integer.valueOf(SendStatus.ALREADY_EXPIRE.getValue()), SendStatus.ALREADY_EXPIRE.getDesc(), null);
        }
        return false;
    }

    private void updateTaskStatusSop(Long sopId) {
        FkTaskId2TaskStatusCountDto fkTaskId2TaskStatusCountDto = this.groupSendTaskMapper.queryTaskStatusCountByFkIdAndFkType(sopId, Integer.valueOf(GroupSendFkType.SOP.getType()));
        if (fkTaskId2TaskStatusCountDto == null) {
            return;
        }
        if (fkTaskId2TaskStatusCountDto.getBandCount() > 0 && fkTaskId2TaskStatusCountDto.getNotEndBandCount().equals(fkTaskId2TaskStatusCountDto.getBandCount())) {
            this.sopMapper.updateTaskStatus(sopId, TaskStatus.BANED.getValue(), Long.valueOf(-1L));
        } else if (fkTaskId2TaskStatusCountDto.getEnableCount() > 0) {
            this.sopMapper.updateTaskStatus(sopId, TaskStatus.NORMAL.getValue(), Long.valueOf(-1L));
        }
    }

    @Override
    public void updateSendStatusSop(List<Long> taskIds) {
        List fkTaskIds = this.groupSendTaskMapper.queryFkIdByFkType(taskIds, Integer.valueOf(GroupSendFkType.SOP.getType()));
        if (CollectionUtils.isNotEmpty((Collection)fkTaskIds)) {
            List fkTaskId2Process = this.groupSendTaskMapper.queryStatusByTaskIds((Collection)fkTaskIds, Integer.valueOf(GroupSendFkType.SOP.getType()));
            Set finishedSopIds = fkTaskId2Process.stream().filter(a -> a.getFinishedCount().equals(a.getAllCount()) && a.getAllCount() > 0).map(a -> a.getId()).collect(Collectors.toSet());
            Set sendingSopIds = fkTaskId2Process.stream().filter(a -> a.getFinishedCount() < a.getAllCount()).map(a -> a.getId()).collect(Collectors.toSet());
            if (CollectionUtils.isNotEmpty(finishedSopIds)) {
                log.info("update sop with already_send sopTaskIds={}", finishedSopIds);
                this.sopMapper.updateSendStatus(finishedSopIds, SendStatus.ALREADY_SEND.getValue());
                Map sopId2SendCount = this.groupSendTaskMapper.queryLastTaskSendCount(finishedSopIds, Integer.valueOf(GroupSendFkType.SOP.getType()));
                sopId2SendCount.forEach((sopId, sendCount) -> this.sopMapper.updateSendCount(sopId, Long.valueOf(sendCount.intValue())));
            }
            if (CollectionUtils.isNotEmpty(sendingSopIds)) {
                log.info("update sop with sending sopTaskIds={}", sendingSopIds);
                this.sopMapper.updateSendStatus(sendingSopIds, SendStatus.SENDING.getValue());
            }
        }
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void generateGroupSendDetailAndUpdate(MessageGroupSendTask task, AddOrModInnerGroupSendReq req) {
        log.info("generateGroupSendDetailAndUpdate2 with task={},req={}", (Object)task, (Object)req);
        ArrayList details = Lists.newArrayList();
        switch (GroupSendTaskType.getType((int)task.getTaskType())) {
            case SIDEBAR: {
                this.buildReceiveDetails(task, req, details);
                break;
            }
            case QYAPI: {
                if (req.getReceiveType().equals(ReceiveType.CHATROOM.getType())) {
                    this.buildClientGroupsendDetails(task, req, details);
                    break;
                }
                this.buildReceiveDetails(task, req, details);
                break;
            }
            case CLIENT: {
                this.buildClientGroupsendDetails(task, req, details);
            }
        }
        log.info("generate taskDetail,taskId={},detailCount={}", (Object)task.getId(), (Object)details.size());
        if (CollectionUtils.isEmpty((Collection)details)) {
            this.updateGroupSendTask(task, 0, SendStatus.ALREADY_SEND.getValue());
        } else {
            List partition = Lists.partition((List)details, (int)50);
            for (List messageGroupSendDetails : partition) {
                this.fillExtField(task, messageGroupSendDetails);
                this.groupSendDetailMapper.batchInsert(messageGroupSendDetails);
            }
            this.updateGroupSendTask(task, details.size(), SendStatus.SENDING.getValue());
        }
    }

    private void buildReceiveDetails(MessageGroupSendTask task, AddOrModInnerGroupSendReq req, List<MessageGroupSendDetail> details) {
        for (WeworkUserSendTargetPair pair : req.getSendTargetPairs()) {
            Date nowTime = new Date();
            MessageGroupSendDetail item = new MessageGroupSendDetail();
            item.setCorpId(task.getCorpId());
            item.setSendTime(task.getSendTime());
            item.setBizId(task.getBizId());
            item.setCreateBy(Long.valueOf(-1L));
            item.setCreateTime(nowTime);
            if (task.getFkType() == 1) {
                String param = "";
                item.setExtField1(param);
            }
            item.setReceiveId(pair.getTargetId());
            item.setReceiveType(req.getReceiveType());
            item.setSendWeworkNum(pair.getWeworkUserNum());
            item.setStatus(Integer.valueOf(SendStatus.TO_BE_SEND.getValue()));
            item.setTaskId(task.getId());
            item.setUpdateBy(Long.valueOf(-1L));
            item.setUpdateTime(nowTime);
            item.setDeadline(task.getDeadline());
            item.setTaskType(task.getTaskType());
            details.add(item);
        }
    }

    private void buildClientGroupsendDetails(MessageGroupSendTask task, AddOrModInnerGroupSendReq req, List<MessageGroupSendDetail> details) {
        Date nowTime = new Date();
        for (String weworkUserNum : req.getWeworkUserNums()) {
            MessageGroupSendDetail detail = new MessageGroupSendDetail();
            detail.setCorpId(task.getCorpId());
            detail.setSendTime(task.getSendTime());
            detail.setBizId(task.getBizId());
            detail.setCreateBy(Long.valueOf(-1L));
            detail.setCreateTime(nowTime);
            if (task.getFkType() == 1) {
                String param = "";
                detail.setExtField1(param);
            }
            detail.setReceiveId("emptyReceiverId");
            detail.setReceiveType(req.getReceiveType());
            detail.setSendWeworkNum(weworkUserNum);
            detail.setStatus(Integer.valueOf(SendStatus.TO_BE_SEND.getValue()));
            detail.setTaskId(task.getId());
            detail.setUpdateBy(Long.valueOf(-1L));
            detail.setUpdateTime(nowTime);
            detail.setTaskType(task.getTaskType());
            detail.setDeadline(task.getDeadline());
            details.add(detail);
        }
    }

    @Override
    public void updateGroupSend2(AddOrModInnerGroupSendReq req, MessageGroupSendTask groupSendTask, Long operatorId) {
        log.info("updateGroupSend2 with req={},groupSendTask={},operatorId={}", new Object[]{req, groupSendTask, operatorId});
        groupSendTask.setSendTime(req.getSendTime());
        groupSendTask.setDeadline(req.getDeadlineTime());
        groupSendTask.setUpdateBy(operatorId);
        groupSendTask.setName(req.getTaskName());
        groupSendTask.setAutoChangeTaskType(req.getAutoChangeTaskType());
        try {
            groupSendTask.setContent(JacksonUtils.getInstance().writeValueAsString(req.getContentList()));
            groupSendTask.setParamsJson(JacksonUtils.getInstance().writeValueAsString((Object)req));
        }
        catch (JsonProcessingException e) {
            e.printStackTrace();
        }
        this.updateGroupSendTask(groupSendTask, null, null);
    }
}

