/*
 * Decompiled with CFR 0.152.
 */
package com.kuaike.scrm.groupsend.service.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.serializer.SerializerFeature;
import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.kuaike.common.errorcode.CommonErrorCode;
import com.kuaike.common.errorcode.UniverseErrorCode;
import com.kuaike.common.exception.BusinessException;
import com.kuaike.scrm.common.dto.CurrentUserInfo;
import com.kuaike.scrm.common.enums.GroupSendFkType;
import com.kuaike.scrm.common.enums.GroupSendSource;
import com.kuaike.scrm.common.enums.GroupSendTaskType;
import com.kuaike.scrm.common.enums.QueryType;
import com.kuaike.scrm.common.enums.ReceiveType;
import com.kuaike.scrm.common.enums.SendStatus;
import com.kuaike.scrm.common.enums.TaskStatus;
import com.kuaike.scrm.common.perm.service.UserRoleCommonService;
import com.kuaike.scrm.common.utils.IdGen;
import com.kuaike.scrm.common.utils.LoginUtils;
import com.kuaike.scrm.dal.groupsend.dto.Id2StatusCount;
import com.kuaike.scrm.dal.groupsend.dto.Id2StatusCount2Dto;
import com.kuaike.scrm.dal.groupsend.dto.SopListReq;
import com.kuaike.scrm.dal.groupsend.entity.MessageGroupSendTask;
import com.kuaike.scrm.dal.groupsend.entity.MessageGroupSop;
import com.kuaike.scrm.dal.groupsend.mapper.MessageGroupSendDetailMapper;
import com.kuaike.scrm.dal.groupsend.mapper.MessageGroupSendTaskMapper;
import com.kuaike.scrm.dal.groupsend.mapper.MessageGroupSopMapper;
import com.kuaike.scrm.dal.wework.dto.WeworkUserInfo;
import com.kuaike.scrm.groupsend.dto.request.AddOrModReq;
import com.kuaike.scrm.groupsend.dto.request.EditTaskStatusReq;
import com.kuaike.scrm.groupsend.dto.request.IdReq;
import com.kuaike.scrm.groupsend.dto.request.sop.EditSopReqDto;
import com.kuaike.scrm.groupsend.dto.request.sop.SopAddOrModReq;
import com.kuaike.scrm.groupsend.dto.request.sop.SopContentAndTimeDto;
import com.kuaike.scrm.groupsend.dto.request.sop.SopDateGroup;
import com.kuaike.scrm.groupsend.dto.response.AddOrModResp;
import com.kuaike.scrm.groupsend.dto.response.MsgGroupSendTaskProcessRespDto;
import com.kuaike.scrm.groupsend.dto.response.SopGroupSendProcessDto;
import com.kuaike.scrm.groupsend.dto.response.sop.SopListRespDto;
import com.kuaike.scrm.groupsend.service.GroupSendFillService;
import com.kuaike.scrm.groupsend.service.GroupSendService;
import com.kuaike.scrm.groupsend.service.GroupSendSopService;
import com.kuaike.scrm.groupsend.service.MultiSelectService;
import com.kuaike.scrm.wework.weworkUser.service.WeworkUserService;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class GroupSendSopServiceImpl
implements GroupSendSopService {
    private static final Logger log = LoggerFactory.getLogger(GroupSendSopServiceImpl.class);
    @Autowired
    private MessageGroupSopMapper sopMapper;
    @Autowired
    private GroupSendService groupSendService;
    @Autowired
    private MessageGroupSendTaskMapper groupSendTaskMapper;
    @Autowired
    private MessageGroupSendDetailMapper groupSendDetailMapper;
    @Autowired
    private UserRoleCommonService userRoleCommonService;
    @Autowired
    private WeworkUserService weworkUserService;
    @Autowired
    private IdGen idGen;
    @Autowired
    private GroupSendFillService fillService;
    @Autowired
    private MultiSelectService multiSelectService;

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void addOrMod(SopAddOrModReq req) {
        CurrentUserInfo currentUserInfo = LoginUtils.getCurrentUser();
        log.info("addOrMod with req={},operatorId={}", (Object)req, (Object)currentUserInfo.getId());
        req.validate();
        Date now = new Date();
        MessageGroupSop sop = null;
        if (StringUtils.isBlank((CharSequence)req.getSopNum())) {
            sop = this.buildSop(req, currentUserInfo, now);
            this.sopMapper.insertSelective((Object)sop);
        } else {
            sop = this.sopMapper.queryByNum(req.getSopNum());
            this.checkSopTaskStatusEditAvailable(sop);
            sop.setParamsJson(JSON.toJSONString((Object)req, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.WriteMapNullValue}));
            sop.setTitle(req.getSopTitle());
            sop.setUpdateTime(new Date());
            sop.setUpdateBy(currentUserInfo.getId());
            this.sopMapper.updateByPrimaryKeySelective((Object)sop);
            if (CollectionUtils.isNotEmpty(req.getDelTaskNums())) {
                EditSopReqDto editSopReqDto = new EditSopReqDto();
                editSopReqDto.setSopNum(sop.getNum());
                editSopReqDto.setChildrenIds(req.getDelTaskNums());
                this.delete(editSopReqDto);
            }
        }
        HashSet taskNums = Sets.newHashSet();
        for (SopDateGroup sopDateGroup : req.getChildren()) {
            for (SopContentAndTimeDto contentAndTimeDto : sopDateGroup.getTaskList()) {
                if (!StringUtils.isNotBlank((CharSequence)contentAndTimeDto.getTaskNum())) continue;
                taskNums.add(contentAndTimeDto.getTaskNum());
            }
        }
        Map<String, MessageGroupSendTask> taskNum2Task = this.groupSendTaskMapper.queryByTaskNums((Collection)taskNums).stream().collect(Collectors.toMap(a -> a.getNum(), a -> a));
        for (SopDateGroup child : req.getChildren()) {
            for (SopContentAndTimeDto item : child.getTaskList()) {
                MessageGroupSendTask taskItem = taskNum2Task.get(item.getTaskNum());
                if (taskItem != null && taskItem.getSendStatus().equals(SendStatus.ALREADY_SEND.getValue())) continue;
                AddOrModReq addOrModReq = this.buildGroupSendAddOrModReq(req, sop, item);
                try {
                    AddOrModResp addOrModResp = this.groupSendService.addOrModGroupSend(addOrModReq);
                    if (addOrModResp == null) continue;
                    item.setTaskNum(addOrModResp.getTaskNum());
                }
                catch (Exception e) {
                    e.printStackTrace();
                    throw e;
                }
            }
        }
        int n = ((MessageGroupSendTask)this.groupSendService.queryEntityByFkTasks(sop.getId(), GroupSendFkType.SOP).stream().findFirst().get()).getSendCount();
        sop.setUpdateBy(currentUserInfo.getId());
        sop.setUpdateTime(new Date());
        sop.setParamsJson(JSON.toJSONString((Object)req, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.WriteMapNullValue}));
        sop.setSendCount(Long.valueOf(n));
        this.sopMapper.updateByPrimaryKeySelective((Object)sop);
    }

    private MessageGroupSop buildSop(SopAddOrModReq req, CurrentUserInfo currentUserInfo, Date now) {
        String num = this.idGen.getNum();
        MessageGroupSop sop = new MessageGroupSop();
        sop.setParamsJson(JSON.toJSONString((Object)req, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.WriteMapNullValue}));
        sop.setTitle(req.getSopTitle());
        sop.setTaskStatus(TaskStatus.NORMAL.getValue());
        sop.setBizId(currentUserInfo.getBizId());
        sop.setCorpId(currentUserInfo.getCorpId());
        sop.setSendStatus(Integer.valueOf(SendStatus.TO_BE_SEND.getValue()));
        sop.setNum(num);
        sop.setRequestId("");
        sop.setCreateBy(currentUserInfo.getId());
        sop.setCreateTime(now);
        sop.setUpdateBy(currentUserInfo.getId());
        sop.setUpdateTime(now);
        sop.setIsDeleted(Integer.valueOf(0));
        if (req.getQueryType().equals(QueryType.CHAT_ROOM.getType())) {
            sop.setReceiveType(Integer.valueOf(ReceiveType.CHATROOM.getType()));
        } else {
            sop.setReceiveType(Integer.valueOf(ReceiveType.CONTACT.getType()));
        }
        return sop;
    }

    private AddOrModReq buildGroupSendAddOrModReq(SopAddOrModReq req, MessageGroupSop sop, SopContentAndTimeDto item) {
        AddOrModReq addOrModReq = new AddOrModReq();
        addOrModReq.setTaskNum(item.getTaskNum());
        addOrModReq.setRemindDates(item.getRemindDates());
        addOrModReq.setRemind(item.getRemind());
        addOrModReq.setRemindType(item.getRemindType());
        addOrModReq.setSendTime(item.getSendTime());
        addOrModReq.setDeadlineTime(item.getDeadlineTime());
        addOrModReq.setFkType(GroupSendFkType.SOP.getType());
        addOrModReq.setFkTaskId(sop.getId());
        addOrModReq.setGroupsendQrCodeContact(req.getGroupsendQrCodeContact());
        addOrModReq.setGroupsendContact(req.getGroupsendContact());
        addOrModReq.setGroupsendChatRoom(req.getGroupsendChatRoom());
        addOrModReq.setQueryType(req.getQueryType());
        addOrModReq.setContentList(item.getContentList());
        addOrModReq.setTaskName(req.getSopTitle());
        addOrModReq.setSource(GroupSendSource.SOP_SERVICE.getType());
        addOrModReq.setTaskType(GroupSendTaskType.SIDEBAR.getValue());
        return addOrModReq;
    }

    private void checkSopTaskExist(MessageGroupSop sop) {
        if (Objects.isNull(sop) || sop.getIsDeleted().equals(1)) {
            throw new BusinessException((UniverseErrorCode)CommonErrorCode.BUSINESS_ERROR, "sop\u4e0d\u5b58\u5728");
        }
    }

    private void checkSopTaskStatusEditAvailable(MessageGroupSop sop) {
        this.checkSopTaskExist(sop);
        if (sop.getSendStatus().equals(SendStatus.ALREADY_SEND.getValue())) {
            throw new BusinessException((UniverseErrorCode)CommonErrorCode.BUSINESS_ERROR, "\u4efb\u52a1\u5df2\u7ed3\u675f\u4e0d\u53ef\u4fee\u6539");
        }
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void delete(EditSopReqDto req) {
        CurrentUserInfo currentUserInfo = LoginUtils.getCurrentUser();
        log.info("deletetask with req={},operatorId={}", (Object)req, (Object)currentUserInfo.getId());
        req.validate();
        MessageGroupSop sop = this.sopMapper.queryByNum(req.getSopNum());
        List<Object> taskNums = Lists.newArrayList();
        this.checkSopTaskStatusEditAvailable(sop);
        taskNums = CollectionUtils.isNotEmpty(req.getChildrenIds()) ? Lists.newArrayList(req.getChildrenIds()) : this.groupSendService.queryFkTasks(sop.getId(), GroupSendFkType.SOP);
        ArrayList failedTaskNum = Lists.newArrayList();
        for (String string : taskNums) {
            try {
                IdReq idReq = new IdReq();
                idReq.setTaskNum(string);
                this.groupSendService.deleteTask(idReq);
            }
            catch (BusinessException e) {
                e.printStackTrace();
                log.info("\u5b50\u4efb\u52a1\u4e0d\u53ef\u5220\u9664\uff0csubTaskNum={}", (Object)string);
                failedTaskNum.add(string);
            }
        }
        taskNums.removeAll(failedTaskNum);
        List groupSendTaskList = this.groupSendTaskMapper.queryEntityByFkIdAndType(sop.getId(), Integer.valueOf(GroupSendFkType.SOP.getType()));
        if (CollectionUtils.isEmpty((Collection)groupSendTaskList)) {
            sop.setIsDeleted(Integer.valueOf(1));
            sop.setUpdateBy(currentUserInfo.getId());
            sop.setUpdateTime(new Date());
            this.sopMapper.updateByPrimaryKeySelective((Object)sop);
        }
        log.info("deletetask success sopNum={},subTaskNums={}", (Object)sop.getNum(), taskNums);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void editIsDisable(EditSopReqDto req) {
        CurrentUserInfo currentUserInfo = LoginUtils.getCurrentUser();
        log.info("editIsDisable with req={},operatorId={}", (Object)req, (Object)currentUserInfo.getId());
        req.validateStatus();
        MessageGroupSop sop = this.sopMapper.queryByNum(req.getSopNum());
        this.checkSopTaskStatusEditAvailable(sop);
        if (req.getTaskStatus().equals(sop.getTaskStatus())) {
            return;
        }
        List<MessageGroupSendTask> tasks = this.groupSendService.queryEntityByFkTasks(sop.getId(), GroupSendFkType.SOP);
        if (CollectionUtils.isEmpty(tasks)) {
            throw new BusinessException((UniverseErrorCode)CommonErrorCode.BUSINESS_ERROR, "sop\u4efb\u52a1\u672a\u5173\u8054\u4efb\u4f55\u7fa4\u53d1\u5b50\u4efb\u52a1");
        }
        List taskNums = tasks.stream().filter(a -> !a.getTaskStatus().equals(req.getTaskStatus())).map(a -> a.getNum()).collect(Collectors.toList());
        if (CollectionUtils.isNotEmpty(taskNums)) {
            for (String taskNum : taskNums) {
                EditTaskStatusReq editTaskStatusReq = new EditTaskStatusReq();
                editTaskStatusReq.setTaskNum(taskNum);
                editTaskStatusReq.setTaskStatus(req.getTaskStatus());
                editTaskStatusReq.setFkTaskId(sop.getId());
                editTaskStatusReq.setFkType(GroupSendFkType.SOP.getType());
                try {
                    this.groupSendService.editTaskStatus(editTaskStatusReq);
                }
                catch (BusinessException e) {
                    if (!e.getMessage().equals("\u4efb\u52a1\u5df2\u7981\u7528") && !e.getMessage().equals("\u4efb\u52a1\u5df2\u542f\u7528")) continue;
                }
            }
        }
    }

    @Override
    public SopAddOrModReq sopDetail(String sopNum) {
        log.info("sopDetail with sopNum={}", (Object)sopNum);
        Preconditions.checkArgument((boolean)StringUtils.isNotBlank((CharSequence)sopNum), (Object)"sopNum\u4e0d\u80fd\u4e3a\u7a7a");
        MessageGroupSop sop = this.sopMapper.queryByNum(sopNum);
        Long bizId = sop.getBizId();
        String corpId = sop.getCorpId();
        this.checkSopTaskExist(sop);
        SopAddOrModReq sopAddOrModReq = (SopAddOrModReq)JSON.parseObject((String)sop.getParamsJson(), SopAddOrModReq.class);
        sopAddOrModReq.setSopNum(sopNum);
        sopAddOrModReq.setSendCount(sop.getSendCount());
        HashMap sendTime2Dto = Maps.newHashMap();
        for (SopDateGroup child : sopAddOrModReq.getChildren()) {
            for (SopContentAndTimeDto sopContentAndTimeDto : child.getTaskList()) {
                sendTime2Dto.put(sopContentAndTimeDto.getSendTime(), sopContentAndTimeDto);
            }
        }
        List tasks = this.groupSendTaskMapper.queryEntityByFkIdAndType(sop.getId(), Integer.valueOf(GroupSendFkType.SOP.getType()));
        Map<String, MessageGroupSendTask> taskNum2Task = tasks.stream().collect(Collectors.toMap(a -> a.getNum(), a -> a));
        for (SopDateGroup child : sopAddOrModReq.getChildren()) {
            for (SopContentAndTimeDto sopContentAndTimeDto : child.getTaskList()) {
                MessageGroupSendTask task = taskNum2Task.get(sopContentAndTimeDto.getTaskNum());
                if (task != null) {
                    sopContentAndTimeDto.setSendStatus(task.getSendStatus());
                    sopContentAndTimeDto.setTaskStatus(task.getTaskStatus());
                    continue;
                }
                sopContentAndTimeDto.setSendStatus(SendStatus.TO_BE_SEND.getValue());
                sopContentAndTimeDto.setTaskStatus(TaskStatus.NORMAL.getValue());
            }
        }
        switch (QueryType.getByType((int)sopAddOrModReq.getQueryType())) {
            case CONTACT: {
                sopAddOrModReq.setGroupsendContact(this.fillService.fillContact(bizId, corpId, sopAddOrModReq.getGroupsendContact()));
                break;
            }
            case CHAT_ROOM: {
                sopAddOrModReq.setGroupsendChatRoom(this.fillService.fillChatroom(corpId, sopAddOrModReq.getGroupsendChatRoom()));
                break;
            }
            case QRCODE: {
                sopAddOrModReq.setGroupsendQrCodeContact(this.fillService.fillQrCode(bizId, corpId, sopAddOrModReq.getGroupsendQrCodeContact()));
            }
        }
        return sopAddOrModReq;
    }

    @Override
    public List<SopListRespDto> sopList(SopListReq req) {
        CurrentUserInfo currentUserInfo = LoginUtils.getCurrentUser();
        log.info("sopList with req={},operatorId={}", (Object)req, (Object)currentUserInfo.getId());
        req.setManageUserIds((Collection)this.userRoleCommonService.getManageUserIds());
        req.setCorpId(currentUserInfo.getCorpId());
        int count = this.sopMapper.queryCountByParam(req);
        if (count == 0) {
            return Lists.newArrayList();
        }
        List list = this.sopMapper.queryByParam(req);
        if (req.getPageDto() != null) {
            req.getPageDto().setCount(Integer.valueOf(count));
            req.getPageDto().setCurPageCount(Integer.valueOf(list.size()));
        }
        Set updateIds = list.stream().map(a -> a.getUpdateBy()).collect(Collectors.toSet());
        Map userId2EntityMap = this.weworkUserService.queryWeworkUserByUserIds(currentUserInfo.getCorpId(), updateIds);
        Set sopIds = list.stream().map(a -> a.getId()).collect(Collectors.toSet());
        List tasks = this.groupSendTaskMapper.queryEntityByFkIdsAndType(sopIds, Integer.valueOf(GroupSendFkType.SOP.getType()));
        Map<Long, List<MessageGroupSendTask>> sopId2Task = tasks.stream().collect(Collectors.groupingBy(MessageGroupSendTask::getFkTaskId));
        List notStartDetails = this.groupSendDetailMapper.queryNotStartTaskDetailsByFk(sopIds, Integer.valueOf(GroupSendFkType.SOP.getType()));
        Map taskId2SendPair = notStartDetails.stream().collect(Collectors.groupingBy(a -> a.getTaskId(), Collectors.mapping(a -> StringUtils.join((Object[])new String[]{a.getSendWeworkNum(), a.getReceiveId()}, (String)"##"), Collectors.toSet())));
        Map<Object, Object> taskId2Dto = Maps.newHashMap();
        Map<Object, Object> sopId2ProcessDto = Maps.newHashMap();
        if (CollectionUtils.isNotEmpty(sopIds)) {
            List id2StatusCounts = this.groupSendTaskMapper.queryStatusByTaskIds(sopIds, Integer.valueOf(GroupSendFkType.SOP.getType()));
            taskId2Dto = id2StatusCounts.stream().collect(Collectors.toMap(Id2StatusCount2Dto::getId, a -> {
                SopGroupSendProcessDto dto = SopGroupSendProcessDto.buildFromId2StatusCount(a);
                return dto;
            }));
            List id2StatusCounts1 = this.groupSendDetailMapper.queryStatusBySopIds(sopIds);
            sopId2ProcessDto = id2StatusCounts1.stream().collect(Collectors.toMap(Id2StatusCount::getId, a -> {
                MsgGroupSendTaskProcessRespDto dto = MsgGroupSendTaskProcessRespDto.buildFromId2StatusCount(a);
                return dto;
            }));
            for (Long sopId : sopIds) {
                List<MessageGroupSendTask> taskList = sopId2Task.get(sopId);
                MsgGroupSendTaskProcessRespDto processRespDto = sopId2ProcessDto.getOrDefault(sopId, new MsgGroupSendTaskProcessRespDto());
                if (processRespDto != null) {
                    int tobeSendCount = 0;
                    for (MessageGroupSendTask task : taskList) {
                        if (task.getSendStatus() >= SendStatus.SENDING.getValue()) continue;
                        Set<String> sendPair = this.multiSelectService.queryMultiSelectSendPair(task);
                        Set oldSendPair = taskId2SendPair.getOrDefault(task.getId(), Sets.newHashSet());
                        Collection unionSet = CollectionUtils.union(sendPair, (Iterable)oldSendPair);
                        Collection notCreateSet = CollectionUtils.subtract((Iterable)unionSet, (Iterable)oldSendPair);
                        tobeSendCount += notCreateSet.size();
                    }
                    processRespDto.setTobeSendTaskNum(processRespDto.getTobeSendTaskNum() + tobeSendCount);
                    processRespDto.calAllTaskNumAndComplateTaskNum();
                    sopId2ProcessDto.put(sopId, processRespDto);
                    continue;
                }
                int totalCount = 0;
                for (MessageGroupSendTask task : taskList) {
                    totalCount += task.getSendCount().intValue();
                }
                processRespDto = new MsgGroupSendTaskProcessRespDto();
                processRespDto.setExpireTaskNum(0);
                processRespDto.setTobeSendTaskNum(totalCount);
                processRespDto.setAlreadySendTaskNum(0);
                processRespDto.setAllTaskNum(totalCount);
                processRespDto.calAllTaskNumAndComplateTaskNum();
                sopId2ProcessDto.put(sopId, processRespDto);
            }
        }
        ArrayList result = Lists.newArrayList();
        for (MessageGroupSop sop : list) {
            SopListRespDto item = new SopListRespDto();
            SopAddOrModReq sopAddOrModReq = (SopAddOrModReq)JSON.parseObject((String)sop.getParamsJson(), SopAddOrModReq.class);
            item.setSopNum(sop.getNum());
            item.setTitle(sop.getTitle());
            item.setQueryType(sopAddOrModReq.getQueryType());
            item.setUpdateTime(sop.getUpdateTime());
            item.setSendStatus(sop.getSendStatus());
            item.setTaskStatus(sop.getTaskStatus());
            item.setProcessDto((MsgGroupSendTaskProcessRespDto)sopId2ProcessDto.get(sop.getId()));
            item.setProcess((SopGroupSendProcessDto)taskId2Dto.get(sop.getId()));
            WeworkUserInfo weworkUserInfo = userId2EntityMap.getOrDefault(sop.getUpdateBy(), new WeworkUserInfo());
            item.setUpdateUserName(weworkUserInfo != null ? weworkUserInfo.getNameFirst() : "");
            result.add(item);
        }
        return result;
    }
}

