/*
 * Decompiled with CFR 0.152.
 */
package com.kuaike.scrm.groupsend.service.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.kuaike.common.errorcode.CommonErrorCode;
import com.kuaike.common.errorcode.UniverseErrorCode;
import com.kuaike.common.exception.BusinessException;
import com.kuaike.common.sqlbuilder.dto.PageDto;
import com.kuaike.common.utils.JacksonUtil;
import com.kuaike.scrm.common.dto.CurrentUserInfo;
import com.kuaike.scrm.common.dto.StopWatchDto;
import com.kuaike.scrm.common.dto.jsMsg.JsNewsDto;
import com.kuaike.scrm.common.dto.jsMsg.UniformMsgDto;
import com.kuaike.scrm.common.enums.GroupSendFkType;
import com.kuaike.scrm.common.enums.GroupSendTaskType;
import com.kuaike.scrm.common.enums.JsMsgType;
import com.kuaike.scrm.common.enums.QueryType;
import com.kuaike.scrm.common.enums.ReceiveType;
import com.kuaike.scrm.common.enums.SendStatus;
import com.kuaike.scrm.common.enums.TaskStatus;
import com.kuaike.scrm.common.enums.YnEnum;
import com.kuaike.scrm.common.excel.ExcelHeader;
import com.kuaike.scrm.common.perm.service.UserRoleCommonService;
import com.kuaike.scrm.common.service.dto.GroupSendEntity;
import com.kuaike.scrm.common.service.dto.SelectedChatroom2WeworkUserDto;
import com.kuaike.scrm.common.service.dto.SelectedContact2WeworkUserDto;
import com.kuaike.scrm.common.utils.BackendExcelUtils;
import com.kuaike.scrm.common.utils.JacksonUtils;
import com.kuaike.scrm.common.utils.KafkaClientUtils;
import com.kuaike.scrm.common.utils.LoginUtils;
import com.kuaike.scrm.dal.groupsend.dto.Id2StatusCount;
import com.kuaike.scrm.dal.groupsend.dto.MsgGroupSendTaskQueryDto;
import com.kuaike.scrm.dal.groupsend.entity.MessageGroupSendDetail;
import com.kuaike.scrm.dal.groupsend.entity.MessageGroupSendTask;
import com.kuaike.scrm.dal.groupsend.entity.MessageGroupSendTaskCriteria;
import com.kuaike.scrm.dal.groupsend.entity.MessageGroupSendWework;
import com.kuaike.scrm.dal.groupsend.entity.WeworkTmpStore;
import com.kuaike.scrm.dal.groupsend.mapper.MessageGroupSendDetailMapper;
import com.kuaike.scrm.dal.groupsend.mapper.MessageGroupSendTaskMapper;
import com.kuaike.scrm.dal.groupsend.mapper.MessageGroupSendWeworkMapper;
import com.kuaike.scrm.dal.groupsend.mapper.MessageGroupSopMapper;
import com.kuaike.scrm.dal.groupsend.mapper.WeworkTmpStoreMapper;
import com.kuaike.scrm.dal.marketing.mapper.MarketingRewardMapper;
import com.kuaike.scrm.dal.marketing.mapper.MarketingRewardStageMapper;
import com.kuaike.scrm.dal.meeting.entity.Meeting;
import com.kuaike.scrm.dal.meeting.entity.MeetingCustomerInfo;
import com.kuaike.scrm.dal.meeting.mapper.MeetingCustomerInfoMapper;
import com.kuaike.scrm.dal.meeting.mapper.MeetingMapper;
import com.kuaike.scrm.dal.meeting.mapper.MeetingSendDetailMapper;
import com.kuaike.scrm.dal.permission.mapper.UserMapper;
import com.kuaike.scrm.dal.wework.dto.ContactWeworkNumPair;
import com.kuaike.scrm.dal.wework.dto.UserContactInfo;
import com.kuaike.scrm.dal.wework.dto.WeworkUserInfo;
import com.kuaike.scrm.dal.wework.entity.WeworkChatRoom;
import com.kuaike.scrm.dal.wework.entity.WeworkContactRelation;
import com.kuaike.scrm.dal.wework.entity.WeworkUser;
import com.kuaike.scrm.dal.wework.mapper.WeworkContactRelationMapper;
import com.kuaike.scrm.dal.wework.mapper.WeworkUserMapper;
import com.kuaike.scrm.groupsend.dto.ContentDto;
import com.kuaike.scrm.groupsend.dto.SendDetailResp;
import com.kuaike.scrm.groupsend.dto.SendTargetDto;
import com.kuaike.scrm.groupsend.dto.request.AddOrModReq;
import com.kuaike.scrm.groupsend.dto.request.EditTaskStatusReq;
import com.kuaike.scrm.groupsend.dto.request.GroupSendDetailStatusReq;
import com.kuaike.scrm.groupsend.dto.request.GroupSendMarkReq;
import com.kuaike.scrm.groupsend.dto.request.GroupSendTaskListReq;
import com.kuaike.scrm.groupsend.dto.request.IdReq;
import com.kuaike.scrm.groupsend.dto.request.MultiSearchContactReq;
import com.kuaike.scrm.groupsend.dto.request.SendDetailListReq;
import com.kuaike.scrm.groupsend.dto.request.SendListReq;
import com.kuaike.scrm.groupsend.dto.response.AddOrModResp;
import com.kuaike.scrm.groupsend.dto.response.GroupSendDetailStatusRespDto;
import com.kuaike.scrm.groupsend.dto.response.GroupSendMarkResp;
import com.kuaike.scrm.groupsend.dto.response.GroupSendTargetResp;
import com.kuaike.scrm.groupsend.dto.response.GroupSendTaskListRespDto;
import com.kuaike.scrm.groupsend.dto.response.GroupSendWrapResp;
import com.kuaike.scrm.groupsend.dto.response.MsgGroupSendTaskProcessRespDto;
import com.kuaike.scrm.groupsend.dto.response.MultiSearchChatroomRespDto;
import com.kuaike.scrm.groupsend.dto.response.MultiSearchContactResp;
import com.kuaike.scrm.groupsend.dto.response.SendListResp;
import com.kuaike.scrm.groupsend.service.GroupSendDetailService;
import com.kuaike.scrm.groupsend.service.GroupSendFillService;
import com.kuaike.scrm.groupsend.service.GroupSendService;
import com.kuaike.scrm.groupsend.service.GroupSendTaskService;
import com.kuaike.scrm.groupsend.service.GroupSendWrapService;
import com.kuaike.scrm.groupsend.service.MultiSelectService;
import com.kuaike.scrm.material.dto.request.DelMaterialReqDto;
import com.kuaike.scrm.material.dto.request.QueryMaterialReqDto;
import com.kuaike.scrm.material.dto.response.MaterialListRespDto;
import com.kuaike.scrm.material.service.MaterialManagerService;
import com.kuaike.scrm.remind.dto.req.DisableRemindReqDto;
import com.kuaike.scrm.remind.service.RemindService;
import com.kuaike.scrm.service.MeetingUrlService;
import com.kuaike.scrm.wework.chatRoom.service.ChatRoomService;
import com.kuaike.scrm.wework.weworkUser.dto.response.WeworkUserNameRespDto;
import com.kuaike.scrm.wework.weworkUser.service.WeworkUserService;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.collections4.MapUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;

@Service
public class GroupSendServiceImpl
implements GroupSendService {
    private static final Logger log = LoggerFactory.getLogger(GroupSendServiceImpl.class);
    public static final String MEETING_PLACEHOLDER = "${customstr}";
    public static final String WEWORKUSER_PLACEHOLDER = "{\u6210\u5458\u6635\u79f0}";
    @Autowired
    private MessageGroupSendTaskMapper groupSendTaskMapper;
    @Autowired
    private MessageGroupSendDetailMapper groupSendDetailMapper;
    @Autowired
    private GroupSendDetailService groupSendDetailService;
    @Autowired
    private GroupSendTaskService groupSendTaskService;
    @Autowired
    private MessageGroupSopMapper sopMapper;
    @Autowired
    private RemindService remindService;
    @Autowired
    private UserRoleCommonService userRoleCommonService;
    @Autowired
    private WeworkTmpStoreMapper weworkTmpStoreMapper;
    @Autowired
    private MultiSelectService multiSelectService;
    @Autowired
    private WeworkUserService weworkUserService;
    @Autowired
    private ChatRoomService chatRoomService;
    @Autowired
    private MaterialManagerService materialManagerService;
    @Autowired
    private KafkaClientUtils kafkaClientUtils;
    @Autowired
    private UserMapper userMapper;
    @Value(value="${kafka.topic.meeting_group_send}")
    private String meetingGroupSendTopic;
    @Autowired
    private GroupSendWrapService groupSendWrapService;
    @Autowired
    private WeworkContactRelationMapper weworkContactRelationMapper;
    @Autowired
    private MarketingRewardMapper marketingRewardMapper;
    @Autowired
    private MarketingRewardStageMapper marketingRewardStageMapper;
    @Autowired
    private GroupSendFillService fillService;
    @Autowired
    private MessageGroupSendWeworkMapper grouSendWeworkMapper;
    @Autowired
    private WeworkUserMapper weworkUserMapper;
    @Autowired
    private MeetingMapper meetingMapper;
    @Resource
    private MeetingCustomerInfoMapper meetingCustomerInfoMapper;
    @Resource
    private MeetingUrlService meetingUrlService;
    @Resource
    MeetingSendDetailMapper meetingSendDetailMapper;
    public static final List<Integer> vipGroupSend = Lists.newArrayList((Object[])new Integer[]{GroupSendTaskType.VIP_GROUP_SEND_CHATROOM.getValue(), GroupSendTaskType.VIP_GROUP_SEND_CUSTOMER.getValue(), GroupSendTaskType.VIP_GROUP_SEND_NOTICE.getValue()});

    @Override
    public AddOrModResp addOrModGroupSend(AddOrModReq req) {
        CurrentUserInfo currentUserInfo = LoginUtils.getCurrentUser();
        log.info("addOrModGroupSend with req={},operatorId={}", (Object)req, (Object)currentUserInfo.getId());
        GroupSendWrapResp resp = this.groupSendWrapService.addOrModGroupSend(req);
        if (resp != null && resp.getOpType() != null) {
            this.sendMessageToKafka(resp.getTask(), resp.getOpType(), resp.isCreateByMeeting());
        }
        AddOrModResp addOrModResp = new AddOrModResp();
        addOrModResp.setTaskNum(resp != null ? resp.getTask().getNum() : null);
        return addOrModResp;
    }

    private void sendMessageToKafka(MessageGroupSendTask task, int opType, boolean isCreateByMeeting) {
        if (task.getFkTaskId() != null && task.getFkType() != null && task.getFkType() != 0) {
            try {
                GroupSendEntity entity = new GroupSendEntity();
                entity.setFkId(String.valueOf(task.getFkTaskId()));
                entity.setFkType(task.getFkType());
                entity.setTaskNum(task.getNum());
                entity.setTaskId(task.getId());
                entity.setOpType(opType);
                entity.setCreateByMeeting(isCreateByMeeting);
                log.info("push to kafka with groupsend entity={}", (Object)JSON.toJSONString((Object)entity));
                this.kafkaClientUtils.sendMessage(this.meetingGroupSendTopic, task.getNum(), JacksonUtils.getInstance().writeValueAsString((Object)entity));
            }
            catch (Exception e) {
                log.error("sendMessage to {} with error", (Object)this.meetingGroupSendTopic, (Object)e);
            }
        }
    }

    @Override
    @Transactional(rollbackFor={Exception.class}, propagation=Propagation.NESTED)
    public void deleteTask(IdReq req) {
        CurrentUserInfo currentUserInfo = LoginUtils.getCurrentUser();
        log.info("deleteTask with req={},operatorId={}", (Object)req, (Object)currentUserInfo.getId());
        req.validate();
        MessageGroupSendTask task = this.groupSendTaskMapper.queryByTaskNum(req.getTaskNum());
        if (task == null || task.getIsDeleted() == 1) {
            throw new BusinessException((UniverseErrorCode)CommonErrorCode.BUSINESS_ERROR, "\u7fa4\u53d1\u4efb\u52a1\u4e0d\u5b58\u5728");
        }
        if (!(task.getSendStatus() <= SendStatus.TO_BE_SEND.getValue())) {
            throw new BusinessException((UniverseErrorCode)CommonErrorCode.BUSINESS_ERROR, "\u6d88\u606f\u72b6\u6001\u4ec5\u4e3a\u5f85\u53d1\u9001\u7684\u4efb\u52a1\u53ef\u5220\u9664");
        }
        this.groupSendTaskMapper.logicDeleteById(task.getId(), currentUserInfo.getId());
        DisableRemindReqDto disableRemindReqDto = new DisableRemindReqDto(task.getId(), Integer.valueOf(2));
        this.remindService.disableRemind(disableRemindReqDto);
        DelMaterialReqDto reqDto = new DelMaterialReqDto();
        reqDto.setFkId(task.getId());
        reqDto.setFkType(Integer.valueOf(1));
        this.materialManagerService.delete(reqDto);
    }

    @Override
    @Transactional(rollbackFor={Exception.class}, propagation=Propagation.NESTED)
    public AddOrModResp editTaskStatus(EditTaskStatusReq req) {
        CurrentUserInfo currentUserInfo = LoginUtils.getCurrentUser();
        log.info("editTaskStatus with req={}", (Object)req);
        req.validate();
        MessageGroupSendTask task = this.groupSendTaskMapper.queryByTaskNum(req.getTaskNum());
        if (task == null || task.getIsDeleted() == 1) {
            throw new BusinessException((UniverseErrorCode)CommonErrorCode.BUSINESS_ERROR, "\u4efb\u52a1\u4e0d\u5b58\u5728");
        }
        List id2StatusCounts = this.groupSendDetailMapper.queryEveryStatusCountByTaskIds((Collection)Lists.newArrayList((Object[])new Long[]{task.getId()}));
        Id2StatusCount id2StatusCount = null;
        if (CollectionUtils.isNotEmpty((Collection)id2StatusCounts)) {
            id2StatusCount = (Id2StatusCount)id2StatusCounts.get(0);
        }
        if (req.getTaskStatus().equals(task.getTaskStatus())) {
            if (req.getTaskStatus().equals(TaskStatus.NORMAL.getValue())) {
                throw new BusinessException((UniverseErrorCode)CommonErrorCode.BUSINESS_ERROR, "\u4efb\u52a1\u5df2\u542f\u7528");
            }
            throw new BusinessException((UniverseErrorCode)CommonErrorCode.BUSINESS_ERROR, "\u4efb\u52a1\u5df2\u7981\u7528");
        }
        if (task.getTaskType().equals(GroupSendTaskType.QYAPI.getValue())) {
            if (req.getTaskStatus().equals(TaskStatus.BANED.getValue())) {
                Preconditions.checkArgument((boolean)task.getSendTime().after(new Date()), (Object)"\u7cfb\u7edf\u7fa4\u53d1\u4efb\u52a1\u5df2\u7ecf\u542f\u52a8\uff0c\u4e0d\u53ef\u7981\u7528");
            }
            if (req.getTaskStatus().equals(TaskStatus.NORMAL.getValue())) {
                Preconditions.checkArgument((boolean)task.getSendTime().after(new Date()), (Object)"\u6d88\u606f\u5df2\u7ecf\u8d85\u8fc7\u53d1\u9001\u65f6\u95f4\uff0c\u4e0d\u652f\u6301\u542f\u7528");
            }
        }
        if (req.getTaskStatus().equals(TaskStatus.BANED.getValue())) {
            if (task.getTaskStatus().equals(TaskStatus.BANED.getValue())) {
                throw new BusinessException((UniverseErrorCode)CommonErrorCode.BUSINESS_ERROR, "\u8be5\u4efb\u52a1\u5df2\u7ecf\u7981\u7528");
            }
            if (task.getSendStatus().intValue() == SendStatus.ALREADY_SEND.getValue() && id2StatusCount != null && id2StatusCount.getFailCount() + id2StatusCount.getExpireCount() == 0) {
                throw new BusinessException((UniverseErrorCode)CommonErrorCode.BUSINESS_ERROR, "\u5df2\u6267\u884c\u6210\u529f\u7684\u4efb\u52a1\u4e0d\u53ef\u7981\u7528");
            }
        }
        if (req.getTaskStatus().equals(TaskStatus.NORMAL.getValue()) && !task.getTaskStatus().equals(TaskStatus.BANED.getValue())) {
            throw new BusinessException((UniverseErrorCode)CommonErrorCode.BUSINESS_ERROR, "\u53ea\u6709\u7981\u7528\u4efb\u52a1\u53ef\u542f\u7528");
        }
        if (req.getTaskStatus().equals(TaskStatus.BANED.getValue())) {
            this.groupSendTaskService.disableTask(req.getTaskNum(), currentUserInfo.getId());
            DisableRemindReqDto disableRemindReqDto = new DisableRemindReqDto(task.getId(), Integer.valueOf(2));
            this.remindService.disableRemind(disableRemindReqDto);
        } else {
            this.groupSendTaskService.enableTask(req.getTaskNum(), currentUserInfo.getId());
        }
        this.updateFkLogic(currentUserInfo, task);
        return new AddOrModResp(task.getNum());
    }

    private void updateFkLogic(CurrentUserInfo currentUserInfo, MessageGroupSendTask task) {
        if (task.getFkType().equals(GroupSendFkType.SOP.getType())) {
            List<MessageGroupSendTask> tasks = this.queryEntityByFkTasks(task.getFkTaskId(), GroupSendFkType.getInstance((int)task.getFkType()));
            int bandSize = tasks.stream().filter(a -> a.getTaskStatus().equals(TaskStatus.BANED.getValue())).collect(Collectors.toList()).size();
            if (bandSize == tasks.size()) {
                this.sopMapper.updateTaskStatus(task.getFkTaskId(), TaskStatus.BANED.getValue(), currentUserInfo.getId());
            } else if (bandSize == 0) {
                this.sopMapper.updateTaskStatus(task.getFkTaskId(), TaskStatus.NORMAL.getValue(), currentUserInfo.getId());
            }
        }
    }

    @Override
    public List<GroupSendTaskListRespDto> taskList(GroupSendTaskListReq req) {
        List users;
        CurrentUserInfo currentUserInfo = LoginUtils.getCurrentUser();
        log.info("taskList with req={},operatorId={}", (Object)req, (Object)currentUserInfo.getId());
        List<Object> createBy = Lists.newArrayList();
        if (CollectionUtils.isNotEmpty(req.getCreateBy()) && CollectionUtils.isEmpty((Collection)(createBy = (users = this.userMapper.getUserInfoByNums(req.getCreateBy())).stream().map(a -> a.getId()).collect(Collectors.toList())))) {
            return Lists.newArrayList();
        }
        MsgGroupSendTaskQueryDto param = req.to(createBy);
        param.setManageUserIds(this.userRoleCommonService.getManageUserIds());
        param.setBizId(currentUserInfo.getBizId());
        param.setCorpId(currentUserInfo.getCorpId());
        param.setHideNotStartedUnArrive(YnEnum.YES.getValue());
        List groupSendTaskList = this.groupSendTaskMapper.queryByParam(param);
        if (CollectionUtils.isEmpty((Collection)groupSendTaskList)) {
            return new ArrayList<GroupSendTaskListRespDto>();
        }
        if (req.getPageDto() != null) {
            req.getPageDto().setCount(this.groupSendTaskMapper.queryTaskListCount(param));
            req.getPageDto().setCurPageCount(Integer.valueOf(groupSendTaskList.size()));
        }
        Set userIdSet = groupSendTaskList.stream().map(a -> a.getCreateBy()).collect(Collectors.toSet());
        userIdSet.addAll(groupSendTaskList.stream().map(a -> a.getUpdateBy()).collect(Collectors.toSet()));
        userIdSet.addAll(groupSendTaskList.stream().map(a -> a.getCreateBy()).collect(Collectors.toSet()));
        Map userId2EntityMap = this.weworkUserService.queryWeworkUserByUserIds(currentUserInfo.getCorpId(), userIdSet);
        List taskIds = groupSendTaskList.stream().map(a -> a.getId()).collect(Collectors.toList());
        Map taskFinishTimeMap = this.groupSendDetailMapper.queryTaskFinishTime(taskIds);
        List notStartDetails = this.groupSendDetailMapper.queryNotStartTaskDetailsByTaskId(taskIds);
        HashMap taskId2WeworkUserNameRespDto = Maps.newHashMap();
        Map taskId2SendPair = notStartDetails.stream().collect(Collectors.groupingBy(a -> a.getTaskId(), Collectors.mapping(a -> StringUtils.join((Object[])new String[]{a.getSendWeworkNum(), a.getReceiveId()}, (String)"##"), Collectors.toSet())));
        if (CollectionUtils.isNotEmpty(req.getTaskTypes()) && CollectionUtils.containsAny(req.getTaskTypes(), vipGroupSend)) {
            Map taskId2WeworkNums = this.groupSendDetailMapper.queryWeworkUserNumByTaskIds(taskIds);
            Set sendWeworkNums = taskId2WeworkNums.values().stream().flatMap(a -> a.stream()).collect(Collectors.toSet());
            Map userNum2Dto = this.weworkUserService.getWeworkUserNames((List)Lists.newArrayList(sendWeworkNums)).stream().collect(Collectors.toMap(WeworkUserNameRespDto::getWeworkUserId, Function.identity()));
            taskId2WeworkNums.forEach((taskId, weworkUserNums) -> {
                List list = weworkUserNums.stream().map(a -> (WeworkUserNameRespDto)userNum2Dto.get(a)).collect(Collectors.toList());
                taskId2WeworkUserNameRespDto.put(taskId, list);
            });
        }
        Map<Object, Object> taskId2Dto = Maps.newHashMap();
        if (CollectionUtils.isNotEmpty(taskIds)) {
            List id2StatusCounts = this.groupSendDetailMapper.queryStatusByTaskIds(taskIds, null, null);
            taskId2Dto = id2StatusCounts.stream().collect(Collectors.toMap(Id2StatusCount::getId, a -> {
                MsgGroupSendTaskProcessRespDto dto = new MsgGroupSendTaskProcessRespDto();
                dto.setTobeSendTaskNum(a.getTobeSendCount());
                dto.setExpireTaskNum(a.getExpireCount());
                dto.setAlreadySendTaskNum(a.getFinishedCount());
                dto.calAllTaskNumAndComplateTaskNum();
                return dto;
            }));
        }
        ArrayList resultList = Lists.newArrayList();
        for (MessageGroupSendTask task : groupSendTaskList) {
            Date finishTime = (Date)taskFinishTimeMap.get(task.getId());
            MsgGroupSendTaskProcessRespDto dto = null;
            if (task.getSendStatus() <= SendStatus.TO_BE_SEND.getValue()) {
                dto = (MsgGroupSendTaskProcessRespDto)taskId2Dto.get(task.getId());
                if (dto != null) {
                    Set<String> sendPair = this.multiSelectService.queryMultiSelectSendPair(task);
                    Set oldSendPair = taskId2SendPair.getOrDefault(task.getId(), Sets.newHashSet());
                    Collection unionSet = CollectionUtils.union(sendPair, (Iterable)oldSendPair);
                    Collection notCreateSet = CollectionUtils.subtract((Iterable)unionSet, (Iterable)oldSendPair);
                    dto.setTobeSendTaskNum(notCreateSet.size());
                    dto.calAllTaskNumAndComplateTaskNum();
                } else {
                    dto = new MsgGroupSendTaskProcessRespDto();
                    dto.setTobeSendTaskNum(task.getSendCount());
                    dto.calAllTaskNumAndComplateTaskNum();
                }
            } else {
                dto = (MsgGroupSendTaskProcessRespDto)taskId2Dto.get(task.getId());
                if (Objects.isNull(dto)) {
                    dto = new MsgGroupSendTaskProcessRespDto();
                    dto.setTobeSendTaskNum(task.getSendCount());
                    dto.calAllTaskNumAndComplateTaskNum();
                }
            }
            List list = (List)taskId2WeworkUserNameRespDto.get(task.getId());
            GroupSendTaskListRespDto item = this.buildGroupSendTaskListRespDto(userId2EntityMap, task, dto, list, finishTime);
            resultList.add(item);
        }
        return resultList;
    }

    @Override
    public Map<String, MsgGroupSendTaskProcessRespDto> buildTaskProcessDto(List<MessageGroupSendTask> taskList) {
        HashMap respDtoMap = Maps.newHashMap();
        if (CollectionUtils.isEmpty(taskList)) {
            return respDtoMap;
        }
        List taskIds = taskList.stream().map(a -> a.getId()).collect(Collectors.toList());
        List notStartDetails = this.groupSendDetailMapper.queryNotStartTaskDetailsByTaskId(taskIds);
        Map taskId2SendPair = notStartDetails.stream().collect(Collectors.groupingBy(a -> a.getTaskId(), Collectors.mapping(a -> StringUtils.join((Object[])new String[]{a.getSendWeworkNum(), a.getReceiveId()}, (String)"##"), Collectors.toSet())));
        Map<Object, Object> taskId2Dto = Maps.newHashMap();
        if (CollectionUtils.isNotEmpty(taskIds)) {
            List id2StatusCounts = this.groupSendDetailMapper.queryStatusByTaskIds(taskIds, null, null);
            taskId2Dto = id2StatusCounts.stream().collect(Collectors.toMap(Id2StatusCount::getId, a -> {
                MsgGroupSendTaskProcessRespDto dto = new MsgGroupSendTaskProcessRespDto();
                dto.setTobeSendTaskNum(a.getTobeSendCount());
                dto.setExpireTaskNum(a.getExpireCount());
                dto.setAlreadySendTaskNum(a.getFinishedCount());
                dto.calAllTaskNumAndComplateTaskNum();
                return dto;
            }));
        }
        for (MessageGroupSendTask task : taskList) {
            MsgGroupSendTaskProcessRespDto dto = null;
            if (task.getSendStatus() <= SendStatus.TO_BE_SEND.getValue()) {
                dto = (MsgGroupSendTaskProcessRespDto)taskId2Dto.get(task.getId());
                if (dto != null) {
                    Set<String> sendPair = this.multiSelectService.queryMultiSelectSendPair(task);
                    Set oldSendPair = taskId2SendPair.getOrDefault(task.getId(), Sets.newHashSet());
                    Collection unionSet = CollectionUtils.union(sendPair, (Iterable)oldSendPair);
                    Collection notCreateSet = CollectionUtils.subtract((Iterable)unionSet, (Iterable)oldSendPair);
                    dto.setTobeSendTaskNum(notCreateSet.size());
                    dto.calAllTaskNumAndComplateTaskNum();
                } else {
                    dto = new MsgGroupSendTaskProcessRespDto();
                    dto.setTobeSendTaskNum(task.getSendCount());
                    dto.calAllTaskNumAndComplateTaskNum();
                }
            } else {
                dto = (MsgGroupSendTaskProcessRespDto)taskId2Dto.get(task.getId());
            }
            respDtoMap.put(task.getNum(), dto);
        }
        return respDtoMap;
    }

    @Override
    public void statusExport(GroupSendDetailStatusReq req, HttpServletResponse response) throws Exception {
        List<GroupSendDetailStatusRespDto> statusRespDtos = this.taskStatus(req);
        statusRespDtos.stream().forEach(item -> {
            if (Objects.nonNull(item.getStatusValue())) {
                ArrayList toBeSend;
                SendStatus type = SendStatus.getType((Integer)item.getStatusValue());
                ArrayList failType = Lists.newArrayList((Object[])new Integer[]{SendStatus.SEND_FAIL.getValue(), SendStatus.ALREADY_EXPIRE.getValue()});
                if (failType.contains(type.getValue())) {
                    item.setStatusStr(SendStatus.SEND_FAIL.getDesc());
                }
                if ((toBeSend = Lists.newArrayList((Object[])new Integer[]{SendStatus.TO_BE_SEND.getValue(), SendStatus.TO_BE_SEND.getValue()})).contains(type.getValue())) {
                    item.setStatusStr(SendStatus.TO_BE_SEND.getDesc());
                }
            }
        });
        BackendExcelUtils.doListToExcel((HttpServletResponse)response, statusRespDtos, this.buildExportHeader(), (String)"\u7fa4\u53d1\u8be6\u60c5", (String)"\u7fa4\u53d1\u8be6\u60c5");
    }

    private List<ExcelHeader> buildExportHeader() {
        ArrayList headers = Lists.newArrayList();
        headers.add(new ExcelHeader("sendWeworkNickName", "\u53d1\u9001\u65b9"));
        headers.add(new ExcelHeader("receiveName", "\u63a5\u6536\u65b9"));
        headers.add(new ExcelHeader("sendTime", "\u53ef\u53d1\u9001\u5f00\u59cb\u65f6\u95f4"));
        headers.add(new ExcelHeader("deadlineTime", "\u53ef\u53d1\u9001\u622a\u6b62\u65f6\u95f4"));
        headers.add(new ExcelHeader("sendCompleteTime", "\u5b9e\u9645\u53d1\u9001\u65f6\u95f4"));
        headers.add(new ExcelHeader("statusStr", "\u6d88\u606f\u53d1\u9001\u72b6\u6001"));
        headers.add(new ExcelHeader("remark", "\u5931\u8d25\u539f\u56e0"));
        return headers;
    }

    private GroupSendTaskListRespDto buildGroupSendTaskListRespDto(Map<Long, WeworkUserInfo> userId2EntityMap, MessageGroupSendTask task, MsgGroupSendTaskProcessRespDto dto, List<WeworkUserNameRespDto> list, Date finishTime) {
        GroupSendTaskListRespDto item = new GroupSendTaskListRespDto();
        item.setTaskNum(task.getNum());
        item.setFkTaskId(task.getFkTaskId());
        item.setSendStatus(SendStatus.getTypeForWeb((Integer)task.getSendStatus()).getValue());
        item.setSendTime(task.getSendTime());
        item.setSendType(task.getSendType());
        item.setFkType(task.getFkType());
        item.setContent(task.getContent());
        item.setDeadlineTime(task.getDeadline());
        item.setTaskName(task.getName());
        item.setTaskStatus(task.getTaskStatus());
        item.setQueryType(task.getQueryType());
        WeworkUserInfo userInfo = userId2EntityMap.get(task.getUpdateBy());
        item.setUpdatorName(userInfo != null ? userInfo.getNameFirst() : "");
        item.setUpdateTime(task.getUpdateTime());
        WeworkUserInfo creatorInfo = userId2EntityMap.get(task.getCreateBy());
        item.setCreatorName(creatorInfo != null ? creatorInfo.getNameFirst() : "");
        item.setCreateTime(task.getCreateTime());
        item.setTaskType(task.getTaskType());
        item.setProcessDto(dto);
        item.setWeworkUserList(list);
        item.setTaskId(task.getId());
        item.setFinishTime(finishTime);
        return item;
    }

    @Override
    public List<GroupSendDetailStatusRespDto> taskStatus(GroupSendDetailStatusReq req) {
        CurrentUserInfo currentUserInfo = new CurrentUserInfo();
        log.info("taskStatus with req={},operatorId={}", (Object)req, (Object)currentUserInfo.getId());
        if (StringUtils.isBlank((CharSequence)req.getTaskNum())) {
            return Lists.newArrayList();
        }
        req.validate();
        MessageGroupSendTask task = this.groupSendTaskMapper.queryByTaskNum(req.getTaskNum());
        if (task == null || task.getIsDeleted() == 1) {
            throw new BusinessException((UniverseErrorCode)CommonErrorCode.BUSINESS_ERROR, "\u4efb\u52a1\u4e0d\u5b58\u5728");
        }
        Long existsDetailId = this.groupSendDetailMapper.existsTask(task.getId());
        ArrayList result = Lists.newArrayList();
        if (task.getTaskType().equals(GroupSendTaskType.CLIENT.getValue()) && task.getSendStatus() < SendStatus.SENDING.getValue() && (Objects.isNull(req.getDetailStatus()) || req.getDetailStatus().equals(SendStatus.TO_BE_SEND.getValue()))) {
            return this.fillSendWeworkUserInfo(req, task, result);
        }
        if (existsDetailId != null && task.getSendStatus() <= SendStatus.TO_BE_SEND.getValue() && !task.getTaskStatus().equals(GroupSendTaskType.CLIENT.getValue()) && req.getDetailStatus() != null) {
            if (req.getDetailStatus().equals(SendStatus.TO_BE_SEND.getValue())) {
                ArrayList result1 = this.queryNotStartDetail(req, currentUserInfo, task, result);
                return result1 != null ? result1 : result;
            }
            if (req.getDetailStatus().equals(SendStatus.ALREADY_SEND.getValue())) {
                this.queryDetail(req, task, result);
                return result;
            }
            return result;
        }
        if (existsDetailId == null && task.getSendStatus() <= SendStatus.TO_BE_SEND.getValue() && !task.getTaskStatus().equals(GroupSendTaskType.CLIENT.getValue())) {
            if (task.getFkType().equals(GroupSendFkType.UN_ARRIVE_MEETING.getType())) {
                return Lists.newArrayList();
            }
            List<GroupSendDetailStatusRespDto> result1 = this.queryNotStartDetail(req, currentUserInfo, task, result);
            if (result1 != null) {
                return result1;
            }
        }
        this.queryDetail(req, task, result);
        return result;
    }

    private List<GroupSendDetailStatusRespDto> queryNotStartDetail(GroupSendDetailStatusReq req, CurrentUserInfo currentUserInfo, MessageGroupSendTask task, List<GroupSendDetailStatusRespDto> result) {
        if (Objects.nonNull(req.getDetailStatus()) && !req.getDetailStatus().equals(SendStatus.TO_BE_SEND.getValue())) {
            return result;
        }
        if (StringUtils.isNotBlank((CharSequence)task.getQueryRequestId()) && this.getResultFromCache(req, task, result, task.getQueryRequestId())) {
            return result;
        }
        ArrayList remindDetailReqDtos = Lists.newArrayList();
        AtomicReference<String> requestIdStore = new AtomicReference<String>();
        AddOrModReq req1 = null;
        try {
            req1 = (AddOrModReq)JacksonUtils.getInstance().readValue(task.getParamsJson(), AddOrModReq.class);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        req1.resetQuery();
        int sendCount = 0;
        if (!(task.getTaskType().equals(GroupSendTaskType.CLIENT.getValue()) || task.getTaskType().intValue() == GroupSendTaskType.QYAPI.getValue() && task.getQueryType().equals(QueryType.CHAT_ROOM.getType()))) {
            sendCount = this.groupSendWrapService.buildRemindDetailReqDtos(req1, currentUserInfo, remindDetailReqDtos, requestIdStore);
            task.setSendCount(Integer.valueOf(sendCount));
            task.setQueryRequestId(requestIdStore.get());
            this.groupSendTaskMapper.updateByPrimaryKeySelective((Object)task);
        }
        if (task.getTaskType().equals(GroupSendTaskType.QYAPI.getValue()) && task.getQueryType().equals(QueryType.CHAT_ROOM.getType())) {
            return this.fillSendWeworkUserInfo(req, task, result);
        }
        if (this.getResultFromCache(req, task, result, requestIdStore.get())) {
            return result;
        }
        return null;
    }

    private List<GroupSendDetailStatusRespDto> fillSendWeworkUserInfo(GroupSendDetailStatusReq req, MessageGroupSendTask task, List<GroupSendDetailStatusRespDto> result) {
        AddOrModReq req1 = null;
        try {
            req1 = (AddOrModReq)JacksonUtils.getInstance().readValue(task.getParamsJson(), AddOrModReq.class);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        Map userNum2Dto = this.weworkUserService.getWeworkUserNames((List)Lists.newArrayList(req1.getWeworkUserNums())).stream().collect(Collectors.toMap(WeworkUserNameRespDto::getWeworkUserId, Function.identity()));
        List weworkUserNums = Lists.newArrayList(req1.getWeworkUserNums()).stream().sorted().collect(Collectors.toList());
        List pageList = null;
        if (req.getPageDto() != null) {
            PageDto pageDto = req.getPageDto();
            int start = Math.min(pageDto.getOffset(), weworkUserNums.size());
            int end = Math.min(pageDto.getPageSize() + pageDto.getOffset(), weworkUserNums.size());
            pageList = weworkUserNums.subList(start, end);
        } else {
            pageList = weworkUserNums;
        }
        for (String weworkUserNum : pageList) {
            GroupSendDetailStatusRespDto dto = new GroupSendDetailStatusRespDto();
            if (task.getQueryType().equals(QueryType.CHAT_ROOM.getType())) {
                dto.setTargetType(ReceiveType.CHATROOM.getType());
            } else {
                dto.setTargetType(ReceiveType.CONTACT.getType());
            }
            dto.setStatusValue(SendStatus.TO_BE_SEND.getValue());
            dto.setStatusStr(SendStatus.TO_BE_SEND.getDesc());
            dto.setId(null);
            dto.setSendTime(task.getSendTime());
            dto.setDeadlineTime(task.getDeadline());
            dto.setSendCompleteTime(null);
            WeworkUserNameRespDto dto1 = (WeworkUserNameRespDto)userNum2Dto.get(weworkUserNum);
            dto.setSendWeworkNickName(dto1 != null ? dto1.getUserName() : "");
            dto.setTaskType(task.getTaskType());
            dto.setContent(task.getContent());
            result.add(dto);
        }
        if (req.getPageDto() != null) {
            req.getPageDto().setCount(Integer.valueOf(req1.getWeworkUserNums().size()));
        }
        return result;
    }

    private boolean getResultFromCache(GroupSendDetailStatusReq req, MessageGroupSendTask task, List<GroupSendDetailStatusRespDto> result, String requestId) {
        WeworkTmpStore tmpStore = this.weworkTmpStoreMapper.queryByRequestId(requestId);
        if (tmpStore != null) {
            switch (tmpStore.getQueryType()) {
                case 1: 
                case 3: {
                    this.contactDetailList(req, task, result, tmpStore);
                    return true;
                }
                case 2: {
                    this.chatroomDetailList(req, task, result, tmpStore);
                    return true;
                }
            }
        }
        return false;
    }

    private void queryDetail(GroupSendDetailStatusReq req, MessageGroupSendTask task, List<GroupSendDetailStatusRespDto> result) {
        ArrayList detailsStatusList = Lists.newArrayList();
        if (req.getDetailStatus() != null) {
            if (req.getDetailStatus().equals(SendStatus.ALREADY_EXPIRE.getValue())) {
                detailsStatusList.add(SendStatus.ALREADY_EXPIRE.getValue());
                detailsStatusList.add(SendStatus.SEND_FAIL.getValue());
            } else if (req.getDetailStatus().equals(SendStatus.TO_BE_SEND.getValue())) {
                detailsStatusList.add(SendStatus.TO_BE_SEND.getValue());
                detailsStatusList.add(SendStatus.SENDING.getValue());
            } else {
                detailsStatusList.add(req.getDetailStatus());
            }
        } else {
            detailsStatusList = null;
        }
        List list = this.groupSendDetailMapper.queryByTaskId(task.getId(), (Collection)detailsStatusList, req.getPageDto());
        if (req.getPageDto() != null) {
            int count = this.groupSendDetailMapper.queryCountByTaskId(task.getId(), (Collection)detailsStatusList);
            req.getPageDto().setCount(Integer.valueOf(count));
            req.getPageDto().setCurPageCount(Integer.valueOf(list.size()));
        }
        if (CollectionUtils.isEmpty((Collection)list)) {
            return;
        }
        HashMap detailId2RoomStr = Maps.newHashMap();
        Map<Long, String> detailId2SendTarget = list.stream().filter(a -> StringUtils.isNotBlank((CharSequence)a.getSendTarget())).collect(Collectors.toMap(a -> a.getId(), a -> a.getSendTarget()));
        Set targetChatroomIds = list.stream().filter(a -> StringUtils.isNotBlank((CharSequence)a.getSendTarget())).map(a -> StringUtils.split((String)a.getSendTarget(), (String)",")).flatMap(a -> Arrays.stream(a)).collect(Collectors.toSet());
        if (CollectionUtils.isNotEmpty(targetChatroomIds)) {
            List chatRoomList = this.chatRoomService.selectRoomList(task.getCorpId(), task.getBizId(), targetChatroomIds);
            Map<String, WeworkChatRoom> chatroomId2Item = chatRoomList.stream().collect(Collectors.toMap(a -> a.getWeworkRoomId(), a -> a));
            detailId2SendTarget.forEach((detailId, sendTargetStr) -> {
                String[] targets = sendTargetStr.split(",");
                ArrayList targetNames = Lists.newArrayList();
                for (String target : targets) {
                    WeworkChatRoom room = (WeworkChatRoom)chatroomId2Item.get(target);
                    if (room == null) continue;
                    targetNames.add(room.getName());
                }
                detailId2RoomStr.put(detailId, StringUtils.join((Iterable)targetNames, (String)","));
            });
        }
        Set sendWeworkNum = list.stream().map(a -> a.getSendWeworkNum()).collect(Collectors.toSet());
        Map userNum2Dto = this.weworkUserService.getWeworkUserNames((List)Lists.newArrayList(sendWeworkNum)).stream().collect(Collectors.toMap(WeworkUserNameRespDto::getWeworkUserId, Function.identity()));
        List receiverIds = list.stream().map(a -> a.getReceiveId()).collect(Collectors.toList());
        Map chatroomId2Entity = null;
        Map contactId2Entity = null;
        if (task.getQueryType().equals(QueryType.CHAT_ROOM.getType())) {
            List chatRoomList = this.chatRoomService.selectRoomList(task.getCorpId(), task.getBizId(), receiverIds);
            chatroomId2Entity = chatRoomList.stream().collect(Collectors.toMap(WeworkChatRoom::getWeworkRoomId, Function.identity()));
        } else {
            List contactWeworkNumPairs = list.stream().map(a -> new ContactWeworkNumPair(a.getSendWeworkNum(), a.getReceiveId())).collect(Collectors.toList());
            contactId2Entity = this.weworkContactRelationMapper.queryContactInfoByWeworkUserNumAndNameQuery(task.getCorpId(), null, contactWeworkNumPairs).stream().collect(Collectors.toMap(UserContactInfo::getContactId, Function.identity()));
        }
        for (MessageGroupSendDetail item : list) {
            GroupSendDetailStatusRespDto dto = new GroupSendDetailStatusRespDto();
            if (task.getFkType().equals(GroupSendFkType.MEETING.getType()) && StringUtils.isNotBlank((CharSequence)item.getExtField1())) {
                dto.setContent(task.getContent().replace(MEETING_PLACEHOLDER, item.getExtField1()));
            } else {
                dto.setContent(task.getContent());
            }
            dto.setTargetType(item.getReceiveType());
            if (item.getReceiveType().equals(ReceiveType.CHATROOM.getType())) {
                if (StringUtils.equals((CharSequence)item.getReceiveId(), (CharSequence)"emptyReceiverId")) {
                    String roomStr = (String)detailId2RoomStr.get(item.getId());
                    dto.setReceiveName(StringUtils.isNotBlank((CharSequence)roomStr) ? roomStr : "");
                } else {
                    WeworkChatRoom chatRoom = (WeworkChatRoom)chatroomId2Entity.get(item.getReceiveId());
                    dto.setCorpName("");
                    dto.setReceiveAvatar("");
                    if (chatRoom != null) {
                        dto.setReceiveName(chatRoom.getName());
                    } else {
                        dto.setReceiveName("");
                    }
                }
            } else if (contactId2Entity != null) {
                UserContactInfo contact = (UserContactInfo)contactId2Entity.get(item.getReceiveId());
                if (contact != null) {
                    dto.setCorpName(contact.getCorpName());
                    dto.setReceiveAvatar(contact.getAvatar());
                    dto.setReceiveName(contact.getRemarkFirst());
                } else {
                    dto.setReceiveName("");
                    dto.setCorpName("");
                    dto.setReceiveAvatar("");
                }
            }
            dto.setStatusValue(item.getStatus());
            dto.setStatusStr(SendStatus.getType((Integer)item.getStatus()).getDesc());
            dto.setId(item.getId());
            dto.setSendTime(task.getSendTime());
            dto.setDeadlineTime(task.getDeadline());
            dto.setSendCompleteTime(item.getSendCompleteTime());
            WeworkUserNameRespDto dto1 = (WeworkUserNameRespDto)userNum2Dto.get(item.getSendWeworkNum());
            dto.setSendWeworkNickName(dto1 != null ? dto1.getUserName() : "");
            dto.setTaskType(item.getTaskType());
            dto.setRemark(item.getRemark());
            result.add(dto);
        }
    }

    private void contactDetailList(GroupSendDetailStatusReq req, MessageGroupSendTask task, List<GroupSendDetailStatusRespDto> result, WeworkTmpStore tmpStore) {
        String contactJson = tmpStore.getStoreBody();
        List contactList = JSONArray.parseArray((String)contactJson, SelectedContact2WeworkUserDto.class);
        Function<SelectedContact2WeworkUserDto, String> contactFunction = SelectedContact2WeworkUserDto::getContactId;
        contactList = this.multiSelectService.pageResult(req.getPageDto(), contactList, contactFunction);
        if (CollectionUtils.isEmpty((Collection)contactList)) {
            return;
        }
        List contactWeworkNumPairs = contactList.stream().map(a -> new ContactWeworkNumPair(a.getWeworkNum(), a.getContactId())).collect(Collectors.toList());
        Map contactId2Entity = this.weworkContactRelationMapper.queryContactInfoByWeworkUserNumAndNameQuery(task.getCorpId(), null, contactWeworkNumPairs).stream().collect(Collectors.toMap(UserContactInfo::getContactId, Function.identity()));
        for (SelectedContact2WeworkUserDto item : contactList) {
            GroupSendDetailStatusRespDto dto = new GroupSendDetailStatusRespDto();
            dto.setContent(task.getContent());
            dto.setTargetType(0);
            UserContactInfo weworkContact = (UserContactInfo)contactId2Entity.get(item.getContactId());
            if (weworkContact != null) {
                dto.setCorpName(weworkContact.getCorpName());
                dto.setReceiveName(StringUtils.isNotBlank((CharSequence)weworkContact.getRemark()) ? weworkContact.getRemark() : weworkContact.getOriginName());
                dto.setReceiveAvatar(item.getContactAvatar());
            }
            dto.setStatusValue(SendStatus.TO_BE_SEND.getValue());
            dto.setSendCompleteTime(null);
            dto.setSendTime(task.getSendTime());
            dto.setDeadlineTime(task.getDeadline());
            dto.setSendWeworkNickName(item.getWeworkName());
            result.add(dto);
        }
    }

    private void chatroomDetailList(GroupSendDetailStatusReq req, MessageGroupSendTask task, List<GroupSendDetailStatusRespDto> result, WeworkTmpStore tmpStore) {
        String chatroomJson = tmpStore.getStoreBody();
        List chatroomList = JSONArray.parseArray((String)chatroomJson, SelectedChatroom2WeworkUserDto.class);
        Function<SelectedChatroom2WeworkUserDto, String> chatroomFunction = SelectedChatroom2WeworkUserDto::getChatroomId;
        chatroomList = this.multiSelectService.pageResult(req.getPageDto(), chatroomList, chatroomFunction);
        for (SelectedChatroom2WeworkUserDto item : chatroomList) {
            GroupSendDetailStatusRespDto dto = new GroupSendDetailStatusRespDto();
            dto.setContent(task.getContent());
            dto.setTargetType(1);
            dto.setCorpName("");
            dto.setReceiveAvatar("");
            dto.setReceiveName(item.getChatroomName());
            dto.setStatusValue(SendStatus.TO_BE_SEND.getValue());
            dto.setSendCompleteTime(null);
            dto.setSendTime(task.getSendTime());
            dto.setDeadlineTime(task.getDeadline());
            dto.setSendWeworkNickName(item.getWeworkName());
            result.add(dto);
        }
    }

    @Override
    public AddOrModReq taskParamDetail(IdReq req) {
        CurrentUserInfo currentUserInfo = LoginUtils.getCurrentUser();
        log.info("taskParamDetail with req={},operatorId={}", (Object)req, (Object)currentUserInfo.getId());
        req.validate();
        MessageGroupSendTask task = this.groupSendTaskMapper.queryByTaskNum(req.getTaskNum());
        if (Objects.isNull(task) || task.getIsDeleted() == null) {
            return null;
        }
        Long bizId = currentUserInfo.getBizId();
        String corpId = currentUserInfo.getCorpId();
        AddOrModReq result = null;
        try {
            result = (AddOrModReq)JacksonUtils.getInstance().readValue(task.getParamsJson(), AddOrModReq.class);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        if (task.getFkType().equals(GroupSendFkType.MEETING.getType())) {
            Meeting meeting = (Meeting)this.meetingMapper.selectByPrimaryKey((Object)task.getFkTaskId());
            result.setInviteInfoType(meeting.getInviteInfoType());
            log.info("taskParamDetail get meeting: {}", (Object)task.getFkTaskId());
        }
        result.setTaskNum(task.getNum());
        result.setSendCount(task.getSendCount());
        if (CollectionUtils.isNotEmpty(result.getWeworkUserNums())) {
            List weworkUserDtos = this.weworkUserService.queryWeworkUserInfoByNums((List)Lists.newArrayList(result.getWeworkUserNums()));
            result.setWeworkUserInfos(weworkUserDtos);
        }
        if (task.getFkType().equals(GroupSendFkType.UN_ARRIVE_MEETING.getType())) {
            MultiSearchContactReq contactReq = this.convert(task, result.getGroupsendContact());
            result.setGroupsendContact(contactReq);
        }
        if (task.getTaskType().intValue() != GroupSendTaskType.CLIENT.getValue()) {
            switch (QueryType.getByType((int)result.getQueryType())) {
                case CONTACT: {
                    result.setGroupsendContact(this.fillService.fillContact(bizId, corpId, result.getGroupsendContact()));
                    break;
                }
                case CHAT_ROOM: {
                    if (!task.getTaskType().equals(GroupSendTaskType.QYAPI.getValue())) {
                        result.setGroupsendChatRoom(this.fillService.fillChatroom(corpId, result.getGroupsendChatRoom()));
                        break;
                    }
                    result.setGroupsendChatRoom(null);
                    break;
                }
                case QRCODE: {
                    result.setGroupsendQrCodeContact(this.fillService.fillQrCode(bizId, corpId, result.getGroupsendQrCodeContact()));
                }
            }
        }
        return result;
    }

    public MultiSearchContactReq convert(MessageGroupSendTask task, MultiSearchContactReq originMultiContact) {
        List sendDetails = this.groupSendDetailMapper.queryByTaskId(task.getId(), null, null);
        Set<String> alreadyReceiveContactIds = sendDetails.stream().map(item -> item.getReceiveId()).collect(Collectors.toSet());
        Set sendWeworkNum = sendDetails.stream().map(item -> item.getSendWeworkNum()).collect(Collectors.toSet());
        Map weworkUserNum2IdMap = this.weworkUserMapper.selectWeworkUserNumAndIdByNums(sendWeworkNum);
        if (MapUtils.isEmpty((Map)weworkUserNum2IdMap)) {
            log.warn("\u6839\u636eweworkUserNums:{}\u672a\u83b7\u53d6\u5230weworkUserIds", sendWeworkNum);
        }
        Collection<String> weworkUserIds = weworkUserNum2IdMap.values();
        Integer onlyVip = 0;
        if (vipGroupSend.contains(task.getTaskType())) {
            onlyVip = 1;
        }
        List<WeworkContactRelation> allContactRel = this.multiSelectService.searchAllContact(task.getCorpId(), weworkUserIds, alreadyReceiveContactIds, onlyVip);
        Set<String> allContactIds = allContactRel.stream().map(WeworkContactRelation::getContactId).collect(Collectors.toSet());
        MultiSearchContactReq groupsendContact = Optional.ofNullable(originMultiContact).orElseGet(MultiSearchContactReq::new);
        if (CollectionUtils.isNotEmpty(groupsendContact.getExcludeContactIds())) {
            allContactIds.addAll(groupsendContact.getExcludeContactIds());
        }
        groupsendContact.setExcludeContactIds(allContactIds);
        groupsendContact.setWeworkUserNums(Lists.newArrayList(sendWeworkNum));
        return groupsendContact;
    }

    @Override
    public GroupSendMarkResp markSend(GroupSendMarkReq req) {
        CurrentUserInfo currentUserInfo = LoginUtils.getCurrentUser();
        log.info("markSend with req={},operatorId={}", (Object)req, (Object)currentUserInfo);
        req.validate();
        MessageGroupSendDetail groupSendDetail = (MessageGroupSendDetail)this.groupSendDetailMapper.selectByPrimaryKey((Object)req.getDetailId());
        if (groupSendDetail == null || groupSendDetail.getIsDeleted() == 1) {
            return new GroupSendMarkResp(1, "detail\u4e0d\u5b58\u5728");
        }
        MessageGroupSendTask task = (MessageGroupSendTask)this.groupSendTaskMapper.selectByPrimaryKey((Object)groupSendDetail.getTaskId());
        if (task == null || task.getIsDeleted() == 1) {
            return new GroupSendMarkResp(1, "\u4efb\u52a1\u4e0d\u5b58\u5728");
        }
        if (task.getSendStatus().equals(SendStatus.ALREADY_SEND.getValue())) {
            return new GroupSendMarkResp(1, "\u4efb\u52a1\u5df2\u7ed3\u675f");
        }
        this.groupSendDetailService.updateSendCompleteByIds(task, Lists.newArrayList((Object[])new Long[]{req.getDetailId()}), SendStatus.ALREADY_SEND.getValue());
        List id2StatusCounts = this.groupSendDetailMapper.queryStatusByTaskIds((Collection)Lists.newArrayList((Object[])new Long[]{task.getId()}), null, null);
        Id2StatusCount id2StatusCount = (Id2StatusCount)id2StatusCounts.get(0);
        if (task.getSendStatus().equals(SendStatus.SENDING.getValue()) && id2StatusCount.getAllCount().equals(id2StatusCount.getExpireCount() + id2StatusCount.getFinishedCount())) {
            this.groupSendTaskService.updateGroupSendTask(task, null, SendStatus.ALREADY_SEND.getValue());
        } else if (task.getSendStatus().equals(SendStatus.TO_BE_SEND.getValue()) && id2StatusCount.getAllCount() > id2StatusCount.getTobeSendCount()) {
            this.groupSendTaskService.updateGroupSendTask(task, null, SendStatus.SENDING.getValue());
        }
        return new GroupSendMarkResp(0, "\u6807\u8bb0\u6210\u529f");
    }

    @Override
    public void updateTaskStatus(Collection<Long> taskIds) {
        log.info("updateTaskStatus with taskIds={}", taskIds);
        if (CollectionUtils.isEmpty(taskIds)) {
            return;
        }
        Map<Long, MessageGroupSendTask> taskId2Task = this.groupSendTaskMapper.queryByIds(taskIds).stream().collect(Collectors.toMap(a -> a.getId(), a -> a));
        List id2StatusCounts = this.groupSendDetailMapper.queryStatusByTaskIds(taskIds, null, null);
        for (Id2StatusCount id2StatusCount : id2StatusCounts) {
            MessageGroupSendTask task = taskId2Task.get(id2StatusCount.getId());
            if (task.getSendStatus().equals(SendStatus.SENDING.getValue()) && id2StatusCount.getAllCount().equals(id2StatusCount.getExpireCount() + id2StatusCount.getFinishedCount())) {
                this.groupSendTaskService.updateGroupSendTask(task, null, SendStatus.ALREADY_SEND.getValue());
                continue;
            }
            if (task.getSendStatus() > SendStatus.TO_BE_SEND.getValue() || id2StatusCount.getAllCount() <= id2StatusCount.getTobeSendCount()) continue;
            this.groupSendTaskService.updateGroupSendTask(task, null, SendStatus.SENDING.getValue());
        }
    }

    @Override
    public List<SendListResp> sendList(SendListReq req) {
        StopWatchDto timer = new StopWatchDto("sendList", true, log);
        CurrentUserInfo currentUserInfo = LoginUtils.getCurrentUser();
        if (StringUtils.isEmpty((CharSequence)req.getWeworkUserNum())) {
            timer.start("getWeworkUserNumById");
            String weworkUserNum = this.weworkUserService.getWeworkUserNumById(currentUserInfo.getCorpId(), currentUserInfo.getWeworkUserId());
            timer.stop();
            req.setWeworkUserNum(weworkUserNum);
        }
        if (req.getCorpId() == null) {
            req.setCorpId(currentUserInfo.getCorpId());
        }
        Long bizId = currentUserInfo.getBizId();
        String corpId = currentUserInfo.getCorpId();
        log.info("sendList with req={},operatorId={}", (Object)req, (Object)currentUserInfo.getId());
        req.validate();
        ArrayList sendStatusList = Lists.newArrayList();
        sendStatusList.add(SendStatus.TO_BE_SEND.getValue());
        sendStatusList.add(SendStatus.TO_BE_QUERY.getValue());
        sendStatusList.add(SendStatus.SENDING.getValue());
        timer.start("queryTaskIdByWeworkNumAndTime");
        Object taskType = null;
        List sortedTaskIds = this.groupSendTaskMapper.queryNeedSendTasks(corpId, req.getSendTime(), (Collection)sendStatusList, req.getWeworkUserNum(), req.getPageDto());
        timer.stop();
        if (req.getPageDto() != null) {
            timer.start("queryCountByWeworkNumAndTime");
            int count = this.groupSendTaskMapper.countNeedSendTasks(corpId, req.getSendTime(), (Collection)sendStatusList, req.getWeworkUserNum());
            timer.stop();
            req.getPageDto().setCount(Integer.valueOf(count));
            req.getPageDto().setCurPageCount(Integer.valueOf(sortedTaskIds.size()));
        }
        if (CollectionUtils.isEmpty((Collection)sortedTaskIds)) {
            timer.print();
            return Lists.newArrayList();
        }
        Set taskIds = sortedTaskIds.stream().collect(Collectors.toSet());
        if (CollectionUtils.isEmpty(taskIds)) {
            timer.print();
            return Lists.newArrayList();
        }
        timer.start("queryStatusByTaskIds");
        List id2StatusCounts = this.groupSendDetailMapper.queryStatusByTaskIds(taskIds, req.getWeworkUserNum(), (Collection)Lists.newArrayList((Object[])new Integer[]{GroupSendTaskType.SIDEBAR.getValue(), GroupSendTaskType.CLIENT.getValue()}));
        timer.stop();
        timer.start("selectBySimple");
        MessageGroupSendTaskCriteria taskCriteria = new MessageGroupSendTaskCriteria();
        taskCriteria.createCriteria().andIdIn((List)Lists.newArrayList(taskIds));
        List taskList = this.groupSendTaskMapper.selectByExample((Object)taskCriteria);
        timer.stop();
        List reqDtos = taskList.stream().map(a -> {
            QueryMaterialReqDto dto = new QueryMaterialReqDto();
            dto.setFkId(a.getId());
            dto.setFkType(Integer.valueOf(1));
            return dto;
        }).collect(Collectors.toList());
        timer.start("query");
        List materialListRespDtoList = this.materialManagerService.query(bizId, corpId, reqDtos);
        timer.stop();
        Map<Long, MaterialListRespDto> taskId2MaterialList = materialListRespDtoList.stream().collect(Collectors.toMap(a -> a.getFkId(), a -> a));
        Map<Long, MessageGroupSendTask> taskId2Task = taskList.stream().collect(Collectors.toMap(a -> a.getId(), a -> a));
        Set userIds = taskList.stream().map(a -> a.getCreateBy()).collect(Collectors.toSet());
        timer.start("queryWeworkUserByUserIds");
        Map userId2EntityMap = this.weworkUserService.queryWeworkUserByUserIds(currentUserInfo.getCorpId(), userIds);
        timer.stop();
        ArrayList respList = Lists.newArrayList();
        timer.start("queryTopNDetailInTask");
        List details = this.groupSendDetailMapper.queryTopNDetailInTask(taskIds, req.getWeworkUserNum(), req.getSendStatus(), 10);
        timer.stop();
        timer.start("buildResult");
        this.buildResult(req.getCorpId(), currentUserInfo, sortedTaskIds, taskId2MaterialList, taskId2Task, userId2EntityMap, respList, details, id2StatusCounts);
        timer.stop();
        timer.print();
        return respList;
    }

    private void buildResult(String corpId, CurrentUserInfo currentUserInfo, List<Long> sortedTaskIds, Map<Long, MaterialListRespDto> taskId2MaterialList, Map<Long, MessageGroupSendTask> taskId2Task, Map<Long, WeworkUserInfo> userId2EntityMap, List<SendListResp> respList, List<MessageGroupSendDetail> details, List<Id2StatusCount> id2StatusCounts) {
        HashSet contactIds = Sets.newHashSet();
        HashSet chatroomIds = Sets.newHashSet();
        Map<Long, Id2StatusCount> taskId2IdStatusCount = id2StatusCounts.stream().collect(Collectors.toMap(a -> a.getId(), a -> a));
        for (MessageGroupSendDetail detail : details) {
            if (detail.getReceiveType().equals(ReceiveType.CONTACT.getType())) {
                contactIds.add(detail.getReceiveId());
                continue;
            }
            chatroomIds.add(detail.getReceiveId());
        }
        Map<String, WeworkChatRoom> chatroomId2Entity = null;
        Map<String, UserContactInfo> contactId2Entity = null;
        if (CollectionUtils.isNotEmpty((Collection)contactIds)) {
            List contactWeworkNumPairs = details.stream().map(a -> new ContactWeworkNumPair(a.getSendWeworkNum(), a.getReceiveId())).collect(Collectors.toList());
            contactId2Entity = this.weworkContactRelationMapper.queryContactInfoByWeworkUserNumAndNameQuery(corpId, null, contactWeworkNumPairs).stream().collect(Collectors.toMap(UserContactInfo::getContactId, Function.identity()));
        }
        if (CollectionUtils.isNotEmpty((Collection)chatroomIds)) {
            List chatRoomList = this.chatRoomService.selectRoomList(currentUserInfo.getCorpId(), currentUserInfo.getBizId(), (Collection)chatroomIds);
            chatroomId2Entity = chatRoomList.stream().collect(Collectors.toMap(WeworkChatRoom::getWeworkRoomId, Function.identity()));
        }
        WeworkUser weworkUser = this.weworkUserMapper.queryWeworkUserByNum(currentUserInfo.getWeworkUserNum());
        String weworkUserName = weworkUser.getName();
        log.info("getWeworkSidebarMeetingList weworkUserName: {}", (Object)weworkUserName);
        Map<Long, List<MessageGroupSendDetail>> taskId2Details = details.stream().collect(Collectors.groupingBy(MessageGroupSendDetail::getTaskId));
        for (Long taskId : sortedTaskIds) {
            List<MessageGroupSendDetail> detailList = taskId2Details.get(taskId);
            MessageGroupSendTask task = taskId2Task.get(taskId);
            detailList = this.filterMeetingGroupSendDetail(detailList, task);
            SendListResp sendListResp = new SendListResp();
            sendListResp.setSendTime(task.getSendTime());
            WeworkUserInfo weworkUserInfo = userId2EntityMap.get(task.getCreateBy());
            sendListResp.setCreatorName(weworkUserInfo != null ? weworkUserInfo.getName() : "");
            sendListResp.setDeadlineTime(task.getDeadline());
            sendListResp.setFkId(task.getFkTaskId());
            sendListResp.setFkType(task.getFkType());
            sendListResp.setTaskId(task.getId());
            sendListResp.setTaskName(task.getName());
            sendListResp.setTaskStatus(task.getTaskStatus());
            log.info("buildResult meeting type: {}", (Object)task.getFkType());
            String content = task.getContent();
            if (task.getFkType().equals(GroupSendFkType.MEETING.getType())) {
                Meeting meeting = (Meeting)this.meetingMapper.selectByPrimaryKey((Object)task.getFkTaskId());
                log.info("buildResult meeting : {}", (Object)meeting);
                if (meeting != null) {
                    Integer inviteType = meeting.getInviteInfoType();
                    sendListResp.setMeetingInviteContentType(inviteType);
                    if (meeting.getLiveDeliverySwitch() == 1) {
                        String wechatAuthMeetingCommerceUrl = this.meetingUrlService.getWechatAuthMeetingCommerceUrl(meeting.getBizId(), meeting.getRoomId(), null, meeting.getNum(), weworkUser.getNum());
                        content = content.replace(meeting.getMeetingUrl(), wechatAuthMeetingCommerceUrl);
                    }
                }
            }
            if (content.contains(WEWORKUSER_PLACEHOLDER)) {
                content = content.replace(WEWORKUSER_PLACEHOLDER, weworkUserName);
            }
            sendListResp.setContent(content);
            sendListResp.setSendStatus(SendStatus.getTypeForWeb((Integer)task.getSendStatus()).getValue());
            sendListResp.setTaskType(task.getTaskType());
            Id2StatusCount id2StatusCount = taskId2IdStatusCount.get(taskId);
            MsgGroupSendTaskProcessRespDto msgGroupSendTaskProcessRespDto = MsgGroupSendTaskProcessRespDto.buildFromId2StatusCount(id2StatusCount);
            sendListResp.setProcess(msgGroupSendTaskProcessRespDto);
            ArrayList targets = Lists.newArrayList();
            List contents = JSONArray.parseArray((String)task.getContent(), UniformMsgDto.class);
            MaterialListRespDto materialListRespDto = taskId2MaterialList.get(task.getId());
            Map<Object, Object> url2MediaId = Maps.newHashMap();
            if (materialListRespDto != null && CollectionUtils.isNotEmpty((Collection)materialListRespDto.getMaterialReqDtoList())) {
                url2MediaId = materialListRespDto.getMaterialReqDtoList().stream().collect(Collectors.toMap(a -> a.getFileUrl(), a -> a.getMediaId(), (a, b) -> a));
            }
            Map stageRewardCountMap = Maps.newHashMap();
            Map receiveStageRewardCountMap = Maps.newHashMap();
            if (task.getFkType().equals(GroupSendFkType.FRIEND_FISSION.getType())) {
                stageRewardCountMap = this.marketingRewardStageMapper.getStageRewardCountByPlanId(task.getFkTaskId());
                receiveStageRewardCountMap = this.marketingRewardMapper.getReceiveStageRewardCountByPlanId(task.getFkTaskId());
            }
            this.forLoopDetail(chatroomId2Entity, contactId2Entity, detailList, task, targets, contents, url2MediaId, stageRewardCountMap, receiveStageRewardCountMap, weworkUser);
            sendListResp.setTargets(targets);
            respList.add(sendListResp);
        }
    }

    private List<MessageGroupSendDetail> filterMeetingGroupSendDetail(List<MessageGroupSendDetail> messageGroupSendDetails, MessageGroupSendTask groupSendTask) {
        if (Objects.isNull(groupSendTask.getFkType()) || groupSendTask.getFkType().intValue() != GroupSendFkType.UN_ARRIVE_MEETING.getType()) {
            return messageGroupSendDetails;
        }
        List meetingCustomerInfos = this.meetingCustomerInfoMapper.queryMeetingCustomerByNumber(groupSendTask.getBizId(), groupSendTask.getFkTaskId(), null);
        if (CollectionUtils.isEmpty((Collection)meetingCustomerInfos)) {
            return messageGroupSendDetails;
        }
        List arriveMeetingContactId = meetingCustomerInfos.stream().filter(customerInfo -> customerInfo.getArrivalTime() != null).map(MeetingCustomerInfo::getContactId).collect(Collectors.toList());
        List shouldReceiveIds = messageGroupSendDetails.stream().map(MessageGroupSendDetail::getReceiveId).collect(Collectors.toList());
        shouldReceiveIds.removeAll(arriveMeetingContactId);
        Map<String, List<MessageGroupSendDetail>> receiveIdTaskDetails = messageGroupSendDetails.stream().collect(Collectors.groupingBy(MessageGroupSendDetail::getReceiveId));
        for (String shouldReceiveId : shouldReceiveIds) {
            receiveIdTaskDetails.get(shouldReceiveId);
        }
        return shouldReceiveIds.stream().map(receiveIdTaskDetails::get).flatMap(Collection::stream).collect(Collectors.toList());
    }

    private void forLoopDetail(Map<String, WeworkChatRoom> chatroomId2Entity, Map<String, UserContactInfo> contactId2Entity, List<MessageGroupSendDetail> detailList, MessageGroupSendTask task, List<SendTargetDto> targets, List<UniformMsgDto> contents, Map<String, String> url2MediaId, Map<Integer, Integer> stageRewardCountMap, Map<Integer, Integer> receiveStageRewardCountMap, WeworkUser weworkUser) {
        if (CollectionUtils.isEmpty(detailList)) {
            return;
        }
        for (MessageGroupSendDetail detail : detailList) {
            SendTargetDto item = new SendTargetDto();
            item.setSendStatus(detail.getStatus());
            item.setDetailId(detail.getId());
            item.setTargetType(detail.getReceiveType());
            item.setTaskType(detail.getTaskType());
            if (detail.getReceiveType().equals(ReceiveType.CHATROOM.getType())) {
                WeworkChatRoom chatRoom = chatroomId2Entity.getOrDefault(detail.getReceiveId(), new WeworkChatRoom());
                item.setTargetAlias("");
                item.setTargetAvatar("");
                item.setTargetName(chatRoom != null ? chatRoom.getName() : "");
            } else {
                UserContactInfo contact = contactId2Entity.getOrDefault(detail.getReceiveId(), new UserContactInfo());
                item.setTargetAlias("");
                item.setTargetAvatar(contact != null ? contact.getAvatar() : "");
                item.setTargetName(contact != null ? contact.getRemarkFirst() : "");
            }
            item.setTargetId(detail.getReceiveId());
            ArrayList contentList = Lists.newArrayList();
            for (UniformMsgDto contentItem : contents) {
                ContentDto dto = new ContentDto();
                dto.setMsgType(contentItem.getMsgType());
                switch (JsMsgType.valueOf((String)contentItem.getMsgType())) {
                    case file: 
                    case video: 
                    case image: {
                        String mediaId = url2MediaId.get(contentItem.getFile().getFileUrl());
                        dto.setMediaId(mediaId);
                        dto.setFile(contentItem.getFile());
                        break;
                    }
                    case miniprogram: {
                        dto.setMiniprogram(contentItem.getMiniprogram());
                        break;
                    }
                    case news: {
                        dto.setNews(contentItem.getNews());
                        break;
                    }
                    case text: {
                        String content = contentItem.getContent();
                        if (content.contains(WEWORKUSER_PLACEHOLDER)) {
                            content = content.replace(WEWORKUSER_PLACEHOLDER, weworkUser.getName());
                        }
                        dto.setContent(content);
                        break;
                    }
                    case meeting: {
                        String meetingContent = contentItem.getContent();
                        if (task.getFkType().equals(GroupSendFkType.MEETING.getType()) && StringUtils.isNotBlank((CharSequence)detail.getExtField1()) && StringUtils.isNotBlank((CharSequence)meetingContent)) {
                            meetingContent = meetingContent.replace(MEETING_PLACEHOLDER, detail.getExtField1());
                        }
                        if (meetingContent.contains(WEWORKUSER_PLACEHOLDER)) {
                            meetingContent = meetingContent.replace(WEWORKUSER_PLACEHOLDER, weworkUser.getName());
                        }
                        dto.setMsgType(JsMsgType.text.name());
                        dto.setContent(meetingContent);
                        Meeting meeting = null;
                        if (!task.getFkType().equals(GroupSendFkType.MEETING.getType())) break;
                        meeting = (Meeting)this.meetingMapper.selectByPrimaryKey((Object)task.getFkTaskId());
                        log.info("forLoopDetail meeting : {}, meetingContent: {}", (Object)meeting, (Object)meetingContent);
                        if (meeting == null || meeting.getInviteInfoType() != 1) break;
                        if (meeting.getLiveDeliverySwitch() == 1) {
                            String wechatAuthMeetingCommerceUrl = this.meetingUrlService.getWechatAuthMeetingCommerceUrl(meeting.getBizId(), meeting.getRoomId(), null, meeting.getNum(), weworkUser.getNum());
                            meetingContent = meetingContent.replace(meeting.getMeetingUrl(), wechatAuthMeetingCommerceUrl);
                        }
                        dto.setMsgType(JsMsgType.news.name());
                        JsNewsDto newsDto = new JsNewsDto();
                        try {
                            newsDto = (JsNewsDto)JacksonUtil.str2Obj((String)meetingContent, JsNewsDto.class);
                        }
                        catch (IOException e) {
                            e.printStackTrace();
                        }
                        dto.setContent(null);
                        dto.setNews(newsDto);
                        break;
                    }
                    case ffWords: {
                        String ffWordContent = contentItem.getContent();
                        if (task.getFkType().equals(GroupSendFkType.FRIEND_FISSION.getType()) && StringUtils.isNotBlank((CharSequence)ffWordContent)) {
                            ffWordContent = this.replaceFriendFissionPlaceHolder(contactId2Entity, stageRewardCountMap, receiveStageRewardCountMap, detail, ffWordContent);
                        }
                        if (ffWordContent.contains(WEWORKUSER_PLACEHOLDER)) {
                            ffWordContent = ffWordContent.replace(WEWORKUSER_PLACEHOLDER, weworkUser.getName());
                        }
                        dto.setMsgType(JsMsgType.text.name());
                        dto.setContent(ffWordContent);
                    }
                }
                contentList.add(dto);
            }
            item.setContentList(contentList);
            targets.add(item);
        }
    }

    @Override
    public String replaceFriendFissionPlaceHolder(Map<String, UserContactInfo> contactId2Entity, Map<Integer, Integer> stageRewardCountMap, Map<Integer, Integer> receiveStageRewardCountMap, MessageGroupSendDetail detail, String content) {
        int firstStageReceiveCount;
        if (content.contains("${nickname}")) {
            if (detail.getReceiveType().equals(ReceiveType.CONTACT.getType()) && !"emptyReceiverId".equals(detail.getReceiveId())) {
                UserContactInfo userContactInfo = contactId2Entity.getOrDefault(detail.getReceiveId(), new UserContactInfo());
                content = StringUtils.replace((String)content, (String)"${nickname}", (String)userContactInfo.getOriginName());
            } else {
                content = StringUtils.replace((String)content, (String)"${nickname}", (String)"");
            }
        }
        if (content.contains("${remainReward-1}")) {
            int firstStageRewardCount;
            int n = firstStageRewardCount = stageRewardCountMap.get(1) == null ? 0 : stageRewardCountMap.get(1);
            firstStageReceiveCount = receiveStageRewardCountMap == null ? 0 : (receiveStageRewardCountMap.get(1) == null ? 0 : receiveStageRewardCountMap.get(1));
            content = StringUtils.replace((String)content, (String)"${remainReward-1}", (String)(Math.max(firstStageRewardCount - firstStageReceiveCount, 0) + ""));
        }
        if (content.contains("${remainReward-2}")) {
            int firstStageRewardCount;
            int n = firstStageRewardCount = stageRewardCountMap.get(2) == null ? 0 : stageRewardCountMap.get(2);
            firstStageReceiveCount = receiveStageRewardCountMap == null ? 0 : (receiveStageRewardCountMap.get(2) == null ? 0 : receiveStageRewardCountMap.get(2));
            content = StringUtils.replace((String)content, (String)"${remainReward-2}", (String)(Math.max(firstStageRewardCount - firstStageReceiveCount, 0) + ""));
        }
        if (content.contains("${remainReward-3}")) {
            int firstStageRewardCount;
            int n = firstStageRewardCount = stageRewardCountMap.get(3) == null ? 0 : stageRewardCountMap.get(3);
            firstStageReceiveCount = receiveStageRewardCountMap == null ? 0 : (receiveStageRewardCountMap.get(3) == null ? 0 : receiveStageRewardCountMap.get(3));
            content = StringUtils.replace((String)content, (String)"${remainReward-3}", (String)(Math.max(firstStageRewardCount - firstStageReceiveCount, 0) + ""));
        }
        return content;
    }

    @Override
    public SendDetailResp sendDetailList(SendDetailListReq req) {
        StopWatchDto timer = new StopWatchDto("sendDetailList", true, log);
        CurrentUserInfo currentUserInfo = LoginUtils.getCurrentUser();
        Long bizId = currentUserInfo.getBizId();
        String corpId = currentUserInfo.getCorpId();
        if (StringUtils.isEmpty((CharSequence)req.getWeworkUserNum())) {
            timer.start("getWeworkUserNumById");
            String weworkUserNum = this.weworkUserService.getWeworkUserNumById(currentUserInfo.getCorpId(), currentUserInfo.getWeworkUserId());
            timer.stop();
            req.setWeworkUserNum(weworkUserNum);
        }
        log.info("sendDetailList with req={},operatorId={}", (Object)req, (Object)currentUserInfo.getId());
        req.validate();
        WeworkUser weworkUser = this.weworkUserMapper.queryWeworkUserByNum(currentUserInfo.getWeworkUserNum());
        String weworkUserName = weworkUser.getName();
        log.info("sendDetailList weworkUserName: {}", (Object)weworkUserName);
        timer.start("selectTaskByPrimaryKey");
        MessageGroupSendTask task = (MessageGroupSendTask)this.groupSendTaskMapper.selectByPrimaryKey((Object)req.getTaskId());
        timer.stop();
        if (task == null || task.getIsDeleted() == 1) {
            throw new BusinessException((UniverseErrorCode)CommonErrorCode.BUSINESS_ERROR, "\u4efb\u52a1\u4e0d\u5b58\u5728");
        }
        timer.start("queryStatusByTaskIds");
        List id2StatusCounts = this.groupSendDetailMapper.queryStatusByTaskIds((Collection)Lists.newArrayList((Object[])new Long[]{task.getId()}), req.getWeworkUserNum(), (Collection)Lists.newArrayList((Object[])new Integer[]{GroupSendTaskType.SIDEBAR.getValue(), GroupSendTaskType.CLIENT.getValue()}));
        timer.stop();
        if (CollectionUtils.isEmpty((Collection)id2StatusCounts)) {
            timer.print();
            return new SendDetailResp();
        }
        Id2StatusCount id2StatusCount = (Id2StatusCount)id2StatusCounts.get(0);
        MsgGroupSendTaskProcessRespDto msgGroupSendTaskProcessRespDto = MsgGroupSendTaskProcessRespDto.buildFromId2StatusCount(id2StatusCount);
        ArrayList sendStatusList = Lists.newArrayList();
        if (req.getSendStatus().equals(SendStatus.ALREADY_EXPIRE.getValue())) {
            sendStatusList.add(SendStatus.ALREADY_EXPIRE.getValue());
            sendStatusList.add(SendStatus.SEND_FAIL.getValue());
        } else {
            sendStatusList.add(req.getSendStatus());
        }
        timer.start("queryDetailListByTaskId");
        List details = this.groupSendDetailMapper.queryDetailListByTaskId(req.getTaskId(), req.getWeworkUserNum(), (Collection)sendStatusList, req.getPageDto());
        timer.stop();
        if (req.getPageDto() != null) {
            req.getPageDto().setCurPageCount(Integer.valueOf(details.size()));
            timer.start("queryDetailCountByTaskId");
            int count = this.groupSendDetailMapper.queryDetailCountByTaskId(req.getTaskId(), req.getWeworkUserNum(), (Collection)sendStatusList);
            timer.stop();
            req.getPageDto().setCount(Integer.valueOf(count));
        }
        SendDetailResp resp = new SendDetailResp();
        ArrayList list = Lists.newArrayList();
        resp.setList(list);
        resp.setProcess(msgGroupSendTaskProcessRespDto);
        HashSet contactIds = Sets.newHashSet();
        HashSet chatroomIds = Sets.newHashSet();
        for (MessageGroupSendDetail detail : details) {
            if (detail.getReceiveType().equals(ReceiveType.CONTACT.getType())) {
                contactIds.add(detail.getReceiveId());
                continue;
            }
            chatroomIds.add(detail.getReceiveId());
        }
        Map chatroomId2Entity = null;
        Map<String, UserContactInfo> contactId2Entity = null;
        if (CollectionUtils.isNotEmpty((Collection)contactIds)) {
            List contactWeworkNumPairs = details.stream().map(a -> new ContactWeworkNumPair(a.getSendWeworkNum(), a.getReceiveId())).collect(Collectors.toList());
            timer.start("queryContactInfoByWeworkUserNumAndNameQuery");
            contactId2Entity = this.weworkContactRelationMapper.queryContactInfoByWeworkUserNumAndNameQuery(task.getCorpId(), null, contactWeworkNumPairs).stream().collect(Collectors.toMap(UserContactInfo::getContactId, Function.identity()));
            timer.stop();
        }
        if (CollectionUtils.isNotEmpty((Collection)chatroomIds)) {
            timer.start("selectRoomList");
            List chatRoomList = this.chatRoomService.selectRoomList(currentUserInfo.getCorpId(), currentUserInfo.getBizId(), (Collection)chatroomIds);
            timer.stop();
            chatroomId2Entity = chatRoomList.stream().collect(Collectors.toMap(WeworkChatRoom::getWeworkRoomId, Function.identity()));
        }
        List contents = JSONArray.parseArray((String)task.getContent(), UniformMsgDto.class);
        ArrayList reqDtos = Lists.newArrayList();
        QueryMaterialReqDto queryMaterialReqDto = new QueryMaterialReqDto();
        queryMaterialReqDto.setFkType(Integer.valueOf(1));
        queryMaterialReqDto.setFkId(task.getId());
        reqDtos.add(queryMaterialReqDto);
        timer.start("queryMaterial");
        List materialListRespDtoList = this.materialManagerService.query(bizId, corpId, (List)reqDtos);
        timer.stop();
        Map<Long, MaterialListRespDto> materialMap = materialListRespDtoList.stream().collect(Collectors.toMap(a -> a.getFkId(), a -> a));
        Map<Object, Object> url2MediaId = Maps.newHashMap();
        if (MapUtils.isNotEmpty(materialMap)) {
            MaterialListRespDto materialListRespDto = materialMap.get(task.getId());
            url2MediaId = materialListRespDto.getMaterialReqDtoList().stream().collect(Collectors.toMap(a -> a.getFileUrl(), a -> a.getMediaId()));
        }
        Map stageRewardCountMap = Maps.newHashMap();
        Map receiveStageRewardCountMap = Maps.newHashMap();
        if (task.getFkType().equals(GroupSendFkType.FRIEND_FISSION.getType())) {
            stageRewardCountMap = this.marketingRewardStageMapper.getStageRewardCountByPlanId(task.getFkTaskId());
            receiveStageRewardCountMap = this.marketingRewardMapper.getReceiveStageRewardCountByPlanId(task.getFkTaskId());
        }
        timer.start("loop");
        for (MessageGroupSendDetail detail : details) {
            SendTargetDto item = new SendTargetDto();
            item.setSendStatus(detail.getStatus());
            item.setDetailId(detail.getId());
            item.setTargetType(detail.getReceiveType());
            if (detail.getReceiveType().equals(ReceiveType.CHATROOM.getType())) {
                WeworkChatRoom chatRoom = chatroomId2Entity.getOrDefault(detail.getReceiveId(), new WeworkChatRoom());
                item.setTargetAlias("");
                item.setTargetAvatar("");
                item.setTargetName(chatRoom.getName());
            } else {
                UserContactInfo contact = contactId2Entity.getOrDefault(detail.getReceiveId(), new UserContactInfo());
                item.setTargetAlias("");
                item.setTargetAvatar(contact.getAvatar());
                item.setTargetName(contact.getRemarkFirst());
            }
            item.setTargetId(detail.getReceiveId());
            ArrayList contentList = Lists.newArrayList();
            for (UniformMsgDto contentItem : contents) {
                ContentDto dto = new ContentDto();
                dto.setMsgType(contentItem.getMsgType());
                switch (JsMsgType.valueOf((String)contentItem.getMsgType())) {
                    case file: 
                    case video: 
                    case image: {
                        String mediaId = (String)url2MediaId.get(contentItem.getFile().getFileUrl());
                        dto.setMediaId(mediaId);
                        dto.setFile(contentItem.getFile());
                        break;
                    }
                    case miniprogram: {
                        dto.setMiniprogram(contentItem.getMiniprogram());
                        break;
                    }
                    case news: {
                        dto.setNews(contentItem.getNews());
                        break;
                    }
                    case text: {
                        String content = contentItem.getContent();
                        if (content.contains(WEWORKUSER_PLACEHOLDER)) {
                            content = content.replace(WEWORKUSER_PLACEHOLDER, weworkUserName);
                        }
                        dto.setContent(content);
                        break;
                    }
                    case meeting: {
                        String meetingContent = contentItem.getContent();
                        if (task.getFkType().equals(GroupSendFkType.MEETING.getType()) && StringUtils.isNotBlank((CharSequence)detail.getExtField1())) {
                            meetingContent = meetingContent.replace(MEETING_PLACEHOLDER, detail.getExtField1());
                        }
                        if (meetingContent.contains(WEWORKUSER_PLACEHOLDER)) {
                            meetingContent = meetingContent.replace(WEWORKUSER_PLACEHOLDER, weworkUserName);
                        }
                        dto.setMsgType(JsMsgType.text.name());
                        dto.setContent(meetingContent);
                        Meeting meeting = null;
                        if (!task.getFkType().equals(GroupSendFkType.MEETING.getType())) break;
                        meeting = (Meeting)this.meetingMapper.selectByPrimaryKey((Object)task.getFkTaskId());
                        log.info("sendDetailList meeting : {}, meetingContent: {}", (Object)meeting, (Object)meetingContent);
                        if (meeting != null && meeting.getLiveDeliverySwitch() == 1) {
                            String wechatAuthMeetingCommerceUrl = this.meetingUrlService.getWechatAuthMeetingCommerceUrl(meeting.getBizId(), meeting.getRoomId(), null, meeting.getNum(), weworkUser.getNum());
                            dto.setContent(dto.getContent().replace(meeting.getMeetingUrl(), wechatAuthMeetingCommerceUrl));
                        }
                        if (meeting == null || meeting.getInviteInfoType() != 1) break;
                        dto.setMsgType(JsMsgType.news.name());
                        JsNewsDto newsDto = new JsNewsDto();
                        try {
                            newsDto = (JsNewsDto)JacksonUtil.str2Obj((String)meetingContent, JsNewsDto.class);
                        }
                        catch (IOException e) {
                            e.printStackTrace();
                        }
                        dto.setContent(null);
                        dto.setNews(newsDto);
                        break;
                    }
                    case ffWords: {
                        String ffWordContent = contentItem.getContent();
                        if (task.getFkType().equals(GroupSendFkType.FRIEND_FISSION.getType()) && StringUtils.isNotBlank((CharSequence)ffWordContent)) {
                            ffWordContent = this.replaceFriendFissionPlaceHolder(contactId2Entity, stageRewardCountMap, receiveStageRewardCountMap, detail, ffWordContent);
                        }
                        if (ffWordContent.contains(WEWORKUSER_PLACEHOLDER)) {
                            ffWordContent = ffWordContent.replace(WEWORKUSER_PLACEHOLDER, weworkUserName);
                        }
                        dto.setMsgType(JsMsgType.text.name());
                        dto.setContent(ffWordContent);
                    }
                }
                contentList.add(dto);
            }
            item.setContentList(contentList);
            list.add(item);
        }
        timer.stop();
        timer.print();
        return resp;
    }

    @Override
    public GroupSendTargetResp sendTarget(IdReq req) {
        CurrentUserInfo currentUserInfo = LoginUtils.getCurrentUser();
        log.info("sendTarget with req={}, operatorId={}", (Object)req, (Object)currentUserInfo.getId());
        req.validateSendTarget();
        MessageGroupSendTask task = null;
        task = StringUtils.isNotBlank((CharSequence)req.getTaskNum()) ? this.groupSendTaskMapper.queryByTaskNum(req.getTaskNum()) : this.groupSendTaskMapper.queryOneBySopNum(req.getSopNum());
        if (task == null || task.getIsDeleted() == 1) {
            throw new BusinessException((UniverseErrorCode)CommonErrorCode.BUSINESS_ERROR, "\u7fa4\u53d1\u4efb\u52a1\u4e0d\u5b58\u5728");
        }
        GroupSendTargetResp targetResp = new GroupSendTargetResp();
        targetResp.setQueryType(task.getQueryType());
        if (task.getSendStatus().equals(SendStatus.TO_BE_QUERY.getValue()) && task.getSendCount() > 0) {
            this.queryCacheDetail(req.getPageDto(), task, targetResp);
        } else {
            this.queryExistDetail(req.getPageDto(), task, targetResp);
        }
        return targetResp;
    }

    private void queryCacheDetail(PageDto pageDto, MessageGroupSendTask task, GroupSendTargetResp targetResp) {
        if (StringUtils.isNotBlank((CharSequence)task.getQueryRequestId())) {
            WeworkTmpStore tmpStore = this.weworkTmpStoreMapper.queryByRequestId(task.getQueryRequestId());
            ArrayList resultContactList = Lists.newArrayList();
            ArrayList resultChatroomList = Lists.newArrayList();
            switch (tmpStore.getQueryType()) {
                case 1: 
                case 3: {
                    String contactJson = tmpStore.getStoreBody();
                    List contactList = JSONArray.parseArray((String)contactJson, SelectedContact2WeworkUserDto.class);
                    Function<SelectedContact2WeworkUserDto, String> contactFunction = SelectedContact2WeworkUserDto::getContactId;
                    contactList = this.multiSelectService.pageResult(pageDto, contactList, contactFunction);
                    resultContactList.addAll(contactList);
                    break;
                }
                case 2: {
                    String chatroomJson = tmpStore.getStoreBody();
                    List chatroomList = JSONArray.parseArray((String)chatroomJson, SelectedChatroom2WeworkUserDto.class);
                    Function<SelectedChatroom2WeworkUserDto, String> chatroomFunction = SelectedChatroom2WeworkUserDto::getChatroomId;
                    chatroomList = this.multiSelectService.pageResult(pageDto, chatroomList, chatroomFunction);
                    resultChatroomList.addAll(chatroomList);
                }
            }
            targetResp.setContactList(resultContactList);
            targetResp.setChatroomList(resultChatroomList);
        }
    }

    private void queryExistDetail(PageDto pageDto, MessageGroupSendTask task, GroupSendTargetResp targetResp) {
        List list = this.groupSendDetailMapper.queryByTaskId(task.getId(), null, pageDto);
        if (pageDto != null) {
            int count = this.groupSendDetailMapper.queryCountByTaskId(task.getId(), null);
            pageDto.setCount(Integer.valueOf(count));
            pageDto.setCurPageCount(Integer.valueOf(list.size()));
        }
        Set sendWeworkNum = list.stream().map(a -> a.getSendWeworkNum()).collect(Collectors.toSet());
        Map userNum2Dto = this.weworkUserService.getWeworkUserNames((List)Lists.newArrayList(sendWeworkNum)).stream().collect(Collectors.toMap(WeworkUserNameRespDto::getWeworkUserId, Function.identity()));
        List receiverIds = list.stream().map(a -> a.getReceiveId()).collect(Collectors.toList());
        Map chatroomId2Entity = null;
        Map contactId2Entity = null;
        if (task.getQueryType().equals(QueryType.CHAT_ROOM.getType())) {
            List chatRoomList = this.chatRoomService.selectRoomList(task.getCorpId(), task.getBizId(), receiverIds);
            chatroomId2Entity = chatRoomList.stream().collect(Collectors.toMap(WeworkChatRoom::getWeworkRoomId, Function.identity()));
        } else {
            List contactWeworkNumPairs = list.stream().map(a -> new ContactWeworkNumPair(a.getSendWeworkNum(), a.getReceiveId())).collect(Collectors.toList());
            contactId2Entity = this.weworkContactRelationMapper.queryContactInfoByWeworkUserNumAndNameQuery(task.getCorpId(), null, contactWeworkNumPairs).stream().collect(Collectors.toMap(UserContactInfo::getContactId, Function.identity()));
        }
        ArrayList contactList = Lists.newArrayList();
        ArrayList chatroomList = Lists.newArrayList();
        for (MessageGroupSendDetail item : list) {
            WeworkUserNameRespDto weworkUserInfo = (WeworkUserNameRespDto)userNum2Dto.get(item.getSendWeworkNum());
            if (task.getQueryType().equals(QueryType.CHAT_ROOM.getType()) && chatroomId2Entity != null) {
                WeworkChatRoom chatRoom = (WeworkChatRoom)chatroomId2Entity.get(item.getReceiveId());
                SelectedChatroom2WeworkUserDto chatroom2WeworkUserDto = new SelectedChatroom2WeworkUserDto();
                chatroom2WeworkUserDto.setChatroomId(chatRoom != null ? chatRoom.getWeworkRoomId() : "");
                chatroom2WeworkUserDto.setChatroomAvatar("");
                chatroom2WeworkUserDto.setChatroomName(chatRoom != null ? chatRoom.getName() : "");
                if (weworkUserInfo != null) {
                    chatroom2WeworkUserDto.setWeworkAlias(weworkUserInfo.getAlias());
                    chatroom2WeworkUserDto.setWeworkName(weworkUserInfo.getUserName());
                    chatroom2WeworkUserDto.setWeworkAvatar(weworkUserInfo.getAvatar());
                    chatroom2WeworkUserDto.setWeworkNum(weworkUserInfo.getWeworkUserId());
                }
                chatroomList.add(chatroom2WeworkUserDto);
                continue;
            }
            if (contactId2Entity == null) continue;
            UserContactInfo contact = (UserContactInfo)contactId2Entity.get(item.getReceiveId());
            SelectedContact2WeworkUserDto contact2WeworkUserDto = new SelectedContact2WeworkUserDto();
            if (contact != null) {
                contact2WeworkUserDto.setContactCorpName(contact.getCorpName());
                contact2WeworkUserDto.setContactAvatar(contact.getAvatar());
                contact2WeworkUserDto.setContactName(contact.getRemarkFirst());
                contact2WeworkUserDto.setContactId(contact.getContactId());
            } else {
                contact2WeworkUserDto.setContactCorpName("");
                contact2WeworkUserDto.setContactAvatar("");
                contact2WeworkUserDto.setContactName("");
                contact2WeworkUserDto.setContactId("");
            }
            if (weworkUserInfo != null) {
                contact2WeworkUserDto.setWeworkAlias(weworkUserInfo.getAlias());
                contact2WeworkUserDto.setWeworkName(weworkUserInfo.getUserName());
                contact2WeworkUserDto.setWeworkAvatar(weworkUserInfo.getAvatar());
                contact2WeworkUserDto.setWeworkNum(weworkUserInfo.getWeworkUserId());
            }
            contactList.add(contact2WeworkUserDto);
        }
        targetResp.setChatroomList(chatroomList);
        targetResp.setContactList(contactList);
    }

    @Override
    public List<String> queryFkTasks(Long fkId, GroupSendFkType fkType) {
        log.info("queryFkTasks with fkId={},fkType={}", (Object)fkId, (Object)fkType);
        return this.groupSendTaskMapper.queryByFkIdAndType(fkId, Integer.valueOf(fkType.getType()));
    }

    @Override
    public List<MessageGroupSendTask> queryEntityByFkTasks(Long fkId, GroupSendFkType fkType) {
        log.info("queryEntityByFkTasks with fkId={},fkType={}", (Object)fkId, (Object)fkType);
        return this.groupSendTaskMapper.queryEntityByFkIdAndType(fkId, Integer.valueOf(fkType.getType()));
    }

    @Override
    public void fixNotFinishedTaskData() {
        log.info("fixNotFinishedTaskData start");
        List tasks = this.groupSendTaskMapper.queryNotFinishedTask();
        for (MessageGroupSendTask task : tasks) {
            AddOrModReq req = null;
            try {
                req = (AddOrModReq)JacksonUtils.getInstance().readValue(task.getParamsJson(), AddOrModReq.class);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            req.setQueryType(task.getQueryType());
            req.setTaskType(task.getTaskType());
            ArrayList sendWeworkNums = Lists.newArrayList();
            if (task.getTaskType().intValue() == GroupSendTaskType.CLIENT.getValue() || task.getTaskType().intValue() == GroupSendTaskType.QYAPI.getValue() && task.getQueryType().equals(QueryType.CHAT_ROOM.getType())) {
                for (String weworkUserNum : req.getWeworkUserNums()) {
                    sendWeworkNums.add(weworkUserNum);
                }
            } else {
                this.searchWeworkUserNums(req, sendWeworkNums);
            }
            if (CollectionUtils.isEmpty((Collection)sendWeworkNums)) continue;
            ArrayList sendWeworks = Lists.newArrayList();
            for (String weworkUserNum : sendWeworkNums) {
                MessageGroupSendWework item = new MessageGroupSendWework();
                item.setBizId(task.getBizId());
                item.setCorpId(task.getCorpId());
                item.setSendTime(task.getSendTime());
                item.setCreateBy(task.getCreateBy());
                item.setCreateTime(new Date());
                item.setSendWeworkNum(weworkUserNum);
                item.setDeadline(task.getDeadline());
                item.setIsDeleted(Integer.valueOf(0));
                item.setTaskId(task.getId());
                item.setUpdateBy(task.getUpdateBy());
                item.setUpdateTime(new Date());
                sendWeworks.add(item);
            }
            this.grouSendWeworkMapper.deleteByTaskId(task.getId());
            this.grouSendWeworkMapper.batchInsert((Collection)sendWeworks);
        }
        log.info("fixNotFinishedTaskData end");
    }

    @Override
    public List<MessageGroupSendTask> queryEntityByTaskNum(List<String> taskNums) {
        return Optional.ofNullable(this.groupSendTaskMapper.queryByTaskNums(taskNums)).orElse(Lists.newArrayList());
    }

    private void searchWeworkUserNums(AddOrModReq req, List<String> sendWeworkNums) {
        if (req.getQueryType().intValue() == QueryType.CHAT_ROOM.getType()) {
            List<SelectedChatroom2WeworkUserDto> chatroomList = null;
            String requestId = null;
            if (Objects.nonNull(req.getGroupsendChatRoom())) {
                requestId = req.getGroupsendChatRoom().getRequestId();
            }
            boolean queryCache = false;
            WeworkTmpStore weworkTmpStore = null;
            if (StringUtils.isNotBlank((CharSequence)requestId) && (weworkTmpStore = this.weworkTmpStoreMapper.queryByRequestId(requestId)) != null) {
                queryCache = true;
            }
            if (!queryCache) {
                MultiSearchChatroomRespDto multiSearchChatroom = this.multiSelectService.multiSearchChatroom(req.getGroupsendChatRoom(), true);
                chatroomList = multiSearchChatroom.getList();
            } else {
                chatroomList = JSONArray.parseArray((String)weworkTmpStore.getStoreBody(), SelectedChatroom2WeworkUserDto.class);
            }
            if (CollectionUtils.isNotEmpty((Collection)chatroomList) && CollectionUtils.isNotEmpty(req.getRemindDates()) && StringUtils.isNotBlank((CharSequence)req.getRemind())) {
                Set weworkNums = chatroomList.stream().map(a -> a.getWeworkNum()).collect(Collectors.toSet());
                sendWeworkNums.addAll(weworkNums);
            }
        } else {
            List<SelectedContact2WeworkUserDto> contactList = null;
            String requestId = null;
            if (req.getQueryType().equals(QueryType.CONTACT.getType())) {
                if (Objects.nonNull(req.getGroupsendContact())) {
                    requestId = req.getGroupsendContact().getRequestId();
                }
            } else if (Objects.nonNull(req.getGroupsendQrCodeContact())) {
                requestId = req.getGroupsendQrCodeContact().getRequestId();
            }
            boolean queryCache = false;
            WeworkTmpStore weworkTmpStore = null;
            if (StringUtils.isNotBlank((CharSequence)requestId) && (weworkTmpStore = this.weworkTmpStoreMapper.queryByRequestId(requestId)) != null) {
                queryCache = true;
            }
            if (!queryCache) {
                MultiSearchContactResp multiSearchContact = null;
                if (req.getQueryType().equals(QueryType.CONTACT.getType())) {
                    if (req.getGroupsendContact() == null) {
                        return;
                    }
                    multiSearchContact = this.multiSelectService.multiSearchContact(req.getGroupsendContact(), true);
                } else {
                    if (req.getGroupsendQrCodeContact() == null) {
                        return;
                    }
                    multiSearchContact = this.multiSelectService.multiSearchQrcode(req.getGroupsendQrCodeContact(), true);
                }
                contactList = multiSearchContact.getList();
            } else {
                contactList = JSONArray.parseArray((String)weworkTmpStore.getStoreBody(), SelectedContact2WeworkUserDto.class);
            }
            if (CollectionUtils.isNotEmpty((Collection)contactList) && CollectionUtils.isNotEmpty(req.getRemindDates()) && StringUtils.isNotBlank((CharSequence)req.getRemind())) {
                Set weworkNums = contactList.stream().map(a -> a.getWeworkNum()).collect(Collectors.toSet());
                sendWeworkNums.addAll(weworkNums);
            }
        }
    }
}

