/*
 * Decompiled with CFR 0.152.
 */
package com.kuaike.scrm.groupinvite.service.impl;

import cn.kinyun.wework.sdk.exception.WeworkException;
import com.google.common.base.Preconditions;
import com.google.common.collect.Sets;
import com.kuaike.scrm.common.dto.CurrentUserInfo;
import com.kuaike.scrm.common.enums.GroupSendTaskType;
import com.kuaike.scrm.common.perm.service.UserRoleCommonService;
import com.kuaike.scrm.common.utils.LoginUtils;
import com.kuaike.scrm.dal.groupsend.dto.GroupInviteRemindDto;
import com.kuaike.scrm.dal.groupsend.entity.GroupInviteTask;
import com.kuaike.scrm.dal.groupsend.entity.GroupInviteUserDetail;
import com.kuaike.scrm.dal.groupsend.mapper.GroupInviteContactDetailMapper;
import com.kuaike.scrm.dal.groupsend.mapper.GroupInviteTaskMapper;
import com.kuaike.scrm.dal.groupsend.mapper.GroupInviteUserDetailMapper;
import com.kuaike.scrm.dal.wework.entity.WeworkUser;
import com.kuaike.scrm.dal.wework.mapper.WeworkContactMapper;
import com.kuaike.scrm.dal.wework.mapper.WeworkContactRelationMapper;
import com.kuaike.scrm.dal.wework.mapper.WeworkUserMapper;
import com.kuaike.scrm.groupinvite.dto.req.GroupInviteRemindReq;
import com.kuaike.scrm.groupinvite.service.GroupInviteRemindService;
import com.kuaike.scrm.remind.service.RemindService;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.curator.shaded.com.google.common.collect.Lists;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class GroupInviteRemindServiceImpl
implements GroupInviteRemindService {
    private static final Logger log = LoggerFactory.getLogger(GroupInviteRemindServiceImpl.class);
    private ExecutorService executorService = Executors.newFixedThreadPool(5);
    @Autowired
    private WeworkUserMapper weworkUserMapper;
    @Autowired
    private WeworkContactMapper weworkContactMapper;
    @Autowired
    private WeworkContactRelationMapper weworkContactRelationMapper;
    @Autowired
    private GroupInviteTaskMapper groupInviteTaskMapper;
    @Autowired
    private GroupInviteUserDetailMapper groupInviteUserDetailMapper;
    @Autowired
    private GroupInviteContactDetailMapper groupInviteContactDetailMapper;
    @Autowired
    private RemindService remindService;
    @Autowired
    private UserRoleCommonService userRoleCommonService;

    @Override
    public void remind(GroupInviteRemindReq params) {
        log.info("remind group invite, params={}, operatorId={}", (Object)params, (Object)LoginUtils.getCurrentUserId());
        Preconditions.checkArgument((params != null ? 1 : 0) != 0, (Object)"\u53c2\u6570\u4e3a\u7a7a");
        Preconditions.checkArgument((boolean)StringUtils.isNotBlank((CharSequence)params.getId()), (Object)"ID\u4e3a\u7a7a");
        this.validateLoginUser();
        String corpId = LoginUtils.getCurrentUserCorpId();
        GroupInviteTask record = this.groupInviteTaskMapper.getByNum(params.getId());
        Preconditions.checkArgument((record != null && record.getIsDeleted() == 0 ? 1 : 0) != 0, (Object)"\u8be5\u4efb\u52a1\u4e0d\u5b58\u5728\u6216\u5df2\u5220\u9664");
        Set manageUserIds = this.userRoleCommonService.getManageUserIds();
        Preconditions.checkArgument((CollectionUtils.isNotEmpty((Collection)manageUserIds) && manageUserIds.contains(record.getCreateBy()) ? 1 : 0) != 0, (Object)"\u65e0\u6743\u8bbf\u95ee\u8be5\u8d44\u6e90");
        List userDetailList = this.groupInviteUserDetailMapper.queryRemindByTaskId(record.getId(), params.getRemindId());
        if (CollectionUtils.isEmpty((Collection)userDetailList)) {
            log.info("\u6ca1\u6709\u9700\u8981\u63d0\u9192\u7684\u6210\u5458");
            return;
        }
        List weworkUserNums = userDetailList.stream().map(it -> it.getWeworkUserNum()).distinct().collect(Collectors.toList());
        List msgIds = userDetailList.stream().map(it -> it.getMsgId()).collect(Collectors.toList());
        List contactDetailList = this.groupInviteContactDetailMapper.queryRemindByTaskId(record.getId(), msgIds);
        if (CollectionUtils.isEmpty((Collection)contactDetailList)) {
            log.info("\u6ca1\u6709\u9700\u8981\u63d0\u9192\u7684\u6210\u5458");
            return;
        }
        List contactIds = contactDetailList.stream().map(it -> it.getContactId()).collect(Collectors.toList());
        Map contactNameMap = this.weworkContactMapper.queryContactNameMap(corpId, contactIds);
        Map<Long, List<GroupInviteRemindDto>> contactMap = contactDetailList.stream().collect(Collectors.groupingBy(it -> it.getMsgId()));
        List weworkUserList = this.weworkUserMapper.queryWeworkUsersByNums(corpId, weworkUserNums);
        Map<String, WeworkUser> weworkUserMap = weworkUserList.stream().collect(Collectors.toMap(it -> it.getNum(), it -> it));
        String taskName = record.getName();
        String taskCreateTime = new SimpleDateFormat("yyyy-MM-dd HH:mm").format(record.getCreateTime());
        HashSet sidebarRemindIds = Sets.newHashSet();
        for (GroupInviteUserDetail u : userDetailList) {
            WeworkUser user = weworkUserMap.get(u.getWeworkUserNum());
            if (user == null || user.getIsDeleted() != 0) {
                log.warn("\u8be5\u6210\u5458\u4e0d\u5b58\u5728\u6216\u5df2\u5220\u9664, weworkUserNum={}", (Object)u.getWeworkUserNum());
                continue;
            }
            String weworkUserId = user.getWeworkUserId();
            if (user.getIsAgentAuth() == 0) {
                log.warn("\u8be5\u6210\u5458\u4e0d\u5728\u81ea\u5efa\u5e94\u7528\u53ef\u89c1\u8303\u56f4\u5185:{}", (Object)weworkUserId);
                continue;
            }
            List<GroupInviteRemindDto> contactList = contactMap.get(u.getMsgId());
            if (CollectionUtils.isEmpty(contactList)) {
                log.warn("\u6ca1\u6709\u8981\u63d0\u9192\u7684\u5ba2\u6237, msgId:{}", (Object)u.getMsgId());
                continue;
            }
            Map contactTypeMap = contactList.stream().collect(Collectors.groupingBy(it -> it.getTaskType(), Collectors.mapping(it -> it.getContactId(), Collectors.toList())));
            List contactIds2 = contactTypeMap.get(GroupSendTaskType.QYAPI.getValue());
            if (CollectionUtils.isNotEmpty(contactIds2)) {
                this.executorService.submit(() -> this.sendQyapi(corpId, weworkUserId, taskName, taskCreateTime, contactIds2, contactNameMap));
            }
            List sideBarContactIds = contactTypeMap.get(GroupSendTaskType.SIDEBAR.getValue());
            if (sidebarRemindIds.contains(weworkUserId) || !CollectionUtils.isNotEmpty(sideBarContactIds)) continue;
            sidebarRemindIds.add(weworkUserId);
            this.executorService.submit(() -> this.sendSidebar(corpId, weworkUserId));
        }
    }

    private void sendSidebar(String corpId, String weworkUserId) {
        String msg = "\u60a8\u6709\u4e00\u9879\u300c\u5ba2\u6237\u7fa4\u53d1\u300d\u5f85\u529e\uff0c\u8bf7\u524d\u5f80\u4fa7\u8fb9\u680f\u3010\u767e\u5bb6\u4e91SCRM\u3011\u2014\u3010\u5f85\u529e\u4e8b\u9879\u3011\u5c3d\u5feb\u5b8c\u6210\u54e6~";
        try {
            this.remindService.sendMsg(corpId, weworkUserId, msg);
        }
        catch (WeworkException e) {
            log.error("\u53d1\u9001\u63d0\u9192\u5931\u8d25:{}", (Object)e.getMessage());
        }
        catch (Exception e) {
            log.error("\u53d1\u9001\u63d0\u9192\u5931\u8d25", (Throwable)e);
        }
    }

    private void sendQyapi(String corpId, String weworkUserId, String taskName, String taskCreateTime, List<String> contactIds, Map<String, String> contactNameMap) {
        List relations = this.weworkContactRelationMapper.selectByCorpIdAndContactIds(corpId, contactIds, weworkUserId);
        Map<String, String> remarkMap = relations.stream().collect(Collectors.toMap(it -> it.getContactId(), it -> it.getRemark()));
        String msg = this.buildMsg(taskName, taskCreateTime, contactIds, contactNameMap, remarkMap);
        try {
            this.remindService.sendMsg(corpId, weworkUserId, msg);
        }
        catch (WeworkException e) {
            log.error("\u53d1\u9001\u63d0\u9192\u5931\u8d25:{}", (Object)e.getMessage());
        }
        catch (Exception e) {
            log.error("\u53d1\u9001\u63d0\u9192\u5931\u8d25", (Throwable)e);
        }
    }

    private String buildMsg(String taskName, String taskCreateTime, List<String> contactIds, Map<String, String> contactNameMap, Map<String, String> remarkMap) {
        int contactCount = contactIds.size();
        int namesCount = 5;
        ArrayList contactNames = Lists.newArrayListWithCapacity((int)namesCount);
        int size = 0;
        for (String contactId : contactIds) {
            String remark = remarkMap.get(contactId);
            String name = contactNameMap.get(contactId);
            if (StringUtils.isBlank((CharSequence)remark)) {
                contactNames.add(name);
            } else {
                contactNames.add(remark);
            }
            if (++size < namesCount) continue;
            break;
        }
        String contactName = StringUtils.join((Iterable)contactNames, (char)'\u3001');
        StringBuilder sb = new StringBuilder();
        sb.append("\u3010\u767e\u5bb6\u4e91\u52a9\u624b\u3011\n\u7ba1\u7406\u5458\u63d0\u9192\u60a8\u53d1\u9001\u7fa4\u53d1\u4efb\u52a1\uff1a\n\u201c");
        sb.append(taskName);
        sb.append("\u201d\u4efb\u52a1\u521b\u5efa\u4e8e");
        sb.append(taskCreateTime);
        sb.append("\uff0c\u5c06\u7fa4\u53d1\u7ed9\u201c");
        sb.append(contactName);
        sb.append("\u201d\u7b49");
        sb.append(contactCount);
        sb.append("\u4e2a\u5ba2\u6237\uff0c\u53ef\u524d\u5f80\u201c\u7fa4\u53d1\u52a9\u624b\u201d\u6d88\u606f\u4e2d\u786e\u8ba4\u53d1\u9001\u3002");
        return sb.toString();
    }

    private void validateLoginUser() {
        CurrentUserInfo currentUser = LoginUtils.getCurrentUser();
        Preconditions.checkArgument((currentUser != null ? 1 : 0) != 0, (Object)"\u7528\u6237\u672a\u767b\u5f55");
        Long operatorId = currentUser.getId();
        Long bizId = currentUser.getBizId();
        String corpId = currentUser.getCorpId();
        Preconditions.checkArgument((operatorId != null ? 1 : 0) != 0, (Object)"\u7528\u6237ID\u4e3a\u7a7a");
        Preconditions.checkArgument((bizId != null ? 1 : 0) != 0, (Object)"\u5546\u6237ID\u4e3a\u7a7a");
        Preconditions.checkArgument((boolean)StringUtils.isNotBlank((CharSequence)corpId), (Object)"\u4f01\u4e1aID\u4e3a\u7a7a");
    }
}

