/*
 * Decompiled with CFR 0.152.
 */
package com.kuaike.scrm.groupinvite.service.impl;

import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import com.kuaike.common.errorcode.CommonErrorCode;
import com.kuaike.common.errorcode.UniverseErrorCode;
import com.kuaike.common.exception.BusinessException;
import com.kuaike.common.sqlbuilder.dto.PageDto;
import com.kuaike.common.utils.JacksonUtil;
import com.kuaike.scrm.common.dto.AttachmentDto;
import com.kuaike.scrm.common.dto.CurrentUserInfo;
import com.kuaike.scrm.common.dto.jsMsg.FileDto;
import com.kuaike.scrm.common.dto.jsMsg.JsNewsDto;
import com.kuaike.scrm.common.dto.jsMsg.MiniProgramDto;
import com.kuaike.scrm.common.dto.jsMsg.UniformMsgDto;
import com.kuaike.scrm.common.enums.GroupSendFkType;
import com.kuaike.scrm.common.enums.GroupSendTaskType;
import com.kuaike.scrm.common.enums.JsMsgType;
import com.kuaike.scrm.common.enums.ReceiveType;
import com.kuaike.scrm.common.service.dto.SelectedContact2WeworkUserDto;
import com.kuaike.scrm.common.utils.DateUtil;
import com.kuaike.scrm.common.utils.IdGen;
import com.kuaike.scrm.common.utils.LoginUtils;
import com.kuaike.scrm.dal.groupsend.entity.GroupInviteContactDetail;
import com.kuaike.scrm.dal.groupsend.entity.GroupInviteRoom;
import com.kuaike.scrm.dal.groupsend.entity.GroupInviteTask;
import com.kuaike.scrm.dal.groupsend.entity.GroupInviteUserDetail;
import com.kuaike.scrm.dal.groupsend.entity.MessageGroupSendTask;
import com.kuaike.scrm.dal.groupsend.mapper.GroupInviteContactDetailMapper;
import com.kuaike.scrm.dal.groupsend.mapper.GroupInviteRoomMapper;
import com.kuaike.scrm.dal.groupsend.mapper.GroupInviteTaskMapper;
import com.kuaike.scrm.dal.groupsend.mapper.GroupInviteUserDetailMapper;
import com.kuaike.scrm.dal.wework.mapper.WeworkChatRoomMapper;
import com.kuaike.scrm.dal.wework.mapper.WeworkChatRoomRelationMapper;
import com.kuaike.scrm.groupinvite.dto.GroupInviteContentDto;
import com.kuaike.scrm.groupinvite.dto.req.GroupInviteAddReq;
import com.kuaike.scrm.groupinvite.dto.req.GroupInviteFilterListReq;
import com.kuaike.scrm.groupinvite.dto.req.GroupInviteRoomDto;
import com.kuaike.scrm.groupinvite.dto.resp.GroupInviteCheckResp;
import com.kuaike.scrm.groupinvite.dto.resp.GroupInviteContactDto;
import com.kuaike.scrm.groupinvite.service.GroupInviteCreateService;
import com.kuaike.scrm.groupsend.dto.WeworkUserSendTargetPair;
import com.kuaike.scrm.groupsend.dto.request.AddOrModInnerGroupSendReq;
import com.kuaike.scrm.groupsend.dto.response.MultiSearchContactResp;
import com.kuaike.scrm.groupsend.service.GroupSendWrapService;
import com.kuaike.scrm.groupsend.service.MultiSelectService;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.data.redis.core.ListOperations;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.data.util.Pair;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class GroupInviteCreateServiceImpl
implements GroupInviteCreateService {
    private static final Logger log = LoggerFactory.getLogger(GroupInviteCreateServiceImpl.class);
    @Autowired
    private GroupSendWrapService groupSendWrapService;
    @Value(value="${group.invite.maxRoomMemberCount:200}")
    private Integer maxRoomMemberCount;
    @Value(value="${group.invite.deadline:7}")
    private Integer groupInviteDeadline;
    @Value(value="${group.invite.filterCacheExpire:30}")
    private Long expireMinutes;
    @Value(value="${spring.redis.key.prefix}")
    private String redisPrefix;
    @Autowired
    private RedisTemplate<String, String> redisTemplate;
    @Autowired
    private IdGen idGen;
    @Autowired
    private WeworkChatRoomMapper weworkChatRoomMapper;
    @Autowired
    private WeworkChatRoomRelationMapper weworkChatRoomRelationMapper;
    @Autowired
    private GroupInviteTaskMapper groupInviteTaskMapper;
    @Autowired
    private GroupInviteRoomMapper groupInviteRoomMapper;
    @Autowired
    private GroupInviteUserDetailMapper groupInviteUserDetailMapper;
    @Autowired
    private GroupInviteContactDetailMapper groupInviteContactDetailMapper;
    @Autowired
    private MultiSelectService multiSelectService;
    @Autowired
    private GroupInviteCreateService groupInviteCreateService;

    private void validateLoginUser() {
        CurrentUserInfo currentUser = LoginUtils.getCurrentUser();
        Preconditions.checkArgument((currentUser != null ? 1 : 0) != 0, (Object)"\u7528\u6237\u672a\u767b\u5f55");
        Long operatorId = currentUser.getId();
        Long bizId = currentUser.getBizId();
        String corpId = currentUser.getCorpId();
        Preconditions.checkArgument((operatorId != null ? 1 : 0) != 0, (Object)"\u7528\u6237ID\u4e3a\u7a7a");
        Preconditions.checkArgument((bizId != null ? 1 : 0) != 0, (Object)"\u5546\u6237ID\u4e3a\u7a7a");
        Preconditions.checkArgument((boolean)StringUtils.isNotBlank((CharSequence)corpId), (Object)"\u4f01\u4e1aID\u4e3a\u7a7a");
    }

    @Override
    public GroupInviteCheckResp check(GroupInviteAddReq params) {
        Set externalUserIds;
        log.info("check group invite, params={}, operatorId={}", (Object)params, (Object)LoginUtils.getCurrentUserId());
        Preconditions.checkArgument((params != null ? 1 : 0) != 0, (Object)"\u53c2\u6570\u4e3a\u7a7a");
        Preconditions.checkArgument((params.getGroupsendContact() != null ? 1 : 0) != 0, (Object)"\u9009\u62e9\u53d1\u9001\u5ba2\u6237\u7684\u6761\u4ef6\u4e3a\u7a7a");
        HashSet<String> existRoomIds = new HashSet<String>();
        Preconditions.checkArgument((boolean)CollectionUtils.isNotEmpty(params.getWeworkRoomList()), (Object)"\u6ca1\u6709\u9009\u62e9\u7fa4");
        for (GroupInviteRoomDto it2 : params.getWeworkRoomList()) {
            Preconditions.checkArgument((boolean)StringUtils.isNotBlank((CharSequence)it2.getId()), (Object)"\u6240\u9009\u7fa4ID\u4e3a\u7a7a");
            Preconditions.checkArgument((boolean)StringUtils.isNotBlank((CharSequence)it2.getQrcode()), (Object)"\u672a\u8bbe\u7f6e\u7fa4\u4e8c\u7ef4\u7801");
            Preconditions.checkArgument((!existRoomIds.contains(it2.getId()) ? 1 : 0) != 0, (Object)"\u6240\u9009\u7fa4\u4e0d\u53ef\u91cd\u590d");
            existRoomIds.add(it2.getId());
        }
        Preconditions.checkArgument((params.getContactFilter() != null ? 1 : 0) != 0, (Object)"\u8fc7\u6ee4\u5ba2\u6237\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a");
        Preconditions.checkArgument((params.getContactFilter() == 0 || params.getContactFilter() == 1 ? 1 : 0) != 0, (Object)"\u8fc7\u6ee4\u5ba2\u6237\u53c2\u6570\u4e0d\u5408\u6cd5");
        this.validateLoginUser();
        String corpId = LoginUtils.getCurrentUserCorpId();
        List<String> roomIds = params.getWeworkRoomList().stream().map(it -> it.getId()).collect(Collectors.toList());
        Map<String, Integer> memberLimitMap = this.getMemberLimitMap(corpId, roomIds);
        int roomCount = memberLimitMap.values().stream().mapToInt(Integer::intValue).sum();
        GroupInviteCheckResp resp = new GroupInviteCheckResp();
        resp.setPlanCount(0);
        resp.setRoomCount(roomCount);
        resp.setFilterCount(0);
        params.getGroupsendContact().setCorpId(corpId);
        MultiSearchContactResp selected = this.multiSelectService.multiSearchContact(params.getGroupsendContact(), true);
        if (selected == null || CollectionUtils.isEmpty(selected.getList())) {
            return resp;
        }
        List<Object> list = selected.getList();
        int totalCount = list.size();
        List<GroupInviteContactDto> filterList = Collections.emptyList();
        if (params.getContactFilter() == 1 && CollectionUtils.isNotEmpty((Collection)(externalUserIds = this.weworkChatRoomRelationMapper.selectMemberIdsByCorpIdAndRoomIds(corpId, roomIds)))) {
            filterList = list.stream().filter(it -> externalUserIds.contains(it.getContactId())).map(it -> this.apply((SelectedContact2WeworkUserDto)it)).collect(Collectors.toList());
            list = list.stream().filter(it -> !externalUserIds.contains(it.getContactId())).collect(Collectors.toList());
        }
        String filterCacheKey = this.saveFilterList(filterList);
        int filterCount = filterList.size();
        resp.setPlanCount(totalCount - filterCount);
        resp.setFilterCount(filterCount);
        resp.setFilterCacheKey(filterCacheKey);
        return resp;
    }

    private GroupInviteContactDto apply(SelectedContact2WeworkUserDto it) {
        GroupInviteContactDto dto = new GroupInviteContactDto();
        dto.setId(it.getContactId());
        dto.setName(it.getContactName());
        dto.setAvatar(it.getContactAvatar());
        dto.setCorpName(it.getContactCorpName());
        return dto;
    }

    private String cacheKey(String id) {
        return this.redisPrefix + "gi:filter:" + id;
    }

    private String saveFilterList(List<GroupInviteContactDto> list) {
        if (CollectionUtils.isEmpty(list)) {
            return null;
        }
        String filterCacheKey = UUID.randomUUID().toString();
        List values = list.stream().map(it -> JacksonUtil.obj2Str((Object)it)).collect(Collectors.toList());
        String key = this.cacheKey(filterCacheKey);
        ListOperations ops = this.redisTemplate.opsForList();
        ops.rightPushAll((Object)key, values);
        this.redisTemplate.expire((Object)key, this.expireMinutes.longValue(), TimeUnit.MINUTES);
        return filterCacheKey;
    }

    @Override
    public List<GroupInviteContactDto> filterList(GroupInviteFilterListReq params) {
        String key;
        log.info("queru group invite filter list, params={}, operatorId={}", (Object)params, (Object)LoginUtils.getCurrentUserId());
        Preconditions.checkArgument((params != null ? 1 : 0) != 0, (Object)"\u53c2\u6570\u4e3a\u7a7a");
        Preconditions.checkArgument((params.getFilterCacheKey() != null ? 1 : 0) != 0, (Object)"\u7f13\u5b58\u53c2\u6570\u4e3a\u7a7a");
        this.validateLoginUser();
        int start = 0;
        int end = -1;
        PageDto pageDto = params.getPageDto();
        if (pageDto != null) {
            start = pageDto.getOffset();
            end = start + pageDto.getPageSize() - 1;
        }
        if (!this.redisTemplate.hasKey((Object)(key = this.cacheKey(params.getFilterCacheKey()))).booleanValue()) {
            log.info("\u7f13\u5b58\u4e0d\u5b58\u5728, key={}", (Object)key);
            if (pageDto != null) {
                pageDto.setCount(Integer.valueOf(0));
            }
            return Collections.emptyList();
        }
        ListOperations ops = this.redisTemplate.opsForList();
        List values = ops.range((Object)key, (long)start, (long)end);
        Long size = ops.size((Object)key);
        this.redisTemplate.expire((Object)key, this.expireMinutes.longValue(), TimeUnit.MINUTES);
        if (pageDto != null) {
            pageDto.setCount(Integer.valueOf(size.intValue()));
            pageDto.setCurPageCount(Integer.valueOf(values.size()));
        }
        ArrayList result = Lists.newArrayList();
        for (String value : values) {
            GroupInviteContactDto dto = null;
            try {
                dto = (GroupInviteContactDto)JacksonUtil.str2Obj((String)value, GroupInviteContactDto.class);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            result.add(dto);
        }
        return result;
    }

    @Override
    public void clearFilterCache(GroupInviteFilterListReq params) {
        log.info("queru group invite filter list, params={}, operatorId={}", (Object)params, (Object)LoginUtils.getCurrentUserId());
        Preconditions.checkArgument((params != null ? 1 : 0) != 0, (Object)"\u53c2\u6570\u4e3a\u7a7a");
        Preconditions.checkArgument((params.getFilterCacheKey() != null ? 1 : 0) != 0, (Object)"\u7f13\u5b58\u53c2\u6570\u4e3a\u7a7a");
        this.validateLoginUser();
        String key = this.cacheKey(params.getFilterCacheKey());
        if (this.redisTemplate.hasKey((Object)key).booleanValue()) {
            log.info("\u6e05\u9664\u7f13\u5b58, key={}", (Object)key);
            this.redisTemplate.delete((Object)key);
        }
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public String add(GroupInviteAddReq params) {
        Set externalUserIds;
        log.info("add group invite, params={}, operatorId={}", (Object)params, (Object)LoginUtils.getCurrentUserId());
        Preconditions.checkArgument((params != null ? 1 : 0) != 0, (Object)"\u53c2\u6570\u4e3a\u7a7a");
        params.validate();
        this.validateLoginUser();
        CurrentUserInfo currentUser = LoginUtils.getCurrentUser();
        Long operatorId = currentUser.getId();
        Long bizId = currentUser.getBizId();
        String corpId = currentUser.getCorpId();
        List<String> roomIds = params.getWeworkRoomList().stream().map(it -> it.getId()).collect(Collectors.toList());
        Map<String, Integer> memberLimitMap = this.getMemberLimitMap(corpId, roomIds);
        int roomCount = memberLimitMap.values().stream().mapToInt(Integer::intValue).sum();
        params.getGroupsendContact().setCorpId(corpId);
        MultiSearchContactResp selected = this.multiSelectService.multiSearchContact(params.getGroupsendContact(), true);
        if (selected == null || CollectionUtils.isEmpty(selected.getList())) {
            throw new BusinessException((UniverseErrorCode)CommonErrorCode.BUSINESS_ERROR, "\u6ca1\u6709\u8981\u9080\u8bf7\u7684\u5ba2\u6237");
        }
        List<Object> list = selected.getList();
        if (params.getContactFilter() == 1 && CollectionUtils.isNotEmpty((Collection)(externalUserIds = this.weworkChatRoomRelationMapper.selectMemberIdsByCorpIdAndRoomIds(corpId, roomIds))) && CollectionUtils.isEmpty(list = list.stream().filter(it -> !externalUserIds.contains(it.getContactId())).collect(Collectors.toList()))) {
            throw new BusinessException((UniverseErrorCode)CommonErrorCode.BUSINESS_ERROR, "\u6240\u6709\u5ba2\u6237\u90fd\u88ab\u8fc7\u6ee4\uff0c\u6ca1\u6709\u8981\u9080\u8bf7\u7684\u5ba2\u6237");
        }
        int planCount = list.size();
        if (planCount > roomCount) {
            this.weightedAvg(roomIds, memberLimitMap, roomCount, planCount);
        }
        GroupInviteTask record = this.saveTask(bizId, corpId, operatorId, params, planCount);
        Long taskId = record.getId();
        List<GroupInviteRoom> roomList = this.buildInviteRoom(bizId, corpId, operatorId, taskId, params.getWeworkRoomList(), memberLimitMap);
        Pair<List<GroupInviteUserDetail>, List<GroupInviteContactDetail>> assignment = this.assign(taskId, bizId, corpId, operatorId, list, params.getWeworkRoomList(), memberLimitMap);
        List userDetailList = (List)assignment.getFirst();
        List contactDetailList = (List)assignment.getSecond();
        this.groupInviteCreateService.create(record, params.getContext(), roomList, userDetailList, contactDetailList);
        this.groupInviteRoomMapper.batchInsert(roomList);
        this.groupInviteUserDetailMapper.batchInsert((Collection)userDetailList);
        this.groupInviteContactDetailMapper.batchInsert((Collection)contactDetailList);
        return record.getNum();
    }

    private Map<String, Integer> getMemberLimitMap(String corpId, List<String> roomIds) {
        Map nameMap = this.weworkChatRoomMapper.queryNameMap(corpId, roomIds);
        Map countMap = this.weworkChatRoomRelationMapper.getRoomIdAndMemberCountByCorpIdAndRoomIds(corpId, roomIds);
        for (String roomId : roomIds) {
            Preconditions.checkArgument((nameMap.containsKey(roomId) && countMap.containsKey(roomId) ? 1 : 0) != 0, (Object)("\u7fa4\u4e0d\u5b58\u5728\u6216\u5df2\u5220\u9664. [" + roomId + "]"));
            String name = (String)nameMap.get(roomId);
            Integer memberCount = (Integer)countMap.get(roomId);
            Preconditions.checkArgument((memberCount < this.maxRoomMemberCount ? 1 : 0) != 0, (Object)("\u7fa4\u6210\u5458\u6570\u91cf\u8fbe\u5230" + this.maxRoomMemberCount + "\u4eba\u4e0a\u9650, \u65e0\u6cd5\u9080\u8bf7\u5165\u7fa4.[" + name + "]"));
            int limit = this.maxRoomMemberCount - memberCount;
            countMap.put(roomId, limit);
        }
        return countMap;
    }

    private LinkedList<Pair<String, String>> sort(List<SelectedContact2WeworkUserDto> list) {
        List weworkUserNums = list.stream().map(it -> it.getWeworkNum()).distinct().collect(Collectors.toList());
        Map sendMap = list.stream().collect(Collectors.groupingBy(it -> it.getWeworkNum(), Collectors.mapping(it -> it.getContactId(), Collectors.toList())));
        LinkedList pairs = Lists.newLinkedList();
        for (String weworkUserNum : weworkUserNums) {
            List contactIds = sendMap.get(weworkUserNum);
            for (String contactId : contactIds) {
                pairs.add(Pair.of((Object)weworkUserNum, (Object)contactId));
            }
        }
        return pairs;
    }

    private Pair<List<GroupInviteUserDetail>, List<GroupInviteContactDetail>> assign(Long taskId, Long bizId, String corpId, Long operatorId, List<SelectedContact2WeworkUserDto> list, List<GroupInviteRoomDto> roomList, Map<String, Integer> memberLimitMap) {
        LinkedList<Pair<String, String>> pairs = this.sort(list);
        LinkedList roomIds = roomList.stream().map(it -> it.getId()).collect(Collectors.toCollection(LinkedList::new));
        ArrayList userDetailList = Lists.newArrayList();
        ArrayList contactDetailList = Lists.newArrayList();
        Date now = new Date();
        Long msgIdx = 0L;
        while (pairs.size() > 0 && roomIds.size() > 0) {
            String roomId = (String)roomIds.removeFirst();
            int limit = memberLimitMap.get(roomId);
            int size = Math.min(limit, pairs.size());
            ArrayList cur = Lists.newArrayListWithCapacity((int)size);
            for (int i = 0; i < size; ++i) {
                cur.add(pairs.removeFirst());
            }
            List curNums = cur.stream().map(it -> (String)it.getFirst()).distinct().collect(Collectors.toList());
            Map curSendMap = cur.stream().collect(Collectors.groupingBy(it -> (String)it.getFirst(), Collectors.mapping(it -> (String)it.getSecond(), Collectors.toList())));
            for (String num : curNums) {
                List contactIds = curSendMap.get(num);
                Long msgId = msgIdx = Long.valueOf(msgIdx + 1L);
                GroupInviteUserDetail userDetail = new GroupInviteUserDetail();
                userDetail.setBizId(bizId);
                userDetail.setCorpId(corpId);
                userDetail.setTaskId(taskId);
                userDetail.setMsgId(msgId);
                userDetail.setWeworkUserNum(num);
                userDetail.setWeworkRoomId(roomId);
                userDetail.setPlanCount(Integer.valueOf(contactIds.size()));
                userDetail.setCreateBy(operatorId);
                userDetail.setCreateTime(now);
                userDetail.setUpdateBy(operatorId);
                userDetail.setUpdateTime(now);
                userDetailList.add(userDetail);
                for (String contactId : contactIds) {
                    GroupInviteContactDetail contactDetail = new GroupInviteContactDetail();
                    contactDetail.setBizId(bizId);
                    contactDetail.setCorpId(corpId);
                    contactDetail.setTaskId(taskId);
                    contactDetail.setMsgId(msgId);
                    contactDetail.setContactId(contactId);
                    contactDetail.setWeworkUserNum(num);
                    contactDetail.setWeworkRoomId(roomId);
                    contactDetail.setJoinStatus(Integer.valueOf(0));
                    contactDetail.setCreateBy(operatorId);
                    contactDetail.setCreateTime(now);
                    contactDetail.setUpdateBy(operatorId);
                    contactDetail.setUpdateTime(now);
                    contactDetailList.add(contactDetail);
                }
            }
        }
        Pair result = Pair.of((Object)userDetailList, (Object)contactDetailList);
        return result;
    }

    private void weightedAvg(List<String> roomIds, Map<String, Integer> memberLimitMap, int roomCount, int planCount) {
        if (planCount <= roomCount) {
            return;
        }
        double factor = 1.0 * (double)planCount / (double)roomCount;
        for (String roomId : roomIds) {
            int limit = memberLimitMap.get(roomId);
            if (limit == 0) continue;
            limit = (int)Math.ceil((double)limit * factor);
            memberLimitMap.put(roomId, limit);
        }
    }

    private GroupInviteTask saveTask(Long bizId, String corpId, Long operatorId, GroupInviteAddReq params, int planCount) {
        String parmasJson = JacksonUtil.obj2Str((Object)params.getGroupsendContact());
        String contentJson = JacksonUtil.obj2Str((Object)params.getContext());
        Date deadline = DateUtil.getDateAddDay((Date)new Date(), (int)this.groupInviteDeadline);
        GroupInviteTask record = new GroupInviteTask();
        record.setNum(this.idGen.getNum());
        record.setBizId(bizId);
        record.setCorpId(corpId);
        record.setName(params.getName());
        record.setParamsJson(parmasJson);
        record.setContentJson(contentJson);
        record.setDeadline(deadline);
        record.setIsAdvanced(params.getIsAdvanced());
        record.setContactFilter(params.getContactFilter());
        record.setPlanCount(Integer.valueOf(planCount));
        record.setCreateBy(operatorId);
        record.setCreateTime(new Date());
        record.setUpdateBy(operatorId);
        record.setUpdateTime(new Date());
        this.groupInviteTaskMapper.insertSelective((Object)record);
        return record;
    }

    private List<GroupInviteRoom> buildInviteRoom(Long bizId, String corpId, Long operatorId, Long taskId, List<GroupInviteRoomDto> weworkRoomList, Map<String, Integer> memberCountMap) {
        ArrayList roomList = Lists.newArrayList();
        for (GroupInviteRoomDto dto : weworkRoomList) {
            GroupInviteRoom room = new GroupInviteRoom();
            room.setBizId(bizId);
            room.setCorpId(corpId);
            room.setTaskId(taskId);
            room.setWeworkRoomId(dto.getId());
            room.setQrcode(dto.getQrcode());
            room.setLimit(memberCountMap.get(dto.getId()));
            room.setCreateBy(operatorId);
            room.setCreateTime(new Date());
            room.setUpdateBy(operatorId);
            room.setUpdateTime(new Date());
            roomList.add(room);
        }
        return roomList;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void create(GroupInviteTask task, GroupInviteContentDto content, List<GroupInviteRoom> roomList, List<GroupInviteUserDetail> userDetailList, List<GroupInviteContactDetail> contactDetailList) {
        Map<String, String> qrcodeMap = roomList.stream().collect(Collectors.toMap(it -> it.getWeworkRoomId(), it -> it.getQrcode()));
        Map<Long, List<GroupInviteContactDetail>> contactDetaulMap = contactDetailList.stream().collect(Collectors.groupingBy(it -> it.getMsgId()));
        List<UniformMsgDto> share = this.buildContentList(content);
        for (GroupInviteUserDetail u : userDetailList) {
            List<GroupInviteContactDetail> contactList = contactDetaulMap.get(u.getMsgId());
            this.create(task, u, contactList, share, qrcodeMap);
        }
    }

    private List<UniformMsgDto> buildContentList(GroupInviteContentDto content) {
        ArrayList list = Lists.newArrayList();
        String contentText = content.getText();
        if (StringUtils.isNotBlank((CharSequence)contentText)) {
            UniformMsgDto msg = new UniformMsgDto();
            msg.setMsgType(JsMsgType.text.name());
            msg.setContent(contentText);
            list.add(msg);
        }
        if (CollectionUtils.isNotEmpty(content.getAttachments())) {
            for (AttachmentDto dto : content.getAttachments()) {
                UniformMsgDto msg;
                String msgType = dto.getMsgType();
                if ("image".equals(msgType)) {
                    msg = this.toImage(dto);
                    list.add(msg);
                    continue;
                }
                if ("link".equals(msgType)) {
                    msg = this.toLink(dto);
                    list.add(msg);
                    continue;
                }
                if ("video".equals(msgType)) {
                    msg = this.toVideo(dto);
                    list.add(msg);
                    continue;
                }
                if (!"miniprogram".equals(msgType)) continue;
                msg = this.toMiniProgrm(dto);
                list.add(msg);
            }
        }
        return list;
    }

    private UniformMsgDto qrcodeMsg(String qrcode) {
        FileDto file = new FileDto();
        file.setFileUrl(qrcode);
        UniformMsgDto msg = new UniformMsgDto();
        msg.setMsgType(JsMsgType.image.name());
        msg.setFile(file);
        return msg;
    }

    private UniformMsgDto toImage(AttachmentDto params) {
        FileDto file = new FileDto();
        file.setFileUrl(params.getUrl());
        UniformMsgDto msg = new UniformMsgDto();
        msg.setMsgType(JsMsgType.image.name());
        msg.setFile(file);
        return msg;
    }

    private UniformMsgDto toVideo(AttachmentDto params) {
        FileDto file = new FileDto();
        file.setFileUrl(params.getUrl());
        UniformMsgDto msg = new UniformMsgDto();
        msg.setMsgType(JsMsgType.video.name());
        msg.setFile(file);
        return msg;
    }

    private UniformMsgDto toLink(AttachmentDto params) {
        JsNewsDto news = new JsNewsDto();
        news.setTitle(params.getTitle());
        news.setDesc(params.getDesc());
        news.setImgUrl(params.getPicUrl());
        news.setLink(params.getUrl());
        UniformMsgDto msg = new UniformMsgDto();
        msg.setMsgType(JsMsgType.news.name());
        msg.setNews(news);
        return msg;
    }

    private UniformMsgDto toMiniProgrm(AttachmentDto params) {
        MiniProgramDto miniProgram = new MiniProgramDto();
        miniProgram.setAppid(params.getAppId());
        miniProgram.setPage(params.getPage());
        miniProgram.setTitle(params.getTitle());
        miniProgram.setImgUrl(params.getPicUrl());
        UniformMsgDto msg = new UniformMsgDto();
        msg.setMsgType(JsMsgType.miniprogram.name());
        msg.setMiniprogram(miniProgram);
        return msg;
    }

    private List<WeworkUserSendTargetPair> toTargetList(String weworkUserNum, List<String> contactIds) {
        ArrayList list = Lists.newArrayListWithCapacity((int)contactIds.size());
        for (String contactId : contactIds) {
            WeworkUserSendTargetPair pair = new WeworkUserSendTargetPair();
            pair.setWeworkUserNum(weworkUserNum);
            pair.setTargetId(contactId);
            list.add(pair);
        }
        return list;
    }

    private void create(GroupInviteTask task, GroupInviteUserDetail u, List<GroupInviteContactDetail> contactList, List<UniformMsgDto> share, Map<String, String> qrcodeMap) {
        String qrcode = qrcodeMap.get(u.getWeworkRoomId());
        String weworkUserNum = u.getWeworkUserNum();
        List<String> externalUserIds = contactList.stream().map(it -> it.getContactId()).collect(Collectors.toList());
        log.info("\u7fa4\u53d1\u6d88\u606f, weworkUserNum:{}, externalUserIds:{}, qrcode:{}", new Object[]{weworkUserNum, externalUserIds, qrcode});
        AddOrModInnerGroupSendReq req = new AddOrModInnerGroupSendReq();
        req.setTaskName(task.getName());
        req.setFkTaskId(task.getId());
        req.setFkType(GroupSendFkType.QRCODE_PULL.getType());
        req.setDeadlineTime(task.getDeadline());
        req.setTaskType(GroupSendTaskType.QYAPI.getValue());
        req.setAutoChangeTaskType(task.getIsAdvanced() == 0 ? 0 : 1);
        ArrayList contentList = Lists.newArrayList();
        contentList.addAll(share);
        contentList.add(this.qrcodeMsg(qrcode));
        req.setContentList(contentList);
        List<WeworkUserSendTargetPair> targetList = this.toTargetList(weworkUserNum, externalUserIds);
        req.setReceiveType(ReceiveType.CONTACT.getType());
        req.setSendTargetPairs(targetList);
        MessageGroupSendTask record = this.groupSendWrapService.addOrModInnerGroupSend(req);
        Long msgId = record.getId();
        u.setMsgId(msgId);
        for (GroupInviteContactDetail c : contactList) {
            c.setMsgId(msgId);
        }
    }
}

