/*
 * Decompiled with CFR 0.152.
 */
package com.kuaike.scrm.service.impl;

import cn.kinyun.scrm.page.auth.service.ShortUrlService;
import cn.kinyun.scrm.weixin.sdk.api.WxOAuth2API;
import cn.kinyun.scrm.weixin.sdk.entity.sns.SnsAccessToken;
import cn.kinyun.scrm.weixin.sdk.entity.sns.SnsUserinfo;
import cn.kinyun.scrm.weixin.token.ComponentTokenService;
import com.alibaba.fastjson.JSONObject;
import com.google.common.base.Preconditions;
import com.kuaike.common.errorcode.CommonErrorCode;
import com.kuaike.common.errorcode.UniverseErrorCode;
import com.kuaike.common.exception.BusinessException;
import com.kuaike.scrm.common.dto.StopWatchDto;
import com.kuaike.scrm.common.enums.MeetingStatus;
import com.kuaike.scrm.common.enums.OauthShortUrlTypeEnum;
import com.kuaike.scrm.common.enums.WxOAuthScope;
import com.kuaike.scrm.common.enums.meeting.MeetingLiveDeliveryAuthMode;
import com.kuaike.scrm.common.service.ParamEncryService;
import com.kuaike.scrm.common.service.dto.MeetingParams;
import com.kuaike.scrm.common.utils.IdGen;
import com.kuaike.scrm.common.utils.NamedThreadFactory;
import com.kuaike.scrm.common.utils.ThreadPoolMonitorUtils;
import com.kuaike.scrm.dal.marketing.entity.OauthShortUrl;
import com.kuaike.scrm.dal.meeting.entity.Meeting;
import com.kuaike.scrm.dal.meeting.entity.MeetingCustomerInfo;
import com.kuaike.scrm.dal.meeting.entity.MeetingSetting;
import com.kuaike.scrm.dal.meeting.mapper.MeetingCustomerInfoMapper;
import com.kuaike.scrm.dal.meeting.mapper.ParamEncryMapper;
import com.kuaike.scrm.dal.official.base.entity.OfficialAccount;
import com.kuaike.scrm.dal.official.base.mapper.OfficialAccountMapper;
import com.kuaike.scrm.dto.GoodsDetailOfficialAuthUrlDto;
import com.kuaike.scrm.dto.MeetingCustomerInfoDto;
import com.kuaike.scrm.service.MeetingCacheService;
import com.kuaike.scrm.service.MeetingUrlCommonService;
import com.kuaike.scrm.service.MeetingUrlService;
import com.kuaike.trace.utils.TraceIdUtils;
import java.net.URLEncoder;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.LinkedBlockingDeque;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import javax.annotation.PostConstruct;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class MeetingUrlServiceImpl
implements MeetingUrlService {
    private static final Logger log = LoggerFactory.getLogger(MeetingUrlServiceImpl.class);
    private static final String LIVE_DELIVERY_USER_INFO_URL = "https://open.weixin.qq.com/connect/oauth2/authorize?appid=${appId}&redirect_uri=${redirect_uri}&response_type=code&scope=snsapi_userinfo&component_appid=${component_appid}";
    private static final String LIVE_DELIVERY_USER_BASE_URL = "https://open.weixin.qq.com/connect/oauth2/authorize?appid=${appId}&redirect_uri=${redirect_uri}&response_type=code&scope=snsapi_base&component_appid=${component_appid}";
    private static final String BACKEND_MEETING_COMMERCE_URL = "/meeting/backendMeetingCommerceUrl.json";
    @Value(value="${scrm.meeting.deliveryCallbackUrl:}")
    private String meetingDeliveryCallbackUrl;
    @Value(value="${scrm.meeting.deliveryGoodsDetailCallbackUrl:}")
    private String deliveryGoodsDetailCallbackUrl;
    @Value(value="${scrm.meeting.playbackAuthCallbackUrl:}")
    private String playbackAuthCallbackUrl;
    @Value(value="${scrm.meeting.authMiddlePage:}")
    private String authMiddlePage;
    @Value(value="${scrm.domain.protocol}")
    private String domainProtocol;
    @Value(value="${scrm.domain.scrm-manager}")
    private String managerDomain;
    @Resource
    private ComponentTokenService componentTokenService;
    @Resource
    private ShortUrlService shortUrlService;
    @Resource
    private IdGen idGen;
    @Resource
    private WxOAuth2API wxOAuth2API;
    @Resource
    private MeetingUrlCommonService meetingUrlCommonService;
    @Resource
    private MeetingCacheService meetingCacheService;
    @Resource
    private OfficialAccountMapper officialAccountMapper;
    @Resource
    private MeetingCustomerInfoMapper meetingCustomerInfoMapper;
    @Resource
    private ParamEncryService paramEncryService;
    @Resource
    private ParamEncryMapper paramEncryMapper;
    private final int size = Runtime.getRuntime().availableProcessors();
    private final ExecutorService threadPool = new ThreadPoolExecutor(this.size, this.size * 2, 10L, TimeUnit.SECONDS, new LinkedBlockingDeque<Runnable>(1024), (ThreadFactory)new NamedThreadFactory("meetingUrlService"), new ThreadPoolExecutor.CallerRunsPolicy());

    @PostConstruct
    public void init() {
        ThreadPoolMonitorUtils.addToMonitor((ExecutorService)this.threadPool);
    }

    @Override
    public String getBackendMeetingCommerceUrl(Long bizId, String meetingNum, String meetingOriginUrl, String channelNum, String weworkUserNum, boolean isPlayback) {
        log.info("getBackendMeetingCommerceUrl bizId:{} channelNum:{} meetingNum:{} weworkUserNum:{} isPlayback:{}", new Object[]{bizId, channelNum, meetingNum, weworkUserNum, isPlayback});
        OfficialAccount officialAccount = this.officialAccountMapper.queryLatestByBizId(bizId);
        if (officialAccount == null) {
            return meetingOriginUrl;
        }
        String appId = officialAccount.getAppId();
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(this.domainProtocol).append(this.managerDomain).append(BACKEND_MEETING_COMMERCE_URL).append("?meetingNum=").append(meetingNum);
        if (StringUtils.isNotBlank((CharSequence)channelNum)) {
            stringBuilder.append("&channelNum=").append(channelNum);
        }
        if (StringUtils.isNotBlank((CharSequence)weworkUserNum)) {
            stringBuilder.append("&weworkUserNum=").append(weworkUserNum);
        }
        stringBuilder.append("&isPlayback=").append(isPlayback);
        String shortUrl = this.getShortUrl(stringBuilder.toString(), appId);
        log.info("getBackendMeetingCommerceUrl,longUrl:{},shortUrl:{}", (Object)stringBuilder.toString(), (Object)shortUrl);
        return shortUrl;
    }

    @Override
    public void backendMeetingCommerceUrlResponse(String meetingNum, String channelNum, String weworkUserNum, boolean isPlayback, HttpServletRequest request, HttpServletResponse response) {
        String longUrl;
        log.info("backendMeetingCommerceUrlResponse,meetingNum:{},channelNum:{},weworkUserNum:{},isPlayback:{}", new Object[]{meetingNum, channelNum, weworkUserNum, isPlayback});
        if (StringUtils.isBlank((CharSequence)meetingNum)) {
            log.info("backendMeetingCommerceUrlResponse,meetingNum is blank");
            return;
        }
        Meeting meeting = this.meetingCacheService.getMeetingByNum(meetingNum);
        if (meeting == null) {
            log.info("backendMeetingCommerceUrlResponse,meeting is null");
            return;
        }
        String userAgent = request.getHeader("User-Agent");
        if (StringUtils.isBlank((CharSequence)userAgent)) {
            longUrl = this.meetingUrlCommonService.buildOriginMeetingUrlAndGenCustomerStr(meeting, channelNum, weworkUserNum, "", "", "", null, isPlayback, false);
        } else {
            userAgent = userAgent.toLowerCase(Locale.getDefault());
            log.info("backendMeetingCommerceUrlResponse,userAgent:{}", (Object)userAgent);
            longUrl = userAgent.contains("micromessenger") ? (isPlayback ? this.getWechatAuthMeetingCommercePlaybackUrl(meeting, false) : this.getWechatAuthMeetingCommerceUrl(meeting.getBizId(), meeting.getRoomId(), channelNum, meetingNum, weworkUserNum, false)) : this.meetingUrlCommonService.buildOriginMeetingUrlAndGenCustomerStr(meeting, channelNum, weworkUserNum, "", "", "", null, isPlayback, false);
        }
        try {
            response.sendRedirect(longUrl);
        }
        catch (Exception e) {
            log.error("backendMeetingCommerceUrlResponse,redirect error,longUrl:{}", (Object)longUrl, (Object)e);
        }
    }

    private String getShortUrl(String longUrl, String appId) {
        OauthShortUrl byOriginUrl = this.shortUrlService.getByOriginUrl(longUrl);
        if (byOriginUrl != null) {
            String shortUlr = this.shortUrlService.getShortUlr(byOriginUrl.getShortUrl());
            log.info("getShortUrl:{}", (Object)shortUlr);
            return shortUlr;
        }
        String shortUrlNum = this.idGen.getNum();
        this.shortUrlService.recordShortUrl(appId, Integer.valueOf(OauthShortUrlTypeEnum.MEETING_AUTH_URL.getValue()), longUrl, longUrl, shortUrlNum);
        return this.shortUrlService.getShortUlr(shortUrlNum);
    }

    @Override
    public String getWechatAuthMeetingCommerceUrl(Long bizId, String roomId, String channelNum, String meetingNum, String weworkUserNum, boolean returnShortUrl) {
        String redirectUrl;
        log.info("getWechatAuthMeetingCommerceUrl bizId:{} roomId:{} channelNum:{} meetingNum:{} weworkUserNum:{}", new Object[]{bizId, roomId, channelNum, meetingNum, weworkUserNum});
        String appId = this.meetingCacheService.getOfficialAppId(bizId);
        if (StringUtils.isBlank((CharSequence)appId)) {
            Meeting meeting = this.meetingCacheService.getMeetingByNum(meetingNum);
            if (Objects.isNull(meeting)) {
                throw new BusinessException((UniverseErrorCode)CommonErrorCode.BUSINESS_ERROR, "\u76f4\u64ad\u4e0d\u5b58\u5728");
            }
            return this.meetingUrlCommonService.buildOriginMeetingUrlAndGenCustomerStr(meeting, channelNum, weworkUserNum, "", "", "", null, false, true);
        }
        String componentAppId = this.componentTokenService.getWechatAppId();
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(this.meetingDeliveryCallbackUrl).append("?roomId=").append(roomId).append("&meetingNum=").append(meetingNum);
        if (StringUtils.isNotBlank((CharSequence)channelNum)) {
            stringBuilder.append("&channelNum=").append(channelNum);
        }
        if (StringUtils.isNotBlank((CharSequence)weworkUserNum)) {
            stringBuilder.append("&weworkUserNum=").append(weworkUserNum);
        }
        try {
            redirectUrl = URLEncoder.encode(stringBuilder.toString(), "utf-8");
        }
        catch (Exception e) {
            log.error("getWechatAuthMeetingCommerceUrl encode url error", (Throwable)e);
            throw new BusinessException((UniverseErrorCode)CommonErrorCode.BUSINESS_ERROR, "\u6784\u9020\u56de\u8c03\u94fe\u63a5\u5f02\u5e38");
        }
        String longUrl = LIVE_DELIVERY_USER_BASE_URL.replace("${appId}", appId).replace("${redirect_uri}", redirectUrl).replace("${component_appid}", componentAppId);
        if (!returnShortUrl) {
            log.info("getWechatAuthMeetingCommerceUrl bizId:{},longUrl:{}", (Object)bizId, (Object)longUrl);
            return longUrl;
        }
        return this.getShortUrl(longUrl, appId);
    }

    private String getWechatAuthMeetingCommerceH5LoginUrl(String channelNum, String meetingNum, String weworkUserNum, Meeting meeting) {
        String authMiddlePageUrl;
        String redirectUrl;
        log.info("getWechatAuthMeetingCommerceUrlBeforeAuthRedirect channelNum:{} meetingNum:{} weworkUserNum:{} meetingId:{}", new Object[]{channelNum, meetingNum, weworkUserNum, meeting.getId()});
        Long bizId = meeting.getBizId();
        String roomId = meeting.getRoomId();
        String appId = this.meetingCacheService.getOfficialAppId(bizId);
        if (StringUtils.isBlank((CharSequence)appId)) {
            log.info("getWechatAuthMeetingCommerceUrlBeforeAuthRedirect getOfficialAppId is null");
            return this.meetingUrlCommonService.buildOriginMeetingUrlAndGenCustomerStr(meeting, channelNum, weworkUserNum, "", "", "", null, false, true);
        }
        String componentAppId = this.componentTokenService.getWechatAppId();
        StringBuilder stringBuilder = new StringBuilder(128);
        stringBuilder.append(this.meetingDeliveryCallbackUrl).append("?roomId=").append(roomId).append("&meetingNum=").append(meetingNum);
        if (StringUtils.isNotBlank((CharSequence)channelNum)) {
            stringBuilder.append("&channelNum=").append(channelNum);
        }
        if (StringUtils.isNotBlank((CharSequence)weworkUserNum)) {
            stringBuilder.append("&weworkUserNum=").append(weworkUserNum);
        }
        try {
            redirectUrl = URLEncoder.encode(stringBuilder.toString(), "utf-8");
        }
        catch (Exception e) {
            log.error("getWechatAuthMeetingCommerceUrlBeforeAuthRedirect encode url error", (Throwable)e);
            return this.meetingUrlCommonService.buildOriginMeetingUrlAndGenCustomerStr(meeting, channelNum, weworkUserNum, appId, "", "", null, false, true);
        }
        String longUrl = LIVE_DELIVERY_USER_INFO_URL.replace("${appId}", appId).replace("${redirect_uri}", redirectUrl).replace("${component_appid}", componentAppId);
        try {
            authMiddlePageUrl = this.authMiddlePage + URLEncoder.encode(longUrl, "utf-8") + "&meetingNum=" + meetingNum;
        }
        catch (Exception e) {
            log.error("getWechatAuthMeetingCommerceUrlBeforeAuthRedirect encode url error", (Throwable)e);
            return this.meetingUrlCommonService.buildOriginMeetingUrlAndGenCustomerStr(meeting, channelNum, weworkUserNum, appId, "", "", null, false, true);
        }
        log.info("getWechatAuthMeetingCommerceUrlBeforeAuthRedirect,authMiddlePageUrl:{}", (Object)authMiddlePageUrl);
        return authMiddlePageUrl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Transactional(rollbackFor={Exception.class})
    public void authRedirect(String code, String roomId, String channelNum, String meetingNum, String weworkUserNum, HttpServletRequest request, HttpServletResponse response) {
        String openId;
        String authScope;
        SnsAccessToken snsAccessToken;
        log.info("authRedirect code:{} roomId:{} channelNum:{} meetingNum:{} weworkUserNum:{}", new Object[]{code, roomId, channelNum, meetingNum, weworkUserNum});
        if (StringUtils.isBlank((CharSequence)meetingNum)) {
            log.error("authRedirect meetingNum is empty code:{}", (Object)code);
            return;
        }
        StopWatchDto timer = new StopWatchDto("meetingOfficialAuthRedirect", true, log);
        timer.start("selectMeeting");
        Meeting meeting = this.meetingCacheService.getMeetingByNum(meetingNum);
        if (meeting == null) {
            log.info("authRedirect meeting is null code:{}", (Object)code);
            timer.stop();
            timer.print();
            return;
        }
        timer.stop();
        if (StringUtils.isBlank((CharSequence)code)) {
            log.info("authRedirect code is empty");
            this.redirectOriginMeetingUrl(meeting, channelNum, weworkUserNum, "", null, null, response);
            return;
        }
        timer.start("selectOfficial");
        Long bizId = meeting.getBizId();
        String appId = this.meetingCacheService.getOfficialAppId(bizId);
        if (StringUtils.isBlank((CharSequence)appId)) {
            log.info("authRedirect officialAccount is null bizId:{} code:{}", (Object)bizId, (Object)code);
            timer.stop();
            timer.print();
            this.redirectOriginMeetingUrl(meeting, channelNum, weworkUserNum, "", null, null, response);
            return;
        }
        timer.stop();
        timer.start("selectMeetingSetting");
        MeetingSetting meetingSetting = this.meetingCacheService.getMeetingSetting(bizId);
        if (meetingSetting == null) {
            log.info("authRedirect meetingSetting is empty bizId:{} code:{}", (Object)bizId, (Object)code);
            timer.stop();
            timer.print();
            this.redirectOriginMeetingUrl(meeting, channelNum, weworkUserNum, "", null, null, response);
            return;
        }
        timer.stop();
        timer.start("getComponentAccessToken");
        String componentAppId = this.componentTokenService.getWechatAppId();
        String componentAccessToken = this.componentTokenService.getComponentAccessToken();
        timer.stop();
        String unionId = null;
        SnsUserinfo snsUserinfo = null;
        try {
            timer.start("getSnsAccessToken");
            snsAccessToken = this.wxOAuth2API.getComponentAccessToken(appId, code, componentAppId, componentAccessToken);
            authScope = snsAccessToken.getScope();
            openId = snsAccessToken.getOpenId();
            timer.stop();
        }
        catch (Exception e) {
            log.error("authRedirect,getComponentAccessToken error,code:{}", (Object)code, (Object)e);
            timer.stop();
            timer.print();
            this.redirectOriginMeetingUrl(meeting, channelNum, weworkUserNum, appId, null, null, response);
            return;
        }
        String headImgUrl = "";
        String nickName = "";
        Integer sex = 0;
        try {
            timer.start("getUserinfo");
            String accessToken = snsAccessToken.getAccessToken();
            snsUserinfo = this.wxOAuth2API.getUserinfo(accessToken, openId, "zh_CN");
            unionId = snsUserinfo.getUnionId();
            headImgUrl = snsUserinfo.getHeadImgUrl();
            nickName = snsUserinfo.getNickname();
            sex = snsUserinfo.getSex();
            timer.stop();
        }
        catch (Exception e) {
            log.error("authRedirect,getComponentAccessToken error,code:{}", (Object)code, (Object)e);
            timer.stop();
        }
        log.info("authRedirect snsUserinfo:{},code:{},snsAccessToken:{}", new Object[]{snsUserinfo, code, snsAccessToken});
        if (WxOAuthScope.SNSAPI_BASE.getValue().equals(authScope) && StringUtils.isBlank((CharSequence)unionId)) {
            try {
                timer.start("getWechatAuthMeetingCommerceH5LoginUrl");
                String wechatAuthMeetingCommerceH5LoginUrl = this.getWechatAuthMeetingCommerceH5LoginUrl(channelNum, meetingNum, weworkUserNum, meeting);
                timer.stop();
                response.sendRedirect(wechatAuthMeetingCommerceH5LoginUrl);
            }
            catch (Exception e) {
                log.error("authRedirect,getWechatAuthMeetingCommerceH5LoginUrl error", (Throwable)e);
                timer.stop();
                this.redirectOriginMeetingUrl(meeting, channelNum, weworkUserNum, appId, snsAccessToken, snsUserinfo, response);
            }
        } else {
            MeetingCustomerInfoDto customerInfoDto;
            timer.start("unionId2contactId");
            this.meetingUrlCommonService.unionId2contactId(meeting.getCorpId(), unionId, openId);
            timer.stop();
            try {
                timer.start("handleCustomerInfoWhenAuthorized");
                customerInfoDto = this.meetingUrlCommonService.handleCustomerInfoWhenAuthorized(channelNum, weworkUserNum, meeting, appId, openId, unionId, headImgUrl, nickName, sex, MeetingLiveDeliveryAuthMode.OFFICIAL_ACCOUNT);
            }
            catch (Exception e) {
                log.error("authRedirect,handleCustomerInfoWhenAuthorized error", (Throwable)e);
                this.redirectOriginMeetingUrl(meeting, channelNum, weworkUserNum, appId, snsAccessToken, snsUserinfo, response);
                return;
            }
            finally {
                timer.stop();
            }
            timer.start("redirectWhenAuthorized");
            this.redirectWhenAuthorized(response, meeting, meetingSetting, headImgUrl, nickName, customerInfoDto);
            timer.stop();
        }
        timer.print();
    }

    private void redirectOriginMeetingUrl(Meeting meeting, String channelNum, String weworkUserNum, String appId, SnsAccessToken snsAccessToken, SnsUserinfo snsUserinfo, HttpServletResponse response) {
        log.info("redirectOriginMeetingUrl,meetingId:{},channelNum:{},weworkUserNum:{}", new Object[]{meeting.getId(), channelNum, weworkUserNum});
        try {
            String openId = snsAccessToken != null && StringUtils.isNotBlank((CharSequence)snsAccessToken.getOpenId()) ? snsAccessToken.getOpenId() : "";
            String unionId = snsUserinfo != null && StringUtils.isNotBlank((CharSequence)snsUserinfo.getUnionId()) ? snsUserinfo.getUnionId() : "";
            response.sendRedirect(this.meetingUrlCommonService.buildOriginMeetingUrlAndGenCustomerStr(meeting, channelNum, weworkUserNum, appId, openId, unionId, null, false, true));
        }
        catch (Exception e) {
            log.error("redirectOriginMeetingUrl,sendRedirect error", (Throwable)e);
        }
    }

    private void redirectWhenAuthorized(HttpServletResponse response, Meeting meeting, MeetingSetting meetingSetting, String headImgUrl, String nickName, MeetingCustomerInfoDto customerInfoDto) {
        StopWatchDto timer = new StopWatchDto("redirectWhenAuthorized", true, log);
        try {
            if (MeetingStatus.FINISHED.getValue() == meeting.getStatus().intValue() && StringUtils.isNotBlank((CharSequence)meeting.getPlaybackUrl())) {
                log.info("redirectWhenAuthorized,meetingId:{},\u4f1a\u8bae\u5df2\u7ed3\u675f\u4e14\u751f\u6210\u4e86\u56de\u653e\u5730\u5740", (Object)meeting.getId());
                timer.start("playbackRedirectWhenAuthorized");
                this.playbackRedirectWhenAuthorized(response, meeting, headImgUrl, customerInfoDto.getUserNumber(), customerInfoDto.getCustomerStr());
                timer.stop();
            } else {
                Integer meetingIsPrivate = meeting.getIsPrivate();
                timer.start("buildMeetingIntoUrl");
                String meetingIntoUrl = this.meetingUrlCommonService.buildMeetingIntoUrl(customerInfoDto.getCustomerStr(), Long.parseLong(meeting.getRoomId()), headImgUrl, nickName, meetingSetting, customerInfoDto.getUserNumber(), meeting.getNum(), meetingIsPrivate);
                timer.stop();
                response.sendRedirect(meetingIntoUrl);
                timer.print();
            }
        }
        catch (Exception e) {
            log.error("meeting authRedirect sendRedirect error", (Throwable)e);
            timer.stop();
            timer.print();
        }
    }

    @Override
    public void playbackUrlRedirect(String code, String meetingNum, HttpServletRequest request, HttpServletResponse response) {
        String openId;
        String authScope;
        SnsAccessToken snsAccessToken;
        log.info("playbackUrlRedirect code:{} meetingNum:{}", (Object)code, (Object)meetingNum);
        if (StringUtils.isBlank((CharSequence)meetingNum)) {
            log.info("playbackUrlRedirect meetingNum is empty");
            return;
        }
        Meeting meeting = this.meetingCacheService.getMeetingByNum(meetingNum);
        if (meeting == null) {
            log.info("playbackUrlRedirect meeting is null");
            return;
        }
        if (StringUtils.isBlank((CharSequence)code)) {
            log.info("playbackUrlRedirect code is empty");
            this.redirectOriginMeetingPlaybackUrl(meeting, response);
            return;
        }
        Long bizId = meeting.getBizId();
        String appId = this.meetingCacheService.getOfficialAppId(bizId);
        if (StringUtils.isBlank((CharSequence)appId)) {
            log.info("playbackUrlRedirect officialAccount is null bizId:{}", (Object)bizId);
            this.redirectOriginMeetingPlaybackUrl(meeting, response);
            return;
        }
        String componentAppId = this.componentTokenService.getWechatAppId();
        String componentAccessToken = this.componentTokenService.getComponentAccessToken();
        String unionId = null;
        SnsUserinfo snsUserinfo = null;
        try {
            snsAccessToken = this.wxOAuth2API.getComponentAccessToken(appId, code, componentAppId, componentAccessToken);
            authScope = snsAccessToken.getScope();
            openId = snsAccessToken.getOpenId();
        }
        catch (Exception e) {
            log.error("playbackUrlRedirect,getComponentAccessToken error", (Throwable)e);
            this.redirectOriginMeetingPlaybackUrl(meeting, response);
            return;
        }
        String headImgUrl = "";
        String nickName = "";
        try {
            String accessToken = snsAccessToken.getAccessToken();
            snsUserinfo = this.wxOAuth2API.getUserinfo(accessToken, openId, "zh_CN");
            unionId = snsUserinfo.getUnionId();
            headImgUrl = snsUserinfo.getHeadImgUrl();
            nickName = snsUserinfo.getNickname();
        }
        catch (Exception e) {
            log.error("playbackUrlRedirect,getUserinfo error", (Throwable)e);
        }
        log.info("playbackUrlRedirect snsUserinfo:{},snsAccessToken:{}", (Object)snsUserinfo, (Object)snsAccessToken);
        if (WxOAuthScope.SNSAPI_BASE.getValue().equals(authScope) && StringUtils.isBlank((CharSequence)unionId)) {
            try {
                String wechatAuthMeetingCommercePlaybackH5LoginUrl = this.getWechatAuthMeetingCommercePlaybackH5LoginUrl(meeting, appId);
                response.sendRedirect(wechatAuthMeetingCommercePlaybackH5LoginUrl);
            }
            catch (Exception e) {
                log.error("playbackUrlRedirect,getWechatAuthMeetingCommercePlaybackH5LoginUrl error", (Throwable)e);
                this.redirectOriginMeetingPlaybackUrl(meeting, response);
            }
        } else {
            MeetingCustomerInfoDto customerInfoDto;
            this.meetingUrlCommonService.unionId2contactId(meeting.getCorpId(), unionId, openId);
            try {
                customerInfoDto = this.meetingUrlCommonService.handlePlaybackCustomerInfoWhenAuthorized(meeting, appId, openId, unionId, headImgUrl, nickName, MeetingLiveDeliveryAuthMode.OFFICIAL_ACCOUNT);
            }
            catch (Exception e) {
                log.error("playbackUrlRedirect,handlePlaybackCustomerInfoWhenAuthorized error", (Throwable)e);
                this.redirectOriginMeetingPlaybackUrl(meeting, response);
                return;
            }
            this.playbackRedirectWhenAuthorized(response, meeting, headImgUrl, customerInfoDto.getUserNumber(), customerInfoDto.getCustomerStr());
        }
    }

    private void redirectOriginMeetingPlaybackUrl(Meeting meeting, HttpServletResponse response) {
        try {
            String playbackUrl = this.meetingUrlCommonService.buildOriginMeetingUrlAndGenCustomerStr(meeting, null, null, null, null, null, null, true, true);
            response.sendRedirect(playbackUrl);
        }
        catch (Exception e) {
            log.error("meeting authRedirect redirectOriginMeetingPlaybackUrl error", (Throwable)e);
        }
    }

    private void playbackRedirectWhenAuthorized(HttpServletResponse response, Meeting meeting, String headImgUrl, Long userNumber, String customerStr) {
        try {
            String playbackUrl = meeting.getPlaybackUrl() + "&customstr=" + customerStr + "&pay_channel=1&user_number=" + userNumber + "&user_name=" + URLEncoder.encode(headImgUrl, "utf-8") + "&meeting_id=" + meeting.getNum();
            response.sendRedirect(playbackUrl);
        }
        catch (Exception e) {
            log.error("meeting authRedirect sendRedirect error", (Throwable)e);
        }
    }

    @Override
    public String getWechatAuthMeetingCommercePlaybackUrl(Meeting meeting, boolean returnShortUrl) {
        String redirectUrl;
        Long bizId = meeting.getBizId();
        String meetingNum = meeting.getNum();
        log.info("getWechatAuthMeetingCommercePlaybackUrl bizId:{} meetingNum:{} returnShortUrl:{}", new Object[]{bizId, meetingNum, returnShortUrl});
        String appId = this.meetingCacheService.getOfficialAppId(bizId);
        if (StringUtils.isBlank((CharSequence)appId)) {
            return this.meetingUrlCommonService.buildOriginMeetingUrlAndGenCustomerStr(meeting, null, null, null, null, null, null, true, true);
        }
        String componentAppId = this.componentTokenService.getWechatAppId();
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(this.playbackAuthCallbackUrl).append("?meetingNum=").append(meetingNum);
        try {
            redirectUrl = URLEncoder.encode(stringBuilder.toString(), "utf-8");
        }
        catch (Exception e) {
            log.error("getWechatAuthMeetingCommercePlaybackUrl encode url error", (Throwable)e);
            return this.meetingUrlCommonService.buildOriginMeetingUrlAndGenCustomerStr(meeting, null, null, null, null, null, null, true, true);
        }
        String longUrl = LIVE_DELIVERY_USER_BASE_URL.replace("${appId}", appId).replace("${redirect_uri}", redirectUrl).replace("${component_appid}", componentAppId);
        if (!returnShortUrl) {
            return longUrl;
        }
        return this.getShortUrl(longUrl, appId);
    }

    public String getWechatAuthMeetingCommercePlaybackH5LoginUrl(Meeting meeting, String appId) {
        String authMiddlePageUrl;
        String redirectUrl;
        Long bizId = meeting.getBizId();
        String meetingNum = meeting.getNum();
        log.info("getWechatAuthMeetingCommercePlaybackUrl bizId:{} meetingNum:{}", (Object)bizId, (Object)meetingNum);
        Preconditions.checkArgument((bizId != null ? 1 : 0) != 0, (Object)"bizId\u4e0d\u80fd\u4e3a\u7a7a");
        Preconditions.checkArgument((boolean)StringUtils.isNotBlank((CharSequence)meetingNum), (Object)"meetingNum\u4e0d\u80fd\u4e3a\u7a7a");
        String componentAppId = this.componentTokenService.getWechatAppId();
        StringBuilder stringBuilder = new StringBuilder(128);
        stringBuilder.append(this.playbackAuthCallbackUrl).append("?meetingNum=").append(meetingNum);
        try {
            redirectUrl = URLEncoder.encode(stringBuilder.toString(), "utf-8");
        }
        catch (Exception e) {
            log.error("getWechatAuthMeetingCommercePlaybackUrl encode url error", (Throwable)e);
            return this.meetingUrlCommonService.buildOriginMeetingUrlAndGenCustomerStr(meeting, null, null, null, null, null, null, true, true);
        }
        String longUrl = LIVE_DELIVERY_USER_INFO_URL.replace("${appId}", appId).replace("${redirect_uri}", redirectUrl).replace("${component_appid}", componentAppId);
        try {
            authMiddlePageUrl = this.authMiddlePage + URLEncoder.encode(longUrl, "utf-8");
        }
        catch (Exception e) {
            log.error("getWechatAuthMeetingCommerceUrl encode url error", (Throwable)e);
            return this.meetingUrlCommonService.buildOriginMeetingUrlAndGenCustomerStr(meeting, null, null, null, null, null, null, true, true);
        }
        log.info("getWechatAuthMeetingCommercePlaybackUrl bizId:{} meetingNum:{} authMiddlePageUrl:{}", new Object[]{bizId, meetingNum, authMiddlePageUrl});
        return authMiddlePageUrl;
    }

    @Override
    public GoodsDetailOfficialAuthUrlDto buildGoodsDetailOfficialAuthUrl(Meeting meeting, String redirectUrl, String userNumber, String customerStr) {
        String wxRedirectUrl;
        OfficialAccount officialAccount;
        MeetingParams meetingParamsByNum;
        log.info("buildGoodsDetailOfficialAuthUrl,meeting:{},redirectUrl:{},userNumber:{},customerStr:{}", new Object[]{meeting.getId(), redirectUrl, userNumber, customerStr});
        GoodsDetailOfficialAuthUrlDto dto = new GoodsDetailOfficialAuthUrlDto();
        Long bizId = meeting.getBizId();
        if (StringUtils.isNotBlank((CharSequence)customerStr) && (meetingParamsByNum = this.paramEncryService.getMeetingParamsByNum(customerStr)) != null && StringUtils.isNotBlank((CharSequence)meetingParamsByNum.getOpenId())) {
            log.info("buildGoodsDetailOfficialAuthUrl,meetingId:{},customerStr\u5df2\u7ecf\u6388\u6743\u8fc7openId", (Object)meeting.getId());
            redirectUrl = redirectUrl + "&authorized=1&customerStr=" + customerStr;
            dto.setAuthUrl(redirectUrl);
            dto.setAuthorized(1);
            dto.setCustomerStr(customerStr);
            return dto;
        }
        if (StringUtils.isNotBlank((CharSequence)userNumber)) {
            MeetingCustomerInfo select = new MeetingCustomerInfo();
            select.setBizId(meeting.getBizId());
            select.setMeetingId(meeting.getId());
            select.setBjyNumber(userNumber);
            List meetingCustomerInfos = this.meetingCustomerInfoMapper.select((Object)select);
            if (meetingCustomerInfos.size() > 1) {
                log.error("buildGoodsDetailOfficialAuthUrl,\u901a\u8fc7bizId\u3001meetingId\u3001bjyNumber\u67e5\u5230\u591a\u6761\u8bb0\u5f55,bizId:{},meetingId:{},userNumber:{}", new Object[]{meeting.getBizId(), meeting.getId(), userNumber});
            }
            if (CollectionUtils.isNotEmpty((Collection)meetingCustomerInfos) && StringUtils.isNotBlank((CharSequence)((MeetingCustomerInfo)meetingCustomerInfos.get(0)).getOpenId()) && StringUtils.isNotBlank((CharSequence)((MeetingCustomerInfo)meetingCustomerInfos.get(0)).getCustomerStr())) {
                log.info("buildGoodsDetailOfficialAuthUrl,meetingId:{},userNumber\u5df2\u7ecf\u6388\u6743\u8fc7openId", (Object)meeting.getId());
                String string = customerStr = StringUtils.isBlank((CharSequence)customerStr) ? ((MeetingCustomerInfo)meetingCustomerInfos.get(0)).getCustomerStr() : customerStr;
                if (StringUtils.isNotBlank((CharSequence)customerStr) && !customerStr.equals(((MeetingCustomerInfo)meetingCustomerInfos.get(0)).getCustomerStr())) {
                    String finalCustomerStr = customerStr;
                    String traceId = TraceIdUtils.getTraceId();
                    this.threadPool.submit(() -> {
                        TraceIdUtils.setTraceId((String)traceId);
                        this.updateNewCustomerStrInfo(finalCustomerStr, (MeetingCustomerInfo)meetingCustomerInfos.get(0));
                    });
                }
                redirectUrl = redirectUrl + "&authorized=1&customerStr=" + customerStr;
                dto.setAuthUrl(redirectUrl);
                dto.setAuthorized(1);
                dto.setCustomerStr(customerStr);
                return dto;
            }
        }
        Preconditions.checkArgument(((officialAccount = this.officialAccountMapper.queryLatestByBizId(bizId)) != null ? 1 : 0) != 0, (Object)"\u5546\u6237\u672a\u6388\u6743\u516c\u4f17\u53f7");
        String componentAppId = this.componentTokenService.getWechatAppId();
        try {
            redirectUrl = URLEncoder.encode(redirectUrl, "utf-8");
        }
        catch (Exception e) {
            log.error("buildGoodsDetailOfficialAuthUrl encode url error", (Throwable)e);
            throw new BusinessException((UniverseErrorCode)CommonErrorCode.BUSINESS_ERROR, "\u6784\u9020\u56de\u8c03\u94fe\u63a5\u5f02\u5e38");
        }
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(this.deliveryGoodsDetailCallbackUrl).append("?meetingNum=").append(meeting.getNum()).append("&redirectUrl=").append(redirectUrl).append("&appId=").append(officialAccount.getAppId());
        if (StringUtils.isNotBlank((CharSequence)userNumber)) {
            stringBuilder.append("&userNumber=").append(userNumber);
        }
        if (StringUtils.isNotBlank((CharSequence)customerStr)) {
            stringBuilder.append("&customerStr=").append(customerStr);
        }
        try {
            wxRedirectUrl = URLEncoder.encode(stringBuilder.toString(), "utf-8");
        }
        catch (Exception e) {
            log.error("buildGoodsDetailOfficialAuthUrl encode url error", (Throwable)e);
            throw new BusinessException((UniverseErrorCode)CommonErrorCode.BUSINESS_ERROR, "\u6784\u9020\u56de\u8c03\u94fe\u63a5\u5f02\u5e38");
        }
        String longUrl = LIVE_DELIVERY_USER_BASE_URL.replace("${appId}", officialAccount.getAppId()).replace("${redirect_uri}", wxRedirectUrl).replace("${component_appid}", componentAppId);
        log.info("buildGoodsDetailOfficialAuthUrl,longUrl:{}", (Object)longUrl);
        dto.setAuthUrl(longUrl);
        dto.setAuthorized(0);
        return dto;
    }

    private void updateNewCustomerStrInfo(String newCustomerStr, MeetingCustomerInfo infoByUserNumber) {
        log.info("updateNewCustomerStrInfo,newCustomerStr:{},infoByUserNumber:{}", (Object)newCustomerStr, (Object)infoByUserNumber);
        MeetingParams newMeetingParams = this.paramEncryService.getMeetingParamsByNum(newCustomerStr);
        if (newMeetingParams == null) {
            return;
        }
        MeetingParams oldMeetingParams = this.paramEncryService.getMeetingParamsByNum(infoByUserNumber.getCustomerStr());
        log.info("updateNewCustomerStrInfo,newMeetingParams:{},oldMeetingParams:{}", (Object)newMeetingParams, (Object)oldMeetingParams);
        if (StringUtils.isBlank((CharSequence)newMeetingParams.getAppId())) {
            newMeetingParams.setAppId(infoByUserNumber.getAppId());
        }
        if (StringUtils.isBlank((CharSequence)newMeetingParams.getOpenId())) {
            newMeetingParams.setOpenId(infoByUserNumber.getOpenId());
        }
        if (StringUtils.isBlank((CharSequence)newMeetingParams.getUnionId())) {
            newMeetingParams.setUnionId(infoByUserNumber.getUnionId());
        }
        if (oldMeetingParams != null) {
            if (StringUtils.isBlank((CharSequence)newMeetingParams.getWeworkUserNum()) || "-1".equals(newMeetingParams.getWeworkUserNum())) {
                newMeetingParams.setWeworkUserNum(StringUtils.isNotBlank((CharSequence)oldMeetingParams.getWeworkUserNum()) ? oldMeetingParams.getWeworkUserNum() : "-1");
            }
            newMeetingParams.setChannelId(oldMeetingParams.getChannelId());
        }
        log.info("updateNewCustomerStrInfo,update newCustomerStr:{}", (Object)newMeetingParams);
        this.paramEncryMapper.updateParamsByNum(newCustomerStr, JSONObject.toJSONString((Object)newMeetingParams));
    }

    @Override
    public void goodsDetailAuthRedirect(String code, String appId, String meetingNum, String redirectUrl, String userNumber, String customerStr, HttpServletResponse response) {
        MeetingCustomerInfo select;
        log.info("goodsDetailAuthRedirect,code:{},meetingNum:{},userNumber:{},redirectUrl:{},customerStr:{}", new Object[]{code, meetingNum, userNumber, redirectUrl, customerStr});
        if (StringUtils.isBlank((CharSequence)code)) {
            log.info("goodsDetailAuthRedirect code is empty");
            return;
        }
        if (StringUtils.isBlank((CharSequence)redirectUrl)) {
            log.info("goodsDetailAuthRedirect redirectUrl is empty code:{}", (Object)code);
            return;
        }
        if (StringUtils.isBlank((CharSequence)meetingNum)) {
            log.info("goodsDetailAuthRedirect meetingNum is empty code:{}", (Object)code);
            return;
        }
        Meeting meeting = this.meetingCacheService.getMeetingByNum(meetingNum);
        if (meeting == null) {
            log.info("goodsDetailAuthRedirect meeting is null code:{}", (Object)code);
            return;
        }
        String componentAppId = this.componentTokenService.getWechatAppId();
        String componentAccessToken = this.componentTokenService.getComponentAccessToken();
        SnsAccessToken snsAccessToken = null;
        try {
            snsAccessToken = this.wxOAuth2API.getComponentAccessToken(appId, code, componentAppId, componentAccessToken);
        }
        catch (Exception e) {
            log.error("goodsDetailAuthRedirect,getComponentAccessToken error,code:{}", (Object)code, (Object)e);
        }
        if (snsAccessToken == null) {
            try {
                response.sendRedirect(redirectUrl);
                return;
            }
            catch (Exception e) {
                log.error("goodsDetailAuthRedirect sendRedirect error", (Throwable)e);
                return;
            }
        }
        MeetingCustomerInfo meetingCustomerInfo = null;
        if (StringUtils.isBlank((CharSequence)customerStr)) {
            if (StringUtils.isNotBlank((CharSequence)userNumber)) {
                select = new MeetingCustomerInfo();
                select.setBizId(meeting.getBizId());
                select.setMeetingId(meeting.getId());
                select.setBjyNumber(userNumber);
                List meetingCustomerInfos = this.meetingCustomerInfoMapper.select((Object)select);
                if (meetingCustomerInfos.size() > 1) {
                    log.error("goodsDetailAuthRedirect,\u901a\u8fc7bizId\u3001meetingId\u3001bjyNumber\u67e5\u5230\u591a\u6761\u8bb0\u5f55,bizId:{},meetingId:{},userNumber:{}", new Object[]{meeting.getBizId(), meeting.getId(), userNumber});
                }
                if (CollectionUtils.isNotEmpty((Collection)meetingCustomerInfos) && StringUtils.isNotBlank((CharSequence)(meetingCustomerInfo = (MeetingCustomerInfo)meetingCustomerInfos.get(0)).getCustomerStr())) {
                    log.info("goodsDetailAuthRedirect,meetingCustomerInfoId:{}", (Object)meetingCustomerInfo.getId());
                    customerStr = meetingCustomerInfo.getCustomerStr();
                }
            }
        } else {
            select = new MeetingCustomerInfo();
            select.setBizId(meeting.getBizId());
            select.setMeetingId(meeting.getId());
            select.setCustomerStr(customerStr);
            List meetingCustomerInfos = this.meetingCustomerInfoMapper.select((Object)select);
            if (meetingCustomerInfos.size() > 1) {
                log.error("goodsDetailAuthRedirect,\u901a\u8fc7bizId\u3001meetingId\u3001customerStr\u67e5\u5230\u591a\u6761\u8bb0\u5f55,bizId:{},meetingId:{},customerStr:{}", new Object[]{meeting.getBizId(), meeting.getId(), customerStr});
            }
            if (CollectionUtils.isNotEmpty((Collection)meetingCustomerInfos)) {
                meetingCustomerInfo = (MeetingCustomerInfo)meetingCustomerInfos.get(0);
            }
        }
        if (StringUtils.isBlank((CharSequence)customerStr)) {
            log.info("goodsDetailAuthRedirect, \u751f\u6210\u65b0\u7684customerStr");
            customerStr = this.idGen.getNum();
            this.meetingUrlCommonService.insertParamEncry(meeting.getId(), appId, snsAccessToken.getOpenId(), snsAccessToken.getUnionId(), customerStr, null, null, null);
            this.meetingUrlCommonService.insertParamEncryRelation(appId, snsAccessToken.getOpenId(), meeting.getBizId(), meeting.getId(), snsAccessToken.getUnionId(), customerStr, null, false);
        }
        this.insertOrUpdateMeetingCustomerInfo(meeting, appId, snsAccessToken.getOpenId(), snsAccessToken.getUnionId(), customerStr, userNumber, meetingCustomerInfo);
        try {
            redirectUrl = redirectUrl + "&customerStr=" + customerStr + "&authorized=1";
            log.info("goodsDetailAuthRedirect,redirectUrl{}", (Object)redirectUrl);
            response.sendRedirect(redirectUrl);
        }
        catch (Exception e) {
            log.error("goodsDetailAuthRedirect sendRedirect error,redirectUrl:{}", (Object)redirectUrl, (Object)e);
        }
    }

    private void insertOrUpdateMeetingCustomerInfo(Meeting meeting, String appId, String openId, String unionId, String customerStr, String userNumber, MeetingCustomerInfo customerInfo) {
        if (customerInfo == null) {
            customerInfo = new MeetingCustomerInfo();
            customerInfo.setNum(this.idGen.getNum());
            customerInfo.setBizId(meeting.getBizId());
            customerInfo.setRoomId(meeting.getRoomId());
            customerInfo.setMeetingId(meeting.getId());
            customerInfo.setAppId(appId);
            customerInfo.setOpenId(openId);
            customerInfo.setUnionId(unionId);
            customerInfo.setContactId("");
            customerInfo.setCustomerStr(customerStr);
            customerInfo.setName("-");
            customerInfo.setBjyNumber(userNumber);
            customerInfo.setInfoId(userNumber);
            Date curTime = new Date();
            customerInfo.setArrivalTime(curTime);
            customerInfo.setCreateTime(curTime);
            customerInfo.setUpdateTime(curTime);
            this.meetingCustomerInfoMapper.insertSelective((Object)customerInfo);
            log.info("insertOrUpdateMeetingCustomerInfo  insertSelective customerInfo:{}", (Object)customerInfo);
        } else {
            boolean needUpdate = false;
            if (StringUtils.isBlank((CharSequence)customerInfo.getCustomerStr())) {
                customerInfo.setCustomerStr(customerStr);
                needUpdate = true;
            }
            if (StringUtils.isBlank((CharSequence)customerInfo.getAppId())) {
                customerInfo.setAppId(appId);
                needUpdate = true;
            }
            if (StringUtils.isBlank((CharSequence)customerInfo.getOpenId())) {
                customerInfo.setOpenId(openId);
                needUpdate = true;
            }
            if (needUpdate) {
                this.meetingCustomerInfoMapper.updateByPrimaryKeySelective((Object)customerInfo);
                log.info("insertOrUpdateMeetingCustomerInfo  updateByPrimaryKeySelective customerInfo:{}", (Object)customerInfo);
            }
        }
        MeetingParams meetingParamsByNum = this.paramEncryService.getMeetingParamsByNum(customerStr);
        if (meetingParamsByNum != null) {
            if (StringUtils.isBlank((CharSequence)meetingParamsByNum.getOpenId())) {
                meetingParamsByNum.setOpenId(openId);
            }
            if (StringUtils.isBlank((CharSequence)meetingParamsByNum.getUnionId())) {
                meetingParamsByNum.setUnionId(unionId);
            }
            if (StringUtils.isBlank((CharSequence)meetingParamsByNum.getAppId())) {
                meetingParamsByNum.setAppId(appId);
            }
            if (StringUtils.isBlank((CharSequence)meetingParamsByNum.getWeworkUserNum())) {
                meetingParamsByNum.setWeworkUserNum("-1");
            }
            log.info("insertOrUpdateMeetingCustomerInfo update meetingParam:{}", (Object)meetingParamsByNum);
            this.paramEncryMapper.updateParamsByNum(customerStr, JSONObject.toJSONString((Object)meetingParamsByNum));
        }
    }
}

