/*
 * Decompiled with CFR 0.152.
 */
package com.kuaike.scrm.service.impl;

import cn.kinyun.customer.center.dto.req.CustomerNumReq;
import cn.kinyun.customer.center.dto.resp.CustomerNumResp;
import cn.kinyun.customer.center.service.CcCustomerNumService;
import com.google.common.collect.Lists;
import com.kuaike.scrm.common.enums.YnEnum;
import com.kuaike.scrm.dal.biz.entity.BusinessCustomer;
import com.kuaike.scrm.dal.biz.entity.BusinessCustomerCriteria;
import com.kuaike.scrm.dal.biz.mapper.BusinessCustomerMapper;
import com.kuaike.scrm.dal.meeting.entity.MeetingCustomerInfo;
import com.kuaike.scrm.dal.meeting.mapper.MeetingCustomerInfoMapper;
import com.kuaike.scrm.service.MeetingCustomerInfoService;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class MeetingCustomerInfoServiceImpl
implements MeetingCustomerInfoService {
    private static final Logger log = LoggerFactory.getLogger(MeetingCustomerInfoServiceImpl.class);
    @Resource
    private BusinessCustomerMapper businessCustomerMapper;
    @Resource
    MeetingCustomerInfoMapper meetingCustomerInfoMapper;
    @Resource
    private CcCustomerNumService ccCustomerNumService;

    @Override
    public void syncMeetingCustomerInfo(Long bizId) {
        List list;
        BusinessCustomerCriteria criteria = new BusinessCustomerCriteria();
        BusinessCustomerCriteria.Criteria query = criteria.createCriteria();
        query.andIsDeletedEqualTo(Byte.valueOf((byte)0)).andStatusEqualTo(Byte.valueOf(YnEnum.YES.getValue().byteValue()));
        if (Objects.nonNull(bizId)) {
            query.andIdEqualTo(bizId);
        }
        if (CollectionUtils.isEmpty((Collection)(list = this.businessCustomerMapper.selectByExample((Object)criteria)))) {
            return;
        }
        for (BusinessCustomer businessCustomer : list) {
            List meetingCustomerInfos = this.meetingCustomerInfoMapper.queryAllUnbindWithWework(businessCustomer.getId(), null, null);
            log.info("\u5f53\u524d\u5546\u6237\uff1a{}\u9700\u8981\u540c\u6b65\u7684\u6570\u636e\u6709:{}", (Object)businessCustomer.getId(), (Object)CollectionUtils.size((Object)meetingCustomerInfos));
            if (CollectionUtils.isEmpty((Collection)meetingCustomerInfos)) continue;
            List reqList = meetingCustomerInfos.stream().map(item -> {
                CustomerNumReq req = new CustomerNumReq();
                req.setAppId(item.getAppId());
                req.setOpenId(item.getOpenId());
                req.setUnionId(item.getUnionId());
                return req;
            }).collect(Collectors.toList());
            List customerNumResps = null;
            try {
                customerNumResps = this.ccCustomerNumService.onlyQueryByOpenId(businessCustomer.getId(), reqList);
            }
            catch (Exception e) {
                log.error("\u8c03\u7528:ccCustomerNumService.onlyQueryByOpenId \u5f02\u5e38", (Throwable)e);
            }
            if (CollectionUtils.isEmpty((Collection)customerNumResps)) continue;
            Map<String, List<CustomerNumResp>> groupByOpenId = customerNumResps.stream().collect(Collectors.groupingBy(item -> item.getAppId() + "_" + item.getOpenId()));
            for (MeetingCustomerInfo mcm : meetingCustomerInfos) {
                String key = mcm.getAppId() + "_" + mcm.getOpenId();
                List<CustomerNumResp> customerInfo = groupByOpenId.get(key);
                if (CollectionUtils.isEmpty(customerInfo)) continue;
                String contactId = customerInfo.get(0).getContactId();
                log.info("appId_openId:{} contactId:{}", (Object)key, (Object)contactId);
                if (StringUtils.isEmpty((CharSequence)contactId)) continue;
                mcm.setContactId(contactId);
                mcm.setUpdateTime(new Date());
                this.meetingCustomerInfoMapper.updateByPrimaryKeySelective((Object)mcm);
            }
        }
    }

    @Override
    public void syncMeetingCustomerInfoByContactId(Long bizId, String contactId) {
        if (StringUtils.isBlank((CharSequence)contactId) || Objects.isNull(bizId)) {
            return;
        }
        CustomerNumReq req = new CustomerNumReq();
        req.setContactId(contactId);
        List customerNumResps = null;
        try {
            customerNumResps = this.ccCustomerNumService.onlyQueryByContactId(bizId, (List)Lists.newArrayList((Object[])new CustomerNumReq[]{req}));
        }
        catch (Exception e) {
            log.error("\u8c03\u7528\u63a5\u53e3 ccCustomerNumService.onlyQueryByContactId \u5f02\u5e38\uff1a", (Throwable)e);
        }
        if (CollectionUtils.isEmpty(customerNumResps)) {
            return;
        }
        for (CustomerNumResp rNumResp : customerNumResps) {
            List customerInfo;
            if (StringUtils.isBlank((CharSequence)rNumResp.getAppId()) || StringUtils.isBlank((CharSequence)rNumResp.getOpenId()) || CollectionUtils.isEmpty((Collection)(customerInfo = this.meetingCustomerInfoMapper.queryAllUnbindWithWework(bizId, rNumResp.getOpenId(), rNumResp.getAppId())))) continue;
            for (MeetingCustomerInfo customerInfo2 : customerInfo) {
                customerInfo2.setContactId(contactId);
                customerInfo2.setUpdateTime(new Date());
                this.meetingCustomerInfoMapper.updateByPrimaryKeySelective((Object)customerInfo2);
            }
        }
    }
}

