/*
 * Decompiled with CFR 0.152.
 */
package com.kuaike.scrm.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.google.common.collect.Lists;
import com.kuaike.scrm.common.dto.StopWatchDto;
import com.kuaike.scrm.common.service.dto.MeetingParams;
import com.kuaike.scrm.common.utils.DateUtil;
import com.kuaike.scrm.common.utils.NamedThreadFactory;
import com.kuaike.scrm.common.utils.ThreadPoolMonitorUtils;
import com.kuaike.scrm.dal.channel.entity.Channel;
import com.kuaike.scrm.dal.channel.mapper.ChannelMapper;
import com.kuaike.scrm.dal.meeting.entity.Meeting;
import com.kuaike.scrm.dal.meeting.entity.MeetingCustomerParamEncryRelation;
import com.kuaike.scrm.dal.meeting.entity.MeetingSetting;
import com.kuaike.scrm.dal.meeting.entity.ParamEncry;
import com.kuaike.scrm.dal.meeting.mapper.MeetingMapper;
import com.kuaike.scrm.dal.meeting.mapper.MeetingSettingMapper;
import com.kuaike.scrm.dal.official.base.entity.OfficialAccount;
import com.kuaike.scrm.dal.official.base.mapper.OfficialAccountMapper;
import com.kuaike.scrm.dal.wework.entity.WeworkUser;
import com.kuaike.scrm.dal.wework.mapper.WeworkUserMapper;
import com.kuaike.scrm.service.MeetingCacheService;
import com.kuaike.trace.utils.TraceIdUtils;
import java.text.MessageFormat;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.TimeZone;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.LinkedBlockingDeque;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import javax.annotation.PostConstruct;
import javax.annotation.Resource;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.math.NumberUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.data.redis.core.StringRedisTemplate;
import org.springframework.stereotype.Service;

@Service
public class MeetingCacheServiceImpl
implements MeetingCacheService {
    private static final Logger log = LoggerFactory.getLogger((String)"meetingCacheLog");
    @Resource
    private StringRedisTemplate stringRedisTemplate;
    @Resource
    private MeetingMapper meetingMapper;
    @Resource
    private WeworkUserMapper weworkUserMapper;
    @Resource
    private MeetingSettingMapper meetingSettingMapper;
    @Resource
    private OfficialAccountMapper officialAccountMapper;
    @Resource
    private ChannelMapper channelMapper;
    private static final String CACHE_MEETING_KEY = "meetingCache:meeting:{0}";
    private static final String CACHE_OFFICIAL_KEY = "meetingCache:official:{0}";
    private static final String CACHE_MEETING_SETTING_KEY = "meetingCache:meetingSetting:{0}";
    private static final String CACHE_INVITE_KEY = "meetingCache:meetingInvite:{0}:{1}";
    private static final String CACHE_CHANNEL_KEY = "meetingCache:meetingChannel:{0}:{1}";
    private static final String CACHE_ENCRY_RELATION_KEY = "meetingCache:encryRelation:{0}:{1}:{2}:{3}:{4}:{5}";
    private static final String CACHE_CHANNEL_MEETING_PARAMS_KEY = "meetingCache:channelMeetingParams:{0}:{1}:{2}";
    private static final String CACHE_INVITE_MEETING_PARAMS_KEY = "meetingCache:inviteMeetingParams:{0}:{1}:{2}";
    private final int size = Runtime.getRuntime().availableProcessors();
    private final ExecutorService threadPool = new ThreadPoolExecutor(this.size, this.size * 2, 10L, TimeUnit.SECONDS, new LinkedBlockingDeque<Runnable>(1024), (ThreadFactory)new NamedThreadFactory("meetingCacheService"), new ThreadPoolExecutor.CallerRunsPolicy());

    @PostConstruct
    public void init() {
        ThreadPoolMonitorUtils.addToMonitor((ExecutorService)this.threadPool);
    }

    private long calMeetingCacheTimeoutHours(Date meetingEndTime) {
        Calendar now = Calendar.getInstance(TimeZone.getDefault());
        now.setTime(meetingEndTime);
        now.add(11, 3);
        long timeout = (now.getTime().getTime() - new Date().getTime()) / 1000L / 3600L;
        if (timeout <= 0L) {
            timeout = 3L;
        }
        return timeout;
    }

    @Override
    public void setMeetingCache(Meeting meeting) {
        StopWatchDto timer = new StopWatchDto("setMeetingCache", true, log);
        timer.start("setCache");
        String key = MessageFormat.format(CACHE_MEETING_KEY, meeting.getNum());
        long timeoutHours = this.calMeetingCacheTimeoutHours(meeting.getEndTime());
        log.info("setMeetingCache,key:{},timeoutHours:{},meeting:{}", new Object[]{key, timeoutHours, meeting});
        this.stringRedisTemplate.opsForValue().set((Object)key, (Object)JSONObject.toJSONString((Object)meeting), timeoutHours, TimeUnit.HOURS);
        timer.stop();
        timer.print();
    }

    @Override
    public Meeting getMeetingByNum(String meetingNum) {
        log.info("getMeetingByNum,meetingNum:{}", (Object)meetingNum);
        StopWatchDto timer = new StopWatchDto("getMeetingByNum", true, log);
        timer.start("getFromCache");
        String key = MessageFormat.format(CACHE_MEETING_KEY, meetingNum);
        String meetingJson = (String)this.stringRedisTemplate.opsForValue().get((Object)key);
        timer.stop();
        Meeting meeting = null;
        if (StringUtils.isNotBlank((CharSequence)meetingJson)) {
            try {
                meeting = (Meeting)JSONObject.parseObject((String)meetingJson, Meeting.class);
            }
            catch (Exception e) {
                log.error("getMeetingByNum,parse meeting error", (Throwable)e);
            }
        }
        if (meeting == null) {
            log.info("getMeetingByNum,\u4ece\u7f13\u5b58\u4e2d\u672a\u67e5\u8be2\u5230meeting,meetingNum:{}", (Object)meetingNum);
            timer.start("getFromDB");
            Meeting finalMeeting = meeting = this.selectByNum(meetingNum);
            String traceId = TraceIdUtils.getTraceId();
            this.threadPool.submit(() -> {
                TraceIdUtils.setTraceId((String)traceId);
                try {
                    this.setMeetingCache(finalMeeting);
                }
                catch (Exception e) {
                    log.error("getMeetingByNum,setMeetingCache error", (Throwable)e);
                }
            });
            timer.stop();
        }
        log.info("getMeetingByNum,meetingNum:{},meeting:{}", (Object)meetingNum, (Object)meeting);
        timer.print();
        return meeting;
    }

    @Override
    public void setOfficialAppId(Long bizId, String latestAuthorizedAppId) {
        StopWatchDto timer = new StopWatchDto("setOfficialAppId", true, log);
        timer.start("setCache");
        log.info("setOfficialAppId,bizId:{},latestAuthorizedAppId:{}", (Object)bizId, (Object)latestAuthorizedAppId);
        if (latestAuthorizedAppId == null) {
            latestAuthorizedAppId = "";
        }
        String key = MessageFormat.format(CACHE_OFFICIAL_KEY, bizId);
        this.stringRedisTemplate.opsForValue().set((Object)key, (Object)latestAuthorizedAppId);
        timer.stop();
        timer.print();
    }

    @Override
    public String getOfficialAppId(Long bizId) {
        log.info("getOfficialAppId,bizId:{}", (Object)bizId);
        StopWatchDto timer = new StopWatchDto("getOfficialAppId", true, log);
        timer.start("getFromCache");
        String key = MessageFormat.format(CACHE_OFFICIAL_KEY, bizId);
        String appId = (String)this.stringRedisTemplate.opsForValue().get((Object)key);
        timer.stop();
        if (StringUtils.isBlank((CharSequence)appId)) {
            log.info("getOfficialAppId,\u4ece\u7f13\u5b58\u4e2d\u672a\u67e5\u8be2\u5230appId,bizId:{}", (Object)bizId);
        }
        timer.print();
        return appId;
    }

    @Override
    public void setMeetingSetting(Long bizId, MeetingSetting meetingSetting) {
        log.info("setMeetingSetting,bizId:{},meetingSetting:{}", (Object)bizId, (Object)meetingSetting);
        StopWatchDto timer = new StopWatchDto("setMeetingSetting", true, log);
        timer.start("setCache");
        String key = MessageFormat.format(CACHE_MEETING_SETTING_KEY, bizId);
        this.stringRedisTemplate.opsForValue().set((Object)key, (Object)JSONObject.toJSONString((Object)meetingSetting));
        timer.stop();
        timer.print();
    }

    @Override
    public MeetingSetting getMeetingSetting(Long bizId) {
        log.info("getMeetingSetting,bizId:{}", (Object)bizId);
        StopWatchDto timer = new StopWatchDto("getMeetingSetting", true, log);
        timer.start("getFromCache");
        String key = MessageFormat.format(CACHE_MEETING_SETTING_KEY, bizId);
        MeetingSetting meetingSetting = null;
        String meetingSettingJson = (String)this.stringRedisTemplate.opsForValue().get((Object)key);
        timer.stop();
        if (StringUtils.isNotBlank((CharSequence)meetingSettingJson)) {
            try {
                meetingSetting = (MeetingSetting)JSONObject.parseObject((String)meetingSettingJson, MeetingSetting.class);
            }
            catch (Exception e) {
                log.error("getMeetingSetting,parse error", (Throwable)e);
            }
        }
        if (meetingSetting == null) {
            log.info("getMeetingSetting,\u4ece\u7f13\u5b58\u4e2d\u672a\u67e5\u8be2\u5230meetingSetting,bizId:{}", (Object)bizId);
        }
        timer.print();
        return meetingSetting;
    }

    @Override
    public void setInviteUserId(Long bizId, String weworkUserNum, Date meetingEndTime, Long userId) {
        log.info("setInviteUserId,bizId:{},weworkUserNum:{},meetingEndTime:{},userId:{}", new Object[]{bizId, weworkUserNum, meetingEndTime, userId});
        StopWatchDto timer = new StopWatchDto("setInviteUserId", true, log);
        String key = MessageFormat.format(CACHE_INVITE_KEY, bizId, weworkUserNum);
        if (userId == null) {
            userId = -1L;
            timer.start("queryUserIdByWeworkNums");
            Map map = this.weworkUserMapper.queryUserIdByWeworkNums(null, (Collection)Lists.newArrayList((Object[])new String[]{weworkUserNum}));
            timer.stop();
            if (!map.isEmpty() && map.containsKey(weworkUserNum)) {
                userId = (Long)map.get(weworkUserNum);
            }
        }
        timer.start("setCache");
        long timeoutHours = this.calMeetingCacheTimeoutHours(meetingEndTime);
        this.stringRedisTemplate.opsForValue().set((Object)key, (Object)String.valueOf(userId), timeoutHours, TimeUnit.HOURS);
        timer.stop();
        timer.print();
    }

    @Override
    public Long getInviteUserId(Long bizId, String weworkUserNum) {
        log.info("getInviteUserId,bizId:{},weworkUserNum:{}", (Object)bizId, (Object)weworkUserNum);
        String key = MessageFormat.format(CACHE_INVITE_KEY, bizId, weworkUserNum);
        Long userId = null;
        StopWatchDto timer = new StopWatchDto("getInviteUserId", true, log);
        timer.start("getFromCache");
        String userIdString = (String)this.stringRedisTemplate.opsForValue().get((Object)key);
        timer.stop();
        if (StringUtils.isNotBlank((CharSequence)userIdString)) {
            try {
                userId = Long.valueOf(userIdString);
            }
            catch (Exception e) {
                log.error("getInviteUserId parse error", (Throwable)e);
            }
        }
        if (userId == null) {
            log.info("getInviteUserId,\u4ece\u7f13\u5b58\u4e2d\u672a\u67e5\u8be2\u5230userId,bizId:{},weworkUserNum:{}", (Object)bizId, (Object)weworkUserNum);
        }
        timer.print();
        return userId;
    }

    @Override
    public void setInviteChannel(Long bizId, Long channelId, String channelNum) {
        log.info("setInviteChannel,bizId:{},channelId:{},channelNum:{}", new Object[]{bizId, channelId, channelNum});
        StopWatchDto timer = new StopWatchDto("setInviteChannel", true, log);
        timer.start("setCache");
        String key = MessageFormat.format(CACHE_CHANNEL_KEY, bizId, channelNum);
        this.stringRedisTemplate.opsForValue().set((Object)key, (Object)String.valueOf(channelId));
        timer.stop();
        timer.print();
    }

    @Override
    public Long getInviteChannel(Long bizId, String channelNum) {
        log.info("getInviteChannel,bizId:{},channelNum:{}", (Object)bizId, (Object)channelNum);
        StopWatchDto timer = new StopWatchDto("getInviteChannel", true, log);
        Long channelId = null;
        String key = MessageFormat.format(CACHE_CHANNEL_KEY, bizId, channelNum);
        timer.start("getFromCache");
        String channelIdString = (String)this.stringRedisTemplate.opsForValue().get((Object)key);
        timer.stop();
        if (StringUtils.isNotBlank((CharSequence)channelIdString)) {
            try {
                channelId = Long.valueOf(channelIdString);
            }
            catch (Exception e) {
                log.error("getInviteChannel,parse error", (Throwable)e);
            }
        }
        if (channelId == null) {
            log.info("getInviteChannel,\u4ece\u7f13\u5b58\u4e2d\u672a\u67e5\u8be2\u5230channelId,bizId:{},channelNum:{}", (Object)bizId, (Object)channelNum);
        }
        timer.print();
        return channelId;
    }

    @Override
    public void setParamEncryRelation(MeetingCustomerParamEncryRelation relation, Date meetingEndTime) {
        log.info("setParamEncryRelation,relation:{},meetingEndTime:{}", (Object)relation, (Object)meetingEndTime);
        StopWatchDto timer = new StopWatchDto("setParamEncryRelation", true, log);
        timer.start("setCache");
        String key = MessageFormat.format(CACHE_ENCRY_RELATION_KEY, relation.getBizId(), relation.getAppId(), relation.getMeetingId(), relation.getOpenId(), relation.getUnionId(), relation.getChannelId());
        long timeoutHours = this.calMeetingCacheTimeoutHours(meetingEndTime);
        this.stringRedisTemplate.opsForValue().set((Object)key, (Object)JSONObject.toJSONString((Object)relation), timeoutHours, TimeUnit.HOURS);
        timer.stop();
        timer.print();
    }

    @Override
    public MeetingCustomerParamEncryRelation getParamEncryRelation(Long bizId, Long meetingId, String appId, String openId, String unionId, Long channelId) {
        log.info("getParamEncryRelation,bizId:{},meetingId:{},appId:{},openId:{},unionId:{},channelId:{}", new Object[]{bizId, meetingId, appId, openId, unionId, channelId});
        StopWatchDto timer = new StopWatchDto("getParamEncryRelation", true, log);
        timer.start("getCache");
        String key = MessageFormat.format(CACHE_ENCRY_RELATION_KEY, bizId, appId, meetingId, openId, unionId, channelId == null ? 0L : channelId);
        String encryRelationString = (String)this.stringRedisTemplate.opsForValue().get((Object)key);
        timer.stop();
        MeetingCustomerParamEncryRelation relation = null;
        if (StringUtils.isNotBlank((CharSequence)encryRelationString)) {
            try {
                relation = (MeetingCustomerParamEncryRelation)JSONObject.parseObject((String)encryRelationString, MeetingCustomerParamEncryRelation.class);
            }
            catch (Exception e) {
                log.error("getParamEncryRelation parse error", (Throwable)e);
            }
        } else {
            log.info("getParamEncryRelation,\u4ece\u7f13\u5b58\u4e2d\u672a\u67e5\u8be2\u5230MeetingCustomerParamEncryRelation,bizId:{},meetingId:{},appId:{},openId:{},unionId:{},channelId:{}", new Object[]{bizId, meetingId, appId, openId, unionId, channelId});
        }
        timer.print();
        return relation;
    }

    @Override
    public void setMeetingParamWhenGenChannelInvite(Long bizId, Long meetingId, Long channelId, MeetingParams meetingParams, Date meetingEndTime) {
        log.info("setMeetingParamWhenGenChannelInvite,bizId:{},meetingId:{},channelId:{},meetingEndTime:{},meetingParams:{}", new Object[]{bizId, meetingId, channelId, meetingEndTime, meetingParams});
        String key = MessageFormat.format(CACHE_CHANNEL_MEETING_PARAMS_KEY, bizId, meetingId, channelId);
        long timeoutHours = this.calMeetingCacheTimeoutHours(meetingEndTime);
        StopWatchDto timer = new StopWatchDto("setMeetingParamWhenGenChannelInvite", true, log);
        timer.start("setCache");
        this.stringRedisTemplate.opsForValue().set((Object)key, (Object)JSONObject.toJSONString((Object)meetingParams), timeoutHours, TimeUnit.HOURS);
        timer.stop();
        timer.print();
    }

    @Override
    public MeetingParams getMeetingParamByChannel(Long bizId, Long meetingId, Long channelId) {
        log.info("getMeetingParamByChannel,bizId:{},meetingId:{},channelId:{}", new Object[]{bizId, meetingId, channelId});
        StopWatchDto timer = new StopWatchDto("getParamEncryRelation", true, log);
        timer.start("getCache");
        String key = MessageFormat.format(CACHE_CHANNEL_MEETING_PARAMS_KEY, bizId, meetingId, channelId);
        MeetingParams meetingParams = null;
        String meetingParamsString = (String)this.stringRedisTemplate.opsForValue().get((Object)key);
        timer.stop();
        if (StringUtils.isNotBlank((CharSequence)meetingParamsString)) {
            try {
                meetingParams = (MeetingParams)JSONObject.parseObject((String)meetingParamsString, MeetingParams.class);
            }
            catch (Exception e) {
                log.error("getMeetingParamByChannel parse error", (Throwable)e);
            }
        } else {
            log.info("getMeetingParamByChannel,\u4ece\u7f13\u5b58\u4e2d\u672a\u67e5\u8be2\u5230meetingParams,bizId:{},meetingId:{},channelId:{}", new Object[]{bizId, meetingId, channelId});
        }
        timer.print();
        return meetingParams;
    }

    @Override
    public void setMeetingParamWhenSidebarGenInvite(Long bizId, Long meetingId, String unionId, ParamEncry paramEncry, Date meetingEndTime) {
        log.info("setMeetingParamWhenSidebarGenInvite,bizId:{},meetingId:{},unionId:{},meetingEndTime:{},paramEncry:{}", new Object[]{bizId, meetingId, unionId, meetingEndTime, paramEncry});
        if (StringUtils.isBlank((CharSequence)unionId)) {
            return;
        }
        StopWatchDto timer = new StopWatchDto("setMeetingParamWhenSidebarGenInvite", true, log);
        String key = MessageFormat.format(CACHE_INVITE_MEETING_PARAMS_KEY, bizId, meetingId, unionId);
        long timeoutHours = this.calMeetingCacheTimeoutHours(meetingEndTime);
        timer.start("setCache");
        this.stringRedisTemplate.opsForValue().set((Object)key, (Object)JSONObject.toJSONString((Object)paramEncry), timeoutHours, TimeUnit.HOURS);
        timer.stop();
        timer.print();
    }

    @Override
    public ParamEncry getMeetingParamBySidebarInvite(Long bizId, Long meetingId, String unionId) {
        log.info("getMeetingParamBySidebarInvite,bizId:{},meetingId:{},unionId:{}", new Object[]{bizId, meetingId, unionId});
        String key = MessageFormat.format(CACHE_INVITE_MEETING_PARAMS_KEY, bizId, meetingId, unionId);
        StopWatchDto timer = new StopWatchDto("getMeetingParamBySidebarInvite", true, log);
        timer.start("getCache");
        String paramEncryString = (String)this.stringRedisTemplate.opsForValue().get((Object)key);
        timer.stop();
        ParamEncry paramEncry = null;
        if (StringUtils.isNotBlank((CharSequence)paramEncryString)) {
            try {
                paramEncry = (ParamEncry)JSONObject.parseObject((String)paramEncryString, ParamEncry.class);
            }
            catch (Exception e) {
                log.error("getMeetingParamBySidebarInvite parse error", (Throwable)e);
            }
        } else {
            log.info("getMeetingParamBySidebarInvite,\u4ece\u7f13\u5b58\u4e2d\u672a\u67e5\u8be2\u5230paramEncry,bizId:{},meetingId:{},unionId:{}", new Object[]{bizId, meetingId, unionId});
        }
        timer.print();
        return paramEncry;
    }

    private Meeting selectByNum(String meetingNum) {
        Meeting select = new Meeting();
        select.setNum(meetingNum);
        return (Meeting)this.meetingMapper.selectOne((Object)select);
    }

    @Override
    public void initMeetingSetting(Long bizId) {
        log.info("initMeetingSetting,bizId:{}", (Object)bizId);
        MeetingSetting select = new MeetingSetting();
        select.setIsDeleted(NumberUtils.INTEGER_ZERO);
        if (bizId != null) {
            select.setBizId(bizId);
        }
        List meetingSettings = this.meetingSettingMapper.select((Object)select);
        for (MeetingSetting meetingSetting : meetingSettings) {
            this.setMeetingSetting(meetingSetting.getBizId(), meetingSetting);
        }
        log.info("initMeetingSetting,done");
    }

    @Override
    public void initOfficialAppId(Long bizId) {
        log.info("initOfficialAppId,bizId:{}", (Object)bizId);
        if (bizId != null) {
            String appId = this.officialAccountMapper.queryLatestAppIdByBizId(bizId);
            if (StringUtils.isNotBlank((CharSequence)appId)) {
                this.setOfficialAppId(bizId, appId);
            }
        } else {
            List officialAccounts = this.officialAccountMapper.queryAllBizLatestAppId();
            for (OfficialAccount officialAccount : officialAccounts) {
                this.setOfficialAppId(officialAccount.getBizId(), officialAccount.getAppId());
            }
        }
        log.info("initOfficialAppId,done");
    }

    @Override
    public void initChannelId(Long bizId) {
        log.info("initChannelId,bizId:{}", (Object)bizId);
        Channel select = new Channel();
        select.setIsDeleted(NumberUtils.INTEGER_ZERO);
        if (bizId != null) {
            select.setBizId(bizId);
        }
        List channelList = this.channelMapper.select((Object)select);
        for (Channel channel : channelList) {
            this.setInviteChannel(channel.getBizId(), channel.getId(), channel.getNum());
        }
        log.info("initChannelId,done");
    }

    @Override
    public void initInviteUserId(Long bizId, String timeoutTime) {
        log.info("initInviteUserId,timeoutTime:{},bizId:{}", (Object)timeoutTime, (Object)bizId);
        List weworkUsers = this.weworkUserMapper.queryAllUserIdByWeworkNums(bizId);
        if (CollectionUtils.isEmpty((Collection)weworkUsers)) {
            log.info("initInviteUserId,weworkUsers isEmpty");
            return;
        }
        Date timeout = DateUtil.getDate((String)timeoutTime, (String)"yyyy-MM-dd HH:mm:ss");
        for (WeworkUser weworkUser : weworkUsers) {
            String weworkUserNum = weworkUser.getNum();
            if (StringUtils.isBlank((CharSequence)weworkUserNum)) continue;
            Long userId = weworkUser.getUserId();
            Long weworkUserBizId = weworkUser.getBizId();
            this.setInviteUserId(weworkUserBizId, weworkUserNum, timeout, userId);
        }
        log.info("initInviteUserId,\u7f13\u5b58\u6570\u636e,size:{},done", (Object)weworkUsers.size());
    }
}

