/*
 * Decompiled with CFR 0.152.
 */
package com.kuaike.scrm.order.enums;

import com.google.common.collect.Maps;
import java.util.Map;

public enum OrderStatus {
    WAIT_PAY(10, "\u5f85\u4ed8\u6b3e"),
    WAIT_GROUP(15, "\u62fc\u56e2\u6d3b\u52a8 \u652f\u4ed8\u6210\u529f \u7b49\u5f85\u6210\u56e2\u4e2d"),
    PAID_WAIT_MERCHANT_TAKE_ORDER(16, "\u652f\u4ed8\u6210\u529f \u7b49\u5f85\u5546\u5bb6\u63a5\u5355\u4e2d (\u540c\u57ce\u914d\u9001, \u7ebf\u4e0b\u81ea\u63d0)"),
    PAID_WAIT_WRITE_OFF(17, "\u652f\u4ed8\u6210\u529f\u5f85\u6838\u9500"),
    WAIT_DELIVERY(20, "\u5f85\u53d1\u8d27"),
    PARTIAL_DELIVERY(21, "\u90e8\u5206\u53d1\u8d27"),
    WAIT_RECEIPT(30, "\u5f85\u6536\u8d27"),
    FINISHED(100, "\u5b8c\u6210"),
    AFTER_SALE_CANCEL(200, "\u5168\u90e8\u5546\u54c1\u552e\u540e\u4e4b\u540e\uff0c\u8ba2\u5355\u53d6\u6d88"),
    USER_CANCEL_OR_PAY_TIMEOUT(250, "\u7528\u6237\u4e3b\u52a8\u53d6\u6d88\u6216\u5f85\u4ed8\u6b3e\u8d85\u65f6\u53d6\u6d88"),
    PAID(10000, "\u5df2\u652f\u4ed8"),
    FAIL(10001, "\u652f\u4ed8\u5931\u8d25");

    private Integer status;
    private String desc;
    private static Map<Integer, OrderStatus> map;

    private OrderStatus(Integer status, String desc) {
        this.status = status;
        this.desc = desc;
    }

    public static boolean isExistByStatus(int status) {
        return map.containsKey(status);
    }

    public static OrderStatus getByStatus(int status) {
        return map.getOrDefault(status, null);
    }

    public Integer getStatus() {
        return this.status;
    }

    public String getDesc() {
        return this.desc;
    }

    static {
        map = Maps.newHashMap();
        for (OrderStatus wxShopOrderStatus : OrderStatus.values()) {
            map.put(wxShopOrderStatus.status, wxShopOrderStatus);
        }
    }
}

