/*
 * Decompiled with CFR 0.152.
 */
package com.kuaike.scrm.goods.service.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import com.kuaike.common.errorcode.CommonErrorCode;
import com.kuaike.common.errorcode.UniverseErrorCode;
import com.kuaike.common.exception.BusinessException;
import com.kuaike.scrm.common.enums.GoodsOrderSource;
import com.kuaike.scrm.common.service.ScrmSkuService;
import com.kuaike.scrm.common.service.dto.req.ScrmProductQueryReq;
import com.kuaike.scrm.common.service.dto.req.ScrmSkuAddReq;
import com.kuaike.scrm.common.service.dto.req.ScrmSkuItemDto;
import com.kuaike.scrm.common.service.dto.req.ScrmSkuProductReq;
import com.kuaike.scrm.common.service.dto.resp.ScrmSkuProductResp;
import com.kuaike.scrm.common.service.dto.resp.SpuSimpleInfoResp;
import com.kuaike.scrm.common.utils.IdGen;
import com.kuaike.scrm.dal.shop.entity.ShopSku;
import com.kuaike.scrm.dal.shop.entity.ShopSpu;
import com.kuaike.scrm.dal.shop.entity.ShopSpuCriteria;
import com.kuaike.scrm.dal.shop.mapper.ShopSkuMapper;
import com.kuaike.scrm.dal.shop.mapper.ShopSpuMapper;
import com.kuaike.scrm.goods.enums.GoodsSkuStatus;
import com.kuaike.scrm.goods.enums.GoodsSpuStatus;
import com.kuaike.scrm.goods.model.ProductEsModel;
import com.kuaike.scrm.goods.req.SpuCreateReq;
import com.kuaike.scrm.goods.service.GoodsEsService;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import javax.annotation.Resource;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class ScrmSkuServiceImpl
implements ScrmSkuService {
    private static final Logger log = LoggerFactory.getLogger(ScrmSkuServiceImpl.class);
    @Resource
    private IdGen idGen;
    @Resource
    private ShopSpuMapper shopSpuMapper;
    @Resource
    private ShopSkuMapper skuMapper;
    @Resource
    private GoodsEsService goodsEsService;

    public void add(ScrmSkuAddReq req) {
        List spuList;
        log.info("add sku, req={}", (Object)req);
        Preconditions.checkArgument((req != null ? 1 : 0) != 0, (Object)"params is null");
        Preconditions.checkArgument((req.getBizId() != null ? 1 : 0) != 0, (Object)"bizId is null");
        if (StringUtils.isBlank((CharSequence)req.getOutProductId())) {
            req.setOutProductId(this.idGen.getNum());
        }
        if (CollectionUtils.isNotEmpty((Collection)req.getSkus())) {
            for (Object sku : req.getSkus()) {
                if (!StringUtils.isBlank((CharSequence)sku.getOutSkuId())) continue;
                sku.setOutSkuId(this.idGen.getNum());
                sku.setOutProductId(req.getOutProductId());
            }
        }
        if (CollectionUtils.isNotEmpty((Collection)(spuList = this.shopSpuMapper.queryByProductsBy(req.getBizId(), null, (Collection)Lists.newArrayList((Object[])new String[]{req.getOutProductId()}), req.getSource())))) {
            for (ShopSpu spu : spuList) {
                this.updateSpuDb(req, spu);
                ProductEsModel model = this.shopSpuToEsModel(spu, null, req.getTitle(), req.getSubTitle());
                this.goodsEsService.updateProduct(model);
            }
            return;
        }
        if (this.checkSpuBy(req)) {
            log.info("title:{} source:{} is exist, return", (Object)req.getTitle(), (Object)req.getSource());
            return;
        }
        ShopSpu shopSpu = this.insertSpuDb(req);
        Long minPrice = this.batchInsertSkuDb(shopSpu, req.getOutProductId(), req.getSkus(), req.getBizId());
        ProductEsModel model = this.shopSpuToEsModel(shopSpu, minPrice, req.getTitle(), req.getSubTitle());
        try {
            this.goodsEsService.writeProduct(model);
        }
        catch (IOException e) {
            log.error("create spu error", (Throwable)e);
            throw new BusinessException((UniverseErrorCode)CommonErrorCode.BUSINESS_ERROR, "\u7f51\u7edc\u5f02\u5e38\uff0c\u8bf7\u7a0d\u540e\u518d\u8bd5");
        }
        log.info("create spu finish");
    }

    public List<ScrmSkuProductResp> queryProductInfoList(ScrmSkuProductReq req) {
        log.info("queryProductInfoList req: {}", (Object)req);
        req.validate();
        List spuList = this.shopSpuMapper.queryProductList(req.getBizId(), req.getShopId(), req.getTitle(), req.getStatus(), req.getPlatform(), Integer.valueOf(req.getPageDto().getOffset()), req.getPageDto().getPageSize());
        log.info("queryProductInfoList get spuList size: {}", (Object)spuList.size());
        if (CollectionUtils.isEmpty((Collection)spuList)) {
            return Collections.emptyList();
        }
        Integer count = this.shopSpuMapper.queryProductListCount(req.getBizId(), req.getShopId(), req.getTitle(), req.getStatus(), req.getPlatform());
        req.getPageDto().setCount(count);
        req.getPageDto().setCurPageCount(Integer.valueOf(spuList.size()));
        ArrayList resps = Lists.newArrayList();
        for (ShopSpu spu : spuList) {
            ScrmSkuProductResp resp = new ScrmSkuProductResp();
            resp.setProductId(spu.getProductId());
            resp.setOutProductId(spu.getOutProductId());
            resp.setTitle(spu.getTitle());
            resp.setSource(spu.getSource());
            resp.setStatus(spu.getStatus());
            resps.add(resp);
        }
        return resps;
    }

    public List<ScrmSkuProductResp> queryProductListById(ScrmProductQueryReq req) {
        log.info("queryProductListById req: {}", (Object)req);
        req.validate();
        Collection outProductIds = req.getOutProductIds();
        ArrayList productIds = Lists.newArrayList();
        if (CollectionUtils.isNotEmpty((Collection)outProductIds)) {
            productIds.addAll(outProductIds);
        }
        if (CollectionUtils.isNotEmpty((Collection)req.getProductIds())) {
            productIds.addAll(req.getProductIds());
        }
        List spuList = this.shopSpuMapper.queryByProductIdsOrOutProductId(req.getBizId(), (Collection)productIds, req.getSource());
        log.info("queryProductListById spuList: {}", (Object)spuList);
        ArrayList resps = Lists.newArrayList();
        if (CollectionUtils.isNotEmpty((Collection)spuList)) {
            for (ShopSpu shopSpu : spuList) {
                ScrmSkuProductResp resp = new ScrmSkuProductResp();
                resp.setProductId(shopSpu.getProductId());
                resp.setOutProductId(shopSpu.getOutProductId());
                resp.setSource(shopSpu.getSource());
                resp.setCreateTime(shopSpu.getCreateTime());
                resp.setUpdateTime(shopSpu.getUpdateTime());
                resp.setStatus(shopSpu.getStatus());
                String spuBody = shopSpu.getSpuBody();
                if (StringUtils.isNotBlank((CharSequence)spuBody)) {
                    ScrmSkuAddReq addReq = (ScrmSkuAddReq)JSONObject.parseObject((String)spuBody, ScrmSkuAddReq.class);
                    resp.setTitle(addReq.getTitle());
                    resp.setHeadImgs(addReq.getHeadImg());
                    resp.setSkus(addReq.getSkus());
                }
                resps.add(resp);
            }
        }
        return resps;
    }

    public List<String> querySkuNoByProductIds(ScrmProductQueryReq req) {
        log.info("querySkuNoByProductIds req: {}", (Object)req);
        Preconditions.checkArgument((req.getBizId() != null ? 1 : 0) != 0, (Object)"bizId\u4e0d\u80fd\u4e3a\u7a7a");
        Collection productIds = req.getProductIds();
        Collection outProductIds = req.getOutProductIds();
        if (CollectionUtils.isEmpty((Collection)productIds) && CollectionUtils.isEmpty((Collection)outProductIds)) {
            return Lists.newArrayList();
        }
        List spuList = this.shopSpuMapper.queryByProductsBy(req.getBizId(), productIds, outProductIds, req.getSource());
        if (CollectionUtils.isEmpty((Collection)spuList)) {
            return Lists.newArrayList();
        }
        ArrayList skuNos = Lists.newArrayList();
        for (ShopSpu spu : spuList) {
            if (!GoodsOrderSource.isFromSystem((Integer)spu.getSource()) && StringUtils.isNotBlank((CharSequence)spu.getOutProductId())) {
                skuNos.add(spu.getOutProductId());
                continue;
            }
            skuNos.add(spu.getProductId());
        }
        return skuNos;
    }

    public SpuSimpleInfoResp querySpuSimpleInfo(Long bizId, String productId) {
        log.info("querySpuSimpleInfo,bizId:{},productId:{}", (Object)bizId, (Object)productId);
        if (bizId == null || bizId <= 0L) {
            throw new BusinessException((UniverseErrorCode)CommonErrorCode.BUSINESS_ERROR, "bizId\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (StringUtils.isBlank((CharSequence)productId)) {
            throw new BusinessException((UniverseErrorCode)CommonErrorCode.BUSINESS_ERROR, "productId\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a");
        }
        ShopSpu shopSpu = this.shopSpuMapper.queryByBizIdAndProductIdIncludeDeleted(bizId, productId);
        if (shopSpu == null) {
            log.warn("\u6839\u636ebizId:{},productId:{}\u672a\u67e5\u8be2\u5230shopSpu", (Object)bizId, (Object)productId);
            throw new BusinessException((UniverseErrorCode)CommonErrorCode.BUSINESS_ERROR, "\u5546\u54c1\u4e0d\u5b58\u5728");
        }
        SpuSimpleInfoResp resp = new SpuSimpleInfoResp();
        SpuCreateReq spuCreateReq = null;
        if (StringUtils.isNotBlank((CharSequence)shopSpu.getSpuBody())) {
            spuCreateReq = (SpuCreateReq)JSON.parseObject((String)shopSpu.getSpuBody(), SpuCreateReq.class);
        }
        resp.setOutProductId(shopSpu.getOutProductId());
        resp.setProductId(shopSpu.getProductId());
        if (spuCreateReq != null) {
            resp.setTitle(spuCreateReq.getTitle());
            resp.setSubTitle(spuCreateReq.getSubTitle());
        }
        resp.setSource(shopSpu.getSource());
        return resp;
    }

    public List<String> querySkuOutSkuIdsByProductIds(List<String> productIds) {
        log.info("querySkuOutSkuIdsByProductIds,productIds:{}", productIds);
        if (CollectionUtils.isEmpty(productIds)) {
            return Lists.newArrayList();
        }
        List shopSkus = this.skuMapper.selectByProductIds(productIds);
        ArrayList skuOutSkuIds = Lists.newArrayList();
        for (ShopSku shopSku : shopSkus) {
            skuOutSkuIds.add(shopSku.getSkuId());
            skuOutSkuIds.add(shopSku.getOutSkuId());
        }
        return skuOutSkuIds;
    }

    private boolean checkSpuBy(ScrmSkuAddReq req) {
        String title = "%\"title\":\"STR\"%";
        ShopSpuCriteria shopSpuCriteria = new ShopSpuCriteria();
        shopSpuCriteria.createCriteria().andBizIdEqualTo(req.getBizId()).andSourceEqualTo(req.getSource()).andSpuBodyLike(title.replace("STR", req.getTitle()));
        int count = this.shopSpuMapper.selectCountByExample((Object)shopSpuCriteria);
        return count > 0;
    }

    private ShopSpu insertSpuDb(ScrmSkuAddReq req) {
        Date now = new Date();
        ShopSpu item = new ShopSpu();
        item.setNum(this.idGen.getNum());
        item.setAppId("-1");
        String productId = String.valueOf(this.idGen.nextId());
        item.setProductId(productId);
        item.setOutProductId(req.getOutProductId());
        item.setSpuBody(JSON.toJSONString((Object)req));
        item.setCreateBy(Long.valueOf(-1L));
        item.setCreateTime(now);
        item.setUpdateTime(now);
        item.setIsDeleted(Integer.valueOf(0));
        item.setStatus(Integer.valueOf(GoodsSpuStatus.LISTING.getStatus()));
        item.setEditStatus(Integer.valueOf(-1));
        item.setBizId(req.getBizId());
        item.setSource(req.getSource());
        item.setShopId(req.getShopId());
        item.setTitle(req.getTitle());
        this.shopSpuMapper.insert((Object)item);
        return item;
    }

    private void updateSpuDb(ScrmSkuAddReq req, ShopSpu spu) {
        Date now = new Date();
        spu.setSpuBody(JSON.toJSONString((Object)req));
        spu.setUpdateTime(now);
        spu.setTitle(req.getTitle());
        this.shopSpuMapper.updateByPrimaryKeySelective((Object)spu);
    }

    private Long batchInsertSkuDb(ShopSpu shopSpu, String outProductId, List<ScrmSkuItemDto> skus, Long bizId) {
        Long minPrice = null;
        Date now = new Date();
        ArrayList<ShopSku> addSkus = new ArrayList<ShopSku>();
        for (ScrmSkuItemDto skuItemDto : skus) {
            if (StringUtils.isNotBlank((CharSequence)skuItemDto.getSkuId())) continue;
            ShopSku sku = this.buildShopSku(shopSpu, outProductId, now, skuItemDto, bizId);
            if (minPrice == null || sku.getSalePrice() < minPrice) {
                minPrice = sku.getSalePrice();
            }
            addSkus.add(sku);
        }
        if (CollectionUtils.isNotEmpty(addSkus)) {
            this.skuMapper.batchInsert(addSkus);
        }
        return minPrice;
    }

    private ShopSku buildShopSku(ShopSpu shopSpu, String outProductId, Date now, ScrmSkuItemDto skuItemDto, Long bizId) {
        ShopSku shopSku = new ShopSku();
        shopSku.setStatus(Integer.valueOf(GoodsSkuStatus.LISTING.getStatus()));
        shopSku.setProductId(shopSpu.getProductId());
        shopSku.setOutProductId(outProductId);
        shopSku.setSkuId(String.valueOf(this.idGen.nextId()));
        shopSku.setOutSkuId(skuItemDto.getOutSkuId());
        shopSku.setSkuBody(JSON.toJSONString((Object)skuItemDto));
        shopSku.setAppId("-1");
        shopSku.setCreateTime(now);
        shopSku.setCreateBy(Long.valueOf(-1L));
        shopSku.setMarketPrice(Long.valueOf(skuItemDto.getMarketPrice() != null ? skuItemDto.getMarketPrice() : 0L));
        shopSku.setSalePrice(skuItemDto.getSalePrice());
        shopSku.setStockNum(skuItemDto.getStockNum());
        shopSku.setNum(this.idGen.getNum());
        shopSku.setBizId(bizId);
        shopSku.setSource(shopSpu.getSource());
        return shopSku;
    }

    private ProductEsModel shopSpuToEsModel(ShopSpu shopSpu, Long minPrice, String title, String subTitle) {
        ProductEsModel model = new ProductEsModel();
        model.setAppId("-1");
        model.setProductId(shopSpu.getProductId());
        model.setOutProductId(shopSpu.getOutProductId());
        model.setTitle(title);
        model.setSubTitle(subTitle);
        if (minPrice != null) {
            model.setPrice(minPrice);
        }
        model.setCategoryIdL1(null);
        model.setCategoryIdL2(null);
        model.setCategoryIdL3(null);
        model.setStatus(shopSpu.getStatus());
        model.setEditStatus(shopSpu.getEditStatus());
        model.setCreateTime(shopSpu.getCreateTime());
        model.setUpdateTime(shopSpu.getUpdateTime());
        model.setIsDeleted(shopSpu.getIsDeleted());
        model.setSource(shopSpu.getSource());
        model.setBizId(shopSpu.getBizId());
        return model;
    }
}

