/*
 * Decompiled with CFR 0.152.
 */
package com.kuaike.scrm.goods.req;

import com.google.common.base.Preconditions;
import com.kuaike.scrm.goods.dto.SkuItemDto;
import com.kuaike.scrm.goods.req.SpuCreateReq;
import java.util.List;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;

public class SpuUpdateReq
extends SpuCreateReq {
    private String productId;

    @Override
    public void validate() {
        super.validate();
        Preconditions.checkArgument((boolean)StringUtils.isNotBlank((CharSequence)this.productId), (Object)"productId\u4e0d\u80fd\u4e3a\u7a7a");
        List<SkuItemDto> skus = this.getSkus();
        if (CollectionUtils.isNotEmpty(skus)) {
            for (SkuItemDto dto : skus) {
                dto.setProductId(this.productId);
            }
        }
    }

    public SpuUpdateReq() {
    }

    public SpuUpdateReq(String productId) {
        this.productId = productId;
    }

    public String getProductId() {
        return this.productId;
    }

    public void setProductId(String productId) {
        this.productId = productId;
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof SpuUpdateReq)) {
            return false;
        }
        SpuUpdateReq other = (SpuUpdateReq)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$productId = this.getProductId();
        String other$productId = other.getProductId();
        return !(this$productId == null ? other$productId != null : !this$productId.equals(other$productId));
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof SpuUpdateReq;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $productId = this.getProductId();
        result = result * 59 + ($productId == null ? 43 : $productId.hashCode());
        return result;
    }

    @Override
    public String toString() {
        return "SpuUpdateReq(productId=" + this.getProductId() + ")";
    }
}

