/*
 * Decompiled with CFR 0.152.
 */
package com.kuaike.scrm.goods.enums;

import com.google.common.collect.Sets;
import java.util.Arrays;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;

public enum GoodsSkuStatus {
    LISTING(5, "\u4e0a\u67b6"),
    FAKE_DELETED(21, "\u5047\u5220\u9664");

    private int status;
    private String desc;
    private static final Map<Integer, GoodsSkuStatus> MAP;

    public int getStatus() {
        return this.status;
    }

    public String getDesc() {
        return this.desc;
    }

    private GoodsSkuStatus(int status, String desc) {
        this.status = status;
        this.desc = desc;
    }

    public static GoodsSkuStatus getByStatus(int status) {
        return MAP.get(status);
    }

    public static Set<Integer> getAllStatus() {
        return Sets.newHashSet(MAP.keySet());
    }

    static {
        MAP = Arrays.stream(GoodsSkuStatus.values()).collect(Collectors.toMap(GoodsSkuStatus::getStatus, a -> a));
    }
}

