/*
 * Decompiled with CFR 0.152.
 */
package com.kuaike.scrm.follow.record.service.impl;

import cn.kinyun.wework.sdk.api.external.ExternalTagClient;
import cn.kinyun.wework.sdk.entity.external.croptag.MarkTagParams;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.kuaike.common.errorcode.CommonErrorCode;
import com.kuaike.common.errorcode.UniverseErrorCode;
import com.kuaike.common.exception.BusinessException;
import com.kuaike.common.utils.JacksonUtil;
import com.kuaike.scrm.common.dto.CurrentUserInfo;
import com.kuaike.scrm.common.enums.ContactStageStatus;
import com.kuaike.scrm.common.enums.FollowRecordType;
import com.kuaike.scrm.common.service.CustomerCenterService;
import com.kuaike.scrm.common.service.ExternalContactModService;
import com.kuaike.scrm.common.utils.LoginUtils;
import com.kuaike.scrm.dal.contactstage.entity.WeworkContactStage;
import com.kuaike.scrm.dal.contactstage.mapper.WeworkContactStageMapper;
import com.kuaike.scrm.dal.follow.entity.FollowRecord;
import com.kuaike.scrm.dal.follow.mapper.FollowRecordMapper;
import com.kuaike.scrm.dal.permission.mapper.UserMapper;
import com.kuaike.scrm.dal.wework.entity.WeworkContact;
import com.kuaike.scrm.dal.wework.entity.WeworkUser;
import com.kuaike.scrm.dal.wework.mapper.WeworkContactMapper;
import com.kuaike.scrm.dal.wework.mapper.WeworkUserMapper;
import com.kuaike.scrm.dal.weworktag.entity.WeworkContactTag;
import com.kuaike.scrm.dal.weworktag.mapper.WeworkContactTagMapper;
import com.kuaike.scrm.dal.weworktag.mapper.WeworkTagMapper;
import com.kuaike.scrm.follow.dto.CorpTagDto;
import com.kuaike.scrm.follow.dto.FollowInfo;
import com.kuaike.scrm.follow.dto.FollowReqDto;
import com.kuaike.scrm.follow.record.dto.FollowInfoReqDto;
import com.kuaike.scrm.follow.record.dto.FollowRecordReqDto;
import com.kuaike.scrm.follow.record.dto.FollowRecordRespDto;
import com.kuaike.scrm.follow.record.dto.StageReq;
import com.kuaike.scrm.follow.record.service.FollowRecordService;
import com.kuaike.scrm.follow.service.FollowService;
import com.kuaike.scrm.wework.contact.dto.ModifyTagDto;
import com.kuaike.scrm.wework.contact.service.ContactOpService;
import com.kuaike.scrm.wework.contact.service.ContactTagSyncService;
import com.kuaike.scrm.wework.contacttag.service.ContactTagService;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.collections4.MapUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class FollowRecordServiceImpl
implements FollowRecordService {
    private static final Logger log = LoggerFactory.getLogger(FollowRecordServiceImpl.class);
    @Autowired
    private ContactTagService contactTagService;
    @Autowired
    private FollowService followService;
    @Autowired
    private WeworkContactStageMapper weworkContactStageMapper;
    @Autowired
    private WeworkContactTagMapper weworkContactTagMapper;
    @Autowired
    private WeworkTagMapper weworkTagMapper;
    @Autowired
    private FollowRecordMapper followRecordMapper;
    @Autowired
    private UserMapper userMapper;
    @Autowired
    private WeworkUserMapper weworkUserMapper;
    @Resource
    private WeworkContactMapper weworkContactMapper;
    @Autowired
    private ExternalTagClient externalTagClient;
    @Autowired
    private CustomerCenterService customerCenterService;
    @Autowired
    private ExternalContactModService externalContactModService;
    @Autowired
    private ContactOpService contactOpService;
    @Autowired
    private ContactTagSyncService contactTagSyncService;

    @Override
    public void addFollow(FollowInfoReqDto reqDto) {
        CurrentUserInfo currentUserInfo = LoginUtils.getCurrentUser();
        log.info("addFollow,operatorId:{}, reqDto:{}", (Object)currentUserInfo.getId(), (Object)reqDto);
        reqDto.validateParams();
        Long bizId = currentUserInfo.getBizId();
        String corpId = currentUserInfo.getCorpId();
        FollowRecordType followRecordType = FollowRecordType.FOLLOW_INFO;
        String weworkUserNum = reqDto.getWeworkUserId();
        String customerNum = reqDto.getCustomerNum();
        String weworkContactId = reqDto.getWeworkContactId();
        WeworkUser weworkUser = this.weworkUserMapper.queryWeworkUserByNum(weworkUserNum);
        if (Objects.isNull(weworkUser)) {
            log.error("\u6839\u636eweworkUserNum:{}\u672a\u83b7\u53d6\u5230\u8bb0\u5f55", (Object)weworkUserNum);
            throw new BusinessException((UniverseErrorCode)CommonErrorCode.PARAM_ERROR, "\u8bf7\u6c42\u53c2\u6570\u4e0d\u5408\u6cd5");
        }
        FollowReqDto followReqDto = new FollowReqDto();
        followReqDto.setWeworkUserNum(weworkUserNum);
        followReqDto.setCustomerNum(customerNum);
        followReqDto.setContactId(weworkContactId);
        followReqDto.setType(Integer.valueOf(followRecordType.getValue()));
        FollowInfo followInfo = new FollowInfo();
        followReqDto.setFollowInfo(followInfo);
        StageReq stageReq = new StageReq();
        stageReq.setStageId(reqDto.getStageId());
        stageReq.setStageReasonId(reqDto.getStageReasonId());
        stageReq.setFinalStageId(reqDto.getFinalStageId());
        this.handleStage(bizId, corpId, weworkUser.getNum(), weworkContactId, stageReq, followInfo);
        this.handleTag(bizId, corpId, weworkUser, weworkContactId, reqDto, followInfo);
        followInfo.setRemark(reqDto.getRemark());
        followInfo.setAttachments(reqDto.getAttachments());
        followInfo.setCallRecordNum(reqDto.getCallRecordNum());
        followInfo.setAppointmentTime(reqDto.getAppointmentTime());
        this.followService.saveFollowRecord(followReqDto, currentUserInfo);
    }

    @Override
    public List<FollowRecordRespDto> followRecords(FollowRecordReqDto reqDto) {
        CurrentUserInfo currentUserInfo = LoginUtils.getCurrentUser();
        log.info("followRecords,operatorId:{}, reqDto:{}", (Object)currentUserInfo.getId(), (Object)reqDto);
        reqDto.validateParams();
        String corpId = currentUserInfo.getCorpId();
        String weworkUserNum = reqDto.getWeworkUserId();
        String contactId = reqDto.getWeworkContactId();
        List followRecords = this.followRecordMapper.selectByParams(corpId, weworkUserNum, contactId);
        if (CollectionUtils.isEmpty((Collection)followRecords)) {
            log.info("\u6839\u636ecorpId:{}, weworkUserNum:{}, contactId:{}\u672a\u67e5\u8be2\u5230\u8ddf\u8fdb\u8bb0\u5f55", new Object[]{corpId, weworkUserNum, contactId});
            return Collections.emptyList();
        }
        Set creatorIds = followRecords.stream().map(FollowRecord::getCreateBy).collect(Collectors.toSet());
        Map userId2NameMap = this.userMapper.selectUserIdAndNameByIds(currentUserInfo.getBizId(), currentUserInfo.getCorpId(), creatorIds);
        Set contactIds = followRecords.stream().map(FollowRecord::getWeworkContactId).collect(Collectors.toSet());
        List contacts = this.weworkContactMapper.queryWeworkContactList(corpId, contactIds);
        Map contactMap = contacts.stream().collect(Collectors.toMap(WeworkContact::getContactId, Function.identity()));
        ArrayList followRecordRespDtos = Lists.newArrayList();
        for (FollowRecord followRecord : followRecords) {
            WeworkContact contact;
            FollowRecordRespDto followRecordRespDto = new FollowRecordRespDto();
            followRecordRespDtos.add(followRecordRespDto);
            followRecordRespDto.setContent(followRecord.getContent());
            followRecordRespDto.setType(followRecord.getType());
            followRecordRespDto.setTypeDesc(FollowRecordType.get((int)followRecord.getType()).getDesc());
            followRecordRespDto.setCreatorId(followRecord.getCreateBy());
            followRecordRespDto.setFollowTime(followRecord.getCreateTime());
            String creatorName = "\u7cfb\u7edf";
            if (MapUtils.isNotEmpty((Map)userId2NameMap) && userId2NameMap.containsKey(followRecord.getCreateBy())) {
                creatorName = (String)userId2NameMap.get(followRecord.getCreateBy());
            }
            followRecordRespDto.setCreatorName(creatorName);
            if (FollowRecordType.FOLLOW_INFO.getValue() == followRecord.getType().intValue()) {
                try {
                    FollowReqDto followReqDto = (FollowReqDto)JacksonUtil.str2Obj((String)followRecord.getParams(), FollowReqDto.class);
                    if (Objects.nonNull(followReqDto) && Objects.nonNull(followReqDto.getFollowInfo())) {
                        followRecordRespDto.setAttachments(followReqDto.getFollowInfo().getAttachments());
                    }
                }
                catch (Exception ex) {
                    log.error("\u8f6c\u6362\u8ddf\u8fdb\u8bb0\u5f55:{}\u6210\u5bf9\u8c61\u65f6\u53d1\u751f\u5f02\u5e38:", (Object)followRecord.getParams(), (Object)ex);
                }
            }
            if (followRecord.getType().intValue() != FollowRecordType.CUSTOMER_FOLLOW.getValue() && followRecord.getType().intValue() != FollowRecordType.FORM_CUSTOMER_FOLLOW.getValue() || (contact = (WeworkContact)contactMap.get(followRecord.getWeworkContactId())) == null) continue;
            followRecordRespDto.setName(contact.getName());
            followRecordRespDto.setAvatar(contact.getAvatar());
            followRecordRespDto.setCorpName(contact.getCorpName());
        }
        return followRecordRespDtos;
    }

    @Override
    public void handleStage(Long bizId, String corpId, String weworkUserNum, String weworkContactId, StageReq reqDto, FollowInfo followInfo) {
        if (reqDto.getStageId() == null && reqDto.getFinalStageId() == null) {
            return;
        }
        if (StringUtils.isBlank((CharSequence)weworkUserNum)) {
            log.error("weworkUserNum is null");
            return;
        }
        WeworkContactStage oldContactStage = this.weworkContactStageMapper.selectCurrentStageByParams(corpId, weworkUserNum, weworkContactId);
        WeworkContactStage newContactStage = new WeworkContactStage();
        if (reqDto.getStageId() != null) {
            newContactStage.setStageId(reqDto.getStageId());
            newContactStage.setStatus(Integer.valueOf(ContactStageStatus.FLOWING.getValue()));
        }
        if (reqDto.getFinalStageId() != null) {
            newContactStage.setFinalStageId(reqDto.getFinalStageId());
            newContactStage.setStageReasonId(reqDto.getStageReasonId());
            newContactStage.setStatus(Integer.valueOf(ContactStageStatus.END.getValue()));
        }
        newContactStage.setBizId(bizId);
        newContactStage.setCorpId(corpId);
        newContactStage.setWeworkUserNum(weworkUserNum);
        newContactStage.setContactId(weworkContactId);
        newContactStage.setCreateTime(new Date());
        newContactStage.setUpdateTime(new Date());
        newContactStage.setUpdateBy(Long.valueOf(-1L));
        newContactStage.setCreateBy(Long.valueOf(-1L));
        this.weworkContactStageMapper.batchInsert(Collections.singletonList(newContactStage));
        this.customerCenterService.pushCustomerStage(newContactStage);
        if (Objects.isNull(followInfo)) {
            return;
        }
        if (Objects.nonNull(oldContactStage)) {
            if (oldContactStage.getStatus().intValue() == ContactStageStatus.END.getValue()) {
                followInfo.setOldStageId(oldContactStage.getFinalStageId());
            } else {
                followInfo.setOldStageId(oldContactStage.getStageId());
            }
            followInfo.setOldStageReasonId(oldContactStage.getStageReasonId());
        }
        if (newContactStage.getStatus().intValue() == ContactStageStatus.END.getValue()) {
            followInfo.setNewStageId(newContactStage.getFinalStageId());
        } else {
            followInfo.setNewStageId(newContactStage.getStageId());
        }
        followInfo.setNewStageReasonId(newContactStage.getStageReasonId());
    }

    private void handleTag(Long bizId, String corpId, WeworkUser weworkUser, String weworkContactId, FollowInfoReqDto reqDto, FollowInfo followInfo) {
        CorpTagDto corpTagDto;
        List<String> addTagIds = reqDto.getAddWeworkTagIds();
        List<String> rmTagIds = reqDto.getRmWeworkTagIds();
        List oldTagIds = this.weworkContactTagMapper.queryWeworkTagIds(corpId, weworkUser.getWeworkUserId(), weworkContactId);
        ArrayList newTagIds = Lists.newArrayList();
        if (CollectionUtils.isNotEmpty((Collection)oldTagIds)) {
            newTagIds.addAll(oldTagIds);
        }
        if (CollectionUtils.isNotEmpty(addTagIds)) {
            newTagIds.addAll(addTagIds);
        }
        if (CollectionUtils.isNotEmpty(rmTagIds)) {
            newTagIds.removeAll(rmTagIds);
        }
        if (!CollectionUtils.isEmpty(addTagIds) || !CollectionUtils.isEmpty(rmTagIds)) {
            MarkTagParams req = new MarkTagParams();
            req.setUserId(weworkUser.getWeworkUserId());
            req.setExternalUserId(weworkContactId);
            req.setAddTagIds(addTagIds);
            req.setRemoveTagIds(rmTagIds);
            ModifyTagDto modifyTagDto = new ModifyTagDto();
            modifyTagDto.setBizId(bizId);
            modifyTagDto.setCorpId(corpId);
            modifyTagDto.setWeworkUserId(weworkUser.getWeworkUserId());
            modifyTagDto.setContactId(weworkContactId);
            modifyTagDto.setRemoveTagIds(rmTagIds);
            modifyTagDto.setAddTagIds(addTagIds);
            try {
                this.externalTagClient.markTag(corpId, req);
            }
            catch (Exception e) {
                log.error("\u4fee\u6539\u5ba2\u6237\u4f01\u4e1a\u6807\u7b7e\u5931\u8d25, {}, params:{}", (Object)e, (Object)req);
            }
        }
        ArrayList tagIds = Lists.newArrayList();
        tagIds.addAll(oldTagIds);
        tagIds.addAll(newTagIds);
        Map tagId2NameMap = this.weworkTagMapper.selectTagIdAndNameByCorpIdAndTagIds(corpId, (Collection)tagIds);
        ArrayList oldCorpDtos = null;
        ArrayList newCorpDtos = null;
        if (CollectionUtils.isNotEmpty((Collection)oldTagIds)) {
            oldCorpDtos = Lists.newArrayList();
            for (String tagId : oldTagIds) {
                corpTagDto = new CorpTagDto();
                oldCorpDtos.add(corpTagDto);
                corpTagDto.setTagId(tagId);
                if (!MapUtils.isNotEmpty((Map)tagId2NameMap)) continue;
                corpTagDto.setTagName((String)tagId2NameMap.get(tagId));
            }
        }
        if (CollectionUtils.isNotEmpty((Collection)newTagIds)) {
            newCorpDtos = Lists.newArrayList();
            for (String tagId : newTagIds) {
                corpTagDto = new CorpTagDto();
                newCorpDtos.add(corpTagDto);
                corpTagDto.setTagId(tagId);
                if (!MapUtils.isNotEmpty((Map)tagId2NameMap)) continue;
                corpTagDto.setTagName((String)tagId2NameMap.get(tagId));
            }
        }
        followInfo.setOldTags((List)oldCorpDtos);
        followInfo.setNewTags((List)newCorpDtos);
        WeworkContact contact = this.weworkContactMapper.queryContactByContactId(corpId, weworkContactId);
        if (Objects.nonNull(contact)) {
            String customerNum = contact.getCustomerNum();
            this.customerCenterService.pushTagRelation(bizId, weworkUser.getNum(), customerNum, addTagIds, rmTagIds);
        }
        List contactTags = this.weworkContactTagMapper.queryByCorpIdAndContactIdsFilterWeworkUserIds(corpId, (List)Lists.newArrayList((Object[])new String[]{weworkContactId}));
        Set existTagIds = contactTags.stream().map(WeworkContactTag::getTagId).collect(Collectors.toSet());
        HashSet allTagIds = Sets.newHashSet();
        allTagIds.addAll(addTagIds);
        allTagIds.addAll(existTagIds);
        if (CollectionUtils.isNotEmpty(rmTagIds)) {
            allTagIds.removeAll(rmTagIds);
        }
        this.contactTagSyncService.syncTag2Crm(bizId, weworkContactId, (Collection)allTagIds, weworkUser.getWeworkUserId());
    }
}

