/*
 * Decompiled with CFR 0.152.
 */
package com.kuaike.scrm.external.service.impl;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.kuaike.common.errorcode.CommonErrorCode;
import com.kuaike.common.errorcode.UniverseErrorCode;
import com.kuaike.common.exception.BusinessException;
import com.kuaike.scrm.common.perm.service.AccessPermitService;
import com.kuaike.scrm.common.utils.LoginUtils;
import com.kuaike.scrm.dal.permission.entity.Permission;
import com.kuaike.scrm.dal.permission.mapper.PermissionMapper;
import com.kuaike.scrm.external.dto.permission.CheckPermissionReqDto;
import com.kuaike.scrm.external.service.ExternalPermissionService;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class ExternalPermissionServiceImpl
implements ExternalPermissionService {
    private static final Logger log = LoggerFactory.getLogger(ExternalPermissionServiceImpl.class);
    @Autowired
    private AccessPermitService accessPermitService;
    @Autowired
    private PermissionMapper permissionMapper;

    @Override
    public void submitPermissionList(List<Permission> permissions) {
        if (CollectionUtils.isEmpty(permissions)) {
            log.warn("No permission found");
            return;
        }
        Long userId = LoginUtils.getLoginAccountId();
        HashSet codes = Sets.newHashSet();
        HashSet duplicated = Sets.newHashSet();
        for (Permission permission : permissions) {
            String code = permission.getCode();
            if (codes.contains(code)) {
                duplicated.add(code);
                continue;
            }
            codes.add(permission.getCode());
        }
        if (CollectionUtils.isNotEmpty((Collection)duplicated)) {
            log.warn("\u6743\u9650\u7f16\u7801\u91cd\u590d\uff01\u8bf7\u68c0\u67e5\u6743\u9650\u914d\u7f6e\u3002codes={}", (Object)duplicated);
            throw new BusinessException((UniverseErrorCode)CommonErrorCode.BUSINESS_ERROR, "\u6743\u9650\u7f16\u7801\u91cd\u590d\uff01\u8bf7\u68c0\u67e5\u6743\u9650\u914d\u7f6e\u3002codes=" + duplicated);
        }
        List exists = this.permissionMapper.selectByCodes((Collection)codes);
        Map<String, Long> map = exists.stream().collect(Collectors.toMap(Permission::getCode, Permission::getId));
        ArrayList add = Lists.newArrayList();
        ArrayList update = Lists.newArrayList();
        permissions.forEach(p -> {
            Long id = (Long)map.get(p.getCode());
            if (Objects.isNull(id)) {
                p.setCreateBy(userId);
                p.setUpdateBy(userId);
                add.add(p);
            } else {
                p.setId(id);
                p.setUpdateBy(userId);
                update.add(p);
            }
        });
        if (CollectionUtils.isNotEmpty((Collection)update)) {
            this.permissionMapper.batchUpdate((List)update);
        }
        if (CollectionUtils.isNotEmpty((Collection)add)) {
            this.permissionMapper.batchInsert((List)add);
        }
    }

    @Override
    public Boolean checkPermission(CheckPermissionReqDto reqDto) {
        reqDto.validateParams();
        return this.accessPermitService.checkPermission(reqDto.getUrl());
    }
}

