/*
 * Decompiled with CFR 0.152.
 */
package com.kuaike.scrm.event.service.impl;

import com.google.common.base.Joiner;
import com.google.common.collect.Lists;
import com.kuaike.common.utils.JacksonUtil;
import com.kuaike.scrm.common.dto.AttachmentDto;
import com.kuaike.scrm.common.utils.TemplateReplaceUtil;
import com.kuaike.scrm.dal.marketing.entity.MarketingChannel;
import com.kuaike.scrm.dal.marketing.entity.MarketingPlan;
import com.kuaike.scrm.dal.marketing.mapper.MarketingChannelMapper;
import com.kuaike.scrm.dal.marketing.mapper.MarketingPlanMapper;
import com.kuaike.scrm.dal.marketing.mapper.MarketingPlanRoomCodeMapper;
import com.kuaike.scrm.dal.teladdfriend.entity.TelAddFriendTask;
import com.kuaike.scrm.dal.teladdfriend.entity.TelAddFriendTaskDetail;
import com.kuaike.scrm.dal.teladdfriend.entity.TelTaskDetailRoom;
import com.kuaike.scrm.dal.teladdfriend.mapper.TelAddFriendTaskDetailMapper;
import com.kuaike.scrm.dal.teladdfriend.mapper.TelAddFriendTaskMapper;
import com.kuaike.scrm.dal.teladdfriend.mapper.TelTaskDetailRoomMapper;
import com.kuaike.scrm.dal.wework.entity.WeworkUser;
import com.kuaike.scrm.dal.wework.mapper.WeworkUserMapper;
import com.kuaike.scrm.dal.weworktag.mapper.WeworkTagMapper;
import com.kuaike.scrm.event.context.ReplyContext;
import com.kuaike.scrm.event.context.ReplyContextUtil;
import com.kuaike.scrm.event.service.HandleTelAddFriendEventService;
import com.kuaike.scrm.event.service.dto.Welcome;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import javax.annotation.Resource;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class HandleTelAddFriendEventServiceImpl
implements HandleTelAddFriendEventService {
    private static final Logger log = LoggerFactory.getLogger(HandleTelAddFriendEventServiceImpl.class);
    private static final String SENDER_NAME = "${senderName}";
    @Autowired
    private TelAddFriendTaskMapper telAddFriendTaskMapper;
    @Autowired
    private TelAddFriendTaskDetailMapper telAddFriendTaskDetailMapper;
    @Autowired
    private WeworkTagMapper weworkTagMapper;
    @Autowired
    private WeworkUserMapper weworkUserMapper;
    @Autowired
    private MarketingChannelMapper marketingChannelMapper;
    @Autowired
    private MarketingPlanMapper marketingPlanMapper;
    @Autowired
    private TelTaskDetailRoomMapper telTaskDetailRoomMapper;
    @Resource
    private MarketingPlanRoomCodeMapper marketingPlanRoomCodeMapper;

    @Override
    public String getRemark() {
        ReplyContext replyContext = ReplyContextUtil.get();
        String corpId = replyContext.getCorpId();
        String weworkUserNum = replyContext.getWeworkUserNum();
        String mobile = replyContext.getMobile();
        Long taskDetailId = replyContext.getTaskDetailId();
        if (!replyContext.isTelAddFriend()) {
            return null;
        }
        TelAddFriendTaskDetail taskDetail = (TelAddFriendTaskDetail)this.telAddFriendTaskDetailMapper.selectByPrimaryKey((Object)taskDetailId);
        if (taskDetail == null) {
            log.info("\u6839\u636ecorpId:{}, weworkUserNum:{}, tel:{}\u672a\u67e5\u8be2\u5230\u624b\u673a\u53f7\u52a0\u597d\u53cb\u4efb\u52a1", new Object[]{corpId, weworkUserNum, mobile});
            return null;
        }
        TelAddFriendTask task = this.telAddFriendTaskMapper.selectByNum(taskDetail.getTaskNum());
        if (task == null) {
            log.info("\u6839\u636ecorpId:{}, weworkUserNum:{}, tel:{}\u672a\u67e5\u8be2\u5230\u624b\u673a\u53f7\u52a0\u597d\u53cb\u4efb\u52a1", new Object[]{corpId, weworkUserNum, mobile});
            return null;
        }
        String friendRemark = taskDetail.getFriendRemark();
        if ((task.getAddType() == 1 || task.getAddType() == 2) && StringUtils.isEmpty((CharSequence)friendRemark)) {
            friendRemark = task.getFriendRemark();
            log.info("\u6839\u636ecorpId:{}, weworkUserNum:{}, \u6253\u4e0a\u5907\u6ce8friendRemark:{}", new Object[]{corpId, weworkUserNum, friendRemark});
        }
        return friendRemark;
    }

    @Override
    public List<String> getTagIds() {
        ReplyContext replyContext = ReplyContextUtil.get();
        String corpId = replyContext.getCorpId();
        String weworkUserNum = replyContext.getWeworkUserNum();
        String mobile = replyContext.getMobile();
        Long taskDetailId = replyContext.getTaskDetailId();
        if (!replyContext.isTelAddFriend()) {
            return null;
        }
        TelAddFriendTaskDetail taskDetail = (TelAddFriendTaskDetail)this.telAddFriendTaskDetailMapper.selectByPrimaryKey((Object)taskDetailId);
        if (taskDetail == null) {
            log.info("\u6839\u636ecorpId:{}, weworkUserNum:{}, tel:{}\u672a\u67e5\u8be2\u5230\u624b\u673a\u53f7\u52a0\u597d\u53cb\u4efb\u52a1", new Object[]{corpId, weworkUserNum, mobile});
            return null;
        }
        TelAddFriendTask task = this.telAddFriendTaskMapper.selectByNum(taskDetail.getTaskNum());
        if (task == null) {
            log.info("\u6839\u636ecorpId:{}, weworkUserNum:{}, tel:{}\u672a\u67e5\u8be2\u5230\u624b\u673a\u53f7\u52a0\u597d\u53cb\u4efb\u52a1", new Object[]{corpId, weworkUserNum, mobile});
            return null;
        }
        String tagIds = task.getTagIds();
        if (StringUtils.isEmpty((CharSequence)tagIds)) {
            log.info("weworkUserNum: {}, \u6807\u7b7e\u96c6\u4e3a\u7a7a", (Object)weworkUserNum);
            return null;
        }
        List tagList = Lists.newArrayList((Object[])tagIds.split(","));
        if (CollectionUtils.isEmpty((Collection)(tagList = this.weworkTagMapper.selectTagIdsByCorpIdAndTagIds(corpId, (Collection)tagList)))) {
            log.info("weworkUserNum: {}, \u6807\u7b7e\u90fd\u5df2\u88ab\u5220\u9664", (Object)weworkUserNum);
            return null;
        }
        taskDetail.setTagIds(Joiner.on((String)",").join((Iterable)tagList));
        taskDetail.setUpdateTime(new Date());
        this.telAddFriendTaskDetailMapper.updateByPrimaryKeySelective((Object)taskDetail);
        return tagList;
    }

    @Override
    public Welcome getWelcome() {
        ReplyContext replyContext = ReplyContextUtil.get();
        String corpId = replyContext.getCorpId();
        String weworkUserNum = replyContext.getWeworkUserNum();
        String mobile = replyContext.getMobile();
        Long taskDetailId = replyContext.getTaskDetailId();
        if (!replyContext.isTelAddFriend()) {
            log.info("\u975e\u624b\u673a\u53f7\u52a0\u597d\u53cb\uff0ctaskDetailId:{}, tel:{}\u672a\u67e5\u8be2\u5230\u624b\u673a\u53f7\u52a0\u597d\u53cb\u4efb\u52a1", (Object)taskDetailId, (Object)mobile);
            return null;
        }
        TelAddFriendTaskDetail taskDetail = (TelAddFriendTaskDetail)this.telAddFriendTaskDetailMapper.selectByPrimaryKey((Object)taskDetailId);
        if (taskDetail == null) {
            log.info("\u6839\u636ecorpId:{}, weworkUserNum:{}, tel:{}\u672a\u67e5\u8be2\u5230\u624b\u673a\u53f7\u52a0\u597d\u53cb\u4efb\u52a1", new Object[]{corpId, weworkUserNum, mobile});
            return null;
        }
        TelAddFriendTask task = this.telAddFriendTaskMapper.selectByNum(taskDetail.getTaskNum());
        if (task == null) {
            log.info("\u6839\u636ecorpId:{}, weworkUserNum:{}, tel:{}\u672a\u67e5\u8be2\u5230\u624b\u673a\u53f7\u52a0\u597d\u53cb\u4efb\u52a1", new Object[]{corpId, weworkUserNum, mobile});
            return null;
        }
        if (StringUtils.isEmpty((CharSequence)task.getWelcomeJson())) {
            log.info("\u6839\u636ecorpId:{}, weworkUserNum:{}, contactId: {}, welcomejson is null", new Object[]{corpId, weworkUserNum, taskDetail.getContactId()});
            return null;
        }
        Welcome friendWelcomeDto = null;
        try {
            friendWelcomeDto = (Welcome)JacksonUtil.str2Obj((String)task.getWelcomeJson(), Welcome.class);
            AttachmentDto planRoomDto = null;
            int planRoomIndex = -1;
            for (int i = 0; i < friendWelcomeDto.getAttachments().size(); ++i) {
                AttachmentDto attachmentDto = friendWelcomeDto.getAttachments().get(i);
                if (!"planRoom".equals(attachmentDto.getMsgType())) continue;
                planRoomDto = attachmentDto;
                planRoomIndex = i;
            }
            if (planRoomDto != null) {
                boolean userPlanRoomLink = this.handlePlanRoom(planRoomDto);
                if (!userPlanRoomLink) {
                    friendWelcomeDto.getAttachments().remove(planRoomIndex);
                } else {
                    List<String> roomIds = this.getPlanRoomIds(planRoomDto.getPlanChannelId());
                    taskDetail.setPlanChannelNum(planRoomDto.getPlanChannelId());
                    this.telAddFriendTaskDetailMapper.updateByPrimaryKey((Object)taskDetail);
                    if (CollectionUtils.isNotEmpty(roomIds)) {
                        this.saveSendPlanRoom(taskDetailId, roomIds);
                    } else {
                        log.info("\u6839\u636ecorpId:{}, weworkUserNum:{}, contactId: {}, plan roomIds is null", new Object[]{corpId, weworkUserNum, replyContext.getContactId()});
                    }
                }
            }
        }
        catch (IOException e) {
            log.error("parse friendwelcome json error: ", (Throwable)e);
        }
        catch (Exception e) {
            log.error("build welcome error: ", (Throwable)e);
        }
        return friendWelcomeDto;
    }

    @Override
    public void saveRemark(String remark) {
        log.info("save tel add friend task detail remark: {}", (Object)remark);
        ReplyContext ctx = ReplyContextUtil.get();
        Long taskDetailId = ctx.getTaskDetailId();
        if (taskDetailId != null) {
            TelAddFriendTaskDetail taskDetail = (TelAddFriendTaskDetail)this.telAddFriendTaskDetailMapper.selectByPrimaryKey((Object)taskDetailId);
            taskDetail.setFriendRemark(remark);
            taskDetail.setUpdateTime(new Date());
            this.telAddFriendTaskDetailMapper.updateByPrimaryKey((Object)taskDetail);
        }
    }

    private boolean handlePlanRoom(AttachmentDto planRoomDto) {
        WeworkUser weworkUser;
        ReplyContext replyContext = ReplyContextUtil.get();
        String weworkUserNum = replyContext.getWeworkUserNum();
        String title = planRoomDto.getTitle();
        String planChannelId = planRoomDto.getPlanChannelId();
        if (StringUtils.isEmpty((CharSequence)planChannelId)) {
            return false;
        }
        MarketingChannel marketingChannel = this.marketingChannelMapper.getByNum(planChannelId);
        if (marketingChannel == null || marketingChannel.getIsDeleted() == 1) {
            log.info("\u6d3b\u52a8\u6e20\u9053\u4e0d\u5b58\u5728\uff0cweworkUserNum: {} \uff0c planChannelId: {}", (Object)weworkUserNum, (Object)planChannelId);
            return false;
        }
        MarketingPlan marketingPlan = (MarketingPlan)this.marketingPlanMapper.selectByPrimaryKey((Object)marketingChannel.getPlanId());
        if (marketingPlan.getIsEnabled() == 0 || marketingPlan.getIsDeleted() == 1) {
            log.info("\u6d3b\u52a8\u5df2\u7ecf\u7981\u7528\u6216\u8005\u5220\u9664\uff0cweworkUserNum: {} \uff0c planChannelId: {}", (Object)weworkUserNum, (Object)planChannelId);
            return false;
        }
        if (StringUtils.isNotEmpty((CharSequence)title) && (weworkUser = this.weworkUserMapper.queryWeworkUserByNum(weworkUserNum)) != null) {
            title = TemplateReplaceUtil.replace((String)title, (String)SENDER_NAME, (String)weworkUser.getName());
        }
        planRoomDto.setMsgType("link");
        planRoomDto.setTitle(title);
        planRoomDto.setUrl(marketingChannel.getUrl());
        planRoomDto.setPicUrl(planRoomDto.getPicUrl());
        return true;
    }

    private List<String> getPlanRoomIds(String planChannelNum) {
        MarketingChannel marketingChannel = this.marketingChannelMapper.getByNum(planChannelNum);
        Long planId = marketingChannel.getPlanId();
        return this.marketingPlanRoomCodeMapper.queryRoomByPlanId(marketingChannel.getCorpId(), planId);
    }

    private void saveSendPlanRoom(Long taskDetailId, List<String> roomIds) {
        ReplyContext cxt = ReplyContextUtil.get();
        int num = this.telTaskDetailRoomMapper.isExistsTaskDetailRoom(taskDetailId);
        if (num > 0) {
            log.info("save send plan room is handle");
        } else {
            ArrayList insertList = Lists.newArrayListWithCapacity((int)roomIds.size());
            for (String roomId : roomIds) {
                TelTaskDetailRoom taskDetailRoom = new TelTaskDetailRoom();
                taskDetailRoom.setBizId(cxt.getBizId());
                taskDetailRoom.setCorpId(cxt.getCorpId());
                taskDetailRoom.setTaskDetailId(taskDetailId);
                taskDetailRoom.setRoomId(roomId);
                taskDetailRoom.setCreateTime(new Date());
                taskDetailRoom.setCreateBy(Long.valueOf(-1L));
                insertList.add(taskDetailRoom);
            }
            this.telTaskDetailRoomMapper.batchInsert((Collection)insertList);
        }
    }
}

