/*
 * Decompiled with CFR 0.152.
 */
package com.kuaike.scrm.event.service.impl;

import cn.kinyun.customer.center.dto.req.CustomerEventReq;
import cn.kinyun.customer.center.dto.req.event.EventData;
import cn.kinyun.customer.center.dto.req.event.EventModule;
import cn.kinyun.customer.center.dto.req.event.EventPage;
import cn.kinyun.customer.center.enums.EventType;
import cn.kinyun.customer.center.enums.ModuleType;
import cn.kinyun.customer.center.service.CcCustomerEventService;
import com.google.common.base.Splitter;
import com.kuaike.scrm.common.enums.PlanType;
import com.kuaike.scrm.dal.contactanalyse.entity.WeworkContactLog;
import com.kuaike.scrm.dal.contactanalyse.mapper.WeworkContactLogMapper;
import com.kuaike.scrm.dal.marketing.entity.MarketingChannel;
import com.kuaike.scrm.dal.marketing.mapper.MarketingChannelMapper;
import com.kuaike.scrm.dal.radar.entity.MarketingRadarQrcode;
import com.kuaike.scrm.dal.radar.mapper.MarketingRadarMapper;
import com.kuaike.scrm.dal.radar.mapper.MarketingRadarQrcodeMapper;
import com.kuaike.scrm.dal.wework.entity.WeworkContact;
import com.kuaike.scrm.dal.wework.entity.WeworkContactRelation;
import com.kuaike.scrm.dal.wework.mapper.WeworkContactMapper;
import com.kuaike.scrm.dal.wework.mapper.WeworkContactRelationMapper;
import com.kuaike.scrm.dal.weworktag.mapper.WeworkContactTagMapper;
import com.kuaike.scrm.event.context.ReplyContext;
import com.kuaike.scrm.event.context.ReplyContextUtil;
import com.kuaike.scrm.event.service.FriendLogService;
import java.text.MessageFormat;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.apache.tomcat.util.buf.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

@Service
public class FriendLogServiceImpl
implements FriendLogService {
    private static final Logger log = LoggerFactory.getLogger(FriendLogServiceImpl.class);
    @Autowired
    private WeworkContactMapper weworkContactMapper;
    @Autowired
    private WeworkContactRelationMapper weworkContactRelationMapper;
    @Autowired
    private WeworkContactTagMapper weworkContactTagMapper;
    @Autowired
    private WeworkContactLogMapper weworkContactLogMapper;
    @Resource
    private MarketingRadarQrcodeMapper marketingRadarQrcodeMapper;
    @Resource
    private MarketingRadarMapper marketingRadarMapper;
    @Resource
    private MarketingChannelMapper marketingChannelMapper;
    @Autowired
    private CcCustomerEventService ccCustomerEventService;
    @Value(value="${scrm.domain.protocol}${scrm.domain.scrm-manager}${marketing.url.format}")
    private String marketingPlanUrlFormat;
    @Value(value="${scrm.domain.protocol}${scrm.domain.scrm-manager}${region-plan.url.format}")
    private String regionPlanUrlFormat;
    @Value(value="${scrm.domain.protocol}${scrm.domain.scrm-manager}${room-plan.url.format}")
    private String roomPlanUrlFormat;
    @Value(value="${scrm.domain.protocol}${scrm.domain.scrm-manager}${friend-fission.url.format}")
    private String friendFissionUrlFormat;

    @Override
    public boolean isExist() {
        ReplyContext ctx = ReplyContextUtil.get();
        int exist = this.weworkContactLogMapper.existAddLog(ctx.getCorpId(), ctx.getWeworkUserNum(), ctx.getContactId(), ctx.getState(), ctx.getTimestamp());
        if (exist > 0) {
            log.info("\u5df2\u5b58\u5728\u52a0\u597d\u53cb\u8bb0\u5f55\u3002ctx:{}", (Object)ctx);
            return true;
        }
        return false;
    }

    @Override
    public void onAddExternalContact() {
        ReplyContext ctx = ReplyContextUtil.get();
        log.info("onAddExternalContact,ctx:{}", (Object)ctx);
        Long bizId = ctx.getBizId();
        String corpId = ctx.getCorpId();
        String weworkUserId = ctx.getWeworkUserId();
        String contactId = ctx.getContactId();
        WeworkContact contact = this.weworkContactMapper.queryWeworkContact(bizId, corpId, contactId);
        WeworkContactRelation relation = this.weworkContactRelationMapper.get(corpId, weworkUserId, contactId);
        List tagIds = this.weworkContactTagMapper.queryWeworkTagIds(corpId, weworkUserId, contactId);
        WeworkContactLog weworkContactLog = new WeworkContactLog();
        weworkContactLog.setBizId(bizId);
        weworkContactLog.setCorpId(corpId);
        weworkContactLog.setWeworkUserNum(ctx.getWeworkUserNum());
        weworkContactLog.setContactId(contactId);
        if (contact != null) {
            weworkContactLog.setName(contact.getName());
            weworkContactLog.setAvatar(contact.getAvatar());
            weworkContactLog.setCorpName(contact.getCorpName());
            weworkContactLog.setCorpFullName(contact.getCorpFullName());
            weworkContactLog.setType(contact.getType());
            weworkContactLog.setGender(contact.getGender());
        }
        if (relation != null) {
            weworkContactLog.setRemark(relation.getRemark());
            weworkContactLog.setAddWay(relation.getAddWay());
            weworkContactLog.setOperUserId(relation.getOperUserId());
        }
        if (CollectionUtils.isNotEmpty((Collection)tagIds)) {
            weworkContactLog.setWeworkTagIds(StringUtils.join((Collection)tagIds, (char)';'));
        }
        weworkContactLog.setAddTime(ctx.getTimestamp());
        weworkContactLog.setState(ctx.getState());
        weworkContactLog.setPlanId(ctx.getPlanId());
        weworkContactLog.setPlanGroupId(ctx.getPlanGroupId());
        weworkContactLog.setChannelId(ctx.getChannelId());
        weworkContactLog.setCreateTime(new Date());
        weworkContactLog.setIsDeleted(Integer.valueOf(0));
        String radarNum = null;
        if (ctx.isRadar()) {
            MarketingRadarQrcode radarQrcode = new MarketingRadarQrcode();
            radarQrcode.setState(ctx.getState());
            radarQrcode = (MarketingRadarQrcode)this.marketingRadarQrcodeMapper.selectOne((Object)radarQrcode);
            if (radarQrcode != null) {
                Long radarId = this.marketingRadarMapper.queryIdByNum(radarQrcode.getMarketingRadarNum());
                weworkContactLog.setMarketingRadarId(radarId);
                radarNum = radarQrcode.getMarketingRadarNum();
            }
        }
        EventModule eventModule = new EventModule();
        EventPage eventPage = null;
        if (ctx.isPlanActive()) {
            eventModule.setType(ModuleType.MARKETING_PLAN.getCode());
            eventModule.setNum(ctx.getPlanNum());
            eventModule.setPlanType(PlanType.get((int)ctx.getPlanType()).getDesc());
            eventModule.setName(ctx.getPlanName());
            eventModule.setChannelId(ctx.getChannelId());
            eventPage = new EventPage();
            eventPage.setTitle(ctx.getPlanName());
            MarketingChannel marketingChannel = this.marketingChannelMapper.selectByPlanIdAndChannelId(ctx.getPlanId(), ctx.getChannelId());
            if (marketingChannel != null) {
                eventPage.setUrl(this.getChannelUrl(marketingChannel.getNum(), ctx.getPlanType()));
            }
        } else if (ctx.isRadar()) {
            eventModule.setType(ModuleType.RADAR.getCode());
            eventModule.setNum(radarNum);
        } else if (ctx.isTelAddFriend()) {
            eventModule.setType(ModuleType.BATCH_ADD_FRIEND.getCode());
            eventModule.setNum(ctx.getTelAddFriendTaskNum());
            eventModule.setName(ctx.getTelAddFriendTaskName());
        } else {
            eventModule.setType(ModuleType.WEWORK_CONTACT.getCode());
        }
        this.weworkContactLogMapper.insertSelective((Object)weworkContactLog);
        if (contact != null) {
            this.saveAddContactEvent(contact.getCustomerNum(), eventModule, eventPage, weworkContactLog);
        }
    }

    @Override
    public void onDelExternalContact() {
        log.info("onDelExternalContact");
        ReplyContext ctx = ReplyContextUtil.get();
        WeworkContactLog weworkContactLog = new WeworkContactLog();
        weworkContactLog.setBizId(ctx.getBizId());
        weworkContactLog.setCorpId(ctx.getCorpId());
        weworkContactLog.setContactId(ctx.getContactId());
        weworkContactLog.setWeworkUserNum(ctx.getWeworkUserNum());
        weworkContactLog.setCreateTime(new Date());
        weworkContactLog.setIsDeleted(Integer.valueOf(1));
        weworkContactLog.setDeletedTime(ctx.getTimestamp());
        this.weworkContactLogMapper.insertSelective((Object)weworkContactLog);
        WeworkContact contact = this.weworkContactMapper.queryWeworkContact(ctx.getBizId(), ctx.getCorpId(), ctx.getContactId());
        if (contact != null) {
            this.saveDelContactEvent(contact.getCustomerNum(), weworkContactLog);
        }
    }

    private void saveAddContactEvent(String customerNum, EventModule eventModule, EventPage page, WeworkContactLog weworkContactLog) {
        ReplyContext ctx = ReplyContextUtil.get();
        CustomerEventReq eventReq = new CustomerEventReq();
        eventReq.setEventType(EventType.ADD_CONTACT.getCode());
        eventReq.setSource("scrm");
        eventReq.setEventTime(new Date());
        eventReq.setBizId(weworkContactLog.getBizId());
        eventReq.setCustomerNum(customerNum);
        EventData eventData = new EventData();
        eventReq.setEventData(eventData);
        eventData.setModule(eventModule);
        eventData.setPage(page);
        eventData.setContactId(weworkContactLog.getContactId());
        eventData.setName(weworkContactLog.getName());
        eventData.setAvatar(weworkContactLog.getAvatar());
        eventData.setCorpName(weworkContactLog.getCorpName());
        eventData.setCorpFullName(weworkContactLog.getCorpFullName());
        eventData.setType(weworkContactLog.getType());
        eventData.setGender(weworkContactLog.getGender());
        eventData.setRemark(weworkContactLog.getRemark());
        if (org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)weworkContactLog.getWeworkTagIds())) {
            eventData.setWeworkTagIds(Splitter.on((String)";").splitToList((CharSequence)weworkContactLog.getWeworkTagIds()));
        }
        eventData.setWeworkUserNum(weworkContactLog.getWeworkUserNum());
        eventData.setWeworkUserName(ctx.getWeworkUserName());
        eventData.setOpUserId(weworkContactLog.getOperUserId());
        eventData.setAddType(weworkContactLog.getAddWay());
        eventData.setAddTime(weworkContactLog.getAddTime());
        eventData.setState(weworkContactLog.getState());
        try {
            this.ccCustomerEventService.add(eventReq);
        }
        catch (Exception e) {
            log.error("save add contact event error: ", (Throwable)e);
        }
    }

    private String getChannelUrl(String num, int planType) {
        if (planType == PlanType.CHANNEL_PLAN.getValue()) {
            return MessageFormat.format(this.marketingPlanUrlFormat, num);
        }
        if (planType == PlanType.REGION_PLAN.getValue()) {
            return MessageFormat.format(this.regionPlanUrlFormat, num);
        }
        if (planType == PlanType.ROOM_PLAN.getValue()) {
            return MessageFormat.format(this.roomPlanUrlFormat, num);
        }
        if (planType == PlanType.FRIEND_FISSION_PLAN.getValue()) {
            return MessageFormat.format(this.friendFissionUrlFormat, num);
        }
        return null;
    }

    private void saveDelContactEvent(String customerNum, WeworkContactLog weworkContactLog) {
        CustomerEventReq eventReq = new CustomerEventReq();
        eventReq.setEventType(EventType.DEL_CONTACT.getCode());
        eventReq.setSource("scrm");
        eventReq.setEventTime(new Date());
        eventReq.setBizId(weworkContactLog.getBizId());
        eventReq.setCustomerNum(customerNum);
        EventData eventData = new EventData();
        eventReq.setEventData(eventData);
        eventData.setContactId(weworkContactLog.getContactId());
        eventData.setName(weworkContactLog.getName());
        eventData.setAvatar(weworkContactLog.getAvatar());
        eventData.setCorpName(weworkContactLog.getCorpName());
        eventData.setCorpFullName(weworkContactLog.getCorpFullName());
        eventData.setType(weworkContactLog.getType());
        eventData.setGender(weworkContactLog.getGender());
        eventData.setRemark(weworkContactLog.getRemark());
        eventData.setWeworkUserNum(weworkContactLog.getWeworkUserNum());
        eventData.setOpUserId(weworkContactLog.getOperUserId());
        eventData.setDeletedTime(weworkContactLog.getDeletedTime());
        try {
            this.ccCustomerEventService.add(eventReq);
        }
        catch (Exception e) {
            log.error("save del contact event error: ", (Throwable)e);
        }
    }
}

