/*
 * Decompiled with CFR 0.152.
 */
package com.kuaike.scrm.event.service.impl;

import cn.kinyun.wework.sdk.api.external.MassMsgPushApi;
import cn.kinyun.wework.sdk.entity.external.msg.Attachment;
import cn.kinyun.wework.sdk.entity.external.msg.Image;
import cn.kinyun.wework.sdk.entity.external.msg.Link;
import cn.kinyun.wework.sdk.entity.external.msg.MiniProgram;
import cn.kinyun.wework.sdk.entity.external.msg.Text;
import cn.kinyun.wework.sdk.entity.external.msg.Video;
import cn.kinyun.wework.sdk.entity.external.welcome.WelcomeMsg;
import com.google.common.collect.Lists;
import com.kuaike.common.utils.JacksonUtil;
import com.kuaike.scrm.addFriend.dto.WelcomeDto;
import com.kuaike.scrm.common.dto.AttachmentDto;
import com.kuaike.scrm.common.enums.MarketingConfigType;
import com.kuaike.scrm.dal.addFriend.entity.AddFriendConfig;
import com.kuaike.scrm.dal.addFriend.mapper.AddFriendConfigMapper;
import com.kuaike.scrm.dal.marketing.entity.MarketingConfig;
import com.kuaike.scrm.dal.qyQrcodeTask.entity.QyQrcodeSubTask;
import com.kuaike.scrm.dal.qyQrcodeTask.mapper.QyQrcodeSubTaskMapper;
import com.kuaike.scrm.dal.wework.entity.WeworkContact;
import com.kuaike.scrm.dal.wework.mapper.WeworkContactMapper;
import com.kuaike.scrm.event.context.ReplyContext;
import com.kuaike.scrm.event.context.ReplyContextUtil;
import com.kuaike.scrm.event.service.FriendFissionService;
import com.kuaike.scrm.event.service.HandleTelAddFriendEventService;
import com.kuaike.scrm.event.service.WelcomeService;
import com.kuaike.scrm.event.service.dto.Welcome;
import com.kuaike.scrm.marketing.dto.FriendWelcomeDto;
import com.kuaike.scrm.marketing.service.MarketingConfigService;
import com.kuaike.scrm.material.service.MaterialManagerService;
import com.kuaike.scrm.token.service.CustomizedTokenService;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.Resource;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class WelcomeServiceImpl
implements WelcomeService {
    private static final Logger log = LoggerFactory.getLogger(WelcomeServiceImpl.class);
    public static final String NICKNAME = "${nickname}";
    @Autowired
    private MassMsgPushApi massMsgPushApi;
    @Autowired
    private WeworkContactMapper weworkContactMapper;
    @Autowired
    private AddFriendConfigMapper addFriendConfigMapper;
    @Autowired
    private MarketingConfigService marketingConfigService;
    @Autowired
    private CustomizedTokenService customizedTokenService;
    @Autowired
    private MaterialManagerService materialManagerService;
    @Autowired
    private FriendFissionService friendFissionService;
    @Autowired
    private HandleTelAddFriendEventService handleTelAddFriendEventService;
    @Resource
    private QyQrcodeSubTaskMapper qyQrcodeSubTaskMapper;

    @Override
    public boolean onAddExternalContact() {
        ReplyContext ctx = ReplyContextUtil.get();
        String corpId = ctx.getCorpId();
        String welcomeCode = ctx.getWelcomeCode();
        if (StringUtils.isBlank((CharSequence)welcomeCode)) {
            log.warn("welcome code is empty");
            return false;
        }
        Welcome welcome = this.getWelcome();
        if (welcome == null) {
            log.warn("welcome msg is empty");
            return false;
        }
        WelcomeMsg params = this.buildWelcomeMsg(welcome);
        params.setWelcomeCode(welcomeCode);
        String accessToken = this.customizedTokenService.getAgentAccessToken(corpId);
        if (StringUtils.isBlank((CharSequence)accessToken)) {
            log.warn("\u4f01\u4e1a\u672a\u6388\u6743\u4ee3\u5f00\u53d1\u81ea\u5efa\u5e94\u7528");
            return false;
        }
        try {
            log.info("\u53d1\u9001\u6b22\u8fce\u8bed params: {}", (Object)params);
            this.massMsgPushApi.sendWelcomeMsg(accessToken, params);
            return true;
        }
        catch (Exception e) {
            log.error("\u53d1\u9001\u6b22\u8fce\u8bed\u5931\u8d25", (Throwable)e);
            return false;
        }
    }

    private Map<String, String> getModel(String format) {
        ReplyContext ctx = ReplyContextUtil.get();
        HashMap<String, String> model = new HashMap<String, String>();
        if (format.contains(NICKNAME)) {
            WeworkContact contact = this.weworkContactMapper.queryWeworkContact(ctx.getBizId(), ctx.getCorpId(), ctx.getContactId());
            if (contact != null) {
                model.put(NICKNAME, contact.getName());
            } else {
                model.put(NICKNAME, "");
            }
        }
        return model;
    }

    private String render(String template, Map<String, String> model) {
        log.info("Render text content with template={}, model={}", (Object)template, model);
        String comment = template;
        Set<Map.Entry<String, String>> entries = model.entrySet();
        for (Map.Entry<String, String> e : entries) {
            String k = e.getKey();
            String v = e.getValue();
            String value = v == null ? "" : v;
            comment = WelcomeServiceImpl.replace(comment, k, value);
        }
        return comment;
    }

    private static String replace(String source, String placeHolder, String target) {
        if (StringUtils.isEmpty((CharSequence)source)) {
            return source;
        }
        if (StringUtils.isEmpty((CharSequence)placeHolder)) {
            return source;
        }
        if (placeHolder.equals(target)) {
            return source;
        }
        while (source.contains(placeHolder)) {
            source = source.replace(placeHolder, target);
        }
        return source;
    }

    private WelcomeMsg buildWelcomeMsg(Welcome welcome) {
        WelcomeMsg params = new WelcomeMsg();
        String welcomeText = welcome.getText();
        if (StringUtils.isNotBlank((CharSequence)welcomeText)) {
            Map<String, String> model = this.getModel(welcomeText);
            welcomeText = this.render(welcomeText, model);
            Text text = new Text();
            text.setContent(welcomeText);
            params.setText(text);
        }
        if (CollectionUtils.isNotEmpty(welcome.getAttachments())) {
            ArrayList list = Lists.newArrayList();
            int size = 0;
            for (AttachmentDto attachmentDto : welcome.getAttachments()) {
                String msgType = attachmentDto.getMsgType();
                Attachment media = this.newAttachment(msgType, attachmentDto);
                if (media == null) continue;
                list.add(media);
                if (++size < 9) continue;
                break;
            }
            params.setAttachments((List)list);
        }
        return params;
    }

    private Welcome getWelcome() {
        Welcome welcome = this.friendFissionService.getWelcome();
        if (welcome == null) {
            welcome = this.getMarketingWelcome();
        }
        if (welcome == null) {
            welcome = this.handleTelAddFriendEventService.getWelcome();
        }
        if (welcome == null) {
            welcome = this.getAddFriendWelcome();
        }
        if (welcome == null) {
            welcome = this.getAdQrcodeWelcome();
        }
        return welcome;
    }

    private Welcome getAddFriendWelcome() {
        String configJson;
        ReplyContext ctx = ReplyContextUtil.get();
        String corpId = ctx.getCorpId();
        String weworkUserId = ctx.getWeworkUserId();
        String weworkUserNum = ctx.getWeworkUserNum();
        String state = ctx.getState();
        AddFriendConfig config = this.addFriendConfigMapper.getByWeworkUser(corpId, weworkUserNum);
        if (config == null) {
            log.info("{} \u6ca1\u6709\u53ef\u7528\u7684\u65b0\u597d\u53cb\u6b22\u8fce\u8bed\u914d\u7f6e", (Object)weworkUserId);
            return null;
        }
        if (config.getWelcomeIsEnabled() == 0) {
            log.info("{} \u7684\u65b0\u597d\u53cb\u6b22\u8fce\u8bed\u529f\u80fd\u5df2\u5173\u95ed", (Object)weworkUserId);
            return null;
        }
        if (config.getWelcomeIsSpecified() == 1) {
            if (!config.getQrcodeState().equals(state) && config.getWelcomeUseOther() == 0) {
                log.info("{} \u7684\u597d\u53cb\u4e0d\u662f\u901a\u8fc7\u4e13\u5c5e\u4e8c\u7ef4\u7801\u6dfb\u52a0\u7684\u800c\u4e14\u672a\u5f00\u542f\u975e\u4f01\u5fae\u4e8c\u7ef4\u7801\u6765\u6e90\u53d1\u6b22\u8fce\u8bed\uff0c\u4e0d\u56de\u590d\u6b22\u8fce\u8bed", (Object)weworkUserId);
                return null;
            }
        } else if (StringUtils.isNotEmpty((CharSequence)state) || config.getWelcomeUseOther() == 0) {
            log.info("{} \u800c\u4e14\u672a\u5f00\u542f\u975e\u4f01\u5fae\u4e8c\u7ef4\u7801\u6765\u6e90\u53d1\u6b22\u8fce\u8bed\uff0c\u4e0d\u56de\u590d\u6b22\u8fce\u8bed", (Object)weworkUserId);
            return null;
        }
        if (StringUtils.isBlank((CharSequence)(configJson = config.getWelcomeJson()))) {
            log.info("{} \u672a\u914d\u7f6e\u6b22\u8fce\u8bed, configId:{}", (Object)weworkUserId, (Object)config.getId());
            return null;
        }
        WelcomeDto dto = null;
        try {
            dto = (WelcomeDto)JacksonUtil.str2Obj((String)configJson, WelcomeDto.class);
        }
        catch (IOException e) {
            log.info("\u89e3\u6790\u597d\u53cb\u6b22\u8fce\u8bed\u5931\u8d25, json:{}", (Object)configJson, (Object)e);
            return null;
        }
        if (dto == null) {
            log.info("{} \u672a\u914d\u7f6e\u6b22\u8fce\u8bed, configId:{}", (Object)weworkUserId, (Object)config.getId());
            return null;
        }
        if (StringUtils.isBlank((CharSequence)dto.getText()) && CollectionUtils.isEmpty((Collection)dto.getAttachments())) {
            log.info("{} \u672a\u914d\u7f6e\u6b22\u8fce\u8bed, configId:{}", (Object)weworkUserId);
            return null;
        }
        Welcome result = new Welcome();
        result.setText(dto.getText());
        result.setAttachments(dto.getAttachments());
        return result;
    }

    private Welcome getMarketingWelcome() {
        ReplyContext ctx = ReplyContextUtil.get();
        Long bizId = ctx.getBizId();
        String corpId = ctx.getCorpId();
        Long planId = ctx.getPlanId();
        if (planId == null) {
            log.warn("\u6d3b\u7801\u4e0d\u5b58\u5728\u6216\u5df2\u5220\u9664");
            return null;
        }
        if (!ctx.isPlanActive()) {
            log.warn("\u6d3b\u7801\u5f53\u524d\u672a\u751f\u6548, planId:{}, planGroupId:{}", (Object)planId);
            return null;
        }
        MarketingConfig config = this.marketingConfigService.getMarketingPlanConfig(bizId, corpId, planId, Integer.valueOf(MarketingConfigType.FRIEND_WELCOME.getValue()));
        if (config == null) {
            log.info("\u6d3b\u7801\u672a\u914d\u7f6e\u6b22\u8fce\u8bed, planId:{}", (Object)planId);
            return null;
        }
        String configJson = config.getConfigJson();
        if (StringUtils.isBlank((CharSequence)configJson)) {
            log.info("\u6d3b\u7801\u672a\u914d\u7f6e\u6b22\u8fce\u8bed, planId:{}, marketingConfigId:{}", (Object)planId, (Object)config.getId());
            return null;
        }
        FriendWelcomeDto dto = null;
        try {
            dto = (FriendWelcomeDto)JacksonUtil.str2Obj((String)configJson, FriendWelcomeDto.class);
        }
        catch (IOException e) {
            log.info("\u89e3\u6790\u597d\u53cb\u6b22\u8fce\u8bed\u5931\u8d25, json:{}", (Object)configJson, (Object)e);
            return null;
        }
        if (dto == null) {
            log.info("\u6d3b\u7801\u672a\u914d\u7f6e\u6b22\u8fce\u8bed, planId:{}, configId:{}", (Object)planId, (Object)config.getId());
            return null;
        }
        if (StringUtils.isBlank((CharSequence)dto.getText()) && CollectionUtils.isEmpty((Collection)dto.getAttachments())) {
            log.info("\u6d3b\u7801\u672a\u914d\u7f6e\u6b22\u8fce\u8bed\u56de\u590d\u5185\u5bb9, planId:{}, configId:{}", (Object)planId, (Object)config.getId());
            return null;
        }
        Welcome result = new Welcome();
        result.setText(dto.getText());
        result.setAttachments(dto.getAttachments());
        return result;
    }

    private Welcome getAdQrcodeWelcome() {
        ReplyContext ctx = ReplyContextUtil.get();
        String corpId = ctx.getCorpId();
        String state = ctx.getState();
        if (!ctx.isAdQrcode()) {
            return null;
        }
        QyQrcodeSubTask subTask = new QyQrcodeSubTask();
        subTask.setCorpId(corpId);
        subTask.setState(state);
        subTask = (QyQrcodeSubTask)this.qyQrcodeSubTaskMapper.selectOne((Object)subTask);
        if (subTask == null || subTask.getIsDeleted() == 1) {
            log.info("get ad qrcode welcome subtask is null or deleted, state: {}", (Object)state);
            return null;
        }
        String welcomeStr = subTask.getWelcomeJson();
        if (StringUtils.isBlank((CharSequence)welcomeStr)) {
            log.info("get ad qrcode welcome welcome is null, state: {}", (Object)state);
            return null;
        }
        Welcome welcome = null;
        try {
            welcome = (Welcome)JacksonUtil.str2Obj((String)welcomeStr, Welcome.class);
        }
        catch (Exception e) {
            log.error("\u89e3\u6790\u4f01\u5fae\u540d\u7247\u6b22\u8fce\u8bed\u56de\u590d error: ", (Throwable)e);
        }
        if (welcome == null) {
            return null;
        }
        if (StringUtils.isBlank((CharSequence)welcome.getText()) && CollectionUtils.isEmpty(welcome.getAttachments())) {
            log.info("\u4f01\u5fae\u540d\u7247\u672a\u914d\u7f6e\u6b22\u8fce\u8bed\u56de\u590d\u5185\u5bb9, state:{}", (Object)state);
            return null;
        }
        List<AttachmentDto> attachmentDtos = welcome.getAttachments();
        if (CollectionUtils.isNotEmpty(attachmentDtos)) {
            for (AttachmentDto attachmentDto : attachmentDtos) {
                if (!attachmentDto.getMsgType().equals("image")) continue;
                String mediaId = this.materialManagerService.getMediaId(ctx.getBizId(), ctx.getCorpId(), attachmentDto.getUrl(), "image");
                attachmentDto.setImageMediaId(mediaId);
            }
        }
        return welcome;
    }

    private Attachment newAttachment(String msgType, AttachmentDto attachmentDto) {
        ReplyContext ctx = ReplyContextUtil.get();
        Long bizId = ctx.getBizId();
        String corpId = ctx.getCorpId();
        Attachment attachment = new Attachment();
        attachment.setMsgType(msgType);
        if ("image".equals(msgType)) {
            Image image = new Image();
            String mediaId = attachmentDto.getImageMediaId();
            if (StringUtils.isNotBlank((CharSequence)mediaId)) {
                image.setMediaId(mediaId);
            }
            image.setPicUrl(attachmentDto.getUrl());
            attachment.setImage(image);
        } else if ("link".equals(msgType)) {
            Link link = new Link();
            link.setTitle(attachmentDto.getTitle());
            link.setDesc(attachmentDto.getDesc());
            link.setPicUrl(attachmentDto.getPicUrl());
            link.setUrl(attachmentDto.getUrl());
            attachment.setLink(link);
        } else if ("video".equals(msgType)) {
            String mediaId = this.materialManagerService.getMediaId(bizId, corpId, attachmentDto.getUrl(), "video");
            if (StringUtils.isBlank((CharSequence)mediaId)) {
                return null;
            }
            Video video = new Video();
            video.setMediaId(mediaId);
            attachment.setVideo(video);
        } else if ("miniprogram".equals(msgType)) {
            String picMediaId = this.materialManagerService.getMediaId(bizId, corpId, attachmentDto.getPicUrl(), "image");
            if (StringUtils.isBlank((CharSequence)picMediaId)) {
                return null;
            }
            MiniProgram miniProgram = new MiniProgram();
            miniProgram.setAppId(attachmentDto.getAppId());
            miniProgram.setPage(attachmentDto.getPage());
            miniProgram.setTitle(attachmentDto.getTitle());
            miniProgram.setPicMediaId(picMediaId);
            attachment.setMiniProgram(miniProgram);
        }
        return attachment;
    }
}

