/*
 * Decompiled with CFR 0.152.
 */
package com.kuaike.scrm.event.service.impl;

import com.kuaike.scrm.common.enums.MarketingConfigType;
import com.kuaike.scrm.dal.addFriend.entity.AddFriendConfig;
import com.kuaike.scrm.dal.addFriend.mapper.AddFriendConfigMapper;
import com.kuaike.scrm.dal.marketing.entity.MarketingConfig;
import com.kuaike.scrm.dal.wework.entity.WeworkContact;
import com.kuaike.scrm.dal.wework.mapper.WeworkContactMapper;
import com.kuaike.scrm.event.context.ReplyContext;
import com.kuaike.scrm.event.context.ReplyContextUtil;
import com.kuaike.scrm.event.service.FriendFissionService;
import com.kuaike.scrm.event.service.HandleTelAddFriendEventService;
import com.kuaike.scrm.event.service.RemarkService;
import com.kuaike.scrm.marketing.service.MarketingConfigService;
import com.kuaike.scrm.wework.contact.dto.ModifyRemarkDto;
import com.kuaike.scrm.wework.contact.service.ContactOpService;
import java.text.SimpleDateFormat;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class RemarkServiceImpl
implements RemarkService {
    private static final Logger log = LoggerFactory.getLogger(RemarkServiceImpl.class);
    public static final String NICKNAME = "${nickname}";
    public static final String DATE = "${date}";
    private final SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
    @Autowired
    private WeworkContactMapper weworkContactMapper;
    @Autowired
    private AddFriendConfigMapper addFriendConfigMapper;
    @Autowired
    private MarketingConfigService marketingConfigService;
    @Autowired
    private ContactOpService contactOpService;
    @Autowired
    private FriendFissionService friendFissionService;
    @Autowired
    private HandleTelAddFriendEventService handleTelAddFriendEventService;

    @Override
    public boolean onAddExternalContact() {
        ReplyContext ctx = ReplyContextUtil.get();
        Long bizId = ctx.getBizId();
        String corpId = ctx.getCorpId();
        String weworkUserId = ctx.getWeworkUserId();
        String contactId = ctx.getContactId();
        log.info("Auto remark on add external contact");
        String format = this.getFormat();
        if (StringUtils.isBlank((CharSequence)format)) {
            log.info("remark format is empty");
            return false;
        }
        Map<String, String> model = this.getModel(format);
        String remark = this.render(format, model);
        if (ctx.isTelAddFriend()) {
            this.handleTelAddFriendEventService.saveRemark(remark);
        }
        log.info("\u4e3a\u597d\u53cb {} \u751f\u6210\u5907\u6ce8\u5b57\u7b26\u4e32: {}", (Object)contactId, (Object)format);
        ModifyRemarkDto modifyRemarkDto = new ModifyRemarkDto();
        modifyRemarkDto.setBizId(bizId);
        modifyRemarkDto.setCorpId(corpId);
        modifyRemarkDto.setWeworkUserId(weworkUserId);
        modifyRemarkDto.setContactId(contactId);
        modifyRemarkDto.setRemark(remark);
        try {
            this.contactOpService.modifyRemark(modifyRemarkDto);
            return true;
        }
        catch (Exception e) {
            log.error("\u5907\u6ce8\u64cd\u4f5c\u5931\u8d25", (Throwable)e);
            return false;
        }
    }

    private Map<String, String> getModel(String format) {
        ReplyContext ctx = ReplyContextUtil.get();
        HashMap<String, String> model = new HashMap<String, String>();
        if (format.contains(DATE)) {
            String date = this.sdf.format(ctx.getTimestamp());
            model.put(DATE, date);
        }
        if (format.contains(NICKNAME)) {
            WeworkContact contact = this.weworkContactMapper.queryWeworkContact(ctx.getBizId(), ctx.getCorpId(), ctx.getContactId());
            if (contact != null) {
                model.put(NICKNAME, contact.getName());
            } else {
                model.put(NICKNAME, "");
            }
        }
        return model;
    }

    private String render(String template, Map<String, String> model) {
        log.info("Render comment with template={}, model={}", (Object)template, model);
        String comment = template;
        Set<Map.Entry<String, String>> entries = model.entrySet();
        for (Map.Entry<String, String> e : entries) {
            String k = e.getKey();
            String v = e.getValue();
            String value = v == null ? "" : v;
            comment = RemarkServiceImpl.replace(comment, k, value);
        }
        return comment;
    }

    private static String replace(String source, String placeHolder, String target) {
        if (StringUtils.isEmpty((CharSequence)source)) {
            return source;
        }
        if (StringUtils.isEmpty((CharSequence)placeHolder)) {
            return source;
        }
        if (placeHolder.equals(target)) {
            return source;
        }
        while (source.contains(placeHolder)) {
            source = source.replace(placeHolder, target);
        }
        return source;
    }

    private String getFormat() {
        String format = this.friendFissionService.getRemarkFormat();
        if (StringUtils.isBlank((CharSequence)format)) {
            format = this.getMarketingRemark();
        }
        if (StringUtils.isEmpty((CharSequence)format)) {
            format = this.handleTelAddFriendEventService.getRemark();
        }
        if (StringUtils.isBlank((CharSequence)format)) {
            format = this.getAddFriendRemark();
        }
        return format;
    }

    private String getAddFriendRemark() {
        ReplyContext ctx = ReplyContextUtil.get();
        String corpId = ctx.getCorpId();
        String weworkUserId = ctx.getWeworkUserId();
        String weworkUserNum = ctx.getWeworkUserNum();
        String state = ctx.getState();
        AddFriendConfig config = this.addFriendConfigMapper.getByWeworkUser(corpId, weworkUserNum);
        if (config == null) {
            log.info("{} \u6ca1\u6709\u53ef\u7528\u7684\u597d\u53cb\u81ea\u52a8\u5907\u6ce8\u914d\u7f6e\u4fe1\u606f", (Object)weworkUserId);
            return null;
        }
        if (StringUtils.isBlank((CharSequence)config.getRemarkFormat())) {
            log.info("{} \u6ca1\u6709\u53ef\u7528\u7684\u597d\u53cb\u81ea\u52a8\u5907\u6ce8\u914d\u7f6e\u4fe1\u606f, config={}", (Object)weworkUserId, (Object)config);
            return null;
        }
        if (config.getRemarkIsEnabled() == 0) {
            log.info("{} \u7684\u597d\u53cb\u81ea\u52a8\u5907\u6ce8\u914d\u7f6e\u529f\u80fd\u5df2\u7981\u7528, config={}", (Object)weworkUserId, (Object)config);
            return null;
        }
        if (config.getRemarkIsSpecified() == 1) {
            if (!config.getQrcodeState().equals(state) && config.getRemarkUseOther() == 0) {
                log.info("{} \u7684\u597d\u53cb\u4e0d\u662f\u901a\u8fc7\u4e13\u5c5e\u4e8c\u7ef4\u7801\u6dfb\u52a0\u7684\u800c\u4e14\u672a\u5f00\u542f\u975e\u4f01\u5fae\u4e8c\u7ef4\u7801\u6765\u6e90\u5907\u6ce8\uff0c\u4e0d\u6267\u884c\u81ea\u52a8\u5907\u6ce8, config={}", (Object)weworkUserId, (Object)config);
                return null;
            }
        } else if (StringUtils.isNotEmpty((CharSequence)state) || config.getRemarkUseOther() == 0) {
            log.info("{} \u800c\u4e14\u672a\u5f00\u542f\u975e\u4f01\u5fae\u4e8c\u7ef4\u7801\u6765\u6e90\u5907\u6ce8\uff0c\u4e0d\u6267\u884c\u81ea\u52a8\u5907\u6ce8, config={}", (Object)weworkUserId, (Object)config);
            return null;
        }
        return config.getRemarkFormat();
    }

    private String getMarketingRemark() {
        ReplyContext ctx = ReplyContextUtil.get();
        Long bizId = ctx.getBizId();
        String corpId = ctx.getCorpId();
        Long planId = ctx.getPlanId();
        if (!ctx.isPlanActive() || planId == null) {
            return null;
        }
        MarketingConfig marketingConfig = this.marketingConfigService.getMarketingPlanConfig(bizId, corpId, planId, Integer.valueOf(MarketingConfigType.AUTO_REMARK.getValue()));
        if (marketingConfig == null) {
            log.info("remark marketing config is null");
            return null;
        }
        String remarkConfig = marketingConfig.getConfigJson();
        if (StringUtils.isBlank((CharSequence)remarkConfig)) {
            log.warn("remark config is empty, config: {}", (Object)marketingConfig);
            return null;
        }
        return remarkConfig;
    }
}

