/*
 * Decompiled with CFR 0.152.
 */
package com.kuaike.scrm.event.service.impl;

import com.google.common.collect.Lists;
import com.kuaike.common.utils.JacksonUtil;
import com.kuaike.scrm.common.dto.AttachmentDto;
import com.kuaike.scrm.common.enums.FriendFissionRestBonus;
import com.kuaike.scrm.common.enums.FriendFissionTagRule;
import com.kuaike.scrm.common.enums.MarketingConfigType;
import com.kuaike.scrm.common.enums.PlanType;
import com.kuaike.scrm.common.utils.TemplateReplaceUtil;
import com.kuaike.scrm.dal.contactAnalyse.mapper.WeworkContactLogMapper;
import com.kuaike.scrm.dal.marketing.entity.MarketingAddFriendLog;
import com.kuaike.scrm.dal.marketing.entity.MarketingChannel;
import com.kuaike.scrm.dal.marketing.entity.MarketingConfig;
import com.kuaike.scrm.dal.marketing.entity.MarketingJoin;
import com.kuaike.scrm.dal.marketing.entity.MarketingPlan;
import com.kuaike.scrm.dal.marketing.entity.MarketingReward;
import com.kuaike.scrm.dal.marketing.entity.MarketingRewardStage;
import com.kuaike.scrm.dal.marketing.entity.MarketingTagRuleLog;
import com.kuaike.scrm.dal.marketing.mapper.MarketingAddFriendLogMapper;
import com.kuaike.scrm.dal.marketing.mapper.MarketingChannelMapper;
import com.kuaike.scrm.dal.marketing.mapper.MarketingJoinMapper;
import com.kuaike.scrm.dal.marketing.mapper.MarketingPlanMapper;
import com.kuaike.scrm.dal.marketing.mapper.MarketingRewardMapper;
import com.kuaike.scrm.dal.marketing.mapper.MarketingRewardStageMapper;
import com.kuaike.scrm.dal.marketing.mapper.MarketingTagRuleItemMapper;
import com.kuaike.scrm.dal.marketing.mapper.MarketingTagRuleLogMapper;
import com.kuaike.scrm.dal.wework.entity.WeworkContact;
import com.kuaike.scrm.dal.wework.mapper.WeworkContactMapper;
import com.kuaike.scrm.dal.wework.mapper.WeworkUserMapper;
import com.kuaike.scrm.dal.weworkTag.mapper.WeworkTagMapper;
import com.kuaike.scrm.event.context.ReplyContext;
import com.kuaike.scrm.event.context.ReplyContextUtil;
import com.kuaike.scrm.event.service.FriendFissionService;
import com.kuaike.scrm.event.service.dto.Welcome;
import com.kuaike.scrm.event.utils.MsgLock;
import com.kuaike.scrm.friendFission.dto.BillboardResultDto;
import com.kuaike.scrm.friendFission.dto.CreateBillboardReqDto;
import com.kuaike.scrm.friendFission.dto.FissionBillboardDto;
import com.kuaike.scrm.friendFission.dto.FissionSwitchDto;
import com.kuaike.scrm.friendFission.service.FissionPlanService;
import com.kuaike.scrm.marketing.dto.FriendWelcomeDto;
import com.kuaike.scrm.marketing.service.MarketingConfigService;
import com.kuaike.scrm.material.service.MaterialManagerService;
import com.kuaike.scrm.remind.service.RemindService;
import com.kuaike.scrm.wework.contact.dto.ModifyTagDto;
import com.kuaike.scrm.wework.contact.service.ContactOpService;
import java.io.IOException;
import java.text.MessageFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.math.NumberUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

@Service
public class FriendFissionServiceImpl
implements FriendFissionService {
    private static final Logger log = LoggerFactory.getLogger(FriendFissionServiceImpl.class);
    public static final String NICKNAME = "${nickname}";
    public static final String DATE = "${date}";
    public static final String INVITE_NAME = "${inviteName}";
    @Value(value="${friend-fission.h5.title}")
    private String h5Title;
    @Value(value="${friend-fission.h5.desc}")
    private String desc;
    @Value(value="${friend-fission.h5.picUrl}")
    private String picUrl;
    private final SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
    private final String lockKey = "fission:markTag";
    private final long lockTime = 1L;
    @Autowired
    private WeworkContactMapper weworkContactMapper;
    @Autowired
    private WeworkUserMapper weworkUserMapper;
    @Autowired
    private MarketingConfigService marketingConfigService;
    @Autowired
    private MarketingPlanMapper marketingPlanMapper;
    @Autowired
    private MarketingAddFriendLogMapper addFriendLogMapper;
    @Autowired
    private MarketingTagRuleItemMapper tagRuleItemMapper;
    @Autowired
    private MarketingJoinMapper joinMapper;
    @Autowired
    private MarketingRewardMapper rewardMapper;
    @Autowired
    private MarketingChannelMapper marketingChannelMapper;
    @Autowired
    private WeworkContactLogMapper contactLogMapper;
    @Autowired
    private RemindService remindService;
    @Autowired
    private ContactOpService contactOpService;
    @Autowired
    private FissionPlanService fissionPlanService;
    @Autowired
    private MaterialManagerService materialManagerService;
    @Autowired
    private MarketingTagRuleLogMapper tagRuleLogMapper;
    @Autowired
    private WeworkTagMapper weworkTagMapper;
    @Autowired
    private MarketingRewardStageMapper rewardStageMapper;
    @Autowired
    private MsgLock msgLock;

    @Override
    public Welcome getWelcome() {
        ReplyContext ctx = ReplyContextUtil.get();
        Long bizId = ctx.getBizId();
        String corpId = ctx.getCorpId();
        Long planId = ctx.getPlanId();
        Integer planType = ctx.getPlanType();
        if (planId == null) {
            log.info("getWelcome: \u6d3b\u7801\u4e0d\u5b58\u5728\u6216\u5df2\u5220\u9664");
            return null;
        }
        if (Objects.isNull(planType) || planType.intValue() != PlanType.FRIEND_FISSION_PLAN.getValue()) {
            log.info("getWelcome: \u5f53\u524d\u975e\u597d\u53cb\u88c2\u53d8, planId:{}", (Object)planId);
            return null;
        }
        if (ctx.getIsFissionDraft() == 1 || ctx.getIsFissionDeleted() == 1) {
            log.info("getWelcome: \u6d3b\u7801\u5f53\u524d\u672a\u751f\u6548, planId:{}", (Object)planId);
            return null;
        }
        Integer type = this.getReplyType();
        MarketingConfig config = this.marketingConfigService.getMarketingPlanConfig(bizId, corpId, planId, type);
        if (Objects.isNull(config)) {
            log.info("getWelcome: \u6d3b\u7801\u672a\u914d\u7f6e\u6b22\u8fce\u8bed, planId:{}", (Object)planId);
            return null;
        }
        String configJson = config.getConfigJson();
        if (StringUtils.isBlank((CharSequence)configJson)) {
            log.info("getWelcome: \u6d3b\u7801\u672a\u914d\u7f6e\u6b22\u8fce\u8bed, planId:{}, marketingConfigId:{}", (Object)planId, (Object)config.getId());
            return null;
        }
        FriendWelcomeDto welcomeDto = null;
        try {
            welcomeDto = (FriendWelcomeDto)JacksonUtil.str2Obj((String)configJson, FriendWelcomeDto.class);
        }
        catch (IOException e) {
            log.info("getWelcome: \u89e3\u6790\u597d\u53cb\u6b22\u8fce\u8bed\u5931\u8d25, json:{}", (Object)configJson, (Object)e);
            return null;
        }
        if (welcomeDto == null) {
            log.info("getWelcome: \u6d3b\u7801\u672a\u914d\u7f6e\u6b22\u8fce\u8bed, planId:{}, configId:{}", (Object)planId, (Object)config.getId());
            return null;
        }
        List attachmentDtos = welcomeDto.getAttachments();
        if (StringUtils.isBlank((CharSequence)welcomeDto.getText()) && CollectionUtils.isEmpty((Collection)attachmentDtos)) {
            log.info("getWelcome: \u6d3b\u7801\u672a\u914d\u7f6e\u6b22\u8fce\u8bed\u56de\u590d\u5185\u5bb9, planId:{}, configId:{}", (Object)planId, (Object)config.getId());
            return null;
        }
        ArrayList dtoList = Lists.newArrayList();
        if (CollectionUtils.isNotEmpty((Collection)attachmentDtos)) {
            for (AttachmentDto dto : attachmentDtos) {
                AttachmentDto imageDto;
                if (!"image".equals(dto.getMsgType()) || !Objects.nonNull(imageDto = this.newImage(dto.getUrl()))) continue;
                dtoList.add(imageDto);
            }
        }
        if (!ctx.isFissionEnd() && ctx.getIsFissionEnabled() == 1) {
            AttachmentDto billboardDto;
            AttachmentDto linkDto = this.newLink(planId);
            if (Objects.nonNull(linkDto)) {
                dtoList.add(linkDto);
            }
            if (Objects.nonNull(billboardDto = this.newBillboard())) {
                dtoList.add(billboardDto);
            }
        }
        Welcome result = new Welcome();
        if (StringUtils.isNotBlank((CharSequence)welcomeDto.getText())) {
            Map<String, String> model = this.getModel(welcomeDto.getText());
            String text = TemplateReplaceUtil.render((String)welcomeDto.getText(), model);
            log.info("getWelcome: \u6b22\u8fce\u8bed\uff1a{}, planId:{}", (Object)text, (Object)planId);
            result.setText(text);
        }
        result.setAttachments(dtoList);
        return result;
    }

    private AttachmentDto newImage(String url) {
        ReplyContext ctx = ReplyContextUtil.get();
        String mediaId = this.materialManagerService.getMediaId(ctx.getBizId(), ctx.getCorpId(), url, "image");
        if (StringUtils.isBlank((CharSequence)mediaId)) {
            log.info("newImage: mediaId is null, url: {}, ctx:{}", (Object)url, (Object)ctx);
            return null;
        }
        AttachmentDto imageDto = new AttachmentDto();
        imageDto.setMsgType("image");
        imageDto.setImageMediaId(mediaId);
        imageDto.setUrl(url);
        return imageDto;
    }

    private AttachmentDto newLink(Long planId) {
        MarketingChannel marketingChannel = this.marketingChannelMapper.selectByPlanIdAndChannelId(planId, NumberUtils.LONG_MINUS_ONE);
        String url = marketingChannel.getUrl();
        if (StringUtils.isBlank((CharSequence)url)) {
            log.info("newLink: \u94fe\u63a5url\u4e3a\u7a7a, planId:{}", (Object)planId);
            return null;
        }
        AttachmentDto linkDto = new AttachmentDto();
        linkDto.setMsgType("link");
        linkDto.setUrl(url);
        linkDto.setPicUrl(this.picUrl);
        linkDto.setTitle(this.h5Title);
        linkDto.setDesc(this.desc);
        return linkDto;
    }

    private AttachmentDto newBillboard() {
        BillboardResultDto billboardResultDto;
        List billboardDtos;
        ReplyContext ctx = ReplyContextUtil.get();
        String corpId = ctx.getCorpId();
        Long planId = ctx.getPlanId();
        String contactId = ctx.getContactId();
        Long channelId = ctx.getChannelId();
        String weworkUserNum = ctx.getWeworkUserNum();
        boolean isFissionSuccess = ctx.isFissionSuccess();
        Date addTime = ctx.getTimestamp();
        boolean isNewCustomer = ctx.isNewCustomer();
        String pContactId = ctx.getPContactId();
        String bgResultUrl = this.joinMapper.selectBgResultUrlByCorpIdPlanIdAndContactId(corpId, planId, contactId);
        if (StringUtils.isNotBlank((CharSequence)bgResultUrl)) {
            String mediaId = this.materialManagerService.getMediaId(ctx.getBizId(), corpId, bgResultUrl, "image");
            log.info("newBillboard: \u5df2\u7ecf\u6709\u6d77\u62a5, bgResultUrl:{}, mediaId:{}, planId:{}", new Object[]{bgResultUrl, mediaId, planId});
            if (StringUtils.isNotBlank((CharSequence)mediaId)) {
                return this.newBillboard(bgResultUrl, mediaId);
            }
        }
        if (CollectionUtils.isEmpty((Collection)(billboardDtos = this.marketingConfigService.getBillboardConfig(corpId, planId)))) {
            log.info("newBillboard: \u672a\u914d\u7f6e\u6d77\u62a5, planId:{}", (Object)planId);
            return null;
        }
        Collections.shuffle(billboardDtos);
        FissionBillboardDto fissionBillboardDto = (FissionBillboardDto)billboardDtos.get(0);
        MarketingPlan marketingPlan = (MarketingPlan)this.marketingPlanMapper.selectByPrimaryKey((Object)ctx.getPlanId());
        CreateBillboardReqDto createBillboardReqDto = new CreateBillboardReqDto();
        createBillboardReqDto.setModel(Integer.valueOf(3));
        createBillboardReqDto.setFissionBillboardDto(fissionBillboardDto);
        createBillboardReqDto.setChannelId(channelId);
        createBillboardReqDto.setWeworkUserNum(weworkUserNum);
        createBillboardReqDto.setContactId(contactId);
        createBillboardReqDto.setMarketingPlan(marketingPlan);
        createBillboardReqDto.setAssistantSuccess(isFissionSuccess);
        createBillboardReqDto.setAddFriendTime(addTime);
        createBillboardReqDto.setIsNewCustomer(Integer.valueOf(isNewCustomer ? 1 : 0));
        createBillboardReqDto.setPContactId(pContactId);
        try {
            billboardResultDto = this.fissionPlanService.createBillboard(createBillboardReqDto);
            log.info("newBillboard: \u751f\u6210\u6d77\u62a5\uff1a{}, planId:{}", (Object)billboardResultDto, (Object)planId);
        }
        catch (Exception ex) {
            log.info("newBillboard: billboardResultDto:{}\u751f\u6210\u4e13\u5c5e\u6d77\u62a5\u5931\u8d25:", (Object)createBillboardReqDto, (Object)ex);
            return null;
        }
        if (Objects.nonNull(billboardResultDto) && StringUtils.isNotBlank((CharSequence)billboardResultDto.getPicUrl()) && StringUtils.isNotBlank((CharSequence)billboardResultDto.getMediaId())) {
            return this.newBillboard(billboardResultDto.getPicUrl(), billboardResultDto.getMediaId());
        }
        return null;
    }

    private AttachmentDto newBillboard(String url, String mediaId) {
        AttachmentDto billboardDto = new AttachmentDto();
        billboardDto.setMsgType("image");
        billboardDto.setUrl(url);
        billboardDto.setImageMediaId(mediaId);
        return billboardDto;
    }

    private Map<String, String> getModel(String format) {
        WeworkContact contact;
        ReplyContext ctx = ReplyContextUtil.get();
        Long bizId = ctx.getBizId();
        String corpId = ctx.getCorpId();
        String contactId = ctx.getContactId();
        Long planId = ctx.getPlanId();
        String pContactId = ctx.getPContactId();
        HashMap<String, String> model = new HashMap<String, String>();
        if (format.contains(DATE)) {
            String date = this.sdf.format(ctx.getTimestamp());
            model.put(DATE, date);
        }
        if (format.contains(NICKNAME)) {
            contact = this.weworkContactMapper.queryWeworkContact(bizId, corpId, contactId);
            if (Objects.nonNull(contact)) {
                model.put(NICKNAME, contact.getName());
            } else {
                model.put(NICKNAME, "");
            }
        }
        if (format.contains(INVITE_NAME)) {
            if (Objects.nonNull(pContactId)) {
                contact = this.weworkContactMapper.queryWeworkContact(bizId, corpId, pContactId);
                if (Objects.nonNull(contact)) {
                    model.put(INVITE_NAME, contact.getName());
                } else {
                    model.put(INVITE_NAME, "");
                }
            } else {
                model.put(INVITE_NAME, "");
            }
        }
        Map rewardStageMap = this.rewardStageMapper.getStageRewardCountByPlanId(planId);
        Map receiveStageRewardCountMap = this.rewardMapper.getStageReceivedRewardCount(corpId, planId);
        Map restBonusMap = FriendFissionRestBonus.getCache();
        Set entries = restBonusMap.entrySet();
        for (Map.Entry e : entries) {
            int rewardCount;
            Integer key = (Integer)e.getKey();
            String value = (String)e.getValue();
            if (!format.contains(value)) continue;
            int n = rewardCount = rewardStageMap.get(key) == null ? 0 : (Integer)rewardStageMap.get(key);
            int receiveCount = receiveStageRewardCountMap == null ? 0 : (receiveStageRewardCountMap.get(key) == null ? 0 : (Integer)receiveStageRewardCountMap.get(key));
            int resetCount = Math.max(rewardCount - receiveCount, 0);
            model.put(value, String.valueOf(resetCount));
        }
        return model;
    }

    private Integer getReplyType() {
        ReplyContext ctx = ReplyContextUtil.get();
        String corpId = ctx.getCorpId();
        Long planId = ctx.getPlanId();
        String contactId = ctx.getContactId();
        boolean isNewCustomer = ctx.isNewCustomer();
        String pContactId = ctx.getPContactId();
        log.info("getReplyType: ctx:{}", (Object)ctx);
        if (ctx.isFissionEnd() || ctx.getIsFissionEnabled() == 0) {
            log.info("getReplyType: \u6d3b\u52a8\u5df2\u7ed3\u675f\u6216\u88ab\u7981\u7528\uff0cplanId:{}", (Object)planId);
            return MarketingConfigType.FINISH_REPLY.getValue();
        }
        if (Objects.isNull(pContactId) || pContactId.equals(contactId)) {
            log.info("getReplyType: \u53d1\u9001\u88c2\u53d8\u8bdd\u672f, planId:{}", (Object)planId);
            return MarketingConfigType.SPREAD_REPLY.getValue();
        }
        Integer successCount = this.addFriendLogMapper.queryHelpSuccessCount(corpId, planId, contactId);
        if (Objects.nonNull(successCount) && successCount > 0) {
            log.info("getReplyType: \u52a9\u529b\u6210\u529f\u8fc7\uff0c\u91cd\u590d\u52a9\u529b, planId:{}", (Object)planId);
            return MarketingConfigType.REPEAT_INVITE_REPLY.getValue();
        }
        boolean isNewCustomerOpen = this.isNewCustomerOpen(corpId, planId);
        log.info("getReplyType: \u65b0\u5ba2\u6237\u624d\u80fd\u52a9\u529b\u5f00\u5173\uff1a{}", (Object)isNewCustomerOpen);
        if (!isNewCustomerOpen) {
            log.info("getReplyType: \u52a9\u529b\u6210\u529f, \u88ab\u52a9\u529b\u597d\u53cb:{}, planId:{}", (Object)pContactId, (Object)planId);
            ctx.setFissionSuccess(true);
            return MarketingConfigType.SUCCESS_INVITE_REPLY.getValue();
        }
        if (isNewCustomer) {
            log.info("getReplyType: \u52a9\u529b\u6210\u529f, \u88ab\u52a9\u529b\u597d\u53cb:{}, planId:{}", (Object)pContactId, (Object)planId);
            ctx.setFissionSuccess(true);
            return MarketingConfigType.SUCCESS_INVITE_REPLY.getValue();
        }
        log.info("getReplyType: \u53d1\u9001\u65b0\u5ba2\u6237\u624d\u80fd\u52a9\u529b\u8bdd\u672f, planId:{}", (Object)planId);
        return MarketingConfigType.LIMIT_NEW_CUSTOMER_REPLY.getValue();
    }

    @Override
    public boolean isMarketingEndTime(MarketingPlan marketingPlan) {
        ReplyContext ctx = ReplyContextUtil.get();
        Long planId = ctx.getPlanId();
        if (Objects.nonNull(marketingPlan) && Objects.nonNull(marketingPlan.getEndTime()) && marketingPlan.getEndTime().before(new Date())) {
            log.info("isMarketingEnd: \u6d3b\u52a8\u5df2\u5230\u671f\uff0cplanId:{}", (Object)planId);
            return true;
        }
        return false;
    }

    @Override
    public boolean isMarketingNoReward() {
        Long planId;
        ReplyContext ctx = ReplyContextUtil.get();
        String corpId = ctx.getCorpId();
        List rewardStages = this.rewardStageMapper.getRewarrdStage(corpId, planId = ctx.getPlanId());
        if (CollectionUtils.isEmpty((Collection)rewardStages)) {
            log.warn("isMarketingNoReward: \u6d3b\u52a8\u67e5\u4e0d\u5230\u5956\u54c1\u603b\u6570\u8bb0\u5f55\uff1a{}", (Object)ctx);
            return false;
        }
        int remainCount = 0;
        Map stageCountMap = this.rewardMapper.getStageReceivedRewardCount(corpId, planId);
        for (MarketingRewardStage it : rewardStages) {
            int count = stageCountMap.getOrDefault(it.getStage(), 0);
            count = it.getRewardCount() - count;
            if (count <= 0) continue;
            remainCount += count;
        }
        boolean ret = remainCount == 0;
        log.info("isMarketingNoReward: \u6d3b\u52a8\u662f\u5426\u7ed3\u675f:{}, planId:{}", (Object)ret, (Object)planId);
        return ret;
    }

    @Override
    public String getRemarkFormat() {
        ReplyContext ctx = ReplyContextUtil.get();
        Long bizId = ctx.getBizId();
        String corpId = ctx.getCorpId();
        Long planId = ctx.getPlanId();
        Integer planType = ctx.getPlanType();
        if (planId == null) {
            log.info("getRemarkFormat\uff1a \u6d3b\u7801\u4e0d\u5b58\u5728\u6216\u5df2\u5220\u9664");
            return null;
        }
        if (Objects.isNull(planType) || planType.intValue() != PlanType.FRIEND_FISSION_PLAN.getValue()) {
            log.info("getRemarkFormat: \u5f53\u524d\u975e\u597d\u53cb\u88c2\u53d8, planId:{}", (Object)planId);
            return null;
        }
        if (!ctx.isPlanActive()) {
            log.info("getRemarkFormat\uff1a\u6d3b\u7801\u5f53\u524d\u672a\u751f\u6548, planId:{}", (Object)planId);
            return null;
        }
        MarketingConfig marketingConfig = this.marketingConfigService.getMarketingPlanConfig(bizId, corpId, planId, Integer.valueOf(MarketingConfigType.AUTO_REMARK.getValue()));
        if (marketingConfig == null) {
            log.info("getRemarkFormat: remark marketing config is null, planId:{}", (Object)planId);
            return null;
        }
        String remarkConfig = marketingConfig.getConfigJson();
        if (StringUtils.isBlank((CharSequence)remarkConfig)) {
            log.info("getRemarkFormat: remarkConfig is empty, planId: {}", (Object)planId);
            return null;
        }
        return remarkConfig;
    }

    @Override
    public List<String> getTags() {
        ReplyContext ctx = ReplyContextUtil.get();
        String corpId = ctx.getCorpId();
        Long planId = ctx.getPlanId();
        Integer planType = ctx.getPlanType();
        if (planId == null) {
            log.info("getTags: \u6d3b\u7801\u4e0d\u5b58\u5728\u6216\u5df2\u5220\u9664");
            return null;
        }
        if (Objects.isNull(planType) || planType.intValue() != PlanType.FRIEND_FISSION_PLAN.getValue()) {
            log.info("getTags: \u5f53\u524d\u975e\u597d\u53cb\u88c2\u53d8, planId:{}", (Object)planId);
            return null;
        }
        if (!ctx.isPlanActive()) {
            log.info("getTags: \u6d3b\u7801\u5f53\u524d\u672a\u751f\u6548, planId:{}", (Object)planId);
            return null;
        }
        boolean isAutoTagOpen = this.isAutoTagOpen(corpId, planId);
        if (!isAutoTagOpen) {
            log.info("getTags\uff1a\u81ea\u52a8\u6253\u6807\u7b7e\u5f00\u5173\u5df2\u5173\u95ed, planId:{}", (Object)planId);
            return null;
        }
        List ruleTagIds = this.tagRuleItemMapper.queryRuleTagsByType(corpId, planId, Integer.valueOf(FriendFissionTagRule.ALL.getValue()), ctx.getContactId());
        if (CollectionUtils.isEmpty((Collection)ruleTagIds)) {
            log.info("getTags: \u65e0\u6cd5\u67e5\u8be2\u5230\u6807\u7b7e, planId:{}", (Object)planId);
            return null;
        }
        if (CollectionUtils.isEmpty((Collection)(ruleTagIds = this.weworkTagMapper.filterIsDeletedTag(corpId, (Collection)ruleTagIds)))) {
            log.warn("getTags: {}\u6ca1\u6709\u53ef\u7528\u7684\u6807\u7b7e\u914d\u7f6e, planId:{}", (Object)ctx.getWeworkUserId(), (Object)planId);
            return null;
        }
        log.info("getTags: \u6ee1\u8db3\u6761\u4ef6\u7684\u6807\u7b7e\u5217\u8868\uff1a{}, ctx:{}", (Object)ruleTagIds, (Object)ctx);
        if (!this.msgLock.locked("fission:markTag", 1L)) {
            log.info("getTags: lock failed, planId:{}", (Object)planId);
            try {
                TimeUnit.SECONDS.sleep(1L);
            }
            catch (InterruptedException e) {
                log.error("getTags: \u7ebf\u7a0b\u4e2d\u65ad, e:{}", (Throwable)e);
                Thread.currentThread().interrupt();
            }
        }
        return ruleTagIds;
    }

    private boolean isAutoTagOpen(String corpId, Long planId) {
        FissionSwitchDto fissionSwitchDto = this.marketingConfigService.getSwitchConfig(corpId, planId);
        return Objects.nonNull(fissionSwitchDto) && Objects.nonNull(fissionSwitchDto.getEnableAttachTag()) && fissionSwitchDto.getEnableAttachTag().equals(NumberUtils.INTEGER_ONE);
    }

    private boolean isNewCustomerOpen(String corpId, Long planId) {
        FissionSwitchDto fissionSwitchDto = this.marketingConfigService.getSwitchConfig(corpId, planId);
        return Objects.nonNull(fissionSwitchDto) && Objects.nonNull(fissionSwitchDto.getIsLimitNewCustomer()) && fissionSwitchDto.getIsLimitNewCustomer().equals(NumberUtils.INTEGER_ONE);
    }

    @Override
    public boolean onDelFollowUser() {
        ReplyContext ctx = ReplyContextUtil.get();
        String corpId = ctx.getCorpId();
        String contactId = ctx.getContactId();
        String weworkUserNum = ctx.getWeworkUserNum();
        log.info("onDelFollowUser: ctx:{}", (Object)ctx);
        Long planId = this.contactLogMapper.queryPlanId(corpId, contactId, weworkUserNum);
        if (Objects.isNull(planId)) {
            log.info("onDelFollowUser: planId is null");
            return false;
        }
        log.info("onDelFollowUser: planId:{}", (Object)planId);
        FissionSwitchDto fissionSwitchDto = this.marketingConfigService.getSwitchConfig(corpId, planId);
        if (Objects.isNull(fissionSwitchDto)) {
            log.info("onDelFollowUser: fissionSwitchDto is null");
            return false;
        }
        Integer invalidOnDisfollow = fissionSwitchDto.getInvalidOnDisfollow();
        if (Objects.isNull(invalidOnDisfollow)) {
            log.info("onDelFollowUser: invalidOnDisfollow is null");
            return false;
        }
        if (invalidOnDisfollow.equals(NumberUtils.INTEGER_ONE)) {
            this.addFriendLogMapper.markHelpFailed(corpId, planId, contactId, weworkUserNum);
            MarketingJoin existJoin = this.joinMapper.selectByCorpIdPlanIdAndContactId(corpId, planId, contactId);
            log.info("onDelFollowUser: existJoin:{},planId:{}", (Object)existJoin, (Object)planId);
            if (Objects.nonNull(existJoin)) {
                MarketingJoin join = new MarketingJoin();
                join.setId(existJoin.getId());
                join.setIsDeleted(NumberUtils.INTEGER_ONE);
                join.setDeleteTime(new Date());
                this.joinMapper.updateByPrimaryKeySelective((Object)join);
                if (StringUtils.isNotBlank((CharSequence)existJoin.getPContactId())) {
                    MarketingJoin pContactJoin = this.joinMapper.selectByCorpIdPlanIdAndContactId(corpId, planId, existJoin.getPContactId());
                    log.info("onDelFollowUser: pContactJoin:{},planId:{}", (Object)pContactJoin, (Object)planId);
                    if (Objects.nonNull(pContactJoin) && pContactJoin.getAddCount() > 0) {
                        MarketingJoin pJoin = new MarketingJoin();
                        pJoin.setId(pContactJoin.getId());
                        pJoin.setAddCount(Integer.valueOf(pContactJoin.getAddCount() - 1));
                        pJoin.setUpdateTime(new Date());
                        this.joinMapper.updateByPrimaryKeySelective((Object)pJoin);
                    }
                }
            }
            return true;
        }
        return false;
    }

    @Override
    public void incrInviteCount() {
        ReplyContext ctx = ReplyContextUtil.get();
        if (ctx.getPlanId() == null) {
            return;
        }
        if (ctx.getPlanType() == null || ctx.getPlanType().intValue() != PlanType.FRIEND_FISSION_PLAN.getValue()) {
            return;
        }
        this.addFriendLog();
        if (!ctx.isPlanActive()) {
            return;
        }
        if (!ctx.isFissionSuccess() || StringUtils.isBlank((CharSequence)ctx.getPContactId())) {
            return;
        }
        MarketingJoin join = this.joinMapper.selectByCorpIdPlanIdAndContactId(ctx.getCorpId(), ctx.getPlanId(), ctx.getPContactId());
        if (join == null) {
            return;
        }
        boolean reachStage = this.tryReachStage(join);
        if (reachStage) {
            this.remindReachStage(join);
        }
        this.addTag(join);
    }

    @Override
    public void addTagLog(List<String> tagList, String contactId) {
        ReplyContext ctx = ReplyContextUtil.get();
        Long planId = ctx.getPlanId();
        Integer planType = ctx.getPlanType();
        String corpId = ctx.getCorpId();
        if (planId == null) {
            log.info("addTagLog: \u6d3b\u7801\u4e0d\u5b58\u5728\u6216\u5df2\u5220\u9664");
            return;
        }
        if (Objects.isNull(planType) || planType.intValue() != PlanType.FRIEND_FISSION_PLAN.getValue()) {
            log.info("addTagLog: \u5f53\u524d\u975e\u597d\u53cb\u88c2\u53d8, planId:{}", (Object)planId);
            return;
        }
        if (!ctx.isPlanActive()) {
            log.info("addTagLog: \u6d3b\u7801\u5f53\u524d\u672a\u751f\u6548\uff0c\u4e14\u6d3b\u52a8\u672a\u7ed3\u675f, planId:{}", (Object)planId);
            return;
        }
        List tagRuleIds = this.tagRuleItemMapper.queryTagRuleIdsByTagList(corpId, planId, tagList);
        if (CollectionUtils.isEmpty((Collection)tagRuleIds)) {
            log.info("addTagLog: \u65e0\u6807\u7b7e\u89c4\u5219id, planId:{}", (Object)planId);
            return;
        }
        ArrayList logList = Lists.newArrayList();
        for (Long tagRuleId : tagRuleIds) {
            MarketingTagRuleLog log = this.newRuleTagLog(tagRuleId, contactId);
            logList.add(log);
        }
        this.tagRuleLogMapper.batchInsert((Collection)logList);
    }

    private void addTag(MarketingJoin join) {
        ReplyContext ctx = ReplyContextUtil.get();
        String corpId = ctx.getCorpId();
        Long planId = ctx.getPlanId();
        String pContactId = ctx.getPContactId();
        Long bizId = ctx.getBizId();
        String weworkUserId = ctx.getWeworkUserId();
        boolean isAutoTagOpen = this.isAutoTagOpen(corpId, planId);
        if (!isAutoTagOpen) {
            log.info("addTag\uff1a\u81ea\u52a8\u6253\u6807\u7b7e\u5f00\u5173\u5df2\u5173\u95ed, planId:{}", (Object)planId);
            return;
        }
        Integer inviteCount = join.getAddCount();
        log.info("addTag: \u5df2\u7ecf\u52a9\u529b\u6210\u529f\u7684\u4eba\u6570\uff1a{}, planId:{}", (Object)inviteCount, (Object)planId);
        Integer reachStage = join.getReachStage();
        log.info("addTag: \uff1a\u5df2\u7ecf\u8fbe\u6210\u7684\u9636\u68af:{}, planId:{}", (Object)reachStage, (Object)planId);
        List tagList = this.tagRuleItemMapper.queryTagsByInviteAndStage(corpId, planId, inviteCount, reachStage, pContactId);
        if (CollectionUtils.isEmpty((Collection)tagList)) {
            log.warn("addTag: tag list is empty, ctx: {}", (Object)ctx);
            return;
        }
        if (CollectionUtils.isEmpty((Collection)(tagList = this.weworkTagMapper.filterIsDeletedTag(corpId, (Collection)tagList)))) {
            log.warn("addTag: {}\u6ca1\u6709\u53ef\u7528\u7684\u6807\u7b7e\u914d\u7f6e, planId:{}", (Object)ctx.getWeworkUserId(), (Object)planId);
            return;
        }
        log.info("addTag: \u6ee1\u8db3\u6761\u4ef6\u7684\u6807\u7b7e\u5217\u8868\uff1a{}, ctx:{}", (Object)tagList, (Object)ctx);
        ModifyTagDto params = new ModifyTagDto();
        params.setBizId(bizId);
        params.setCorpId(corpId);
        params.setWeworkUserId(weworkUserId);
        params.setContactId(pContactId);
        params.setAddTagIds(tagList);
        if (!this.msgLock.locked("fission:markTag", 1L)) {
            log.info("addTag: lock failed, planId:{}", (Object)planId);
            try {
                TimeUnit.SECONDS.sleep(1L);
            }
            catch (InterruptedException e) {
                log.error("addTag: \u7ebf\u7a0b\u4e2d\u65ad, e:{}", (Throwable)e);
                Thread.currentThread().interrupt();
            }
        }
        log.info("addTag: \u6253\u6807\u7b7e:{}", (Object)params);
        try {
            this.contactOpService.modifyTag(params);
            this.addTagLog(tagList, pContactId);
        }
        catch (Exception e) {
            log.error("addTag: \u4fee\u6539\u5ba2\u6237\u6807\u7b7e\u5931\u8d25", (Throwable)e);
        }
    }

    private MarketingTagRuleLog newRuleTagLog(Long tagRuleId, String contactId) {
        ReplyContext ctx = ReplyContextUtil.get();
        MarketingTagRuleLog ruleLog = new MarketingTagRuleLog();
        ruleLog.setBizId(ctx.getBizId());
        ruleLog.setCorpId(ctx.getCorpId());
        ruleLog.setPlanId(ctx.getPlanId());
        ruleLog.setContactId(contactId);
        ruleLog.setTagRuleId(tagRuleId);
        ruleLog.setCreateTime(new Date());
        ruleLog.setUpdateTime(new Date());
        ruleLog.setIsDeleted(Integer.valueOf(0));
        return ruleLog;
    }

    private void addFriendLog() {
        ReplyContext ctx = ReplyContextUtil.get();
        log.info("\u8bb0\u5f55\u6d3b\u52a8\u52a0\u597d\u53cb\u65e5\u5fd7, ctx={}", (Object)ctx);
        MarketingAddFriendLog record = new MarketingAddFriendLog();
        record.setBizId(ctx.getBizId());
        record.setCorpId(ctx.getCorpId());
        record.setWeworkUserNum(ctx.getWeworkUserNum());
        record.setContactId(ctx.getContactId());
        record.setAddFriendTime(ctx.getTimestamp());
        record.setPlanId(ctx.getPlanId());
        record.setPlanNum(ctx.getPlanNum());
        record.setChannelId(ctx.getChannelId());
        record.setPContactId(ctx.getPContactId());
        record.setIsNewCustomer(Boolean.valueOf(ctx.isNewCustomer()));
        record.setIsSuccess(Boolean.valueOf(ctx.isFissionSuccess()));
        record.setCreateTime(new Date());
        record.setUpdateTime(new Date());
        record.setIsDeleted(Integer.valueOf(0));
        record.setDeleteTime(null);
        this.addFriendLogMapper.insertSelective((Object)record);
    }

    private boolean tryReachStage(MarketingJoin join) {
        boolean flag = false;
        Date now = new Date();
        int count = join.getAddCount() + 1;
        join.setAddCount(Integer.valueOf(count));
        join.setUpdateTime(now);
        List reachedStages = this.rewardMapper.isReachStage(join.getPlanId(), join.getCorpId(), join.getContactId(), count, now);
        if (CollectionUtils.isNotEmpty((Collection)reachedStages)) {
            List ids = reachedStages.stream().map(it -> it.getId()).collect(Collectors.toList());
            this.rewardMapper.updateReachStage(ids, now);
            int reachStage = ((MarketingReward)reachedStages.get(0)).getStage();
            join.setReachStage(Integer.valueOf(reachStage));
            flag = true;
        }
        this.joinMapper.updateByPrimaryKeySelective((Object)join);
        return flag;
    }

    private void remindReachStage(MarketingJoin join) {
        if (StringUtils.isBlank((CharSequence)join.getWeworkUserNum())) {
            log.info("\u672a\u627e\u5230\u5ba2\u6237\u5206\u914d\u7684\u6210\u5458\uff0c\u4e0d\u63a8\u9001\u63d0\u9192\u3002");
            return;
        }
        String corpId = join.getCorpId();
        String contactId = join.getContactId();
        String weworkUserId = this.weworkUserMapper.queryWeworkUserIdByNum(join.getWeworkUserNum());
        String format = "\u6d3b\u52a8\u5b8c\u6210\u901a\u77e5\n\u5ba2\u6237\u6635\u79f0\uff1a{0}\n\u6d3b\u52a8\u540d\u79f0\uff1a{1}\n\u5b8c\u6210\u9636\u68af\uff1a{2}\n\u9080\u8bf7\u4eba\u6570\uff1a{3}\n\u5b8c\u6210\u65f6\u95f4\uff1a{4}";
        WeworkContact contact = this.weworkContactMapper.queryWeworkContact(join.getBizId(), corpId, contactId);
        MarketingPlan plan = (MarketingPlan)this.marketingPlanMapper.selectByPrimaryKey((Object)join.getPlanId());
        String datetime = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").format(new Date());
        String message = MessageFormat.format(format, contact.getName(), plan.getName(), join.getReachStage(), join.getAddCount(), datetime);
        log.info("\u5ba2\u6237\u8fbe\u6210\u4e86\u9636\u6bb5\u5956\u52b1\uff0c\u7ed9\u6210\u5458\u63a8\u9001\u63d0\u9192. stage={}, planId={}, contactId={}, weworkUserId={}", new Object[]{join.getReachStage(), join.getPlanId(), contactId, weworkUserId});
        try {
            this.remindService.sendMsg(join.getCorpId(), weworkUserId, message);
        }
        catch (Exception e) {
            log.error("\u63a8\u9001\u767e\u5bb6\u4e91\u63d0\u9192\u5931\u8d25, message:{}", (Object)message, (Object)e);
        }
    }
}

