/*
 * Decompiled with CFR 0.152.
 */
package com.kuaike.scrm.event.service.impl;

import cn.kinyun.wework.sdk.api.external.TransferApi;
import cn.kinyun.wework.sdk.callback.corp.contact.DeleteUser;
import cn.kinyun.wework.sdk.entity.external.transfer.UnassignedCustomer;
import cn.kinyun.wework.sdk.entity.external.transfer.UnassignedListResp;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.kuaike.scrm.dal.transfer.entity.DimissionWeworkUser;
import com.kuaike.scrm.dal.transfer.entity.DimissionWeworkUserCustomer;
import com.kuaike.scrm.dal.transfer.entity.DimissionWeworkUserRoom;
import com.kuaike.scrm.dal.transfer.mapper.DimissionWeworkUserCustomerMapper;
import com.kuaike.scrm.dal.transfer.mapper.DimissionWeworkUserMapper;
import com.kuaike.scrm.dal.transfer.mapper.DimissionWeworkUserRoomMapper;
import com.kuaike.scrm.dal.wework.entity.WeworkChatRoom;
import com.kuaike.scrm.dal.wework.mapper.WeworkChatRoomMapper;
import com.kuaike.scrm.dal.wework.mapper.WeworkUserMapper;
import com.kuaike.scrm.event.context.ReplyContext;
import com.kuaike.scrm.event.context.ReplyContextUtil;
import com.kuaike.scrm.event.service.DismissUserService;
import com.kuaike.scrm.token.service.CustomizedTokenService;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.collections4.MapUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.math.NumberUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class DismissUserServiceImpl
implements DismissUserService {
    private static final Logger log = LoggerFactory.getLogger(DismissUserServiceImpl.class);
    @Autowired
    private DimissionWeworkUserMapper dimissionWeworkUserMapper;
    @Autowired
    private CustomizedTokenService customizedTokenService;
    @Autowired
    private TransferApi transferApi;
    @Autowired
    private WeworkChatRoomMapper weworkChatRoomMapper;
    @Autowired
    private DimissionWeworkUserCustomerMapper dimissionWeworkUserCustomerMapper;
    @Autowired
    private DimissionWeworkUserRoomMapper dimissionWeworkUserRoomMapper;
    @Autowired
    private WeworkUserMapper weworkUserMapper;

    @Override
    public void onDeleteUser(DeleteUser event) {
        List<DimissionWeworkUserRoom> dimissionWeworkUserRooms;
        List<DimissionWeworkUserCustomer> dimissionWeworkUserCustomers;
        Map weworkUserId2NumMap;
        log.info("begin handle del user, delUserDto:{}", (Object)event);
        ReplyContext ctx = ReplyContextUtil.get();
        Long bizId = ctx.getBizId();
        String corpId = ctx.getCorpId();
        String weworkUserId = ctx.getWeworkUserId();
        String weworkUserNum = ctx.getWeworkUserNum();
        if (Objects.isNull(bizId)) {
            log.info("\u6839\u636ecorpId:{}\u672a\u67e5\u8be2\u5230\u5546\u6237\u4fe1\u606f", (Object)corpId);
            return;
        }
        if (StringUtils.isBlank((CharSequence)weworkUserNum)) {
            log.warn("\u6839\u636ecorpId:{}, weworkUserId:{}\u672a\u83b7\u53d6\u5230\u8bb0\u5f55", (Object)corpId, (Object)weworkUserId);
            return;
        }
        DimissionWeworkUser dimissionWeworkUser = this.dimissionWeworkUserMapper.selectByCorpIdAndWeworkUserNum(corpId, weworkUserNum);
        if (Objects.nonNull(dimissionWeworkUser)) {
            log.info("\u6839\u636ecorpId:{}, weworkUserId:{}\u67e5\u8be2\u5230\u8bb0\u5f55", (Object)corpId, (Object)weworkUserId);
            return;
        }
        HashMap weworkUserId2CustomerIdsMap = Maps.newHashMap();
        HashMap weworkUserId2DimissionTimeMap = Maps.newHashMap();
        this.getDimissionUserCustomers(corpId, weworkUserId2CustomerIdsMap, weworkUserId2DimissionTimeMap);
        HashSet weworkUserIds = Sets.newHashSet();
        weworkUserIds.add(weworkUserId);
        if (weworkUserId2CustomerIdsMap.size() > 0) {
            weworkUserIds.addAll(weworkUserId2CustomerIdsMap.keySet());
        }
        if (MapUtils.isEmpty((Map)(weworkUserId2NumMap = this.weworkUserMapper.selectWeworkUserIdAndNumByWeworkUserIds(corpId, (Collection)weworkUserIds)))) {
            log.info("\u6839\u636eweworkUserIds:{}\u672a\u83b7\u53d6\u5230\u8bb0\u5f55", weworkUserId2CustomerIdsMap.keySet());
            return;
        }
        Map<String, Set<String>> weworkUserId2RoomIdsMap = this.getDimissionUserRooms(corpId, Sets.newHashSet((Object[])new String[]{weworkUserId}));
        List<DimissionWeworkUser> dimissionWeworkUsers = this.buildDimissionWeworkUsers(bizId, corpId, weworkUserIds, weworkUserId2CustomerIdsMap, weworkUserId2DimissionTimeMap, weworkUserId2RoomIdsMap, weworkUserId2NumMap);
        if (CollectionUtils.isNotEmpty(dimissionWeworkUsers)) {
            this.dimissionWeworkUserMapper.batchInsert(dimissionWeworkUsers);
        }
        if (CollectionUtils.isNotEmpty(dimissionWeworkUserCustomers = this.buildDimissionWeworkUserCustomers(bizId, corpId, weworkUserId2CustomerIdsMap, weworkUserId2NumMap))) {
            Lists.partition(dimissionWeworkUserCustomers, (int)500).forEach(pagedUserCustomers -> this.dimissionWeworkUserCustomerMapper.batchInsert((Collection)pagedUserCustomers));
        }
        if (CollectionUtils.isNotEmpty(dimissionWeworkUserRooms = this.buildDimissionWeworkUserRooms(bizId, corpId, weworkUserId2RoomIdsMap, weworkUserId2NumMap))) {
            Lists.partition(dimissionWeworkUserRooms, (int)500).forEach(pagedUserRooms -> this.dimissionWeworkUserRoomMapper.batchInsert((Collection)pagedUserRooms));
        }
    }

    private void getDimissionUserCustomers(String corpId, Map<String, Set<String>> weworkUserId2CustomerIdsMap, Map<String, Long> weworkUserId2DimissionTimeMap) {
        boolean flag = true;
        String cursor = null;
        List unassignedCustomers = null;
        String accessToken = "";
        UnassignedListResp unassignedListResp = null;
        while (flag) {
            block11: {
                try {
                    accessToken = this.customizedTokenService.getAgentAccessToken(corpId);
                    if (StringUtils.isBlank((CharSequence)accessToken)) {
                        log.info("\u4f01\u4e1a\u672a\u6388\u6743\u4ee3\u5f00\u53d1\u81ea\u5efa\u5e94\u7528, corpId={}", (Object)corpId);
                    }
                    break block11;
                }
                catch (Exception ex) {
                    log.error("\u6839\u636ecorpId:{}\u83b7\u53d6suiteToken\u53d1\u751f\u5f02\u5e38:", (Object)corpId, (Object)ex);
                }
                break;
            }
            try {
                log.info("getUnassignedList,accessToken:{}, cursor:{}", (Object)accessToken, cursor);
                unassignedListResp = this.transferApi.getUnassignedList(accessToken, null, null, cursor);
                log.info("unassignedListResp:{},", (Object)unassignedListResp);
                if (Objects.isNull(unassignedListResp) || !NumberUtils.INTEGER_ZERO.equals(unassignedListResp.getErrCode())) {
                    log.warn("\u6839\u636esuiteToken:{},cursor:{}\u672a\u83b7\u53d6\u5230\u8bb0\u5f55", (Object)accessToken, cursor);
                    break;
                }
                cursor = unassignedListResp.getNextCursor();
                if (StringUtils.isBlank((CharSequence)cursor)) {
                    flag = false;
                }
                if (!CollectionUtils.isNotEmpty((Collection)(unassignedCustomers = unassignedListResp.getInfo()))) continue;
                Map<String, List<UnassignedCustomer>> pagedUserId2CustomerIdsMap = unassignedCustomers.stream().collect(Collectors.groupingBy(UnassignedCustomer::getHandoverUserId));
                for (Map.Entry<String, List<UnassignedCustomer>> entry : pagedUserId2CustomerIdsMap.entrySet()) {
                    String weworkUserId = entry.getKey();
                    if (!weworkUserId2DimissionTimeMap.containsKey(weworkUserId)) {
                        weworkUserId2DimissionTimeMap.put(weworkUserId, entry.getValue().get(0).getDimissionTime());
                    }
                    if (weworkUserId2CustomerIdsMap.containsKey(entry.getKey())) {
                        Set<String> customerIds = weworkUserId2CustomerIdsMap.get(entry.getKey());
                        customerIds.addAll(entry.getValue().stream().map(UnassignedCustomer::getExternalUserId).collect(Collectors.toSet()));
                        weworkUserId2CustomerIdsMap.put(weworkUserId, customerIds);
                        continue;
                    }
                    weworkUserId2CustomerIdsMap.put(weworkUserId, entry.getValue().stream().map(UnassignedCustomer::getExternalUserId).collect(Collectors.toSet()));
                }
            }
            catch (Exception ex) {
                flag = false;
                log.error("getUnassignedList,\u53d1\u751f\u5f02\u5e38", (Throwable)ex);
            }
        }
    }

    private Map<String, Set<String>> getDimissionUserRooms(String corpId, Set<String> weworkUserIds) {
        List chatRooms = this.weworkChatRoomMapper.selectByCorpIdAndOwner(corpId, weworkUserIds);
        if (CollectionUtils.isEmpty((Collection)chatRooms)) {
            log.info("\u6839\u636ecorpId:{}, weworkUserIds:{}\u672a\u83b7\u53d6\u5230\u7fa4\u4fe1\u606f", (Object)corpId, weworkUserIds);
            return Maps.newHashMap();
        }
        return chatRooms.stream().collect(Collectors.groupingBy(WeworkChatRoom::getOwner, Collectors.mapping(WeworkChatRoom::getWeworkRoomId, Collectors.toSet())));
    }

    private List<DimissionWeworkUser> buildDimissionWeworkUsers(Long bizId, String corpId, Set<String> weworkUserIds, Map<String, Set<String>> weworkUserId2CustomerIdsMap, Map<String, Long> weworkUserId2DimissionTimeMap, Map<String, Set<String>> weworkUserId2RoomIdsMap, Map<String, String> weworkUserId2NumMap) {
        ArrayList dimissionWeworkUsers = Lists.newArrayList();
        for (String weworkUserId : weworkUserIds) {
            if (!weworkUserId2NumMap.containsKey(weworkUserId)) {
                log.warn("weworkUserId:{}\u5728\u7cfb\u7edf\u4e2d\u4e0d\u5b58\u5728", (Object)weworkUserId);
                continue;
            }
            DimissionWeworkUser dimissionWeworkUser = new DimissionWeworkUser();
            dimissionWeworkUsers.add(dimissionWeworkUser);
            dimissionWeworkUser.setBizId(bizId);
            dimissionWeworkUser.setCorpId(corpId);
            dimissionWeworkUser.setWeworkUserNum(weworkUserId2NumMap.get(weworkUserId));
            if (weworkUserId2DimissionTimeMap.containsKey(weworkUserId)) {
                dimissionWeworkUser.setDimissionTime(new Date(weworkUserId2DimissionTimeMap.get(weworkUserId) * 1000L));
            } else {
                dimissionWeworkUser.setDimissionTime(new Date());
            }
            if (weworkUserId2CustomerIdsMap.containsKey(weworkUserId)) {
                dimissionWeworkUser.setWaitAllocateCustomerCount(Integer.valueOf(weworkUserId2CustomerIdsMap.get(weworkUserId).size()));
            } else {
                dimissionWeworkUser.setWaitAllocateCustomerCount(NumberUtils.INTEGER_ZERO);
            }
            if (MapUtils.isNotEmpty(weworkUserId2RoomIdsMap) && weworkUserId2RoomIdsMap.containsKey(weworkUserId)) {
                dimissionWeworkUser.setWaitAllocateRoomCount(Integer.valueOf(weworkUserId2RoomIdsMap.get(weworkUserId).size()));
            } else {
                dimissionWeworkUser.setWaitAllocateRoomCount(NumberUtils.INTEGER_ZERO);
            }
            dimissionWeworkUser.setCreateTime(new Date());
            dimissionWeworkUser.setUpdateTime(new Date());
            dimissionWeworkUser.setAllocatedCustomerCount(NumberUtils.INTEGER_ZERO);
            dimissionWeworkUser.setAllocatedRoomCount(NumberUtils.INTEGER_ZERO);
        }
        return dimissionWeworkUsers;
    }

    private List<DimissionWeworkUserCustomer> buildDimissionWeworkUserCustomers(Long bizId, String corpId, Map<String, Set<String>> weworkUserId2CustomerIdsMap, Map<String, String> weworkUserId2NumMap) {
        if (MapUtils.isEmpty(weworkUserId2CustomerIdsMap)) {
            return Collections.emptyList();
        }
        ArrayList userCustomers = Lists.newArrayList();
        for (Map.Entry<String, Set<String>> entry : weworkUserId2CustomerIdsMap.entrySet()) {
            String weworkUserId = entry.getKey();
            if (!weworkUserId2NumMap.containsKey(weworkUserId)) {
                log.warn("\u6210\u5458weworkUserId:{}\u5728\u7cfb\u7edf\u4e2d\u4e0d\u5b58\u5728", (Object)weworkUserId);
                continue;
            }
            Set<String> customerIds = entry.getValue();
            for (String customerId : customerIds) {
                DimissionWeworkUserCustomer dimissionWeworkUserCustomer = new DimissionWeworkUserCustomer();
                userCustomers.add(dimissionWeworkUserCustomer);
                dimissionWeworkUserCustomer.setBizId(bizId);
                dimissionWeworkUserCustomer.setCorpId(corpId);
                dimissionWeworkUserCustomer.setWeworkUserNum(weworkUserId2NumMap.get(weworkUserId));
                dimissionWeworkUserCustomer.setWeworkContactId(customerId);
                dimissionWeworkUserCustomer.setCreateTime(new Date());
                dimissionWeworkUserCustomer.setUpdateTime(new Date());
            }
        }
        return userCustomers;
    }

    private List<DimissionWeworkUserRoom> buildDimissionWeworkUserRooms(Long bizId, String corpId, Map<String, Set<String>> weworkUserId2RoomIdsMap, Map<String, String> weworkUserId2NumMap) {
        if (MapUtils.isEmpty(weworkUserId2RoomIdsMap)) {
            return Collections.emptyList();
        }
        ArrayList userRooms = Lists.newArrayList();
        for (Map.Entry<String, Set<String>> entry : weworkUserId2RoomIdsMap.entrySet()) {
            String weworkUserId = entry.getKey();
            if (!weworkUserId2NumMap.containsKey(weworkUserId)) {
                log.warn("\u6210\u5458weworkUserId:{}\u5728\u7cfb\u7edf\u4e2d\u4e0d\u5b58\u5728", (Object)weworkUserId);
                continue;
            }
            Set<String> roomIds = entry.getValue();
            for (String roomId : roomIds) {
                DimissionWeworkUserRoom dimissionWeworkUserRoom = new DimissionWeworkUserRoom();
                userRooms.add(dimissionWeworkUserRoom);
                dimissionWeworkUserRoom.setBizId(bizId);
                dimissionWeworkUserRoom.setCorpId(corpId);
                dimissionWeworkUserRoom.setWeworkUserNum(weworkUserId2NumMap.get(weworkUserId));
                dimissionWeworkUserRoom.setWeworkRoomId(roomId);
                dimissionWeworkUserRoom.setCreateTime(new Date());
                dimissionWeworkUserRoom.setUpdateTime(new Date());
            }
        }
        return userRooms;
    }
}

