/*
 * Decompiled with CFR 0.152.
 */
package com.kuaike.scrm.event.service.impl;

import com.google.common.base.Splitter;
import com.kuaike.scrm.dal.addFriend.entity.AddFriendConfig;
import com.kuaike.scrm.dal.addFriend.mapper.AddFriendConfigMapper;
import com.kuaike.scrm.dal.addFriend.mapper.AddFriendConfigTagMapper;
import com.kuaike.scrm.dal.qyQrcodeTask.entity.QyQrcodeSubTask;
import com.kuaike.scrm.dal.qyQrcodeTask.mapper.QyQrcodeSubTaskMapper;
import com.kuaike.scrm.dal.radar.entity.MarketingRadar;
import com.kuaike.scrm.dal.radar.entity.MarketingRadarQrcode;
import com.kuaike.scrm.dal.radar.mapper.MarketingRadarDetailMapper;
import com.kuaike.scrm.dal.radar.mapper.MarketingRadarMapper;
import com.kuaike.scrm.dal.radar.mapper.MarketingRadarQrcodeMapper;
import com.kuaike.scrm.dal.weworkTag.mapper.WeworkTagMapper;
import com.kuaike.scrm.event.context.ReplyContext;
import com.kuaike.scrm.event.context.ReplyContextUtil;
import com.kuaike.scrm.event.service.AttachTagService;
import com.kuaike.scrm.event.service.FriendFissionService;
import com.kuaike.scrm.event.service.HandleTelAddFriendEventService;
import com.kuaike.scrm.marketing.service.MarketingTagService;
import com.kuaike.scrm.wework.contact.dto.ModifyTagDto;
import com.kuaike.scrm.wework.contact.service.ContactOpService;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class AttachTagServiceImpl
implements AttachTagService {
    private static final Logger log = LoggerFactory.getLogger(AttachTagServiceImpl.class);
    @Autowired
    private WeworkTagMapper weworkTagMapper;
    @Autowired
    private AddFriendConfigMapper addFriendConfigMapper;
    @Autowired
    private AddFriendConfigTagMapper addFriendConfigTagMapper;
    @Autowired
    private QyQrcodeSubTaskMapper qyQrcodeSubTaskMapper;
    @Resource
    private MarketingRadarQrcodeMapper marketingRadarQrcodeMapper;
    @Resource
    private MarketingRadarDetailMapper marketingRadarDetailMapper;
    @Resource
    private MarketingRadarMapper marketingRadarMapper;
    @Autowired
    private MarketingTagService marketingTagService;
    @Autowired
    private ContactOpService contactOpService;
    @Autowired
    private FriendFissionService friendFissionService;
    @Autowired
    private HandleTelAddFriendEventService handleTelAddFriendEventService;

    @Override
    public boolean onAddExternalContact() {
        ReplyContext ctx = ReplyContextUtil.get();
        Long bizId = ctx.getBizId();
        String corpId = ctx.getCorpId();
        String weworkUserId = ctx.getWeworkUserId();
        String contactId = ctx.getContactId();
        List<String> tagIds = this.getTagIds();
        if (CollectionUtils.isEmpty(tagIds)) {
            log.warn("tag list is empty, corpId: {}", (Object)corpId);
            return false;
        }
        ModifyTagDto params = new ModifyTagDto();
        params.setBizId(bizId);
        params.setCorpId(corpId);
        params.setWeworkUserId(weworkUserId);
        params.setContactId(contactId);
        params.setAddTagIds(tagIds);
        log.info("onAddExternalContact: \u6253\u6807\u7b7e:{}", (Object)params);
        try {
            this.contactOpService.modifyTag(params);
            this.friendFissionService.addTagLog(tagIds, contactId);
            return true;
        }
        catch (Exception e) {
            log.error("\u4fee\u6539\u5ba2\u6237\u6807\u7b7e\u5931\u8d25", (Throwable)e);
            return false;
        }
    }

    private List<String> getTagIds() {
        List<String> tagIds = this.friendFissionService.getTags();
        if (CollectionUtils.isEmpty(tagIds)) {
            tagIds = this.getMarketingTagIds();
        }
        if (CollectionUtils.isEmpty(tagIds)) {
            tagIds = this.handleTelAddFriendEventService.getTagIds();
        }
        if (CollectionUtils.isEmpty(tagIds)) {
            tagIds = this.getAddFriendTagIds();
        }
        if (CollectionUtils.isEmpty(tagIds)) {
            tagIds = this.getAdQrcodeTagIds();
        }
        if (CollectionUtils.isEmpty(tagIds)) {
            tagIds = this.getRadarTagIds();
        }
        return tagIds;
    }

    private List<String> getAddFriendTagIds() {
        List tagList;
        ReplyContext ctx = ReplyContextUtil.get();
        String corpId = ctx.getCorpId();
        String weworkUserId = ctx.getWeworkUserId();
        String weworkUserNum = ctx.getWeworkUserNum();
        String state = ctx.getState();
        AddFriendConfig config = this.addFriendConfigMapper.getByWeworkUser(corpId, weworkUserNum);
        if (config == null) {
            log.info("{} \u6ca1\u6709\u53ef\u7528\u7684\u65b0\u597d\u53cb\u6807\u7b7e\u914d\u7f6e", (Object)weworkUserId);
            return null;
        }
        if (config.getAttachTagIsEnabled() == 0) {
            log.info("{} \u7684\u65b0\u597d\u53cb\u6807\u7b7e\u529f\u80fd\u5df2\u5173\u95ed", (Object)weworkUserId);
            return null;
        }
        if (config.getAttachTagIsSpecified() == 1) {
            if (!config.getQrcodeState().equals(state) && config.getAttachTagUseOther() == 0) {
                log.info("{} \u7684\u597d\u53cb\u4e0d\u662f\u901a\u8fc7\u4e13\u5c5e\u4e8c\u7ef4\u7801\u6dfb\u52a0\u7684\u800c\u4e14\u672a\u5f00\u542f\u975e\u4f01\u5fae\u4e8c\u7ef4\u7801\u6765\u6e90\u6253\u6807\u7b7e\uff0c\u4e0d\u6253\u6807\u7b7e", (Object)weworkUserId);
                return null;
            }
        } else if (StringUtils.isNotEmpty((CharSequence)state) || config.getAttachTagUseOther() == 0) {
            log.info("{} \u672a\u5f00\u542f\u975e\u4f01\u5fae\u4e8c\u7ef4\u7801\u6765\u6e90\u6253\u6807\u7b7e\uff0c\u4e0d\u6253\u6807\u7b7e", (Object)weworkUserId);
            return null;
        }
        if (CollectionUtils.isEmpty((Collection)(tagList = this.addFriendConfigTagMapper.getByWeworkUser(corpId, weworkUserNum)))) {
            log.warn("{} \u6ca1\u6709\u53ef\u7528\u7684\u65b0\u597d\u53cb\u6807\u7b7e\u914d\u7f6e", (Object)weworkUserId);
            return null;
        }
        List tagIds = tagList.stream().map(item -> item.getTagId()).collect(Collectors.toList());
        if (CollectionUtils.isEmpty((Collection)(tagIds = this.weworkTagMapper.filterIsDeletedTag(corpId, tagIds)))) {
            log.warn("{} \u6ca1\u6709\u53ef\u7528\u7684\u65b0\u597d\u53cb\u6807\u7b7e\u914d\u7f6e", (Object)weworkUserId);
            return null;
        }
        log.info("\u65b0\u597d\u53cb\u6807\u7b7eID:{}", (Object)tagIds);
        return tagIds;
    }

    private List<String> getMarketingTagIds() {
        ReplyContext ctx = ReplyContextUtil.get();
        Long bizId = ctx.getBizId();
        String corpId = ctx.getCorpId();
        Long planId = ctx.getPlanId();
        Long planGroupId = ctx.getPlanGroupId();
        if (planId == null || planGroupId == null) {
            log.warn("\u6d3b\u7801\u4e0d\u5b58\u5728\u6216\u5df2\u5220\u9664");
            return null;
        }
        if (!ctx.isPlanActive()) {
            log.warn("\u6d3b\u7801\u5f53\u524d\u672a\u751f\u6548, planId:{}, planGroupId:{}", (Object)planId, (Object)planGroupId);
            return null;
        }
        List tagList = this.marketingTagService.queryMarketingPlanGroupTag(bizId, corpId, planId, planGroupId);
        if (CollectionUtils.isEmpty((Collection)tagList)) {
            log.warn("\u6d3b\u7801\u6807\u7b7e\u4e3a\u7a7a, planId:{}, planGroupId:{}", (Object)planId, (Object)planGroupId);
            return null;
        }
        List tagIds = tagList.stream().map(item -> item.getTagId()).collect(Collectors.toList());
        if (CollectionUtils.isEmpty((Collection)(tagIds = this.weworkTagMapper.filterIsDeletedTag(corpId, tagIds)))) {
            log.warn("\u6d3b\u7801\u6807\u7b7e\u4e3a\u7a7a, planId:{}, planGroupId:{}", (Object)planId, (Object)planGroupId);
            return null;
        }
        log.info("\u6d3b\u7801\u6807\u7b7eID:{}, planId:{}, planGroupId:{}", new Object[]{tagIds, planId, planGroupId});
        return tagIds;
    }

    private List<String> getAdQrcodeTagIds() {
        ReplyContext ctx = ReplyContextUtil.get();
        String corpId = ctx.getCorpId();
        String state = ctx.getState();
        if (!ctx.isAdQrcode()) {
            return null;
        }
        QyQrcodeSubTask subTask = new QyQrcodeSubTask();
        subTask.setCorpId(corpId);
        subTask.setState(state);
        subTask = (QyQrcodeSubTask)this.qyQrcodeSubTaskMapper.selectOne((Object)subTask);
        if (subTask == null || subTask.getIsDeleted() == 1) {
            log.info("get ad qrcode tagIds subtask is null or deleted, state: {}", (Object)state);
            return null;
        }
        String tagIds = subTask.getTagIds();
        if (StringUtils.isBlank((CharSequence)tagIds)) {
            log.info("get ad qrcode tagIds is null, state: {}", (Object)state);
            return null;
        }
        List tagIdList = Splitter.on((String)",").splitToList((CharSequence)tagIds);
        if (CollectionUtils.isEmpty((Collection)tagIdList)) {
            return null;
        }
        return tagIdList;
    }

    private List<String> getRadarTagIds() {
        ReplyContext ctx = ReplyContextUtil.get();
        String corpId = ctx.getCorpId();
        if (!ctx.isRadar()) {
            return null;
        }
        MarketingRadarQrcode radarQrcode = new MarketingRadarQrcode();
        radarQrcode.setState(ctx.getState());
        radarQrcode = (MarketingRadarQrcode)this.marketingRadarQrcodeMapper.selectOne((Object)radarQrcode);
        List result = null;
        if (radarQrcode != null) {
            MarketingRadar radar = new MarketingRadar();
            radar.setNum(radarQrcode.getMarketingRadarNum());
            radar = (MarketingRadar)this.marketingRadarMapper.selectOne((Object)radar);
            if (radar == null || radar.getIsDeleted() == 1 || radar.getIsClickTag() == 0) {
                log.info("radar is del or not attach tag");
                return null;
            }
            result = this.marketingRadarDetailMapper.queryRadarWeworkTagNums(corpId, radarQrcode.getMarketingRadarNum());
        }
        log.info("radar tagIds: {}", result);
        return result;
    }
}

