/*
 * Decompiled with CFR 0.152.
 */
package com.kuaike.scrm.event.service.impl;

import cn.kinyun.ad.common.req.AddFriendSuccReq;
import cn.kinyun.ad.common.service.MSWeworkCardDetailService;
import com.google.common.collect.Lists;
import com.kuaike.scrm.dal.wework.entity.WeworkContact;
import com.kuaike.scrm.dal.wework.mapper.WeworkContactMapper;
import com.kuaike.scrm.dal.wework.mapper.WeworkUserMapper;
import com.kuaike.scrm.event.context.ReplyContext;
import com.kuaike.scrm.event.context.ReplyContextUtil;
import com.kuaike.scrm.event.service.AddContactCallbackAdService;
import java.util.Collection;
import java.util.Map;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class AddContactCallbackAdServiceImp
implements AddContactCallbackAdService {
    private static final Logger log = LoggerFactory.getLogger(AddContactCallbackAdServiceImp.class);
    @Resource
    private WeworkContactMapper weworkContactMapper;
    @Resource
    private WeworkUserMapper weworkUserMapper;
    @Autowired(required=false)
    private MSWeworkCardDetailService mSWeworkCardDetailService;

    @Override
    public void callbackEventToAd() {
        ReplyContext ctx = ReplyContextUtil.get();
        Long bizId = ctx.getBizId();
        String corpId = ctx.getCorpId();
        String weworkUserNum = ctx.getWeworkUserNum();
        String contactId = ctx.getContactId();
        if (!ctx.isAdQrcode()) {
            return;
        }
        WeworkContact weworkContact = this.weworkContactMapper.queryWeworkContact(bizId, corpId, contactId);
        if (weworkContact == null) {
            log.info("callbackEventToAd contact is null");
            return;
        }
        Integer gender = weworkContact.getGender();
        String nickName = weworkContact.getName();
        Map nameMap = this.weworkUserMapper.queryWeworkUserNameMapByNums(corpId, (Collection)Lists.newArrayList((Object[])new String[]{weworkUserNum}));
        String weworkUserName = (String)nameMap.get(weworkUserNum);
        AddFriendSuccReq req = new AddFriendSuccReq();
        req.setCorpId(corpId);
        req.setContactId(contactId);
        req.setAvatar(weworkContact.getAvatar());
        req.setGender(gender);
        req.setNickName(nickName);
        req.setState(ctx.getState());
        req.setUnionId(weworkContact.getUnionid());
        req.setWeworkUserName(weworkUserName);
        req.setWeworkUserNum(weworkUserNum);
        log.info("addFriendCallback params: {}", (Object)req);
        this.mSWeworkCardDetailService.addFriendCallback(req);
    }
}

