/*
 * Decompiled with CFR 0.152.
 */
package com.kuaike.scrm.event.handler;

import cn.kinyun.customer.center.dto.req.ModMobileReq;
import cn.kinyun.customer.center.enums.ModuleType;
import cn.kinyun.customer.center.service.CcCustomerInfoService;
import cn.kinyun.wework.sdk.callback.corp.external.AddExternalContact;
import cn.kinyun.wework.sdk.callback.corp.external.AddHalfExternalContact;
import cn.kinyun.wework.sdk.callback.corp.external.DelExternalContact;
import cn.kinyun.wework.sdk.callback.corp.external.DelFollowUser;
import cn.kinyun.wework.sdk.callback.corp.external.EditExternalContact;
import cn.kinyun.wework.sdk.callback.corp.external.TransferFail;
import com.google.common.collect.Sets;
import com.kuaike.scrm.chat.service.QualityCheckService;
import com.kuaike.scrm.common.enums.TelAddFriendStatus;
import com.kuaike.scrm.common.enums.addfriend.TelAddType;
import com.kuaike.scrm.common.service.CustomerCenterService;
import com.kuaike.scrm.common.service.ScrmBizService;
import com.kuaike.scrm.common.service.dto.resp.BizSimpleDto;
import com.kuaike.scrm.dal.marketing.entity.MarketingJoin;
import com.kuaike.scrm.dal.marketing.entity.MarketingPlan;
import com.kuaike.scrm.dal.marketing.entity.MarketingQrcode;
import com.kuaike.scrm.dal.marketing.mapper.MarketingJoinMapper;
import com.kuaike.scrm.dal.marketing.mapper.MarketingPlanMapper;
import com.kuaike.scrm.dal.marketing.mapper.MarketingQrcodeMapper;
import com.kuaike.scrm.dal.permission.mapper.UserMapper;
import com.kuaike.scrm.dal.telAddFriend.entity.TelAddFriendTask;
import com.kuaike.scrm.dal.telAddFriend.entity.TelAddFriendTaskDetail;
import com.kuaike.scrm.dal.telAddFriend.mapper.TelAddFriendTaskDetailMapper;
import com.kuaike.scrm.dal.telAddFriend.mapper.TelAddFriendTaskMapper;
import com.kuaike.scrm.dal.vip.mapper.VipFriendSendRecordMapper;
import com.kuaike.scrm.dal.wework.entity.WeworkContact;
import com.kuaike.scrm.dal.wework.entity.WeworkContactRelation;
import com.kuaike.scrm.dal.wework.entity.WeworkUser;
import com.kuaike.scrm.dal.wework.mapper.WeworkContactMapper;
import com.kuaike.scrm.dal.wework.mapper.WeworkContactRelationMapper;
import com.kuaike.scrm.dal.wework.mapper.WeworkUserMapper;
import com.kuaike.scrm.event.context.ReplyContext;
import com.kuaike.scrm.event.context.ReplyContextUtil;
import com.kuaike.scrm.event.service.AddContactCallbackAdService;
import com.kuaike.scrm.event.service.AttachTagService;
import com.kuaike.scrm.event.service.FriendFissionService;
import com.kuaike.scrm.event.service.FriendLogService;
import com.kuaike.scrm.event.service.RemarkService;
import com.kuaike.scrm.event.service.VipIdTranslateService;
import com.kuaike.scrm.event.service.WelcomeService;
import com.kuaike.scrm.event.utils.MsgLock;
import com.kuaike.scrm.wework.contact.service.ContactCenterService;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import javax.annotation.Resource;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class FriendEventHandler {
    private static final Logger log = LoggerFactory.getLogger(FriendEventHandler.class);
    @Autowired
    private MsgLock msgLock;
    @Autowired
    private WeworkUserMapper weworkUserMapper;
    @Autowired
    private MarketingJoinMapper marketingJoinMapper;
    @Autowired
    private MarketingQrcodeMapper marketingQrcodeMapper;
    @Autowired
    private MarketingPlanMapper marketingPlanMapper;
    @Autowired
    private WeworkContactMapper weworkContactMapper;
    @Autowired
    private TelAddFriendTaskDetailMapper telAddFriendTaskDetailMapper;
    @Resource
    private TelAddFriendTaskMapper telAddFriendTaskMapper;
    @Autowired
    private FriendLogService friendLogService;
    @Autowired
    private WelcomeService welcomeService;
    @Autowired
    private RemarkService remarkService;
    @Autowired
    private AttachTagService attachTagService;
    @Autowired
    private FriendFissionService friendFissionService;
    @Autowired
    private VipIdTranslateService vipIdTranslateService;
    @Autowired
    private QualityCheckService qualityCheckService;
    @Autowired
    private AddContactCallbackAdService addContactCallbackAdService;
    @Autowired
    private CustomerCenterService customerCenterService;
    @Autowired
    private ScrmBizService scrmBizService;
    @Autowired
    private ContactCenterService contactCenterService;
    @Autowired
    private CcCustomerInfoService ccCustomerInfoService;
    @Resource
    private UserMapper userMapper;
    @Autowired
    private VipFriendSendRecordMapper vipFriendSendRecordMapper;
    @Autowired
    private WeworkContactRelationMapper weworkContactRelationMapper;

    private void initMarketingPlan() {
        ReplyContext ctx = ReplyContextUtil.get();
        Long bizId = ctx.getBizId();
        String corpId = ctx.getCorpId();
        String state = ctx.getState();
        if (!StringUtils.isBlank((CharSequence)state)) {
            MarketingQrcode marketingQrcode = new MarketingQrcode();
            marketingQrcode.setBizId(bizId);
            marketingQrcode.setCorpId(corpId);
            marketingQrcode.setState(ctx.getState());
            marketingQrcode = (MarketingQrcode)this.marketingQrcodeMapper.selectOne((Object)marketingQrcode);
            if (marketingQrcode != null) {
                ctx.setChannelId(marketingQrcode.getChannelId());
                ctx.setPlanId(marketingQrcode.getPlanId());
                ctx.setPlanGroupId(marketingQrcode.getPlanGroupId());
                if (marketingQrcode.getIsDeleted() == 0) {
                    ctx.setPlanActive(true);
                } else {
                    ctx.setPlanActive(false);
                }
            } else {
                MarketingJoin marketingJoin = this.marketingJoinMapper.queryByQrcodeState(corpId, state);
                if (marketingJoin != null) {
                    ctx.setChannelId(marketingJoin.getChannelId());
                    ctx.setPlanId(marketingJoin.getPlanId());
                    ctx.setPlanGroupId(Long.valueOf(-1L));
                    ctx.setPlanActive(true);
                    ctx.setPContactId(marketingJoin.getContactId());
                }
            }
            if (ctx.getPlanId() != null) {
                MarketingPlan marketingPlan = (MarketingPlan)this.marketingPlanMapper.selectByPrimaryKey((Object)ctx.getPlanId());
                if (marketingPlan != null) {
                    ctx.setPlanName(marketingPlan.getName());
                    ctx.setPlanNum(marketingPlan.getNum());
                    ctx.setPlanType(marketingPlan.getType());
                    ctx.setIsFissionDraft(marketingPlan.getIsDraft().intValue());
                    ctx.setIsFissionDeleted(marketingPlan.getIsDeleted().intValue());
                    ctx.setIsFissionEnabled(marketingPlan.getIsEnabled().intValue());
                    if (this.friendFissionService.isMarketingEndTime(marketingPlan) || this.friendFissionService.isMarketingNoReward()) {
                        if (marketingPlan.getStatus() == 1) {
                            marketingPlan.setStatus(Integer.valueOf(2));
                            marketingPlan.setUpdateTime(new Date());
                            this.marketingPlanMapper.updateByPrimaryKeySelective((Object)marketingPlan);
                        }
                        ctx.setPlanActive(false);
                        ctx.setFissionEnd(true);
                    }
                }
                if (marketingPlan == null || marketingPlan.getIsDraft() == 1 || marketingPlan.getIsDeleted() == 1 || marketingPlan.getIsEnabled() == 0 || marketingPlan.getStatus() == 2) {
                    ctx.setPlanActive(false);
                }
            }
        }
    }

    private void initAdQrcode() {
        ReplyContext ctx = ReplyContextUtil.get();
        String state = ctx.getState();
        if (StringUtils.isNotBlank((CharSequence)state) && state.startsWith("AD_")) {
            ctx.setAdQrcode(true);
        }
    }

    private void initRadar() {
        ReplyContext ctx = ReplyContextUtil.get();
        String state = ctx.getState();
        if (StringUtils.isNotBlank((CharSequence)state) && state.startsWith("RD_")) {
            ctx.setRadar(true);
        }
    }

    public void initTelAddFriend() {
        String mobile;
        ReplyContext replyContext = ReplyContextUtil.get();
        String state = replyContext.getState();
        if (StringUtils.isNotEmpty((CharSequence)state)) {
            return;
        }
        String corpId = replyContext.getCorpId();
        Long bizId = replyContext.getBizId();
        String weworkUserNum = replyContext.getWeworkUserNum();
        String contactId = replyContext.getContactId();
        WeworkContact weworkContact = this.weworkContactMapper.queryWeworkContact(bizId, corpId, contactId);
        String string = mobile = weworkContact == null ? null : weworkContact.getMobile();
        if (StringUtils.isEmpty((CharSequence)mobile)) {
            log.warn("\u6839\u636ecorpId:{},contactId:{}\u672a\u67e5\u8be2\u5230\u624b\u673a\u53f7", (Object)corpId, (Object)contactId);
            return;
        }
        List telAddFriendTaskDetails = this.telAddFriendTaskDetailMapper.selectByCorpIdWeworkUserNumAndTel(corpId, weworkUserNum, mobile);
        if (CollectionUtils.isEmpty((Collection)telAddFriendTaskDetails)) {
            log.info("\u6839\u636ecorpId:{}, weworkUserNum:{}, tel:{}\u672a\u67e5\u8be2\u5230\u624b\u673a\u53f7\u52a0\u597d\u53cb\u4efb\u52a1", new Object[]{corpId, weworkUserNum, mobile});
            return;
        }
        TelAddFriendTaskDetail taskDetail = null;
        for (TelAddFriendTaskDetail detail : telAddFriendTaskDetails) {
            WeworkContactRelation weworkContactRelation;
            WeworkUser weworkUser;
            if (TelAddFriendStatus.EXPIRE.getStatus() == detail.getStatus().intValue()) {
                log.info("detail.num:{}\u5df2\u8fc7\u671f", (Object)detail.getNum());
                continue;
            }
            taskDetail = detail;
            detail.setStatus(Integer.valueOf(TelAddFriendStatus.SUCCESS.getStatus()));
            detail.setAddSuccessTime(new Date());
            detail.setContactId(contactId);
            if (detail.getStatus().intValue() == TelAddFriendStatus.SUCCESS.getStatus() && StringUtils.isNotBlank((CharSequence)detail.getContactId()) && StringUtils.isNotBlank((CharSequence)detail.getUserDigitId()) && (weworkUser = this.weworkUserMapper.queryWeworkUserByDigitId(detail.getUserDigitId())) != null && (weworkContactRelation = this.weworkContactRelationMapper.queryWeworkContactDetail(detail.getCorpId(), weworkUser.getWeworkUserId(), detail.getContactId())) != null) {
                detail.setAddSuccessTime(weworkContactRelation.getAddTime());
            }
            detail.setUpdateTime(new Date());
            this.telAddFriendTaskDetailMapper.updateByPrimaryKey((Object)detail);
            if (!StringUtils.isNotBlank((CharSequence)detail.getRequestId())) break;
            log.info("initTelAddFriend detailId:{}, requestId:{}", (Object)detail.getId(), (Object)detail.getRequestId());
            this.vipFriendSendRecordMapper.updateSuccessByRequestId(bizId, detail.getRequestId(), new Date(), TelAddFriendStatus.SUCCESS.getDesc());
            break;
        }
        if (taskDetail == null) {
            return;
        }
        replyContext.setTelAddFriend(true);
        replyContext.setMobile(mobile);
        replyContext.setTaskDetailId(taskDetail.getId());
        replyContext.setTelAddFriendTaskNum(taskDetail.getTaskNum());
        String customerNum = weworkContact.getCustomerNum();
        TelAddFriendTask telAddFriendTask = this.telAddFriendTaskMapper.selectByNum(taskDetail.getTaskNum());
        String taskName = telAddFriendTask == null ? null : telAddFriendTask.getTaskName();
        String taskNum = taskDetail.getTaskNum();
        replyContext.setTelAddFriendTaskName(taskName);
        Integer taskAddType = taskDetail.getAddType();
        CompletableFuture.runAsync(() -> {
            this.customerCenterService.saveAddMobile(bizId, customerNum, mobile, ModuleType.BATCH_ADD_FRIEND.getCode(), taskNum, taskName);
            if (Objects.nonNull(taskAddType) && taskAddType.equals(TelAddType.LEADS.getValue())) {
                return;
            }
            BizSimpleDto biz = this.scrmBizService.getById(bizId);
            log.info("\u6dfb\u52a0\u624b\u673a\u53f7\u5fae\u4fe1\u597d\u53cb\u6210\u529f,\u5c06\u624b\u673a\u53f7\u6dfb\u52a0\u5230\u7ebf\u7d22");
            if (biz.getIsOpenCrm() != 0) {
                String channelNums;
                ModMobileReq modMobileReq = new ModMobileReq();
                modMobileReq.setMobile1(mobile);
                modMobileReq.setName(weworkContact.getName());
                WeworkUser weworkUser = this.weworkUserMapper.queryWeworkUserByNum(weworkUserNum);
                Long userId = null;
                if (Objects.nonNull(weworkUser)) {
                    userId = this.userMapper.getUserIdByWeworkUserId(bizId, weworkUser.getWeworkUserId());
                }
                modMobileReq.setUserId(userId);
                modMobileReq.setBizId(bizId);
                modMobileReq.setWeworkUserNum(weworkContact.getNum());
                modMobileReq.setCustomerNum(customerNum);
                String string = channelNums = Objects.nonNull(telAddFriendTask) ? telAddFriendTask.getChannelNums() : null;
                if (StringUtils.isNotBlank((CharSequence)channelNums)) {
                    String channelNum = Arrays.stream(channelNums.split(",")).findAny().orElse(null);
                    modMobileReq.setChannelId(channelNum);
                }
                this.contactCenterService.makeCrmLeads(corpId, (Set)Sets.newHashSet((Object[])new String[]{mobile}), null, modMobileReq, weworkContact, null, false);
                this.ccCustomerInfoService.modCustomerMobiles(modMobileReq);
            }
        });
    }

    public void onAddExternalInit(AddExternalContact event) {
        ReplyContext ctx = ReplyContextUtil.get();
        String corpId = ctx.getCorpId();
        String msgType = ctx.getMsgType();
        String userId = event.getUserId();
        String externalUserId = event.getExternalUserId();
        Long timestamp = event.getCreateTime();
        String msgKey = msgType + ":" + corpId + ":" + userId + ":" + externalUserId + ":" + timestamp;
        if (!this.msgLock.locked(msgKey, 30L)) {
            log.info("Not locked, msgKey={}", (Object)msgKey);
            return;
        }
        WeworkUser weworkUser = this.weworkUserMapper.queryWeworkUserInfo(corpId, userId);
        String weworkUserNum = weworkUser.getNum();
        String weworkUserName = weworkUser.getName();
        ctx.setMsgKey(msgKey);
        ctx.setWeworkUserId(userId);
        ctx.setWeworkUserNum(weworkUserNum);
        ctx.setWeworkUserName(weworkUserName);
        ctx.setContactId(externalUserId);
        ctx.setTimestamp(new Date(timestamp * 1000L));
        ctx.setState(event.getState());
        ctx.setWelcomeCode(event.getWelcomeCode());
    }

    public void onAddHalfExternalInit(AddHalfExternalContact event) {
        ReplyContext ctx = ReplyContextUtil.get();
        String corpId = ctx.getCorpId();
        String msgType = ctx.getMsgType();
        String userId = event.getUserId();
        String externalUserId = event.getExternalUserId();
        Long timestamp = event.getCreateTime();
        String msgKey = msgType + ":" + corpId + ":" + userId + ":" + externalUserId + ":" + timestamp;
        if (!this.msgLock.locked(msgKey, 30L)) {
            log.info("Not locked, msgKey={}", (Object)msgKey);
            return;
        }
        WeworkUser weworkUser = this.weworkUserMapper.queryWeworkUserInfo(corpId, userId);
        String weworkUserNum = weworkUser.getNum();
        String weworkUserName = weworkUser.getName();
        ctx.setMsgKey(msgKey);
        ctx.setWeworkUserId(userId);
        ctx.setWeworkUserNum(weworkUserNum);
        ctx.setWeworkUserName(weworkUserName);
        ctx.setContactId(externalUserId);
        ctx.setTimestamp(new Date(timestamp * 1000L));
        ctx.setState(event.getState());
        ctx.setWelcomeCode(event.getWelcomeCode());
    }

    public void onAddExternalContact(AddExternalContact event) {
        ReplyContext ctx = ReplyContextUtil.get();
        if (this.friendLogService.isExist()) {
            return;
        }
        this.initAdQrcode();
        this.initRadar();
        if (!ctx.isAdQrcode() && !ctx.isRadar()) {
            this.initMarketingPlan();
            this.initTelAddFriend();
        }
        this.welcomeService.onAddExternalContact();
        this.remarkService.onAddExternalContact();
        this.attachTagService.onAddExternalContact();
        this.friendFissionService.incrInviteCount();
        this.addContactCallbackAdService.callbackEventToAd();
        this.vipIdTranslateService.onAddExternalContact();
        this.friendLogService.onAddExternalContact();
    }

    public void onAddHalfExternalContact(AddHalfExternalContact event) {
        ReplyContext ctx = ReplyContextUtil.get();
        this.initAdQrcode();
        this.initRadar();
        if (!ctx.isAdQrcode() && !ctx.isRadar()) {
            this.initMarketingPlan();
            this.initTelAddFriend();
        }
        this.welcomeService.onAddExternalContact();
        this.remarkService.onAddExternalContact();
        this.attachTagService.onAddExternalContact();
        this.friendFissionService.incrInviteCount();
        this.addContactCallbackAdService.callbackEventToAd();
        this.vipIdTranslateService.onAddExternalContact();
        this.friendLogService.onAddExternalContact();
    }

    public void onEditExternalContact(EditExternalContact event) {
        ReplyContext ctx = ReplyContextUtil.get();
        String corpId = ctx.getCorpId();
        String msgType = ctx.getMsgType();
        String userId = event.getUserId();
        String externalUserId = event.getExternalUserId();
        Long timestamp = event.getCreateTime();
        String msgKey = msgType + ":" + corpId + ":" + userId + ":" + externalUserId + ":" + timestamp;
        if (!this.msgLock.locked(msgKey, 30L)) {
            log.info("Not locked, msgKey={}", (Object)msgKey);
            return;
        }
        String weworkUserNum = this.weworkUserMapper.getNumByCorpIdAndWeworkUserId(corpId, userId);
        ctx.setMsgKey(msgKey);
        ctx.setWeworkUserId(userId);
        ctx.setWeworkUserNum(weworkUserNum);
        ctx.setContactId(externalUserId);
        ctx.setTimestamp(new Date(timestamp * 1000L));
    }

    public void onDelExternalContact(DelExternalContact event) {
        ReplyContext ctx = ReplyContextUtil.get();
        String corpId = ctx.getCorpId();
        String msgType = ctx.getMsgType();
        String userId = event.getUserId();
        String externalUserId = event.getExternalUserId();
        Long timestamp = event.getCreateTime();
        String msgKey = msgType + ":" + corpId + ":" + userId + ":" + externalUserId + ":" + timestamp;
        if (!this.msgLock.locked(msgKey, 30L)) {
            log.info("Not locked, msgKey={}", (Object)msgKey);
            return;
        }
        String weworkUserNum = this.weworkUserMapper.getNumByCorpIdAndWeworkUserId(corpId, userId);
        ctx.setMsgKey(msgKey);
        ctx.setWeworkUserId(userId);
        ctx.setWeworkUserNum(weworkUserNum);
        ctx.setContactId(externalUserId);
        ctx.setTimestamp(new Date(timestamp * 1000L));
        this.friendLogService.onDelExternalContact();
        this.qualityCheckService.handleDelContact(event);
    }

    public void onDelFollowUser(DelFollowUser event) {
        ReplyContext ctx = ReplyContextUtil.get();
        String corpId = ctx.getCorpId();
        String msgType = ctx.getMsgType();
        String userId = event.getUserId();
        String externalUserId = event.getExternalUserId();
        Long timestamp = event.getCreateTime();
        String msgKey = msgType + ":" + corpId + ":" + userId + ":" + externalUserId + ":" + timestamp;
        if (!this.msgLock.locked(msgKey, 30L)) {
            log.info("Not locked, msgKey={}", (Object)msgKey);
            return;
        }
        String weworkUserNum = this.weworkUserMapper.getNumByCorpIdAndWeworkUserId(corpId, userId);
        ctx.setMsgKey(msgKey);
        ctx.setWeworkUserId(userId);
        ctx.setWeworkUserNum(weworkUserNum);
        ctx.setContactId(externalUserId);
        ctx.setTimestamp(new Date(timestamp * 1000L));
        this.friendFissionService.onDelFollowUser();
        this.qualityCheckService.handleDelByContact(event);
    }

    public void onTransferFail(TransferFail event) {
        ReplyContext ctx = ReplyContextUtil.get();
        String corpId = ctx.getCorpId();
        String msgType = ctx.getMsgType();
        String userId = event.getUserId();
        String externalUserId = event.getExternalUserId();
        Long timestamp = event.getCreateTime();
        String msgKey = msgType + ":" + corpId + ":" + userId + ":" + externalUserId + ":" + timestamp;
        if (!this.msgLock.locked(msgKey, 30L)) {
            log.info("Not locked, msgKey={}", (Object)msgKey);
            return;
        }
        String weworkUserNum = this.weworkUserMapper.getNumByCorpIdAndWeworkUserId(corpId, userId);
        ctx.setMsgKey(msgKey);
        ctx.setWeworkUserId(userId);
        ctx.setWeworkUserNum(weworkUserNum);
        ctx.setContactId(externalUserId);
        ctx.setTimestamp(new Date(timestamp * 1000L));
    }
}

