/*
 * Decompiled with CFR 0.152.
 */
package com.kuaike.scrm.dynamicform.service.impl;

import cn.kinyun.crm.common.service.CrmLeadsService;
import cn.kinyun.crm.common.service.CrmProductLineService;
import com.alibaba.excel.EasyExcel;
import com.alibaba.excel.write.builder.ExcelWriterBuilder;
import com.alibaba.fastjson.JSON;
import com.google.common.base.Preconditions;
import com.google.common.base.Splitter;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.kuaike.common.errorcode.CommonErrorCode;
import com.kuaike.common.errorcode.UniverseErrorCode;
import com.kuaike.common.exception.BusinessException;
import com.kuaike.common.sqlbuilder.dto.PageDto;
import com.kuaike.common.utils.JacksonUtil;
import com.kuaike.common.utils.lang.BeanUtil;
import com.kuaike.scrm.common.dto.BaseDto;
import com.kuaike.scrm.common.dto.CurrentUserInfo;
import com.kuaike.scrm.common.enums.DynamicFormMoment;
import com.kuaike.scrm.common.service.ScrmBizService;
import com.kuaike.scrm.common.service.dto.resp.BizSimpleDto;
import com.kuaike.scrm.common.utils.DateUtil;
import com.kuaike.scrm.common.utils.LoginUtils;
import com.kuaike.scrm.dal.dynamicform.dto.QueryCustomerParams;
import com.kuaike.scrm.dal.dynamicform.entity.DynamicForm;
import com.kuaike.scrm.dal.dynamicform.entity.DynamicFormAccessLog;
import com.kuaike.scrm.dal.dynamicform.entity.DynamicFormRelease;
import com.kuaike.scrm.dal.dynamicform.entity.DynamicFormShare;
import com.kuaike.scrm.dal.dynamicform.entity.DynamicFormSubmit;
import com.kuaike.scrm.dal.dynamicform.mapper.DynamicFormAccessLogMapper;
import com.kuaike.scrm.dal.dynamicform.mapper.DynamicFormGroupMapper;
import com.kuaike.scrm.dal.dynamicform.mapper.DynamicFormMapper;
import com.kuaike.scrm.dal.dynamicform.mapper.DynamicFormReleaseMapper;
import com.kuaike.scrm.dal.dynamicform.mapper.DynamicFormShareMapper;
import com.kuaike.scrm.dal.dynamicform.mapper.DynamicFormSubmitMapper;
import com.kuaike.scrm.dal.dynamicform.mapper.DynamicFormTitleTagMapper;
import com.kuaike.scrm.dal.permission.entity.User;
import com.kuaike.scrm.dal.wework.entity.WeworkContact;
import com.kuaike.scrm.dal.wework.mapper.WeworkContactMapper;
import com.kuaike.scrm.dal.weworktag.mapper.WeworkTagMapper;
import com.kuaike.scrm.dynamicform.dto.CrmConfigDto;
import com.kuaike.scrm.dynamicform.dto.CrmCustomerAllocDto;
import com.kuaike.scrm.dynamicform.dto.CustomerListItemDto;
import com.kuaike.scrm.dynamicform.dto.DynamicValueDto;
import com.kuaike.scrm.dynamicform.dto.FormEleDto;
import com.kuaike.scrm.dynamicform.dto.FormStatisticDto;
import com.kuaike.scrm.dynamicform.dto.QueryCustomerListDto;
import com.kuaike.scrm.dynamicform.dto.QuerySubmitListDto;
import com.kuaike.scrm.dynamicform.dto.ShareListItemDto;
import com.kuaike.scrm.dynamicform.dto.StatisticInfoDto;
import com.kuaike.scrm.dynamicform.dto.SubmitDataDto;
import com.kuaike.scrm.dynamicform.dto.SubmitListItemDto;
import com.kuaike.scrm.dynamicform.service.DynamicFormService;
import com.kuaike.scrm.dynamicform.service.FormStatisticService;
import com.kuaike.scrm.system.service.UserService;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.poi.ss.usermodel.BorderStyle;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.Font;
import org.apache.poi.ss.usermodel.HorizontalAlignment;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.VerticalAlignment;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.xssf.usermodel.XSSFSheet;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.json.JacksonJsonParser;
import org.springframework.stereotype.Service;

@Service
public class FormStatisticServiceImpl
implements FormStatisticService {
    private static final Logger log = LoggerFactory.getLogger(FormStatisticServiceImpl.class);
    @Resource
    private DynamicFormMapper dynamicFormMapper;
    @Resource
    private DynamicFormReleaseMapper dynamicFormReleaseMapper;
    @Resource
    private DynamicFormAccessLogMapper dynamicFormAccessLogMapper;
    @Resource
    private DynamicFormGroupMapper dynamicFormGroupMapper;
    @Resource
    private DynamicFormShareMapper dynamicFormShareMapper;
    @Autowired
    private UserService userService;
    @Autowired
    private DynamicFormService dynamicFormService;
    @Resource
    private WeworkTagMapper weworkTagMapper;
    @Resource
    private DynamicFormSubmitMapper dynamicFormSubmitMapper;
    @Resource
    private DynamicFormTitleTagMapper dynamicFormTitleTagMapper;
    @Resource
    private WeworkContactMapper weworkContactMapper;
    @Autowired
    private CrmLeadsService crmLeadsService;
    @Autowired
    private CrmProductLineService crmProductLineService;
    @Autowired
    private ScrmBizService scrmBizService;

    @Override
    public StatisticInfoDto info(BaseDto params) {
        log.info("dynamic form statistic params: {}", (Object)params);
        CurrentUserInfo userInfo = LoginUtils.getCurrentUser();
        Preconditions.checkArgument((boolean)StringUtils.isNotBlank((CharSequence)params.getId()), (Object)"\u8868\u5355id\u4e0d\u80fd\u4e3a\u7a7a");
        DynamicFormRelease formRelease = new DynamicFormRelease();
        formRelease.setBizId(userInfo.getBizId());
        formRelease.setDynamicFormNum(params.getId());
        formRelease = (DynamicFormRelease)this.dynamicFormReleaseMapper.selectOne((Object)formRelease);
        if (formRelease == null) {
            return null;
        }
        StatisticInfoDto result = new StatisticInfoDto();
        Date todayStart = DateUtil.getTodayStartTime();
        Date todayEnd = DateUtil.getTodayEndTime();
        int todayOpenCount = this.dynamicFormAccessLogMapper.queryOpenCount(userInfo.getBizId(), params.getId(), todayStart, todayEnd);
        int todaySubmitCount = this.dynamicFormAccessLogMapper.querySubmitCount(userInfo.getBizId(), params.getId(), todayStart, todayEnd);
        String todaySubmitPercent = "0.00%";
        NumberFormat numberFormat = NumberFormat.getPercentInstance();
        numberFormat.setMaximumFractionDigits(2);
        if (todayOpenCount != 0 && todaySubmitCount != 0) {
            todaySubmitPercent = numberFormat.format((double)todaySubmitCount * 1.0 / (double)todayOpenCount);
        }
        int openCount = this.dynamicFormAccessLogMapper.queryOpenCount(userInfo.getBizId(), params.getId(), null, null);
        int submitCount = this.dynamicFormAccessLogMapper.querySubmitCount(userInfo.getBizId(), params.getId(), null, null);
        String submitPercent = "0.00%";
        if (openCount != 0 && submitCount != 0) {
            submitPercent = numberFormat.format((double)submitCount * 1.0 / (double)openCount);
        }
        result.setId(formRelease.getDynamicFormNum());
        result.setTodayOpenCount(todayOpenCount);
        result.setTodaySubmitCount(todaySubmitCount);
        result.setTodaySubmitPercent(todaySubmitPercent);
        result.setOpenCount(openCount);
        result.setSubmitCount(submitCount);
        result.setSubmitPercent(submitPercent);
        DynamicForm dynamicForm = new DynamicForm();
        dynamicForm.setBizId(userInfo.getBizId());
        dynamicForm.setNum(params.getId());
        dynamicForm = (DynamicForm)this.dynamicFormMapper.selectOne((Object)dynamicForm);
        Map userMap = this.userService.getUserIdAndNameByUserIds((Set)Sets.newHashSet((Object[])new Long[]{dynamicForm.getCreateBy()}));
        result.setCreateTime(dynamicForm.getCreateTime());
        result.setCreateBy((String)userMap.get(dynamicForm.getCreateBy()));
        if (formRelease.getValidType() == 1) {
            result.setDeadline(formRelease.getDeadline());
        }
        Map groupMap = this.dynamicFormGroupMapper.queryGroupNameMap(userInfo.getBizId(), (Collection)Lists.newArrayList((Object[])new String[]{formRelease.getGroupNum()}));
        result.setGroupName((String)groupMap.get(formRelease.getGroupNum()));
        result.setSubmitLimit(formRelease.getSubmitLimit());
        result.setSendRemind(formRelease.getSendRemind());
        result.setWriteFollow(formRelease.getWriteFollow());
        if (formRelease.getAttachTag() == 1) {
            result.setAccessTags(this.dynamicFormService.getDynamicFormTags(userInfo.getBizId(), formRelease.getDynamicFormNum(), DynamicFormMoment.OPEN_FORM.getValue()));
            result.setSubmitTags(this.dynamicFormService.getDynamicFormTags(userInfo.getBizId(), formRelease.getDynamicFormNum(), DynamicFormMoment.SUBMIT_FORM.getValue()));
        } else {
            result.setAccessTags(Lists.newArrayList());
            result.setSubmitTags(Lists.newArrayList());
        }
        result.setSkip(formRelease.getSkip());
        if (result.getSkip() == 1) {
            result.setSkipType(formRelease.getSkipType());
            result.setSkipUrl(formRelease.getSkipUrl());
            result.setSkipDesc(formRelease.getSkipDesc());
        }
        return result;
    }

    @Override
    public List<CustomerListItemDto> customerList(QueryCustomerListDto params) {
        List uniqIds;
        log.info("dynamic form customer list params: {}", (Object)params);
        CurrentUserInfo userInfo = LoginUtils.getCurrentUser();
        Long bizId = userInfo.getBizId();
        String corpId = userInfo.getCorpId();
        Preconditions.checkArgument((boolean)StringUtils.isNotBlank((CharSequence)params.getId()), (Object)"\u8868\u5355id\u4e0d\u80fd\u4e3a\u7a7a");
        QueryCustomerParams queryParams = (QueryCustomerParams)BeanUtil.convert((Object)params, QueryCustomerParams.class, (String[])new String[0]);
        queryParams.setDynamicFormNum(params.getId());
        queryParams.setBizId(userInfo.getBizId());
        PageDto pageDto = params.getPageDto();
        if (pageDto != null) {
            int count = this.dynamicFormAccessLogMapper.queryCustomerCount(queryParams);
            pageDto.setCount(Integer.valueOf(count));
        }
        if (CollectionUtils.isEmpty((Collection)(uniqIds = this.dynamicFormAccessLogMapper.queryCustomerList(queryParams)))) {
            return Lists.newArrayList();
        }
        List list = this.dynamicFormAccessLogMapper.queryCustomerLastLog(bizId, params.getId(), (Collection)uniqIds);
        Map accessLogMap = list.stream().collect(Collectors.toMap(DynamicFormAccessLog::getUniqId, Function.identity()));
        Map shareNumsMap = this.dynamicFormAccessLogMapper.queryCustomerOfShareNums(bizId, params.getId(), (Collection)uniqIds);
        Map submitCountMap = this.dynamicFormAccessLogMapper.queryCustomerSubmitCount(bizId, params.getId(), (Collection)uniqIds);
        Map shareUserMap = this.dynamicFormShareMapper.queryShareUserIdMap(bizId, params.getId());
        Map shareUserNameMap = this.userService.getUserIdAndNameByUserIds(shareUserMap.values().stream().collect(Collectors.toSet()));
        Set contactIds = list.stream().filter(it -> StringUtils.isNotBlank((CharSequence)it.getContactId())).map(it -> it.getContactId()).collect(Collectors.toSet());
        List weworkContacts = this.weworkContactMapper.queryWeworkContactList(corpId, contactIds);
        Map<String, WeworkContact> contactId2Entity = weworkContacts.stream().collect(Collectors.toMap(WeworkContact::getContactId, a -> a));
        Map<String, String> tagDtoMap = this.getTagMap(userInfo.getCorpId(), list);
        ArrayList result = Lists.newArrayListWithCapacity((int)list.size());
        for (String uniqId : uniqIds) {
            WeworkContact weworkContact;
            DynamicFormAccessLog accessLog = (DynamicFormAccessLog)accessLogMap.get(uniqId);
            CustomerListItemDto dto = new CustomerListItemDto();
            dto.setUniqId(uniqId);
            dto.setNickname(accessLog.getNickname());
            dto.setAvatar(accessLog.getAvatar());
            dto.setContactId(accessLog.getContactId());
            dto.setCity(accessLog.getCity());
            dto.setIp(accessLog.getIp());
            if (StringUtils.isNotBlank((CharSequence)dto.getContactId()) && Objects.nonNull(weworkContact = contactId2Entity.get(dto.getContactId()))) {
                dto.setCorpName(weworkContact.getCorpName());
                dto.setCustomerNum(weworkContact.getCustomerNum());
            }
            List shareNums = (List)shareNumsMap.get(uniqId);
            ArrayList shareNames = Lists.newArrayList();
            for (String shareNum : shareNums) {
                String shareName = (String)shareUserNameMap.get(shareUserMap.get(shareNum));
                shareNames.add(shareName);
            }
            dto.setShareNames(shareNames);
            ArrayList tagNames = Lists.newArrayList();
            List<String> formTags = this.getTag(accessLog, tagDtoMap);
            List<String> formTitleTags = this.getDynamicFormTitleTag(bizId, corpId, accessLog.getNum(), params.getId());
            log.info("dynamic form customerList formTags :{}, formTitleTags: {}", formTags, formTitleTags);
            if (CollectionUtils.isNotEmpty(formTags)) {
                tagNames.addAll(formTags);
            }
            if (CollectionUtils.isNotEmpty(formTitleTags)) {
                tagNames.addAll(formTitleTags);
            }
            dto.setTags(tagNames);
            dto.setSubmitCount(submitCountMap.getOrDefault(uniqId, 0));
            if (dto.getSubmitCount() > 0) {
                dto.setSubmitTime(this.dynamicFormAccessLogMapper.queryCustomerLastSubmitTime(bizId, params.getId(), uniqId));
            }
            result.add(dto);
        }
        return result;
    }

    @Override
    public List<String> customerCityList(BaseDto params) {
        CurrentUserInfo userInfo = LoginUtils.getCurrentUser();
        Long bizId = userInfo.getBizId();
        Preconditions.checkArgument((boolean)StringUtils.isNotBlank((CharSequence)params.getId()), (Object)"\u8868\u5355id\u4e0d\u80fd\u4e3a\u7a7a");
        List cityList = this.dynamicFormAccessLogMapper.queryCustomerCityList(bizId, params.getId());
        return cityList.stream().filter(StringUtils::isNotBlank).collect(Collectors.toList());
    }

    private Map<String, String> getTagMap(String corpId, List<DynamicFormAccessLog> list) {
        HashSet tagIds = Sets.newHashSet();
        for (DynamicFormAccessLog it : list) {
            String accessTagIds = it.getAccessTagIds();
            String submitTagIds = it.getSubmitTagIds();
            if (StringUtils.isNotBlank((CharSequence)accessTagIds)) {
                tagIds.addAll(Splitter.on((String)",").splitToList((CharSequence)accessTagIds));
            }
            if (!StringUtils.isNotBlank((CharSequence)submitTagIds)) continue;
            tagIds.addAll(Splitter.on((String)",").splitToList((CharSequence)submitTagIds));
        }
        return this.weworkTagMapper.queryTagIdAndName(corpId, (Collection)tagIds);
    }

    private List<String> getTag(DynamicFormAccessLog accessLog, Map<String, String> tagDtoMap) {
        String accessTagIds = accessLog.getAccessTagIds();
        String submitTagIds = accessLog.getSubmitTagIds();
        HashSet tagIds = Sets.newHashSet();
        if (StringUtils.isNotBlank((CharSequence)accessTagIds)) {
            tagIds.addAll(Splitter.on((String)",").splitToList((CharSequence)accessTagIds));
        }
        if (StringUtils.isNotBlank((CharSequence)submitTagIds)) {
            tagIds.addAll(Splitter.on((String)",").splitToList((CharSequence)submitTagIds));
        }
        ArrayList tags = Lists.newArrayList();
        for (String tagId : tagIds) {
            tags.add(tagDtoMap.get(tagId));
        }
        return tags;
    }

    private List<String> getDynamicFormTitleTag(Long bizId, String corpId, String accessLogNum, String dynamicNum) {
        log.info("getDynamicFormTitleTag bizId: {}, corpId: {}, accessLogNum: {}, dynamicNum: {}", new Object[]{bizId, corpId, accessLogNum, dynamicNum});
        List submitList = this.dynamicFormSubmitMapper.querySubmitByAccessNum(bizId, accessLogNum);
        if (CollectionUtils.isEmpty((Collection)submitList)) {
            return Collections.emptyList();
        }
        ArrayList tagIds = Lists.newArrayList();
        for (DynamicFormSubmit submit : submitList) {
            String key = submit.getFormKey();
            String value = submit.getFormValue();
            log.info("getDynamicFormTitleTag key: {}, value: {}", (Object)key, (Object)value);
            DynamicValueDto dto = null;
            try {
                dto = (DynamicValueDto)JSON.parseObject((String)value, DynamicValueDto.class);
            }
            catch (Exception e) {
                log.error("getDynamicFormTitleTag e", (Throwable)e);
            }
            ArrayList titles = Lists.newArrayList();
            if (dto != null) {
                String titleValue = dto.getVal();
                log.info("getDynamicFormTitleTag titleValue: {}", (Object)titleValue);
                if (StringUtils.isNotBlank((CharSequence)titleValue)) {
                    if (titleValue.contains(",")) {
                        String[] titleList = titleValue.split(",");
                        titles.addAll(Arrays.asList(titleList));
                    } else {
                        titles.add(titleValue);
                    }
                }
            } else {
                log.info("getDynamicFormTitleTag dto is null");
            }
            log.info("getDynamicFormTitleTag get key: {} titles: {}", (Object)key, (Object)titles);
            List tags = this.dynamicFormTitleTagMapper.queryTagsByTypeAndValues(bizId, dynamicNum, key, (List)titles);
            if (!CollectionUtils.isNotEmpty((Collection)tags)) continue;
            tagIds.addAll(tags);
        }
        if (CollectionUtils.isEmpty((Collection)tagIds)) {
            return Collections.emptyList();
        }
        ArrayList tagNames = Lists.newArrayList();
        Map tagMaps = this.weworkTagMapper.queryTagIdAndName(corpId, (Collection)tagIds);
        log.info("addTitleTagAndAttachTag get tagIds: {}, tagMaps: {}", (Object)tagIds, (Object)tagMaps);
        for (Map.Entry entry : tagMaps.entrySet()) {
            String tagId = (String)entry.getKey();
            String tagName = (String)tagMaps.get(tagId);
            tagNames.add(tagName);
        }
        return tagNames;
    }

    @Override
    public List<SubmitListItemDto> submitList(QuerySubmitListDto params) {
        log.info("dynamic form submit list params: {}", (Object)params);
        CurrentUserInfo userInfo = LoginUtils.getCurrentUser();
        Preconditions.checkArgument((boolean)StringUtils.isNotBlank((CharSequence)params.getId()), (Object)"\u8868\u5355id\u4e0d\u80fd\u4e3a\u7a7a");
        Preconditions.checkArgument((boolean)StringUtils.isNotBlank((CharSequence)params.getUniqId()), (Object)"\u5ba2\u6237\u6807\u8bc6id\u4e0d\u80fd\u4e3a\u7a7a");
        List list = this.dynamicFormAccessLogMapper.queryCustomerOfSubmitLog(userInfo.getBizId(), params.getId(), params.getUniqId());
        ArrayList result = Lists.newArrayListWithCapacity((int)list.size());
        for (DynamicFormAccessLog it : list) {
            SubmitListItemDto dto = new SubmitListItemDto();
            dto.setId(it.getNum());
            dto.setSubmitTime(it.getUpdateTime());
            long costTime = (it.getUpdateTime().getTime() - it.getCreateTime().getTime()) / 1000L;
            dto.setCostTime(costTime);
            List submitList = this.dynamicFormSubmitMapper.querySubmitByAccessNum(userInfo.getBizId(), it.getNum());
            ArrayList submitDataDtos = Lists.newArrayList();
            for (DynamicFormSubmit submit : submitList) {
                SubmitDataDto submitDataDto = new SubmitDataDto();
                submitDataDto.setKey(submit.getFormKey());
                submitDataDto.setValue(submit.getFormValue());
                submitDataDtos.add(submitDataDto);
            }
            dto.setSubmitList(submitDataDtos);
            result.add(dto);
        }
        return result;
    }

    @Override
    public List<ShareListItemDto> shareList(BaseDto params) {
        log.info("dynamic form share list params: {}", (Object)params);
        CurrentUserInfo userInfo = LoginUtils.getCurrentUser();
        Preconditions.checkArgument((boolean)StringUtils.isNotBlank((CharSequence)params.getId()), (Object)"\u8868\u5355id\u4e0d\u80fd\u4e3a\u7a7a");
        PageDto pageDto = params.getPageDto();
        if (pageDto != null) {
            int count = this.dynamicFormShareMapper.queryShareCount(userInfo.getBizId(), params.getId(), params.getName());
            pageDto.setCount(Integer.valueOf(count));
        }
        List list = this.dynamicFormShareMapper.queryShareList(userInfo.getBizId(), params.getId(), params.getName(), pageDto);
        ArrayList result = Lists.newArrayListWithCapacity((int)list.size());
        Set userIds = list.stream().map(DynamicFormShare::getUserId).collect(Collectors.toSet());
        Map userMap = this.userService.queryUserMap(userIds);
        Set shareNums = list.stream().map(DynamicFormShare::getNum).collect(Collectors.toSet());
        Map openCountMap = this.dynamicFormAccessLogMapper.batchQueryCount(userInfo.getBizId(), null, shareNums);
        Map submitCountMap = this.dynamicFormAccessLogMapper.batchQueryCount(userInfo.getBizId(), Integer.valueOf(1), shareNums);
        Map openPersonCountMap = this.dynamicFormAccessLogMapper.batchQueryPersonCount(userInfo.getBizId(), null, shareNums);
        Map submitPersonCountMap = this.dynamicFormAccessLogMapper.batchQueryPersonCount(userInfo.getBizId(), Integer.valueOf(1), shareNums);
        for (DynamicFormShare formShare : list) {
            ShareListItemDto dto = new ShareListItemDto();
            User user = (User)userMap.get(formShare.getUserId());
            dto.setName(user.getName());
            dto.setAvatar(user.getAvatar());
            dto.setClickCount(openCountMap.getOrDefault(formShare.getNum(), 0));
            dto.setSubmitCount(submitCountMap.getOrDefault(formShare.getNum(), 0));
            dto.setClickPersonCount(openPersonCountMap.getOrDefault(formShare.getNum(), 0));
            dto.setSubmitPersonCount(submitPersonCountMap.getOrDefault(formShare.getNum(), 0));
            result.add(dto);
        }
        return result;
    }

    @Override
    public FormStatisticDto statistic(BaseDto params) {
        log.info("dynamic form sidebar statistic params: {}", (Object)params);
        CurrentUserInfo userInfo = LoginUtils.getCurrentUser();
        Preconditions.checkArgument((boolean)StringUtils.isNotBlank((CharSequence)params.getId()), (Object)"\u8868\u5355id\u4e0d\u80fd\u4e3a\u7a7a");
        DynamicFormRelease formRelease = new DynamicFormRelease();
        formRelease.setBizId(userInfo.getBizId());
        formRelease.setDynamicFormNum(params.getId());
        formRelease = (DynamicFormRelease)this.dynamicFormReleaseMapper.selectOne((Object)formRelease);
        if (formRelease == null) {
            return new FormStatisticDto();
        }
        FormStatisticDto result = new FormStatisticDto();
        result.setId(formRelease.getDynamicFormNum());
        Date todayStart = DateUtil.getTodayStartTime();
        Date todayEnd = DateUtil.getTodayEndTime();
        int todayOpenCount = this.dynamicFormAccessLogMapper.queryOpenCount(userInfo.getBizId(), params.getId(), todayStart, todayEnd);
        int todaySubmitCount = this.dynamicFormAccessLogMapper.querySubmitCount(userInfo.getBizId(), params.getId(), todayStart, todayEnd);
        int openCount = this.dynamicFormAccessLogMapper.queryOpenCount(userInfo.getBizId(), params.getId(), null, null);
        int submitCount = this.dynamicFormAccessLogMapper.querySubmitCount(userInfo.getBizId(), params.getId(), null, null);
        result.setTodayOpenCount(todayOpenCount);
        result.setTodaySubmitCount(todaySubmitCount);
        result.setOpenCount(openCount);
        result.setSubmitCount(submitCount);
        return result;
    }

    @Override
    public List<CrmCustomerAllocDto> queryCrmAllocList(QueryCustomerListDto params) {
        List accessLogList;
        Preconditions.checkArgument((boolean)StringUtils.isNotBlank((CharSequence)params.getId()), (Object)"\u8868\u5355id\u4e0d\u80fd\u4e3a\u7a7a");
        CurrentUserInfo userInfo = LoginUtils.getCurrentUser();
        DynamicForm dynamicForm = new DynamicForm();
        dynamicForm.setNum(params.getId());
        dynamicForm = (DynamicForm)this.dynamicFormMapper.selectOne((Object)dynamicForm);
        if (dynamicForm.getLeadsSyncSwitch() != null && dynamicForm.getLeadsSyncSwitch() == 0) {
            return Lists.newArrayList();
        }
        QueryCustomerParams queryParams = (QueryCustomerParams)BeanUtil.convert((Object)params, QueryCustomerParams.class, (String[])new String[0]);
        queryParams.setDynamicFormNum(params.getId());
        queryParams.setBizId(userInfo.getBizId());
        String productLineNum = null;
        BizSimpleDto biz = this.scrmBizService.getById(userInfo.getBizId());
        if (StringUtils.isBlank((CharSequence)dynamicForm.getCrmConfig())) {
            if (biz.getIsOpenCrm() == 1) {
                productLineNum = this.crmProductLineService.validateProductLineNum(userInfo.getBizId(), null);
            }
        } else {
            CrmConfigDto crmConfigDto = null;
            try {
                crmConfigDto = (CrmConfigDto)JacksonUtil.str2Obj((String)dynamicForm.getCrmConfig(), CrmConfigDto.class);
            }
            catch (IOException e) {
                log.error("crmConfigDto json parse error: {}", (Object)crmConfigDto, (Object)e);
            }
            if (crmConfigDto == null) {
                return Lists.newArrayList();
            }
            productLineNum = crmConfigDto.getCrmProductLine();
        }
        int total = this.dynamicFormAccessLogMapper.formAccessLogCrmAllocCount(queryParams);
        PageDto pageDto = params.getPageDto();
        if (pageDto != null) {
            pageDto.setCount(Integer.valueOf(total));
        }
        if (CollectionUtils.isEmpty((Collection)(accessLogList = this.dynamicFormAccessLogMapper.formAccessLogCrmAllocPage(queryParams)))) {
            return Lists.newArrayList();
        }
        List leadsNum = accessLogList.stream().filter(it -> StringUtils.isNotBlank((CharSequence)it.getCrmAlloc())).map(it -> it.getCrmAlloc()).collect(Collectors.toList());
        Map crmAllocMap = new HashMap();
        if (CollectionUtils.isNotEmpty(leadsNum) && biz.getIsOpenCrm() == 1) {
            crmAllocMap = this.crmLeadsService.getAllocTarget(userInfo.getBizId(), productLineNum, leadsNum);
        }
        List list = this.dynamicFormSubmitMapper.querySubmitByFormNum(userInfo.getBizId(), params.getId());
        Map<String, List<DynamicFormSubmit>> formSubmitGroup = list.stream().collect(Collectors.groupingBy(DynamicFormSubmit::getDynamicFormAccessLogNum));
        Set contactIds = accessLogList.stream().filter(it -> StringUtils.isNotBlank((CharSequence)it.getContactId())).map(it -> it.getContactId()).collect(Collectors.toSet());
        List weworkContacts = this.weworkContactMapper.queryWeworkContactList(userInfo.getCorpId(), contactIds);
        Map<String, WeworkContact> contactId2Entity = weworkContacts.stream().collect(Collectors.toMap(WeworkContact::getContactId, a -> a));
        ArrayList result = Lists.newArrayList();
        for (DynamicFormAccessLog accessLog : accessLogList) {
            WeworkContact weworkContact;
            CrmCustomerAllocDto allocDto = new CrmCustomerAllocDto();
            allocDto.setNickname(accessLog.getNickname());
            if (StringUtils.isNotBlank((CharSequence)accessLog.getContactId()) && Objects.nonNull(weworkContact = contactId2Entity.get(accessLog.getContactId()))) {
                allocDto.setCorpName(weworkContact.getCorpName());
                allocDto.setCustomerNum(weworkContact.getCustomerNum());
            }
            allocDto.setAvatar(accessLog.getAvatar());
            allocDto.setCity(accessLog.getCity());
            allocDto.setIp(accessLog.getIp());
            allocDto.setContactId(accessLog.getContactId());
            allocDto.setSubmitTime(accessLog.getUpdateTime());
            ArrayList submitList = Lists.newArrayList();
            List<DynamicFormSubmit> formSubmits = formSubmitGroup.get(accessLog.getNum());
            for (DynamicFormSubmit formSubmit : formSubmits) {
                SubmitDataDto dto = new SubmitDataDto();
                dto.setKey(formSubmit.getFormKey());
                dto.setValue(JSON.parseObject((String)formSubmit.getFormValue()).getString("val"));
                submitList.add(dto);
            }
            allocDto.setSubmitList(submitList);
            if (accessLog.getCrmAlloc() != null && accessLog.getCrmAlloc().equals("-1")) {
                allocDto.setCrmAlloc("\u5ba2\u6237\u5df2\u5b58\u5728");
            } else if (StringUtils.isNotBlank((CharSequence)accessLog.getCrmAlloc())) {
                allocDto.setCrmAlloc((String)crmAllocMap.get(accessLog.getCrmAlloc()));
            }
            result.add(allocDto);
        }
        return result;
    }

    @Override
    public void export(String id, HttpServletResponse response) {
        Preconditions.checkArgument((boolean)StringUtils.isNotBlank((CharSequence)id), (Object)"\u8868\u5355id\u4e0d\u80fd\u4e3a\u7a7a");
        CurrentUserInfo userInfo = LoginUtils.getCurrentUser();
        DynamicFormSubmit query = new DynamicFormSubmit();
        query.setBizId(userInfo.getBizId());
        query.setDynamicFormNum(id);
        List submitList = this.dynamicFormSubmitMapper.select((Object)query);
        Map<String, List<DynamicFormSubmit>> submitMap = submitList.stream().collect(Collectors.groupingBy(DynamicFormSubmit::getDynamicFormAccessLogNum));
        DynamicForm dynamicForm = new DynamicForm();
        dynamicForm.setBizId(userInfo.getBizId());
        dynamicForm.setNum(id);
        dynamicForm = (DynamicForm)this.dynamicFormMapper.selectOne((Object)dynamicForm);
        if (dynamicForm == null) {
            throw new BusinessException((UniverseErrorCode)CommonErrorCode.PARAM_ERROR, "\u627e\u4e0d\u5230\u8868\u5355\u8bb0\u5f55");
        }
        List accessLogList = this.dynamicFormAccessLogMapper.queryLogListByDynamicFormNum(userInfo.getBizId(), id);
        try {
            List formEleDtos = JacksonUtil.str2List((String)dynamicForm.getFormStruct(), FormEleDto.class);
            String fileName = dynamicForm.getName() + "\u8868\u5355\u63d0\u4ea4\u5185\u5bb9.xlsx";
            this.doPrint(response, "\u8868\u5355\u63d0\u4ea4\u5185\u5bb9", fileName, formEleDtos, submitMap, accessLogList);
        }
        catch (Exception e) {
            log.error("export dynamic form error: ", (Throwable)e);
        }
    }

    @Override
    public void exportAlloc(String id, HttpServletResponse response) {
        Preconditions.checkArgument((boolean)StringUtils.isNotBlank((CharSequence)id), (Object)"\u8868\u5355id\u4e0d\u80fd\u4e3a\u7a7a");
        CurrentUserInfo userInfo = LoginUtils.getCurrentUser();
        QueryCustomerListDto params = new QueryCustomerListDto();
        params.setId(id);
        List<CrmCustomerAllocDto> data = this.queryCrmAllocList(params);
        DynamicForm dynamicForm = new DynamicForm();
        dynamicForm.setBizId(userInfo.getBizId());
        dynamicForm.setNum(id);
        dynamicForm = (DynamicForm)this.dynamicFormMapper.selectOne((Object)dynamicForm);
        if (dynamicForm == null) {
            throw new BusinessException((UniverseErrorCode)CommonErrorCode.PARAM_ERROR, "\u627e\u4e0d\u5230\u8868\u5355\u8bb0\u5f55");
        }
        String fileName = dynamicForm.getName() + "-crm\u5ba2\u6237\u5206\u914d.xlsx";
        try {
            List formEleDtos = JacksonUtil.str2List((String)dynamicForm.getFormStruct(), FormEleDto.class);
            OutputStream fileWriter = this.getWebOutputStream(response, fileName);
            ArrayList heads = Lists.newArrayList();
            ArrayList head1 = Lists.newArrayList((Object[])new String[]{"\u5ba2\u6237"});
            ArrayList head2 = Lists.newArrayList((Object[])new String[]{"\u57ce\u5e02"});
            ArrayList head3 = Lists.newArrayList((Object[])new String[]{"ip"});
            heads.add(head1);
            heads.add(head2);
            heads.add(head3);
            for (FormEleDto eleDto : formEleDtos) {
                ArrayList head = Lists.newArrayList((Object[])new String[]{eleDto.getName()});
                heads.add(head);
            }
            ArrayList head4 = Lists.newArrayList((Object[])new String[]{"\u63d0\u4ea4\u65f6\u95f4"});
            ArrayList head5 = Lists.newArrayList((Object[])new String[]{"\u5206\u914d\u60c5\u51b5"});
            heads.add(head4);
            heads.add(head5);
            HashMap genderValueMap = Maps.newHashMap();
            genderValueMap.put("0", "\u672a\u77e5");
            genderValueMap.put("1", "\u7537");
            genderValueMap.put("2", "\u5973");
            ArrayList table = Lists.newArrayList();
            for (CrmCustomerAllocDto allocDto : data) {
                ArrayList row = Lists.newArrayList();
                row.add(allocDto.getNickname());
                row.add(allocDto.getCity());
                row.add(allocDto.getIp());
                List<SubmitDataDto> submitList = allocDto.getSubmitList();
                HashMap<String, String> eleKeyValMap = new HashMap<String, String>();
                for (SubmitDataDto dataDto : submitList) {
                    eleKeyValMap.put(dataDto.getKey(), dataDto.getValue());
                }
                for (FormEleDto eleDto : formEleDtos) {
                    String value = (String)eleKeyValMap.get(eleDto.getKey());
                    if (eleDto.getKey().equals("gender")) {
                        value = (String)genderValueMap.get(value);
                    }
                    row.add(value);
                }
                row.add(DateUtil.dateToDateString((Date)allocDto.getSubmitTime()));
                row.add(allocDto.getCrmAlloc());
                table.add(row);
            }
            ((ExcelWriterBuilder)EasyExcel.write((OutputStream)fileWriter).head((List)heads)).sheet("sheet").doWrite((Collection)table);
        }
        catch (Exception e) {
            log.error("export crm alloc error: ", (Throwable)e);
        }
    }

    private OutputStream getWebOutputStream(HttpServletResponse response, String fileName) throws IOException {
        response.setContentType("application/vnd.openxmlformats-officedocument.spreadsheetml.sheet;charset=utf-8");
        response.setHeader("Cache-Control", "no-cache");
        response.setHeader("Pragma", "no-cache");
        response.setDateHeader("Expires", -1L);
        response.addHeader("Content-Disposition", "attachment; filename=\"" + new String(fileName.getBytes(), StandardCharsets.ISO_8859_1) + "\"");
        return response.getOutputStream();
    }

    private void doPrint(HttpServletResponse response, String sheetName, String fileName, List<FormEleDto> formHeads, Map<String, List<DynamicFormSubmit>> submitData, List<DynamicFormAccessLog> logList) throws IOException {
        Cell nCell;
        OutputStream fileWriter = this.getWebOutputStream(response, fileName);
        XSSFWorkbook wb = new XSSFWorkbook();
        XSSFSheet sheet = wb.createSheet(sheetName);
        int rowIndex = 0;
        int cellNo = 2;
        Row nRow = sheet.createRow(rowIndex++);
        nRow.setHeightInPoints(20.0f);
        boolean needAddRow = false;
        for (FormEleDto eleDto : formHeads) {
            if (eleDto.getRequired() == null || eleDto.getRequired() != 1) continue;
            sheet.setColumnWidth(cellNo, 2048);
            nCell = nRow.createCell(cellNo++);
            nCell.setCellValue("\u5fc5\u586b");
            needAddRow = true;
        }
        if (needAddRow) {
            nRow = sheet.createRow(rowIndex++);
        }
        CellStyle headerStyle = FormStatisticServiceImpl.getCellStyle((Workbook)wb, true);
        cellNo = 0;
        HashMap keyIndexMap = Maps.newHashMap();
        int length = 3072;
        sheet.setColumnWidth(cellNo, length);
        nCell = nRow.createCell(cellNo++);
        nCell.setCellValue("\u586b\u5199\u4eba");
        nCell.setCellStyle(headerStyle);
        length = 4096;
        sheet.setColumnWidth(cellNo, length);
        nCell = nRow.createCell(cellNo++);
        nCell.setCellValue("\u586b\u5199\u65f6\u95f4");
        nCell.setCellStyle(headerStyle);
        for (FormEleDto eleDto : formHeads) {
            keyIndexMap.put(eleDto.getKey(), cellNo);
            String name = eleDto.getName();
            length = name.length() * 4 * 256;
            length = Math.min(length, 15360);
            sheet.setColumnWidth(cellNo, length);
            nCell = nRow.createCell(cellNo++);
            nCell.setCellValue(name);
            nCell.setCellStyle(headerStyle);
        }
        JacksonJsonParser jsonParser = new JacksonJsonParser();
        for (DynamicFormAccessLog accessLog : logList) {
            String key = accessLog.getNum();
            List<DynamicFormSubmit> submitList = submitData.get(key);
            nRow = sheet.createRow(rowIndex++);
            String submitName = accessLog.getNickname();
            if (StringUtils.isBlank((CharSequence)accessLog.getContactId())) {
                submitName = "\u6e38\u5ba2";
                if (StringUtils.isNotBlank((CharSequence)accessLog.getIp())) {
                    submitName = "\u6e38\u5ba2\uff08" + accessLog.getIp() + "\uff09";
                }
            }
            String submitTime = DateUtil.dateToDateString((Date)accessLog.getUpdateTime());
            nCell = nRow.createCell(0);
            nCell.setCellValue(submitName);
            nCell = nRow.createCell(1);
            nCell.setCellValue(submitTime);
            for (DynamicFormSubmit formSubmit : submitList) {
                Object val;
                int cellIndex = keyIndexMap.getOrDefault(formSubmit.getFormKey(), -1);
                if (cellIndex == -1) continue;
                nCell = nRow.createCell(cellIndex);
                String value = formSubmit.getFormValue();
                if (!StringUtils.isNotBlank((CharSequence)value) || (val = jsonParser.parseMap(value).get("val")) == null) continue;
                nCell.setCellValue(val.toString());
            }
        }
        wb.write(fileWriter);
        wb.close();
    }

    private static CellStyle getCellStyle(Workbook wb, boolean bold) {
        CellStyle cellStyle = wb.createCellStyle();
        cellStyle.setAlignment(HorizontalAlignment.CENTER);
        cellStyle.setVerticalAlignment(VerticalAlignment.CENTER);
        cellStyle.setBorderBottom(BorderStyle.THIN);
        cellStyle.setBorderTop(BorderStyle.THIN);
        cellStyle.setBorderLeft(BorderStyle.THIN);
        cellStyle.setBorderRight(BorderStyle.THIN);
        cellStyle.setWrapText(true);
        Font font = wb.createFont();
        font.setFontName("\u9ed1\u4f53");
        font.setBold(bold);
        font.setFontHeightInPoints((short)12);
        cellStyle.setFont(font);
        return cellStyle;
    }
}

