/*
 * Decompiled with CFR 0.152.
 */
package cn.kinyun.scrm.contract.service.impl;

import cn.kinyun.scrm.contract.dto.VerifyMsg;
import cn.kinyun.scrm.contract.enums.PersonalVerifyStatusEnum;
import cn.kinyun.scrm.contract.service.CustomerVerifyService;
import com.alibaba.fastjson.JSONObject;
import com.kuaike.scrm.bjy.sdk.service.BjyPartnerService;
import com.kuaike.scrm.common.service.dto.resp.CustomerVerifyStatusDto;
import com.kuaike.scrm.common.utils.JacksonUtils;
import com.kuaike.scrm.common.utils.KafkaClientUtils;
import com.kuaike.scrm.dal.contract.entity.ContractCustomerVerifyInfo;
import com.kuaike.scrm.dal.contract.mapper.ContractCustomerVerifyInfoMapper;
import com.kuaike.scrm.dal.sms.entity.PartnerInfo;
import com.kuaike.scrm.dal.sms.mapper.PartnerInfoMapper;
import java.util.Date;
import java.util.Map;
import java.util.Objects;
import java.util.TreeMap;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

@Service
public class CustomerVerifyServiceImpl
implements CustomerVerifyService {
    private static final Logger log = LoggerFactory.getLogger(CustomerVerifyServiceImpl.class);
    @Resource
    private BjyPartnerService bjyPartnerService;
    @Resource
    private PartnerInfoMapper partnerInfoMapper;
    @Resource
    private ContractCustomerVerifyInfoMapper customerVerifyInfoMapper;
    @Resource
    private KafkaClientUtils kafkaClient;
    @Value(value="${app.contract.personCertInfoUrl}")
    private String personCertInfoUrl;
    @Value(value="${kafka.topic.verify_status}")
    private String customerVerifyStatusTopic;

    @Override
    public void handleCustomVerifyMsg(VerifyMsg verifyMsg) {
        Map headerParams;
        String verifyInfo;
        log.info("handleCustomVerifyMsg, verifyMsg:{}", (Object)verifyMsg);
        PartnerInfo partnerInfo = this.partnerInfoMapper.selectByPartnerId(verifyMsg.getPartnerId());
        if (Objects.isNull(partnerInfo)) {
            log.warn("\u6839\u636epartnerId:{}\u672a\u67e5\u8be2\u5230PartnerInfo", (Object)verifyMsg.getPartnerId());
            return;
        }
        ContractCustomerVerifyInfo customerVerifyInfo = this.customerVerifyInfoMapper.selectByBizIdAndCustomerId(partnerInfo.getBizId(), verifyMsg.getCustomerId());
        if (Objects.isNull(customerVerifyInfo)) {
            log.warn("\u6839\u636ebizId:{},customerId:{}\u672a\u67e5\u8be2\u5230ContractCustomerVerifyInfo", (Object)partnerInfo.getBizId(), (Object)verifyMsg.getCustomerId());
            return;
        }
        try {
            CustomerVerifyStatusDto statusDto = new CustomerVerifyStatusDto();
            statusDto.setBizId(partnerInfo.getBizId());
            statusDto.setCustomerId(verifyMsg.getCustomerId());
            statusDto.setVerifyStatus(Integer.valueOf(verifyMsg.getStatus().intValue() == PersonalVerifyStatusEnum.APPROVE_PASSED.getValue() ? 1 : 0));
            this.kafkaClient.sendMessage(this.customerVerifyStatusTopic, statusDto.getCustomerId(), JacksonUtils.getInstance().writeValueAsString((Object)statusDto));
        }
        catch (Exception e) {
            log.error("\u53d1\u9001\u6d88\u606f\u5230\u4e2a\u4eba\u5b9e\u540d\u8ba4\u8bc1\u72b6\u6001topic:{}\u5931\u8d25,", (Object)this.customerVerifyStatusTopic, (Object)e);
        }
        customerVerifyInfo.setTransactionNo(verifyMsg.getTransactionNo());
        customerVerifyInfo.setVerifyStatus(verifyMsg.getStatus());
        customerVerifyInfo.setCertStatus(verifyMsg.getCertStatus());
        customerVerifyInfo.setUpdateTime(new Date());
        if (PersonalVerifyStatusEnum.APPROVE_PASSED.getValue() == verifyMsg.getStatus().intValue() && StringUtils.isBlank((CharSequence)customerVerifyInfo.getVerifyInfo()) && StringUtils.isNotBlank((CharSequence)(verifyInfo = this.getCustomerVerifyInfo(partnerInfo, headerParams = this.bjyPartnerService.getBjyHeader(partnerInfo.getBizId(), partnerInfo.getCorpId()), verifyMsg.getTransactionNo())))) {
            customerVerifyInfo.setVerifyInfo(verifyInfo);
        }
        this.customerVerifyInfoMapper.updateByPrimaryKey((Object)customerVerifyInfo);
    }

    private String getCustomerVerifyInfo(PartnerInfo partnerInfo, Map<String, String> headerParams, String transactionNo) {
        JSONObject jsonObject;
        if (StringUtils.isBlank((CharSequence)transactionNo)) {
            return "";
        }
        TreeMap<String, String> queryParams = new TreeMap<String, String>();
        queryParams.put("transaction_no", transactionNo);
        queryParams.put("partner_id", partnerInfo.getPartnerId());
        queryParams.put("timestamp", String.valueOf(System.currentTimeMillis()));
        try {
            jsonObject = this.bjyPartnerService.bjyPost(this.personCertInfoUrl, queryParams, headerParams);
            log.info("getCustomerVerifyInfo result:{}", (Object)jsonObject);
        }
        catch (Exception ex) {
            log.error("\u8c03\u7528\u83b7\u53d6\u4e2a\u4eba\u5b9e\u540d\u8ba4\u8bc1\u4fe1\u606f\u63a5\u53e3\u5931\u8d25:", (Throwable)ex);
            return "";
        }
        int code = jsonObject.getIntValue("code");
        if (code != 0) {
            return "";
        }
        return jsonObject.getJSONObject("data").toJSONString();
    }
}

