/*
 * Decompiled with CFR 0.152.
 */
package cn.kinyun.scrm.contract.service.impl;

import cn.kinyun.customer.center.service.CcCustomerOrderService;
import cn.kinyun.scrm.contract.dto.ContractSignMsg;
import cn.kinyun.scrm.contract.dto.req.ContractListReqDto;
import cn.kinyun.scrm.contract.dto.req.ContractModReqDto;
import cn.kinyun.scrm.contract.dto.resp.ContractListRespDto;
import cn.kinyun.scrm.contract.enums.ContractStatusEnum;
import cn.kinyun.scrm.contract.service.ContractService;
import com.alibaba.fastjson.JSONObject;
import com.google.common.collect.Lists;
import com.kuaike.common.errorcode.CommonErrorCode;
import com.kuaike.common.errorcode.UniverseErrorCode;
import com.kuaike.common.exception.BusinessException;
import com.kuaike.scrm.common.dto.CurrentUserInfo;
import com.kuaike.scrm.common.enums.ContractStatus;
import com.kuaike.scrm.common.service.dto.resp.ContractStatusDto;
import com.kuaike.scrm.common.utils.DateUtil;
import com.kuaike.scrm.common.utils.JacksonUtils;
import com.kuaike.scrm.common.utils.KafkaClientUtils;
import com.kuaike.scrm.common.utils.LoginUtils;
import com.kuaike.scrm.dal.contract.dto.ContractQuery;
import com.kuaike.scrm.dal.contract.entity.ContractInfo;
import com.kuaike.scrm.dal.contract.entity.OrderContract;
import com.kuaike.scrm.dal.contract.mapper.ContractInfoMapper;
import com.kuaike.scrm.dal.contract.mapper.OrderContractMapper;
import com.kuaike.scrm.dal.sms.entity.PartnerInfo;
import com.kuaike.scrm.dal.sms.mapper.PartnerInfoMapper;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.math.NumberUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class ContractServiceImpl
implements ContractService {
    private static final Logger log = LoggerFactory.getLogger(ContractServiceImpl.class);
    @Resource
    private ContractInfoMapper contractInfoMapper;
    @Resource
    private PartnerInfoMapper partnerInfoMapper;
    @Resource
    private OrderContractMapper orderContractMapper;
    @Resource
    private KafkaClientUtils kafkaClient;
    @Value(value="${kafka.topic.contract_info}")
    private String contractInfoTopic;
    @Resource
    private CcCustomerOrderService customerOrderService;

    @Override
    public List<ContractListRespDto> list(ContractListReqDto reqDto) {
        CurrentUserInfo userInfo = LoginUtils.getCurrentUser();
        log.info("contract list reqDto:{}, operatorId:{}", (Object)reqDto, (Object)userInfo.getId());
        reqDto.validateParams();
        ContractQuery contractQuery = reqDto.convert2ContractQuery(userInfo.getBizId());
        List contractInfos = this.contractInfoMapper.selectListByQuery(contractQuery);
        if (CollectionUtils.isEmpty((Collection)contractInfos)) {
            return Collections.emptyList();
        }
        int count = this.contractInfoMapper.selectCountByQuery(contractQuery);
        reqDto.getPageDto().setCount(Integer.valueOf(count));
        ArrayList respDtos = Lists.newArrayList();
        for (ContractInfo contractInfo : contractInfos) {
            ContractListRespDto respDto = new ContractListRespDto();
            respDtos.add(respDto);
            BeanUtils.copyProperties((Object)contractInfo, (Object)respDto);
            ContractStatusEnum contractStatusEnum = ContractStatusEnum.get(contractInfo.getStatus());
            if (!Objects.nonNull((Object)contractStatusEnum)) continue;
            respDto.setStatusDesc(contractStatusEnum.getDesc());
        }
        return respDtos;
    }

    @Override
    public void updateRemark(ContractModReqDto reqDto) {
        CurrentUserInfo userInfo = LoginUtils.getCurrentUser();
        log.info("contract updateRemark reqDto:{}, operatorId:{}", (Object)reqDto, (Object)userInfo.getId());
        reqDto.validateParams();
        ContractInfo contractInfo = this.contractInfoMapper.selectByBizIdAndId(userInfo.getBizId(), reqDto.getId());
        if (Objects.isNull(contractInfo)) {
            log.warn("\u6839\u636ebizId:{}, contractInfoId:{}\u672a\u67e5\u8be2\u5230\u8bb0\u5f55", (Object)userInfo.getBizId(), (Object)reqDto.getId());
            return;
        }
        this.contractInfoMapper.updateRemarkById(reqDto.getRemark(), userInfo.getId(), contractInfo.getId());
    }

    @Override
    public void archive(ContractModReqDto reqDto) {
        CurrentUserInfo userInfo = LoginUtils.getCurrentUser();
        log.info("contract archive reqDto:{}, operatorId:{}", (Object)reqDto, (Object)userInfo.getId());
        reqDto.validateParams();
        ContractInfo contractInfo = this.contractInfoMapper.selectByBizIdAndId(userInfo.getBizId(), reqDto.getId());
        if (Objects.isNull(contractInfo)) {
            log.warn("\u6839\u636ebizId:{}, contractInfoId:{}\u672a\u67e5\u8be2\u5230\u8bb0\u5f55", (Object)userInfo.getBizId(), (Object)reqDto.getId());
            return;
        }
        log.info("\u5408\u540cid:{}\u7684\u72b6\u6001\u4e3a:{}", (Object)reqDto.getId(), (Object)contractInfo.getStatus());
        ContractStatusEnum contractStatusEnum = ContractStatusEnum.get(contractInfo.getStatus());
        if (Objects.isNull((Object)contractStatusEnum) || contractStatusEnum != ContractStatusEnum.SIGNED) {
            throw new BusinessException((UniverseErrorCode)CommonErrorCode.BUSINESS_ERROR, "\u3010\u5df2\u7b7e\u7f72\u3011\u72b6\u6001\u7684\u5408\u540c\u624d\u80fd\u8fdb\u884c\u5f52\u6863");
        }
        this.contractInfoMapper.updateStatusById(Integer.valueOf(ContractStatusEnum.ARCHIVED.getValue()), userInfo.getId(), contractInfo.getId());
        try {
            ContractStatusDto statusDto = new ContractStatusDto();
            statusDto.setBizId(contractInfo.getBizId());
            statusDto.setContractId(contractInfo.getContractId());
            statusDto.setCorpSignStatus(contractInfo.getCorpSignStatus());
            statusDto.setPersonalSignStatus(contractInfo.getPersonalSignStatus());
            statusDto.setIsArchived(contractInfo.getIsArchived());
            statusDto.setSignTime(contractInfo.getSignTime());
            statusDto.setStatus(Integer.valueOf(ContractStatusEnum.ARCHIVED.getValue()));
            this.kafkaClient.sendMessage(this.contractInfoTopic, statusDto.getContractId(), JacksonUtils.getInstance().writeValueAsString((Object)statusDto));
        }
        catch (Exception e) {
            log.error("\u53d1\u9001\u6d88\u606f\u5230\u5408\u540c\u7b7e\u7f72\u72b6\u6001topic:{}\u5931\u8d25,", (Object)this.contractInfoTopic, (Object)e);
        }
    }

    @Override
    public void handleSignCallbackMsg(String data) {
        log.info("handleSignCallbackMsg, data:{}", (Object)data);
        ContractSignMsg contractSignMsg = (ContractSignMsg)JSONObject.parseObject((String)data, ContractSignMsg.class);
        if (Objects.isNull(contractSignMsg)) {
            log.warn("\u5c06data\u8f6c\u6362\u6210ContractSignMsg\u5bf9\u8c61\u5931\u8d25");
            return;
        }
        PartnerInfo partnerInfo = this.partnerInfoMapper.selectByPartnerId(contractSignMsg.getPartnerId());
        if (Objects.isNull(partnerInfo)) {
            log.warn("\u6839\u636epartnerId:{}\u672a\u67e5\u8be2\u5230PartnerInfo", (Object)contractSignMsg.getPartnerId());
            return;
        }
        ContractInfo contractInfo = this.contractInfoMapper.selectByBizIdAndContractId(partnerInfo.getBizId(), contractSignMsg.getContractId());
        if (Objects.isNull(contractInfo)) {
            log.info("\u6839\u636econtractId:{}\u672a\u67e5\u8be2\u5230\u8bb0\u5f55", (Object)contractSignMsg.getContractId());
            return;
        }
        contractInfo.setCorpSignStatus(contractSignMsg.getVerifyStatusA());
        contractInfo.setPersonalSignStatus(contractSignMsg.getVerifyStatusB());
        contractInfo.setIsArchived(contractSignMsg.getStatus());
        contractInfo.setUpdateBy(NumberUtils.LONG_MINUS_ONE);
        contractInfo.setUpdateTime(new Date());
        contractInfo.setSignTime(contractSignMsg.getSignTime());
        if (StringUtils.isBlank((CharSequence)contractInfo.getSignTime())) {
            contractInfo.setSignTime(DateUtil.getNowTime((String)"yyyy-MM-dd"));
        }
        if (NumberUtils.INTEGER_ONE.equals(contractSignMsg.getVerifyStatusA()) && NumberUtils.INTEGER_ONE.equals(contractSignMsg.getVerifyStatusB())) {
            contractInfo.setStatus(Integer.valueOf(ContractStatus.SIGNED.getValue()));
        }
        this.contractInfoMapper.updateByPrimaryKey((Object)contractInfo);
        OrderContract orderContract = this.orderContractMapper.queryByBizIdAndContractId(partnerInfo.getBizId(), contractSignMsg.getContractId());
        if (orderContract != null) {
            orderContract.setCorpSignStatus(contractSignMsg.getVerifyStatusA());
            orderContract.setPersonalSignStatus(contractSignMsg.getVerifyStatusB());
            orderContract.setSignTime(contractSignMsg.getSignTime());
            if (NumberUtils.INTEGER_ONE.equals(contractSignMsg.getVerifyStatusA()) && NumberUtils.INTEGER_ONE.equals(contractSignMsg.getVerifyStatusB())) {
                contractInfo.setStatus(Integer.valueOf(ContractStatus.SIGNED.getValue()));
                this.customerOrderService.updateOrderContractSignStatus(orderContract.getOrderNo(), Integer.valueOf(ContractStatus.SIGNED.getValue()));
            }
            orderContract.setUpdateTime(new Date());
            this.orderContractMapper.updateByPrimaryKey((Object)orderContract);
        } else {
            try {
                ContractStatusDto statusDto = new ContractStatusDto();
                statusDto.setBizId(partnerInfo.getBizId());
                statusDto.setContractId(contractInfo.getContractId());
                statusDto.setCorpSignStatus(contractInfo.getCorpSignStatus());
                statusDto.setPersonalSignStatus(contractInfo.getPersonalSignStatus());
                statusDto.setIsArchived(contractInfo.getIsArchived());
                statusDto.setSignTime(contractInfo.getSignTime());
                statusDto.setStatus(contractInfo.getStatus());
                this.kafkaClient.sendMessage(this.contractInfoTopic, statusDto.getContractId(), JacksonUtils.getInstance().writeValueAsString((Object)statusDto));
            }
            catch (Exception e) {
                log.error("\u53d1\u9001\u6d88\u606f\u5230\u5408\u540c\u7b7e\u7f72\u72b6\u6001topic:{}\u5931\u8d25,", (Object)this.contractInfoTopic, (Object)e);
            }
        }
    }
}

