/*
 * Decompiled with CFR 0.152.
 */
package cn.kinyun.scrm.contract.service.impl;

import cn.kinyun.scrm.contract.dto.ContractConfig;
import com.alibaba.fastjson.JSONObject;
import com.google.common.base.Preconditions;
import com.kuaike.common.errorcode.CommonErrorCode;
import com.kuaike.common.errorcode.UniverseErrorCode;
import com.kuaike.common.exception.BusinessException;
import com.kuaike.common.utils.JacksonUtil;
import com.kuaike.scrm.bjy.sdk.service.BjyPartnerService;
import com.kuaike.scrm.common.service.AppInstallService;
import com.kuaike.scrm.dal.app.entity.AppBindings;
import com.kuaike.scrm.dal.app.mapper.AppBindingsMapper;
import com.kuaike.scrm.dal.sms.entity.PartnerInfo;
import java.io.IOException;
import java.util.Map;
import java.util.Objects;
import java.util.TreeMap;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.math.NumberUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

@Service
public class ContractAppInstallServiceImpl
implements AppInstallService {
    private static final Logger log = LoggerFactory.getLogger(ContractAppInstallServiceImpl.class);
    @Value(value="${app.contract.appCode}")
    private String appCode;
    @Value(value="${app.contract.defaultPrice}")
    private Integer defaultUnitPrice;
    @Value(value="${app.contract.openUrl}")
    private String openUrl;
    @Value(value="${scrm.domain.protocol}${scrm.domain.scrm-manager}")
    private String defaultCallbackDomain;
    @Resource
    private BjyPartnerService bjyPartnerService;
    @Autowired
    private AppBindingsMapper bindingsMapper;

    public String getAppCode() {
        return this.appCode;
    }

    public void install(AppBindings binding) {
        ContractConfig contractConfig;
        log.info("install contract binding:{}", (Object)binding);
        Integer unitPrice = this.defaultUnitPrice;
        if (0 == binding.getIsOpen()) {
            return;
        }
        if (StringUtils.isBlank((CharSequence)binding.getConfigJson())) {
            contractConfig = new ContractConfig();
            contractConfig.setUnitPrice(unitPrice);
            contractConfig.setCallbackHost(this.defaultCallbackDomain);
            binding.setConfigJson(JacksonUtil.obj2Str((Object)contractConfig));
        } else {
            try {
                log.info("addOrModBjySetting contract getConfigJson: {}", (Object)binding.getConfigJson());
                contractConfig = (ContractConfig)JacksonUtil.str2Obj((String)binding.getConfigJson(), ContractConfig.class);
                unitPrice = contractConfig.getUnitPrice();
                Preconditions.checkArgument((boolean)Objects.nonNull(unitPrice), (Object)"\u5408\u540c\u5355\u4ef7\u4e0d\u80fd\u4e3a\u7a7a");
                if (Objects.isNull(contractConfig.getVerifyPrice())) {
                    contractConfig.setVerifyPrice(NumberUtils.INTEGER_ZERO);
                }
                if (StringUtils.isBlank((CharSequence)contractConfig.getCallbackHost())) {
                    contractConfig.setCallbackHost(this.defaultCallbackDomain);
                }
                binding.setConfigJson(JacksonUtil.obj2Str((Object)contractConfig));
            }
            catch (IOException e) {
                log.error("configJson str2Obj error", (Throwable)e);
                throw new BusinessException((UniverseErrorCode)CommonErrorCode.BUSINESS_ERROR, "\u7535\u5b50\u5408\u540c\u4ef7\u683c\u53c2\u6570\u914d\u7f6e\u5f02\u5e38");
            }
        }
        log.info("install contract");
        Long bizId = binding.getBizId();
        PartnerInfo partnerInfo = this.bjyPartnerService.validPartner(bizId);
        if (StringUtils.isBlank((CharSequence)contractConfig.getCallbackHost())) {
            contractConfig.setCallbackHost("");
        }
        this.open(partnerInfo, contractConfig);
        this.bindingsMapper.updateByPrimaryKeySelective((Object)binding);
    }

    public void update(AppBindings bindings) {
        ContractConfig contractConfig;
        log.info("update contract bindings:{}", (Object)bindings);
        Long bizId = bindings.getBizId();
        try {
            if (StringUtils.isBlank((CharSequence)bindings.getConfigJson())) {
                return;
            }
            if (0 == bindings.getIsOpen()) {
                return;
            }
            contractConfig = (ContractConfig)JacksonUtil.str2Obj((String)bindings.getConfigJson(), ContractConfig.class);
            Preconditions.checkArgument((boolean)Objects.nonNull(contractConfig.getUnitPrice()), (Object)"\u5408\u540c\u5355\u4ef7\u4e0d\u80fd\u4e3a\u7a7a");
            if (Objects.isNull(contractConfig.getVerifyPrice())) {
                contractConfig.setVerifyPrice(NumberUtils.INTEGER_ZERO);
            }
            if (StringUtils.isBlank((CharSequence)contractConfig.getCallbackHost())) {
                contractConfig.setCallbackHost(this.defaultCallbackDomain);
            }
            bindings.setConfigJson(JacksonUtil.obj2Str((Object)contractConfig));
            this.bindingsMapper.updateByPrimaryKeySelective((Object)bindings);
        }
        catch (IOException e) {
            log.error("configJson str2Obj error", (Throwable)e);
            throw new BusinessException((UniverseErrorCode)CommonErrorCode.BUSINESS_ERROR, "\u5408\u540c\u4ef7\u683c\u53c2\u6570\u914d\u7f6e\u5f02\u5e38");
        }
        PartnerInfo partnerInfo = this.bjyPartnerService.validPartner(bizId);
        this.open(partnerInfo, contractConfig);
    }

    public void uninstall(AppBindings binding) {
        super.uninstall(binding);
    }

    private void open(PartnerInfo partnerInfo, ContractConfig contractConfig) {
        Map<String, String> params = this.getOpenParams(partnerInfo.getPartnerId(), contractConfig);
        try {
            JSONObject jsonObject = this.bjyPartnerService.bjyPost(this.openUrl, params, this.bjyPartnerService.getBjyHeader(partnerInfo.getBizId(), partnerInfo.getCorpId()));
            log.info("open contract params:{}, response:{}", params, (Object)jsonObject);
        }
        catch (Exception e) {
            log.error("open contract error", (Throwable)e);
            throw new BusinessException((UniverseErrorCode)CommonErrorCode.BUSINESS_ERROR, "\u5f00\u901a\u7535\u5b50\u5408\u540c\u5931\u8d25,\u8bf7\u7a0d\u540e\u91cd\u8bd5");
        }
    }

    private Map<String, String> getOpenParams(String partnerId, ContractConfig contractConfig) {
        TreeMap<String, String> result = new TreeMap<String, String>();
        result.put("unit_price", String.valueOf(contractConfig.getUnitPrice()));
        result.put("verify_price", String.valueOf(contractConfig.getVerifyPrice()));
        result.put("partner_id", partnerId);
        result.put("callback_host", contractConfig.getCallbackHost());
        result.put("timestamp", String.valueOf(System.currentTimeMillis()));
        return result;
    }
}

