/*
 * Decompiled with CFR 0.152.
 */
package cn.kinyun.scrm.contract.service.impl;

import cn.kinyun.scrm.contract.dto.resp.CompanySignatureRespDto;
import cn.kinyun.scrm.contract.service.CompanySignatureService;
import com.alibaba.fastjson.JSONObject;
import com.google.common.collect.Maps;
import com.kuaike.common.errorcode.CommonErrorCode;
import com.kuaike.common.errorcode.UniverseErrorCode;
import com.kuaike.common.exception.BusinessException;
import com.kuaike.scrm.bjy.sdk.service.BjyPartnerService;
import com.kuaike.scrm.common.dto.CurrentUserInfo;
import com.kuaike.scrm.common.utils.LoginUtils;
import com.kuaike.scrm.dal.contract.entity.ContractCompanySignature;
import com.kuaike.scrm.dal.contract.mapper.ContractCompanySignatureMapper;
import com.kuaike.scrm.dal.sms.entity.PartnerInfo;
import java.util.Date;
import java.util.Map;
import java.util.Objects;
import java.util.TreeMap;
import javax.annotation.Resource;
import org.apache.commons.lang3.math.NumberUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

@Service
public class CompanySignatureServiceImpl
implements CompanySignatureService {
    private static final Logger log = LoggerFactory.getLogger(CompanySignatureServiceImpl.class);
    @Resource
    private BjyPartnerService bjyPartnerService;
    @Resource
    private ContractCompanySignatureMapper companySignatureMapper;
    @Value(value="${app.contract.createSignatureUrl}")
    private String createSignatureUrl;
    @Value(value="${app.contract.ossFullUrl}")
    private String ossFullUrl;

    @Override
    public void createCustomSignature(String companyName, String customerId, PartnerInfo partnerInfo, Map<String, String> headerParams) {
        log.info("createCustomSignature,companyName:{}, bizId:{}", (Object)companyName, (Object)partnerInfo.getBizId());
        ContractCompanySignature companySignature = this.companySignatureMapper.selectByBizId(partnerInfo.getBizId());
        if (Objects.nonNull(companySignature)) {
            log.info("\u5546\u6237id:{}\u5df2\u751f\u6210\u4f01\u4e1a\u5370\u7ae0", (Object)partnerInfo.getBizId());
            return;
        }
        String signatureImgUrl = this.createCustomSignatureAndGetImgUrl(companyName, customerId, partnerInfo, headerParams);
        companySignature = new ContractCompanySignature();
        companySignature.setBizId(partnerInfo.getBizId());
        companySignature.setCorpId(partnerInfo.getCorpId());
        companySignature.setSignatureImgUrl(signatureImgUrl);
        companySignature.setCreateBy(NumberUtils.LONG_MINUS_ONE);
        companySignature.setUpdateBy(NumberUtils.LONG_MINUS_ONE);
        Date curDate = new Date();
        companySignature.setCreateTime(curDate);
        companySignature.setUpdateTime(curDate);
        this.companySignatureMapper.insertOrIgnore(companySignature);
    }

    @Override
    public CompanySignatureRespDto detail() {
        CurrentUserInfo userInfo = LoginUtils.getCurrentUser();
        log.info("company signature detail, operatorId:{}", (Object)userInfo.getId());
        ContractCompanySignature companySignature = this.companySignatureMapper.selectByBizId(userInfo.getBizId());
        CompanySignatureRespDto companySignatureRespDto = new CompanySignatureRespDto();
        if (Objects.nonNull(companySignature)) {
            String fullUrl = this.getFullUrl(companySignature.getSignatureImgUrl());
            companySignatureRespDto.setSignatureImgUrl(fullUrl);
        }
        return companySignatureRespDto;
    }

    private String createCustomSignatureAndGetImgUrl(String companyName, String customerId, PartnerInfo partnerInfo, Map<String, String> headerParams) {
        JSONObject jsonObject;
        TreeMap<String, String> queryParams = new TreeMap<String, String>();
        queryParams.put("customer_id", customerId);
        queryParams.put("content", companyName);
        queryParams.put("partner_id", partnerInfo.getPartnerId());
        queryParams.put("timestamp", String.valueOf(System.currentTimeMillis()));
        try {
            jsonObject = this.bjyPartnerService.bjyPost(this.createSignatureUrl, queryParams, headerParams);
            log.info("createCustomSignature result:{}", (Object)jsonObject);
        }
        catch (Exception ex) {
            log.error("\u8c03\u7528\u751f\u6210\u4f01\u4e1a\u5370\u7ae0\u63a5\u53e3\u5931\u8d25:", (Throwable)ex);
            throw new BusinessException((UniverseErrorCode)CommonErrorCode.BUSINESS_ERROR, "\u8c03\u7528\u751f\u6210\u4f01\u4e1a\u5370\u7ae0\u63a5\u53e3\u5931\u8d25");
        }
        int code = jsonObject.getIntValue("code");
        if (code != 0) {
            throw new BusinessException((UniverseErrorCode)CommonErrorCode.BUSINESS_ERROR, "\u8c03\u7528\u751f\u6210\u4f01\u4e1a\u5370\u7ae0\u63a5\u53e3\u5931\u8d25");
        }
        return jsonObject.getJSONObject("data").getString("signature_img_url");
    }

    private String getFullUrl(String path) {
        JSONObject jsonObject;
        TreeMap<String, String> queryParams = new TreeMap<String, String>();
        queryParams.put("path", path);
        try {
            jsonObject = this.bjyPartnerService.bjyPost(this.ossFullUrl, queryParams, (Map)Maps.newHashMap());
            log.info("getFullUrl result:{}", (Object)jsonObject);
        }
        catch (Exception ex) {
            log.error("\u83b7\u53d6\u6587\u4ef6\u5b8c\u6574\u8def\u5f84\u5931\u8d25:", (Throwable)ex);
            throw new BusinessException((UniverseErrorCode)CommonErrorCode.BUSINESS_ERROR, "\u83b7\u53d6\u6587\u4ef6\u5b8c\u6574\u8def\u5f84\u5931\u8d25");
        }
        int code = jsonObject.getIntValue("code");
        if (code != 0) {
            throw new BusinessException((UniverseErrorCode)CommonErrorCode.BUSINESS_ERROR, "\u83b7\u53d6\u6587\u4ef6\u5b8c\u6574\u8def\u5f84\u5931\u8d25");
        }
        return jsonObject.getJSONObject("data").getString("full_url");
    }
}

