/*
 * Decompiled with CFR 0.152.
 */
package cn.kinyun.scrm.contract.dto.req;

import cn.kinyun.scrm.contract.enums.ContractTemplateTypeEnum;
import com.google.common.base.Preconditions;
import com.kuaike.common.sqlbuilder.dto.PageDto;
import com.kuaike.scrm.common.dto.CurrentUserInfo;
import com.kuaike.scrm.dal.contract.dto.ContractTemplateQuery;
import java.util.Objects;

public class ContractTemplateListReqDto {
    private Integer templateType;
    private String templateName;
    private PageDto pageDto;

    public void validateParams() {
        if (Objects.nonNull(this.templateType)) {
            ContractTemplateTypeEnum contractTemplateTypeEnum = ContractTemplateTypeEnum.get(this.templateType);
            Preconditions.checkArgument((boolean)Objects.nonNull((Object)contractTemplateTypeEnum), (Object)"\u8bf7\u6c42\u53c2\u6570\u4e0d\u5408\u6cd5");
        }
        Preconditions.checkArgument((boolean)Objects.nonNull(this.pageDto), (Object)"\u5206\u9875\u5bf9\u8c61\u4e0d\u80fd\u4e3a\u7a7a");
        Preconditions.checkArgument((boolean)Objects.nonNull(this.pageDto.getPageNum()), (Object)"\u5206\u9875\u9875\u7801\u4e0d\u80fd\u4e3a\u7a7a");
        Preconditions.checkArgument((boolean)Objects.nonNull(this.pageDto.getPageSize()), (Object)"\u5206\u9875\u5927\u5c0f\u4e0d\u80fd\u4e3a\u7a7a");
    }

    public ContractTemplateQuery convert2TemplateQuery(CurrentUserInfo userInfo) {
        ContractTemplateQuery contractTemplateQuery = new ContractTemplateQuery();
        contractTemplateQuery.setBizId(userInfo.getBizId());
        contractTemplateQuery.setTemplateType(this.templateType);
        contractTemplateQuery.setTemplateName(this.templateName);
        contractTemplateQuery.setOffset(Integer.valueOf((this.pageDto.getPageNum() - 1) * this.pageDto.getPageSize()));
        contractTemplateQuery.setLimit(this.pageDto.getPageSize());
        return contractTemplateQuery;
    }

    public Integer getTemplateType() {
        return this.templateType;
    }

    public String getTemplateName() {
        return this.templateName;
    }

    public PageDto getPageDto() {
        return this.pageDto;
    }

    public void setTemplateType(Integer templateType) {
        this.templateType = templateType;
    }

    public void setTemplateName(String templateName) {
        this.templateName = templateName;
    }

    public void setPageDto(PageDto pageDto) {
        this.pageDto = pageDto;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ContractTemplateListReqDto)) {
            return false;
        }
        ContractTemplateListReqDto other = (ContractTemplateListReqDto)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Integer this$templateType = this.getTemplateType();
        Integer other$templateType = other.getTemplateType();
        if (this$templateType == null ? other$templateType != null : !((Object)this$templateType).equals(other$templateType)) {
            return false;
        }
        String this$templateName = this.getTemplateName();
        String other$templateName = other.getTemplateName();
        if (this$templateName == null ? other$templateName != null : !this$templateName.equals(other$templateName)) {
            return false;
        }
        PageDto this$pageDto = this.getPageDto();
        PageDto other$pageDto = other.getPageDto();
        return !(this$pageDto == null ? other$pageDto != null : !this$pageDto.equals(other$pageDto));
    }

    protected boolean canEqual(Object other) {
        return other instanceof ContractTemplateListReqDto;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Integer $templateType = this.getTemplateType();
        result = result * 59 + ($templateType == null ? 43 : ((Object)$templateType).hashCode());
        String $templateName = this.getTemplateName();
        result = result * 59 + ($templateName == null ? 43 : $templateName.hashCode());
        PageDto $pageDto = this.getPageDto();
        result = result * 59 + ($pageDto == null ? 43 : $pageDto.hashCode());
        return result;
    }

    public String toString() {
        return "ContractTemplateListReqDto(templateType=" + this.getTemplateType() + ", templateName=" + this.getTemplateName() + ", pageDto=" + this.getPageDto() + ")";
    }
}

