/*
 * Decompiled with CFR 0.152.
 */
package cn.kinyun.scrm.contract.dto.req;

import cn.kinyun.scrm.contract.enums.ContractStatusEnum;
import com.google.common.base.Preconditions;
import com.kuaike.common.sqlbuilder.dto.PageDto;
import com.kuaike.scrm.dal.contract.dto.ContractQuery;
import java.util.Date;
import java.util.Objects;
import org.springframework.beans.BeanUtils;

public class ContractListReqDto {
    private Integer status;
    private Date createTimeBegin;
    private Date createTimeEnd;
    private String contractId;
    private String customerName;
    private PageDto pageDto;

    public void validateParams() {
        Preconditions.checkArgument((boolean)Objects.nonNull(this.pageDto), (Object)"\u5206\u9875\u5bf9\u8c61\u4e0d\u80fd\u4e3a\u7a7a");
        Preconditions.checkArgument((boolean)Objects.nonNull(this.pageDto.getPageSize()), (Object)"\u5206\u9875\u5927\u5c0f\u4e0d\u80fd\u4e3a\u7a7a");
        Preconditions.checkArgument((boolean)Objects.nonNull(this.pageDto.getPageNum()), (Object)"\u5206\u9875\u9875\u7801\u4e0d\u80fd\u4e3a\u7a7a");
        if (Objects.nonNull(this.status)) {
            ContractStatusEnum contractStatusEnum = ContractStatusEnum.get(this.status);
            Preconditions.checkArgument((boolean)Objects.nonNull((Object)contractStatusEnum), (Object)"\u8bf7\u6c42\u53c2\u6570\u4e0d\u5408\u6cd5");
        }
    }

    public ContractQuery convert2ContractQuery(Long bizId) {
        ContractQuery contractQuery = new ContractQuery();
        BeanUtils.copyProperties((Object)this, (Object)contractQuery);
        contractQuery.setBizId(bizId);
        contractQuery.setOffset(Integer.valueOf((this.pageDto.getPageNum() - 1) * this.pageDto.getPageSize()));
        contractQuery.setLimit(this.pageDto.getPageSize());
        return contractQuery;
    }

    public Integer getStatus() {
        return this.status;
    }

    public Date getCreateTimeBegin() {
        return this.createTimeBegin;
    }

    public Date getCreateTimeEnd() {
        return this.createTimeEnd;
    }

    public String getContractId() {
        return this.contractId;
    }

    public String getCustomerName() {
        return this.customerName;
    }

    public PageDto getPageDto() {
        return this.pageDto;
    }

    public void setStatus(Integer status) {
        this.status = status;
    }

    public void setCreateTimeBegin(Date createTimeBegin) {
        this.createTimeBegin = createTimeBegin;
    }

    public void setCreateTimeEnd(Date createTimeEnd) {
        this.createTimeEnd = createTimeEnd;
    }

    public void setContractId(String contractId) {
        this.contractId = contractId;
    }

    public void setCustomerName(String customerName) {
        this.customerName = customerName;
    }

    public void setPageDto(PageDto pageDto) {
        this.pageDto = pageDto;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ContractListReqDto)) {
            return false;
        }
        ContractListReqDto other = (ContractListReqDto)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Integer this$status = this.getStatus();
        Integer other$status = other.getStatus();
        if (this$status == null ? other$status != null : !((Object)this$status).equals(other$status)) {
            return false;
        }
        Date this$createTimeBegin = this.getCreateTimeBegin();
        Date other$createTimeBegin = other.getCreateTimeBegin();
        if (this$createTimeBegin == null ? other$createTimeBegin != null : !((Object)this$createTimeBegin).equals(other$createTimeBegin)) {
            return false;
        }
        Date this$createTimeEnd = this.getCreateTimeEnd();
        Date other$createTimeEnd = other.getCreateTimeEnd();
        if (this$createTimeEnd == null ? other$createTimeEnd != null : !((Object)this$createTimeEnd).equals(other$createTimeEnd)) {
            return false;
        }
        String this$contractId = this.getContractId();
        String other$contractId = other.getContractId();
        if (this$contractId == null ? other$contractId != null : !this$contractId.equals(other$contractId)) {
            return false;
        }
        String this$customerName = this.getCustomerName();
        String other$customerName = other.getCustomerName();
        if (this$customerName == null ? other$customerName != null : !this$customerName.equals(other$customerName)) {
            return false;
        }
        PageDto this$pageDto = this.getPageDto();
        PageDto other$pageDto = other.getPageDto();
        return !(this$pageDto == null ? other$pageDto != null : !this$pageDto.equals(other$pageDto));
    }

    protected boolean canEqual(Object other) {
        return other instanceof ContractListReqDto;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Integer $status = this.getStatus();
        result = result * 59 + ($status == null ? 43 : ((Object)$status).hashCode());
        Date $createTimeBegin = this.getCreateTimeBegin();
        result = result * 59 + ($createTimeBegin == null ? 43 : ((Object)$createTimeBegin).hashCode());
        Date $createTimeEnd = this.getCreateTimeEnd();
        result = result * 59 + ($createTimeEnd == null ? 43 : ((Object)$createTimeEnd).hashCode());
        String $contractId = this.getContractId();
        result = result * 59 + ($contractId == null ? 43 : $contractId.hashCode());
        String $customerName = this.getCustomerName();
        result = result * 59 + ($customerName == null ? 43 : $customerName.hashCode());
        PageDto $pageDto = this.getPageDto();
        result = result * 59 + ($pageDto == null ? 43 : $pageDto.hashCode());
        return result;
    }

    public String toString() {
        return "ContractListReqDto(status=" + this.getStatus() + ", createTimeBegin=" + this.getCreateTimeBegin() + ", createTimeEnd=" + this.getCreateTimeEnd() + ", contractId=" + this.getContractId() + ", customerName=" + this.getCustomerName() + ", pageDto=" + this.getPageDto() + ")";
    }
}

