/*
 * Decompiled with CFR 0.152.
 */
package com.kuaike.scrm.chat.service.impl;

import com.google.common.collect.Lists;
import com.kuaike.scrm.chat.dto.TransferUserDto;
import com.kuaike.scrm.chat.dto.message.MessageReqDto;
import com.kuaike.scrm.chat.service.DimissionChatService;
import com.kuaike.scrm.chat.service.SidebarChatService;
import com.kuaike.scrm.chat.service.WeworkMessageService;
import com.kuaike.scrm.common.dto.ContactIdDto;
import com.kuaike.scrm.common.dto.CurrentUserInfo;
import com.kuaike.scrm.common.dto.MessageListRespDto;
import com.kuaike.scrm.common.utils.LoginUtils;
import com.kuaike.scrm.dal.agent.mapper.AgentDecryptWeworkContactIdMapper;
import com.kuaike.scrm.dal.agent.mapper.AgentDecryptWeworkUserIdMapper;
import com.kuaike.scrm.dal.wework.entity.WeworkCorp;
import com.kuaike.scrm.dal.wework.entity.WeworkUser;
import com.kuaike.scrm.dal.wework.mapper.WeworkCorpMapper;
import com.kuaike.scrm.dal.wework.mapper.WeworkUserMapper;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class SidebarChatServiceImpl
implements SidebarChatService {
    private static final Logger log = LoggerFactory.getLogger(SidebarChatServiceImpl.class);
    @Resource
    private WeworkUserMapper weworkUserMapper;
    @Autowired
    private DimissionChatService dimissionChatService;
    @Autowired
    private WeworkMessageService weworkMessageService;
    @Resource
    private WeworkCorpMapper weworkCorpMapper;
    @Resource
    private AgentDecryptWeworkUserIdMapper agentDecryptWeworkUserIdMapper;
    @Resource
    private AgentDecryptWeworkContactIdMapper agentDecryptWeworkContactIdMapper;

    @Override
    public List<TransferUserDto> getTransferList(ContactIdDto params) {
        List<TransferUserDto> result = this.dimissionChatService.getTransferUserList(params);
        CurrentUserInfo userInfo = LoginUtils.getCurrentUser();
        Long bizId = userInfo.getBizId();
        WeworkUser weworkUser = this.weworkUserMapper.queryWeworkUserByNum(userInfo.getWeworkUserNum());
        TransferUserDto userDto = new TransferUserDto();
        userDto.setWeworkUserId(weworkUser.getNum());
        userDto.setAvatar(weworkUser.getAvatar());
        userDto.setName(weworkUser.getName());
        userDto.setIsDimission(0);
        int useAgent = this.queryNewDKF(bizId);
        String weworkUserId = weworkUser.getWeworkUserId();
        String contactId = params.getContactId();
        if (useAgent == 1) {
            weworkUserId = this.agentDecryptWeworkUserIdMapper.queryByEncryptUserId(bizId, weworkUserId);
            contactId = this.agentDecryptWeworkContactIdMapper.queryByEncryptContactId(bizId, contactId);
        }
        if (StringUtils.isNotBlank((CharSequence)weworkUserId) && StringUtils.isNotBlank((CharSequence)contactId)) {
            String conversationId = Lists.newArrayList((Object[])new String[]{weworkUserId, contactId}).stream().sorted().collect(Collectors.joining("$$"));
            userDto.setConversationId(conversationId);
            result.add(userDto);
        }
        return result;
    }

    @Override
    public MessageListRespDto getMessageList(MessageReqDto params) {
        params.fillDefaultValue();
        params.setCorpId(LoginUtils.getCurrentUserCorpId());
        params.setBizId(LoginUtils.getCurrentUserBizId());
        return this.weworkMessageService.messageList(params);
    }

    private Integer queryNewDKF(Long bizId) {
        WeworkCorp weworkCorp = this.weworkCorpMapper.getByBizId(bizId);
        return Objects.equals(weworkCorp.getIsNewDkf(), 1) ? 1 : 0;
    }
}

