/*
 * Decompiled with CFR 0.152.
 */
package com.kuaike.scrm.chat.check;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.kuaike.scrm.chat.check.MatchedType;
import com.kuaike.scrm.chat.check.MatchedWord;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class WordTree
implements Serializable {
    private static final long serialVersionUID = 1L;
    public static final int MIN_MATCH_TYPE = 1;
    public static final int MAX_MATCH_TYPE = 2;
    private boolean isEnd;
    private long[] groupIds;
    private int groupIdIndex;
    private HashMap<Character, WordTree> next = new HashMap();

    public WordTree() {
    }

    public WordTree(Collection<String> words, long groupId) {
        for (String word : words) {
            this.addWord(word, groupId);
        }
    }

    public void addWords(Collection<String> words, long groupId) {
        for (String word : words) {
            this.addWord(word, groupId);
        }
    }

    public void addWord(String word, long groupId) {
        if (word == null || word.isEmpty()) {
            return;
        }
        WordTree cur = this;
        int len = word.length();
        for (int i = 0; i < len; ++i) {
            char keyChar = word.charAt(i);
            WordTree wordTree = cur.next.get(Character.valueOf(keyChar));
            if (wordTree == null) {
                wordTree = new WordTree();
                cur.next.put(Character.valueOf(keyChar), wordTree);
            }
            cur = wordTree;
            if (i != len - 1) continue;
            cur.isEnd = true;
            if (cur.groupIds == null) {
                cur.groupIds = new long[]{groupId};
            } else {
                Set set = Arrays.stream(cur.groupIds).distinct().collect(HashSet::new, Set::add, Set::addAll);
                set.add(groupId);
                cur.groupIds = set.stream().mapToLong(a -> a).toArray();
            }
            ++this.groupIdIndex;
        }
    }

    @JsonIgnore
    public boolean isEmpty() {
        return this.next.isEmpty();
    }

    public int checkWord(String txt, int beginIndex, int matchType) {
        char word;
        boolean flag = false;
        WordTree cur = this;
        int length = txt.length();
        int curLength = 0;
        for (int i = beginIndex; !(i >= length || (cur = cur.next.get(Character.valueOf(word = txt.charAt(i)))) == null || flag && 1 == matchType); ++i) {
            ++curLength;
            if (!cur.isEnd) continue;
            flag = true;
        }
        if (!flag) {
            curLength = 0;
        }
        return curLength;
    }

    public boolean isContaintWord(String txt) {
        if (txt == null || txt.isEmpty()) {
            return false;
        }
        if (this.next.isEmpty()) {
            return false;
        }
        boolean flag = false;
        for (int i = 0; i < txt.length(); ++i) {
            int matchFlag = this.checkWord(txt, i, 1);
            if (matchFlag <= 0) continue;
            flag = true;
        }
        return flag;
    }

    public List<MatchedWord> getMatchedWords(String txt) {
        ArrayList matched = Lists.newArrayList();
        if (txt == null || txt.isEmpty()) {
            return Collections.emptyList();
        }
        if (this.next.isEmpty()) {
            return Collections.emptyList();
        }
        int length = txt.length();
        for (int i = 0; i < length; ++i) {
            char word;
            WordTree cur = this;
            int curLength = 0;
            for (int k = i; k < length && (cur = cur.next.get(Character.valueOf(word = txt.charAt(k)))) != null; ++k) {
                ++curLength;
                if (!cur.isEnd) continue;
                String curWord = txt.substring(i, i + curLength);
                MatchedWord matchedWord = cur.getMatchedWord(curLength, i, curWord);
                matched.add(matchedWord);
            }
        }
        return Lists.newArrayList((Iterable)matched);
    }

    private MatchedWord getMatchedWord(int curLength, int beginIndex, String curWord) {
        MatchedWord matchedWord = new MatchedWord();
        matchedWord.setWord(curWord);
        matchedWord.setStart(beginIndex);
        matchedWord.setEnd(beginIndex + curLength);
        HashSet matchedTypes = Sets.newHashSet();
        for (long groupId : this.groupIds) {
            MatchedType type = new MatchedType();
            type.setGroupId(groupId);
            matchedTypes.add(type);
        }
        matchedWord.setTypes(matchedTypes);
        return matchedWord;
    }

    public boolean isEnd() {
        return this.isEnd;
    }

    public long[] getGroupIds() {
        return this.groupIds;
    }

    public int getGroupIdIndex() {
        return this.groupIdIndex;
    }

    public HashMap<Character, WordTree> getNext() {
        return this.next;
    }

    public void setEnd(boolean isEnd) {
        this.isEnd = isEnd;
    }

    public void setGroupIds(long[] groupIds) {
        this.groupIds = groupIds;
    }

    public void setGroupIdIndex(int groupIdIndex) {
        this.groupIdIndex = groupIdIndex;
    }

    public void setNext(HashMap<Character, WordTree> next) {
        this.next = next;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof WordTree)) {
            return false;
        }
        WordTree other = (WordTree)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.isEnd() != other.isEnd()) {
            return false;
        }
        if (this.getGroupIdIndex() != other.getGroupIdIndex()) {
            return false;
        }
        if (!Arrays.equals(this.getGroupIds(), other.getGroupIds())) {
            return false;
        }
        HashMap<Character, WordTree> this$next = this.getNext();
        HashMap<Character, WordTree> other$next = other.getNext();
        return !(this$next == null ? other$next != null : !((Object)this$next).equals(other$next));
    }

    protected boolean canEqual(Object other) {
        return other instanceof WordTree;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.isEnd() ? 79 : 97);
        result = result * 59 + this.getGroupIdIndex();
        result = result * 59 + Arrays.hashCode(this.getGroupIds());
        HashMap<Character, WordTree> $next = this.getNext();
        result = result * 59 + ($next == null ? 43 : ((Object)$next).hashCode());
        return result;
    }

    public String toString() {
        return "WordTree(isEnd=" + this.isEnd() + ", groupIds=" + Arrays.toString(this.getGroupIds()) + ", groupIdIndex=" + this.getGroupIdIndex() + ", next=" + this.getNext() + ")";
    }
}

