/*
 * Decompiled with CFR 0.152.
 */
package com.kuaike.scrm.chat.utils;

import cn.kinyun.wework.sdk.api.chat.ChatApi;
import cn.kinyun.wework.sdk.api.chat.ChatApiBuilder;
import cn.kinyun.wework.sdk.api.chat.ChatApiFactory;
import com.google.common.base.Preconditions;
import com.kuaike.scrm.dal.chat.dto.ChatConfigDto;
import java.io.IOException;
import java.util.List;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ChatMessageUtil {
    private static final Logger log = LoggerFactory.getLogger(ChatMessageUtil.class);
    public static final String MSG_ACTION_RECALL = "recall";
    public static final String MSG_ACTION_SEND = "send";
    private static final Object LOCK = new Object();

    private ChatMessageUtil() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ChatApi getChatApi(List<ChatConfigDto> chatConfigDtos) throws IOException {
        Preconditions.checkArgument((boolean)CollectionUtils.isNotEmpty(chatConfigDtos), (Object)"chatConfigDtos not empty");
        Object object = LOCK;
        synchronized (object) {
            ChatConfigDto configDto = chatConfigDtos.get(0);
            ChatApi api = ChatApiFactory.get((String)configDto.getCorpId());
            if (api != null) {
                api.setProxy(ChatMessageUtil.getProxy(configDto));
                return api;
            }
            ChatApiBuilder apiBuilder = ChatApi.builder().corpId(configDto.getCorpId()).secret(configDto.getSecret()).proxy(ChatMessageUtil.getProxy(configDto));
            for (ChatConfigDto chatConfigDto : chatConfigDtos) {
                apiBuilder.addPrikey(chatConfigDto.getVersion().toString(), chatConfigDto.getPrivateKey());
            }
            api = apiBuilder.build();
            ChatApiFactory.put((ChatApi)api);
            return api;
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    private static String getProxy(ChatConfigDto configDto) {
        String proxyType;
        if (!StringUtils.isNotBlank((CharSequence)configDto.getProxyAddress()) || configDto.getProxyPort() == null || configDto.getProxyPort() <= 0) return null;
        log.info("corpId:{}, proxyType:{}, proxyAddress:{}, proxyPort:{}", new Object[]{configDto.getCorpId(), configDto.getProxyType(), configDto.getProxyAddress(), configDto.getProxyPort()});
        if (StringUtils.isNotBlank((CharSequence)configDto.getProxyType())) {
            String type = configDto.getProxyType().trim();
            if ("HTTP".equalsIgnoreCase(type)) {
                proxyType = "http";
                return String.format("%s://%s:%d", proxyType, configDto.getProxyAddress().trim(), configDto.getProxyPort());
            } else {
                if (!"SOCKS5".equalsIgnoreCase(type)) {
                    log.error("corpId:{}, proxyType:{} is illegal, support: http/sock5", (Object)configDto.getCorpId(), (Object)configDto.getProxyType());
                    return null;
                }
                proxyType = "socks5";
            }
            return String.format("%s://%s:%d", proxyType, configDto.getProxyAddress().trim(), configDto.getProxyPort());
        }
        proxyType = "http";
        return String.format("%s://%s:%d", proxyType, configDto.getProxyAddress().trim(), configDto.getProxyPort());
    }
}

