/*
 * Decompiled with CFR 0.152.
 */
package com.kuaike.scrm.chat.service.impl;

import cn.kinyun.wework.sdk.entity.chat.ChatMsg;
import cn.kinyun.wework.sdk.entity.chat.msg.Revoke;
import com.alibaba.fastjson.JSON;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.kuaike.common.errorcode.CommonErrorCode;
import com.kuaike.common.errorcode.UniverseErrorCode;
import com.kuaike.common.exception.BusinessException;
import com.kuaike.common.utils.JacksonUtil;
import com.kuaike.scrm.chat.dto.message.MessageDetailReqDto;
import com.kuaike.scrm.chat.dto.message.MessageReqDto;
import com.kuaike.scrm.chat.service.WeworkMessageService;
import com.kuaike.scrm.common.dto.CurrentUserInfo;
import com.kuaike.scrm.common.dto.MessageListRespDto;
import com.kuaike.scrm.common.dto.StopWatchDto;
import com.kuaike.scrm.common.dto.TalkerMessageRespDto;
import com.kuaike.scrm.common.service.MessageCommonService;
import com.kuaike.scrm.common.service.dto.req.ChatEsReq;
import com.kuaike.scrm.common.utils.LoginUtils;
import com.kuaike.scrm.dal.wework.dto.UserContactInfo;
import com.kuaike.scrm.dal.wework.entity.WeworkChatRoomRelation;
import com.kuaike.scrm.dal.wework.entity.WeworkCorp;
import com.kuaike.scrm.dal.wework.entity.WeworkUser;
import com.kuaike.scrm.dal.wework.mapper.WeworkChatRoomRelationMapper;
import com.kuaike.scrm.dal.wework.mapper.WeworkContactRelationMapper;
import com.kuaike.scrm.dal.wework.mapper.WeworkCorpMapper;
import com.kuaike.scrm.dal.wework.mapper.WeworkUserMapper;
import com.kuaike.scrm.wework.contact.dto.ContactQueryDto;
import com.kuaike.scrm.wework.contact.service.ContactRelationService;
import com.kuaike.scrm.wework.contact.service.ContactService;
import com.kuaike.scrm.wework.corp.service.WeworkCorpService;
import com.kuaike.scrm.wework.weworkuser.service.AgentWeworkUserService;
import com.kuaike.scrm.wework.weworkuser.service.WeworkUserService;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class WeworkMessageServiceImpl
implements WeworkMessageService {
    private static final Logger log = LoggerFactory.getLogger(WeworkMessageServiceImpl.class);
    @Autowired
    private MessageCommonService messageCommonService;
    @Autowired
    private ContactService contactService;
    @Autowired
    private WeworkUserService weworkUserService;
    @Autowired
    private AgentWeworkUserService agentWeworkUserService;
    @Autowired
    private ContactRelationService contactRelationService;
    @Autowired
    private WeworkChatRoomRelationMapper weworkChatRoomRelationMapper;
    @Autowired
    private WeworkCorpMapper weworkCorpMapper;
    @Autowired
    private WeworkUserMapper weworkUserMapper;
    @Autowired
    private WeworkCorpService weworkCorpService;
    @Resource
    private WeworkContactRelationMapper weworkContactRelationMapper;

    private Integer queryNewDKF(Long bizId) {
        WeworkCorp weworkCorp = this.weworkCorpMapper.getByBizId(bizId);
        return Objects.equals(weworkCorp.getIsNewDkf(), 1) ? 1 : 0;
    }

    @Override
    public void handleRevokeMessage(ChatMsg chatMsg) {
        Revoke revoke = chatMsg.getRevoke();
        if (!"recall".equals(chatMsg.getAction()) || Objects.isNull(revoke)) {
            return;
        }
        String preMsgId = revoke.getPreMsgId();
        Optional<ChatMsg> msgOptional = this.timeoutToFetchOriginMessage(preMsgId);
        msgOptional.ifPresent(t -> this.messageCommonService.updateRevokeMsg(t.getMsgId(), new Date(t.getMsgTime())));
    }

    private Optional<ChatMsg> timeoutToFetchOriginMessage(String msgId) {
        ChatMsg originMessage = this.messageCommonService.selectByPrimaryKeyFromES(msgId);
        Long beginTime = System.currentTimeMillis() + 1200L;
        int count = 0;
        while (Objects.isNull(originMessage) && System.currentTimeMillis() < beginTime) {
            try {
                TimeUnit.MILLISECONDS.sleep(500L);
            }
            catch (InterruptedException e) {
                log.error("\u7ebf\u7a0b\u4e2d\u65ad\u4e86");
                Thread.currentThread().interrupt();
                return Optional.empty();
            }
            originMessage = this.messageCommonService.selectByPrimaryKeyFromES(msgId);
            ++count;
        }
        log.info("timeoutToFetchOriginMessage \u91cd\u8bd5\u6b21\u6570\uff1a{}", (Object)count);
        return Optional.ofNullable(originMessage);
    }

    @Override
    public MessageListRespDto messageList(MessageReqDto req) {
        log.info("messageList params,req:{}", (Object)JSON.toJSONString((Object)req));
        req.validate();
        StopWatchDto timer = new StopWatchDto("messageList", true, log);
        Date createTime = null;
        if (StringUtils.isNotBlank((CharSequence)req.getMsgId())) {
            timer.start("es\u5355\u70b9\u67e5\u8be2");
            ChatMsg chatMsg = this.messageCommonService.selectByPrimaryKeyFromES(req.getMsgId());
            if (Objects.nonNull(chatMsg)) {
                createTime = new Date(chatMsg.getMsgTime());
            }
            timer.stop();
        }
        timer.start("es\u5217\u8868\u67e5\u8be2");
        String decryptCorpId = this.weworkCorpService.getDecryptCorpId(req.getCorpId(), null, null);
        ChatEsReq chatEsReq = ChatEsReq.buildChatEsReqParam((String)req.getConversationId(), (Date)createTime, (Boolean)req.getDirection(), (Integer)req.getCount(), (Boolean)true, (String)decryptCorpId, (Long)req.getBizId());
        chatEsReq.setStartChatTime(req.getStartTime());
        chatEsReq.setEndChatTime(req.getEndTime());
        chatEsReq.setChatMsgTypes(req.getChatMsgTypes());
        List messageList = this.messageCommonService.queryListByCreateTimeCount(chatEsReq);
        timer.stop();
        timer.print();
        MessageReqDto reqDto = new MessageReqDto();
        reqDto.setConversationId(req.getConversationId());
        reqDto.setWeworkUserId(req.getWeworkUserId());
        reqDto.setTalkerId(req.getTalkerId());
        reqDto.setMessageList(messageList);
        reqDto.setAscOrder(Boolean.TRUE);
        reqDto.setBizId(req.getBizId());
        reqDto.setCorpId(req.getCorpId());
        return this.getMessageListRespDto(reqDto);
    }

    @Override
    public MessageListRespDto getMessageListRespDto(MessageReqDto reqDto) {
        List contactIds;
        long commonDealMessageBeginTime = System.currentTimeMillis();
        String conversationId = reqDto.getConversationId();
        String weworkUserNum = reqDto.getWeworkUserId();
        String talkerId = reqDto.getTalkerId();
        List<ChatMsg> messageList = reqDto.getMessageList();
        boolean ascOrder = reqDto.getAscOrder();
        Long bizId = reqDto.getBizId();
        String corpId = reqDto.getCorpId();
        StopWatchDto timer = new StopWatchDto("getMessageListRespDto", true, log);
        MessageListRespDto result = new MessageListRespDto();
        result.setWeworkUserId(weworkUserNum);
        result.setTalkerId(talkerId);
        if (CollectionUtils.isEmpty(messageList)) {
            return result;
        }
        Integer useAgent = this.queryNewDKF(bizId);
        String decryptCorpId = this.weworkCorpService.getDecryptCorpId(corpId, useAgent, bizId);
        Map userId2UserMap = this.weworkUserService.queryByWeworkUserNum(bizId, weworkUserNum, useAgent);
        String originWeworkUserId = this.weworkUserService.getDecryptWeworkUserId(weworkUserNum);
        ArrayList talkerMsgList = Lists.newArrayListWithExpectedSize((int)messageList.size());
        List weworkUserIds = contactIds = messageList.stream().filter(t -> StringUtils.isNotBlank((CharSequence)t.getFrom())).map(ChatMsg::getFrom).distinct().collect(Collectors.toList());
        ContactQueryDto queryDto = new ContactQueryDto();
        queryDto.setWeworkUserId(originWeworkUserId);
        queryDto.setBizId(bizId);
        queryDto.setContactIds(contactIds);
        queryDto.setUseAgent(useAgent);
        List contactInfos = this.contactRelationService.queryContactInfo(queryDto);
        Map<String, UserContactInfo> contactMap = contactInfos.stream().collect(Collectors.toMap(a -> a.getContactId(), a -> a));
        Map<Object, Object> contact2Relation = Maps.newHashMap();
        if (StringUtils.isNotBlank((CharSequence)conversationId) && StringUtils.startsWith((CharSequence)conversationId, (CharSequence)"wr")) {
            List relations = this.weworkChatRoomRelationMapper.queryByRoomIdAndMemberId(useAgent, bizId, decryptCorpId, conversationId, weworkUserIds);
            contact2Relation = relations.stream().collect(Collectors.toMap(a -> a.getMemberId(), a -> a));
        }
        userId2UserMap.putAll(this.weworkUserService.queryUserByWeworkUserIds(bizId, weworkUserIds, useAgent, corpId));
        log.info("userId2UserMap: {}, weworkUserIds: {}", (Object)userId2UserMap, weworkUserIds);
        timer.start("\u6392\u5e8f");
        if (ascOrder) {
            messageList.sort(Comparator.comparing(ChatMsg::getMsgTime).thenComparing(ChatMsg::getMsgId));
        } else {
            messageList.sort(Comparator.comparing(ChatMsg::getMsgTime).thenComparing(ChatMsg::getMsgId).reversed());
        }
        timer.stop();
        timer.start("forWechatMessageList");
        for (ChatMsg message : messageList) {
            TalkerMessageRespDto talkerMessageRespDto = this.buildTalkerMessage(message, contactMap, userId2UserMap, contact2Relation);
            talkerMsgList.add(talkerMessageRespDto);
        }
        timer.stop();
        result.setTalkerMsgList((List)talkerMsgList);
        log.info("getWechatMessageListRespDto\u5f00\u59cb\u65f6\u95f4:{},\u901a\u7528\u903b\u8f91\u5904\u7406\u6d88\u606f\u8017\u65f6\uff1a{}", (Object)commonDealMessageBeginTime, (Object)(System.currentTimeMillis() - commonDealMessageBeginTime));
        timer.print();
        return result;
    }

    private TalkerMessageRespDto buildTalkerMessage(ChatMsg message, Map<String, UserContactInfo> contactMap, Map<String, WeworkUser> userId2UserMap, Map<String, WeworkChatRoomRelation> contact2Relation) {
        TalkerMessageRespDto talkerMessageRespDto = new TalkerMessageRespDto();
        WeworkUser user = userId2UserMap.get(message.getFrom());
        UserContactInfo contactInfo = contactMap.get(message.getFrom());
        WeworkChatRoomRelation chatRoomRelation = contact2Relation.get(message.getFrom());
        if (user != null) {
            talkerMessageRespDto.setSendNum(user.getNum());
            talkerMessageRespDto.setSenderName(user.getName());
            talkerMessageRespDto.setSendOriginName(user.getName());
            talkerMessageRespDto.setAvatar(user.getAvatar());
        } else if (contactInfo != null) {
            talkerMessageRespDto.setSenderName(contactInfo.getRemark());
            talkerMessageRespDto.setSendOriginName(contactInfo.getOriginName());
            talkerMessageRespDto.setAvatar(contactInfo.getAvatar());
        } else if (chatRoomRelation != null) {
            talkerMessageRespDto.setSenderName(chatRoomRelation.getGroupNickname());
            talkerMessageRespDto.setSendOriginName(chatRoomRelation.getName());
            talkerMessageRespDto.setAvatar("");
        }
        talkerMessageRespDto.setSenderId(message.getFrom());
        Map msgMap = JacksonUtil.toMap((Object)message);
        talkerMessageRespDto.setMessage(msgMap);
        talkerMessageRespDto.setMsgId(message.getMsgId());
        if (Objects.nonNull(message.getText()) && Objects.nonNull(message.getText().getContent())) {
            talkerMessageRespDto.setMsgText(message.getText().getContent());
        }
        if (Objects.nonNull(message.getMsgTime())) {
            talkerMessageRespDto.setMsgTime(new Date(message.getMsgTime()));
        }
        return talkerMessageRespDto;
    }

    @Override
    public MessageListRespDto messageAroundList(MessageDetailReqDto req) {
        log.info("messageAroundList params, req:{}", (Object)JSON.toJSONString((Object)req));
        req.validate();
        StopWatchDto timer = new StopWatchDto("messageAroundList", true, log);
        timer.start("queryMessageFromES");
        ChatMsg chatMsg = this.messageCommonService.selectByPrimaryKeyFromES(req.getMsgId());
        timer.stop();
        if (null == chatMsg) {
            throw new BusinessException((UniverseErrorCode)CommonErrorCode.BUSINESS_ERROR, "\u6307\u5b9a\u6d88\u606fID\u4e0d\u5b58\u5728");
        }
        Integer count = req.getCount();
        if (null == count) {
            count = 10;
        }
        Date createTime = new Date(chatMsg.getMsgTime());
        timer.start("queryListByCreateTimeCountBefore");
        CurrentUserInfo currentUser = LoginUtils.getCurrentUser();
        String decryptCorpId = this.weworkCorpService.getDecryptCorpId(currentUser.getCorpId(), null, null);
        ChatEsReq esReqBefore = ChatEsReq.buildChatEsReqParam((String)req.getConversationId(), (Date)createTime, (Boolean)false, (Integer)count, (Boolean)false, (String)decryptCorpId, (Long)currentUser.getBizId());
        List wechatMessageBeforeList = this.messageCommonService.queryListByCreateTimeCount(esReqBefore);
        timer.stop();
        timer.start("queryListByCreateTimeCountAfter");
        ChatEsReq esReqAfter = ChatEsReq.buildChatEsReqParam((String)req.getConversationId(), (Date)createTime, (Boolean)true, (Integer)count, (Boolean)false, (String)decryptCorpId, (Long)currentUser.getBizId());
        List wechatMessageAfterList = this.messageCommonService.queryListByCreateTimeCount(esReqAfter);
        timer.stop();
        timer.print();
        ArrayList wechatMessageList = Lists.newArrayListWithExpectedSize((int)(2 * count + 1));
        wechatMessageList.addAll(wechatMessageBeforeList);
        wechatMessageList.add(chatMsg);
        wechatMessageList.addAll(wechatMessageAfterList);
        MessageReqDto reqDto = new MessageReqDto();
        reqDto.setConversationId(req.getConversationId());
        reqDto.setWeworkUserId(req.getWeworkUserId());
        reqDto.setTalkerId(req.getTalkerId());
        reqDto.setMessageList(wechatMessageList);
        reqDto.setAscOrder(Boolean.TRUE);
        reqDto.setBizId(currentUser.getBizId());
        reqDto.setCorpId(currentUser.getCorpId());
        return this.getMessageListRespDto(reqDto);
    }
}

