/*
 * Decompiled with CFR 0.152.
 */
package com.kuaike.scrm.chat.service.impl;

import cn.kinyun.wework.sdk.entity.chat.ChatMsg;
import cn.kinyun.wework.sdk.enums.TalkerType;
import com.alibaba.fastjson.JSON;
import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import com.kuaike.common.sqlbuilder.dto.PageDto;
import com.kuaike.scrm.common.service.ScrmChatMsgService;
import com.kuaike.scrm.common.service.dto.resp.ChatEsMsgDto;
import com.kuaike.scrm.common.service.dto.resp.ChatEsMsgResp;
import com.kuaike.scrm.common.service.dto.resp.ChatMsgAggResp;
import com.kuaike.scrm.common.service.dto.resp.ChatMsgRespDto;
import com.kuaike.scrm.common.utils.AutoCreateIndexUtil;
import com.kuaike.scrm.dal.agent.mapper.AgentDecryptWeworkContactIdMapper;
import com.kuaike.scrm.dal.agent.mapper.AgentDecryptWeworkUserIdMapper;
import com.kuaike.scrm.dal.chat.entity.WeworkConversation;
import com.kuaike.scrm.dal.chat.mapper.WeworkConversationMapper;
import com.kuaike.scrm.dal.wework.entity.WeworkCorp;
import com.kuaike.scrm.dal.wework.mapper.WeworkCorpMapper;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.math.NumberUtils;
import org.apache.http.Header;
import org.elasticsearch.action.search.SearchRequest;
import org.elasticsearch.action.search.SearchResponse;
import org.elasticsearch.client.RestHighLevelClient;
import org.elasticsearch.index.query.BoolQueryBuilder;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.index.query.QueryBuilders;
import org.elasticsearch.search.SearchHit;
import org.elasticsearch.search.SearchHits;
import org.elasticsearch.search.aggregations.AggregationBuilder;
import org.elasticsearch.search.aggregations.AggregationBuilders;
import org.elasticsearch.search.aggregations.bucket.terms.ParsedStringTerms;
import org.elasticsearch.search.aggregations.bucket.terms.Terms;
import org.elasticsearch.search.aggregations.bucket.terms.TermsAggregationBuilder;
import org.elasticsearch.search.builder.SearchSourceBuilder;
import org.elasticsearch.search.sort.SortOrder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class ChatMsgServiceImpl
implements ScrmChatMsgService {
    private static final Logger log = LoggerFactory.getLogger(ChatMsgServiceImpl.class);
    @Autowired
    private WeworkConversationMapper weworkConversationMapper;
    @Resource
    private RestHighLevelClient restHighLevelClient;
    @Resource
    private AutoCreateIndexUtil indexUtil;
    @Resource
    private WeworkCorpMapper weworkCorpMapper;
    @Resource
    private AgentDecryptWeworkContactIdMapper agentDecryptWeworkContactIdMapper;
    @Resource
    private AgentDecryptWeworkUserIdMapper agentDecryptWeworkUserIdMapper;
    private static final String VERIFICATION_MESSAGE = "\u6211\u901a\u8fc7\u4e86\u4f60\u7684\u8054\u7cfb\u4eba\u9a8c\u8bc1\u8bf7\u6c42\uff0c\u73b0\u5728\u6211\u4eec\u53ef\u4ee5\u5f00\u59cb\u804a\u5929\u4e86";

    public List<ChatMsgRespDto> queryChatMsgByContactId(Long bizId, List<String> contactIds) {
        log.info("queryChatMsgByContactId: bizId:{}, contactIds:{}", (Object)bizId, contactIds);
        Preconditions.checkArgument((bizId != null ? 1 : 0) != 0, (Object)"\u5546\u6237Id\u4e0d\u80fd\u4e3a\u7a7a");
        if (CollectionUtils.isEmpty(contactIds)) {
            return Lists.newArrayList();
        }
        ArrayList respDtoList = Lists.newArrayList();
        Map<String, WeworkConversation> latestRecordMap = this.getLatestMsg(bizId, null, contactIds);
        Map<String, WeworkConversation> latestRecvRecordMap = this.getLatestMsg(bizId, 0, contactIds);
        for (String contactId : contactIds) {
            ChatMsgRespDto respDto = new ChatMsgRespDto();
            respDto.setContactId(contactId);
            if (latestRecordMap.containsKey(contactId)) {
                WeworkConversation latestRecord = latestRecordMap.get(contactId);
                respDto.setLatestChatMsgId(latestRecord.getMsgId());
                respDto.setLatestChatTime(latestRecord.getLastMsgTime());
            }
            if (latestRecvRecordMap.containsKey(contactId)) {
                WeworkConversation latestRecvRecord = latestRecordMap.get(contactId);
                respDto.setLatestRecvChatMsgId(latestRecvRecord.getMsgId());
                respDto.setLatestRecvChatTime(latestRecvRecord.getLastMsgTime());
            }
            respDtoList.add(respDto);
        }
        return respDtoList;
    }

    private Map<String, WeworkConversation> getLatestMsg(Long bizId, Integer isSend, List<String> contactIds) {
        Map<String, Object> latestRecordMap;
        List latestIds = this.weworkConversationMapper.queryLatestChatMsgIds(bizId, isSend, contactIds);
        if (CollectionUtils.isNotEmpty((Collection)latestIds)) {
            List latestList = this.weworkConversationMapper.selectByIds((Collection)latestIds);
            latestRecordMap = latestList.stream().collect(Collectors.toMap(WeworkConversation::getTalkerId, Function.identity()));
        } else {
            latestRecordMap = Collections.emptyMap();
        }
        return latestRecordMap;
    }

    public ChatEsMsgResp queryChatEsMsgByFromAndTime(Long bizId, Collection<String> fromList, Date startTime, Date endTime, PageDto pageDto) {
        SearchResponse searchResponse;
        log.info("queryChatEsMsgByFromAndTime,bizId:{},fromList:{},startTime:{},endTime:{},pageDto:{}", new Object[]{bizId, fromList, startTime, endTime, pageDto});
        ChatEsMsgResp resp = new ChatEsMsgResp();
        resp.setList(Collections.emptyList());
        resp.setTotalCount(Long.valueOf(0L));
        if (bizId == null || CollectionUtils.isEmpty(fromList) || startTime == null && endTime == null) {
            return resp;
        }
        boolean isNewDkf = false;
        WeworkCorp weworkCorp = this.weworkCorpMapper.getByBizId(bizId);
        if (weworkCorp != null && NumberUtils.INTEGER_ONE.equals(weworkCorp.getIsNewDkf())) {
            isNewDkf = true;
        }
        HashMap<String, String> decryptAndEncryptContactIdMap = new HashMap<String, String>();
        if (isNewDkf) {
            Map encryptAndDecryptContactIdMap = this.agentDecryptWeworkContactIdMapper.queryByEncryptContactIds(bizId, fromList);
            encryptAndDecryptContactIdMap.forEach((encrypt, decrypt) -> decryptAndEncryptContactIdMap.put((String)decrypt, (String)encrypt));
        }
        if (isNewDkf && decryptAndEncryptContactIdMap.isEmpty()) {
            return resp;
        }
        Integer pageNum = pageDto.getPageNum();
        Integer pageSize = pageDto.getPageSize();
        String indexName = null;
        if (endTime != null) {
            indexName = this.indexUtil.getIndexName(endTime);
        }
        if (startTime != null) {
            indexName = this.indexUtil.getIndexName(startTime);
        }
        if (StringUtils.isBlank(indexName)) {
            return resp;
        }
        BoolQueryBuilder queryBuilder = QueryBuilders.boolQuery().must((QueryBuilder)QueryBuilders.termsQuery((String)"from.keyword", isNewDkf ? decryptAndEncryptContactIdMap.keySet() : fromList)).must((QueryBuilder)QueryBuilders.termQuery((String)"bizId", (Object)bizId)).must((QueryBuilder)QueryBuilders.termsQuery((String)"action.keyword", (String[])new String[]{"send"})).must((QueryBuilder)QueryBuilders.termQuery((String)"talkerType", (int)TalkerType.CONTACT.getValue()));
        queryBuilder.mustNot((QueryBuilder)QueryBuilders.termQuery((String)"text.content.keyword", (String)VERIFICATION_MESSAGE));
        if (startTime != null) {
            queryBuilder.must((QueryBuilder)QueryBuilders.rangeQuery((String)"msgTime").gte((Object)startTime.getTime()));
        }
        if (endTime != null) {
            queryBuilder.must((QueryBuilder)QueryBuilders.rangeQuery((String)"msgTime").lte((Object)endTime.getTime()));
        }
        SearchRequest searchRequest = new SearchRequest(new String[]{indexName});
        searchRequest.types(new String[]{"doc"});
        SearchSourceBuilder searchSourceBuilder = new SearchSourceBuilder();
        searchSourceBuilder.query((QueryBuilder)queryBuilder);
        searchSourceBuilder.from((pageNum - 1) * pageSize).size(pageSize.intValue());
        searchRequest.source(searchSourceBuilder);
        log.info("queryChatEsMsgByFromAndTime, searchSourceBuilder:{}", (Object)searchSourceBuilder);
        try {
            searchResponse = this.restHighLevelClient.search(searchRequest, new Header[0]);
        }
        catch (Exception e) {
            log.error("queryChatEsMsgByFromAndTime,Search es failed, searchRequest={}", (Object)searchRequest, (Object)e);
            searchResponse = null;
        }
        if (searchResponse == null) {
            log.info("queryChatEsMsgByFromAndTime,searchResponse is null");
            return resp;
        }
        SearchHits hits = searchResponse.getHits();
        List<ChatEsMsgDto> msgDtoList = this.buildResultList(bizId, isNewDkf, hits, decryptAndEncryptContactIdMap);
        resp.setList(msgDtoList);
        resp.setTotalCount(Long.valueOf(hits.getTotalHits()));
        return resp;
    }

    private List<ChatEsMsgDto> buildResultList(Long bizId, boolean isNewDkf, SearchHits hits, Map<String, String> decryptAndEncryptContactIdMap) {
        ArrayList<ChatEsMsgDto> msgDtoList = new ArrayList<ChatEsMsgDto>();
        HashSet decryptWeworkUserIds = new HashSet();
        for (SearchHit searchHit : hits) {
            try {
                String sourceAsString = searchHit.getSourceAsString();
                ChatMsg chatMsg = (ChatMsg)JSON.parseObject((String)sourceAsString, ChatMsg.class);
                ChatEsMsgDto dto = new ChatEsMsgDto();
                dto.setMsgId(chatMsg.getMsgId());
                dto.setFrom(chatMsg.getFrom());
                if (isNewDkf) {
                    String encryptContactId = decryptAndEncryptContactIdMap.get(chatMsg.getFrom());
                    dto.setFrom(encryptContactId);
                }
                List toList = chatMsg.getTolist();
                dto.setToList(toList);
                decryptWeworkUserIds.addAll(toList);
                dto.setMsgDate(new Date(chatMsg.getMsgTime()));
                dto.setConversationId(chatMsg.getConversationId());
                msgDtoList.add(dto);
            }
            catch (Exception e) {
                log.error("queryChatEsMsgByFromAndTime,\u89e3\u6790\u7ed3\u679c\u5f02\u5e38", (Throwable)e);
            }
        }
        if (!isNewDkf) {
            return msgDtoList;
        }
        Map decryptAndEncryptWeworkUserIdMap = this.agentDecryptWeworkUserIdMapper.queryMapByDecryptUserIds(bizId, decryptWeworkUserIds);
        for (ChatEsMsgDto dto : msgDtoList) {
            List toList = dto.getToList();
            ArrayList<String> encryptToList = new ArrayList<String>();
            for (String decrypt : toList) {
                String encrypt = (String)decryptAndEncryptWeworkUserIdMap.get(decrypt);
                if (!StringUtils.isNotBlank((CharSequence)encrypt)) continue;
                encryptToList.add(encrypt);
            }
            dto.setToList(encryptToList);
        }
        return msgDtoList;
    }

    public List<ChatMsgAggResp> aggChatMsg(Long bizId, Collection<String> fromList, Date startTime, Date endTime) {
        SearchResponse searchResponse;
        log.info("aggChatMsg,bizId:{},fromList:{},startTime:{},endTime:{}", new Object[]{bizId, fromList, startTime, endTime});
        if (bizId == null || CollectionUtils.isEmpty(fromList) || startTime == null && endTime == null) {
            return Collections.emptyList();
        }
        boolean isNewDkf = false;
        WeworkCorp weworkCorp = this.weworkCorpMapper.getByBizId(bizId);
        if (weworkCorp != null && NumberUtils.INTEGER_ONE.equals(weworkCorp.getIsNewDkf())) {
            isNewDkf = true;
        }
        HashMap<String, String> decryptAndEncryptContactIdMap = new HashMap<String, String>();
        if (isNewDkf) {
            Map encryptAndDecryptContactIdMap = this.agentDecryptWeworkContactIdMapper.queryByEncryptContactIds(bizId, fromList);
            encryptAndDecryptContactIdMap.forEach((encrypt, decrypt) -> decryptAndEncryptContactIdMap.put((String)decrypt, (String)encrypt));
        }
        if (isNewDkf && decryptAndEncryptContactIdMap.isEmpty()) {
            return Collections.emptyList();
        }
        log.info("aggChatMsg,isNewDkf:{},decryptAndEncryptContactIdMap:{}", (Object)isNewDkf, decryptAndEncryptContactIdMap);
        String indexName = null;
        if (endTime != null) {
            indexName = this.indexUtil.getIndexName(endTime);
        }
        if (startTime != null) {
            indexName = this.indexUtil.getIndexName(startTime);
        }
        if (StringUtils.isBlank(indexName)) {
            return Collections.emptyList();
        }
        BoolQueryBuilder queryBuilder = QueryBuilders.boolQuery().must((QueryBuilder)QueryBuilders.termsQuery((String)"from.keyword", isNewDkf ? decryptAndEncryptContactIdMap.keySet() : fromList)).must((QueryBuilder)QueryBuilders.termQuery((String)"bizId", (Object)bizId)).must((QueryBuilder)QueryBuilders.termsQuery((String)"action.keyword", (String[])new String[]{"send"})).must((QueryBuilder)QueryBuilders.termQuery((String)"talkerType", (int)TalkerType.CONTACT.getValue()));
        queryBuilder.mustNot((QueryBuilder)QueryBuilders.termQuery((String)"text.content.keyword", (String)VERIFICATION_MESSAGE));
        if (startTime != null) {
            queryBuilder.must((QueryBuilder)QueryBuilders.rangeQuery((String)"msgTime").gte((Object)startTime.getTime()));
        }
        if (endTime != null) {
            queryBuilder.must((QueryBuilder)QueryBuilders.rangeQuery((String)"msgTime").lte((Object)endTime.getTime()));
        }
        TermsAggregationBuilder userNumsAggregation = (TermsAggregationBuilder)((TermsAggregationBuilder)AggregationBuilders.terms((String)"froms").field("from.keyword")).size(fromList.size() + 1).subAggregation((AggregationBuilder)((TermsAggregationBuilder)AggregationBuilders.terms((String)"toLists").field("tolist.keyword")).size(10000));
        SearchSourceBuilder searchSourceBuilder = new SearchSourceBuilder();
        searchSourceBuilder.query((QueryBuilder)queryBuilder);
        searchSourceBuilder.size(0);
        searchSourceBuilder.aggregation((AggregationBuilder)userNumsAggregation);
        searchSourceBuilder.sort("msgTime", SortOrder.ASC);
        SearchRequest searchRequest = new SearchRequest(new String[]{indexName});
        searchRequest.types(new String[]{"doc"});
        searchRequest.source(searchSourceBuilder);
        try {
            searchResponse = this.restHighLevelClient.search(searchRequest, new Header[0]);
        }
        catch (Exception e) {
            log.error("aggChatMsg,error,searchRequest:{}", (Object)searchRequest, (Object)e);
            return Collections.emptyList();
        }
        return this.buildAggResultList(bizId, isNewDkf, searchResponse, decryptAndEncryptContactIdMap);
    }

    private List<ChatMsgAggResp> buildAggResultList(Long bizId, boolean isNewDkf, SearchResponse searchResponse, Map<String, String> decryptAndEncryptContactIdMap) {
        ArrayList<ChatMsgAggResp> list = new ArrayList<ChatMsgAggResp>();
        HashSet<String> decryptWeworkUserIds = new HashSet<String>();
        Terms userNumsTerms = (Terms)searchResponse.getAggregations().get("froms");
        for (Terms.Bucket userNumsBucket : userNumsTerms.getBuckets()) {
            String contactId = userNumsBucket.getKeyAsString();
            ParsedStringTerms toLists = (ParsedStringTerms)userNumsBucket.getAggregations().get("toLists");
            ChatMsgAggResp resp = new ChatMsgAggResp();
            resp.setContactId(contactId);
            if (isNewDkf) {
                String encryptContactId = decryptAndEncryptContactIdMap.get(contactId);
                resp.setContactId(encryptContactId);
            }
            HashSet<String> weworkUserIds = new HashSet<String>();
            for (Terms.Bucket to : toLists.getBuckets()) {
                String weworkUserId = to.getKeyAsString();
                weworkUserIds.add(weworkUserId);
                decryptWeworkUserIds.add(weworkUserId);
            }
            resp.setWeworkUserIds(weworkUserIds);
            log.info("buildAggResultList,chatMsgAggResp:{}", (Object)resp);
            list.add(resp);
        }
        if (!isNewDkf) {
            return list;
        }
        Map decryptAndEncryptWeworkUserIdMap = this.agentDecryptWeworkUserIdMapper.queryDeAndEnMapByDecryptUserIds(bizId, decryptWeworkUserIds);
        log.info("buildAggResultList,decryptWeworkUserIds:{}", decryptWeworkUserIds);
        for (ChatMsgAggResp chatMsgAggResp : list) {
            Collection weworkUserIds = chatMsgAggResp.getWeworkUserIds();
            ArrayList<String> encryptToList = new ArrayList<String>();
            for (String decrypt : weworkUserIds) {
                String encrypt = (String)decryptAndEncryptWeworkUserIdMap.get(decrypt);
                log.info("buildAggResultList,decryptWeworkUserId:{},encrypt:{}", (Object)decrypt, (Object)encrypt);
                if (!StringUtils.isNotBlank((CharSequence)encrypt)) continue;
                encryptToList.add(encrypt);
            }
            chatMsgAggResp.setWeworkUserIds(encryptToList);
            log.info("buildAggResultList,decrypt chatMsgAggResp:{}", (Object)chatMsgAggResp);
        }
        return list;
    }
}

