/*
 * Decompiled with CFR 0.152.
 */
package com.kuaike.scrm.chat.check;

import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.kuaike.scrm.chat.check.MatchedResult;
import com.kuaike.scrm.chat.check.MatchedWord;
import com.kuaike.scrm.chat.check.WordTree;
import com.kuaike.scrm.common.enums.QualityBehaviorType;
import com.kuaike.scrm.common.enums.QualitySenderType;
import com.kuaike.scrm.dal.qualitycheck.entity.QualityCheckBehaviorSetting;
import com.kuaike.scrm.dal.qualitycheck.entity.QualityCheckWordGroup;
import com.kuaike.scrm.dal.qualitycheck.entity.QualityCheckWordGroupNode;
import com.kuaike.scrm.dal.qualitycheck.entity.QualityCheckWords;
import com.kuaike.scrm.dal.qualitycheck.mapper.QualityCheckBehaviorSettingMapper;
import com.kuaike.scrm.dal.qualitycheck.mapper.QualityCheckWordGroupMapper;
import com.kuaike.scrm.dal.qualitycheck.mapper.QualityCheckWordGroupNodeMapper;
import com.kuaike.scrm.dal.qualitycheck.mapper.QualityCheckWordsMapper;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import org.apache.commons.collections4.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Component;

@Lazy
@Component
public class CorpWordTree {
    private static final Logger log = LoggerFactory.getLogger(CorpWordTree.class);
    private final Map<Long, WordTree> weworkUserWordTree = Maps.newConcurrentMap();
    private final Map<Long, WordTree> weworkContactWordTree = Maps.newConcurrentMap();
    private final Map<Long, Map<Long, Set<Integer>>> bizId2GroupId2NodeIdMap = Maps.newConcurrentMap();
    private final Map<Long, Map<Integer, Boolean>> weworkUserBehaviorMap = Maps.newConcurrentMap();
    private final Map<Long, Map<Integer, Boolean>> weworkContactBehaviorMap = Maps.newConcurrentMap();
    @Autowired
    private QualityCheckWordsMapper qualityCheckWordsMapper;
    @Autowired
    private QualityCheckWordGroupMapper qualityCheckWordGroupMapper;
    @Autowired
    private QualityCheckWordGroupNodeMapper qualityCheckWordGroupNodeMapper;
    @Autowired
    private QualityCheckBehaviorSettingMapper qualityCheckBehaviorSettingMapper;

    @PostConstruct
    public void init() {
        this.initSensitiveWords();
        this.initSensitiveBehavior();
        log.info("wordTree init load");
    }

    private void initSensitiveWords() {
        HashMap userWordTree = Maps.newHashMap();
        HashMap contactWordTree = Maps.newHashMap();
        List allGroups = this.qualityCheckWordGroupMapper.queryAll();
        List allWords = this.qualityCheckWordsMapper.queryAll();
        Map groupWordsMap = allWords.stream().collect(Collectors.groupingBy(QualityCheckWords::getGroupId, Collectors.mapping(QualityCheckWords::getWord, Collectors.toSet())));
        for (QualityCheckWordGroup group : allGroups) {
            Set words = groupWordsMap.computeIfAbsent(group.getId(), k -> Sets.newHashSet());
            words.add(group.getGroupName());
            QualitySenderType senderType = QualitySenderType.getByType((Integer)group.getSenderType());
            HashMap bizWordTreeMap = senderType == QualitySenderType.WEWORK_CONTACT ? contactWordTree : userWordTree;
            WordTree wordTree = bizWordTreeMap.computeIfAbsent(group.getBizId(), k -> new WordTree());
            wordTree.addWords(words, group.getId());
        }
        this.weworkUserWordTree.putAll(userWordTree);
        this.weworkContactWordTree.putAll(contactWordTree);
        List nodes = this.qualityCheckWordGroupNodeMapper.queryAll();
        Map bizIdGroupIdNodeIdMap = nodes.stream().collect(Collectors.groupingBy(QualityCheckWordGroupNode::getBizId, Collectors.groupingBy(QualityCheckWordGroupNode::getGroupId, Collectors.mapping(a -> a.getNodeId().intValue(), Collectors.toSet()))));
        this.bizId2GroupId2NodeIdMap.putAll(bizIdGroupIdNodeIdMap);
    }

    private void initSensitiveBehavior() {
        List behaviorSettings = this.qualityCheckBehaviorSettingMapper.queryAll();
        HashMap userBehaviorMap = Maps.newHashMap();
        HashMap contactBehaviorMap = Maps.newHashMap();
        for (QualityCheckBehaviorSetting setting : behaviorSettings) {
            Long bizId = setting.getBizId();
            QualitySenderType senderType = QualitySenderType.getByType((Integer)setting.getSenderType());
            Map behaviorMap = senderType == QualitySenderType.WEWORK_CONTACT ? contactBehaviorMap.computeIfAbsent(bizId, k -> Maps.newHashMap()) : userBehaviorMap.computeIfAbsent(bizId, k -> Maps.newHashMap());
            behaviorMap.put(setting.getCheckValue(), Objects.equals(setting.getCheckStatus(), 1));
        }
        this.weworkUserBehaviorMap.putAll(userBehaviorMap);
        this.weworkContactBehaviorMap.putAll(contactBehaviorMap);
    }

    public void resetBizSensitiveWords(Long bizId, String corpId) {
        log.info("resetBizSensitiveWords, bizId:{}, corpId:{}", (Object)bizId, (Object)corpId);
        List groups = this.qualityCheckWordGroupMapper.queryByCorpId(corpId);
        List groupWords = this.qualityCheckWordsMapper.queryByCorpId(corpId);
        WordTree userWordTree = new WordTree();
        WordTree contactWordTree = new WordTree();
        Map groupWordsMap = groupWords.stream().collect(Collectors.groupingBy(QualityCheckWords::getGroupId, Collectors.mapping(QualityCheckWords::getWord, Collectors.toSet())));
        for (QualityCheckWordGroup group : groups) {
            Set words = groupWordsMap.computeIfAbsent(group.getId(), k -> Sets.newHashSet());
            words.add(group.getGroupName());
            QualitySenderType senderType = QualitySenderType.getByType((Integer)group.getSenderType());
            WordTree wordTree = senderType == QualitySenderType.WEWORK_CONTACT ? contactWordTree : userWordTree;
            wordTree.addWords(words, group.getId());
        }
        this.weworkUserWordTree.put(bizId, userWordTree);
        this.weworkContactWordTree.put(bizId, contactWordTree);
        List nodes = this.qualityCheckWordGroupNodeMapper.queryByCorpId(corpId);
        Map groupIdNodeIdMap = nodes.stream().collect(Collectors.groupingBy(QualityCheckWordGroupNode::getGroupId, Collectors.mapping(a -> a.getNodeId().intValue(), Collectors.toSet())));
        this.bizId2GroupId2NodeIdMap.put(bizId, groupIdNodeIdMap);
        log.info("reset corp sensitive word, bizId={}, corpId={}", (Object)bizId, (Object)corpId);
    }

    public void resetBizSensitiveBehavior(Long bizId, String corpId) {
        log.info("resetBizSensitiveBehavior, bizId:{}, corpId:{}", (Object)bizId, (Object)corpId);
        List behaviorSettings = this.qualityCheckBehaviorSettingMapper.queryBehaviorListByBizId(bizId);
        HashMap userBehaviorMap = Maps.newHashMap();
        HashMap contactBehaviorMap = Maps.newHashMap();
        for (QualityCheckBehaviorSetting setting : behaviorSettings) {
            QualitySenderType senderType = QualitySenderType.getByType((Integer)setting.getSenderType());
            if (senderType == QualitySenderType.WEWORK_CONTACT) {
                contactBehaviorMap.put(setting.getCheckValue(), Objects.equals(setting.getCheckStatus(), 1));
                continue;
            }
            userBehaviorMap.put(setting.getCheckValue(), Objects.equals(setting.getCheckStatus(), 1));
        }
        this.weworkUserBehaviorMap.put(bizId, userBehaviorMap);
        this.weworkContactBehaviorMap.put(bizId, contactBehaviorMap);
        log.info("reset biz sensitive behavior success, userBehaviorMap={}, contactBehaviorMap:{}", (Object)userBehaviorMap, (Object)contactBehaviorMap);
    }

    public Set<Integer> getNodeIdsByGroupId(Long bizId, Long groupId) {
        Map<Long, Set<Integer>> map = this.bizId2GroupId2NodeIdMap.get(bizId);
        if (map == null) {
            return Collections.emptySet();
        }
        return map.getOrDefault(groupId, Collections.emptySet());
    }

    public MatchedResult matchSensitiveWord(Long bizId, QualitySenderType senderType, String content) {
        if (bizId == null) {
            return null;
        }
        WordTree wordTree = senderType == QualitySenderType.WEWORK_USER ? this.weworkUserWordTree.get(bizId) : this.weworkContactWordTree.get(bizId);
        if (Objects.isNull(wordTree) || wordTree.isEmpty()) {
            return null;
        }
        List<MatchedWord> sensitiveWords = wordTree.getMatchedWords(content);
        if (CollectionUtils.isEmpty(sensitiveWords)) {
            return null;
        }
        return new MatchedResult(bizId, sensitiveWords);
    }

    public boolean isCheckBehavior(Long bizId, QualitySenderType senderType, QualityBehaviorType behaviorType) {
        Boolean check;
        Map<Integer, Boolean> behaviorMap = senderType == QualitySenderType.WEWORK_USER ? this.weworkUserBehaviorMap.get(bizId) : this.weworkContactBehaviorMap.get(bizId);
        if (behaviorMap != null && (check = behaviorMap.get(behaviorType.getType())) != null) {
            return check;
        }
        return false;
    }

    @PreDestroy
    public void destroy() {
        this.weworkUserWordTree.clear();
        this.weworkContactWordTree.clear();
        this.bizId2GroupId2NodeIdMap.clear();
        this.weworkUserBehaviorMap.clear();
        this.weworkContactBehaviorMap.clear();
    }
}

