/*
 * Decompiled with CFR 0.152.
 */
package com.kuaike.scrm.chat.utils;

import cn.kinyun.wework.sdk.api.chat.ChatApi;
import cn.kinyun.wework.sdk.api.chat.ChatApiBuilder;
import cn.kinyun.wework.sdk.api.chat.ChatApiFactory;
import com.google.common.base.Preconditions;
import com.kuaike.scrm.dal.chat.dto.ChatConfigDto;
import java.util.List;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ChatMessageUtil {
    private static final Logger log = LoggerFactory.getLogger(ChatMessageUtil.class);
    public static final String MSG_ACTION_RECALL = "recall";
    public static final String MSG_ACTION_SEND = "send";

    public static synchronized ChatApi getChatApi(String corpId, String secret, String privateKey, Integer version) throws Exception {
        log.info("getChatApi corpId:{}, secret:{}, version:{}, privateKey:{}", new Object[]{corpId, secret, version, StringUtils.abbreviate((String)privateKey, (int)30)});
        ChatApi api = ChatApiFactory.get((String)corpId);
        if (api != null) {
            return api;
        }
        api = ChatApi.builder().corpId(corpId).secret(secret).addPrikey(version.toString(), privateKey).build();
        ChatApiFactory.put((ChatApi)api);
        return api;
    }

    public static synchronized ChatApi getChatApi(List<ChatConfigDto> chatConfigDtos) throws Exception {
        Preconditions.checkArgument((boolean)CollectionUtils.isNotEmpty(chatConfigDtos), (Object)"chatConfigDtos not empty");
        ChatConfigDto configDto = chatConfigDtos.get(0);
        ChatApi api = ChatApiFactory.get((String)configDto.getCorpId());
        if (api != null) {
            return api;
        }
        ChatApiBuilder apiBuilder = ChatApi.builder().corpId(configDto.getCorpId()).secret(configDto.getSecret());
        for (ChatConfigDto chatConfigDto : chatConfigDtos) {
            apiBuilder.addPrikey(chatConfigDto.getVersion().toString(), chatConfigDto.getPrivateKey());
        }
        api = apiBuilder.build();
        ChatApiFactory.put((ChatApi)api);
        return api;
    }
}

