/*
 * Decompiled with CFR 0.152.
 */
package com.kuaike.scrm.chat.service.impl;

import cn.kinyun.wework.sdk.enums.ChatMsgType;
import com.alibaba.fastjson.JSON;
import com.google.common.collect.Lists;
import com.kuaike.common.errorcode.CommonErrorCode;
import com.kuaike.common.errorcode.UniverseErrorCode;
import com.kuaike.common.exception.BusinessException;
import com.kuaike.scrm.chat.dto.message.MessageListRespDto;
import com.kuaike.scrm.chat.dto.message.MessageReqDto;
import com.kuaike.scrm.chat.service.WeworkMessageService;
import com.kuaike.scrm.common.enums.ExportTaskType;
import com.kuaike.scrm.common.excel.ExcelHeader;
import com.kuaike.scrm.common.utils.BackendExcelUtils;
import com.kuaike.scrm.dal.exporttask.entity.ExportTask;
import com.kuaike.scrm.dal.exporttask.mapper.ExportTaskMapper;
import com.kuaike.scrm.wework.contact.service.impl.AbstractExportService;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service(value="wechatMsgExport")
public class ExportWeChatMsgServiceImpl
extends AbstractExportService {
    private static final Logger log = LoggerFactory.getLogger(ExportWeChatMsgServiceImpl.class);
    @Resource
    private ExportTaskMapper exportTaskMapper;
    @Resource
    private WeworkMessageService weworkMessageService;

    protected Runnable buildTask(ExportTask task, String json) {
        return () -> {
            if (task == null) {
                log.warn("build task is null");
                return;
            }
            try {
                log.info("run task num: {}", (Object)task.getNum());
                String filePath = this.createExportFile(task, json);
                task.setFilePath(filePath);
            }
            catch (BusinessException e) {
                log.error("build task error: ", (Throwable)e);
                task.setErrorMsg(e.getMessage());
            }
            catch (Exception e) {
                log.error("build task error: ", (Throwable)e);
                task.setErrorMsg("\u521b\u5efa\u6587\u4ef6\u5931\u8d25");
            }
            finally {
                task.setStatus(Integer.valueOf(2));
                task.setUpdateTime(new Date());
                this.exportTaskMapper.updateByPrimaryKeySelective((Object)task);
            }
        };
    }

    private String createExportFile(ExportTask task, String json) {
        String corpId = task.getCorpId();
        this.createCorpDir(corpId);
        MessageReqDto messageReqDto = (MessageReqDto)JSON.parseObject((String)json, MessageReqDto.class);
        messageReqDto.setCorpId(corpId);
        messageReqDto.setBizId(task.getBizId());
        messageReqDto.setChatMsgTypes(Lists.newArrayList((Object[])new ChatMsgType[]{ChatMsgType.text}));
        return this.exportExcel(messageReqDto);
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public String exportExcel(MessageReqDto messageReqDto) {
        String url = null;
        String filePath = null;
        try {
            List<ExcelHeader> excelHeaders = this.buildExportExcelHeader();
            filePath = this.createFilePath(messageReqDto.getCorpId(), ExportTaskType.WECHAT_MSG, null);
            MessageListRespDto messageListRespDto = this.weworkMessageService.messageList(messageReqDto);
            BackendExcelUtils.doListToLocalExcel((String)filePath, messageListRespDto.getTalkerMsgList(), excelHeaders, (String)"\u5fae\u4fe1\u4f1a\u8bdd");
            File file = new File(filePath);
            if (file.exists()) {
                url = this.uploadOss(messageReqDto.getCorpId(), file);
            }
        }
        catch (BusinessException e) {
            try {
                log.error("\u5bfc\u51fa\u6587\u4ef6\u5f02\u5e38\uff1aexception:{}", (Object)e.getMessage());
                throw e;
                catch (IOException e2) {
                    log.error("createExportFile IOException error: ", (Throwable)e2);
                    throw new BusinessException((UniverseErrorCode)CommonErrorCode.BUSINESS_ERROR, "json\u683c\u5f0f\u9519\u8bef");
                }
                catch (Exception e3) {
                    log.error("createExportFile error: ", (Throwable)e3);
                    throw new BusinessException((UniverseErrorCode)CommonErrorCode.BUSINESS_ERROR, "\u521b\u5efa\u6587\u4ef6\u5931\u8d25");
                }
            }
            catch (Throwable throwable) {
                if (!StringUtils.isNotBlank(filePath)) throw throwable;
                File file = new File(filePath);
                if (!file.exists()) throw throwable;
                file.deleteOnExit();
                throw throwable;
            }
        }
        if (!StringUtils.isNotBlank((CharSequence)filePath)) return url;
        File file = new File(filePath);
        if (!file.exists()) return url;
        file.deleteOnExit();
        return url;
    }

    private List<ExcelHeader> buildExportExcelHeader() {
        ArrayList excelHeaders = Lists.newArrayList();
        excelHeaders.add(new ExcelHeader("senderName", "\u6d88\u606f\u53d1\u9001\u4eba"));
        excelHeaders.add(new ExcelHeader("msgTime", "\u804a\u5929\u65f6\u95f4", "yyyy-MM-dd HH:mm:ss"));
        excelHeaders.add(new ExcelHeader("msgText", "\u6d88\u606f\u5185\u5bb9"));
        return excelHeaders;
    }
}

