/*
 * Decompiled with CFR 0.152.
 */
package com.kuaike.scrm.chat.service.impl;

import cn.kinyun.wework.sdk.entity.chat.ChatMsg;
import cn.kinyun.wework.sdk.enums.ChatMsgType;
import cn.kinyun.wework.sdk.enums.TalkerType;
import com.alibaba.fastjson.JSON;
import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.kuaike.common.sqlbuilder.dto.PageDto;
import com.kuaike.scrm.chat.dto.QueryChatroomReq;
import com.kuaike.scrm.chat.dto.conversation.ContactSearchRespDto;
import com.kuaike.scrm.chat.dto.conversation.ConversationRespDto;
import com.kuaike.scrm.chat.dto.conversation.ConversationSearchRespDto;
import com.kuaike.scrm.chat.dto.conversation.MessageSearchRespDto;
import com.kuaike.scrm.chat.dto.conversation.WeworkRoomSearchRespDto;
import com.kuaike.scrm.chat.dto.message.MessageDetailReqDto;
import com.kuaike.scrm.chat.dto.message.MessageListRespDto;
import com.kuaike.scrm.chat.dto.message.MessageReqDto;
import com.kuaike.scrm.chat.service.ConversationService;
import com.kuaike.scrm.chat.service.WeworkMessageService;
import com.kuaike.scrm.chat.service.WeworkUserChatConfigService;
import com.kuaike.scrm.common.dto.CurrentUserInfo;
import com.kuaike.scrm.common.dto.StopWatchDto;
import com.kuaike.scrm.common.dto.TalkerMsgCountDto;
import com.kuaike.scrm.common.enums.IsDelete;
import com.kuaike.scrm.common.enums.YnEnum;
import com.kuaike.scrm.common.service.MessageCommonService;
import com.kuaike.scrm.common.utils.ChatCommonUtil;
import com.kuaike.scrm.common.utils.LoginUtils;
import com.kuaike.scrm.dal.agent.mapper.AgentDecryptWeworkContactIdMapper;
import com.kuaike.scrm.dal.chat.dto.ConversationDto;
import com.kuaike.scrm.dal.chat.dto.ConversationListQueryParam;
import com.kuaike.scrm.dal.chat.entity.WeworkConversation;
import com.kuaike.scrm.dal.chat.mapper.WeworkConversationMapper;
import com.kuaike.scrm.dal.system.entity.CustomerStage;
import com.kuaike.scrm.dal.system.mapper.CustomerStageMapper;
import com.kuaike.scrm.dal.wework.dto.UserContactInfo;
import com.kuaike.scrm.dal.wework.dto.WeworkChatroomDto;
import com.kuaike.scrm.dal.wework.dto.conversation.ConversionQueryParams;
import com.kuaike.scrm.dal.wework.dto.conversation.SelectedTagsDto;
import com.kuaike.scrm.dal.wework.entity.WeworkChatRoom;
import com.kuaike.scrm.dal.wework.entity.WeworkContact;
import com.kuaike.scrm.dal.wework.entity.WeworkCorp;
import com.kuaike.scrm.dal.wework.entity.WeworkUser;
import com.kuaike.scrm.dal.wework.mapper.WeworkCorpMapper;
import com.kuaike.scrm.dal.weworktag.dto.TagGroupPair;
import com.kuaike.scrm.dal.weworktag.mapper.WeworkContactTagMapper;
import com.kuaike.scrm.wework.chatroom.dto.request.UserChatroomQuery;
import com.kuaike.scrm.wework.chatroom.service.AgentChatRoomService;
import com.kuaike.scrm.wework.chatroom.service.ChatRoomService;
import com.kuaike.scrm.wework.contact.dto.ContactQueryDto;
import com.kuaike.scrm.wework.contact.service.ContactRelationService;
import com.kuaike.scrm.wework.contact.service.ContactService;
import com.kuaike.scrm.wework.corp.service.WeworkCorpService;
import com.kuaike.scrm.wework.weworkuser.service.AgentWeworkUserService;
import com.kuaike.scrm.wework.weworkuser.service.WeworkUserService;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.tuple.Pair;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class ConversationServiceImpl
implements ConversationService {
    private static final Logger log = LoggerFactory.getLogger(ConversationServiceImpl.class);
    @Autowired
    private WeworkConversationMapper weworkConversationMapper;
    @Resource
    private CustomerStageMapper customerStageMapper;
    @Autowired
    private WeworkUserChatConfigService weworkUserChatConfigService;
    @Autowired
    private WeworkUserService weworkUserService;
    @Autowired
    private AgentWeworkUserService agentWeworkUserService;
    @Autowired
    private ContactService contactService;
    @Autowired
    private ChatRoomService chatRoomService;
    @Autowired
    private AgentChatRoomService agentChatRoomService;
    @Autowired
    private MessageCommonService messageCommonService;
    @Autowired
    private WeworkMessageService weworkMessageService;
    @Autowired
    private WeworkContactTagMapper weworkContactTagMapper;
    @Autowired
    private ContactRelationService contactRelationService;
    @Autowired
    private WeworkCorpMapper weworkCorpMapper;
    @Autowired
    private WeworkCorpService weworkCorpService;
    @Autowired
    private AgentDecryptWeworkContactIdMapper agentDecryptWeworkContactIdMapper;

    private Integer queryNewDKF(Long bizId) {
        WeworkCorp weworkCorp = this.weworkCorpMapper.getByBizId(bizId);
        return Objects.equals(weworkCorp.getIsNewDkf(), 1) ? 1 : 0;
    }

    @Override
    public void handleConversation(ChatMsg chatMsg) {
        List sortedList;
        log.info("handleConversation {}", (Object)chatMsg.getMsgId());
        if (!"send".equals(chatMsg.getAction())) {
            return;
        }
        List<WeworkConversation> conversationList = this.getConversationFromMsg(chatMsg);
        if (CollectionUtils.isEmpty(conversationList)) {
            log.warn("conversationList empty {}", (Object)chatMsg.getMsgId());
            return;
        }
        List conversationDtos = conversationList.stream().map(t -> new ConversationDto(t.getWeworkUserId(), t.getTalkerId())).collect(Collectors.toList());
        Map existsConversationMap = this.weworkConversationMapper.queryExistsConversationBatch(chatMsg.getCorpId(), chatMsg.getBizId(), conversationDtos).stream().collect(Collectors.toMap(this::conversationKey, Function.identity(), (u, v) -> v));
        ArrayList updateList = Lists.newArrayList();
        ArrayList insertList = Lists.newArrayList();
        for (WeworkConversation conversation : conversationList) {
            WeworkConversation existsConversation = (WeworkConversation)existsConversationMap.get(this.conversationKey(conversation));
            if (Objects.nonNull(existsConversation)) {
                conversation.setId(existsConversation.getId());
                updateList.add(conversation);
                continue;
            }
            insertList.add(conversation);
        }
        if (CollectionUtils.isNotEmpty((Collection)insertList)) {
            sortedList = insertList.stream().sorted(Comparator.comparing(WeworkConversation::getWeworkUserId).thenComparing(WeworkConversation::getTalkerId)).collect(Collectors.toList());
            int count = this.weworkConversationMapper.batchInsert(sortedList);
            log.info("batchInsert:{}", (Object)count);
        }
        if (CollectionUtils.isNotEmpty((Collection)updateList)) {
            sortedList = updateList.stream().sorted(Comparator.comparing(WeworkConversation::getId)).collect(Collectors.toList());
            int count = this.weworkConversationMapper.batchUpdate(sortedList);
            log.info("batchUpdate:{}", (Object)count);
        }
    }

    private String conversationKey(WeworkConversation conversation) {
        return conversation.getWeworkUserId() + "_" + conversation.getTalkerId();
    }

    private List<WeworkConversation> getConversationFromMsg(ChatMsg chatMsg) {
        Set<String> permitUserSet = this.weworkUserChatConfigService.getPermitUserList(chatMsg.getCorpId());
        ArrayList list = Lists.newArrayList();
        if (chatMsg.getTalkerType().intValue() == TalkerType.CONTACT.getValue()) {
            String weworkId = "";
            String senderId = chatMsg.getFrom();
            String talkerId = (String)chatMsg.getTolist().get(0);
            if (permitUserSet.contains(senderId)) {
                weworkId = chatMsg.getFrom();
                list.add(this.buildConversation(chatMsg.getBizId(), chatMsg, senderId, talkerId, weworkId));
            }
            if (permitUserSet.contains(talkerId)) {
                weworkId = talkerId;
                list.add(this.buildConversation(chatMsg.getBizId(), chatMsg, senderId, senderId, weworkId));
            }
        } else {
            Sets.SetView robotIds;
            if (permitUserSet.contains(chatMsg.getFrom())) {
                list.add(this.buildConversation(chatMsg.getBizId(), chatMsg, chatMsg.getFrom(), chatMsg.getRoomId(), chatMsg.getFrom()));
            }
            Set<Object> memberIds = Sets.newHashSet();
            if (CollectionUtils.isNotEmpty((Collection)chatMsg.getTolist())) {
                memberIds = chatMsg.getTolist().stream().collect(Collectors.toSet());
            }
            if (CollectionUtils.isEmpty((Collection)(robotIds = Sets.intersection(permitUserSet, (Set)memberIds)))) {
                return list;
            }
            for (String weworkUserId : robotIds) {
                list.add(this.buildConversation(chatMsg.getBizId(), chatMsg, chatMsg.getFrom(), chatMsg.getRoomId(), weworkUserId));
            }
        }
        if (CollectionUtils.isEmpty((Collection)list)) {
            return list;
        }
        return list;
    }

    private WeworkConversation buildConversation(Long bizId, ChatMsg chatMsg, String senderId, String talkerId, String weworkId) {
        WeworkConversation conversation = new WeworkConversation();
        conversation.setBizId(bizId);
        conversation.setCorpId(chatMsg.getCorpId());
        conversation.setDigestUser(senderId);
        conversation.setDigest(this.getDigest(chatMsg));
        conversation.setCreateTime(new Date());
        conversation.setIsDeleted(Integer.valueOf(IsDelete.NOT_DELETED.getDelStatus()));
        conversation.setLastMsgTime(new Date(chatMsg.getMsgTime()));
        conversation.setMsgId(chatMsg.getMsgId());
        conversation.setMsgType(chatMsg.getMsgType());
        conversation.setTalkerType(chatMsg.getTalkerType());
        conversation.setExternalType(Integer.valueOf(chatMsg.getExternalContact() != false ? 1 : 0));
        conversation.setTalkerId(talkerId);
        conversation.setUpdateTime(new Date());
        conversation.setWeworkUserId(weworkId);
        conversation.setIsSend(Integer.valueOf(weworkId.equals(senderId) ? 1 : 0));
        return conversation;
    }

    private String getDigest(ChatMsg chatMsg) {
        return this.convertToDigest(chatMsg);
    }

    private String convertToDigest(ChatMsg chatMsg) {
        String digestStr = "";
        switch (ChatMsgType.valueOf((String)chatMsg.getMsgType())) {
            case text: {
                digestStr = StringUtils.abbreviate((String)chatMsg.getText().getContent(), (int)20);
                break;
            }
            case agree: {
                digestStr = "[\u540c\u610f]";
                break;
            }
            case disagree: {
                digestStr = "[\u4e0d\u540c\u610f]";
                break;
            }
            case calendar: {
                digestStr = "[\u65e5\u7a0b]";
                break;
            }
            case card: {
                if ("\u5fae\u4fe1".equals(chatMsg.getCard().getCorpName())) {
                    digestStr = "[\u4e2a\u4eba\u540d\u7247]";
                    break;
                }
                digestStr = "[\u4f01\u4e1a\u5fae\u4fe1\u540d\u7247]";
                break;
            }
            case collect: {
                digestStr = "[\u586b\u8868]";
                break;
            }
            case chatrecord: {
                digestStr = "[\u4f1a\u8bdd\u8bb0\u5f55]";
                break;
            }
            case docmsg: {
                digestStr = "[\u5728\u7ebf\u6587\u6863]";
                break;
            }
            case emotion: {
                digestStr = "[\u52a8\u56fe]";
                break;
            }
            case external_redpacket: 
            case redpacket: {
                digestStr = "[\u7ea2\u5305]";
                break;
            }
            case file: {
                digestStr = "[\u6587\u4ef6]";
                break;
            }
            case image: {
                digestStr = "[\u56fe\u7247]";
                break;
            }
            case link: {
                digestStr = "[\u94fe\u63a5\u5361\u7247]";
                break;
            }
            case location: {
                digestStr = "[\u5b9a\u4f4d]";
                break;
            }
            case markdown: {
                digestStr = "[markdown]";
                break;
            }
            case meeting: {
                digestStr = "[\u4f1a\u8bae]";
                break;
            }
            case meeting_voice_call: {
                digestStr = "[\u89c6\u9891\u4f1a\u8bae]";
                break;
            }
            case mixed: {
                digestStr = "[\u6df7\u5408\u6d88\u606f]";
                break;
            }
            case revoke: {
                digestStr = "[\u64a4\u56de\u6d88\u606f]";
                break;
            }
            case video: {
                digestStr = "[\u89c6\u9891]";
                break;
            }
            case voice: {
                digestStr = "[\u8bed\u97f3]";
                break;
            }
            case voip_doc_share: {
                digestStr = "[\u97f3\u9891\u5171\u4eab\u6587\u6863]";
                break;
            }
            case vote: {
                digestStr = "[\u6295\u7968]";
                break;
            }
            case weapp: {
                digestStr = "[\u5c0f\u7a0b\u5e8f]";
                break;
            }
            default: {
                digestStr = "[\u672a\u77e5\u7c7b\u578b\u6d88\u606f]";
            }
        }
        return digestStr;
    }

    @Override
    public List<ConversationRespDto> getConversationList(ConversionQueryParams req, CurrentUserInfo currentUserInfo) {
        CustomerStage customerStage;
        log.info("getConversationList req:{}", (Object)JSON.toJSONString((Object)req));
        req.validate();
        if ((CollectionUtils.isNotEmpty((Collection)req.getSelectedTags()) || req.getStageId() != null) && req.getTalkerType() != null && req.getTalkerType() == 2) {
            return Lists.newArrayList();
        }
        Long bizId = LoginUtils.getCurrentUserBizId();
        Integer useAgent = this.queryNewDKF(bizId);
        String weworkUserId = this.weworkUserService.getDecryptWeworkUserId(req.getWeworkUserId());
        req.setWeworkUserId(weworkUserId);
        List<String> matchedContactIds = this.filterSelectedTagGroup(req, currentUserInfo, useAgent);
        ConversationListQueryParam param = new ConversationListQueryParam();
        param.setPageDto(req.getPageDto());
        param.setStageId(req.getStageId());
        param.setBizId(currentUserInfo.getBizId());
        param.setTalkerType(req.getTalkerType());
        param.setUseAgent(useAgent);
        param.setWeworkUserId(weworkUserId);
        param.setContactIds(matchedContactIds);
        if (CollectionUtils.isNotEmpty((Collection)req.getSelectedTags())) {
            param.setCheckContactIds(Integer.valueOf(1));
        }
        if (req.getStageId() != null && (customerStage = this.customerStageMapper.queryStageByPrimaryKey(req.getStageId())) != null) {
            param.setStageType(customerStage.getType());
        }
        int count = this.weworkConversationMapper.queryListCountByWeworkUserId(param);
        req.getPageDto().setCount(Integer.valueOf(count));
        if (0 == count) {
            return Collections.emptyList();
        }
        List wechatConversationList = this.weworkConversationMapper.queryListByWeworkUserId(param);
        List contactIds = wechatConversationList.stream().filter(t -> t.getTalkerType().intValue() == TalkerType.CONTACT.getValue()).map(WeworkConversation::getTalkerId).distinct().collect(Collectors.toList());
        List roomMemberIds = wechatConversationList.stream().filter(t -> t.getTalkerType().intValue() == TalkerType.CHATROOM.getValue()).map(WeworkConversation::getDigestUser).distinct().collect(Collectors.toList());
        ContactQueryDto queryDto = new ContactQueryDto();
        queryDto.setContactIds(contactIds);
        queryDto.setWeworkUserId(weworkUserId);
        queryDto.setBizId(currentUserInfo.getBizId());
        queryDto.setUseAgent(useAgent);
        List contactInfos = this.contactRelationService.queryContactInfo(queryDto);
        Map contactMap = contactInfos.stream().collect(Collectors.toMap(UserContactInfo::getContactId, Function.identity(), (u, v) -> v));
        Map internalTalkerMap = this.weworkUserService.queryUserByWeworkUserIds(currentUserInfo.getBizId(), contactIds, useAgent, currentUserInfo.getCorpId());
        List roomIds = wechatConversationList.stream().filter(t -> t.getTalkerType().intValue() == TalkerType.CHATROOM.getValue()).map(WeworkConversation::getTalkerId).collect(Collectors.toList());
        UserChatroomQuery userChatroomQuery = new UserChatroomQuery();
        userChatroomQuery.setChatroomIds(roomIds);
        userChatroomQuery.setWeworkUserId(weworkUserId);
        userChatroomQuery.setBizId(currentUserInfo.getBizId());
        userChatroomQuery.setUseAgent(useAgent);
        String decryptCorpId = this.weworkCorpService.getDecryptCorpId(currentUserInfo.getCorpId(), useAgent, bizId);
        userChatroomQuery.setCorpId(decryptCorpId);
        List chatroomDtos = this.chatRoomService.queryUserChatroom(userChatroomQuery);
        Map chatRoomMap = chatroomDtos.stream().collect(Collectors.toMap(WeworkChatRoom::getWeworkRoomId, Function.identity(), (u, v) -> v));
        WeworkUser weworkUser = this.weworkUserService.selectByWeworkUserId(currentUserInfo.getCorpId(), currentUserInfo.getBizId(), req.getWeworkUserId());
        ArrayList result = Lists.newArrayListWithExpectedSize((int)wechatConversationList.size());
        Map contactIdMap = Maps.newHashMap();
        if (useAgent == 1) {
            contactIdMap = this.agentDecryptWeworkContactIdMapper.queryByDecryptContactIds(bizId, contactIds);
        }
        for (WeworkConversation conversation : wechatConversationList) {
            ConversationRespDto dto = new ConversationRespDto();
            dto.setLastMsgDigest(conversation.getDigest());
            dto.setLastMsgSendTime(conversation.getLastMsgTime());
            dto.setTalkerId(conversation.getTalkerId());
            if (useAgent == 1) {
                dto.setTalkerId(contactIdMap.getOrDefault(conversation.getTalkerId(), conversation.getTalkerId()));
            }
            dto.setTalkerType(conversation.getTalkerType());
            dto.setIsTop(conversation.getIsTop());
            dto.setExternalType(conversation.getExternalType());
            result.add(dto);
            if (conversation.getTalkerType().intValue() == TalkerType.CONTACT.getValue()) {
                UserContactInfo contact = (UserContactInfo)contactMap.get(conversation.getTalkerId());
                if (!Objects.isNull(contact)) {
                    dto.setConversationId(ChatMsg.getConversationId(null, (String)weworkUserId, (String)conversation.getTalkerId()));
                    dto.setTalkerName(contact.getOriginName());
                    dto.setType(contact.getExternalType());
                    dto.setCorpName(contact.getCorpName());
                    dto.setAvatar(contact.getAvatar());
                    dto.setIsDeleted(contact.getIsDeleted());
                    dto.setIsZombieFans(contact.getIsZombieFans());
                    dto.setTalkerRemark(contact.getRemark());
                } else {
                    WeworkUser weworkUser1 = (WeworkUser)internalTalkerMap.get(conversation.getTalkerId());
                    if (!Objects.isNull(weworkUser1)) {
                        String conversationId = YnEnum.YES.getValue().equals(useAgent) ? ChatMsg.getConversationId(null, (String)weworkUserId, (String)conversation.getTalkerId()) : ChatMsg.getConversationId(null, (String)weworkUserId, (String)weworkUser1.getWeworkUserId());
                        dto.setConversationId(conversationId);
                        dto.setTalkerName(weworkUser1.getName());
                        dto.setType(2);
                        dto.setCorpFullName(null);
                        dto.setCorpName(null);
                        dto.setAvatar(weworkUser1.getAvatar());
                    } else {
                        dto.setConversationId(ChatMsg.getConversationId(null, (String)weworkUserId, (String)conversation.getTalkerId()));
                        log.info("not found talkerId={}", (Object)conversation.getTalkerId());
                    }
                }
            } else {
                WeworkChatroomDto chatroomDto = chatRoomMap.getOrDefault(conversation.getTalkerId(), new WeworkChatroomDto());
                dto.setTalkerName(chatroomDto.getName());
                dto.setConversationId(conversation.getTalkerId());
                dto.setIsLevel(chatroomDto.getIsLevel());
                dto.setIsDismiss(chatroomDto.getIsDismiss());
            }
            if (conversation.getDigestUser() == null) continue;
            UserContactInfo sender = (UserContactInfo)contactMap.get(conversation.getDigestUser());
            WeworkUser digestUser = (WeworkUser)internalTalkerMap.get(conversation.getDigestUser());
            if (Objects.nonNull(sender)) {
                dto.setSenderName(sender.getRemark());
                continue;
            }
            if (Objects.nonNull(digestUser)) {
                dto.setSenderName(digestUser.getName());
                continue;
            }
            if (weworkUser == null || !conversation.getDigest().equals(weworkUserId)) continue;
            dto.setSenderName(weworkUser.getName());
        }
        return result;
    }

    private List<String> filterSelectedTagGroup(ConversionQueryParams req, CurrentUserInfo currentUserInfo, Integer useAgent) {
        List contactIds = Lists.newArrayList();
        if ((Objects.isNull(req.getTalkerType()) || req.getTalkerType().intValue() == TalkerType.CONTACT.getValue()) && CollectionUtils.isNotEmpty((Collection)req.getSelectedTags())) {
            ArrayList groupPairs = Lists.newArrayList();
            for (SelectedTagsDto selectedTag : req.getSelectedTags()) {
                for (String tagId : selectedTag.getTagIds()) {
                    TagGroupPair item = new TagGroupPair();
                    item.setTagId(tagId);
                    item.setGroupId(selectedTag.getTagGroupId());
                    groupPairs.add(item);
                }
            }
            if (CollectionUtils.isNotEmpty((Collection)groupPairs)) {
                contactIds = this.weworkContactTagMapper.queryMatchedContactIdByGroupAndTag(useAgent, currentUserInfo.getBizId(), currentUserInfo.getCorpId(), req.getWeworkUserId(), (List)groupPairs);
            }
        }
        return contactIds;
    }

    @Override
    public ConversationSearchRespDto conversationSearch(String weworkUserId, String query, Integer type) {
        WeworkConversation weworkConversation;
        log.info("conversationSearch with weworkUserId={},query={},type={}", new Object[]{weworkUserId, query, type});
        Preconditions.checkArgument((boolean)StringUtils.isNotBlank((CharSequence)weworkUserId), (Object)"\u6210\u5458ID\u4e3a\u7a7a");
        CurrentUserInfo currentUserInfo = LoginUtils.getCurrentUser();
        Preconditions.checkArgument((currentUserInfo != null ? 1 : 0) != 0, (Object)"\u7528\u6237\u4fe1\u606f\u4e3a\u7a7a");
        Long bizId = currentUserInfo.getBizId();
        String corpId = currentUserInfo.getCorpId();
        Integer useAgent = this.queryNewDKF(bizId);
        StopWatchDto timer = new StopWatchDto("conversationSearch", true, log);
        HashSet contactIds = Sets.newHashSet();
        HashSet chatroomIds = Sets.newHashSet();
        HashMap talkerId2ConversationMap = Maps.newHashMap();
        List<Object> contactList = Lists.newArrayList();
        if (type == null || type == 0 || type == 1) {
            contactList = this.queryContact(useAgent, weworkUserId, query, bizId, timer, contactIds);
        }
        List<Object> chatRoomList = Lists.newArrayList();
        if (type == null || type == 0 || type == 2) {
            QueryChatroomReq req = new QueryChatroomReq();
            req.setTalkerId2ConversationMap(talkerId2ConversationMap);
            req.setBizId(bizId);
            req.setQuery(query);
            req.setUseAgent(useAgent);
            req.setWeworkUserId(weworkUserId);
            req.setTimer(timer);
            req.setCorpId(corpId);
            chatRoomList = this.queryChatroom(req, chatroomIds);
        }
        List<MessageSearchRespDto> messageList = this.queryMessageHistory(useAgent, weworkUserId, query, bizId, timer, contactIds, chatroomIds, talkerId2ConversationMap, corpId);
        for (Object item : contactList) {
            weworkConversation = (WeworkConversation)talkerId2ConversationMap.get(((ContactSearchRespDto)item).getTalkerId());
            if (Objects.isNull(weworkConversation)) continue;
            ((ContactSearchRespDto)item).setLastMsgDigest(weworkConversation.getDigest());
            ((ContactSearchRespDto)item).setLastMsgSendTime(weworkConversation.getLastMsgTime());
            ((ContactSearchRespDto)item).setExternalType(weworkConversation.getExternalType());
        }
        for (Object item : chatRoomList) {
            weworkConversation = (WeworkConversation)talkerId2ConversationMap.get(((WeworkRoomSearchRespDto)item).getTalkerId());
            if (Objects.isNull(weworkConversation)) continue;
            ((WeworkRoomSearchRespDto)item).setLastMsgDigest(weworkConversation.getDigest());
            ((WeworkRoomSearchRespDto)item).setLastMsgSendTime(weworkConversation.getLastMsgTime());
            ((WeworkRoomSearchRespDto)item).setExternalType(weworkConversation.getExternalType());
        }
        ConversationSearchRespDto result = new ConversationSearchRespDto();
        result.setContactList(contactList);
        result.setWeworkRoomList(chatRoomList);
        result.setMessageList(messageList);
        timer.stop();
        timer.print();
        return result;
    }

    private List<WeworkRoomSearchRespDto> queryChatroom(QueryChatroomReq param, Set<String> chatroomIds) {
        param.getTimer().start("queryListByWeworkUserIdNameQuery-weworkRoom");
        UserChatroomQuery req = new UserChatroomQuery();
        req.setQuery(param.getQuery());
        req.setBizId(param.getBizId());
        req.setCorpId(param.getCorpId());
        req.setWeworkUserId(param.getWeworkUserId());
        req.setUseAgent(param.getUseAgent());
        List weworkChatroomDtos = this.chatRoomService.queryUserChatroom(req);
        param.getTimer().stop();
        ArrayList chatRoomList = Lists.newArrayListWithExpectedSize((int)weworkChatroomDtos.size());
        for (WeworkChatroomDto weworkChatRoom : weworkChatroomDtos) {
            WeworkRoomSearchRespDto wechatChatRoomSearchRespDto = new WeworkRoomSearchRespDto();
            wechatChatRoomSearchRespDto.from((WeworkChatRoom)weworkChatRoom, param.getQuery());
            WeworkConversation weworkConversation = param.getTalkerId2ConversationMap().get(weworkChatRoom.getWeworkRoomId());
            if (Objects.nonNull(weworkConversation)) {
                wechatChatRoomSearchRespDto.setExternalType(weworkConversation.getExternalType());
            }
            chatRoomList.add(wechatChatRoomSearchRespDto);
            chatroomIds.add(weworkChatRoom.getWeworkRoomId());
        }
        return chatRoomList;
    }

    private List<ContactSearchRespDto> queryContact(Integer useAgent, String weworkUserId, String query, Long bizId, StopWatchDto timer, Set<String> contactIds) {
        timer.start("queryByWeworkUserIdNameQuery-contact");
        ContactQueryDto queryDto = new ContactQueryDto();
        queryDto.setQuery(query);
        queryDto.setBizId(bizId);
        queryDto.setWeworkUserId(weworkUserId);
        queryDto.setUseAgent(useAgent);
        List userContactInfos = this.contactRelationService.queryContactInfo(queryDto);
        timer.stop();
        ArrayList contactList = Lists.newArrayListWithExpectedSize((int)userContactInfos.size());
        for (UserContactInfo contact : userContactInfos) {
            ContactSearchRespDto wechatContactSearchRespDto = new ContactSearchRespDto();
            wechatContactSearchRespDto.from(contact, query);
            contactIds.add(contact.getContactId());
            String conversationId = ChatMsg.getConversationId(null, (String)weworkUserId, (String)contact.getContactId());
            wechatContactSearchRespDto.setConversationId(conversationId);
            contactList.add(wechatContactSearchRespDto);
        }
        return contactList;
    }

    private List<MessageSearchRespDto> queryMessageHistory(Integer useAgent, String weworkUserId, String query, Long bizId, StopWatchDto timer, Set<String> contactIds, Set<String> chatroomIds, Map<String, WeworkConversation> talkId2ConversationMap, String corpId) {
        timer.start("\u804a\u5929\u8bb0\u5f55\u5339\u914d\u6761\u6570");
        List talkerMsgCountDtos = Lists.newArrayList();
        if (StringUtils.isNotBlank((CharSequence)query)) {
            talkerMsgCountDtos = this.messageCommonService.queryTalkerCountByWechatIdMessageQuery(weworkUserId, query);
        }
        LinkedHashMap talkerIdCountMap = talkerMsgCountDtos.stream().collect(Collectors.toMap(TalkerMsgCountDto::getTalkerId, TalkerMsgCountDto::getCount, (k1, k2) -> k2, LinkedHashMap::new));
        timer.stop();
        timer.start("\u7fa4\u7684\u6635\u79f0");
        Set talkerChatRoomIds = talkerIdCountMap.keySet().stream().filter(k -> ChatMsg.getTalkerTypeByConversationId((String)k) == TalkerType.CHATROOM.getValue()).collect(Collectors.toSet());
        Map<String, String> weworkRoomIdNickNameMap = Objects.equals(1, useAgent) ? this.agentChatRoomService.selectRoomList(bizId, (Collection)Lists.newArrayList(talkerChatRoomIds)).stream().collect(Collectors.toMap(WeworkChatRoom::getWeworkRoomId, WeworkChatRoom::getName, (u, v) -> v)) : this.chatRoomService.selectRoomList(null, bizId, (Collection)Lists.newArrayList(talkerChatRoomIds)).stream().collect(Collectors.toMap(WeworkChatRoom::getWeworkRoomId, WeworkChatRoom::getName, (u, v) -> v));
        timer.stop();
        timer.start("\u8054\u7cfb\u4eba\u7684\u6635\u79f0");
        Set talkerContactIds = talkerIdCountMap.keySet().stream().filter(k -> ChatMsg.getTalkerTypeByConversationId((String)k) == TalkerType.CONTACT.getValue()).map(a -> ChatCommonUtil.getTalkerId((String)a, (String)weworkUserId)).collect(Collectors.toSet());
        Map internalTalkerMap = this.weworkUserService.queryUserByWeworkUserIds(bizId, talkerContactIds, useAgent, corpId);
        HashSet allTalkers = Sets.newHashSet();
        allTalkers.addAll(talkerChatRoomIds);
        allTalkers.addAll(talkerContactIds);
        allTalkers.addAll(contactIds);
        allTalkers.addAll(chatroomIds);
        ConversationListQueryParam param = new ConversationListQueryParam();
        param.setWeworkUserId(weworkUserId);
        param.setPageDto(null);
        param.setContactIds((List)Lists.newArrayList((Iterable)allTalkers));
        param.setBizId(bizId);
        param.setUseAgent(useAgent);
        List conversationList = this.weworkConversationMapper.queryListByWeworkUserId(param);
        if (CollectionUtils.isNotEmpty((Collection)conversationList)) {
            Map<String, WeworkConversation> talkId2Conversation = conversationList.stream().collect(Collectors.toMap(a -> a.getTalkerId(), a -> a));
            talkId2ConversationMap.putAll(talkId2Conversation);
        }
        Map<String, WeworkConversation> conversationMap = conversationList.stream().collect(Collectors.toMap(a -> {
            String conversationId = a.getTalkerType().intValue() == TalkerType.CHATROOM.getValue() ? ChatMsg.getConversationId((String)a.getTalkerId(), null, null) : ChatMsg.getConversationId(null, (String)a.getWeworkUserId(), (String)a.getTalkerId());
            return conversationId;
        }, a -> a));
        Map contactMap = this.contactService.selectContactList(useAgent, bizId, weworkUserId, (List)Lists.newArrayList(talkerContactIds)).stream().collect(Collectors.toMap(WeworkContact::getContactId, Function.identity(), (u, v) -> v));
        timer.stop();
        timer.start("fillResult");
        ArrayList messageList = Lists.newArrayList();
        for (Map.Entry entry : talkerIdCountMap.entrySet()) {
            String conversationId = (String)entry.getKey();
            MessageSearchRespDto messageSearchRespDto = new MessageSearchRespDto();
            messageSearchRespDto.setConversationId(conversationId);
            messageSearchRespDto.setMatchCount((Integer)entry.getValue());
            WeworkConversation weworkConversation = conversationMap.get(conversationId);
            if (!Objects.isNull(weworkConversation)) {
                messageSearchRespDto.setLastMsgDigest(weworkConversation.getDigestUser());
                messageSearchRespDto.setLastMsgSendTime(weworkConversation.getLastMsgTime());
                messageSearchRespDto.setExternalType(weworkConversation.getExternalType());
            }
            if (ChatMsg.getTalkerTypeByConversationId((String)conversationId) == TalkerType.CHATROOM.getValue()) {
                messageSearchRespDto.setTalkerName(weworkRoomIdNickNameMap.get(conversationId));
                messageSearchRespDto.setTalkerType(TalkerType.CHATROOM.getValue());
            } else {
                String talkerId = ChatCommonUtil.getTalkerId((String)conversationId, (String)weworkUserId);
                if (StringUtils.isBlank((CharSequence)talkerId)) continue;
                messageSearchRespDto.setTalkerType(TalkerType.CONTACT.getValue());
                WeworkContact contact = (WeworkContact)contactMap.get(talkerId);
                if (!Objects.isNull(contact)) {
                    messageSearchRespDto.setTalkerName(contact.getName());
                    messageSearchRespDto.setAvatar(contact.getAvatar());
                } else {
                    WeworkUser weworkUser = (WeworkUser)internalTalkerMap.get(talkerId);
                    if (!Objects.isNull(weworkUser)) {
                        messageSearchRespDto.setTalkerName(weworkUser.getName());
                        messageSearchRespDto.setTalkerRemark(weworkUser.getAlias());
                        messageSearchRespDto.setAvatar(weworkUser.getAvatar());
                    } else {
                        log.info("not exist talkId={}", (Object)talkerId);
                    }
                }
            }
            messageList.add(messageSearchRespDto);
        }
        return messageList;
    }

    @Override
    public MessageListRespDto conversationSearchMessageDetail(MessageDetailReqDto req) {
        PageDto pageDto;
        log.info("conversationSearchMessageDetail req:{}", (Object)JSON.toJSONString((Object)req));
        Preconditions.checkArgument((boolean)StringUtils.isNotBlank((CharSequence)req.getConversationId()), (Object)"conversationId\u4e0d\u80fd\u4e3a\u7a7a");
        if (req.getType() == null) {
            req.setType(0);
        }
        if (null == req.getPageDto()) {
            req.setPageDto(new PageDto());
        }
        if ((pageDto = req.getPageDto()) == null) {
            pageDto = new PageDto();
            pageDto.setPageNum(Integer.valueOf(1));
            pageDto.setPageSize(Integer.valueOf(20));
        }
        StopWatchDto timer = new StopWatchDto("conversationSearchMessageDetail", true, log);
        String corpId = LoginUtils.getCurrentUserCorpId();
        Long bizId = LoginUtils.getCurrentUserBizId();
        String decryptCorpId = this.weworkCorpService.getDecryptCorpId(corpId, null, null);
        timer.start("queryPageList");
        Pair pair = this.messageCommonService.queryPageList(req.getConversationId(), req.getQuery(), req.getType(), Integer.valueOf(pageDto.getOffset()), pageDto.getPageSize(), decryptCorpId);
        List messageList = (List)pair.getLeft();
        pageDto.setCount(Integer.valueOf(((Long)pair.getRight()).intValue()));
        timer.stop();
        timer.start("getWechatMessageListRespDto");
        MessageReqDto reqDto = new MessageReqDto();
        reqDto.setConversationId(req.getConversationId());
        reqDto.setWeworkUserId(req.getWeworkUserId());
        reqDto.setTalkerId(req.getTalkerId());
        reqDto.setMessageList(messageList);
        reqDto.setAscOrder(Boolean.FALSE);
        reqDto.setBizId(bizId);
        reqDto.setCorpId(corpId);
        MessageListRespDto result = this.weworkMessageService.getMessageListRespDto(reqDto);
        timer.stop();
        timer.print();
        return result;
    }
}

