/*
 * Decompiled with CFR 0.152.
 */
package com.kuaike.scrm.chat.service.impl;

import cn.kinyun.wework.sdk.api.AccessTokenApi;
import cn.kinyun.wework.sdk.api.chat.ChatApi;
import cn.kinyun.wework.sdk.api.chat.ChatApiBuilder;
import cn.kinyun.wework.sdk.entity.AccessToken;
import cn.kinyun.wework.sdk.entity.chat.ChatData;
import cn.kinyun.wework.sdk.entity.chat.ChatMsg;
import cn.kinyun.wework.sdk.entity.chat.EncryptChatData;
import cn.kinyun.wework.sdk.exception.WeworkException;
import com.alibaba.fastjson.JSON;
import com.kuaike.common.errorcode.CommonErrorCode;
import com.kuaike.common.errorcode.UniverseErrorCode;
import com.kuaike.common.exception.BusinessException;
import com.kuaike.scrm.chat.dto.ChatDataReq;
import com.kuaike.scrm.chat.dto.ChatKeyCheckReq;
import com.kuaike.scrm.chat.dto.ChatKeyCheckResp;
import com.kuaike.scrm.chat.service.ChatKeyService;
import com.kuaike.scrm.common.dto.CurrentUserInfo;
import com.kuaike.scrm.common.dto.PublishPayloadDto;
import com.kuaike.scrm.common.dto.StopWatchDto;
import com.kuaike.scrm.common.enums.PublishPayloadType;
import com.kuaike.scrm.common.utils.LoginUtils;
import com.kuaike.scrm.dal.agent.entity.AgentToken;
import com.kuaike.scrm.dal.agent.mapper.AgentTokenMapper;
import com.kuaike.scrm.dal.chat.dto.ChatConfigDto;
import com.kuaike.scrm.dal.chat.entity.WeworkChatKey;
import com.kuaike.scrm.dal.chat.entity.WeworkChatKeyCriteria;
import com.kuaike.scrm.dal.chat.entity.WeworkChatSecret;
import com.kuaike.scrm.dal.chat.entity.WeworkChatTmpKey;
import com.kuaike.scrm.dal.chat.mapper.WeworkChatKeyMapper;
import com.kuaike.scrm.dal.chat.mapper.WeworkChatSecretMapper;
import com.kuaike.scrm.dal.chat.mapper.WeworkChatTmpKeyMapper;
import java.security.GeneralSecurityException;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationContext;
import org.springframework.stereotype.Service;

@Service
public class ChatKeyServiceImpl
implements ChatKeyService {
    private static final Logger log = LoggerFactory.getLogger(ChatKeyServiceImpl.class);
    @Autowired
    private WeworkChatTmpKeyMapper chatTmpKeyMapper;
    @Autowired
    private WeworkChatKeyMapper chatKeyMapper;
    @Autowired
    private WeworkChatSecretMapper weworkChatSecretMapper;
    @Autowired
    private AccessTokenApi accessTokenApi;
    @Autowired
    private ApplicationContext context;
    @Autowired
    private AgentTokenMapper agentTokenMapper;

    @Override
    public ChatKeyCheckResp checkKey(ChatKeyCheckReq req) {
        CurrentUserInfo currentUserInfo = LoginUtils.getCurrentUser();
        log.info("checkKey with req={}, userId={},corpId={},bizId={}", new Object[]{req, currentUserInfo.getId(), currentUserInfo.getCorpId(), currentUserInfo.getBizId()});
        req.validate();
        Long bizId = currentUserInfo.getBizId();
        Long operatorId = currentUserInfo.getId();
        Boolean checkSuccess = null;
        AgentToken agentToken = this.agentTokenMapper.queryByBizId(bizId);
        String corpId = "";
        if (Objects.isNull(agentToken) || StringUtils.isBlank((CharSequence)agentToken.getCorpId())) {
            ChatKeyCheckResp chatKeyCheckResp = new ChatKeyCheckResp();
            chatKeyCheckResp.setReason("\u8bf7\u5148\u914d\u7f6e\u81ea\u5efa\u5e94\u7528\u3002");
            chatKeyCheckResp.setSuccess(false);
            return chatKeyCheckResp;
        }
        corpId = agentToken.getCorpId();
        ChatKeyCheckResp resp = new ChatKeyCheckResp();
        if (this.checkVersionExists(req, bizId, resp)) {
            return resp;
        }
        AccessToken accessToken = null;
        try {
            accessToken = this.accessTokenApi.getAccessToken(corpId, req.getSecret());
        }
        catch (WeworkException e) {
            log.error("get chatSecretToken with weworkException,corpId={}", (Object)corpId, (Object)e);
            if (!this.isWXServerAvailable(e.getErrorCode())) {
                log.info("server not available,corpId={},accessToken={}", (Object)corpId, (Object)accessToken);
            }
            return new ChatKeyCheckResp(false, "secret\u9519\u8bef\uff0c\u8bf7\u786e\u8ba4");
        }
        catch (Exception e) {
            log.error("get chatToken with error,corpId={}", (Object)corpId, (Object)e);
            String errBizMessage = StringUtils.abbreviate((String)e.getMessage(), (int)32);
            return new ChatKeyCheckResp(false, errBizMessage);
        }
        this.checkNeedUpdateSecret(req, bizId, corpId, operatorId, accessToken);
        WeworkChatTmpKey item = this.buildWeworkChatTmpKey(req, bizId, corpId, operatorId);
        this.chatTmpKeyMapper.insertSelective((Object)item);
        checkSuccess = this.fetchLastMsgAndCheck(req, bizId, corpId, checkSuccess, resp);
        if (checkSuccess.booleanValue()) {
            WeworkChatKey newKey = new WeworkChatKey();
            BeanUtils.copyProperties((Object)item, (Object)newKey);
            this.chatKeyMapper.insertSelective((Object)newKey);
            this.chatTmpKeyMapper.deleteByPrimaryKey((Object)item);
            WeworkChatSecret chatSecret = this.weworkChatSecretMapper.queryByCorpId(corpId);
            chatSecret.setVersion(req.getVersion());
            chatSecret.setUpdateBy(operatorId);
            chatSecret.setUpdateTime(new Date());
            this.weworkChatSecretMapper.updateByPrimaryKeySelective((Object)chatSecret);
            this.publishReloadKeyEvent(newKey);
        } else {
            item.setIsDeleted(Boolean.valueOf(true));
            this.chatTmpKeyMapper.updateByPrimaryKey((Object)item);
        }
        return resp;
    }

    private boolean isWXServerAvailable(Integer code) {
        if (code == null) {
            return true;
        }
        return code != -1 && code != 6000;
    }

    private void checkNeedUpdateSecret(ChatKeyCheckReq req, Long bizId, String corpId, Long operatorId, AccessToken accessToken) {
        Date expireTime;
        Long expires;
        WeworkChatSecret chatSecret = this.weworkChatSecretMapper.queryByBizId(bizId);
        Date now = new Date();
        if (chatSecret != null) {
            if (!req.getSecret().equals(chatSecret.getSecret())) {
                expires = accessToken.getExpires();
                expireTime = new Date(now.getTime() + expires * 1000L);
                WeworkChatSecret weworkChatSecret = new WeworkChatSecret();
                weworkChatSecret.setId(chatSecret.getId());
                weworkChatSecret.setAccessToken(accessToken.getAccessToken());
                weworkChatSecret.setExpireTime(expireTime);
                weworkChatSecret.setUpdateTime(now);
                weworkChatSecret.setUpdateBy(operatorId);
                weworkChatSecret.setUpdateTime(now);
                weworkChatSecret.setSecret(req.getSecret());
                this.weworkChatSecretMapper.updateByPrimaryKeySelective((Object)weworkChatSecret);
            }
        } else {
            expires = accessToken.getExpires();
            expireTime = new Date(now.getTime() + expires * 1000L);
            chatSecret = this.buildChatSecret(req, bizId, corpId, operatorId, accessToken, now, expireTime);
            this.weworkChatSecretMapper.insertSelective((Object)chatSecret);
        }
        List list = this.chatKeyMapper.queryByBizId(bizId);
        if (CollectionUtils.isNotEmpty(list = list.stream().filter(a -> !req.getSecret().equals(a.getSecret())).collect(Collectors.toList()))) {
            WeworkChatKey weworkChatKey = new WeworkChatKey();
            weworkChatKey.setSecret(req.getSecret());
            weworkChatKey.setUpdateTime(now);
            weworkChatKey.setUpdateBy(operatorId);
            WeworkChatKeyCriteria chatKeyCriteria = new WeworkChatKeyCriteria();
            chatKeyCriteria.createCriteria().andIdIn(list.stream().map(WeworkChatKey::getId).collect(Collectors.toList()));
            this.chatKeyMapper.updateByExampleSelective((Object)weworkChatKey, (Object)chatKeyCriteria);
        }
    }

    private WeworkChatSecret buildChatSecret(ChatKeyCheckReq req, Long bizId, String corpId, Long operatorId, AccessToken accessToken, Date now, Date expireTime) {
        WeworkChatSecret chatSecret = new WeworkChatSecret();
        chatSecret.setSecret(req.getSecret());
        chatSecret.setBizId(bizId);
        chatSecret.setCorpId(corpId);
        chatSecret.setCreateBy(operatorId);
        chatSecret.setCreateTime(now);
        chatSecret.setExpireTime(expireTime);
        chatSecret.setUpdateTime(now);
        chatSecret.setUpdateBy(operatorId);
        chatSecret.setAccessToken(accessToken.getAccessToken());
        chatSecret.setVersion(Integer.valueOf(-1));
        chatSecret.setStatus(Integer.valueOf(1));
        return chatSecret;
    }

    private void publishReloadKeyEvent(WeworkChatKey newKey) {
        PublishPayloadDto publishPayloadDto = new PublishPayloadDto();
        publishPayloadDto.setType(PublishPayloadType.CONVERSATION_MSG_SAVE_PRIVATE_KEY_CHANGE);
        publishPayloadDto.setContent(StringUtils.joinWith((String)"##", (Object[])new Object[]{newKey.getBizId(), newKey.getCorpId(), newKey.getVersion()}));
        this.context.publishEvent((Object)publishPayloadDto);
    }

    private Boolean fetchLastMsgAndCheck(ChatKeyCheckReq req, Long bizId, String corpId, Boolean checkSuccess, ChatKeyCheckResp resp) {
        ChatApi chatApi;
        ChatConfigDto chatConfigDto = new ChatConfigDto();
        chatConfigDto.setCorpId(corpId);
        chatConfigDto.setPrivateKey(req.getPrivateKey());
        chatConfigDto.setSecret(req.getSecret());
        chatConfigDto.setVersion(req.getVersion());
        chatConfigDto.setBizId(bizId);
        try {
            chatApi = new ChatApiBuilder().corpId(corpId).secret(req.getSecret()).addPrikey(String.valueOf(req.getVersion()), req.getPrivateKey()).timeout(3).build();
        }
        catch (Exception e) {
            log.error("build chat api failed", (Throwable)e);
            throw new BusinessException((UniverseErrorCode)CommonErrorCode.PARAM_ERROR, "\u6784\u9020\u4f1a\u8bdd\u5bc6\u94a5\u5931\u8d25");
        }
        EncryptChatData lastMessage = null;
        long lastSeq = 0L;
        while (true) {
            ChatDataReq dataReq = new ChatDataReq();
            dataReq.setSeq(lastSeq);
            dataReq.setLimit(1000);
            EncryptChatData currentLastMessage = null;
            try {
                currentLastMessage = this.pullLastMessage(chatApi, dataReq);
            }
            catch (Exception e) {
                log.error("pull message failed", (Throwable)e);
            }
            if (currentLastMessage == null) break;
            lastMessage = currentLastMessage;
            lastSeq = currentLastMessage.getSeq();
        }
        if (lastMessage == null) {
            checkSuccess = false;
            resp.setSuccess(false);
            resp.setReason("\u672a\u62c9\u53d6\u5230\u4efb\u4f55\u4fe1\u606f\uff0c\u8bf7\u786e\u8ba4\u662f\u5426\u53d1\u9001\u4e86\u6d88\u606f");
        } else {
            int msgVersion = Integer.parseInt(lastMessage.getPublickeyVer());
            if (msgVersion != req.getVersion()) {
                checkSuccess = false;
                resp.setSuccess(false);
                resp.setReason("\u8bbe\u7f6e\u9519\u8bef\uff0c\u6700\u65b0\u6d88\u606f\u7248\u672c\u4e0d\u5339\u914d");
            }
        }
        if (checkSuccess == null) {
            try {
                ChatMsg chatMsg = this.decrypt(chatApi, lastMessage);
                log.info("\u62c9\u53d6\u5230\u6700\u540e\u4e00\u6761\u6d88\u606f:{}", (Object)chatMsg);
                checkSuccess = true;
                resp.setReason("");
                resp.setSuccess(true);
            }
            catch (Exception e) {
                log.error("decrypt error:{}", (Object)JSON.toJSONString((Object)lastMessage), (Object)e);
                checkSuccess = false;
                resp.setReason("\u6821\u9a8c\u5931\u8d25\uff0c\u8bf7\u786e\u8ba4\u586b\u5199\u4e86\u6b63\u786e\u7684key\uff0c\u5e76\u53d1\u9001\u4e86\u6d88\u606f");
                resp.setSuccess(false);
            }
        }
        return checkSuccess;
    }

    private ChatMsg decrypt(ChatApi chatApi, EncryptChatData encryptChatData) throws GeneralSecurityException {
        return chatApi.decrypt(encryptChatData);
    }

    private EncryptChatData pullLastMessage(ChatApi chatApi, ChatDataReq req) {
        log.info("pullMessage req:{}", (Object)JSON.toJSONString((Object)req));
        StopWatchDto stopWatchDto = new StopWatchDto("PullMessage", true, log);
        stopWatchDto.start("getChatData");
        ChatData chatdata = chatApi.getChatdata(req.getSeq(), req.getLimit());
        stopWatchDto.stop();
        if (Objects.isNull(chatdata)) {
            log.info("chat data is null");
            stopWatchDto.print();
            return null;
        }
        List chatDataList = chatdata.getChatdata();
        if (CollectionUtils.isEmpty((Collection)chatDataList)) {
            log.info("chatDataList is empty");
            stopWatchDto.print();
            return null;
        }
        stopWatchDto.print();
        return (EncryptChatData)chatDataList.get(chatDataList.size() - 1);
    }

    private boolean checkVersionExists(ChatKeyCheckReq req, Long bizId, ChatKeyCheckResp resp) {
        int count = this.chatKeyMapper.queryCountByVersion(bizId, req.getVersion());
        if (count > 0) {
            resp.setReason("\u7248\u672c\u53f7\u5df2\u7ecf\u5b58\u5728\uff0c\u8bf7\u786e\u8ba4\u7248\u672c\u662f\u5426\u6b63\u786e");
            resp.setSuccess(false);
            return true;
        }
        return false;
    }

    private WeworkChatTmpKey buildWeworkChatTmpKey(ChatKeyCheckReq req, Long bizId, String corpId, Long operatorId) {
        Date now = new Date();
        WeworkChatTmpKey item = new WeworkChatTmpKey();
        item.setBizId(bizId);
        item.setCorpId(corpId);
        item.setPrivateKey(req.getPrivateKey());
        item.setPublicKey(req.getPublicKey());
        item.setSecret(req.getSecret());
        item.setVersion(req.getVersion());
        item.setCreateTime(now);
        item.setCreateBy(operatorId);
        item.setUpdateTime(now);
        item.setUpdateBy(operatorId);
        return item;
    }
}

