/*
 * Decompiled with CFR 0.152.
 */
package com.kuaike.scrm.chat.service;

import cn.kinyun.wework.sdk.entity.chat.ChatMsg;
import cn.kinyun.wework.sdk.entity.chat.msg.Revoke;
import com.kuaike.scrm.dal.qualitycheck.entity.QualityCheckLog;
import com.kuaike.scrm.dal.qualitycheck.mapper.QualityCheckLogMapper;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.stream.Collectors;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import org.apache.commons.collections4.CollectionUtils;
import org.redisson.api.RBlockingQueue;
import org.redisson.api.RDelayedQueue;
import org.redisson.api.RedissonClient;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.redis.core.StringRedisTemplate;
import org.springframework.stereotype.Component;

@Component
public class ChatMsgRedisDelayQueueManager {
    private static final Logger log = LoggerFactory.getLogger(ChatMsgRedisDelayQueueManager.class);
    private final AtomicBoolean consumerThreadRun = new AtomicBoolean(true);
    private RBlockingQueue<ChatMsg> blockingFairQueue;
    private RDelayedQueue<ChatMsg> delayedQueue;
    @Autowired
    private QualityCheckLogMapper qualityCheckLogMapper;
    @Autowired
    private StringRedisTemplate redisTemplate;
    @Autowired
    private RedissonClient redissonClient;

    @PostConstruct
    public void init() {
        this.blockingFairQueue = this.redissonClient.getBlockingQueue(ChatMsg.class.getName());
        this.delayedQueue = this.redissonClient.getDelayedQueue(this.blockingFairQueue);
        Thread consumerThread = new Thread(() -> {
            while (this.consumerThreadRun.get()) {
                try {
                    ChatMsg chatMsg = (ChatMsg)this.blockingFairQueue.take();
                    this.dealRecallMsg(chatMsg);
                }
                catch (InterruptedException e) {
                    log.error("take chat message failed", (Throwable)e);
                    Thread.currentThread().interrupt();
                }
            }
        });
        consumerThread.start();
        log.info("chatMsg delay queue start");
    }

    @PreDestroy
    public void destroy() {
        this.consumerThreadRun.getAndSet(false);
        this.delayedQueue.destroy();
    }

    public void addQueue(ChatMsg chatMsg, long delay, TimeUnit timeUnit) {
        this.delayedQueue.offer((Object)chatMsg, delay, timeUnit);
    }

    public void dealRecallMsg(ChatMsg chatMsg) {
        Revoke revoke = chatMsg.getRevoke();
        String preMsgId = revoke.getPreMsgId();
        log.info("dealRecallMsg msgId={},preMsgId={}", (Object)chatMsg.getMsgId(), (Object)preMsgId);
        List checkLogs = this.qualityCheckLogMapper.queryByMsgId(preMsgId);
        if (CollectionUtils.isNotEmpty((Collection)checkLogs)) {
            List ids = checkLogs.stream().filter(a -> a.getIsRevoke() == 0).map(QualityCheckLog::getId).collect(Collectors.toList());
            if (CollectionUtils.isNotEmpty(ids)) {
                this.qualityCheckLogMapper.updateRevoke(ids);
                log.info("recall msg success msgId={},preMsgId={}", (Object)chatMsg.getMsgId(), (Object)preMsgId);
            } else {
                log.info("msg have been recall, exit. msgId={},preMsgId={}", (Object)chatMsg.getMsgId(), (Object)preMsgId);
            }
        } else {
            Long count = this.redisTemplate.opsForValue().increment((Object)preMsgId);
            this.redisTemplate.expire((Object)preMsgId, 120L, TimeUnit.SECONDS);
            if (count != null && count > 3L) {
                log.info("\u91cd\u8bd53\u6b21\u540e\u672a\u627e\u5230\u9700\u8981\u64a4\u56de\u7684\u6d88\u606f,msgId={},revokeMsgId={}, exit", (Object)chatMsg.getMsgId(), (Object)preMsgId);
            } else {
                this.addQueue(chatMsg, 5L, TimeUnit.SECONDS);
                log.info("recall msg put into delayQueue, msgId={}, preMsgId={},\u7b2c{}\u6b21", new Object[]{chatMsg.getMsgId(), preMsgId, count});
            }
        }
    }
}

