/*
 * Decompiled with CFR 0.152.
 */
package com.kuaike.scrm.call.factory;

import com.alibaba.fastjson.JSONObject;
import com.google.common.base.Preconditions;
import com.kuaike.common.errorcode.CommonErrorCode;
import com.kuaike.common.errorcode.UniverseErrorCode;
import com.kuaike.common.exception.BusinessException;
import com.kuaike.common.utils.JacksonUtil;
import com.kuaike.scrm.bjy.sdk.service.BjyPartnerService;
import com.kuaike.scrm.call.dto.CallConfig;
import com.kuaike.scrm.call.dto.CallExtenCountRespDto;
import com.kuaike.scrm.call.dto.CallMemberDto;
import com.kuaike.scrm.call.enums.ApiTypeEnum;
import com.kuaike.scrm.call.enums.CallOutTypeEnum;
import com.kuaike.scrm.call.factory.CallMemberService;
import com.kuaike.scrm.call.utils.CallSmsUtil;
import com.kuaike.scrm.dal.app.entity.AppBindings;
import com.kuaike.scrm.dal.app.mapper.AppBindingsMapper;
import com.kuaike.scrm.dal.call.entity.CallAccountUsing;
import com.kuaike.scrm.dal.call.entity.CallMember;
import com.kuaike.scrm.dal.call.entity.CallMemberCriteria;
import com.kuaike.scrm.dal.call.mapper.CallAccountUsingMapper;
import com.kuaike.scrm.dal.call.mapper.CallMemberMapper;
import com.kuaike.scrm.dal.permission.mapper.UserMapper;
import java.io.IOException;
import java.util.Date;
import java.util.Map;
import java.util.Random;
import java.util.TreeMap;
import java.util.concurrent.TimeUnit;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.stereotype.Service;
import org.springframework.util.ObjectUtils;

@Service
public class ZhongTongCallMemberServiceImpl
implements CallMemberService {
    private static final Logger log = LoggerFactory.getLogger(ZhongTongCallMemberServiceImpl.class);
    @Value(value="${spring.redis.key.prefix}")
    private String redisKeyPrefix;
    @Value(value="${aliyun.sms.scrm.signName}")
    private String signName;
    @Value(value="${aliyun.sms.verificationCode.templateCode.ad}")
    private String adTemplateCode;
    @Value(value="${app.call.addMemberUrl}")
    private String addMemberUrl;
    @Value(value="${app.call.editMemberUrl}")
    private String editMemberUrl;
    @Value(value="${app.call.appCode}")
    private String appCode;
    @Resource
    private RedisTemplate<String, Object> redisTemplate;
    @Autowired
    private BjyPartnerService bjyPartnerService;
    @Autowired
    private UserMapper userMapper;
    @Autowired
    private CallMemberMapper callMemberMapper;
    @Autowired
    private CallAccountUsingMapper callAccountUsingMapper;
    @Autowired
    private AppBindingsMapper bindingsMapper;
    private Random random = new Random();
    private static final String CODE_KEY = "SCRM_BJY_CALL_CODE_KEY_%s";
    private static final int CODE_CACHE_EXPIRE = 15;
    private static final int[] digit = new int[]{0, 1, 2, 3, 4, 5, 6, 7, 8, 9};

    @Override
    public void add(CallMemberDto reqDto) {
        log.info("add reqDto:{}", (Object)reqDto);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void mod(CallMemberDto reqDto) {
        log.info("mod reqDto:{}", (Object)reqDto);
        Long bizId = reqDto.getBizId();
        String phone = reqDto.getPhone();
        Long userId = reqDto.getToUserId();
        CallMember member = null;
        if (1 == reqDto.getValidate()) {
            if (phone.equals(reqDto.getNewPhone())) {
                CallConfig callConfig = this.callConfig(bizId);
                if (callConfig.getSupplierType() == null || callConfig.getSupplierType().intValue() != CallOutTypeEnum.ZHONG_TONG.getValue() || !StringUtils.isBlank((CharSequence)reqDto.getExten())) return;
                String userName = this.userMapper.getUserNameByUserId(userId);
                Map<String, String> params = this.getAddMemberParams(phone, userName, userId);
                JSONObject jsonObject = this.bjyPartnerService.bjyPost(bizId, this.addMemberUrl, params);
                String exten = jsonObject.getJSONObject("data").getString("exten");
                String doubleCallExten = jsonObject.getJSONObject("data").getString("exten_double_call");
                member = CallMember.builder().id(reqDto.getId()).phone(reqDto.getNewPhone()).updateBy(userId).updateTime(new Date()).enable(Integer.valueOf(1)).validate(Integer.valueOf(1)).exten(exten).doubleCallExten(doubleCallExten).build();
            } else {
                Map<String, String> params = this.getModMemberParams(reqDto.getPhone(), userId);
                this.bjyPartnerService.bjyPost(bizId, this.editMemberUrl, params);
                member = CallMember.builder().id(reqDto.getId()).phone(reqDto.getNewPhone()).updateBy(reqDto.getUserId()).updateTime(new Date()).enable(Integer.valueOf(0)).validate(Integer.valueOf(0)).build();
            }
        } else {
            member = CallMember.builder().id(reqDto.getId()).phone(reqDto.getNewPhone()).updateBy(reqDto.getUserId()).updateTime(new Date()).enable(Integer.valueOf(0)).validate(Integer.valueOf(0)).build();
        }
        this.callMemberMapper.updateByPrimaryKeySelective((Object)member);
    }

    @Override
    public void code(CallMemberDto reqDto) {
        log.info("code reqDto:{}", (Object)reqDto);
        String phone = reqDto.getPhone();
        String key = this.redisKeyPrefix + String.format(CODE_KEY, phone);
        Object existsVerifyCode = this.redisTemplate.opsForValue().get((Object)key);
        if (existsVerifyCode != null) {
            throw new BusinessException((UniverseErrorCode)CommonErrorCode.BUSINESS_ERROR, "\u9a8c\u8bc1\u7801\u5df2\u53d1\u9001\u8bf7\u7a0d\u540e\u5c1d\u8bd5");
        }
        String verifyCode = this.getVerifyCode();
        String params = "{\"code\":" + verifyCode + "}";
        boolean result = CallSmsUtil.sendSms(phone, this.signName, this.adTemplateCode, params);
        if (result) {
            this.redisTemplate.opsForValue().set((Object)key, (Object)verifyCode, 15L, TimeUnit.MINUTES);
        }
        log.info("\u53d1\u9001\u77ed\u4fe1\u9a8c\u8bc1\u7801,mobile:{},verifyCode:{}, result:{}", new Object[]{phone, verifyCode, result});
    }

    @Override
    public void validate(CallMemberDto reqDto) {
        log.info("validate reqDto:{}", (Object)reqDto);
        Long bizId = reqDto.getBizId();
        String phone = reqDto.getPhone();
        Long userId = reqDto.getToUserId();
        String key = this.redisKeyPrefix + String.format(CODE_KEY, phone);
        Object cache = this.redisTemplate.opsForValue().get((Object)key);
        Preconditions.checkArgument((!ObjectUtils.isEmpty((Object)cache) ? 1 : 0) != 0, (Object)"\u8bf7\u5148\u83b7\u53d6\u9a8c\u8bc1\u7801");
        String cacheCode = String.valueOf(cache);
        Preconditions.checkArgument((boolean)cacheCode.equals(reqDto.getCode()), (Object)"\u9a8c\u8bc1\u7801\u9519\u8bef");
        CallMember member = (CallMember)this.callMemberMapper.selectOne((Object)CallMember.builder().id(reqDto.getId()).build());
        if (member != null && StringUtils.isBlank((CharSequence)member.getExten()) && StringUtils.isBlank((CharSequence)member.getDoubleCallExten())) {
            CallMemberCriteria userCriteria = new CallMemberCriteria();
            userCriteria.createCriteria().andBizIdEqualTo(bizId).andExtenNotEqualTo("");
            int used = this.callMemberMapper.selectCountByExample((Object)userCriteria);
            CallAccountUsing using = (CallAccountUsing)this.callAccountUsingMapper.selectOne((Object)CallAccountUsing.builder().bizId(bizId).wayType(Integer.valueOf(ApiTypeEnum.SIP.getValue())).build());
            if (using != null) {
                Preconditions.checkArgument((using.getOpenSeatCount() > used ? 1 : 0) != 0, (Object)"\u5750\u5e2d\u6570\u91cf\u4e0d\u8db3\uff0c\u8bf7\u5148\u5f00\u901a\u5750\u5e2d");
            }
        }
        String userName = this.userMapper.getUserNameByUserId(userId);
        Map<String, String> params = this.getAddMemberParams(phone, userName, userId);
        JSONObject jsonObject = this.bjyPartnerService.bjyPost(bizId, this.addMemberUrl, params);
        String exten = jsonObject.getJSONObject("data").getString("exten");
        String doubleCallExten = jsonObject.getJSONObject("data").getString("exten_double_call");
        this.callMemberMapper.updateByPrimaryKeySelective((Object)CallMember.builder().id(reqDto.getId()).updateBy(reqDto.getUserId()).updateTime(new Date()).enable(Integer.valueOf(1)).validate(Integer.valueOf(1)).exten(exten).doubleCallExten(doubleCallExten).build());
    }

    @Override
    public CallExtenCountRespDto extenCount(CallMemberDto reqDto) {
        log.info("extenCount reqDto:{}", (Object)reqDto);
        Long bizId = reqDto.getBizId();
        CallMemberCriteria userCriteria = new CallMemberCriteria();
        userCriteria.createCriteria().andBizIdEqualTo(bizId).andExtenNotEqualTo("");
        int used = this.callMemberMapper.selectCountByExample((Object)userCriteria);
        CallAccountUsing using = (CallAccountUsing)this.callAccountUsingMapper.selectOne((Object)CallAccountUsing.builder().bizId(bizId).wayType(Integer.valueOf(ApiTypeEnum.SIP.getValue())).build());
        CallAccountUsing doubleUsing = (CallAccountUsing)this.callAccountUsingMapper.selectOne((Object)CallAccountUsing.builder().bizId(bizId).wayType(Integer.valueOf(ApiTypeEnum.LOCAL.getValue())).build());
        return CallExtenCountRespDto.builder().total(using == null ? 0 : using.getOpenSeatCount()).doubleTotal(doubleUsing == null ? 0 : doubleUsing.getOpenSeatCount()).used(used).build();
    }

    private CallConfig callConfig(Long bizId) {
        CallConfig callConfig;
        AppBindings bindings = (AppBindings)this.bindingsMapper.selectOne((Object)AppBindings.builder().bizId(bizId).appCode(this.appCode).build());
        Preconditions.checkArgument((bindings != null && bindings.getIsOpen() == 1 ? 1 : 0) != 0, (Object)"\u4f01\u4e1a\u5c1a\u672a\u5f00\u901a\u5916\u547c\u529f\u80fd");
        String configJson = bindings.getConfigJson();
        try {
            callConfig = (CallConfig)JacksonUtil.str2Obj((String)configJson, CallConfig.class);
        }
        catch (IOException e) {
            throw new BusinessException((UniverseErrorCode)CommonErrorCode.BUSINESS_ERROR, "\u89e3\u6790\u5916\u547c\u914d\u7f6e\u5f02\u5e38");
        }
        return callConfig;
    }

    private String getVerifyCode() {
        StringBuilder stringBuilder = new StringBuilder();
        for (int i = 0; i < 6; ++i) {
            int j = this.random.nextInt(10);
            if (i == 0 && j == 0) {
                j = 1;
            }
            stringBuilder.append(digit[j]);
        }
        return stringBuilder.toString();
    }

    private Map<String, String> getAddMemberParams(String phone, String name, Long userId) {
        TreeMap<String, String> result = new TreeMap<String, String>();
        result.put("phone", phone);
        result.put("name", name);
        result.put("user_number", String.valueOf(userId));
        return result;
    }

    private Map<String, String> getModMemberParams(String newPhone, Long userId) {
        TreeMap<String, String> result = new TreeMap<String, String>();
        result.put("phone", newPhone);
        result.put("user_number", String.valueOf(userId));
        return result;
    }
}

