/*
 * Decompiled with CFR 0.152.
 */
package com.kuaike.scrm.call.service.impl;

import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import com.kuaike.common.errorcode.CommonErrorCode;
import com.kuaike.common.errorcode.UniverseErrorCode;
import com.kuaike.common.exception.BusinessException;
import com.kuaike.scrm.bjy.sdk.service.BjyPartnerService;
import com.kuaike.scrm.call.dto.CallExtenCountRespDto;
import com.kuaike.scrm.call.dto.CallMemberDto;
import com.kuaike.scrm.call.dto.MemberDto;
import com.kuaike.scrm.call.dto.req.CallMemberReqDto;
import com.kuaike.scrm.call.dto.resp.CallMemberRespDto;
import com.kuaike.scrm.call.factory.CallMemberFacade;
import com.kuaike.scrm.call.service.CallCommonService;
import com.kuaike.scrm.call.service.CallMemberService;
import com.kuaike.scrm.common.dto.CurrentUserInfo;
import com.kuaike.scrm.common.perm.service.UserRoleCommonService;
import com.kuaike.scrm.common.service.NodeService;
import com.kuaike.scrm.common.service.ScrmUserService;
import com.kuaike.scrm.common.utils.IdGen;
import com.kuaike.scrm.common.utils.LoginUtils;
import com.kuaike.scrm.dal.app.mapper.AppBindingsMapper;
import com.kuaike.scrm.dal.call.dto.CallMemberQueryParams;
import com.kuaike.scrm.dal.call.entity.CallMember;
import com.kuaike.scrm.dal.call.entity.CallMemberCriteria;
import com.kuaike.scrm.dal.call.mapper.CallAccountUsingMapper;
import com.kuaike.scrm.dal.call.mapper.CallMemberMapper;
import com.kuaike.scrm.dal.permission.dto.UserQueryParams;
import com.kuaike.scrm.dal.permission.entity.User;
import com.kuaike.scrm.dal.permission.mapper.UserMapper;
import com.kuaike.scrm.dal.system.mapper.OrganizationMapper;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.TreeMap;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.elasticsearch.common.util.set.Sets;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;
import org.springframework.util.ObjectUtils;

@Service
public class CallMemberServiceImpl
extends CallCommonService
implements CallMemberService {
    private static final Logger log = LoggerFactory.getLogger(CallMemberServiceImpl.class);
    @Value(value="${app.call.deleteMemberUrl}")
    private String deleteMemberUrl;
    @Value(value="${app.call.addMemberUrl}")
    private String addMemberUrl;
    @Value(value="${app.call.editMemberUrl}")
    private String editMemberUrl;
    @Value(value="${app.call.forbiddenMemberUrl}")
    private String forbiddenMemberUrl;
    @Value(value="${app.call.appCode}")
    private String appCode;
    @Autowired
    private CallMemberMapper callMemberMapper;
    @Autowired
    private UserMapper userMapper;
    @Autowired
    private IdGen idGen;
    @Autowired
    private BjyPartnerService bjyPartnerService;
    @Autowired
    private OrganizationMapper organizationMapper;
    @Autowired
    private AppBindingsMapper bindingsMapper;
    @Autowired
    private CallAccountUsingMapper callAccountUsingMapper;
    @Autowired
    private CallMemberFacade callMemberFacade;

    public CallMemberServiceImpl(UserRoleCommonService userRoleCommonService, ScrmUserService scrmUserService, NodeService nodeService) {
        this.userRoleCommonService = userRoleCommonService;
        this.scrmUserService = scrmUserService;
        this.nodeService = nodeService;
    }

    @Override
    public List<CallMemberRespDto> list(CallMemberReqDto reqDto) {
        CurrentUserInfo currentUserInfo = LoginUtils.getCurrentUser();
        reqDto.validateListParams(currentUserInfo);
        Long bizId = currentUserInfo.getBizId();
        log.info("reqDto:{}, bizId:{}", (Object)reqDto, (Object)bizId);
        CallMemberQueryParams params = reqDto.to(bizId, currentUserInfo.getId());
        Collection<Long> userIds = this.getManageUserIds(bizId, reqDto.getNodeId(), reqDto.getUserId());
        params.setUserIds(userIds);
        List members = this.callMemberMapper.queryList(params);
        ArrayList<CallMemberRespDto> resultList = new ArrayList<CallMemberRespDto>();
        if (!CollectionUtils.isEmpty((Collection)members)) {
            List<Long> nodeIds = members.stream().map(CallMember::getNodeId).collect(Collectors.toList());
            Map<Long, String> nodePNameMap = this.nodePName(bizId, nodeIds);
            for (CallMember member : members) {
                member.setOrgName(nodePNameMap.get(member.getNodeId()));
                resultList.add(CallMemberRespDto.from(member));
            }
        }
        if (params.getPageDto() != null) {
            params.getPageDto().setCount(Integer.valueOf(this.callMemberMapper.queryCount(params)));
            params.getPageDto().setCurPageCount(Integer.valueOf(resultList.size()));
        }
        return resultList;
    }

    @Override
    public void mod(CallMemberReqDto reqDto) {
        CurrentUserInfo currentUser = LoginUtils.getCurrentUser();
        reqDto.validateModParams(currentUser);
        Long bizId = currentUser.getBizId();
        log.info("mod member : {}", (Object)reqDto);
        CallMember callMember = (CallMember)this.callMemberMapper.selectOne((Object)CallMember.builder().bizId(bizId).id(reqDto.getId()).build());
        if (!callMember.getPhone().equals(reqDto.getPhone())) {
            CallMember phoneMember = (CallMember)this.callMemberMapper.selectOne((Object)CallMember.builder().bizId(bizId).phone(reqDto.getPhone()).build());
            Preconditions.checkArgument((boolean)ObjectUtils.isEmpty((Object)phoneMember), (Object)"\u624b\u673a\u53f7\u5df2\u5b58\u5728");
        }
        CallMemberDto callMemberDto = CallMemberDto.builder().bizId(currentUser.getBizId()).phone(callMember.getPhone()).newPhone(reqDto.getPhone()).exten(callMember.getExten()).validate(callMember.getValidate()).userId(currentUser.getId()).toUserId(callMember.getUserId()).id(callMember.getId()).build();
        this.callMemberFacade.getInstance(currentUser.getBizId()).mod(callMemberDto);
    }

    @Override
    public void add(CallMemberReqDto reqDto) {
        CurrentUserInfo currentUser = LoginUtils.getCurrentUser();
        reqDto.validateAddParams(currentUser);
        log.info("add member : {}", (Object)reqDto);
        CallMemberDto callMemberDto = CallMemberDto.builder().bizId(currentUser.getBizId()).build();
        this.callMemberFacade.getInstance(currentUser.getBizId()).add(callMemberDto);
        List<MemberDto> users = reqDto.getUsers();
        List userNums = users.stream().map(MemberDto::getId).collect(Collectors.toList());
        Set phones = users.stream().map(MemberDto::getPhone).collect(Collectors.toSet());
        Preconditions.checkArgument((phones.size() == users.size() ? 1 : 0) != 0, (Object)"\u624b\u673a\u53f7\u4e0d\u80fd\u91cd\u590d");
        List userInfoByNums = this.userMapper.getUserInfoByNums(userNums);
        List userIds = userInfoByNums.stream().map(User::getId).collect(Collectors.toList());
        CallMemberCriteria userCriteria = new CallMemberCriteria();
        userCriteria.createCriteria().andBizIdEqualTo(currentUser.getBizId()).andUserIdIn(userIds);
        List userMember = this.callMemberMapper.selectByExample((Object)userCriteria);
        if (!CollectionUtils.isEmpty((Collection)userMember)) {
            List id = userMember.stream().map(CallMember::getUserId).collect(Collectors.toList());
            List userInfoByIds = this.userMapper.getUserInfoByIds(id);
            List names = userInfoByIds.stream().map(User::getName).collect(Collectors.toList());
            throw new BusinessException((UniverseErrorCode)CommonErrorCode.SIGN_INVALIDATE, StringUtils.join((Object[])names.toArray(), (String)",") + "\u6210\u5458\u5df2\u5b58\u5728");
        }
        CallMemberCriteria callMemberCriteria = new CallMemberCriteria();
        callMemberCriteria.createCriteria().andBizIdEqualTo(currentUser.getBizId()).andPhoneIn((List)Lists.newArrayList(phones));
        List callMembers = this.callMemberMapper.selectByExample((Object)callMemberCriteria);
        if (!CollectionUtils.isEmpty((Collection)callMembers)) {
            List phone = callMembers.stream().map(CallMember::getPhone).collect(Collectors.toList());
            throw new BusinessException((UniverseErrorCode)CommonErrorCode.SIGN_INVALIDATE, StringUtils.join((Object[])phone.toArray(), (String)",") + "\u624b\u673a\u53f7\u5df2\u5b58\u5728");
        }
        ArrayList members = Lists.newArrayList();
        for (MemberDto memberDto : users) {
            members.add(this.buildCallMember(currentUser, memberDto, userInfoByNums.stream().filter(user -> user.getNum().equals(memberDto.getId())).findFirst().get().getId()));
        }
        this.callMemberMapper.batchInsert((List)members);
    }

    private CallMember buildCallMember(CurrentUserInfo currentUser, MemberDto user, Long userId) {
        return CallMember.builder().num(this.idGen.getNum()).bizId(currentUser.getBizId()).corpId(currentUser.getCorpId()).userId(userId).phone(user.getPhone()).enable(Integer.valueOf(0)).validate(Integer.valueOf(0)).exten("").doubleCallExten("").createTime(new Date()).createBy(currentUser.getId()).updateTime(new Date()).updateBy(currentUser.getId()).isDeleted(Integer.valueOf(0)).build();
    }

    @Override
    public void del(CallMemberReqDto reqDto) {
        CurrentUserInfo currentUser = LoginUtils.getCurrentUser();
        reqDto.validateIdParams(currentUser);
        Long bizId = currentUser.getBizId();
        log.info("del member: {}", (Object)reqDto);
        CallMember callMember = (CallMember)this.callMemberMapper.selectOne((Object)CallMember.builder().bizId(currentUser.getBizId()).id(reqDto.getId()).build());
        if (ObjectUtils.isEmpty((Object)callMember)) {
            log.warn("del member: \u6839\u636eid\u67e5\u8be2\u5916\u547c\u6210\u5458\u4e3a\u7a7a, bizId:{}\uff0c\u88ab\u5220\u9664\u7684id:{}", (Object)bizId, (Object)reqDto.getId());
            return;
        }
        log.info("del member: bizId:{}, \u5f53\u524d\u64cd\u4f5c\u4ebauserId:{}, \u88ab\u5220\u6210\u5458\u7684userId:{}", new Object[]{bizId, currentUser.getId(), callMember.getUserId()});
        Map<String, String> params = this.getDeleteMemberParams(callMember.getUserId());
        if (Objects.equals(callMember.getValidate(), 1)) {
            this.bjyPartnerService.bjyPost(bizId, this.deleteMemberUrl, params);
        }
        this.callMemberMapper.deleteByPrimaryKey((Object)CallMember.builder().id(reqDto.getId()).build());
    }

    @Override
    public void enable(CallMemberReqDto reqDto) {
        int enable;
        CurrentUserInfo currentUser = LoginUtils.getCurrentUser();
        reqDto.validateIdParams(currentUser);
        Long bizId = currentUser.getBizId();
        log.info("enable member : {}", (Object)reqDto);
        CallMember callMember = (CallMember)this.callMemberMapper.selectOne((Object)CallMember.builder().bizId(bizId).id(reqDto.getId()).build());
        if (Objects.equals(callMember.getEnable(), 0)) {
            if (!Objects.equals(callMember.getValidate(), 1)) {
                throw new BusinessException((UniverseErrorCode)CommonErrorCode.SIGN_INVALIDATE, "\u624b\u673a\u53f7\u672a\u9a8c\u8bc1");
            }
            enable = 1;
        } else {
            enable = 0;
        }
        this.callMemberMapper.updateByPrimaryKeySelective((Object)CallMember.builder().id(reqDto.getId()).updateBy(currentUser.getId()).updateTime(new Date()).enable(Integer.valueOf(enable)).build());
        Map<String, String> params = this.getForbiddenMemberParams(enable == 0 ? 1 : 0, callMember.getUserId());
        this.bjyPartnerService.bjyPost(bizId, this.forbiddenMemberUrl, params);
    }

    @Override
    public void code(CallMemberReqDto reqDto) {
        CurrentUserInfo currentUser = LoginUtils.getCurrentUser();
        reqDto.validateIdParams(currentUser);
        log.info("code member : {}", (Object)reqDto);
        CallMember callMember = (CallMember)this.callMemberMapper.selectOne((Object)CallMember.builder().bizId(currentUser.getBizId()).id(reqDto.getId()).build());
        Preconditions.checkArgument((!ObjectUtils.isEmpty((Object)callMember) ? 1 : 0) != 0, (Object)"id\u4e0d\u5b58\u5728");
        CallMemberDto callMemberDto = CallMemberDto.builder().bizId(currentUser.getBizId()).phone(callMember.getPhone()).userId(currentUser.getId()).toUserId(callMember.getUserId()).id(callMember.getId()).build();
        this.callMemberFacade.getInstance(currentUser.getBizId()).code(callMemberDto);
    }

    @Override
    public void validate(CallMemberReqDto reqDto) {
        CurrentUserInfo currentUser = LoginUtils.getCurrentUser();
        reqDto.validateCodeParams(currentUser);
        Long bizId = currentUser.getBizId();
        log.info("validate member : {}", (Object)reqDto);
        CallMember callMember = (CallMember)this.callMemberMapper.selectOne((Object)CallMember.builder().bizId(currentUser.getBizId()).id(reqDto.getId()).build());
        Preconditions.checkArgument((!ObjectUtils.isEmpty((Object)callMember) ? 1 : 0) != 0, (Object)"id\u4e0d\u5b58\u5728");
        if (1 == callMember.getValidate()) {
            throw new BusinessException((UniverseErrorCode)CommonErrorCode.SIGN_INVALIDATE, "\u8be5\u624b\u673a\u53f7\u5df2\u9a8c\u8bc1");
        }
        CallMemberDto callMemberDto = CallMemberDto.builder().bizId(bizId).phone(callMember.getPhone()).userId(currentUser.getId()).toUserId(callMember.getUserId()).code(reqDto.getCode()).id(callMember.getId()).build();
        this.callMemberFacade.getInstance(bizId).validate(callMemberDto);
    }

    @Override
    public List<CallMemberRespDto> getUserList(CallMemberReqDto reqDto) {
        CurrentUserInfo currentUser = LoginUtils.getCurrentUser();
        log.info("getUserList reqDto : {}", (Object)reqDto);
        List<String> nodeNums = reqDto.getNodeIds();
        Long bizId = currentUser.getBizId();
        ArrayList resultList = Lists.newArrayList();
        if (CollectionUtils.isEmpty(nodeNums)) {
            return resultList;
        }
        HashSet nodeIds = Sets.newHashSet((Object[])new Long[0]);
        for (String nodeNum : nodeNums) {
            Long orgId = this.organizationMapper.getIdByNum(bizId, nodeNum);
            nodeIds.add(orgId);
        }
        Set manageUserIds = this.userRoleCommonService.getManageUserIds();
        UserQueryParams userQueryParams = new UserQueryParams();
        userQueryParams.setNodeIds((Set)nodeIds);
        userQueryParams.setUserIds(manageUserIds);
        userQueryParams.setBizId(bizId);
        List users = this.userMapper.queryUserByQueryParams(userQueryParams);
        if (!CollectionUtils.isEmpty((Collection)users)) {
            for (User user : users) {
                resultList.add(CallMemberRespDto.from(user));
            }
        }
        return resultList;
    }

    @Override
    public CallExtenCountRespDto extenCount() {
        CurrentUserInfo currentUser = LoginUtils.getCurrentUser();
        Long bizId = currentUser.getBizId();
        CallMemberDto callMemberDto = CallMemberDto.builder().bizId(bizId).build();
        return this.callMemberFacade.getInstance(bizId).extenCount(callMemberDto);
    }

    private Map<String, String> getDeleteMemberParams(Long userId) {
        TreeMap<String, String> result = new TreeMap<String, String>();
        result.put("user_number", String.valueOf(userId));
        return result;
    }

    private Map<String, String> getForbiddenMemberParams(int status, Long userId) {
        TreeMap<String, String> result = new TreeMap<String, String>();
        result.put("status", String.valueOf(status));
        result.put("user_number", String.valueOf(userId));
        return result;
    }
}

