/*
 * Decompiled with CFR 0.152.
 */
package com.kuaike.scrm.call.factory;

import com.google.common.base.Preconditions;
import com.kuaike.common.errorcode.CommonErrorCode;
import com.kuaike.common.errorcode.UniverseErrorCode;
import com.kuaike.common.exception.BusinessException;
import com.kuaike.common.utils.JacksonUtil;
import com.kuaike.scrm.call.dto.CallConfig;
import com.kuaike.scrm.call.dto.CallExtenCountRespDto;
import com.kuaike.scrm.call.dto.CallMemberDto;
import com.kuaike.scrm.call.enums.CallOutTypeEnum;
import com.kuaike.scrm.call.factory.CallMemberService;
import com.kuaike.scrm.call.factory.RongLianCallMemberServiceImpl;
import com.kuaike.scrm.call.factory.RongYingCallMemberServiceImpl;
import com.kuaike.scrm.call.factory.ZhongTongCallMemberServiceImpl;
import com.kuaike.scrm.common.utils.LoginUtils;
import com.kuaike.scrm.dal.app.entity.AppBindings;
import com.kuaike.scrm.dal.app.mapper.AppBindingsMapper;
import java.io.IOException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;

@Component
public class CallMemberFacade
implements CallMemberService {
    private static final Logger log = LoggerFactory.getLogger(CallMemberFacade.class);
    @Value(value="${app.call.appCode}")
    private String appCode;
    @Autowired
    private AppBindingsMapper bindingsMapper;
    @Autowired
    private RongLianCallMemberServiceImpl ronglian;
    @Autowired
    private RongYingCallMemberServiceImpl rongying;
    @Autowired
    private ZhongTongCallMemberServiceImpl zhongtong;

    private CallConfig callConfig(Long bizId) {
        CallConfig callConfig;
        AppBindings bindings = (AppBindings)this.bindingsMapper.selectOne((Object)AppBindings.builder().bizId(bizId).appCode(this.appCode).build());
        Preconditions.checkArgument((bindings != null && bindings.getIsOpen() == 1 ? 1 : 0) != 0, (Object)"\u4f01\u4e1a\u5c1a\u672a\u5f00\u901a\u5916\u547c\u529f\u80fd");
        String configJson = bindings.getConfigJson();
        try {
            callConfig = (CallConfig)JacksonUtil.str2Obj((String)configJson, CallConfig.class);
        }
        catch (IOException e) {
            throw new BusinessException((UniverseErrorCode)CommonErrorCode.BUSINESS_ERROR, "\u89e3\u6790\u5916\u547c\u914d\u7f6e\u5f02\u5e38");
        }
        return callConfig;
    }

    public CallMemberService getInstance(Long bizId) {
        CallConfig config = this.callConfig(bizId);
        return this.getInstance(config.getSupplierType());
    }

    public CallMemberService getInstance() {
        Long bizId = LoginUtils.getCurrentUserBizId();
        return this.getInstance(bizId);
    }

    public CallMemberService getInstance(Integer supplierType) {
        Preconditions.checkArgument((supplierType != null ? 1 : 0) != 0, (Object)"\u4e0d\u652f\u6301\u7684\u4f9b\u5e94\u5546");
        CallOutTypeEnum type = CallOutTypeEnum.get(supplierType);
        switch (type) {
            case RONG_LIAN: 
            case ZHU_QUE: {
                return this.ronglian;
            }
            case RONG_YING: {
                return this.rongying;
            }
            case ZHONG_TONG: {
                return this.zhongtong;
            }
        }
        log.warn("\u4e0d\u652f\u6301\u7684\u5916\u547c\u7ebf\u8def");
        return null;
    }

    @Override
    public void add(CallMemberDto reqDto) {
        this.getInstance().add(reqDto);
    }

    @Override
    public void mod(CallMemberDto reqDto) {
        this.getInstance().mod(reqDto);
    }

    @Override
    public void code(CallMemberDto reqDto) {
        this.getInstance().code(reqDto);
    }

    @Override
    public void validate(CallMemberDto reqDto) {
        this.getInstance().validate(reqDto);
    }

    @Override
    public CallExtenCountRespDto extenCount(CallMemberDto reqDto) {
        return this.getInstance().extenCount(reqDto);
    }
}

