/*
 * Decompiled with CFR 0.152.
 */
package com.kuaike.scrm.call.dto.req;

import com.alibaba.fastjson.JSON;
import com.google.common.base.Preconditions;
import com.kuaike.common.sqlbuilder.dto.PageDto;
import com.kuaike.scrm.call.enums.VoiceSmsNoticeTypeEnum;
import com.kuaike.scrm.common.dto.CurrentUserInfo;
import com.kuaike.scrm.common.enums.CallTypeEnum;
import com.kuaike.scrm.common.enums.voicecall.VoiceContentTypeEnum;
import com.kuaike.scrm.common.service.dto.CustomerDto;
import com.kuaike.scrm.dal.call.dto.CallTaskQueryParams;
import com.kuaike.scrm.dal.call.entity.CallTask;
import com.kuaike.scrm.dal.call.entity.VoiceContent;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import org.apache.commons.lang3.StringUtils;
import org.springframework.util.CollectionUtils;
import org.springframework.util.ObjectUtils;

public class CallTaskReqDto {
    private List<CustomerDto> customers;
    private List<String> userIds;
    private String name;
    private String source;
    private Integer openNotice;
    private Date planCompleteTime;
    private String batchId;
    private Long callTaskId;
    private List<Long> callTaskIds;
    private List<Long> callTaskDetailId;
    private Long detailId;
    private String userId;
    private Long user;
    private String nodeId;
    private String memberUserId;
    private String memberNodeId;
    private String query;
    private Date startTime;
    private Date endTime;
    private PageDto pageDto;
    private Integer completed;
    private Integer selectMode;
    private Integer called;
    private Integer type;
    private String voiceContent;
    private Integer voiceContentType;
    private Long fkId;
    private Integer fkType;
    private Integer smsNotice;
    private Integer smsNoticeType;
    private Long smsId;
    private Integer callStatus;
    private List<String> willCallContactIds;
    private Integer allocMode = 0;
    private List<Integer> allocRatio;
    private Integer sendType;
    private Date sendTime;
    private Long bizId;
    private String corpId;
    private Long createBy;

    private void validateBaseParams(CurrentUserInfo currentUserInfo) {
        if (this.bizId != null && StringUtils.isNotBlank((CharSequence)this.corpId)) {
            return;
        }
        Preconditions.checkArgument((boolean)Objects.nonNull(currentUserInfo), (Object)"\u5f53\u524d\u7528\u6237\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a");
        Preconditions.checkArgument((boolean)Objects.nonNull(currentUserInfo.getBizId()), (Object)"\u5f53\u524d\u7528\u6237\u6240\u5c5e\u5546\u6237id\u4e0d\u80fd\u4e3a\u7a7a");
        Preconditions.checkArgument((boolean)StringUtils.isNotBlank((CharSequence)currentUserInfo.getCorpId()), (Object)"\u5f53\u524d\u7528\u6237\u6240\u5c5e\u4f01\u4e1aid\u4e0d\u80fd\u4e3a\u7a7a");
    }

    public void validateListParams(CurrentUserInfo currentUserInfo) {
        this.validateBaseParams(currentUserInfo);
    }

    public void validateOptionParams(CurrentUserInfo currentUserInfo) {
        this.validateBaseParams(currentUserInfo);
        Preconditions.checkArgument((boolean)StringUtils.isNotBlank((CharSequence)this.source), (Object)"\u4efb\u52a1\u6765\u6e90\u4e0d\u80fd\u4e3a\u7a7a");
    }

    public void validateAddParams(CurrentUserInfo currentUserInfo) {
        CallTypeEnum callTypeEnum = CallTypeEnum.get((Integer)this.type);
        Preconditions.checkArgument((callTypeEnum != null ? 1 : 0) != 0, (Object)"\u4efb\u52a1\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a");
        if (this.callTaskId == null && callTypeEnum.equals((Object)CallTypeEnum.VOICE)) {
            VoiceContentTypeEnum voiceContentTypeEnum = VoiceContentTypeEnum.get((Integer)this.voiceContentType);
            Preconditions.checkArgument((voiceContentTypeEnum != null ? 1 : 0) != 0, (Object)"\u8bed\u97f3\u5916\u547c\u5185\u5bb9\u7c7b\u578b\u4e0d\u5b58\u5728");
            Preconditions.checkArgument((boolean)StringUtils.isNotBlank((CharSequence)this.voiceContent), (Object)"\u8bed\u97f3\u64ad\u62a5\u5185\u5bb9\u4e0d\u80fd\u4e3a\u7a7a");
            Preconditions.checkArgument((this.smsNotice != null ? 1 : 0) != 0, (Object)"\u8bed\u97f3\u5916\u547c\u662f\u5426\u5f00\u542f\u77ed\u4fe1\u63d0\u9192\u8bbe\u7f6e\u4e0d\u80fd\u4e3a\u7a7a");
            if (this.smsNotice == 1) {
                Preconditions.checkArgument((this.smsNoticeType != null ? 1 : 0) != 0, (Object)"\u77ed\u4fe1\u63d0\u9192\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a");
                VoiceSmsNoticeTypeEnum voiceSmsNoticeTypeEnum = VoiceSmsNoticeTypeEnum.get(this.smsNoticeType);
                Preconditions.checkArgument((voiceSmsNoticeTypeEnum != null ? 1 : 0) != 0, (Object)"\u77ed\u4fe1\u63d0\u9192\u7c7b\u578b\u4e0d\u5b58\u5728");
                Preconditions.checkArgument((this.smsId != null ? 1 : 0) != 0, (Object)"\u77ed\u4fe1\u63d0\u9192\u6a21\u677fid\u4e0d\u80fd\u4e3a\u7a7a");
            }
        }
        this.validateBaseParams(currentUserInfo);
        if (this.sendType == null) {
            this.sendType = 0;
        }
    }

    public void validateTransferParams(CurrentUserInfo currentUserInfo) {
        this.validateBaseParams(currentUserInfo);
        Preconditions.checkArgument((!CollectionUtils.isEmpty(this.callTaskDetailId) || !ObjectUtils.isEmpty((Object)this.selectMode) && this.selectMode == 1 ? 1 : 0) != 0, (Object)"\u5f85\u8f6c\u6d3e\u8bb0\u5f55\u4e0d\u80fd\u4e3a\u7a7a");
        Preconditions.checkArgument((!StringUtils.isEmpty((CharSequence)this.userId) ? 1 : 0) != 0, (Object)"\u6267\u884c\u4eba\u4e0d\u80fd\u4e3a\u7a7a");
        Preconditions.checkArgument((!ObjectUtils.isEmpty((Object)this.callTaskId) ? 1 : 0) != 0, (Object)"\u4efb\u52a1id\u4e0d\u80fd\u4e3a\u7a7a");
    }

    public void validateDetailParams(CurrentUserInfo currentUserInfo) {
        this.validateBaseParams(currentUserInfo);
        Preconditions.checkArgument((!ObjectUtils.isEmpty((Object)this.callTaskId) ? 1 : 0) != 0, (Object)"\u4efb\u52a1id\u4e0d\u80fd\u4e3a\u7a7a");
    }

    public void validateForTaskList(CurrentUserInfo currentUserInfo) {
        this.validateBaseParams(currentUserInfo);
        Preconditions.checkArgument((!CollectionUtils.isEmpty(this.callTaskIds) ? 1 : 0) != 0, (Object)"\u4efb\u52a1id\u96c6\u5408\u4e0d\u80fd\u4e3a\u7a7a");
    }

    public void validateTaskDetailParams(CurrentUserInfo currentUserInfo) {
        this.validateBaseParams(currentUserInfo);
        Preconditions.checkArgument((!ObjectUtils.isEmpty((Object)this.callTaskId) ? 1 : 0) != 0, (Object)"\u4efb\u52a1id\u4e0d\u80fd\u4e3a\u7a7a");
        Preconditions.checkArgument((!ObjectUtils.isEmpty((Object)this.user) ? 1 : 0) != 0, (Object)"\u7528\u6237id\u4e0d\u80fd\u4e3a\u7a7a");
    }

    public CallTaskQueryParams to(Long bizId) {
        CallTaskQueryParams queryParams = new CallTaskQueryParams();
        queryParams.setCallTaskIds(this.callTaskIds);
        queryParams.setCallTaskId(this.callTaskId);
        queryParams.setBizId(bizId);
        queryParams.setStartDate(this.startTime);
        queryParams.setEndDate(this.endTime);
        queryParams.setQuery(this.query);
        queryParams.setCompleted(this.completed);
        queryParams.setCalled(this.called);
        queryParams.setPageDto(this.pageDto);
        queryParams.setSource(this.source);
        queryParams.setType(this.type);
        queryParams.setMemberUserId(this.memberUserId);
        queryParams.setUserId(this.userId);
        queryParams.setCallStatus(this.callStatus);
        return queryParams;
    }

    public CallTask backward(CurrentUserInfo currentUser, String num, List<String> userNames, List<Long> userIds) {
        CallTask callTask = this.bizId == null ? CallTask.builder().num(num).bizId(currentUser.getBizId()).corpId(currentUser.getCorpId()).user(StringUtils.join((Object[])userNames.toArray(), (String)"/")).name(this.name).planCompleteTime(this.planCompleteTime).openNotice(this.openNotice).source(this.source).progress(Double.valueOf(0.0)).allocMode(this.allocMode).allocUser(StringUtils.join((Object[])userIds.toArray(), (String)",")).allocRatio(CollectionUtils.isEmpty(this.allocRatio) ? "" : StringUtils.join((Object[])this.allocRatio.toArray(), (String)",")).createTime(new Date()).createBy(currentUser.getId()).updateTime(new Date()).updateBy(currentUser.getId()).type(Integer.valueOf(CallTypeEnum.MANUAL.getValue())).fkId(this.fkId).fkType(this.fkType).sendType(this.sendType).sendTime(this.sendTime).build() : CallTask.builder().num(num).bizId(this.bizId).corpId(this.corpId).user(StringUtils.join((Object[])userNames.toArray(), (String)"/")).name(this.name).planCompleteTime(this.planCompleteTime).openNotice(this.openNotice).source(this.source).progress(Double.valueOf(0.0)).allocMode(this.allocMode).allocUser(StringUtils.join((Object[])userIds.toArray(), (String)",")).allocRatio(CollectionUtils.isEmpty(this.allocRatio) ? "" : StringUtils.join((Object[])this.allocRatio.toArray(), (String)",")).createTime(new Date()).createBy(Long.valueOf(this.createBy != null ? this.createBy : -1L)).updateTime(new Date()).updateBy(Long.valueOf(-1L)).type(Integer.valueOf(CallTypeEnum.MANUAL.getValue())).fkId(this.fkId).fkType(this.fkType).sendType(this.sendType).sendTime(this.sendTime).build();
        if (callTask.getSendType() == 1) {
            callTask.setStatus(Integer.valueOf(0));
        }
        return callTask;
    }

    public static CallTaskReqDto entityToDto(CallTask entity) {
        CallTaskReqDto callTaskReqDto = new CallTaskReqDto();
        callTaskReqDto.setFkType(entity.getFkType());
        callTaskReqDto.setFkId(entity.getFkId());
        callTaskReqDto.setCallTaskId(entity.getId());
        VoiceContent voiceContent = (VoiceContent)JSON.parseObject((String)entity.getVoiceContent(), VoiceContent.class);
        Integer voiceContentType = null;
        if (Objects.nonNull(voiceContent.getVoiceContentType())) {
            voiceContentType = VoiceContentTypeEnum.TEXT.getValue();
            callTaskReqDto.setVoiceContent(voiceContent.getVoiceContent());
        } else if (Objects.nonNull(voiceContent.getVoiceUrl())) {
            voiceContentType = VoiceContentTypeEnum.VOICE_URL.getValue();
            callTaskReqDto.setVoiceContent(voiceContent.getVoiceContent());
        } else if (Objects.nonNull(voiceContent.getVoiceMaterialId())) {
            voiceContentType = VoiceContentTypeEnum.VOICE_MATERIAL_ID.getValue();
            callTaskReqDto.setVoiceContent(voiceContent.getVoiceContent());
        }
        callTaskReqDto.setVoiceContentType(voiceContentType);
        callTaskReqDto.setName(entity.getName());
        callTaskReqDto.setPlanCompleteTime(entity.getPlanCompleteTime());
        callTaskReqDto.setOpenNotice(entity.getOpenNotice());
        callTaskReqDto.setSmsNotice(entity.getSmsNotice());
        callTaskReqDto.setPlanCompleteTime(entity.getPlanCompleteTime());
        callTaskReqDto.setSource(entity.getSource());
        callTaskReqDto.setType(entity.getType());
        return callTaskReqDto;
    }

    public CallTask backwardByVoice(CurrentUserInfo currentUser, String num, VoiceContent voiceContent) {
        return CallTask.builder().num(num).bizId(currentUser.getBizId()).corpId(currentUser.getCorpId()).name(this.name).planCompleteTime(this.planCompleteTime).openNotice(this.openNotice).source(this.source).progress(Double.valueOf(0.0)).createTime(new Date()).createBy(currentUser.getId()).updateTime(new Date()).updateBy(currentUser.getId()).voiceContent(JSON.toJSONString((Object)voiceContent)).type(Integer.valueOf(CallTypeEnum.VOICE.getValue())).user("system").openNotice(Integer.valueOf(0)).fkId(this.fkId).fkType(this.fkType).build();
    }

    public List<CustomerDto> getCustomers() {
        return this.customers;
    }

    public List<String> getUserIds() {
        return this.userIds;
    }

    public String getName() {
        return this.name;
    }

    public String getSource() {
        return this.source;
    }

    public Integer getOpenNotice() {
        return this.openNotice;
    }

    public Date getPlanCompleteTime() {
        return this.planCompleteTime;
    }

    public String getBatchId() {
        return this.batchId;
    }

    public Long getCallTaskId() {
        return this.callTaskId;
    }

    public List<Long> getCallTaskIds() {
        return this.callTaskIds;
    }

    public List<Long> getCallTaskDetailId() {
        return this.callTaskDetailId;
    }

    public Long getDetailId() {
        return this.detailId;
    }

    public String getUserId() {
        return this.userId;
    }

    public Long getUser() {
        return this.user;
    }

    public String getNodeId() {
        return this.nodeId;
    }

    public String getMemberUserId() {
        return this.memberUserId;
    }

    public String getMemberNodeId() {
        return this.memberNodeId;
    }

    public String getQuery() {
        return this.query;
    }

    public Date getStartTime() {
        return this.startTime;
    }

    public Date getEndTime() {
        return this.endTime;
    }

    public PageDto getPageDto() {
        return this.pageDto;
    }

    public Integer getCompleted() {
        return this.completed;
    }

    public Integer getSelectMode() {
        return this.selectMode;
    }

    public Integer getCalled() {
        return this.called;
    }

    public Integer getType() {
        return this.type;
    }

    public String getVoiceContent() {
        return this.voiceContent;
    }

    public Integer getVoiceContentType() {
        return this.voiceContentType;
    }

    public Long getFkId() {
        return this.fkId;
    }

    public Integer getFkType() {
        return this.fkType;
    }

    public Integer getSmsNotice() {
        return this.smsNotice;
    }

    public Integer getSmsNoticeType() {
        return this.smsNoticeType;
    }

    public Long getSmsId() {
        return this.smsId;
    }

    public Integer getCallStatus() {
        return this.callStatus;
    }

    public List<String> getWillCallContactIds() {
        return this.willCallContactIds;
    }

    public Integer getAllocMode() {
        return this.allocMode;
    }

    public List<Integer> getAllocRatio() {
        return this.allocRatio;
    }

    public Integer getSendType() {
        return this.sendType;
    }

    public Date getSendTime() {
        return this.sendTime;
    }

    public Long getBizId() {
        return this.bizId;
    }

    public String getCorpId() {
        return this.corpId;
    }

    public Long getCreateBy() {
        return this.createBy;
    }

    public void setCustomers(List<CustomerDto> customers) {
        this.customers = customers;
    }

    public void setUserIds(List<String> userIds) {
        this.userIds = userIds;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setSource(String source) {
        this.source = source;
    }

    public void setOpenNotice(Integer openNotice) {
        this.openNotice = openNotice;
    }

    public void setPlanCompleteTime(Date planCompleteTime) {
        this.planCompleteTime = planCompleteTime;
    }

    public void setBatchId(String batchId) {
        this.batchId = batchId;
    }

    public void setCallTaskId(Long callTaskId) {
        this.callTaskId = callTaskId;
    }

    public void setCallTaskIds(List<Long> callTaskIds) {
        this.callTaskIds = callTaskIds;
    }

    public void setCallTaskDetailId(List<Long> callTaskDetailId) {
        this.callTaskDetailId = callTaskDetailId;
    }

    public void setDetailId(Long detailId) {
        this.detailId = detailId;
    }

    public void setUserId(String userId) {
        this.userId = userId;
    }

    public void setUser(Long user) {
        this.user = user;
    }

    public void setNodeId(String nodeId) {
        this.nodeId = nodeId;
    }

    public void setMemberUserId(String memberUserId) {
        this.memberUserId = memberUserId;
    }

    public void setMemberNodeId(String memberNodeId) {
        this.memberNodeId = memberNodeId;
    }

    public void setQuery(String query) {
        this.query = query;
    }

    public void setStartTime(Date startTime) {
        this.startTime = startTime;
    }

    public void setEndTime(Date endTime) {
        this.endTime = endTime;
    }

    public void setPageDto(PageDto pageDto) {
        this.pageDto = pageDto;
    }

    public void setCompleted(Integer completed) {
        this.completed = completed;
    }

    public void setSelectMode(Integer selectMode) {
        this.selectMode = selectMode;
    }

    public void setCalled(Integer called) {
        this.called = called;
    }

    public void setType(Integer type) {
        this.type = type;
    }

    public void setVoiceContent(String voiceContent) {
        this.voiceContent = voiceContent;
    }

    public void setVoiceContentType(Integer voiceContentType) {
        this.voiceContentType = voiceContentType;
    }

    public void setFkId(Long fkId) {
        this.fkId = fkId;
    }

    public void setFkType(Integer fkType) {
        this.fkType = fkType;
    }

    public void setSmsNotice(Integer smsNotice) {
        this.smsNotice = smsNotice;
    }

    public void setSmsNoticeType(Integer smsNoticeType) {
        this.smsNoticeType = smsNoticeType;
    }

    public void setSmsId(Long smsId) {
        this.smsId = smsId;
    }

    public void setCallStatus(Integer callStatus) {
        this.callStatus = callStatus;
    }

    public void setWillCallContactIds(List<String> willCallContactIds) {
        this.willCallContactIds = willCallContactIds;
    }

    public void setAllocMode(Integer allocMode) {
        this.allocMode = allocMode;
    }

    public void setAllocRatio(List<Integer> allocRatio) {
        this.allocRatio = allocRatio;
    }

    public void setSendType(Integer sendType) {
        this.sendType = sendType;
    }

    public void setSendTime(Date sendTime) {
        this.sendTime = sendTime;
    }

    public void setBizId(Long bizId) {
        this.bizId = bizId;
    }

    public void setCorpId(String corpId) {
        this.corpId = corpId;
    }

    public void setCreateBy(Long createBy) {
        this.createBy = createBy;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof CallTaskReqDto)) {
            return false;
        }
        CallTaskReqDto other = (CallTaskReqDto)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Integer this$openNotice = this.getOpenNotice();
        Integer other$openNotice = other.getOpenNotice();
        if (this$openNotice == null ? other$openNotice != null : !((Object)this$openNotice).equals(other$openNotice)) {
            return false;
        }
        Long this$callTaskId = this.getCallTaskId();
        Long other$callTaskId = other.getCallTaskId();
        if (this$callTaskId == null ? other$callTaskId != null : !((Object)this$callTaskId).equals(other$callTaskId)) {
            return false;
        }
        Long this$detailId = this.getDetailId();
        Long other$detailId = other.getDetailId();
        if (this$detailId == null ? other$detailId != null : !((Object)this$detailId).equals(other$detailId)) {
            return false;
        }
        Long this$user = this.getUser();
        Long other$user = other.getUser();
        if (this$user == null ? other$user != null : !((Object)this$user).equals(other$user)) {
            return false;
        }
        Integer this$completed = this.getCompleted();
        Integer other$completed = other.getCompleted();
        if (this$completed == null ? other$completed != null : !((Object)this$completed).equals(other$completed)) {
            return false;
        }
        Integer this$selectMode = this.getSelectMode();
        Integer other$selectMode = other.getSelectMode();
        if (this$selectMode == null ? other$selectMode != null : !((Object)this$selectMode).equals(other$selectMode)) {
            return false;
        }
        Integer this$called = this.getCalled();
        Integer other$called = other.getCalled();
        if (this$called == null ? other$called != null : !((Object)this$called).equals(other$called)) {
            return false;
        }
        Integer this$type = this.getType();
        Integer other$type = other.getType();
        if (this$type == null ? other$type != null : !((Object)this$type).equals(other$type)) {
            return false;
        }
        Integer this$voiceContentType = this.getVoiceContentType();
        Integer other$voiceContentType = other.getVoiceContentType();
        if (this$voiceContentType == null ? other$voiceContentType != null : !((Object)this$voiceContentType).equals(other$voiceContentType)) {
            return false;
        }
        Long this$fkId = this.getFkId();
        Long other$fkId = other.getFkId();
        if (this$fkId == null ? other$fkId != null : !((Object)this$fkId).equals(other$fkId)) {
            return false;
        }
        Integer this$fkType = this.getFkType();
        Integer other$fkType = other.getFkType();
        if (this$fkType == null ? other$fkType != null : !((Object)this$fkType).equals(other$fkType)) {
            return false;
        }
        Integer this$smsNotice = this.getSmsNotice();
        Integer other$smsNotice = other.getSmsNotice();
        if (this$smsNotice == null ? other$smsNotice != null : !((Object)this$smsNotice).equals(other$smsNotice)) {
            return false;
        }
        Integer this$smsNoticeType = this.getSmsNoticeType();
        Integer other$smsNoticeType = other.getSmsNoticeType();
        if (this$smsNoticeType == null ? other$smsNoticeType != null : !((Object)this$smsNoticeType).equals(other$smsNoticeType)) {
            return false;
        }
        Long this$smsId = this.getSmsId();
        Long other$smsId = other.getSmsId();
        if (this$smsId == null ? other$smsId != null : !((Object)this$smsId).equals(other$smsId)) {
            return false;
        }
        Integer this$callStatus = this.getCallStatus();
        Integer other$callStatus = other.getCallStatus();
        if (this$callStatus == null ? other$callStatus != null : !((Object)this$callStatus).equals(other$callStatus)) {
            return false;
        }
        Integer this$allocMode = this.getAllocMode();
        Integer other$allocMode = other.getAllocMode();
        if (this$allocMode == null ? other$allocMode != null : !((Object)this$allocMode).equals(other$allocMode)) {
            return false;
        }
        Integer this$sendType = this.getSendType();
        Integer other$sendType = other.getSendType();
        if (this$sendType == null ? other$sendType != null : !((Object)this$sendType).equals(other$sendType)) {
            return false;
        }
        Long this$bizId = this.getBizId();
        Long other$bizId = other.getBizId();
        if (this$bizId == null ? other$bizId != null : !((Object)this$bizId).equals(other$bizId)) {
            return false;
        }
        Long this$createBy = this.getCreateBy();
        Long other$createBy = other.getCreateBy();
        if (this$createBy == null ? other$createBy != null : !((Object)this$createBy).equals(other$createBy)) {
            return false;
        }
        List<CustomerDto> this$customers = this.getCustomers();
        List<CustomerDto> other$customers = other.getCustomers();
        if (this$customers == null ? other$customers != null : !((Object)this$customers).equals(other$customers)) {
            return false;
        }
        List<String> this$userIds = this.getUserIds();
        List<String> other$userIds = other.getUserIds();
        if (this$userIds == null ? other$userIds != null : !((Object)this$userIds).equals(other$userIds)) {
            return false;
        }
        String this$name = this.getName();
        String other$name = other.getName();
        if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
            return false;
        }
        String this$source = this.getSource();
        String other$source = other.getSource();
        if (this$source == null ? other$source != null : !this$source.equals(other$source)) {
            return false;
        }
        Date this$planCompleteTime = this.getPlanCompleteTime();
        Date other$planCompleteTime = other.getPlanCompleteTime();
        if (this$planCompleteTime == null ? other$planCompleteTime != null : !((Object)this$planCompleteTime).equals(other$planCompleteTime)) {
            return false;
        }
        String this$batchId = this.getBatchId();
        String other$batchId = other.getBatchId();
        if (this$batchId == null ? other$batchId != null : !this$batchId.equals(other$batchId)) {
            return false;
        }
        List<Long> this$callTaskIds = this.getCallTaskIds();
        List<Long> other$callTaskIds = other.getCallTaskIds();
        if (this$callTaskIds == null ? other$callTaskIds != null : !((Object)this$callTaskIds).equals(other$callTaskIds)) {
            return false;
        }
        List<Long> this$callTaskDetailId = this.getCallTaskDetailId();
        List<Long> other$callTaskDetailId = other.getCallTaskDetailId();
        if (this$callTaskDetailId == null ? other$callTaskDetailId != null : !((Object)this$callTaskDetailId).equals(other$callTaskDetailId)) {
            return false;
        }
        String this$userId = this.getUserId();
        String other$userId = other.getUserId();
        if (this$userId == null ? other$userId != null : !this$userId.equals(other$userId)) {
            return false;
        }
        String this$nodeId = this.getNodeId();
        String other$nodeId = other.getNodeId();
        if (this$nodeId == null ? other$nodeId != null : !this$nodeId.equals(other$nodeId)) {
            return false;
        }
        String this$memberUserId = this.getMemberUserId();
        String other$memberUserId = other.getMemberUserId();
        if (this$memberUserId == null ? other$memberUserId != null : !this$memberUserId.equals(other$memberUserId)) {
            return false;
        }
        String this$memberNodeId = this.getMemberNodeId();
        String other$memberNodeId = other.getMemberNodeId();
        if (this$memberNodeId == null ? other$memberNodeId != null : !this$memberNodeId.equals(other$memberNodeId)) {
            return false;
        }
        String this$query = this.getQuery();
        String other$query = other.getQuery();
        if (this$query == null ? other$query != null : !this$query.equals(other$query)) {
            return false;
        }
        Date this$startTime = this.getStartTime();
        Date other$startTime = other.getStartTime();
        if (this$startTime == null ? other$startTime != null : !((Object)this$startTime).equals(other$startTime)) {
            return false;
        }
        Date this$endTime = this.getEndTime();
        Date other$endTime = other.getEndTime();
        if (this$endTime == null ? other$endTime != null : !((Object)this$endTime).equals(other$endTime)) {
            return false;
        }
        PageDto this$pageDto = this.getPageDto();
        PageDto other$pageDto = other.getPageDto();
        if (this$pageDto == null ? other$pageDto != null : !this$pageDto.equals(other$pageDto)) {
            return false;
        }
        String this$voiceContent = this.getVoiceContent();
        String other$voiceContent = other.getVoiceContent();
        if (this$voiceContent == null ? other$voiceContent != null : !this$voiceContent.equals(other$voiceContent)) {
            return false;
        }
        List<String> this$willCallContactIds = this.getWillCallContactIds();
        List<String> other$willCallContactIds = other.getWillCallContactIds();
        if (this$willCallContactIds == null ? other$willCallContactIds != null : !((Object)this$willCallContactIds).equals(other$willCallContactIds)) {
            return false;
        }
        List<Integer> this$allocRatio = this.getAllocRatio();
        List<Integer> other$allocRatio = other.getAllocRatio();
        if (this$allocRatio == null ? other$allocRatio != null : !((Object)this$allocRatio).equals(other$allocRatio)) {
            return false;
        }
        Date this$sendTime = this.getSendTime();
        Date other$sendTime = other.getSendTime();
        if (this$sendTime == null ? other$sendTime != null : !((Object)this$sendTime).equals(other$sendTime)) {
            return false;
        }
        String this$corpId = this.getCorpId();
        String other$corpId = other.getCorpId();
        return !(this$corpId == null ? other$corpId != null : !this$corpId.equals(other$corpId));
    }

    protected boolean canEqual(Object other) {
        return other instanceof CallTaskReqDto;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Integer $openNotice = this.getOpenNotice();
        result = result * 59 + ($openNotice == null ? 43 : ((Object)$openNotice).hashCode());
        Long $callTaskId = this.getCallTaskId();
        result = result * 59 + ($callTaskId == null ? 43 : ((Object)$callTaskId).hashCode());
        Long $detailId = this.getDetailId();
        result = result * 59 + ($detailId == null ? 43 : ((Object)$detailId).hashCode());
        Long $user = this.getUser();
        result = result * 59 + ($user == null ? 43 : ((Object)$user).hashCode());
        Integer $completed = this.getCompleted();
        result = result * 59 + ($completed == null ? 43 : ((Object)$completed).hashCode());
        Integer $selectMode = this.getSelectMode();
        result = result * 59 + ($selectMode == null ? 43 : ((Object)$selectMode).hashCode());
        Integer $called = this.getCalled();
        result = result * 59 + ($called == null ? 43 : ((Object)$called).hashCode());
        Integer $type = this.getType();
        result = result * 59 + ($type == null ? 43 : ((Object)$type).hashCode());
        Integer $voiceContentType = this.getVoiceContentType();
        result = result * 59 + ($voiceContentType == null ? 43 : ((Object)$voiceContentType).hashCode());
        Long $fkId = this.getFkId();
        result = result * 59 + ($fkId == null ? 43 : ((Object)$fkId).hashCode());
        Integer $fkType = this.getFkType();
        result = result * 59 + ($fkType == null ? 43 : ((Object)$fkType).hashCode());
        Integer $smsNotice = this.getSmsNotice();
        result = result * 59 + ($smsNotice == null ? 43 : ((Object)$smsNotice).hashCode());
        Integer $smsNoticeType = this.getSmsNoticeType();
        result = result * 59 + ($smsNoticeType == null ? 43 : ((Object)$smsNoticeType).hashCode());
        Long $smsId = this.getSmsId();
        result = result * 59 + ($smsId == null ? 43 : ((Object)$smsId).hashCode());
        Integer $callStatus = this.getCallStatus();
        result = result * 59 + ($callStatus == null ? 43 : ((Object)$callStatus).hashCode());
        Integer $allocMode = this.getAllocMode();
        result = result * 59 + ($allocMode == null ? 43 : ((Object)$allocMode).hashCode());
        Integer $sendType = this.getSendType();
        result = result * 59 + ($sendType == null ? 43 : ((Object)$sendType).hashCode());
        Long $bizId = this.getBizId();
        result = result * 59 + ($bizId == null ? 43 : ((Object)$bizId).hashCode());
        Long $createBy = this.getCreateBy();
        result = result * 59 + ($createBy == null ? 43 : ((Object)$createBy).hashCode());
        List<CustomerDto> $customers = this.getCustomers();
        result = result * 59 + ($customers == null ? 43 : ((Object)$customers).hashCode());
        List<String> $userIds = this.getUserIds();
        result = result * 59 + ($userIds == null ? 43 : ((Object)$userIds).hashCode());
        String $name = this.getName();
        result = result * 59 + ($name == null ? 43 : $name.hashCode());
        String $source = this.getSource();
        result = result * 59 + ($source == null ? 43 : $source.hashCode());
        Date $planCompleteTime = this.getPlanCompleteTime();
        result = result * 59 + ($planCompleteTime == null ? 43 : ((Object)$planCompleteTime).hashCode());
        String $batchId = this.getBatchId();
        result = result * 59 + ($batchId == null ? 43 : $batchId.hashCode());
        List<Long> $callTaskIds = this.getCallTaskIds();
        result = result * 59 + ($callTaskIds == null ? 43 : ((Object)$callTaskIds).hashCode());
        List<Long> $callTaskDetailId = this.getCallTaskDetailId();
        result = result * 59 + ($callTaskDetailId == null ? 43 : ((Object)$callTaskDetailId).hashCode());
        String $userId = this.getUserId();
        result = result * 59 + ($userId == null ? 43 : $userId.hashCode());
        String $nodeId = this.getNodeId();
        result = result * 59 + ($nodeId == null ? 43 : $nodeId.hashCode());
        String $memberUserId = this.getMemberUserId();
        result = result * 59 + ($memberUserId == null ? 43 : $memberUserId.hashCode());
        String $memberNodeId = this.getMemberNodeId();
        result = result * 59 + ($memberNodeId == null ? 43 : $memberNodeId.hashCode());
        String $query = this.getQuery();
        result = result * 59 + ($query == null ? 43 : $query.hashCode());
        Date $startTime = this.getStartTime();
        result = result * 59 + ($startTime == null ? 43 : ((Object)$startTime).hashCode());
        Date $endTime = this.getEndTime();
        result = result * 59 + ($endTime == null ? 43 : ((Object)$endTime).hashCode());
        PageDto $pageDto = this.getPageDto();
        result = result * 59 + ($pageDto == null ? 43 : $pageDto.hashCode());
        String $voiceContent = this.getVoiceContent();
        result = result * 59 + ($voiceContent == null ? 43 : $voiceContent.hashCode());
        List<String> $willCallContactIds = this.getWillCallContactIds();
        result = result * 59 + ($willCallContactIds == null ? 43 : ((Object)$willCallContactIds).hashCode());
        List<Integer> $allocRatio = this.getAllocRatio();
        result = result * 59 + ($allocRatio == null ? 43 : ((Object)$allocRatio).hashCode());
        Date $sendTime = this.getSendTime();
        result = result * 59 + ($sendTime == null ? 43 : ((Object)$sendTime).hashCode());
        String $corpId = this.getCorpId();
        result = result * 59 + ($corpId == null ? 43 : $corpId.hashCode());
        return result;
    }

    public String toString() {
        return "CallTaskReqDto(customers=" + this.getCustomers() + ", userIds=" + this.getUserIds() + ", name=" + this.getName() + ", source=" + this.getSource() + ", openNotice=" + this.getOpenNotice() + ", planCompleteTime=" + this.getPlanCompleteTime() + ", batchId=" + this.getBatchId() + ", callTaskId=" + this.getCallTaskId() + ", callTaskIds=" + this.getCallTaskIds() + ", callTaskDetailId=" + this.getCallTaskDetailId() + ", detailId=" + this.getDetailId() + ", userId=" + this.getUserId() + ", user=" + this.getUser() + ", nodeId=" + this.getNodeId() + ", memberUserId=" + this.getMemberUserId() + ", memberNodeId=" + this.getMemberNodeId() + ", query=" + this.getQuery() + ", startTime=" + this.getStartTime() + ", endTime=" + this.getEndTime() + ", pageDto=" + this.getPageDto() + ", completed=" + this.getCompleted() + ", selectMode=" + this.getSelectMode() + ", called=" + this.getCalled() + ", type=" + this.getType() + ", voiceContent=" + this.getVoiceContent() + ", voiceContentType=" + this.getVoiceContentType() + ", fkId=" + this.getFkId() + ", fkType=" + this.getFkType() + ", smsNotice=" + this.getSmsNotice() + ", smsNoticeType=" + this.getSmsNoticeType() + ", smsId=" + this.getSmsId() + ", callStatus=" + this.getCallStatus() + ", willCallContactIds=" + this.getWillCallContactIds() + ", allocMode=" + this.getAllocMode() + ", allocRatio=" + this.getAllocRatio() + ", sendType=" + this.getSendType() + ", sendTime=" + this.getSendTime() + ", bizId=" + this.getBizId() + ", corpId=" + this.getCorpId() + ", createBy=" + this.getCreateBy() + ")";
    }
}

