/*
 * Decompiled with CFR 0.152.
 */
package com.kuaike.scrm.call.service.impl;

import com.google.common.base.Preconditions;
import com.kuaike.scrm.call.dto.voicematerial.AddVoiceMaterialReq;
import com.kuaike.scrm.call.dto.voicematerial.DelVoiceMaterialReq;
import com.kuaike.scrm.call.dto.voicematerial.EditVoiceMaterialReq;
import com.kuaike.scrm.call.dto.voicematerial.VoiceMaterialListReq;
import com.kuaike.scrm.call.dto.voicematerial.VoiceMaterialListResp;
import com.kuaike.scrm.call.service.CallVoiceMaterialService;
import com.kuaike.scrm.common.dto.CurrentUserInfo;
import com.kuaike.scrm.common.dto.UserRoleRespDto;
import com.kuaike.scrm.common.perm.service.UserRoleCommonService;
import com.kuaike.scrm.common.utils.IdGen;
import com.kuaike.scrm.common.utils.LoginUtils;
import com.kuaike.scrm.dal.call.dto.VoiceMaterialQueryParams;
import com.kuaike.scrm.dal.call.entity.CallVoiceMaterial;
import com.kuaike.scrm.dal.call.mapper.CallVoiceMaterialMapper;
import com.kuaike.scrm.dal.permission.entity.User;
import com.kuaike.scrm.dal.permission.mapper.UserMapper;
import com.kuaike.scrm.dal.permission.mapper.UserRoleMapper;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Set;
import javax.annotation.Resource;
import org.apache.commons.collections4.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class CallVoiceMaterialServiceImpl
implements CallVoiceMaterialService {
    private static final Logger log = LoggerFactory.getLogger(CallVoiceMaterialServiceImpl.class);
    @Resource
    private CallVoiceMaterialMapper callVoiceMaterialMapper;
    @Resource
    private UserRoleMapper userRoleMapper;
    @Resource
    private UserMapper userMapper;
    @Resource
    private IdGen idGen;
    @Resource
    private UserRoleCommonService userRoleCommonService;

    @Override
    public List<VoiceMaterialListResp> list(VoiceMaterialListReq req) {
        CurrentUserInfo currentUser = LoginUtils.getCurrentUser();
        Preconditions.checkArgument((currentUser != null ? 1 : 0) != 0, (Object)"\u7528\u6237\u672a\u767b\u5f55");
        log.info("list req:{}", (Object)req);
        req.validate();
        VoiceMaterialQueryParams params = new VoiceMaterialQueryParams();
        params.setPageDto(req.getPageDto());
        params.setType(req.getType());
        params.setQuery(req.getQuery());
        params.setBizId(currentUser.getBizId());
        Long total = this.callVoiceMaterialMapper.queryListCount(params);
        if (total == 0L) {
            return Collections.emptyList();
        }
        if (req.getPageDto() != null) {
            req.getPageDto().setCount(Integer.valueOf(total.intValue()));
        }
        List list = this.callVoiceMaterialMapper.queryList(params);
        ArrayList<VoiceMaterialListResp> respList = new ArrayList<VoiceMaterialListResp>(list.size());
        for (CallVoiceMaterial material : list) {
            VoiceMaterialListResp resp = new VoiceMaterialListResp();
            resp.setId(material.getNum());
            resp.setName(material.getName());
            resp.setType(material.getType());
            resp.setFileName(material.getVoiceFileName());
            resp.setContent(material.getContent());
            resp.setCreateTime(material.getCreateTime());
            resp.setCreator(material.getCreateName());
            resp.setPermission(0);
            if (material.getCreateBy().equals(currentUser.getId()) || this.isLeader(currentUser, material.getCreateBy())) {
                resp.setPermission(1);
            }
            respList.add(resp);
        }
        return respList;
    }

    private boolean isLeader(CurrentUserInfo currentUserInfo, Long createBy) {
        UserRoleRespDto curRole = currentUserInfo.getCurRole();
        if (curRole == null || curRole.getRoleId() == null) {
            return false;
        }
        Set manageNodeIds = this.userRoleCommonService.getManageNodeIds();
        log.info("isLeader current user:{} , manager node ids.size :{}", (Object)currentUserInfo.getId(), (Object)manageNodeIds.size());
        if (CollectionUtils.isEmpty((Collection)manageNodeIds)) {
            return false;
        }
        User createUser = this.userMapper.getUserInfoById(createBy);
        log.info("isLeader create user:{} , node id :{}", (Object)createBy, (Object)(createUser == null ? -1L : createUser.getNodeId()));
        return createUser == null || manageNodeIds.contains(createUser.getNodeId());
    }

    @Override
    public void add(AddVoiceMaterialReq req) {
        CurrentUserInfo currentUser = LoginUtils.getCurrentUser();
        Preconditions.checkArgument((currentUser != null ? 1 : 0) != 0, (Object)"\u7528\u6237\u672a\u767b\u5f55");
        log.info("add req:{}", (Object)req);
        req.validate();
        CallVoiceMaterial nameExist = new CallVoiceMaterial();
        nameExist.setName(req.getName());
        nameExist.setBizId(currentUser.getBizId());
        nameExist.setIsDeleted(Integer.valueOf(0));
        int count = this.callVoiceMaterialMapper.selectCount((Object)nameExist);
        Preconditions.checkArgument((count == 0 ? 1 : 0) != 0, (Object)"\u7d20\u6750\u540d\u79f0\u4e0d\u80fd\u91cd\u590d");
        Date now = new Date();
        CallVoiceMaterial callVoiceMaterial = new CallVoiceMaterial();
        callVoiceMaterial.setNum(this.idGen.getNum());
        callVoiceMaterial.setBizId(currentUser.getBizId());
        callVoiceMaterial.setCorpId(currentUser.getCorpId());
        callVoiceMaterial.setName(req.getName());
        callVoiceMaterial.setType(req.getType());
        callVoiceMaterial.setContent(req.getContent());
        callVoiceMaterial.setVoiceFileName(req.getFileName());
        callVoiceMaterial.setCreateBy(currentUser.getId());
        callVoiceMaterial.setCreateName(currentUser.getName());
        callVoiceMaterial.setCreateTime(now);
        callVoiceMaterial.setUpdateTime(now);
        callVoiceMaterial.setUpdateBy(Long.valueOf(-1L));
        callVoiceMaterial.setIsDeleted(Integer.valueOf(0));
        this.callVoiceMaterialMapper.insert((Object)callVoiceMaterial);
    }

    @Override
    public void edit(EditVoiceMaterialReq req) {
        CurrentUserInfo currentUser = LoginUtils.getCurrentUser();
        Preconditions.checkArgument((currentUser != null ? 1 : 0) != 0, (Object)"\u7528\u6237\u672a\u767b\u5f55");
        log.info("edit req:{}", (Object)req);
        req.validate();
        CallVoiceMaterial exist = new CallVoiceMaterial();
        exist.setNum(req.getId());
        exist.setBizId(currentUser.getBizId());
        exist.setIsDeleted(Integer.valueOf(0));
        CallVoiceMaterial callVoiceMaterial = (CallVoiceMaterial)this.callVoiceMaterialMapper.selectOne((Object)exist);
        Preconditions.checkArgument((callVoiceMaterial != null ? 1 : 0) != 0, (Object)"\u7d20\u6750\u4e0d\u5b58\u5728");
        if (!callVoiceMaterial.getName().equals(req.getName())) {
            Long count = this.callVoiceMaterialMapper.nameCountByEdit(callVoiceMaterial.getId(), req.getName(), currentUser.getBizId());
            Preconditions.checkArgument((count == 0L ? 1 : 0) != 0, (Object)"\u7d20\u6750\u540d\u79f0\u4e0d\u80fd\u91cd\u590d");
        }
        Date now = new Date();
        callVoiceMaterial.setName(req.getName());
        callVoiceMaterial.setType(req.getType());
        callVoiceMaterial.setContent(req.getContent());
        callVoiceMaterial.setVoiceFileName(req.getFileName());
        callVoiceMaterial.setUpdateTime(now);
        callVoiceMaterial.setUpdateBy(currentUser.getId());
        callVoiceMaterial.setUpdateName(currentUser.getName());
        this.callVoiceMaterialMapper.updateByPrimaryKeySelective((Object)callVoiceMaterial);
    }

    @Override
    public void del(DelVoiceMaterialReq req) {
        CurrentUserInfo currentUser = LoginUtils.getCurrentUser();
        Preconditions.checkArgument((currentUser != null ? 1 : 0) != 0, (Object)"\u7528\u6237\u672a\u767b\u5f55");
        log.info("del req:{}", (Object)req);
        req.validate();
        CallVoiceMaterial exist = new CallVoiceMaterial();
        exist.setNum(req.getId());
        exist.setBizId(currentUser.getBizId());
        exist.setIsDeleted(Integer.valueOf(0));
        CallVoiceMaterial callVoiceMaterial = (CallVoiceMaterial)this.callVoiceMaterialMapper.selectOne((Object)exist);
        Preconditions.checkArgument((callVoiceMaterial != null ? 1 : 0) != 0, (Object)"\u7d20\u6750\u4e0d\u5b58\u5728");
        Date now = new Date();
        callVoiceMaterial.setIsDeleted(Integer.valueOf(1));
        callVoiceMaterial.setUpdateTime(now);
        callVoiceMaterial.setUpdateName(currentUser.getName());
        this.callVoiceMaterialMapper.updateByPrimaryKeySelective((Object)callVoiceMaterial);
    }
}

