/*
 * Decompiled with CFR 0.152.
 */
package com.kuaike.scrm.call.service.impl;

import com.kuaike.scrm.call.dto.req.CallRecordReqDto;
import com.kuaike.scrm.call.dto.req.CallStatisticReqDto;
import com.kuaike.scrm.call.enums.StatusEnum;
import com.kuaike.scrm.call.enums.TypeEnum;
import com.kuaike.scrm.call.service.CallCommonService;
import com.kuaike.scrm.call.service.CallStatisticService;
import com.kuaike.scrm.common.dto.CurrentUserInfo;
import com.kuaike.scrm.common.enums.CallTypeEnum;
import com.kuaike.scrm.common.perm.service.UserRoleCommonService;
import com.kuaike.scrm.common.service.NodeService;
import com.kuaike.scrm.common.service.ScrmUserService;
import com.kuaike.scrm.common.utils.DateUtil;
import com.kuaike.scrm.common.utils.IdGen;
import com.kuaike.scrm.common.utils.LoginUtils;
import com.kuaike.scrm.dal.biz.entity.BusinessCustomer;
import com.kuaike.scrm.dal.biz.mapper.BusinessCustomerMapper;
import com.kuaike.scrm.dal.call.dto.CallRecordQueryParams;
import com.kuaike.scrm.dal.call.dto.CallStatisticQueryParams;
import com.kuaike.scrm.dal.call.entity.CallRecord;
import com.kuaike.scrm.dal.call.entity.CallRecordCriteria;
import com.kuaike.scrm.dal.call.entity.CallStatistic;
import com.kuaike.scrm.dal.call.mapper.CallRecordMapper;
import com.kuaike.scrm.dal.call.mapper.CallStatisticMapper;
import java.io.IOException;
import java.io.OutputStream;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletResponse;
import org.apache.poi.hssf.usermodel.HSSFCell;
import org.apache.poi.hssf.usermodel.HSSFCellStyle;
import org.apache.poi.hssf.usermodel.HSSFFont;
import org.apache.poi.hssf.usermodel.HSSFRichTextString;
import org.apache.poi.hssf.usermodel.HSSFRow;
import org.apache.poi.hssf.usermodel.HSSFSheet;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.ss.usermodel.FillPatternType;
import org.apache.poi.ss.usermodel.Font;
import org.apache.poi.ss.usermodel.IndexedColors;
import org.apache.poi.ss.usermodel.RichTextString;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;
import org.springframework.util.ObjectUtils;

@Service
public class CallStatisticServiceImpl
extends CallCommonService
implements CallStatisticService {
    private static final Logger log = LoggerFactory.getLogger(CallStatisticServiceImpl.class);
    private static final String[] dateHeaders = new String[]{"\u65e5\u671f", "\u5df2\u63a5\u901a\u7535\u8bdd", "\u672a\u63a5\u901a\u7535\u8bdd", "\u901a\u8bdd\u65f6\u957f(\u5206)", "\u8ba1\u8d39\u65f6\u957f(\u5206)"};
    private static final String[] userHeaders = new String[]{"\u90e8\u95e8/\u4eba\u5458", "\u5df2\u63a5\u901a\u7535\u8bdd", "\u672a\u63a5\u901a\u7535\u8bdd", "\u901a\u8bdd\u65f6\u957f(\u5206)", "\u8ba1\u8d39\u65f6\u957f(\u5206)"};
    @Resource
    private CallStatisticMapper callStatisticMapper;
    @Resource
    private CallRecordMapper callRecordMapper;
    @Autowired
    private IdGen idGen;
    @Resource
    private BusinessCustomerMapper businessCustomerMapper;

    public CallStatisticServiceImpl(UserRoleCommonService userRoleCommonService, ScrmUserService scrmUserService, NodeService nodeService) {
        this.userRoleCommonService = userRoleCommonService;
        this.scrmUserService = scrmUserService;
        this.nodeService = nodeService;
    }

    @Override
    public List<CallRecordReqDto.CallStatisticRespDto> statistic(CallStatisticReqDto reqDto) {
        CurrentUserInfo currentUser = LoginUtils.getCurrentUser();
        reqDto.validateStatisticParams(currentUser);
        log.info("statistic record: {}", (Object)reqDto);
        Long bizId = currentUser.getBizId();
        CallStatisticQueryParams queryParams = reqDto.to(bizId);
        Collection<Long> userIds = this.getManageUserIds(bizId, reqDto.getNodeId(), reqDto.getUserId());
        queryParams.setUserIds(userIds);
        List statistic = this.callStatisticMapper.statistic(queryParams);
        ArrayList<CallRecordReqDto.CallStatisticRespDto> resultList = new ArrayList<CallRecordReqDto.CallStatisticRespDto>();
        Integer mode = reqDto.getMode();
        List days = DateUtil.betweenDayStr((String)reqDto.getStartDate(), (String)reqDto.getEndDate());
        if (!CollectionUtils.isEmpty((Collection)statistic)) {
            if (mode == 1) {
                days.stream().forEach(day -> {
                    CallStatistic callStatistic = statistic.stream().filter(item -> day.equals(item.getDate())).findFirst().orElse(null);
                    boolean hasData = !ObjectUtils.isEmpty((Object)callStatistic);
                    resultList.add(CallRecordReqDto.CallStatisticRespDto.builder().x((String)day).successCount(hasData ? callStatistic.getSuccessCount() : 0).callDuration(hasData ? callStatistic.getCallDuration() : 0).billCallDuration(hasData ? callStatistic.getBillCallDuration() : 0).emptyCount(hasData ? callStatistic.getEmptyCount() : 0).downCount(hasData ? callStatistic.getDownCount() : 0).busyCount(hasData ? callStatistic.getBusyCount() : 0).nobodyCount(hasData ? callStatistic.getNobodyCount() : 0).hangCount(hasData ? callStatistic.getHangCount() : 0).closeCount(hasData ? callStatistic.getCloseCount() : 0).notSupportCount(hasData ? callStatistic.getNotSupportCount() : 0).build());
                });
            } else {
                for (CallStatistic callStatistic : statistic) {
                    if (ObjectUtils.isEmpty((Object)callStatistic)) {
                        resultList.add(new CallRecordReqDto.CallStatisticRespDto());
                        continue;
                    }
                    resultList.add(CallRecordReqDto.CallStatisticRespDto.from(callStatistic, reqDto.getMode()));
                }
            }
        } else if (mode == 1) {
            days.stream().forEach(day -> resultList.add(CallRecordReqDto.CallStatisticRespDto.builder().x((String)day).successCount(0).callDuration(0).billCallDuration(0).emptyCount(0).downCount(0).busyCount(0).nobodyCount(0).hangCount(0).closeCount(0).notSupportCount(0).build()));
        }
        resultList.sort((o1, o2) -> o2.getCallDuration().compareTo(o1.getCallDuration()));
        return resultList;
    }

    @Override
    public void analyse(CallStatisticReqDto reqDto) {
        Date endTime;
        Date startTime;
        String corpId;
        Long bizId;
        CurrentUserInfo currentUser = LoginUtils.getCurrentUser();
        log.info("analyse record : {}", (Object)reqDto);
        if (ObjectUtils.isEmpty((Object)reqDto.getBizId())) {
            reqDto.validateAnalyseParams(currentUser);
            bizId = currentUser.getBizId();
            corpId = currentUser.getCorpId();
            startTime = DateUtil.getTodayStartTime();
            endTime = DateUtil.getTodayEndTime();
        } else {
            bizId = reqDto.getBizId();
            corpId = reqDto.getCorpId();
            startTime = reqDto.getStartTime();
            endTime = reqDto.getEndTime();
        }
        CallRecordQueryParams queryParams = new CallRecordQueryParams();
        queryParams.setBizId(bizId);
        queryParams.setStartDate(startTime);
        queryParams.setEndDate(endTime);
        List users = this.callRecordMapper.userList(queryParams);
        String date = DateUtil.dateToDateString((Date)startTime, (String)"yyyy-MM-dd");
        CallStatistic.CallStatisticBuilder callStatisticBuilder = this.buildCallStatistic(bizId, corpId, date);
        this.callStatisticMapper.delete((Object)callStatisticBuilder.build());
        users.forEach(user -> this.insertCallStatistic(queryParams, callStatisticBuilder, (CallRecord)user));
    }

    @Override
    public void autoAnalyse(Date startTime, Date endTime) {
        log.info("autoAnalyse startTime: {},endTime: {}", (Object)startTime, (Object)endTime);
        CallRecordQueryParams queryParams = new CallRecordQueryParams();
        queryParams.setStartDate(startTime);
        queryParams.setEndDate(endTime);
        List records = this.callRecordMapper.bizList(queryParams);
        for (CallRecord callRecord : records) {
            CallStatisticReqDto reqDto = new CallStatisticReqDto();
            reqDto.setBizId(callRecord.getBizId());
            reqDto.setCorpId(callRecord.getCorpId());
            reqDto.setStartTime(startTime);
            reqDto.setEndTime(endTime);
            this.analyse(reqDto);
        }
    }

    @Override
    public void exportExcel(CallStatisticReqDto reqDto, HttpServletResponse response) {
        log.info("exportExcel reqDto:{}", (Object)reqDto);
        HSSFWorkbook workbook = new HSSFWorkbook();
        HSSFSheet sheet = workbook.createSheet("\u6570\u636e\u7edf\u8ba1");
        String fileName = "\u5916\u547c\u6570\u636e\u7edf\u8ba1.xls";
        HSSFRow row = sheet.createRow(0);
        row.setZeroHeight(false);
        row.setHeight((short)360);
        HSSFCellStyle headerCellStyle = workbook.createCellStyle();
        headerCellStyle.setFillForegroundColor(IndexedColors.GREY_25_PERCENT.getIndex());
        headerCellStyle.setFillPattern(FillPatternType.SOLID_FOREGROUND);
        HSSFFont headerFont = workbook.createFont();
        headerFont.setBold(true);
        headerFont.setFontHeightInPoints((short)12);
        headerCellStyle.setFont((Font)headerFont);
        List<CallRecordReqDto.CallStatisticRespDto> dtoList = this.statistic(reqDto);
        for (int i = 0; i < userHeaders.length; ++i) {
            sheet.setColumnWidth(i, 6400);
            HSSFCell cell = row.createCell(i);
            cell.setCellStyle(headerCellStyle);
            HSSFRichTextString text = reqDto.getMode() == 1 ? new HSSFRichTextString(dateHeaders[i]) : new HSSFRichTextString(userHeaders[i]);
            cell.setCellValue((RichTextString)text);
        }
        if (dtoList.size() > 0) {
            int rowNum = 1;
            for (CallRecordReqDto.CallStatisticRespDto respDto : dtoList) {
                HSSFRow ssRow = sheet.createRow(rowNum);
                ssRow.createCell(0).setCellValue(respDto.getX());
                ssRow.createCell(1).setCellValue((double)respDto.getSuccessCount().intValue());
                Integer failCount = respDto.getBusyCount() + respDto.getCloseCount() + respDto.getDownCount() + respDto.getHangCount() + respDto.getEmptyCount() + respDto.getNobodyCount() + respDto.getNotSupportCount();
                ssRow.createCell(2).setCellValue((double)failCount.intValue());
                Integer callDuration = respDto.getCallDuration();
                int seconds = callDuration % 60;
                int minutes = callDuration / 60;
                ssRow.createCell(3).setCellValue(minutes == 0 ? seconds + "\u79d2" : minutes + "\u5206" + seconds + "\u79d2");
                Integer billCallDuration = respDto.getBillCallDuration();
                ssRow.createCell(4).setCellValue(billCallDuration + "\u5206");
                ++rowNum;
            }
        }
        try {
            response.setCharacterEncoding("UTF-8");
            response.setHeader("Content-Disposition", "attachment;filename=" + URLEncoder.encode(fileName, "UTF-8"));
            response.setHeader("content-Type", "application/vnd.ms-excel");
            response.flushBuffer();
            workbook.write((OutputStream)response.getOutputStream());
        }
        catch (IOException e) {
            log.error("export call statistic error", (Throwable)e);
        }
    }

    @Override
    public void billCallDurationBackfill(Long bizId, int depth) {
        int i = this.businessCustomerMapper.selectCount((Object)new BusinessCustomer());
        if (depth > i) {
            log.info("oversize depth, return");
        }
        if (bizId != null) {
            List statistics = this.callStatisticMapper.select((Object)CallStatistic.builder().bizId(bizId).build());
            if (CollectionUtils.isEmpty((Collection)statistics)) {
                log.info("bizId has no data in call statistic, return");
                return;
            }
            Set<String> dates = statistics.stream().collect(Collectors.groupingBy(CallStatistic::getDate)).keySet();
            for (String date : dates) {
                CallStatisticReqDto reqDto = new CallStatisticReqDto();
                reqDto.setBizId(bizId);
                reqDto.setCorpId(((CallStatistic)statistics.get(0)).getCorpId());
                reqDto.setStartTime(DateUtil.getTheDateBeginFromString((String)date));
                reqDto.setEndTime(DateUtil.getTheDateEndFromString((String)date));
                this.analyse(reqDto);
                log.info("bizId:{}, date:{} has backfill success", (Object)bizId, (Object)date);
            }
        } else {
            List statistics = this.callStatisticMapper.selectAll();
            if (CollectionUtils.isEmpty((Collection)statistics)) {
                log.info("has no data in call statistic, return");
                return;
            }
            Set<Long> bis = statistics.stream().collect(Collectors.groupingBy(CallStatistic::getBizId)).keySet();
            for (Long biz : bis) {
                this.billCallDurationBackfill(biz, depth + 1);
            }
        }
    }

    private void insertCallStatistic(CallRecordQueryParams queryParams, CallStatistic.CallStatisticBuilder callStatisticBuilder, CallRecord user) {
        log.info("insertCallStatistic bizId:{},user:{},date:{}", new Object[]{queryParams.getBizId(), user.getUserId(), DateUtil.dateToDateString((Date)queryParams.getStartDate())});
        Long userId = user.getUserId();
        Long nodeId = user.getNodeId();
        for (TypeEnum type : TypeEnum.values()) {
            for (CallTypeEnum callType : CallTypeEnum.values()) {
                int successCount = 0;
                int nobodyCount = 0;
                int emptyCount = 0;
                int downCount = 0;
                int busyCount = 0;
                int hangCount = 0;
                int closeCount = 0;
                int notSupportCount = 0;
                int typeInt = type.getValue();
                int callTypeInt = callType.getValue();
                block12: for (StatusEnum value : StatusEnum.values()) {
                    int statusInt = value.getValue();
                    if (StatusEnum.START.getValue() == statusInt || StatusEnum.LINK.getValue() == statusInt) continue;
                    CallRecordCriteria callRecordCriteria = new CallRecordCriteria();
                    callRecordCriteria.createCriteria().andBizIdEqualTo(queryParams.getBizId()).andUserIdEqualTo(userId).andStatusEqualTo(Integer.valueOf(statusInt)).andTypeEqualTo(Integer.valueOf(typeInt)).andUserTypeEqualTo(Integer.valueOf(callTypeInt)).andCreateTimeBetween(queryParams.getStartDate(), queryParams.getEndDate());
                    int i = this.callRecordMapper.selectCountByExample((Object)callRecordCriteria);
                    switch (statusInt) {
                        case -1: {
                            notSupportCount = i;
                            continue block12;
                        }
                        case 1: {
                            successCount = i;
                            continue block12;
                        }
                        case 2: {
                            nobodyCount = i;
                            continue block12;
                        }
                        case 3: {
                            emptyCount = i;
                            continue block12;
                        }
                        case 4: {
                            downCount = i;
                            continue block12;
                        }
                        case 5: {
                            busyCount = i;
                            continue block12;
                        }
                        case 6: {
                            hangCount = i;
                            continue block12;
                        }
                        case 7: {
                            closeCount = i;
                            continue block12;
                        }
                    }
                }
                if (successCount == 0 && nobodyCount == 0 && emptyCount == 0 && downCount == 0 && busyCount == 0 && hangCount == 0 && closeCount == 0 && notSupportCount == 0) continue;
                queryParams.setUserId(userId);
                queryParams.setUserType(Integer.valueOf(callTypeInt));
                queryParams.setType(Integer.valueOf(typeInt));
                int callDuration = this.callRecordMapper.callDuration(queryParams);
                int billCallDuration = this.callRecordMapper.billCallDuration(queryParams);
                callStatisticBuilder.num(this.idGen.getNum()).type(Integer.valueOf(typeInt)).userType(Integer.valueOf(callTypeInt)).nobodyCount(Integer.valueOf(nobodyCount)).emptyCount(Integer.valueOf(emptyCount)).downCount(Integer.valueOf(downCount)).busyCount(Integer.valueOf(busyCount)).hangCount(Integer.valueOf(hangCount)).successCount(Integer.valueOf(successCount)).closeCount(Integer.valueOf(closeCount)).notSupportCount(Integer.valueOf(notSupportCount)).callDuration(Integer.valueOf(callDuration)).billCallDuration(Integer.valueOf(billCallDuration)).userId(userId).nodeId(nodeId).createBy(Long.valueOf(-1L)).createTime(new Date()).updateBy(Long.valueOf(-1L)).updateTime(new Date());
                this.callStatisticMapper.insert((Object)callStatisticBuilder.build());
            }
        }
    }

    private CallStatistic.CallStatisticBuilder buildCallStatistic(Long bizId, String corpId, String date) {
        return CallStatistic.builder().bizId(bizId).corpId(corpId).date(date);
    }
}

