/*
 * Decompiled with CFR 0.152.
 */
package com.kuaike.scrm.call.factory;

import com.alibaba.fastjson.JSONObject;
import com.google.common.base.Preconditions;
import com.kuaike.common.errorcode.CommonErrorCode;
import com.kuaike.common.errorcode.UniverseErrorCode;
import com.kuaike.common.exception.BusinessException;
import com.kuaike.common.utils.JacksonUtil;
import com.kuaike.scrm.bjy.sdk.service.BjyPartnerService;
import com.kuaike.scrm.call.dto.CallConfig;
import com.kuaike.scrm.call.dto.CallExtenCountRespDto;
import com.kuaike.scrm.call.dto.CallMemberDto;
import com.kuaike.scrm.call.factory.CallMemberService;
import com.kuaike.scrm.dal.app.entity.AppBindings;
import com.kuaike.scrm.dal.app.mapper.AppBindingsMapper;
import com.kuaike.scrm.dal.call.entity.CallMember;
import com.kuaike.scrm.dal.call.entity.CallMemberCriteria;
import com.kuaike.scrm.dal.call.mapper.CallMemberMapper;
import com.kuaike.scrm.dal.permission.mapper.UserMapper;
import java.io.IOException;
import java.util.Date;
import java.util.Map;
import java.util.TreeMap;
import java.util.concurrent.TimeUnit;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.stereotype.Service;

@Service
public class RongYingCallMemberServiceImpl
implements CallMemberService {
    private static final Logger log = LoggerFactory.getLogger(RongYingCallMemberServiceImpl.class);
    @Value(value="${spring.redis.key.prefix}")
    private String redisKeyPrefix;
    @Value(value="${app.call.applyExtenUrl}")
    private String applyExtenUrl;
    @Value(value="${app.call.addMemberUrl}")
    private String addMemberUrl;
    @Value(value="${app.call.appCode}")
    private String appCode;
    @Resource
    private RedisTemplate<String, Object> redisTemplate;
    @Autowired
    private BjyPartnerService bjyPartnerService;
    @Autowired
    private UserMapper userMapper;
    @Autowired
    private CallMemberMapper callMemberMapper;
    @Autowired
    private AppBindingsMapper bindingsMapper;
    private static final String CODE_KEY = "SCRM_BJY_CALL_CODE_KEY_%s";
    private static final int CODE_CACHE_EXPIRE = 60;

    @Override
    public void add(CallMemberDto reqDto) {
        log.info("add reqDto:{}", (Object)reqDto);
        Long bizId = reqDto.getBizId();
        CallMemberCriteria userCriteria = new CallMemberCriteria();
        userCriteria.createCriteria().andBizIdEqualTo(bizId);
        int used = this.callMemberMapper.selectCountByExample((Object)userCriteria);
        CallConfig callConfig = this.callConfig(bizId);
        Integer numberCount = callConfig.getDoubleCallFeeInfo().getNumberCount();
        numberCount = numberCount == null ? 0 : numberCount;
        if (used >= numberCount) {
            throw new BusinessException((UniverseErrorCode)CommonErrorCode.BUSINESS_ERROR, "\u5f00\u901a\u53f7\u7801\u5269\u4f59\u6570\u91cf\u4e0d\u8db3,\u8bf7\u5148\u5220\u9664\u6216\u5f00\u901a");
        }
    }

    @Override
    public void mod(CallMemberDto reqDto) {
        log.info("mod reqDto:{}", (Object)reqDto);
        String phone = reqDto.getPhone();
        if (phone.equals(reqDto.getNewPhone())) {
            return;
        }
        CallMember member = CallMember.builder().id(reqDto.getId()).phone(reqDto.getNewPhone()).updateBy(reqDto.getUserId()).updateTime(new Date()).enable(Integer.valueOf(0)).validate(Integer.valueOf(0)).build();
        this.callMemberMapper.updateByPrimaryKeySelective((Object)member);
    }

    @Override
    public void code(CallMemberDto reqDto) {
        log.info("code reqDto:{}", (Object)reqDto);
        Long bizId = reqDto.getBizId();
        String phone = reqDto.getPhone();
        Long toUserId = reqDto.getToUserId();
        String key = this.redisKeyPrefix + String.format(CODE_KEY, phone);
        String userName = this.userMapper.getUserNameByUserId(toUserId);
        Object existsVerifyCode = this.redisTemplate.opsForValue().get((Object)key);
        if (existsVerifyCode != null) {
            throw new BusinessException((UniverseErrorCode)CommonErrorCode.BUSINESS_ERROR, "\u9a8c\u8bc1\u7801\u5df2\u53d1\u9001\u8bf7\u7a0d\u540e\u5c1d\u8bd5");
        }
        Map<String, String> params = this.getApplyExtenParams(phone, toUserId, userName);
        this.bjyPartnerService.bjyPost(bizId, this.applyExtenUrl, params);
        this.redisTemplate.opsForValue().set((Object)key, (Object)"rongying", 60L, TimeUnit.SECONDS);
    }

    @Override
    public void validate(CallMemberDto reqDto) {
        log.info("validate reqDto:{}", (Object)reqDto);
        Long bizId = reqDto.getBizId();
        String phone = reqDto.getPhone();
        Long userId = reqDto.getToUserId();
        String code = reqDto.getCode();
        String userName = this.userMapper.getUserNameByUserId(userId);
        Map<String, String> params = this.getAddMemberParams(phone, userName, userId, code);
        JSONObject jsonObject = this.bjyPartnerService.bjyPost(bizId, this.addMemberUrl, params);
        String exten = jsonObject.getJSONObject("data").getString("exten");
        String doubleCallExten = jsonObject.getJSONObject("data").getString("exten_double_call");
        this.callMemberMapper.updateByPrimaryKeySelective((Object)CallMember.builder().id(reqDto.getId()).updateBy(reqDto.getUserId()).updateTime(new Date()).enable(Integer.valueOf(1)).validate(Integer.valueOf(1)).exten(exten).doubleCallExten(doubleCallExten).build());
    }

    @Override
    public CallExtenCountRespDto extenCount(CallMemberDto reqDto) {
        log.info("extenCount reqDto:{}", (Object)reqDto);
        Long bizId = reqDto.getBizId();
        CallMemberCriteria userCriteria = new CallMemberCriteria();
        userCriteria.createCriteria().andBizIdEqualTo(bizId);
        int used = this.callMemberMapper.selectCountByExample((Object)userCriteria);
        CallConfig callConfig = this.callConfig(bizId);
        Integer numberCount = callConfig.getDoubleCallFeeInfo().getNumberCount();
        return CallExtenCountRespDto.builder().total(numberCount == null ? 0 : numberCount).used(used).build();
    }

    private CallConfig callConfig(Long bizId) {
        CallConfig callConfig;
        AppBindings bindings = (AppBindings)this.bindingsMapper.selectOne((Object)AppBindings.builder().bizId(bizId).appCode(this.appCode).build());
        Preconditions.checkArgument((bindings != null && bindings.getIsOpen() == 1 ? 1 : 0) != 0, (Object)"\u4f01\u4e1a\u5c1a\u672a\u5f00\u901a\u5916\u547c\u529f\u80fd");
        String configJson = bindings.getConfigJson();
        try {
            callConfig = (CallConfig)JacksonUtil.str2Obj((String)configJson, CallConfig.class);
        }
        catch (IOException e) {
            throw new BusinessException((UniverseErrorCode)CommonErrorCode.BUSINESS_ERROR, "\u89e3\u6790\u5916\u547c\u914d\u7f6e\u5f02\u5e38");
        }
        return callConfig;
    }

    private Map<String, String> getApplyExtenParams(String phone, Long userId, String name) {
        TreeMap<String, String> result = new TreeMap<String, String>();
        result.put("phone", phone);
        result.put("name", name);
        result.put("user_number", String.valueOf(userId));
        return result;
    }

    private Map<String, String> getAddMemberParams(String phone, String name, Long userId, String code) {
        TreeMap<String, String> result = new TreeMap<String, String>();
        result.put("phone", phone);
        result.put("name", name);
        result.put("user_number", String.valueOf(userId));
        result.put("code", code);
        return result;
    }
}

