/*
 * Decompiled with CFR 0.152.
 */
package com.kuaike.scrm.bjy.sdk.service.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.parser.Feature;
import com.google.common.collect.Maps;
import com.kuaike.common.errorcode.CommonErrorCode;
import com.kuaike.common.errorcode.UniverseErrorCode;
import com.kuaike.common.exception.BusinessException;
import com.kuaike.common.utils.HttpClientUtils;
import com.kuaike.scrm.bjy.sdk.service.BjyPartnerService;
import com.kuaike.scrm.common.utils.IdGen;
import com.kuaike.scrm.dal.biz.entity.BusinessCustomer;
import com.kuaike.scrm.dal.biz.mapper.BusinessCustomerMapper;
import com.kuaike.scrm.dal.sms.entity.PartnerInfo;
import com.kuaike.scrm.dal.sms.mapper.PartnerInfoMapper;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.TreeMap;
import java.util.concurrent.TimeUnit;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.stereotype.Service;
import org.springframework.util.DigestUtils;
import org.springframework.util.ObjectUtils;

@Service
public class BjyPartnerServiceImpl
implements BjyPartnerService {
    private static final Logger log = LoggerFactory.getLogger(BjyPartnerServiceImpl.class);
    @Value(value="${spring.redis.key.prefix}")
    private String redisKeyPrefix;
    @Value(value="${app.sms.loginUrl}")
    private String loginUrl;
    @Value(value="${app.sms.createAccountUrl}")
    private String createAccountUrl;
    @Value(value="${baijiacloud.parse.ip.url:scrm_api/ip/batchGetIpInfo}")
    private String ipParserUrl;
    @Value(value="${app.bjy.domain}")
    private String bjyUrl;
    @Value(value="${app.bjy.salt}")
    private String salt;
    @Value(value="${app.bjy.prefix}")
    private String prefix;
    @Resource
    private RedisTemplate<String, Object> redisTemplate;
    @Autowired
    private PartnerInfoMapper partnerInfoMapper;
    @Autowired
    private BusinessCustomerMapper businessCustomerMapper;
    @Autowired
    private IdGen idGen;
    private final int TOKEN_CACHE_EXPIRE = 1;
    private final String TOKEN_KEY = "SCRM_BJY_TOKEN_KEY_V2_%s";
    private final String TIMESTAMP = "timestamp";
    private final String ERROR_MSG = "\u8c03\u7528API\u5f02\u5e38";

    @Override
    public String getBjyToken(Long bizId, String corpId) {
        String key = this.redisKeyPrefix + String.format("SCRM_BJY_TOKEN_KEY_V2_%s", bizId);
        Object cache = this.redisTemplate.opsForValue().get((Object)key);
        if (!ObjectUtils.isEmpty((Object)cache)) {
            return String.valueOf(cache);
        }
        Map<String, String> params = this.getLoginParam(corpId);
        try {
            JSONObject result = this.bjyPost(this.loginUrl, params, (Map<String, String>)Maps.newHashMap());
            log.info("getBjyToken params:{},result:{}", params, (Object)result);
            String token = result.getJSONObject("data").getString("token");
            this.redisTemplate.opsForValue().set((Object)key, (Object)token, 1L, TimeUnit.DAYS);
            return token;
        }
        catch (Exception e) {
            log.error("getBjyToken error", (Throwable)e);
            String token = "";
            return token;
        }
    }

    @Override
    public PartnerInfo getBjyPartnerInfo(Long bizId) {
        String corpName;
        PartnerInfo info = this.getPartner(bizId);
        if (!ObjectUtils.isEmpty((Object)info)) {
            return info;
        }
        BusinessCustomer biz = (BusinessCustomer)this.businessCustomerMapper.selectByPrimaryKey((Object)bizId);
        if (ObjectUtils.isEmpty((Object)biz)) {
            return null;
        }
        String corpId = biz.getCorpId();
        Map<String, String> params = this.getCreateAccountParam(corpId, corpName = biz.getName());
        JSONObject account = this.bjyPost(this.createAccountUrl, params, (Map<String, String>)Maps.newHashMap()).getJSONObject("data");
        if (ObjectUtils.isEmpty((Object)account)) {
            return null;
        }
        PartnerInfo partnerInfo = PartnerInfo.builder().bizId(bizId).corpId(corpId).num(this.idGen.getNum()).partnerId(account.getString("partner_id")).partnerKey(account.getString("partner_key")).secretKey(account.getString("secret_key")).email(account.getString("email")).mobile(account.getString("mobile")).partnerName(account.getString("partner_name")).url(account.getString("private_domain_url")).updateTime(new Date()).createTime(new Date()).createBy(Long.valueOf(-1L)).updateBy(Long.valueOf(-1L)).build();
        this.partnerInfoMapper.insert((Object)partnerInfo);
        return partnerInfo;
    }

    private Map<String, String> getLoginParam(String corpId) {
        TreeMap<String, String> result = new TreeMap<String, String>();
        result.put("corp_id", corpId);
        result.put("timestamp", String.valueOf(System.currentTimeMillis()));
        return result;
    }

    private Map<String, String> getCreateAccountParam(String corpId, String corpName) {
        TreeMap<String, String> result = new TreeMap<String, String>();
        result.put("corp_id", corpId);
        result.put("corp_name", corpName);
        result.put("timestamp", String.valueOf(System.currentTimeMillis()));
        return result;
    }

    private void trimMap(Map<String, String> params) {
        for (Map.Entry<String, String> entry : params.entrySet()) {
            if (entry.getValue() == null) continue;
            params.put(entry.getKey(), entry.getValue().trim());
        }
    }

    @Override
    public void setSign(Map<String, String> params) {
        this.trimMap(params);
        params.put("sign", this.getMd5Sign(params));
    }

    @Override
    public PartnerInfo getPartner(Long bizId) {
        return (PartnerInfo)this.partnerInfoMapper.selectOne((Object)PartnerInfo.builder().bizId(bizId).build());
    }

    @Override
    public JSONObject bjyPost(String url, Map<String, String> map, Map<String, String> header) {
        String result;
        log.info("bjyPost url:{},params:{}", (Object)(this.bjyUrl + url), map);
        Map<String, String> params = this.putTimestamp(map);
        this.setSign(params);
        try {
            result = HttpClientUtils.doPost((String)(this.bjyUrl + url), params, header, (String)"");
        }
        catch (Exception e) {
            log.error("bjy api post error", (Throwable)e);
            throw new BusinessException((UniverseErrorCode)CommonErrorCode.BUSINESS_ERROR, "\u8c03\u7528API\u5f02\u5e38");
        }
        JSONObject jsonObject = JSON.parseObject((String)result, (Feature[])new Feature[]{Feature.OrderedField});
        int code = jsonObject.getIntValue("code");
        String msg = jsonObject.getString("msg");
        log.info("bjyPost with header params:{} ,result:{}", params, (Object)result);
        switch (code) {
            case 0: {
                return jsonObject;
            }
            case 30004: {
                log.warn("bjyPost with header warn repeat");
                return jsonObject;
            }
        }
        log.error("bjyPost with header error,result:{}", (Object)result);
        throw new BusinessException((UniverseErrorCode)CommonErrorCode.BUSINESS_ERROR, msg);
    }

    @Override
    public JSONObject bjyPost(Long bizId, String url, Map<String, String> map) {
        String result;
        log.info("bjyPost url:{},params:{}", (Object)(this.bjyUrl + url), map);
        PartnerInfo partnerInfo = this.getBjyPartnerInfo(bizId);
        String partnerId = partnerInfo.getPartnerId();
        String corpId = partnerInfo.getCorpId();
        Map<String, String> bjyHeader = this.getBjyHeader(bizId, corpId);
        Map<String, String> params = this.putTimestamp(map);
        map.put("partner_id", partnerId);
        this.setSign(params);
        try {
            result = HttpClientUtils.doPost((String)(this.bjyUrl + url), params, bjyHeader, (String)"");
        }
        catch (Exception e) {
            log.error("bjy api post error", (Throwable)e);
            throw new BusinessException((UniverseErrorCode)CommonErrorCode.BUSINESS_ERROR, "\u8c03\u7528API\u5f02\u5e38");
        }
        JSONObject jsonObject = JSON.parseObject((String)result, (Feature[])new Feature[]{Feature.OrderedField});
        int code = jsonObject.getIntValue("code");
        String msg = jsonObject.getString("msg");
        log.info("bjyPost params:{} ,result:{}", params, (Object)result);
        switch (code) {
            case 0: {
                return jsonObject;
            }
            case 30004: {
                log.warn("bjyPost warn repeat");
                return jsonObject;
            }
            case 31002: {
                log.warn("bjyPost voice call phone limie");
                return jsonObject;
            }
            case 31003: {
                log.warn("bjyPost voice call speed limit");
                return jsonObject;
            }
            case 31004: {
                log.warn("bjyPost voice call text over length");
                return jsonObject;
            }
        }
        log.error("bjyPost error,result:{}", (Object)result);
        throw new BusinessException((UniverseErrorCode)CommonErrorCode.BUSINESS_ERROR, msg);
    }

    private String getMd5Sign(Map<String, String> params) {
        log.info("getMd5Sign params:{}", params);
        StringBuffer sb = new StringBuffer();
        sb.append(this.salt);
        sb.append(":");
        TreeMap<String, String> sorted = new TreeMap<String, String>();
        sorted.putAll(params);
        for (Map.Entry entry : sorted.entrySet()) {
            sb.append((String)entry.getValue());
            sb.append("$");
        }
        String sign = sb.toString();
        sign = sign.substring(0, sign.length() - 1);
        log.info("getMd5Sign sign before:{}", (Object)sign);
        sign = DigestUtils.md5DigestAsHex((byte[])sign.getBytes());
        log.info("getMd5Sign sign after:{}", (Object)sign);
        return sign;
    }

    private Map<String, String> putTimestamp(Map<String, String> map) {
        map.put("timestamp", String.valueOf(System.currentTimeMillis()));
        return map;
    }

    @Override
    public Map<String, String> getBjyHeader(Long bizId, String corpId) {
        if (ObjectUtils.isEmpty((Object)bizId) || StringUtils.isEmpty((CharSequence)corpId)) {
            return Maps.newHashMap();
        }
        HashMap<String, String> result = new HashMap<String, String>(1);
        result.put("Authorization", this.prefix + this.getBjyToken(bizId, corpId));
        return result;
    }

    @Override
    public String getCityByIp(String ip) {
        if (StringUtils.isBlank((CharSequence)ip)) {
            return null;
        }
        HashMap params = Maps.newHashMap();
        params.put("ips", ip);
        try {
            JSONArray jsonArr;
            JSONObject result = this.bjyGet(this.ipParserUrl, params);
            JSONObject data = result.getJSONObject("data");
            if (data != null && (jsonArr = data.getJSONArray(ip)) != null) {
                return jsonArr.getString(2);
            }
        }
        catch (Exception e) {
            log.error("get city by ip error: ", (Throwable)e);
        }
        return null;
    }

    @Override
    public JSONObject bjyPost(String partnerId, String url, Map<String, String> params) {
        String result;
        log.info("bjyPost partnerId: {}, url:{},params:{}", new Object[]{partnerId, this.bjyUrl + url, params});
        params = this.putTimestamp(params);
        params.put("partner_id", partnerId);
        this.setSign(params);
        try {
            result = HttpClientUtils.doPost((String)(this.bjyUrl + url), params, (Map)Maps.newHashMap(), (String)"");
        }
        catch (Exception e) {
            log.error("bjy api post error", (Throwable)e);
            throw new BusinessException((UniverseErrorCode)CommonErrorCode.BUSINESS_ERROR, "\u8c03\u7528API\u5f02\u5e38");
        }
        JSONObject jsonObject = JSON.parseObject((String)result, (Feature[])new Feature[]{Feature.OrderedField});
        int code = jsonObject.getIntValue("code");
        String msg = jsonObject.getString("msg");
        log.info("bjyPost params:{} ,result:{}", params, (Object)result);
        switch (code) {
            case 0: {
                return jsonObject;
            }
            case 30004: {
                log.warn("bjyPost warn repeat");
                return jsonObject;
            }
            case 31002: {
                log.warn("bjyPost voice call phone limie");
                return jsonObject;
            }
            case 31003: {
                log.warn("bjyPost voice call speed limit");
                return jsonObject;
            }
            case 31004: {
                log.warn("bjyPost voice call text over length");
                return jsonObject;
            }
        }
        log.error("bjyPost error,result:{}", (Object)result);
        throw new BusinessException((UniverseErrorCode)CommonErrorCode.BUSINESS_ERROR, msg);
    }

    private JSONObject bjyGet(String url, Map<String, String> map) {
        String result;
        Map<String, String> params = this.putTimestamp(map);
        this.setSign(params);
        log.info("bjyGet url:{},params:{}", (Object)(this.bjyUrl + url), params);
        try {
            result = HttpClientUtils.doGet((String)(this.bjyUrl + url), params, (String)"UTF-8");
        }
        catch (Exception e) {
            log.error("bjy api get error", (Throwable)e);
            throw new BusinessException((UniverseErrorCode)CommonErrorCode.BUSINESS_ERROR, "\u8c03\u7528API\u5f02\u5e38");
        }
        JSONObject jsonObject = JSON.parseObject((String)result, (Feature[])new Feature[]{Feature.OrderedField});
        int code = jsonObject.getIntValue("code");
        String msg = jsonObject.getString("msg");
        log.info("bjyGet params:{} ,result:{}", params, (Object)result);
        switch (code) {
            case 0: {
                return jsonObject;
            }
            case 30004: {
                log.warn("bjyGet warn repeat");
                return jsonObject;
            }
        }
        log.error("bjyGet error,result:{}", (Object)result);
        throw new BusinessException((UniverseErrorCode)CommonErrorCode.BUSINESS_ERROR, msg);
    }
}

